/* gnome-db-grid.h
 *
 * Copyright (C) 2002 - 2006 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNOME_DB_GRID__
#define __GNOME_DB_GRID__

#include <gtk/gtk.h>
#include <libgda/gda-decl.h>

G_BEGIN_DECLS

#define GNOME_DB_TYPE_GRID          (gnome_db_grid_get_type())
#define GNOME_DB_GRID(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_grid_get_type(), GnomeDbGrid)
#define GNOME_DB_GRID_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_grid_get_type (), GnomeDbGridClass)
#define GNOME_DB_IS_GRID(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_grid_get_type ())


typedef struct _GnomeDbGrid      GnomeDbGrid;
typedef struct _GnomeDbGridClass GnomeDbGridClass;
typedef struct _GnomeDbGridPriv  GnomeDbGridPriv;

/* struct for the object's data */
struct _GnomeDbGrid
{
	GtkVBox             object;

	GnomeDbGridPriv     *priv;
};

/* struct for the object's class */
struct _GnomeDbGridClass
{
	GtkVBoxClass       parent_class;
};

/* 
 * Generic widget's methods 
 */
GType             gnome_db_grid_get_type            (void) G_GNUC_CONST;

GtkWidget        *gnome_db_grid_new                 (GdaDataModel *model);
GList            *gnome_db_grid_get_selection       (GnomeDbGrid *grid);
void              gnome_db_grid_set_sample_size     (GnomeDbGrid *grid, gint sample_size);

G_END_DECLS

#endif



