#include <libgnomeuimm.h>
#include <iostream>

using SigC::slot;
using SigC::bind;

class MyApp : public Gnome::UI::App
{
  public:
    MyApp();
};

void foo(int i)
{
  std::cout << i << std::endl;
}

void foo2(Gtk::Widget *w)
{
  std::cout << w << std::endl;
}

MyApp::MyApp() : Gnome::UI::App("MyApp","MyApp")
{
  using namespace Gnome::UI;

  Items::Info radioitems[] =
  {
    Items::Item("Item1", SigC::bind(slot(&foo), 1)),
    Items::Item("Item2", SigC::bind(slot(&foo), 2)),
    Items::Item("Item3", SigC::bind(slot(&foo), 3)),
    Items::Item("Item4", SigC::bind(slot(&foo), 4))
  };

  Items::Info radioitems2[] =
  {
    Items::Item("Item1", SigC::slot(&foo2)),
    Items::Item("Item2", SigC::slot(&foo2))
  };

  Items::Info radio_menu[] =
  {
    Items::Item("Not Radio"),
    Items::Separator(),
    Items::RadioTree(radioitems),
    Items::Separator(),
    Items::RadioTree(radioitems2)
  };

  Items::SubTree menus[]=
  {
    Items::Menu("Items", radio_menu)
  };

  create_menus(menus);
  show();
}

int main (int argc, char* argv[])
{
  Gnome::Main kit("radio-info-demo", "0.0", Gnome::UI::module_info_get(), argc, argv);
  MyApp app;
  kit.run(app);
  return 0;
}


