/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gtk/gtk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.gtk.Clipboard
 * Method:    gtk_clipboard_get
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_Clipboard_gtk_1clipboard_1get (JNIEnv *env, jclass cls, 
    jobject selection) 
{
    GdkAtom selection_g = (GdkAtom)getPointerFromHandle(env, selection);
    return getHandleFromPointer(env, gtk_clipboard_get (selection_g));
}

/*
 * Class:     org.gnu.gtk.Clipboard
 * Method:    gtk_clipboard_get_display
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_Clipboard_gtk_1clipboard_1get_1display(JNIEnv *env, jclass cls, 
    jobject clipboard) 
{
	GtkClipboard* clipboard_g = (GtkClipboard*)getPointerFromHandle(env, clipboard);
    return getHandleFromPointer(env, gtk_clipboard_get_display(clipboard_g));
}

/*
 * Class:     org.gnu.gtk.Clipboard
 * Method:    gtk_clipboard_get_owner
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_Clipboard_gtk_1clipboard_1get_1owner (JNIEnv *env, 
    jclass cls, jobject clipboard) 
{
	GtkClipboard* clipboard_g = (GtkClipboard*)getPointerFromHandle(env, clipboard);
    return getHandleFromPointer(env, gtk_clipboard_get_owner (clipboard_g));
}

/*
 * Class:     org.gnu.gtk.Clipboard
 * Method:    gtk_clipboard_clear
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Clipboard_gtk_1clipboard_1clear (JNIEnv *env, jclass 
    cls, jobject clipboard) 
{
	GtkClipboard* clipboard_g = (GtkClipboard*)getPointerFromHandle(env, clipboard);
    gtk_clipboard_clear (clipboard_g);
}

/*
 * Class:     org.gnu.gtk.Clipboard
 * Method:    gtk_clipboard_set_text
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Clipboard_gtk_1clipboard_1set_1text (JNIEnv *env, 
    jclass cls, jobject clipboard, jstring text, jint len) 
{
	GtkClipboard* clipboard_g = (GtkClipboard*)getPointerFromHandle(env, clipboard);
    gint32 len_g = (gint32) len;
    const gchar* text_g = (*env)->GetStringUTFChars(env, text, NULL);
	gtk_clipboard_set_text (clipboard_g, text_g, len_g);
	(*env)->ReleaseStringUTFChars(env, text, text_g);
}

/*
 * Class:     org.gnu.gtk.Clipboard
 * Method:    gtk_clipboard_wait_for_text
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_Clipboard_gtk_1clipboard_1wait_1for_1text (JNIEnv 
    *env, jclass cls, jobject clipboard) 
{
	GtkClipboard* clipboard_g = (GtkClipboard*)getPointerFromHandle(env, clipboard);
	return (*env)->NewStringUTF(env,gtk_clipboard_wait_for_text (clipboard_g));
}

/*
 * Class:     org.gnu.gtk.Clipboard
 * Method:    gtk_clipboard_wait_is_text_available
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Clipboard_gtk_1clipboard_1wait_1is_1text_1available (
    JNIEnv *env, jclass cls, jobject clipboard) 
{
	GtkClipboard* clipboard_g = (GtkClipboard*)getPointerFromHandle(env, clipboard);
    return (jboolean) (gtk_clipboard_wait_is_text_available (clipboard_g));
}


#ifdef __cplusplus
}

#endif
