/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_tree_view_get_type();
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_new
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1new
  (JNIEnv *env, jclass cls)
{
 	return (jint)gtk_tree_view_new ();
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_new_with_model
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1new_1with_1model
  (JNIEnv *env, jclass cls, jint model)
{
	return (jint)gtk_tree_view_new_with_model((GtkTreeModel*)model);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_get_model
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1get_1model
  (JNIEnv *env, jclass cls, jint view)
{
	return (jint)gtk_tree_view_get_model((GtkTreeView*)view);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_set_model
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1set_1model
  (JNIEnv *env, jclass cls, jint view, jint model)
{
	gtk_tree_view_set_model((GtkTreeView*)view, (GtkTreeModel*)model);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_get_selection
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1get_1selection
  (JNIEnv *env, jclass cls, jint view)
{
	return (jint)gtk_tree_view_get_selection((GtkTreeView*)view);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_get_hadjustment
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1get_1hadjustment
  (JNIEnv *env, jclass cls, jint view)
{
	return (jint)gtk_tree_view_get_hadjustment((GtkTreeView*)view);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_set_hadjustment
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1set_1hadjustment
  (JNIEnv *env, jclass cls, jint view, jint adj)
{
	gtk_tree_view_set_hadjustment((GtkTreeView*)view, (GtkAdjustment*)adj);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_get_vadjustment
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1get_1vadjustment
  (JNIEnv *env, jclass cls, jint view)
{
	return (jint)gtk_tree_view_get_vadjustment((GtkTreeView*)view);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_set_vadjustment
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1set_1vadjustment
  (JNIEnv *env, jclass cls, jint view, jint adj)
{
	gtk_tree_view_set_vadjustment((GtkTreeView*)view, (GtkAdjustment*)adj);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_get_headers_visible
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1get_1headers_1visible
  (JNIEnv *env, jclass cls, jint view)
{
	return (jboolean)gtk_tree_view_get_headers_visible((GtkTreeView*)view);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_set_headers_visible
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1set_1headers_1visible
  (JNIEnv *env, jclass cls, jint view, jboolean vis)
{
	gtk_tree_view_set_headers_visible((GtkTreeView*)view, (gboolean)vis);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_columns_autosize
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1columns_1autosize
  (JNIEnv *env, jclass cls, jint view)
{
	gtk_tree_view_columns_autosize((GtkTreeView*)view);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_set_headers_clickable
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1set_1headers_1clickable
  (JNIEnv *env, jclass cls, jint view, jboolean value)
{
	gtk_tree_view_set_headers_clickable((GtkTreeView*)view, (gboolean)value);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_set_rules_hint
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1set_1rules_1hint
  (JNIEnv *env, jclass cls, jint view, jboolean value)
{
	gtk_tree_view_set_rules_hint((GtkTreeView*)view, (gboolean)value);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_get_rules_hint
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1get_1rules_1hint
  (JNIEnv *env, jclass cls, jint view)
{
	return (jboolean)gtk_tree_view_get_rules_hint((GtkTreeView*)view);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_append_column
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1append_1column
  (JNIEnv *env, jclass cls, jint view, jint column)
{
	return (jint)gtk_tree_view_append_column((GtkTreeView*)view, (GtkTreeViewColumn*)column);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_remove_column
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1remove_1column
  (JNIEnv *env, jclass cls, jint view, jint column)
{
	return (jint)gtk_tree_view_remove_column((GtkTreeView*)view, (GtkTreeViewColumn*)column);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_insert_column
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1insert_1column
  (JNIEnv *env, jclass cls, jint view, jint column, jint pos)
{
	return (jint)gtk_tree_view_insert_column((GtkTreeView*)view, (GtkTreeViewColumn*)column, (gint)pos);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_get_column
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1get_1column
  (JNIEnv *env, jclass cls, jint view, jint pos)
{
	return (jint)gtk_tree_view_get_column((GtkTreeView*)view, (gint)pos);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_get_columns
 * Signature: (I)[I
 */
JNIEXPORT jintArray JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1get_1columns
  (JNIEnv *env, jclass cls, jint view)
{
	GList *list = gtk_tree_view_get_columns((GtkTreeView*)view);
	guint len;
	jintArray ar;
	int i = 0;
 	if (NULL == list)
		return NULL;
	len = g_list_length(list);
	ar = (*env)->NewIntArray(env, len);
	for (i = 0; i < len; i++) {
		GList *item = g_list_nth(list, i);
		(*env)->SetIntArrayRegion(env, ar, i, 1, (jint*)item->data);
	}
	return ar;
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_move_column_after
 * Signature: (III)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1move_1column_1after
  (JNIEnv *env, jclass cls, jint view, jint column, jint baseColumn)
{
	gtk_tree_view_move_column_after((GtkTreeView*)view, (GtkTreeViewColumn*)column, (GtkTreeViewColumn*)baseColumn);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_set_expander_column
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1set_1expander_1column
  (JNIEnv *env, jclass cls, jint view, jint column)
{
	gtk_tree_view_set_expander_column((GtkTreeView*)view, (GtkTreeViewColumn*)column);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_get_expander_column
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1get_1expander_1column
  (JNIEnv *env, jclass cls, jint view)
{
	return (jint)gtk_tree_view_get_expander_column((GtkTreeView*)view);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_scroll_to_point
 * Signature: (III)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1scroll_1to_1point
  (JNIEnv *env, jclass cls, jint view, jint x, jint y)
{
	gtk_tree_view_scroll_to_point((GtkTreeView*)view, (gint)x, (gint)y);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_scroll_to_cell
 * Signature: (IIIZDD)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1scroll_1to_1cell
  (JNIEnv *env, jclass cls, jint view, jint path, jint column, jboolean align, jdouble row, jdouble col)
{
	gtk_tree_view_scroll_to_cell((GtkTreeView*)view, (GtkTreePath*)path, (GtkTreeViewColumn*)column,
			(gboolean)align, (gfloat)row, (gfloat)col);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_row_activated
 * Signature: (III)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1row_1activated
  (JNIEnv *env, jclass cls, jint view, jint path, jint column)
{
	gtk_tree_view_row_activated((GtkTreeView*)view, (GtkTreePath*)path, (GtkTreeViewColumn*)column);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_expand_all
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1expand_1all
  (JNIEnv *env, jclass cls, jint view)
{
	gtk_tree_view_expand_all((GtkTreeView*)view);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_collapse_all
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1collapse_1all
  (JNIEnv *env, jclass cls, jint view)
{
	gtk_tree_view_collapse_all((GtkTreeView*)view);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_expand_row
 * Signature: (IIZ)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1expand_1row
  (JNIEnv *env, jclass cls, jint view, jint path, jboolean all)
{
	return (jboolean)gtk_tree_view_expand_row((GtkTreeView*)view, (GtkTreePath*)path, (gboolean)all);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_collapse_row
 * Signature: (II)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1collapse_1row
  (JNIEnv *env, jclass cls, jint view, jint path)
{
	return (jboolean)gtk_tree_view_collapse_row((GtkTreeView*)view, (GtkTreePath*)path);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_row_expanded
 * Signature: (II)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1row_1expanded
  (JNIEnv *env, jclass cls, jint view, jint path)
{
	return (jboolean)gtk_tree_view_row_expanded((GtkTreeView*)view, (GtkTreePath*)path);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_set_reorderable
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1set_1reorderable
  (JNIEnv *env, jclass cls, jint view, jboolean value)
{
	gtk_tree_view_set_reorderable((GtkTreeView*)view, (gboolean)value);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_get_reorderable
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1get_1reorderable
  (JNIEnv *env, jclass cls, jint view)
{
	return (jboolean)gtk_tree_view_get_reorderable((GtkTreeView*)view);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_set_cursor
 * Signature: (IIIZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1set_1cursor
  (JNIEnv *env, jclass cls, jint view, jint path, jint column, jboolean startEdit)
{
	gtk_tree_view_set_cursor((GtkTreeView*)view, (GtkTreePath*)path, (GtkTreeViewColumn*)column, (gboolean)startEdit);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_set_cursor_on_cell
 * Signature: (IIIIZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1set_1cursor_1on_1cell
  (JNIEnv *env, jclass cls, jint view, jint path, jint column, jint cell, jboolean startEdit)
{
	gtk_tree_view_set_cursor_on_cell((GtkTreeView*)view, (GtkTreePath*)path, (GtkTreeViewColumn*)column, (GtkCellRenderer*)cell, (gboolean)startEdit);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_get_cursor
 * Signature: (I[I[I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1get_1cursor
  (JNIEnv *env, jclass cls, jint view, jintArray path, jintArray column)
{
	GtkTreeViewColumn* col;
	GtkTreePath* pat;

	col = (GtkTreeViewColumn*)(*env)->GetIntArrayElements(env, column, NULL);
	pat = (GtkTreePath*)(*env)->GetIntArrayElements(env, path, NULL);
	gtk_tree_view_get_cursor((GtkTreeView*)view, &pat, &col);
	(*env)->ReleaseIntArrayElements(env, column, (jint*)col, 0);
	(*env)->ReleaseIntArrayElements(env, path, (jint*)pat, 0);
}
                                                                          
///*
// * Class:     org_gnu_gtk_TreeView
// * Method:    gtk_tree_view_get_bin_window
// * Signature: (I)I
// */
//JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1get_1bin_1window
//  (JNIEnv *env, jclass cls, jint view)
//{
//	return (jint)gtk_tree_view_get_bin_window((GtkTreeView*)view);
//}
//                                                                          
///*
// * Class:     org_gnu_gtk_TreeView
// * Method:    gtk_tree_view_get_path_at_pos
// * Signature: (III[I[I[I[I)Z
// */
//JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1get_1path_1at_1pos
//  (JNIEnv *env, jclass cls, jint view, jint x, jint y, jintArray path, jintArray column, jintArray cellX, jintArray cellY)
//{
//	GtkTreeViewColumn* col;
//	GtkTreePath* pat;
//	gint* cx;
//	gint* cy;
//	jboolean val;
//
//	col = (GtkTreeViewColumn*)(*env)->GetIntArrayElements(env, column, NULL);
//	pat = (GtkTreePath*)(*env)->GetIntArrayElements(env, path, NULL);
//	cx = (gint*)(*env)->GetIntArrayElements(env, cellX, NULL);
//	cy = (gint*)(*env)->GetIntArrayElements(env, cellY, NULL);
//	val = gtk_tree_view_get_path_at_pos((GtkTreeView*)view, (gint)x, (gint)y, &pat, &col, cx, cy);
//	(*env)->ReleaseIntArrayElements(env, column, (jint*)col, 0);
//	(*env)->ReleaseIntArrayElements(env, path, (jint*)pat, 0);
//	(*env)->ReleaseIntArrayElements(env, cellX, (jint*)cx, 0);
//	(*env)->ReleaseIntArrayElements(env, cellY, (jint*)cy, 0);
//	return val;
//}
//                                                                          
///*
// * Class:     org_gnu_gtk_TreeView
// * Method:    gtk_tree_view_get_cell_area
// * Signature: (III)I
// */
//JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1get_1cell_1area
//  (JNIEnv *env, jclass cls, jint view, jint path, jint column)
//{
//	GdkRectangle* rect = (GdkRectangle*)g_malloc(sizeof(GdkRectangle));
//	gtk_tree_view_get_cell_area((GtkTreeView*)view, (GtkTreePath*)path, (GtkTreeViewColumn*)column, rect);
//	return (jint)rect;
//}
//                                                                             
///*
// * Class:     org_gnu_gtk_TreeView
// * Method:    gtk_tree_view_get_background_area
// * Signature: (III)I
// */
//JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1get_1background_1area
//  (JNIEnv *env, jclass cls, jint view, jint path, jint column)
//{
//	GdkRectangle* rect = (GdkRectangle*)g_malloc(sizeof(GdkRectangle));
//	gtk_tree_view_get_background_area((GtkTreeView*)view, (GtkTreePath*)path, (GtkTreeViewColumn*)column, rect);
//	return (jint)rect;
//}
//                                                                             
///*
// * Class:     org_gnu_gtk_TreeView
// * Method:    gtk_tree_view_get_visible_rect
// * Signature: (I)I
// */
//JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1get_1visible_1rect
//  (JNIEnv *env, jclass cls, jint view)
//{
//	GdkRectangle* rect = (GdkRectangle*)g_malloc(sizeof(GdkRectangle));
//	gtk_tree_view_get_visible_rect((GtkTreeView*)view, rect);
//	return (jint)rect;
//}
//                                                                             
///*
// * Class:     org_gnu_gtk_TreeView
// * Method:    gtk_tree_view_widget_to_tree_coords
// * Signature: (III[I[I)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1widget_1to_1tree_1coords
//  (JNIEnv *env, jclass cls, jint view, jint wx, jint wy, jintArray treeX, jintArray treeY)
//{
//	gint* tx = (gint*)(*env)->GetIntArrayElements(env, treeX, NULL);
//	gint* ty = (gint*)(*env)->GetIntArrayElements(env, treeY, NULL);
//	gtk_tree_view_widget_to_tree_coords((GtkTreeView*)view, (gint)wx, (gint)wy, tx, ty);
//	(*env)->ReleaseIntArrayElements(env, treeX, (jint*)tx, 0);
//	(*env)->ReleaseIntArrayElements(env, treeY, (jint*)ty, 0);
//}
//                                                                          
///*
// * Class:     org_gnu_gtk_TreeView
// * Method:    gtk_tree_view_tree_to_widget_coords
// * Signature: (III[I[I)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1tree_1to_1widget_1coords
//  (JNIEnv *env, jclass cls, jint view, jint tx, jint ty, jintArray winX, jintArray winY)
//{
//	gint* wx = (gint*)(*env)->GetIntArrayElements(env, winX, NULL);
//	gint* wy = (gint*)(*env)->GetIntArrayElements(env, winY, NULL);
//	gtk_tree_view_tree_to_widget_coords((GtkTreeView*)view, (gint)tx, (gint)ty, wx, wy);
//	(*env)->ReleaseIntArrayElements(env, winX, (jint*)wx, 0);
//	(*env)->ReleaseIntArrayElements(env, winY, (jint*)wy, 0);
//}
//                                                                          
///*
// * Class:     org_gnu_gtk_TreeView
// * Method:    gtk_tree_view_enable_model_drag_source
// * Signature: (II[II)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1enable_1model_1drag_1source
//  (JNIEnv *env, jclass cls, jint view, jint mask, jintArray targets, jint action)
//{
//	GtkTargetEntry** entries;
//	jint* targs;
//	jsize len;
//	int index;
//
//	len = (*env)->GetArrayLength(env, targets);
//	entries = g_malloc(sizeof(GtkTargetEntry*)*len);
//	targs = (*env)->GetIntArrayElements(env, targets, NULL);
//	for (index = 0; index < len; index++)
//		entries[index] = (GtkTargetEntry*)targs[index];
//	gtk_tree_view_enable_model_drag_source((GtkTreeView*)view, (GdkModifierType)mask, entries[0], len, (GdkDragAction)action);
//}
//                                                                          
///*
// * Class:     org_gnu_gtk_TreeView
// * Method:    gtk_tree_view_enable_model_drag_dest
// * Signature: (I[II)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1enable_1model_1drag_1dest
//  (JNIEnv *env, jclass cls, jint view, jintArray targets, jint action)
//{
//	jsize len = (*env)->GetArrayLength(env, targets);
//	jint* targs;
//	int index;
//	GtkTargetEntry** entries = g_malloc(sizeof(GtkTargetEntry*)*len);
//		
//	targs = (*env)->GetIntArrayElements(env, targets, NULL);
//	for (index = 0; index < len; index++)
//		entries[index] = (GtkTargetEntry*)targs[index];
//	gtk_tree_view_enable_model_drag_dest((GtkTreeView*)view, entries[0], len, (GdkDragAction)action);
//}
//                                                                          
///*
// * Class:     org_gnu_gtk_TreeView
// * Method:    gtk_tree_view_unset_rows_drag_source
// * Signature: (I)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1unset_1rows_1drag_1source
//  (JNIEnv *env, jclass cls, jint view)
//{
//	gtk_tree_view_unset_rows_drag_source((GtkTreeView*)view);
//}
//                                                                          
///*
// * Class:     org_gnu_gtk_TreeView
// * Method:    gtk_tree_view_unset_rows_drag_dest
// * Signature: (I)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1unset_1rows_1drag_1dest
//  (JNIEnv *env, jclass cls, jint view)
//{
//	gtk_tree_view_unset_rows_drag_dest((GtkTreeView*)view);
//}
//                                                                          
///*
// * Class:     org_gnu_gtk_TreeView
// * Method:    gtk_tree_view_create_row_drag_icon
// * Signature: (II)I
// */
//JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1create_1row_1drag_1icon
//  (JNIEnv *env, jclass cls, jint view, jint path)
//{
//	return (jint)gtk_tree_view_create_row_drag_icon((GtkTreeView*)view, (GtkTreePath*)path);
//}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_set_enable_search
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1set_1enable_1search
  (JNIEnv *env, jclass cls, jint view, jboolean enable)
{
	gtk_tree_view_set_enable_search((GtkTreeView*)view, (gboolean)enable);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_get_enable_search
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1get_1enable_1search
  (JNIEnv *env, jclass cls, jint view)
{
	return (jboolean)gtk_tree_view_get_enable_search((GtkTreeView*)view);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_get_search_column
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1get_1search_1column
  (JNIEnv *env, jclass cls, jint view)
{
	return (jint)gtk_tree_view_get_search_column((GtkTreeView*)view);
}
                                                                          
/*
 * Class:     org_gnu_gtk_TreeView
 * Method:    gtk_tree_view_set_search_column
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeView_gtk_1tree_1view_1set_1search_1column
  (JNIEnv *env, jclass cls, jint view, jint column)
{
	gtk_tree_view_set_search_column((GtkTreeView*)view, (gint)column);
}
                                                                             
#ifdef __cplusplus
}

#endif
