/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.GObject;
import org.gnu.glib.Type;

/**
 * The ColorSelectionDialog provides a standard dialog which allows the
 * user to select a color much like the {@link FileSelection} 
 * provides a standard dialog for file selection.
 */
public class ColorSelectionDialog extends Dialog {
	/**
	 * Construct a new ColorSelectionDialog.
	 * 
	 * @param title The text to display on the title bar of the dialog.
	 */
	public ColorSelectionDialog(String title) {
		super(ColorSelectionDialog.gtk_color_selection_dialog_new(title));
	}
	
	/**
	 * Construct a ColorSelectionDialog using a handle to a 
	 * native resource.
	 */
	public ColorSelectionDialog(int handle) {
	    super(handle);
	}

	/**
	 * Return the OK Button widget for this Dialog.
	 * 
	 * @return The OK Button.
	 */
	public Button getOKButton() {
		int hndl = ColorSelectionDialog.getOkButton(getHandle());
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Button)obj;
		return new Button(hndl);
	}
	
	/**
	 * Return the Cancel Button widget for this dialog.
	 * 
	 * @return The Cancel Button.
	 */
	public Button getCancelButton() {
		int hndl = ColorSelectionDialog.getCancelButton(getHandle());
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Button)obj;
		return new Button(hndl);
	}
	
	/**
	 * Return the Help Button widget for this dialog.
	 * 
	 * @return The Help Button.
	 */
	public Button getHelpButton() {
		int hndl = ColorSelectionDialog.getHelpButton(getHandle());
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Button)obj;
		return new Button(hndl);
	}
	
	/**
	 * Return the ColorSelection widget for this dialog.
	 * 
	 * @return The ColorSelection widget.
	 */
	public ColorSelection getColorSelectionWidget() {
		int hndl = ColorSelectionDialog.getColorsel(getHandle());
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (ColorSelection)obj;
		return new ColorSelection(hndl);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_color_selection_dialog_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getColorsel (int cptr);
    native static final protected int getOkButton (int cptr);
    native static final protected int getCancelButton (int cptr);
    native static final protected int getHelpButton (int cptr);
    native static final protected int gtk_color_selection_dialog_get_type ();
    native static final protected int gtk_color_selection_dialog_new (String title);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

