/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_input_set_extension_events
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1input_1set_1extension_1events (JNIEnv *env, 
    jclass cls, jobject window, jint mask, jint mode) 
{
    GdkWindow *window_g = (GdkWindow *)getPointerFromHandle(env, window);
    gint32 mask_g = (gint32) mask;
    GdkExtensionMode mode_g = (GdkExtensionMode) mode;
    gdk_input_set_extension_events (window_g, mask_g, mode_g);
}


/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_flush
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1flush (JNIEnv *env, jclass cls) 
{
    gdk_flush ();
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_set_locale
 * Signature: ()java.lang.String
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gdk_Gdk_gdk_1set_1locale (JNIEnv *env, jclass cls) 
{
    gchar *result_g = gdk_set_locale ();
    return (*env)->NewStringUTF(env, result_g);
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_screen_width
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Gdk_gdk_1screen_1width (JNIEnv *env, jclass cls) 
{
    jint result_j = (jint) (gdk_screen_width ());
    return result_j;
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_screen_height
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Gdk_gdk_1screen_1height (JNIEnv *env, jclass cls) 
{
    {
        jint result_j = (jint) (gdk_screen_height ());
        return result_j;
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_screen_width_mm
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Gdk_gdk_1screen_1width_1mm (JNIEnv *env, jclass cls) 
{
    {
        jint result_j = (jint) (gdk_screen_width_mm ());
        return result_j;
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_screen_height_mm
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Gdk_gdk_1screen_1height_1mm (JNIEnv *env, jclass cls) 
{
    {
        jint result_j = (jint) (gdk_screen_height_mm ());
        return result_j;
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_beep
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1beep (JNIEnv *env, jclass cls) 
{
    {
        gdk_beep ();
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_set_show_events
 * Signature: (Z)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1set_1show_1events (JNIEnv *env, jclass cls, 
    jboolean showEvents) 
{
    gboolean showEvents_g = (gboolean) showEvents;
    {
        gdk_set_show_events (showEvents_g);
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_get_show_events
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Gdk_gdk_1get_1show_1events (JNIEnv *env, jclass cls)
{
    {
        jboolean result_j = (jboolean) (gdk_get_show_events ());
        return result_j;
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_keyval_name
 * Signature: (I)java.lang.String
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gdk_Gdk_gdk_1keyval_1name (JNIEnv *env, jclass cls, 
    jint keyval) 
{
    gchar *result_g = gdk_keyval_name ((gint32)keyval);
    return (*env)->NewStringUTF(env, result_g);
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_keyval_from_name
 * Signature: (java.lang.String)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Gdk_gdk_1keyval_1from_1name (JNIEnv *env, jclass cls, 
    jstring keyvalName) 
{
    const gchar* keyvalName_g = (*env)->GetStringUTFChars(env, keyvalName, 0);
    jint result_j = (jint) (gdk_keyval_from_name (keyvalName_g));
    (*env)->ReleaseStringUTFChars(env, keyvalName, keyvalName_g);
    return result_j;
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_keyval_to_upper
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Gdk_gdk_1keyval_1to_1upper (JNIEnv *env, jclass cls, 
    jint keyval) 
{
    gint32 keyval_g = (gint32) keyval;
    {
        jint result_j = (jint) (gdk_keyval_to_upper (keyval_g));
        return result_j;
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_keyval_to_lower
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Gdk_gdk_1keyval_1to_1lower (JNIEnv *env, jclass cls, 
    jint keyval) 
{
    gint32 keyval_g = (gint32) keyval;
    {
        jint result_j = (jint) (gdk_keyval_to_lower (keyval_g));
        return result_j;
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_keyval_is_upper
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Gdk_gdk_1keyval_1is_1upper (JNIEnv *env, jclass 
    cls, jint keyval) 
{
    gint32 keyval_g = (gint32) keyval;
    {
        jboolean result_j = (jboolean) (gdk_keyval_is_upper (keyval_g));
        return result_j;
    }
}

/*
 * Class:     org.gnu.gdk.Gdk
 * Method:    gdk_keyval_is_lower
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Gdk_gdk_1keyval_1is_1lower (JNIEnv *env, jclass 
    cls, jint keyval) 
{
    gint32 keyval_g = (gint32) keyval;
    {
        jboolean result_j = (jboolean) (gdk_keyval_is_lower (keyval_g));
        return result_j;
    }
}


JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1init
(JNIEnv *env, jclass cls, jintArray argc, jobjectArray argv)
{
    gint *argc_g = (gint *) (*env)->GetIntArrayElements (env, argc, NULL);
    gchar **argv_g_arr = getStringArray(env, argv);
    gchar ***argv_g = &argv_g_arr;
    gdk_init(argc_g, argv_g);
    (*env)->ReleaseIntArrayElements (env, argc, (jint *) argc_g, 0);
    freeStringArray(env, argv, argv_g_arr);
}

JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Gdk_gdk_1init_1check
(JNIEnv *env, jclass cls, jintArray argc, jobjectArray argv)
{
    gint *argc_g = (gint *) (*env)->GetIntArrayElements (env, argc, NULL);
    gchar **argv_g_arr = getStringArray(env, argv);
    gchar ***argv_g = &argv_g_arr;
    jboolean ret = gdk_init_check(argc_g, argv_g);
    (*env)->ReleaseIntArrayElements (env, argc, (jint *) argc_g, 0);
    freeStringArray(env, argv, argv_g_arr);
    return ret;
}

JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1parse_1args
(JNIEnv *env, jclass cls, jintArray argc, gchar*** argv)
{
    gint *argc_g = (gint *) (*env)->GetIntArrayElements (env, argc, NULL);
    gchar **argv_g_arr = getStringArray(env, argv);
    gchar ***argv_g = &argv_g_arr;
    gdk_parse_args(argc_g, argv_g);
    (*env)->ReleaseIntArrayElements (env, argc, (jint *) argc_g, 0);
    freeStringArray(env, argv, argv_g_arr);
}

JNIEXPORT jstring JNICALL Java_org_gnu_gdk_Gdk_gdk_1get_1program_1class
(JNIEnv *env, jclass cls)
{
    return (*env)->NewStringUTF(env, gdk_get_program_class());
}

JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1set_1program_1class
(JNIEnv *env, jclass cls, jstring program_class)
{
    const char * program_class_g = (const char *)(*env)->GetStringUTFChars(env, program_class, 0);
    gdk_set_program_class(program_class_g);
    (*env)->ReleaseStringUTFChars(env, program_class, program_class_g);
}

JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1error_1trap_1push
(JNIEnv *env, jclass cls)
{
    gdk_error_trap_push();
}

JNIEXPORT jint JNICALL Java_org_gnu_gdk_Gdk_gdk_1error_1trap_1pop
(JNIEnv *env, jclass cls)
{
    return (jint)gdk_error_trap_pop();
}

JNIEXPORT jstring JNICALL Java_org_gnu_gdk_Gdk_gdk_1get_1display_1arg_1name
(JNIEnv *env, jclass cls)
{
    return (*env)->NewStringUTF(env, gdk_get_display_arg_name());
}

JNIEXPORT jstring JNICALL Java_org_gnu_gdk_Gdk_gdk_1get_1display
(JNIEnv *env, jclass cls)
{
    return (*env)->NewStringUTF(env, gdk_get_display());
}

JNIEXPORT jint JNICALL Java_org_gnu_gdk_Gdk_gdk_1pointer_1grab
(JNIEnv *env, jclass cls, jobject window, jboolean owner_events, jint event_mask, jobject confine_to, jobject cursor, jint time_)
{
    GdkWindow * window_g = (GdkWindow *)getPointerFromHandle(env, window);
    gboolean owner_events_g = (gboolean)owner_events;
    GdkEventMask event_mask_g = (GdkEventMask)event_mask;
    GdkWindow * confine_to_g = (GdkWindow *)getPointerFromHandle(env, confine_to);
    GdkCursor * cursor_g = (GdkCursor *)getPointerFromHandle(env, cursor);
    guint32 time__g = (guint32)time_;
    return (jint)gdk_pointer_grab(window_g, owner_events_g, event_mask_g, confine_to_g, cursor_g, time__g);
}

JNIEXPORT jint JNICALL Java_org_gnu_gdk_Gdk_gdk_1keyboard_1grab
(JNIEnv *env, jclass cls, jobject window, jboolean owner_events, jint time_)
{
    GdkWindow * window_g = (GdkWindow *)getPointerFromHandle(env, window);
    gboolean owner_events_g = (gboolean)owner_events;
    guint32 time__g = (guint32)time_;
    return (jint)gdk_keyboard_grab(window_g, owner_events_g, time__g);
}

JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1pointer_1ungrab
(JNIEnv *env, jclass cls, jint time_)
{
    guint32 time__g = (guint32)time_;
    gdk_pointer_ungrab(time__g);
}

JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1keyboard_1ungrab
(JNIEnv *env, jclass cls, jint time_)
{
    guint32 time__g = (guint32)time_;
    gdk_keyboard_ungrab(time__g);
}

JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Gdk_gdk_1pointer_1is_1grabbed
(JNIEnv *env, jclass cls)
{
    return (jboolean)gdk_pointer_is_grabbed();
}

JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1set_1double_1click_1time
(JNIEnv *env, jclass cls, jint msec)
{
    guint msec_g = (guint)msec;
    gdk_set_double_click_time(msec_g);
}

JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Gdk_gdk_1rectangle_1intersect
(JNIEnv *env, jclass cls, jobject src1, jobject src2, jobject dest)
{
    GdkRectangle * src1_g = (GdkRectangle *)getPointerFromHandle(env, src1);
    GdkRectangle * src2_g = (GdkRectangle *)getPointerFromHandle(env, src2);
    GdkRectangle * dest_g = (GdkRectangle *)getPointerFromHandle(env, dest);
    return (jboolean)gdk_rectangle_intersect(src1_g, src2_g, dest_g);
}

JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1rectangle_1union
(JNIEnv *env, jclass cls, jobject src1, jobject src2, jobject dest)
{
    GdkRectangle * src1_g = (GdkRectangle *)getPointerFromHandle(env, src1);
    GdkRectangle * src2_g = (GdkRectangle *)getPointerFromHandle(env, src2);
    GdkRectangle * dest_g = (GdkRectangle *)getPointerFromHandle(env, dest);
    gdk_rectangle_union(src1_g, src2_g, dest_g);
}

JNIEXPORT jint JNICALL Java_org_gnu_gdk_Gdk_gdk_1rectangle_1get_1type
(JNIEnv *env, jclass cls)
{
    return (jint)gdk_rectangle_get_type();
}

JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Gdk_gdk_1event_1send_1client_1message
(JNIEnv *env, jclass cls, jobject event, jint winid)
{
    GdkEvent * event_g = (GdkEvent *)getPointerFromHandle(env, event);
    GdkNativeWindow winid_g = (GdkNativeWindow)winid;
    return (jboolean)gdk_event_send_client_message(event_g, winid_g);
}

JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1event_1send_1clientmessage_1toall
(JNIEnv *env, jclass cls, jobject event)
{
    GdkEvent * event_g = (GdkEvent *)getPointerFromHandle(env, event);
    gdk_event_send_clientmessage_toall(event_g);
}

JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Gdk_gdk_1event_1send_1client_1message_1for_1display
(JNIEnv *env, jclass cls, jobject display, jobject event, jint winid)
{
    GdkDisplay * display_g = (GdkDisplay *)getPointerFromHandle(env, display);
    GdkEvent * event_g = (GdkEvent *)getPointerFromHandle(env, event);
    GdkNativeWindow winid_g = (GdkNativeWindow)winid;
    return (jboolean)gdk_event_send_client_message_for_display(display_g, event_g, winid_g);
}

JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1notify_1startup_1complete
(JNIEnv *env, jclass cls)
{
    gdk_notify_startup_complete();
}

JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1threads_1enter
(JNIEnv *env, jclass cls)
{
    gdk_threads_enter();
}

JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1threads_1leave
(JNIEnv *env, jclass cls)
{
    gdk_threads_leave();
}

JNIEXPORT void JNICALL Java_org_gnu_gdk_Gdk_gdk_1threads_1init
(JNIEnv *env, jclass cls)
{
    gdk_threads_init();
}

#ifdef __cplusplus
}

#endif
