
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <libvtemm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "terminal.h"
#include "charattributes.h"
#include "terminalaccessible.h"
#include "reaper.h"

extern "C"
{

//Declarations of the *_get_type() functions:

#ifndef LIBVTEMM_DISABLE_DEPRECATED
GType vte_reaper_get_type(void);
#endif // *_DISABLE_DEPRECATED
GType vte_terminal_get_type(void);
GType vte_terminal_accessible_get_type(void);

//Declarations of the *_error_quark() functions:

} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

#ifndef LIBVTEMM_DISABLE_DEPRECATED
namespace Gnome { namespace Vte {  class Reaper_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
#endif // *_DISABLE_DEPRECATED
namespace Gnome { namespace Vte {  class Terminal_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Vte {  class TerminalAccessible_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }

namespace Gnome { namespace Vte { 

void wrap_init()
{
  // Register Error domains:

// Map gtypes to gtkmm wrapper-creation functions:
#ifndef LIBVTEMM_DISABLE_DEPRECATED
  Glib::wrap_register(vte_reaper_get_type(), &Gnome::Vte::Reaper_Class::wrap_new);
#endif // *_DISABLE_DEPRECATED
  Glib::wrap_register(vte_terminal_get_type(), &Gnome::Vte::Terminal_Class::wrap_new);
  Glib::wrap_register(vte_terminal_accessible_get_type(), &Gnome::Vte::TerminalAccessible_Class::wrap_new);

  // Register the gtkmm gtypes:
#ifndef LIBVTEMM_DISABLE_DEPRECATED
  Gnome::Vte::Reaper::get_type();
#endif // *_DISABLE_DEPRECATED
  Gnome::Vte::Terminal::get_type();
  Gnome::Vte::TerminalAccessible::get_type();

} // wrap_init()

} //Vte
} //Gnome


