/* utility.h
 * Copyright (C) 2003 Vivien Malerba <malerba@gnome-db.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include "mg-work-core.h"
#include "mg-context.h"
#include "mg-data-entry.h"


/*
 *
 * Data Entry utilities
 *
 */
GtkWidget*              utility_entry_build_actions_menu      (GObject *obj_data, guint attrs, GCallback function);
GdkColor **             utility_entry_build_info_colors_array (void);



/*
 *
 * Combo utilities
 *
 */

typedef struct _ComboCore ComboCore;
typedef struct _ComboNode ComboNode;

struct _ComboNode {
	MgParameter  *param;
	GdaValue     *value;    /* we don't own the value, since it belongs to a GdaDataModel => don't free it */
	gint          position; /* pos. in ComboCore's resultset */
	GdaValue     *value_orig;
	GdaValue     *value_default;
};

struct _ComboCore {
	MgConf             *conf;

	MgContext          *context;
	GSList             *nodes; /* ComboNode structures */
	MgQuery            *query;
	gint                nb_visible_cols; /* query's number of visible columns */

	gint               *mask; 
	gint                masksize;

	GCallback           dependency_param_callback;
	gpointer            dependency_data;

	MgResultSet        *resultset;
	GdaDataModel       *data_model;
	gboolean            data_model_valid;	
};

#define COMBO_NODE(x) ((ComboNode *) (x))
#define COMBO_CORE(x) ((ComboCore *)(x))

ComboCore            *utility_combo_initialize_core (MgConf *conf, MgContext *context, MgContextNode *node, 
						     GCallback dependency_param_callback, gpointer data);
void                  utility_combo_free_core (ComboCore *core);
void                  utility_combo_compute_model (ComboCore *core);
void                  utility_combo_destroy_model (ComboCore *core);
gchar                *utility_combo_compute_display_string (ComboCore *core, GList *values);
GList                *utility_combo_compute_choice_strings (ComboCore *core);


/*
 *
 * MgWorkGrid and renderers utilities
 *
 * The following structure is used by the MgWorkGrid data's model which is a 2 columns data model:
 * --> 1 column which refers to the row number to be displayed at the selected row (or -1 for a new row)
 * --> 1 column which holds the changes the user has made to the model; the original data
 *     is not modified. This column is a ModelUserModifiedRow structure (all
 *     the data in each of these structures is allocated on demand, and managed in priv->modified_rows).
 *
 * The ModelUserModifiedValue's value field can be a GdaValue of type GDA_VALUE_TYPE_LIST, for multiple parameters
 * nodes, and in which case there are more than the PK fields of the query: all the fields of context_node->query
 * have their value listed there.
 *
 * No data is allocated within the data model itself.
 */

enum {
	COLUMN_ROW_NUM,
	COLUMN_USER_MODIFS_ROW
};

typedef struct {
	gboolean       to_be_deleted;
	GSList        *pkey;        /* list of GdaValue to identify  the row */
	GSList        *user_values; /* list of ModelUserModifiedValue */
} ModelUserModifiedRow;
#define MODEL_USER_MODIFIED_ROW(x) ((ModelUserModifiedRow *) (x))

typedef struct
{
	MgContextNode *context_node;
	GdaValue      *value;        /* can also be GDA_VALUE_TYPE_LIST for multiple values; values are owned */
	guint          attributes;
} ModelUserModifiedValue;
#define MODEL_USER_MODIFIED_VALUE(x) ((ModelUserModifiedValue *) (x))


GdaValue               *utility_grid_model_get_value (GtkTreeModel *tree_model, GtkTreeIter *iter,
						      MgWorkCore *core, MgContextNode *context_node,
						      gboolean pk_values_only, guint *attributes);
