/* data-entry.h
 *
 * Copyright (C) 1999 - 2002 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __DATA_ENTRY__
#define __DATA_ENTRY__

#include <gnome.h>
#include "datadisplay-common.h"
#include "query.h"

G_BEGIN_DECLS

#define DATA_ENTRY_TYPE          (data_entry_get_type())
#define DATA_ENTRY(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, data_entry_get_type(), DataEntry)
#define DATA_ENTRY_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, data_entry_get_type (), DataEntryClass)
#define IS_DATA_ENTRY(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, data_entry_get_type ())

/*
 * Very simple object wrapper for the widgets that will be used to display
 * the data. What is important is the "contents_modified" signal
 */

typedef struct _DataEntry      DataEntry;
typedef struct _DataEntryClass DataEntryClass;

/* struct for the object's data */
struct _DataEntry
{
	GtkVBox         object;
	GtkWidget      *top_box;
	GtkWidget      *event_box;
	GSList         *children;	/* list of GtkWidgets for easier retreival */
	GtkStyle       *orig_style;

	/* info on the possible ops on the data */
	QueryField     *query_field;
	DataDisplayFns *fns;
	gboolean        is_default_possible;
	gboolean        value_required;

	/* status */
	GdaValue       *orig_value;
	GdaValueType    orig_type;
	gboolean        value_is_null;
	gboolean        value_is_defaultval;
	gboolean        value_is_modified;
};

/* struct for the object's class */
struct _DataEntryClass
{
	GtkVBoxClass               parent_class;

	void (*contents_modified) (DataEntry * wid);
};

/* 
 * generic widget's functions 
*/
guint      data_entry_get_type            (void);
GtkWidget *data_entry_new                 ();
void       data_entry_set_orig_value      (DataEntry *de, const GdaValue *value);
void       data_entry_refresh_display     (DataEntry *de);

/*
 * packing method
 */
void       data_entry_pack_default        (DataEntry * de, GtkWidget * wid);

/*
 * Getting information
 */
GdaValue  *data_entry_get_gdavalue        (DataEntry * de); /* free after usage */
gboolean   data_entry_is_value_null       (DataEntry * de);


G_END_DECLS

#endif
