#ifndef IMAGEFRAME_H		// -*- c++ -*-
#define IMAGEFRAME_H
///
// Copyright (C) 2002 - 2004, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "util/filewatcher.h"
#include "cachedframe.h"

class ImageFrame: public CachedFrame {
public:
  // try to determine if a file is a ps
  static bool is_postscript(std::string filename);

  ImageFrame(Group *parent, 
	      const std::string& assoc,
	      float w, float h);
  ImageFrame(Group *parent, const xmlpp::Element& node,
	     const FileContext &context);
  virtual ~ImageFrame();

  virtual std::string getTypeName() const;
  
  virtual xmlpp::Element *save(xmlpp::Element& parent_node,
			       const FileContext &context) const ;
  virtual void print(std::ostream &out, bool grayscale = false) const;


  // *** undoable actions ***
  void set_association(const std::string &s);


  // *** probe state ***
  const std::string &get_association() const {return association;}

protected:
  std::string association, parsed_file;
  FileWatcher filewatcher;

  void generate_picture(FileCallback callback);
  void on_file_modified();
  void read_size();
};

#endif
