///
// Copyright (C) 2003, 2004, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "viewent.h"
#include <gdkmm.h>

Viewent::Viewent(View& the_view)
  : view(the_view)
{}

Viewent::~Viewent()
{}

void Viewent::draw_content_error(const PixmapRef pixmap) {
  if(pixmap) {
    // p is the top left corner, since that is what draw_pixmap wants.
    const Gdk::Point p = 
      view.pt2scr(get_frame()->get_matrix().transform
		  (Vector(0, get_frame()->get_height())));
    view.get_win()->draw_drawable(view.get_gc(), pixmap, 
				  0, 0, p.get_x(), p.get_y());
  }
}

void Viewent::draw_content_wait() {
  draw_content_error(view.get_wait_pixmap());
}

void Viewent::draw_content_missing() {
  draw_content_error(view.get_missing_pixmap());
}

void Viewent::draw_content_broken() {
  draw_content_error(view.get_broken_pixmap());
}

