#ifndef PPT_VIEWENT_H		// -*- C++ -*-
#define PPT_VIEWENT_H
///
// Copyright (C) 2003, 2004, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "view.h"
#include "document/pagent.h"

/**
 * Base class for View adapters for Pagent s.  A Pagent can be visible
 * in multiple View s, then each of the View s has a Viewent for the
 * Pagent.  When a View is rescaled etc, all its Viewent s are dropped
 * and new ones created.
 */
class Viewent : public SigC::Object {
public:
  typedef Glib::RefPtr<const Gdk::Pixmap> PixmapRef;
  typedef Glib::RefPtr<Viewent> Ref;
  
  /** Returns true if this viewent is for viewing {ent} */
  bool samePagent(const Pagent* ent) { return ent == get_frame(); }
  
  /**
   * Redraw the relevant Pagent in the relevant View.
   * Called (hierarchically through the page / groups) from DocumentView.
   * This method is supposed to be fast and none-blocking, if the content
   * can't be drawn immediately, just return false so draw_content() will be
   * called again.
   * \return true if complete, false if there is need to redraw.
   * \todo the draw-again-on-false feature doesn't work currently.
   */
  virtual bool draw_content() = 0;
  
  virtual const Pagent* get_frame() const = 0;
  
protected:
  Viewent(View& view);
  virtual ~Viewent();
  
  void draw_content_error(const PixmapRef pixmap);
  void draw_content_wait();
  void draw_content_missing();
  void draw_content_broken();
  
  View& view;
private:
  // Undefined
  Viewent();
  Viewent(const Viewent&);
  Viewent& operator = (const Viewent&);
};

#endif
