/* rygel-media-objects.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-media-objects.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
typedef struct _RygelMediaObjectsPrivate RygelMediaObjectsPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block4Data Block4Data;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelMediaObjects {
	GeeArrayList parent_instance;
	RygelMediaObjectsPrivate * priv;
};

struct _RygelMediaObjectsClass {
	GeeArrayListClass parent_class;
};

struct _Block4Data {
	int _ref_count_;
	RygelMediaObjects * self;
	gchar** sort_props;
	gint sort_props_length1;
	gint _sort_props_size_;
};


static gpointer rygel_media_objects_parent_class = NULL;

GType rygel_media_objects_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_OBJECTS_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_OBJECTS_SORT_CAPS "@id,@parentID,dc:title,upnp:class," "dc:artist,dc:author,upnp:album,dc:date"
GType rygel_media_object_get_type (void) G_GNUC_CONST;
static GeeList* rygel_media_objects_real_slice (GeeAbstractList* base, gint start, gint stop);
RygelMediaObjects* rygel_media_objects_new (void);
RygelMediaObjects* rygel_media_objects_construct (GType object_type);
void rygel_media_objects_sort_by_criteria (RygelMediaObjects* self, const gchar* sort_criteria);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static gint _lambda0_ (gconstpointer a, gconstpointer b, Block4Data* _data4_);
static gint rygel_media_objects_compare_media_objects (RygelMediaObjects* self, RygelMediaObject* a, RygelMediaObject* b, gchar** sort_props, int sort_props_length1);
static gint __lambda0__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
void rygel_media_objects_serialize (RygelMediaObjects* self, GUPnPDIDLLiteWriter* didl_writer, RygelHTTPServer* http_server, RygelXBoxHacks* xbox_hacks, GError** error);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
void rygel_xbox_hacks_apply (RygelXBoxHacks* self, RygelMediaItem* item);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GeeList* rygel_media_objects_real_slice (GeeAbstractList* base, gint start, gint stop) {
	RygelMediaObjects * self;
	GeeList* result = NULL;
	GeeList* _tmp0_ = NULL;
	GeeList* slice;
	RygelMediaObjects* _tmp1_ = NULL;
	RygelMediaObjects* ret;
	self = (RygelMediaObjects*) base;
	_tmp0_ = GEE_ABSTRACT_LIST_CLASS (rygel_media_objects_parent_class)->slice ((GeeAbstractList*) GEE_ARRAY_LIST (self), start, stop);
	slice = _tmp0_;
	_tmp1_ = rygel_media_objects_new ();
	ret = _tmp1_;
	gee_abstract_collection_add_all ((GeeAbstractCollection*) ret, (GeeCollection*) slice);
	result = (GeeList*) ret;
	_g_object_unref0 (slice);
	return result;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		_data4_->sort_props = (_vala_array_free (_data4_->sort_props, _data4_->sort_props_length1, (GDestroyNotify) g_free), NULL);
		g_slice_free (Block4Data, _data4_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint _lambda0_ (gconstpointer a, gconstpointer b, Block4Data* _data4_) {
	RygelMediaObjects * self;
	gint result = 0;
	gconstpointer _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaObject* object_a;
	gconstpointer _tmp2_;
	RygelMediaObject* _tmp3_;
	RygelMediaObject* object_b;
	gint _tmp4_;
	self = _data4_->self;
	_tmp0_ = a;
	_tmp1_ = _g_object_ref0 (RYGEL_IS_MEDIA_OBJECT (_tmp0_) ? ((RygelMediaObject*) _tmp0_) : NULL);
	object_a = _tmp1_;
	_tmp2_ = b;
	_tmp3_ = _g_object_ref0 (RYGEL_IS_MEDIA_OBJECT (_tmp2_) ? ((RygelMediaObject*) _tmp2_) : NULL);
	object_b = _tmp3_;
	_tmp4_ = rygel_media_objects_compare_media_objects (self, object_a, object_b, _data4_->sort_props, _data4_->sort_props_length1);
	result = _tmp4_;
	_g_object_unref0 (object_b);
	_g_object_unref0 (object_a);
	return result;
}


static gint __lambda0__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = _lambda0_ (a, b, self);
	return result;
}


void rygel_media_objects_sort_by_criteria (RygelMediaObjects* self, const gchar* sort_criteria) {
	Block4Data* _data4_;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sort_criteria != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp1_ = _tmp0_ = g_strsplit (sort_criteria, ",", 0);
	_data4_->sort_props = _tmp1_;
	_data4_->sort_props_length1 = _vala_array_length (_tmp0_);
	_data4_->_sort_props_size_ = _vala_array_length (_tmp0_);
	if (_data4_->sort_props_length1 == 0) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	gee_array_list_sort_with_data ((GeeArrayList*) self, __lambda0__gcompare_data_func, _data4_);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


void rygel_media_objects_serialize (RygelMediaObjects* self, GUPnPDIDLLiteWriter* didl_writer, RygelHTTPServer* http_server, RygelXBoxHacks* xbox_hacks, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (didl_writer != NULL);
	g_return_if_fail (http_server != NULL);
	{
		RygelMediaObjects* _tmp0_;
		RygelMediaObjects* _result_list;
		gint _tmp1_;
		gint _result_size;
		gint _result_index;
		_tmp0_ = _g_object_ref0 (self);
		_result_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _result_list);
		_result_size = _tmp1_;
		_result_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelMediaObject* _result_;
			gboolean _tmp3_ = FALSE;
			GUPnPDIDLLiteObject* _tmp5_ = NULL;
			GUPnPDIDLLiteObject* _tmp6_;
			_result_index = _result_index + 1;
			if (!(_result_index < _result_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _result_list, _result_index);
			_result_ = (RygelMediaObject*) _tmp2_;
			if (RYGEL_IS_MEDIA_ITEM (_result_)) {
				_tmp3_ = xbox_hacks != NULL;
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				RygelMediaObject* _tmp4_;
				_tmp4_ = _result_;
				rygel_xbox_hacks_apply (xbox_hacks, RYGEL_IS_MEDIA_ITEM (_tmp4_) ? ((RygelMediaItem*) _tmp4_) : NULL);
			}
			_tmp5_ = rygel_media_object_serialize (_result_, didl_writer, http_server, &_inner_error_);
			_tmp6_ = _tmp5_;
			_g_object_unref0 (_tmp6_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (_result_);
				_g_object_unref0 (_result_list);
				return;
			}
			_g_object_unref0 (_result_);
		}
		_g_object_unref0 (_result_list);
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gint rygel_media_objects_compare_media_objects (RygelMediaObjects* self, RygelMediaObject* a, RygelMediaObject* b, gchar** sort_props, int sort_props_length1) {
	gint result = 0;
	gint i = 0;
	gint ret;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	ret = 0;
	{
		gboolean _tmp0_;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			gchar* _tmp2_ = NULL;
			gchar* property;
			gint _tmp3_;
			gchar _tmp4_;
			if (!_tmp0_) {
				i++;
			}
			_tmp0_ = FALSE;
			if (ret == 0) {
				_tmp1_ = i < sort_props_length1;
			} else {
				_tmp1_ = FALSE;
			}
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = string_substring (sort_props[i], (glong) 1, (glong) (-1));
			property = _tmp2_;
			_tmp3_ = rygel_media_object_compare_by_property (a, b, property);
			ret = _tmp3_;
			_tmp4_ = string_get (sort_props[i], (glong) 0);
			if (_tmp4_ == '-') {
				ret = 0 - ret;
			}
			_g_free0 (property);
		}
	}
	result = ret;
	return result;
}


RygelMediaObjects* rygel_media_objects_construct (GType object_type) {
	RygelMediaObjects * self = NULL;
	self = (RygelMediaObjects*) gee_array_list_construct (object_type, RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	return self;
}


RygelMediaObjects* rygel_media_objects_new (void) {
	return rygel_media_objects_construct (RYGEL_TYPE_MEDIA_OBJECTS);
}


static void rygel_media_objects_class_init (RygelMediaObjectsClass * klass) {
	rygel_media_objects_parent_class = g_type_class_peek_parent (klass);
	GEE_ABSTRACT_LIST_CLASS (klass)->slice = rygel_media_objects_real_slice;
}


static void rygel_media_objects_instance_init (RygelMediaObjects * self) {
}


/**
 * An array list that keeps media objects.
 */
GType rygel_media_objects_get_type (void) {
	static volatile gsize rygel_media_objects_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_objects_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_objects_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObjects), 0, (GInstanceInitFunc) rygel_media_objects_instance_init, NULL };
		GType rygel_media_objects_type_id;
		rygel_media_objects_type_id = g_type_register_static (GEE_TYPE_ARRAY_LIST, "RygelMediaObjects", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_objects_type_id__volatile, rygel_media_objects_type_id);
	}
	return rygel_media_objects_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



