/* rygel-http-post.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-http-post.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2006, 2007, 2008 OpenedHand Ltd.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jorn Baayen <jorn.baayen@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_HTTP_POST (rygel_http_post_get_type ())
#define RYGEL_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPost))
#define RYGEL_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))
#define RYGEL_IS_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_POST))
#define RYGEL_IS_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_POST))
#define RYGEL_HTTP_POST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))

typedef struct _RygelHTTPPost RygelHTTPPost;
typedef struct _RygelHTTPPostClass RygelHTTPPostClass;
typedef struct _RygelHTTPPostPrivate RygelHTTPPostPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_ITEM_REMOVAL_QUEUE (rygel_item_removal_queue_get_type ())
#define RYGEL_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueue))
#define RYGEL_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_ITEM_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))

typedef struct _RygelItemRemovalQueue RygelItemRemovalQueue;
typedef struct _RygelItemRemovalQueueClass RygelItemRemovalQueueClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHttpPostHandleData RygelHttpPostHandleData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelHttpPostHandleRealData RygelHttpPostHandleRealData;
typedef struct _Block2Data Block2Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _soup_buffer_free0(var) ((var == NULL) ? NULL : (var = (soup_buffer_free (var), NULL)))
typedef struct _RygelHttpPostWriteChunkData RygelHttpPostWriteChunkData;
typedef struct _RygelHttpPostRemoveItemData RygelHttpPostRemoveItemData;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPPost {
	RygelHTTPRequest parent_instance;
	RygelHTTPPostPrivate * priv;
};

struct _RygelHTTPPostClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelHTTPPostPrivate {
	GSourceFunc handle_continue;
	gpointer handle_continue_target;
	GDestroyNotify handle_continue_target_destroy_notify;
	GFile* file;
	GOutputStream* stream;
};

struct _RygelHttpPostHandleData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	RygelItemRemovalQueue* _tmp0_;
	RygelItemRemovalQueue* queue;
	GError * _error_;
	GCancellable* _tmp1_;
	GError* _tmp2_;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHttpPostHandleRealData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* msg;
	GError* _tmp3_;
	GCancellable* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	GCancellable* _tmp9_;
	GFileOutputStream* _tmp10_;
	GFileOutputStream* _tmp11_;
	GError * _inner_error_;
};

struct _Block2Data {
	int _ref_count_;
	RygelHTTPPost * self;
	GMainLoop* main_loop;
};

struct _RygelHttpPostWriteChunkData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	SoupBuffer* chunk;
	GCancellable* _tmp0_;
	GError * _error_;
	GError * _inner_error_;
};

struct _RygelHttpPostRemoveItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	RygelItemRemovalQueue* _tmp0_;
	RygelItemRemovalQueue* queue;
};


static gpointer rygel_http_post_parent_class = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_http_post_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_POST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_POST, RygelHTTPPostPrivate))
enum  {
	RYGEL_HTTP_POST_DUMMY_PROPERTY
};
RygelHTTPPost* rygel_http_post_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPPost* rygel_http_post_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_http_post_on_request_cancelled (RygelHTTPPost* self);
static void _rygel_http_post_on_request_cancelled_gfunc (gconstpointer data, gpointer self);
static void rygel_http_post_real_handle_data_free (gpointer _data);
static void rygel_http_post_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_post_real_handle_co (RygelHttpPostHandleData* data);
GType rygel_item_removal_queue_get_type (void) G_GNUC_CONST;
RygelItemRemovalQueue* rygel_item_removal_queue_get_default (void);
gboolean rygel_item_removal_queue_dequeue (RygelItemRemovalQueue* self, RygelMediaItem* item);
static void rygel_http_post_handle_real (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_handle_real_finish (RygelHTTPPost* self, GAsyncResult* _res_, GError** error);
static void rygel_http_post_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_item_removal_queue_remove_now (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_item_removal_queue_remove_now_finish (RygelItemRemovalQueue* self, GAsyncResult* _res_);
static void rygel_http_post_handle_real_data_free (gpointer _data);
static gboolean rygel_http_post_handle_real_co (RygelHttpPostHandleRealData* data);
static void rygel_http_post_on_got_chunk (RygelHTTPPost* self, SoupMessage* msg, SoupBuffer* chunk);
static void _rygel_http_post_on_got_chunk_soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self);
static void rygel_http_post_on_got_body (RygelHTTPPost* self, SoupMessage* msg);
static void _rygel_http_post_on_got_body_soup_message_got_body (SoupMessage* _sender, gpointer self);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GQuark rygel_content_directory_error_quark (void);
void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static void rygel_http_post_handle_real_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GQuark rygel_http_request_error_quark (void);
static gboolean _rygel_http_post_handle_real_co_gsource_func (gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void _lambda6_ (RygelMediaContainer* container, Block2Data* _data2_);
static void __lambda6__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
static gboolean _lambda7_ (Block2Data* _data2_);
static gboolean __lambda7__gsource_func (gpointer self);
void rygel_http_request_end (RygelHTTPRequest* self, guint status);
static void rygel_http_post_write_chunk (RygelHTTPPost* self, SoupBuffer* chunk, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_write_chunk_finish (RygelHTTPPost* self, GAsyncResult* _res_);
static void rygel_http_post_write_chunk_data_free (gpointer _data);
static gboolean rygel_http_post_write_chunk_co (RygelHttpPostWriteChunkData* data);
void rygel_http_request_handle_error (RygelHTTPRequest* self, GError* _error_);
static void rygel_http_post_remove_item (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_remove_item_finish (RygelHTTPPost* self, GAsyncResult* _res_);
static void rygel_http_post_remove_item_data_free (gpointer _data);
static gboolean rygel_http_post_remove_item_co (RygelHttpPostRemoveItemData* data);
static void rygel_http_post_remove_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_http_post_finalize (GObject* obj);


static void _rygel_http_post_on_request_cancelled_gfunc (gconstpointer data, gpointer self) {
	rygel_http_post_on_request_cancelled (self);
}


RygelHTTPPost* rygel_http_post_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	RygelHTTPPost * self = NULL;
	GCancellable* _tmp0_ = NULL;
	g_return_val_if_fail (http_server != NULL, NULL);
	g_return_val_if_fail (server != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	self = (RygelHTTPPost*) rygel_http_request_construct (object_type, http_server, server, msg);
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	g_cancellable_connect (_tmp0_, (GCallback*) _rygel_http_post_on_request_cancelled_gfunc, g_object_ref (self), g_object_unref);
	return self;
}


RygelHTTPPost* rygel_http_post_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	return rygel_http_post_construct (RYGEL_TYPE_HTTP_POST, http_server, server, msg);
}


static void rygel_http_post_real_handle_data_free (gpointer _data) {
	RygelHttpPostHandleData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelHttpPostHandleData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_http_post_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPPost * self;
	RygelHttpPostHandleData* _data_;
	self = (RygelHTTPPost*) base;
	_data_ = g_slice_new0 (RygelHttpPostHandleData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_real_handle);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_real_handle_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_http_post_real_handle_co (_data_);
}


static void rygel_http_post_real_handle_finish (RygelHTTPRequest* base, GAsyncResult* _res_, GError** error) {
	RygelHttpPostHandleData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_post_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostHandleData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_http_post_real_handle_co (data);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean rygel_http_post_real_handle_co (RygelHttpPostHandleData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_item_removal_queue_get_default ();
	data->queue = data->_tmp0_;
	rygel_item_removal_queue_dequeue (data->queue, ((RygelHTTPRequest*) data->self)->item);
	data->_state_ = 1;
	rygel_http_post_handle_real (data->self, rygel_http_post_handle_ready, data);
	return FALSE;
	_state_1:
	rygel_http_post_handle_real_finish (data->self, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch32_g_error;
	}
	goto __finally32;
	__catch32_g_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp1_ = NULL;
		data->_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
		data->_state_ = 2;
		rygel_item_removal_queue_remove_now (data->queue, ((RygelHTTPRequest*) data->self)->item, data->_tmp1_, rygel_http_post_handle_ready, data);
		return FALSE;
		_state_2:
		rygel_item_removal_queue_remove_now_finish (data->queue, data->_res_);
		data->_tmp2_ = _g_error_copy0 (data->_error_);
		data->_inner_error_ = data->_tmp2_;
		_g_error_free0 (data->_error_);
		goto __finally32;
	}
	__finally32:
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->queue);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->queue);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_http_post_handle_real_data_free (gpointer _data) {
	RygelHttpPostHandleRealData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelHttpPostHandleRealData, data);
}


static void rygel_http_post_handle_real (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostHandleRealData* _data_;
	_data_ = g_slice_new0 (RygelHttpPostHandleRealData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_handle_real);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_handle_real_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_http_post_handle_real_co (_data_);
}


static void rygel_http_post_handle_real_finish (RygelHTTPPost* self, GAsyncResult* _res_, GError** error) {
	RygelHttpPostHandleRealData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _rygel_http_post_on_got_chunk_soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self) {
	rygel_http_post_on_got_chunk (self, _sender, chunk);
}


static void _rygel_http_post_on_got_body_soup_message_got_body (SoupMessage* _sender, gpointer self) {
	rygel_http_post_on_got_body (self, _sender);
}


static void rygel_http_post_handle_real_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostHandleRealData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_http_post_handle_real_co (data);
}


static gboolean _rygel_http_post_handle_real_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_post_handle_real_co (self);
	return result;
}


static gboolean rygel_http_post_handle_real_co (RygelHttpPostHandleRealData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_signal_connect_object (((RygelHTTPRequest*) data->self)->msg, "got-chunk", (GCallback) _rygel_http_post_on_got_chunk_soup_message_got_chunk, data->self, 0);
	g_signal_connect_object (((RygelHTTPRequest*) data->self)->msg, "got-body", (GCallback) _rygel_http_post_on_got_body_soup_message_got_body, data->self, 0);
	data->_tmp0_ = rygel_media_item_get_place_holder (((RygelHTTPRequest*) data->self)->item);
	if (!data->_tmp0_) {
		data->_tmp1_ = NULL;
		data->_tmp1_ = _ ("Pushing data to non-empty item '%s' not allowed");
		data->_tmp2_ = g_strdup (data->_tmp1_);
		data->msg = data->_tmp2_;
		data->_tmp3_ = NULL;
		data->_tmp3_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, data->msg, ((RygelMediaObject*) ((RygelHTTPRequest*) data->self)->item)->id);
		data->_inner_error_ = data->_tmp3_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_free0 (data->msg);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp4_ = NULL;
	data->_tmp4_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
	data->_state_ = 1;
	rygel_media_object_get_writable ((RygelMediaObject*) ((RygelHTTPRequest*) data->self)->item, data->_tmp4_, rygel_http_post_handle_real_ready, data);
	return FALSE;
	_state_1:
	data->_tmp5_ = NULL;
	data->_tmp5_ = rygel_media_object_get_writable_finish ((RygelMediaObject*) ((RygelHTTPRequest*) data->self)->item, data->_res_, &data->_inner_error_);
	data->_tmp6_ = data->_tmp5_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->self->priv->file);
	data->self->priv->file = data->_tmp6_;
	if (data->self->priv->file == NULL) {
		data->_tmp7_ = NULL;
		data->_tmp7_ = _ ("No writable URI for %s available");
		data->_tmp8_ = NULL;
		data->_tmp8_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, data->_tmp7_, ((RygelMediaObject*) ((RygelHTTPRequest*) data->self)->item)->id);
		data->_inner_error_ = data->_tmp8_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp9_ = NULL;
	data->_tmp9_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
	data->_state_ = 2;
	g_file_replace_async (data->self->priv->file, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, G_PRIORITY_LOW, data->_tmp9_, rygel_http_post_handle_real_ready, data);
	return FALSE;
	_state_2:
	data->_tmp10_ = NULL;
	data->_tmp10_ = g_file_replace_finish (data->self->priv->file, data->_res_, &data->_inner_error_);
	data->_tmp11_ = data->_tmp10_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->self->priv->stream);
	data->self->priv->stream = (GOutputStream*) data->_tmp11_;
	soup_server_unpause_message (((RygelHTTPRequest*) data->self)->server, ((RygelHTTPRequest*) data->self)->msg);
	(data->self->priv->handle_continue_target_destroy_notify == NULL) ? NULL : (data->self->priv->handle_continue_target_destroy_notify (data->self->priv->handle_continue_target), NULL);
	data->self->priv->handle_continue = NULL;
	data->self->priv->handle_continue_target = NULL;
	data->self->priv->handle_continue_target_destroy_notify = NULL;
	data->self->priv->handle_continue = _rygel_http_post_handle_real_co_gsource_func;
	data->self->priv->handle_continue_target = data;
	data->self->priv->handle_continue_target_destroy_notify = NULL;
	data->_state_ = 3;
	return FALSE;
	_state_3:
	;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_main_loop_unref0 (_data2_->main_loop);
		g_slice_free (Block2Data, _data2_);
	}
}


static void _lambda6_ (RygelMediaContainer* container, Block2Data* _data2_) {
	RygelHTTPPost * self;
	self = _data2_->self;
	g_return_if_fail (container != NULL);
	g_main_loop_quit (_data2_->main_loop);
}


static void __lambda6__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
	_lambda6_ (container, self);
}


static gboolean _lambda7_ (Block2Data* _data2_) {
	RygelHTTPPost * self;
	gboolean result = FALSE;
	self = _data2_->self;
	g_debug ("rygel-http-post.vala:103: Timeout while waiting for 'updated' signal o" \
"n '%s'.", ((RygelMediaObject*) ((RygelMediaObject*) ((RygelHTTPRequest*) self)->item)->parent)->id);
	g_main_loop_quit (_data2_->main_loop);
	result = FALSE;
	return result;
}


static gboolean __lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda7_ (self);
	return result;
}


static void rygel_http_post_on_got_body (RygelHTTPPost* self, SoupMessage* msg) {
	Block2Data* _data2_;
	GCancellable* _tmp0_ = NULL;
	GMainLoop* _tmp1_ = NULL;
	guint _tmp2_;
	guint timeout_id;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	if (((RygelHTTPRequest*) self)->msg != msg) {
		return;
	}
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	g_output_stream_close (self->priv->stream, _tmp0_, &_inner_error_);
	if (_inner_error_ != NULL) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		goto __catch33_g_error;
	}
	_tmp1_ = g_main_loop_new (NULL, FALSE);
	_data2_->main_loop = _tmp1_;
	g_signal_connect_data (((RygelMediaObject*) ((RygelHTTPRequest*) self)->item)->parent, "container-updated", (GCallback) __lambda6__rygel_media_container_container_updated, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp2_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda7__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	timeout_id = _tmp2_;
	g_debug ("Waiting for update signal from container '%s' after pushing" " content to its child item '%s'..", ((RygelMediaObject*) ((RygelMediaObject*) ((RygelHTTPRequest*) self)->item)->parent)->id, ((RygelMediaObject*) ((RygelHTTPRequest*) self)->item)->id);
	g_main_loop_run (_data2_->main_loop);
	g_source_remove (timeout_id);
	g_debug ("rygel-http-post.vala:116: Finished waiting for update signal from cont" \
"ainer '%s'", ((RygelMediaObject*) ((RygelMediaObject*) ((RygelHTTPRequest*) self)->item)->parent)->id);
	rygel_http_request_end ((RygelHTTPRequest*) self, (guint) SOUP_STATUS_OK);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	goto __finally33;
	__catch33_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		rygel_http_request_end ((RygelHTTPRequest*) self, (guint) SOUP_STATUS_INTERNAL_SERVER_ERROR);
		_g_error_free0 (_error_);
	}
	__finally33:
	self->priv->handle_continue (self->priv->handle_continue_target);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_http_post_on_got_chunk (RygelHTTPPost* self, SoupMessage* msg, SoupBuffer* chunk) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	g_return_if_fail (chunk != NULL);
	rygel_http_post_write_chunk (self, chunk, NULL, NULL);
}


static void rygel_http_post_write_chunk_data_free (gpointer _data) {
	RygelHttpPostWriteChunkData* data;
	data = _data;
	_soup_buffer_free0 (data->chunk);
	_g_object_unref0 (data->self);
	g_slice_free (RygelHttpPostWriteChunkData, data);
}


static gpointer _soup_buffer_copy0 (gpointer self) {
	return self ? soup_buffer_copy (self) : NULL;
}


static void rygel_http_post_write_chunk (RygelHTTPPost* self, SoupBuffer* chunk, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostWriteChunkData* _data_;
	_data_ = g_slice_new0 (RygelHttpPostWriteChunkData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_write_chunk);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_write_chunk_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->chunk = _soup_buffer_copy0 (chunk);
	rygel_http_post_write_chunk_co (_data_);
}


static void rygel_http_post_write_chunk_finish (RygelHTTPPost* self, GAsyncResult* _res_) {
	RygelHttpPostWriteChunkData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean rygel_http_post_write_chunk_co (RygelHttpPostWriteChunkData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
	g_output_stream_write (data->self->priv->stream, data->chunk->data, (gsize) ((gint) data->chunk->length), data->_tmp0_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch34_g_error;
	}
	goto __finally34;
	__catch34_g_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		rygel_http_request_handle_error ((RygelHTTPRequest*) data->self, data->_error_);
		data->self->priv->handle_continue (data->self->priv->handle_continue_target);
		_g_error_free0 (data->_error_);
	}
	__finally34:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_http_post_on_request_cancelled (RygelHTTPPost* self) {
	g_return_if_fail (self != NULL);
	rygel_http_post_remove_item (self, NULL, NULL);
}


static void rygel_http_post_remove_item_data_free (gpointer _data) {
	RygelHttpPostRemoveItemData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelHttpPostRemoveItemData, data);
}


static void rygel_http_post_remove_item (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostRemoveItemData* _data_;
	_data_ = g_slice_new0 (RygelHttpPostRemoveItemData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_remove_item);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_remove_item_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_http_post_remove_item_co (_data_);
}


static void rygel_http_post_remove_item_finish (RygelHTTPPost* self, GAsyncResult* _res_) {
	RygelHttpPostRemoveItemData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_post_remove_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostRemoveItemData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_http_post_remove_item_co (data);
}


static gboolean rygel_http_post_remove_item_co (RygelHttpPostRemoveItemData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_item_removal_queue_get_default ();
	data->queue = data->_tmp0_;
	data->_state_ = 1;
	rygel_item_removal_queue_remove_now (data->queue, ((RygelHTTPRequest*) data->self)->item, NULL, rygel_http_post_remove_item_ready, data);
	return FALSE;
	_state_1:
	rygel_item_removal_queue_remove_now_finish (data->queue, data->_res_);
	_g_object_unref0 (data->queue);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_http_post_class_init (RygelHTTPPostClass * klass) {
	rygel_http_post_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPPostPrivate));
	RYGEL_HTTP_REQUEST_CLASS (klass)->handle = rygel_http_post_real_handle;
	RYGEL_HTTP_REQUEST_CLASS (klass)->handle_finish = rygel_http_post_real_handle_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_post_finalize;
}


static void rygel_http_post_instance_init (RygelHTTPPost * self) {
	self->priv = RYGEL_HTTP_POST_GET_PRIVATE (self);
}


static void rygel_http_post_finalize (GObject* obj) {
	RygelHTTPPost * self;
	self = RYGEL_HTTP_POST (obj);
	(self->priv->handle_continue_target_destroy_notify == NULL) ? NULL : (self->priv->handle_continue_target_destroy_notify (self->priv->handle_continue_target), NULL);
	self->priv->handle_continue = NULL;
	self->priv->handle_continue_target = NULL;
	self->priv->handle_continue_target_destroy_notify = NULL;
	_g_object_unref0 (self->priv->file);
	_g_object_unref0 (self->priv->stream);
	G_OBJECT_CLASS (rygel_http_post_parent_class)->finalize (obj);
}


/**
 * Responsible for handling HTTP POST client requests.
 */
GType rygel_http_post_get_type (void) {
	static volatile gsize rygel_http_post_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_post_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPPostClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_post_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPPost), 0, (GInstanceInitFunc) rygel_http_post_instance_init, NULL };
		GType rygel_http_post_type_id;
		rygel_http_post_type_id = g_type_register_static (RYGEL_TYPE_HTTP_REQUEST, "RygelHTTPPost", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_post_type_id__volatile, rygel_http_post_type_id);
	}
	return rygel_http_post_type_id__volatile;
}



