/* rygel-item-removal-queue.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-item-removal-queue.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_ITEM_REMOVAL_QUEUE (rygel_item_removal_queue_get_type ())
#define RYGEL_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueue))
#define RYGEL_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_ITEM_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))

typedef struct _RygelItemRemovalQueue RygelItemRemovalQueue;
typedef struct _RygelItemRemovalQueueClass RygelItemRemovalQueueClass;
typedef struct _RygelItemRemovalQueuePrivate RygelItemRemovalQueuePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _Block7Data Block7Data;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelItemRemovalQueueRemoveNowData RygelItemRemovalQueueRemoveNowData;

struct _RygelItemRemovalQueue {
	GObject parent_instance;
	RygelItemRemovalQueuePrivate * priv;
};

struct _RygelItemRemovalQueueClass {
	GObjectClass parent_class;
};

struct _RygelItemRemovalQueuePrivate {
	GeeHashMap* item_timeouts;
};

struct _Block7Data {
	int _ref_count_;
	RygelItemRemovalQueue * self;
	RygelMediaItem* item;
	GCancellable* cancellable;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelItemRemovalQueueRemoveNowData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemRemovalQueue* self;
	RygelMediaItem* item;
	GCancellable* cancellable;
	RygelMediaContainer* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* parent;
	GError * err;
	GError * _inner_error_;
};


static gpointer rygel_item_removal_queue_parent_class = NULL;
static RygelItemRemovalQueue* rygel_item_removal_queue_removal_queue;
static RygelItemRemovalQueue* rygel_item_removal_queue_removal_queue = NULL;

GType rygel_item_removal_queue_get_type (void) G_GNUC_CONST;
#define RYGEL_ITEM_REMOVAL_QUEUE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueuePrivate))
enum  {
	RYGEL_ITEM_REMOVAL_QUEUE_DUMMY_PROPERTY
};
#define RYGEL_ITEM_REMOVAL_QUEUE_TIMEOUT ((guint) 35)
RygelItemRemovalQueue* rygel_item_removal_queue_get_default (void);
static RygelItemRemovalQueue* rygel_item_removal_queue_new (void);
static RygelItemRemovalQueue* rygel_item_removal_queue_construct (GType object_type);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
void rygel_item_removal_queue_queue (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
static gboolean _lambda5_ (Block7Data* _data7_);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
void rygel_item_removal_queue_remove_now (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_item_removal_queue_remove_now_finish (RygelItemRemovalQueue* self, GAsyncResult* _res_);
static gboolean __lambda5__gsource_func (gpointer self);
gboolean rygel_item_removal_queue_dequeue (RygelItemRemovalQueue* self, RygelMediaItem* item);
static void rygel_item_removal_queue_remove_now_data_free (gpointer _data);
static gboolean rygel_item_removal_queue_remove_now_co (RygelItemRemovalQueueRemoveNowData* data);
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
void rygel_writable_container_remove_item (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_remove_item_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_item_removal_queue_remove_now_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_item_removal_queue_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelItemRemovalQueue* rygel_item_removal_queue_get_default (void) {
	RygelItemRemovalQueue* result = NULL;
	gboolean _tmp0_;
	RygelItemRemovalQueue* _tmp2_;
	_tmp0_ = G_UNLIKELY (rygel_item_removal_queue_removal_queue == NULL);
	if (_tmp0_) {
		RygelItemRemovalQueue* _tmp1_ = NULL;
		_tmp1_ = rygel_item_removal_queue_new ();
		_g_object_unref0 (rygel_item_removal_queue_removal_queue);
		rygel_item_removal_queue_removal_queue = _tmp1_;
	}
	_tmp2_ = _g_object_ref0 (rygel_item_removal_queue_removal_queue);
	result = _tmp2_;
	return result;
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_g_object_unref0 (_data7_->self);
		_g_object_unref0 (_data7_->item);
		_g_object_unref0 (_data7_->cancellable);
		g_slice_free (Block7Data, _data7_);
	}
}


static gboolean _lambda5_ (Block7Data* _data7_) {
	RygelItemRemovalQueue * self;
	gboolean result = FALSE;
	self = _data7_->self;
	g_debug ("rygel-item-removal-queue.vala:45: Timeout on temporary item '%s'.", ((RygelMediaObject*) _data7_->item)->id);
	rygel_item_removal_queue_remove_now (self, _data7_->item, _data7_->cancellable, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean __lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda5_ (self);
	return result;
}


void rygel_item_removal_queue_queue (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable) {
	Block7Data* _data7_;
	guint _tmp0_;
	guint timeout;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_data7_->item = _g_object_ref0 (item);
	_data7_->cancellable = _g_object_ref0 (cancellable);
	_tmp0_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, RYGEL_ITEM_REMOVAL_QUEUE_TIMEOUT, __lambda5__gsource_func, block7_data_ref (_data7_), block7_data_unref);
	timeout = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->item_timeouts, ((RygelMediaObject*) _data7_->item)->id, GUINT_TO_POINTER (timeout));
	block7_data_unref (_data7_);
	_data7_ = NULL;
}


gboolean rygel_item_removal_queue_dequeue (RygelItemRemovalQueue* self, RygelMediaItem* item) {
	gboolean result = FALSE;
	guint timeout = 0U;
	gpointer _tmp0_ = NULL;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp1_ = gee_abstract_map_unset ((GeeAbstractMap*) self->priv->item_timeouts, ((RygelMediaObject*) item)->id, &_tmp0_);
	timeout = _tmp0_;
	if (_tmp1_) {
		g_source_remove (timeout);
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static void rygel_item_removal_queue_remove_now_data_free (gpointer _data) {
	RygelItemRemovalQueueRemoveNowData* data;
	data = _data;
	_g_object_unref0 (data->item);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->self);
	g_slice_free (RygelItemRemovalQueueRemoveNowData, data);
}


void rygel_item_removal_queue_remove_now (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemRemovalQueueRemoveNowData* _data_;
	_data_ = g_slice_new0 (RygelItemRemovalQueueRemoveNowData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_removal_queue_remove_now);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_removal_queue_remove_now_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->item = _g_object_ref0 (item);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_item_removal_queue_remove_now_co (_data_);
}


void rygel_item_removal_queue_remove_now_finish (RygelItemRemovalQueue* self, GAsyncResult* _res_) {
	RygelItemRemovalQueueRemoveNowData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_item_removal_queue_remove_now_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemRemovalQueueRemoveNowData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_item_removal_queue_remove_now_co (data);
}


static gboolean rygel_item_removal_queue_remove_now_co (RygelItemRemovalQueueRemoveNowData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	gee_abstract_map_unset ((GeeAbstractMap*) data->self->priv->item_timeouts, ((RygelMediaObject*) data->item)->id, NULL);
	data->_tmp0_ = ((RygelMediaObject*) data->item)->parent;
	data->_tmp1_ = _g_object_ref0 (RYGEL_IS_WRITABLE_CONTAINER (data->_tmp0_) ? ((RygelWritableContainer*) data->_tmp0_) : NULL);
	data->parent = data->_tmp1_;
	data->_state_ = 1;
	rygel_writable_container_remove_item (data->parent, ((RygelMediaObject*) data->item)->id, data->cancellable, rygel_item_removal_queue_remove_now_ready, data);
	return FALSE;
	_state_1:
	rygel_writable_container_remove_item_finish (data->parent, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch67_g_error;
	}
	g_debug ("rygel-item-removal-queue.vala:74: Auto-destroyed item '%s'!", ((RygelMediaObject*) data->item)->id);
	goto __finally67;
	__catch67_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("rygel-item-removal-queue.vala:76: Failed to auto-destroy temporary ite" \
"m '%s': %s", ((RygelMediaObject*) data->item)->id, data->err->message);
		_g_error_free0 (data->err);
	}
	__finally67:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->parent);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->parent);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static RygelItemRemovalQueue* rygel_item_removal_queue_construct (GType object_type) {
	RygelItemRemovalQueue * self = NULL;
	GeeHashMap* _tmp0_ = NULL;
	self = (RygelItemRemovalQueue*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->item_timeouts);
	self->priv->item_timeouts = _tmp0_;
	return self;
}


static RygelItemRemovalQueue* rygel_item_removal_queue_new (void) {
	return rygel_item_removal_queue_construct (RYGEL_TYPE_ITEM_REMOVAL_QUEUE);
}


static void rygel_item_removal_queue_class_init (RygelItemRemovalQueueClass * klass) {
	rygel_item_removal_queue_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelItemRemovalQueuePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_item_removal_queue_finalize;
}


static void rygel_item_removal_queue_instance_init (RygelItemRemovalQueue * self) {
	self->priv = RYGEL_ITEM_REMOVAL_QUEUE_GET_PRIVATE (self);
}


static void rygel_item_removal_queue_finalize (GObject* obj) {
	RygelItemRemovalQueue * self;
	self = RYGEL_ITEM_REMOVAL_QUEUE (obj);
	_g_object_unref0 (self->priv->item_timeouts);
	G_OBJECT_CLASS (rygel_item_removal_queue_parent_class)->finalize (obj);
}


/**
 * Queues items for removal after 35 seconds or immediately.
 */
GType rygel_item_removal_queue_get_type (void) {
	static volatile gsize rygel_item_removal_queue_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_item_removal_queue_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelItemRemovalQueueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_item_removal_queue_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelItemRemovalQueue), 0, (GInstanceInitFunc) rygel_item_removal_queue_instance_init, NULL };
		GType rygel_item_removal_queue_type_id;
		rygel_item_removal_queue_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelItemRemovalQueue", &g_define_type_info, 0);
		g_once_init_leave (&rygel_item_removal_queue_type_id__volatile, rygel_item_removal_queue_type_id);
	}
	return rygel_item_removal_queue_type_id__volatile;
}



