/* rygel-http-time-seek.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-http-time-seek.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>


#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
typedef struct _RygelHTTPSeekPrivate RygelHTTPSeekPrivate;

#define RYGEL_TYPE_HTTP_TIME_SEEK (rygel_http_time_seek_get_type ())
#define RYGEL_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeek))
#define RYGEL_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))
#define RYGEL_IS_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_IS_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_HTTP_TIME_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))

typedef struct _RygelHTTPTimeSeek RygelHTTPTimeSeek;
typedef struct _RygelHTTPTimeSeekClass RygelHTTPTimeSeekClass;
typedef struct _RygelHTTPTimeSeekPrivate RygelHTTPTimeSeekPrivate;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelHTTPSeek {
	GObject parent_instance;
	RygelHTTPSeekPrivate * priv;
};

struct _RygelHTTPSeekClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPSeek* self);
};

struct _RygelHTTPTimeSeek {
	RygelHTTPSeek parent_instance;
	RygelHTTPTimeSeekPrivate * priv;
};

struct _RygelHTTPTimeSeekClass {
	RygelHTTPSeekClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()
struct _RygelHTTPGet {
	GObject parent_instance;
	RygelHTTPGetPrivate * priv;
	SoupMessage* msg;
	RygelMediaItem* item;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPTranscodeHandler* handler;
};

struct _RygelHTTPGetClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	GObject parent_instance;
	RygelMediaItemPrivate * priv;
	gint64 size;
};

struct _RygelMediaItemClass {
	GObjectClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	gint64 duration;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};


static gpointer rygel_http_time_seek_parent_class = NULL;

GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_time_seek_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TIME_SEEK_DUMMY_PROPERTY
};
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_error_quark (void);
RygelHTTPTimeSeek* rygel_http_time_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
static gboolean rygel_http_time_seek_parse_seconds (const gchar* range_token, gint64* value);
static gboolean rygel_http_time_seek_parse_time (const gchar* range_token, gint64* value);
RygelHTTPSeek* rygel_http_seek_construct (GType object_type, SoupMessage* msg, gint64 start, gint64 stop, gint64 step, gint64 total_length, GError** error);
gboolean rygel_http_time_seek_needed (RygelHTTPGet* request);
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
gboolean rygel_http_time_seek_requested (RygelHTTPGet* request);
static void rygel_http_time_seek_real_add_response_headers (RygelHTTPSeek* base);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
SoupMessage* rygel_http_seek_get_msg (RygelHTTPSeek* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, RygelHTTPGet* request, GError** error) {
	RygelHTTPTimeSeek * self = NULL;
	gchar* range = NULL;
	gchar** range_tokens = NULL;
	gint range_tokens_length1 = 0;
	gint _range_tokens_size_ = 0;
	gint64 start;
	RygelMediaItem* _tmp0_;
	gint64 duration;
	gint64 stop;
	gint64 parsed_value;
	gboolean parsing_start;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (request != NULL, NULL);
	start = (gint64) 0;
	_tmp0_ = request->item;
	duration = (RYGEL_IS_AUDIO_ITEM (_tmp0_) ? ((RygelAudioItem*) _tmp0_) : NULL)->duration * GST_SECOND;
	stop = duration - GST_MSECOND;
	parsed_value = (gint64) 0;
	parsing_start = TRUE;
	_tmp1_ = soup_message_headers_get_one (request->msg->request_headers, "TimeSeekRange.dlna.org");
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (range);
	range = _tmp2_;
	if (range != NULL) {
		gboolean _tmp3_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp3_ = g_str_has_prefix (range, "npt=");
		if (!_tmp3_) {
			GError* _tmp4_ = NULL;
			_tmp4_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, "Invalid Range '%s'", range);
			_inner_error_ = _tmp4_;
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
				g_propagate_error (error, _inner_error_);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (range);
				_g_object_unref0 (self);
				return NULL;
			} else {
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (range);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp5_ = string_substring (range, (glong) 4, (glong) (-1));
		_tmp6_ = _tmp5_;
		_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "-", 2);
		range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
		range_tokens = _tmp8_;
		range_tokens_length1 = _vala_array_length (_tmp7_);
		_range_tokens_size_ = _vala_array_length (_tmp7_);
		_g_free0 (_tmp6_);
		if (range_tokens[0] == NULL) {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = g_strcmp0 (range_tokens[0], "") == 0;
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = range_tokens[1] == NULL;
		}
		if (_tmp9_) {
			const gchar* _tmp11_ = NULL;
			GError* _tmp12_ = NULL;
			_tmp11_ = _ ("Invalid Range '%s'");
			_tmp12_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp11_, range);
			_inner_error_ = _tmp12_;
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
				g_propagate_error (error, _inner_error_);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (range);
				_g_object_unref0 (self);
				return NULL;
			} else {
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (range);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		{
			gchar** range_token_collection;
			int range_token_collection_length1;
			int range_token_it;
			range_token_collection = range_tokens;
			range_token_collection_length1 = range_tokens_length1;
			for (range_token_it = 0; range_token_it < range_tokens_length1; range_token_it = range_token_it + 1) {
				gchar* _tmp13_;
				gchar* range_token;
				_tmp13_ = g_strdup (range_token_collection[range_token_it]);
				range_token = _tmp13_;
				{
					gint _tmp14_;
					if (g_strcmp0 (range_token, "") == 0) {
						_g_free0 (range_token);
						continue;
					}
					_tmp14_ = string_index_of (range_token, ":", 0);
					if (_tmp14_ == (-1)) {
						gboolean _tmp15_;
						_tmp15_ = rygel_http_time_seek_parse_seconds (range_token, &parsed_value);
						if (!_tmp15_) {
							const gchar* _tmp16_ = NULL;
							GError* _tmp17_ = NULL;
							_tmp16_ = _ ("Invalid Range '%s'");
							_tmp17_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp16_, range);
							_inner_error_ = _tmp17_;
							if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (range_token);
								range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (range);
								_g_object_unref0 (self);
								return NULL;
							} else {
								_g_free0 (range_token);
								range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (range);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
					} else {
						gboolean _tmp18_;
						_tmp18_ = rygel_http_time_seek_parse_time (range_token, &parsed_value);
						if (!_tmp18_) {
							const gchar* _tmp19_ = NULL;
							GError* _tmp20_ = NULL;
							_tmp19_ = _ ("Invalid Range '%s'");
							_tmp20_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp19_, range);
							_inner_error_ = _tmp20_;
							if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (range_token);
								range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (range);
								_g_object_unref0 (self);
								return NULL;
							} else {
								_g_free0 (range_token);
								range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (range);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
					}
					if (parsing_start) {
						parsing_start = FALSE;
						start = parsed_value;
					} else {
						stop = parsed_value;
					}
					_g_free0 (range_token);
				}
			}
		}
		if (start > stop) {
			const gchar* _tmp21_ = NULL;
			GError* _tmp22_ = NULL;
			_tmp21_ = _ ("Invalid Range '%s'");
			_tmp22_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp21_, range);
			_inner_error_ = _tmp22_;
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
				g_propagate_error (error, _inner_error_);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (range);
				_g_object_unref0 (self);
				return NULL;
			} else {
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (range);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	self = (RygelHTTPTimeSeek*) rygel_http_seek_construct (object_type, request->msg, start, stop, (gint64) GST_MSECOND, duration, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (range);
	return self;
}


RygelHTTPTimeSeek* rygel_http_time_seek_new (RygelHTTPGet* request, GError** error) {
	return rygel_http_time_seek_construct (RYGEL_TYPE_HTTP_TIME_SEEK, request, error);
}


gboolean rygel_http_time_seek_needed (RygelHTTPGet* request) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (request != NULL, FALSE);
	if (RYGEL_IS_AUDIO_ITEM (request->item)) {
		RygelMediaItem* _tmp2_;
		_tmp2_ = request->item;
		_tmp1_ = (RYGEL_IS_AUDIO_ITEM (_tmp2_) ? ((RygelAudioItem*) _tmp2_) : NULL)->duration > 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp3_ = FALSE;
		if (RYGEL_IS_HTTP_TRANSCODE_HANDLER (request->handler)) {
			_tmp3_ = TRUE;
		} else {
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			if (request->thumbnail == NULL) {
				_tmp5_ = request->subtitle == NULL;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				gboolean _tmp6_;
				_tmp6_ = rygel_media_item_is_live_stream (request->item);
				_tmp4_ = _tmp6_;
			} else {
				_tmp4_ = FALSE;
			}
			_tmp3_ = _tmp4_;
		}
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean rygel_http_time_seek_requested (RygelHTTPGet* request) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (request != NULL, FALSE);
	_tmp0_ = soup_message_headers_get_one (request->msg->request_headers, "TimeSeekRange.dlna.org");
	result = _tmp0_ != NULL;
	return result;
}


static void rygel_http_time_seek_real_add_response_headers (RygelHTTPSeek* base) {
	RygelHTTPTimeSeek * self;
	gint64 _tmp0_;
	gdouble start;
	gint64 _tmp1_;
	gdouble stop;
	gint64 _tmp2_;
	gdouble total;
	gchar* _tmp3_ = NULL;
	gchar* start_str;
	gint start_str_length1;
	gint _start_str_size_;
	gchar* _tmp4_ = NULL;
	gchar* stop_str;
	gint stop_str_length1;
	gint _stop_str_size_;
	gchar* _tmp5_ = NULL;
	gchar* total_str;
	gint total_str_length1;
	gint _total_str_size_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* range;
	SoupMessage* _tmp19_ = NULL;
	self = (RygelHTTPTimeSeek*) base;
	_tmp0_ = rygel_http_seek_get_start ((RygelHTTPSeek*) self);
	start = ((gdouble) _tmp0_) / GST_SECOND;
	_tmp1_ = rygel_http_seek_get_stop ((RygelHTTPSeek*) self);
	stop = ((gdouble) _tmp1_) / GST_SECOND;
	_tmp2_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) self);
	total = ((gdouble) _tmp2_) / GST_SECOND;
	_tmp3_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	start_str = _tmp3_;
	start_str_length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_start_str_size_ = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp4_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	stop_str = _tmp4_;
	stop_str_length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_stop_str_size_ = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp5_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	total_str = _tmp5_;
	total_str_length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_total_str_size_ = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp6_ = g_ascii_formatd (start_str, start_str_length1, "%.3f", start);
	_tmp7_ = g_strconcat ("npt=", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, "-", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_ascii_formatd (stop_str, stop_str_length1, "%.3f", stop);
	_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, "/", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_ascii_formatd (total_str, total_str_length1, "%.3f", total);
	_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	range = _tmp18_;
	_tmp19_ = rygel_http_seek_get_msg ((RygelHTTPSeek*) self);
	soup_message_headers_append (_tmp19_->response_headers, "TimeSeekRange.dlna.org", range);
	_g_free0 (range);
	total_str = (g_free (total_str), NULL);
	stop_str = (g_free (stop_str), NULL);
	start_str = (g_free (start_str), NULL);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	gdouble _tmp0_;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = g_ascii_strtod (str, NULL);
	result = _tmp0_;
	return result;
}


static gboolean rygel_http_time_seek_parse_seconds (const gchar* range_token, gint64* value) {
	gboolean result = FALSE;
	gchar _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (range_token != NULL, FALSE);
	_tmp0_ = string_get (range_token, (glong) 0);
	_tmp1_ = g_ascii_isdigit (_tmp0_);
	if (_tmp1_) {
		gdouble _tmp2_;
		_tmp2_ = double_parse (range_token);
		*value = (gint64) (_tmp2_ * GST_SECOND);
	} else {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean rygel_http_time_seek_parse_time (const gchar* range_token, gint64* value) {
	gboolean result = FALSE;
	gint64 seconds_sum;
	gint time_factor;
	gchar** time_tokens = NULL;
	gint time_tokens_length1 = 0;
	gint _time_tokens_size_ = 0;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (range_token != NULL, FALSE);
	seconds_sum = (gint64) 0;
	time_factor = 0;
	seconds_sum = (gint64) 0;
	time_factor = 3600;
	_tmp1_ = _tmp0_ = g_strsplit (range_token, ":", 3);
	time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
	time_tokens = _tmp1_;
	time_tokens_length1 = _vala_array_length (_tmp0_);
	_time_tokens_size_ = _vala_array_length (_tmp0_);
	if (time_tokens[0] == NULL) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = time_tokens[1] == NULL;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = time_tokens[2] == NULL;
	}
	if (_tmp2_) {
		result = FALSE;
		time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	{
		gchar** time_collection;
		int time_collection_length1;
		int time_it;
		time_collection = time_tokens;
		time_collection_length1 = time_tokens_length1;
		for (time_it = 0; time_it < time_tokens_length1; time_it = time_it + 1) {
			gchar* _tmp4_;
			gchar* time;
			_tmp4_ = g_strdup (time_collection[time_it]);
			time = _tmp4_;
			{
				gchar _tmp5_;
				gboolean _tmp6_;
				_tmp5_ = string_get (time, (glong) 0);
				_tmp6_ = g_ascii_isdigit (_tmp5_);
				if (_tmp6_) {
					gdouble _tmp7_;
					_tmp7_ = double_parse (time);
					seconds_sum = seconds_sum + ((gint64) ((_tmp7_ * GST_SECOND) * time_factor));
				} else {
					result = FALSE;
					_g_free0 (time);
					time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				time_factor = time_factor / 60;
				_g_free0 (time);
			}
		}
	}
	*value = seconds_sum;
	result = TRUE;
	time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void rygel_http_time_seek_class_init (RygelHTTPTimeSeekClass * klass) {
	rygel_http_time_seek_parent_class = g_type_class_peek_parent (klass);
	RYGEL_HTTP_SEEK_CLASS (klass)->add_response_headers = rygel_http_time_seek_real_add_response_headers;
}


static void rygel_http_time_seek_instance_init (RygelHTTPTimeSeek * self) {
}


GType rygel_http_time_seek_get_type (void) {
	static volatile gsize rygel_http_time_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTimeSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_time_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTimeSeek), 0, (GInstanceInitFunc) rygel_http_time_seek_instance_init, NULL };
		GType rygel_http_time_seek_type_id;
		rygel_http_time_seek_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK, "RygelHTTPTimeSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_time_seek_type_id__volatile, rygel_http_time_seek_type_id);
	}
	return rygel_http_time_seek_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



