/* rygel-transcoder.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <libgupnp-av/gupnp-av.h>
#include <gst/pbutils/pbutils.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _gst_encoding_profile_unref0(var) ((var == NULL) ? NULL : (var = (gst_encoding_profile_unref (var), NULL)))
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))

struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
	GstElement* (*create_source) (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error);
	GUPnPDIDLLiteResource* (*add_resource) (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
	guint (*get_distance) (RygelTranscoder* self, RygelMediaItem* item);
	GstEncodingProfile* (*get_encoding_profile) (RygelTranscoder* self);
};

struct _RygelTranscoderPrivate {
	gchar* _mime_type;
	gchar* _dlna_profile;
	GstElement* decoder;
	GstElement* encoder;
	gchar* _upnp_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};


static gpointer rygel_transcoder_parent_class = NULL;

GType rygel_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
#define RYGEL_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TRANSCODER, RygelTranscoderPrivate))
enum  {
	RYGEL_TRANSCODER_DUMMY_PROPERTY,
	RYGEL_TRANSCODER_MIME_TYPE,
	RYGEL_TRANSCODER_DLNA_PROFILE,
	RYGEL_TRANSCODER_UPNP_CLASS
};
#define RYGEL_TRANSCODER_DECODE_BIN "decodebin2"
#define RYGEL_TRANSCODER_ENCODE_BIN "encodebin"
RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* upnp_class);
void rygel_transcoder_set_mime_type (RygelTranscoder* self, const gchar* value);
void rygel_transcoder_set_dlna_profile (RygelTranscoder* self, const gchar* value);
void rygel_transcoder_set_upnp_class (RygelTranscoder* self, const gchar* value);
GstElement* rygel_transcoder_create_source (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error);
static GstElement* rygel_transcoder_real_create_source (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error);
GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error);
GstEncodingProfile* rygel_transcoder_get_encoding_profile (RygelTranscoder* self);
static inline void _dynamic_set_profile0 (GstElement* obj, GstEncodingProfile* value);
static void rygel_transcoder_on_decoder_pad_added (RygelTranscoder* self, GstElement* decodebin, GstPad* new_pad);
static void _rygel_transcoder_on_decoder_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
static gboolean rygel_transcoder_on_autoplug_continue (RygelTranscoder* self, GstElement* decodebin, GstPad* new_pad, GstCaps* caps);
static gboolean _rygel_transcoder_on_autoplug_continue_dynamic_autoplug_continue0_ (GstElement* _sender, GstPad* new_pad, GstCaps* caps, gpointer self);
static void g_cclosure_user_marshal_BOOLEAN__OBJECT_GST_CAPS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
void _dynamic_autoplug_continue1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data);
GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
static GUPnPDIDLLiteResource* rygel_transcoder_real_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
gboolean rygel_transcoder_mime_type_is_a (RygelTranscoder* self, const gchar* mime_type1, const gchar* mime_type2);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
const gchar* rygel_transcoder_get_mime_type (RygelTranscoder* self);
const gchar* rygel_transcoder_get_dlna_profile (RygelTranscoder* self);
gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self);
gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
gboolean rygel_transcoder_can_handle (RygelTranscoder* self, const gchar* target);
guint rygel_transcoder_get_distance (RygelTranscoder* self, RygelMediaItem* item);
static guint rygel_transcoder_real_get_distance (RygelTranscoder* self, RygelMediaItem* item);
static GstEncodingProfile* rygel_transcoder_real_get_encoding_profile (RygelTranscoder* self);
const gchar* rygel_transcoder_get_upnp_class (RygelTranscoder* self);
static void rygel_transcoder_finalize (GObject* obj);
static void _vala_rygel_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* upnp_class) {
	RygelTranscoder * self = NULL;
	g_return_val_if_fail (mime_type != NULL, NULL);
	g_return_val_if_fail (dlna_profile != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	self = (RygelTranscoder*) g_object_new (object_type, NULL);
	rygel_transcoder_set_mime_type (self, mime_type);
	rygel_transcoder_set_dlna_profile (self, dlna_profile);
	rygel_transcoder_set_upnp_class (self, upnp_class);
	return self;
}


/**
     * Creates a transcoding source.
     *
     * @param src the media item to create the transcoding source for
     * @param src the original (non-transcoding) source
     *
     * @return      the new transcoding source
     */
static inline void _dynamic_set_profile0 (GstElement* obj, GstEncodingProfile* value) {
	g_object_set (obj, "profile", value, NULL);
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


static void _rygel_transcoder_on_decoder_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
	rygel_transcoder_on_decoder_pad_added (self, _sender, pad);
}


static gboolean _rygel_transcoder_on_autoplug_continue_dynamic_autoplug_continue0_ (GstElement* _sender, GstPad* new_pad, GstCaps* caps, gpointer self) {
	gboolean result;
	result = rygel_transcoder_on_autoplug_continue (self, _sender, new_pad, caps);
	return result;
}


static void g_cclosure_user_marshal_BOOLEAN__OBJECT_GST_CAPS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__OBJECT_GST_CAPS) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__OBJECT_GST_CAPS callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__OBJECT_GST_CAPS) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_object (param_values + 1), gst_value_get_caps (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}


void _dynamic_autoplug_continue1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data) {
	g_signal_connect_object (obj, signal_name, handler, data, 0);
}


static GstElement* rygel_transcoder_real_create_source (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error) {
	GstElement* result = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_;
	GstElement* _tmp2_ = NULL;
	GstElement* _tmp3_;
	GstEncodingProfile* _tmp4_ = NULL;
	GstEncodingProfile* _tmp5_;
	GstBin* _tmp6_ = NULL;
	GstBin* bin;
	GstElement* _tmp7_;
	GstElement* _tmp8_;
	GstElement* _tmp9_;
	GstPad* _tmp10_ = NULL;
	GstPad* pad;
	GstGhostPad* _tmp11_ = NULL;
	GstGhostPad* ghost;
	GstPad* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (src != NULL, NULL);
	_tmp0_ = rygel_gst_utils_create_element (RYGEL_TRANSCODER_DECODE_BIN, RYGEL_TRANSCODER_DECODE_BIN, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_gst_object_unref0 (self->priv->decoder);
	self->priv->decoder = _tmp1_;
	_tmp2_ = rygel_gst_utils_create_element (RYGEL_TRANSCODER_ENCODE_BIN, RYGEL_TRANSCODER_ENCODE_BIN, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_gst_object_unref0 (self->priv->encoder);
	self->priv->encoder = _tmp3_;
	_tmp4_ = rygel_transcoder_get_encoding_profile (self);
	_tmp5_ = _tmp4_;
	_dynamic_set_profile0 (self->priv->encoder, _tmp5_);
	_gst_encoding_profile_unref0 (_tmp5_);
	_tmp6_ = (GstBin*) gst_bin_new ("transcoder-source");
	bin = _tmp6_;
	_tmp7_ = _gst_object_ref0 (src);
	_tmp8_ = _gst_object_ref0 (self->priv->decoder);
	_tmp9_ = _gst_object_ref0 (self->priv->encoder);
	gst_bin_add_many (bin, _tmp7_, _tmp8_, _tmp9_, NULL);
	gst_element_link (src, self->priv->decoder);
	g_signal_connect_object (self->priv->decoder, "pad-added", (GCallback) _rygel_transcoder_on_decoder_pad_added_gst_element_pad_added, self, 0);
	_dynamic_autoplug_continue1_connect (self->priv->decoder, "autoplug_continue", (GCallback) _rygel_transcoder_on_autoplug_continue_dynamic_autoplug_continue0_, self);
	_tmp10_ = gst_element_get_static_pad (self->priv->encoder, "src");
	pad = _tmp10_;
	_tmp11_ = (GstGhostPad*) gst_ghost_pad_new (NULL, pad);
	ghost = _tmp11_;
	_tmp12_ = _gst_object_ref0 ((GstPad*) ghost);
	gst_element_add_pad ((GstElement*) bin, _tmp12_);
	result = (GstElement*) bin;
	_gst_object_unref0 (ghost);
	_gst_object_unref0 (pad);
	return result;
}


GstElement* rygel_transcoder_create_source (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error) {
	return RYGEL_TRANSCODER_GET_CLASS (self)->create_source (self, item, src, error);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GUPnPDIDLLiteResource* rygel_transcoder_real_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error) {
	GUPnPDIDLLiteResource* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* protocol;
	gchar* _tmp3_ = NULL;
	gchar* uri;
	GUPnPDIDLLiteResource* _tmp4_ = NULL;
	GUPnPDIDLLiteResource* res;
	GUPnPProtocolInfo* _tmp5_ = NULL;
	GUPnPProtocolInfo* _tmp6_;
	GUPnPProtocolInfo* protocol_info;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (didl_item != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (manager != NULL, NULL);
	_tmp1_ = rygel_transcoder_mime_type_is_a (self, item->mime_type, self->priv->_mime_type);
	if (_tmp1_) {
		_tmp0_ = g_strcmp0 (self->priv->_dlna_profile, item->dlna_profile) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp2_ = rygel_transcode_manager_get_protocol (manager);
	protocol = _tmp2_;
	_tmp3_ = rygel_transcode_manager_create_uri_for_item (manager, item, -1, -1, self->priv->_dlna_profile);
	uri = _tmp3_;
	_tmp4_ = rygel_media_item_add_resource (item, didl_item, uri, protocol, NULL, &_inner_error_);
	res = _tmp4_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (uri);
		_g_free0 (protocol);
		return NULL;
	}
	gupnp_didl_lite_resource_set_size (res, (glong) (-1));
	_tmp5_ = gupnp_didl_lite_resource_get_protocol_info (res);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	protocol_info = _tmp6_;
	gupnp_protocol_info_set_mime_type (protocol_info, self->priv->_mime_type);
	gupnp_protocol_info_set_dlna_profile (protocol_info, self->priv->_dlna_profile);
	gupnp_protocol_info_set_dlna_conversion (protocol_info, GUPNP_DLNA_CONVERSION_TRANSCODED);
	gupnp_protocol_info_set_dlna_flags (protocol_info, ((GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE) | GUPNP_DLNA_FLAGS_CONNECTION_STALL) | GUPNP_DLNA_FLAGS_DLNA_V15);
	if (RYGEL_IS_AUDIO_ITEM (item)) {
		RygelMediaItem* _tmp8_;
		_tmp8_ = item;
		_tmp7_ = (RYGEL_IS_AUDIO_ITEM (_tmp8_) ? ((RygelAudioItem*) _tmp8_) : NULL)->duration > 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gupnp_protocol_info_set_dlna_operation (protocol_info, GUPNP_DLNA_OPERATION_TIMESEEK);
	} else {
		gupnp_protocol_info_set_dlna_operation (protocol_info, GUPNP_DLNA_OPERATION_NONE);
	}
	result = res;
	_g_object_unref0 (protocol_info);
	_g_free0 (uri);
	_g_free0 (protocol);
	return result;
}


GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error) {
	return RYGEL_TRANSCODER_GET_CLASS (self)->add_resource (self, didl_item, item, manager, error);
}


gboolean rygel_transcoder_can_handle (RygelTranscoder* self, const gchar* target) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (target != NULL, FALSE);
	result = g_strcmp0 (target, self->priv->_dlna_profile) == 0;
	return result;
}


/**
     * Gets the numeric value that gives an gives an estimate of how hard
     * would it be to trancode @item to target profile of this transcoder.
     *
     * @param item the media item to calculate the distance for
     *
     * @return      the distance from the @item, uint.MIN if providing such a
     *              value is impossible or uint.MAX if it doesn't make any
     *              sense to use this transcoder for @item
     */
static guint rygel_transcoder_real_get_distance (RygelTranscoder* self, RygelMediaItem* item) {
	g_return_val_if_fail (self != NULL, 0U);
	g_critical ("Type `%s' does not implement abstract method `rygel_transcoder_get_distance'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0U;
}


guint rygel_transcoder_get_distance (RygelTranscoder* self, RygelMediaItem* item) {
	return RYGEL_TRANSCODER_GET_CLASS (self)->get_distance (self, item);
}


/**
     * Gets the Gst.EncodingProfile for this transcoder.
     *
     * @return      the Gst.EncodingProfile for this transcoder.
     */
static GstEncodingProfile* rygel_transcoder_real_get_encoding_profile (RygelTranscoder* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `rygel_transcoder_get_encoding_profile'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GstEncodingProfile* rygel_transcoder_get_encoding_profile (RygelTranscoder* self) {
	return RYGEL_TRANSCODER_GET_CLASS (self)->get_encoding_profile (self);
}


gboolean rygel_transcoder_mime_type_is_a (RygelTranscoder* self, const gchar* mime_type1, const gchar* mime_type2) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* content_type1;
	gchar* _tmp1_ = NULL;
	gchar* content_type2;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (mime_type1 != NULL, FALSE);
	g_return_val_if_fail (mime_type2 != NULL, FALSE);
	_tmp0_ = g_content_type_get_mime_type (mime_type1);
	content_type1 = _tmp0_;
	_tmp1_ = g_content_type_get_mime_type (mime_type2);
	content_type2 = _tmp1_;
	_tmp2_ = g_content_type_is_a (content_type1, content_type2);
	result = _tmp2_;
	_g_free0 (content_type2);
	_g_free0 (content_type1);
	return result;
}


static gboolean rygel_transcoder_on_autoplug_continue (RygelTranscoder* self, GstElement* decodebin, GstPad* new_pad, GstCaps* caps) {
	gboolean result = FALSE;
	GstPad* sinkpad;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (decodebin != NULL, FALSE);
	g_return_val_if_fail (new_pad != NULL, FALSE);
	g_return_val_if_fail (caps != NULL, FALSE);
	sinkpad = NULL;
	g_signal_emit_by_name (self->priv->encoder, "request-pad", caps, &sinkpad, NULL);
	if (sinkpad == NULL) {
		result = TRUE;
		_gst_object_unref0 (sinkpad);
		return result;
	}
	result = FALSE;
	_gst_object_unref0 (sinkpad);
	return result;
}


static void rygel_transcoder_on_decoder_pad_added (RygelTranscoder* self, GstElement* decodebin, GstPad* new_pad) {
	GstPad* sinkpad = NULL;
	GstPad* _tmp0_ = NULL;
	GstPadLinkReturn _tmp3_;
	gboolean pad_link_ok;
	g_return_if_fail (self != NULL);
	g_return_if_fail (decodebin != NULL);
	g_return_if_fail (new_pad != NULL);
	_tmp0_ = gst_element_get_compatible_pad (self->priv->encoder, new_pad, NULL);
	_gst_object_unref0 (sinkpad);
	sinkpad = _tmp0_;
	if (sinkpad == NULL) {
		GstCaps* _tmp1_ = NULL;
		GstCaps* caps;
		_tmp1_ = gst_pad_get_caps (new_pad);
		caps = _tmp1_;
		g_signal_emit_by_name (self->priv->encoder, "request-pad", caps, &sinkpad, NULL);
		_gst_caps_unref0 (caps);
	}
	if (sinkpad == NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = gst_object_get_name ((GstObject*) new_pad);
		g_debug ("rygel-transcoder.vala:174: No compatible encodebin pad found for pad '" \
"%s', ignoring..", _tmp2_);
		_gst_object_unref0 (sinkpad);
		return;
	}
	_tmp3_ = gst_pad_link (new_pad, sinkpad);
	pad_link_ok = _tmp3_ == GST_PAD_LINK_OK;
	if (!pad_link_ok) {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp4_ = gst_object_get_name ((GstObject*) new_pad);
		_tmp5_ = gst_object_get_name ((GstObject*) sinkpad);
		g_warning ("rygel-transcoder.vala:182: Failed to link pad '%s' to '%s'", _tmp4_, _tmp5_);
	}
	_gst_object_unref0 (sinkpad);
	return;
}


const gchar* rygel_transcoder_get_mime_type (RygelTranscoder* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_mime_type;
	return result;
}


void rygel_transcoder_set_mime_type (RygelTranscoder* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_mime_type);
	self->priv->_mime_type = _tmp0_;
	g_object_notify ((GObject *) self, "mime-type");
}


const gchar* rygel_transcoder_get_dlna_profile (RygelTranscoder* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_dlna_profile;
	return result;
}


void rygel_transcoder_set_dlna_profile (RygelTranscoder* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_dlna_profile);
	self->priv->_dlna_profile = _tmp0_;
	g_object_notify ((GObject *) self, "dlna-profile");
}


const gchar* rygel_transcoder_get_upnp_class (RygelTranscoder* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_upnp_class;
	return result;
}


void rygel_transcoder_set_upnp_class (RygelTranscoder* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_upnp_class);
	self->priv->_upnp_class = _tmp0_;
	g_object_notify ((GObject *) self, "upnp-class");
}


static void rygel_transcoder_class_init (RygelTranscoderClass * klass) {
	rygel_transcoder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTranscoderPrivate));
	RYGEL_TRANSCODER_CLASS (klass)->create_source = rygel_transcoder_real_create_source;
	RYGEL_TRANSCODER_CLASS (klass)->add_resource = rygel_transcoder_real_add_resource;
	RYGEL_TRANSCODER_CLASS (klass)->get_distance = rygel_transcoder_real_get_distance;
	RYGEL_TRANSCODER_CLASS (klass)->get_encoding_profile = rygel_transcoder_real_get_encoding_profile;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_transcoder_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_transcoder_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_transcoder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRANSCODER_MIME_TYPE, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRANSCODER_DLNA_PROFILE, g_param_spec_string ("dlna-profile", "dlna-profile", "dlna-profile", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRANSCODER_UPNP_CLASS, g_param_spec_string ("upnp-class", "upnp-class", "upnp-class", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_transcoder_instance_init (RygelTranscoder * self) {
	self->priv = RYGEL_TRANSCODER_GET_PRIVATE (self);
}


static void rygel_transcoder_finalize (GObject* obj) {
	RygelTranscoder * self;
	self = RYGEL_TRANSCODER (obj);
	_g_free0 (self->priv->_mime_type);
	_g_free0 (self->priv->_dlna_profile);
	_gst_object_unref0 (self->priv->decoder);
	_gst_object_unref0 (self->priv->encoder);
	_g_free0 (self->priv->_upnp_class);
	G_OBJECT_CLASS (rygel_transcoder_parent_class)->finalize (obj);
}


/**
 * The base Transcoder class. Each implementation derives from it and must
 * implement get_distance and get_encoding_profile methods.
 */
GType rygel_transcoder_get_type (void) {
	static volatile gsize rygel_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTranscoder), 0, (GInstanceInitFunc) rygel_transcoder_instance_init, NULL };
		GType rygel_transcoder_type_id;
		rygel_transcoder_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelTranscoder", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_transcoder_type_id__volatile, rygel_transcoder_type_id);
	}
	return rygel_transcoder_type_id__volatile;
}


static void _vala_rygel_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelTranscoder * self;
	self = RYGEL_TRANSCODER (object);
	switch (property_id) {
		case RYGEL_TRANSCODER_MIME_TYPE:
		g_value_set_string (value, rygel_transcoder_get_mime_type (self));
		break;
		case RYGEL_TRANSCODER_DLNA_PROFILE:
		g_value_set_string (value, rygel_transcoder_get_dlna_profile (self));
		break;
		case RYGEL_TRANSCODER_UPNP_CLASS:
		g_value_set_string (value, rygel_transcoder_get_upnp_class (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelTranscoder * self;
	self = RYGEL_TRANSCODER (object);
	switch (property_id) {
		case RYGEL_TRANSCODER_MIME_TYPE:
		rygel_transcoder_set_mime_type (self, g_value_get_string (value));
		break;
		case RYGEL_TRANSCODER_DLNA_PROFILE:
		rygel_transcoder_set_dlna_profile (self, g_value_get_string (value));
		break;
		case RYGEL_TRANSCODER_UPNP_CLASS:
		rygel_transcoder_set_upnp_class (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



