/* rygel-media-object.c generated by valac 0.13.3, the Vala compiler
 * generated from rygel-media-object.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaObjectGetWritableData RygelMediaObjectGetWritableData;
typedef struct _RygelMediaObjectGetWritablesData RygelMediaObjectGetWritablesData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaObjectCheckWritableData RygelMediaObjectCheckWritableData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaObjectPrivate {
	RygelMediaContainer* _parent_ref;
	gchar* _title;
};

struct _RygelMediaObjectGetWritableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GCancellable* cancellable;
	GFile* result;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _uri_list;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _uri_size;
	gint _uri_index;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GeeArrayList* _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_;
	gchar* uri;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* file;
	GFile* _tmp13_;
	GCancellable* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	GError * _inner_error_;
};

struct _RygelMediaObjectGetWritablesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GCancellable* cancellable;
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	GeeArrayList* writables;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _uri_list;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _uri_size;
	gint _uri_index;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	gchar* uri;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	GFile* file;
	GFile* _tmp14_;
	GCancellable* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	GeeArrayList* _tmp18_;
	GFile* _tmp19_;
	GError * _inner_error_;
};

struct _RygelMediaObjectCheckWritableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GFile* file;
	GCancellable* cancellable;
	gboolean result;
	GFile* _tmp0_;
	gboolean _tmp1_;
	GFile* _tmp2_;
	GCancellable* _tmp3_;
	GFileInfo* _tmp4_;
	GFileInfo* info;
	GFileInfo* _tmp5_;
	gboolean _tmp6_;
	GError* _error_;
	GError * _inner_error_;
};


static gpointer rygel_media_object_parent_class = NULL;
static GRegex* rygel_media_object_real_name_regex;
static GRegex* rygel_media_object_real_name_regex = NULL;
static GRegex* rygel_media_object_user_name_regex;
static GRegex* rygel_media_object_user_name_regex = NULL;
static GRegex* rygel_media_object_host_name_regex;
static GRegex* rygel_media_object_host_name_regex = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectPrivate))
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY,
	RYGEL_MEDIA_OBJECT_PARENT_REF,
	RYGEL_MEDIA_OBJECT_TITLE,
	RYGEL_MEDIA_OBJECT_OCM_FLAGS,
	RYGEL_MEDIA_OBJECT_RESTRICTED
};
static void rygel_media_object_get_writable_data_free (gpointer _data);
void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_object_get_writable_co (RygelMediaObjectGetWritableData* _data_);
static void rygel_media_object_check_writable (RygelMediaObject* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_object_check_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static void rygel_media_object_get_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_media_object_get_writables_data_free (gpointer _data);
void rygel_media_object_get_writables (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeeArrayList* rygel_media_object_get_writables_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_object_get_writables_co (RygelMediaObjectGetWritablesData* _data_);
static void rygel_media_object_get_writables_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
static GUPnPDIDLLiteObject* rygel_media_object_real_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static gint rygel_media_object_real_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
gint rygel_media_object_compare_int_props (RygelMediaObject* self, gint prop1, gint prop2);
static void rygel_media_object_check_writable_data_free (gpointer _data);
static gboolean rygel_media_object_check_writable_co (RygelMediaObjectCheckWritableData* _data_);
static void rygel_media_object_check_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
RygelMediaObject* rygel_media_object_construct (GType object_type);
RygelMediaContainer* rygel_media_object_get_parent_ref (RygelMediaObject* self);
void rygel_media_object_set_parent_ref (RygelMediaObject* self, RygelMediaContainer* value);
void rygel_media_object_set_title (RygelMediaObject* self, const gchar* value);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
static GObject * rygel_media_object_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void rygel_media_object_finalize (GObject* obj);
static void _vala_rygel_media_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void rygel_media_object_get_writable_data_free (gpointer _data) {
	RygelMediaObjectGetWritableData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_g_object_unref0 (_data_->cancellable);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_g_object_unref0 (_data_->result);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_slice_free (RygelMediaObjectGetWritableData, _data_);
#line 264 "rygel-media-object.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	return self ? g_object_ref (self) : NULL;
#line 271 "rygel-media-object.c"
}


void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectGetWritableData* _data_;
	RygelMediaObject* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_ = g_slice_new0 (RygelMediaObjectGetWritableData);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_get_writable);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_get_writable_data_free);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp1_ = cancellable;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->cancellable = _tmp2_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	rygel_media_object_get_writable_co (_data_);
#line 298 "rygel-media-object.c"
}


GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error) {
	GFile* result;
	RygelMediaObjectGetWritableData* _data_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		return NULL;
#line 309 "rygel-media-object.c"
	}
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	result = _data_->result;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->result = NULL;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	return result;
#line 319 "rygel-media-object.c"
}


/**
     * Fetches a File object for any writable URI available for this object.
     *
     * @param cancellable A GLib.Cancellable
     */
static void rygel_media_object_get_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectGetWritableData* _data_;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_ = _user_data_;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->_source_object_ = source_object;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->_res_ = _res_;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	rygel_media_object_get_writable_co (_data_);
#line 338 "rygel-media-object.c"
}


static gboolean rygel_media_object_get_writable_co (RygelMediaObjectGetWritableData* _data_) {
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	switch (_data_->_state_) {
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		case 0:
#line 347 "rygel-media-object.c"
		goto _state_0;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		case 1:
#line 351 "rygel-media-object.c"
		goto _state_1;
		default:
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_assert_not_reached ();
#line 356 "rygel-media-object.c"
	}
	_state_0:
	{
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_tmp0_ = _data_->self->uris;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_uri_list = _data_->_tmp1_;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_tmp2_ = _data_->_uri_list;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_tmp3_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp2_);
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_tmp4_ = _data_->_tmp3_;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_uri_size = _data_->_tmp4_;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_uri_index = -1;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		while (TRUE) {
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp5_ = _data_->_uri_index;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_uri_index = _data_->_tmp5_ + 1;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp6_ = _data_->_uri_index;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp7_ = _data_->_uri_size;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			if (!(_data_->_tmp6_ < _data_->_tmp7_)) {
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				break;
#line 390 "rygel-media-object.c"
			}
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp8_ = _data_->_uri_list;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp9_ = _data_->_uri_index;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp10_ = NULL;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp8_, _data_->_tmp9_);
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->uri = (gchar*) _data_->_tmp10_;
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp11_ = _data_->uri;
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp12_ = NULL;
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp12_ = g_file_new_for_uri (_data_->_tmp11_);
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->file = _data_->_tmp12_;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp13_ = _data_->file;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp14_ = _data_->cancellable;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_state_ = 1;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			rygel_media_object_check_writable (_data_->self, _data_->_tmp13_, _data_->_tmp14_, rygel_media_object_get_writable_ready, _data_);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			return FALSE;
#line 420 "rygel-media-object.c"
			_state_1:
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp15_ = FALSE;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp15_ = rygel_media_object_check_writable_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp16_ = _data_->_tmp15_;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			if (_data_->_inner_error_ != NULL) {
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				g_error_free (_data_->_inner_error_);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_g_object_unref0 (_data_->file);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_g_free0 (_data_->uri);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_g_object_unref0 (_data_->_uri_list);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				if (_data_->_state_ == 0) {
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 444 "rygel-media-object.c"
				} else {
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 448 "rygel-media-object.c"
				}
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				g_object_unref (_data_->_async_result);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				return FALSE;
#line 454 "rygel-media-object.c"
			}
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			if (_data_->_tmp16_) {
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_data_->result = _data_->file;
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_g_free0 (_data_->uri);
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_g_object_unref0 (_data_->_uri_list);
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				if (_data_->_state_ == 0) {
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 468 "rygel-media-object.c"
				} else {
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 472 "rygel-media-object.c"
				}
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				g_object_unref (_data_->_async_result);
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				return FALSE;
#line 478 "rygel-media-object.c"
			}
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_g_object_unref0 (_data_->file);
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_g_free0 (_data_->uri);
#line 484 "rygel-media-object.c"
		}
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_g_object_unref0 (_data_->_uri_list);
#line 488 "rygel-media-object.c"
	}
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->result = NULL;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 496 "rygel-media-object.c"
	} else {
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 500 "rygel-media-object.c"
	}
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	return FALSE;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 510 "rygel-media-object.c"
	} else {
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 514 "rygel-media-object.c"
	}
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	return FALSE;
#line 520 "rygel-media-object.c"
}


static void rygel_media_object_get_writables_data_free (gpointer _data) {
	RygelMediaObjectGetWritablesData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_g_object_unref0 (_data_->cancellable);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_g_object_unref0 (_data_->result);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_slice_free (RygelMediaObjectGetWritablesData, _data_);
#line 535 "rygel-media-object.c"
}


void rygel_media_object_get_writables (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectGetWritablesData* _data_;
	RygelMediaObject* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_ = g_slice_new0 (RygelMediaObjectGetWritablesData);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_get_writables);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_get_writables_data_free);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp1_ = cancellable;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->cancellable = _tmp2_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	rygel_media_object_get_writables_co (_data_);
#line 562 "rygel-media-object.c"
}


GeeArrayList* rygel_media_object_get_writables_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error) {
	GeeArrayList* result;
	RygelMediaObjectGetWritablesData* _data_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		return NULL;
#line 573 "rygel-media-object.c"
	}
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	result = _data_->result;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->result = NULL;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	return result;
#line 583 "rygel-media-object.c"
}


/**
     * Fetches File objects for all writable URIs available for this object.
     *
     * @param cancellable A GLib.Cancellable
     */
static void rygel_media_object_get_writables_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectGetWritablesData* _data_;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_ = _user_data_;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->_source_object_ = source_object;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->_res_ = _res_;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	rygel_media_object_get_writables_co (_data_);
#line 602 "rygel-media-object.c"
}


static gboolean rygel_media_object_get_writables_co (RygelMediaObjectGetWritablesData* _data_) {
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	switch (_data_->_state_) {
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		case 0:
#line 611 "rygel-media-object.c"
		goto _state_0;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		case 1:
#line 615 "rygel-media-object.c"
		goto _state_1;
		default:
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_assert_not_reached ();
#line 620 "rygel-media-object.c"
	}
	_state_0:
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->_tmp0_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->writables = _data_->_tmp0_;
#line 627 "rygel-media-object.c"
	{
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_tmp1_ = _data_->self->uris;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_uri_list = _data_->_tmp2_;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_tmp3_ = _data_->_uri_list;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_tmp4_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp3_);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_uri_size = _data_->_tmp5_;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_uri_index = -1;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		while (TRUE) {
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp6_ = _data_->_uri_index;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_uri_index = _data_->_tmp6_ + 1;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp7_ = _data_->_uri_index;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp8_ = _data_->_uri_size;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				break;
#line 659 "rygel-media-object.c"
			}
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp9_ = _data_->_uri_list;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp10_ = _data_->_uri_index;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp11_ = NULL;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp9_, _data_->_tmp10_);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->uri = (gchar*) _data_->_tmp11_;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp12_ = _data_->uri;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp13_ = NULL;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp13_ = g_file_new_for_uri (_data_->_tmp12_);
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->file = _data_->_tmp13_;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp14_ = _data_->file;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp15_ = _data_->cancellable;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_state_ = 1;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			rygel_media_object_check_writable (_data_->self, _data_->_tmp14_, _data_->_tmp15_, rygel_media_object_get_writables_ready, _data_);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			return FALSE;
#line 689 "rygel-media-object.c"
			_state_1:
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp16_ = FALSE;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp16_ = rygel_media_object_check_writable_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_data_->_tmp17_ = _data_->_tmp16_;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			if (_data_->_inner_error_ != NULL) {
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				g_error_free (_data_->_inner_error_);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_g_object_unref0 (_data_->file);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_g_free0 (_data_->uri);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_g_object_unref0 (_data_->_uri_list);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_g_object_unref0 (_data_->writables);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				if (_data_->_state_ == 0) {
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 715 "rygel-media-object.c"
				} else {
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 719 "rygel-media-object.c"
				}
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				g_object_unref (_data_->_async_result);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				return FALSE;
#line 725 "rygel-media-object.c"
			}
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			if (_data_->_tmp17_) {
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_data_->_tmp18_ = _data_->writables;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_data_->_tmp19_ = _data_->file;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp18_, _data_->_tmp19_);
#line 735 "rygel-media-object.c"
			}
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_g_object_unref0 (_data_->file);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_g_free0 (_data_->uri);
#line 741 "rygel-media-object.c"
		}
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_g_object_unref0 (_data_->_uri_list);
#line 745 "rygel-media-object.c"
	}
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->result = _data_->writables;
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 753 "rygel-media-object.c"
	} else {
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 757 "rygel-media-object.c"
	}
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	return FALSE;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_g_object_unref0 (_data_->writables);
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 769 "rygel-media-object.c"
	} else {
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 773 "rygel-media-object.c"
	}
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	return FALSE;
#line 779 "rygel-media-object.c"
}


static GUPnPDIDLLiteObject* rygel_media_object_real_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error) {
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_media_object_serialize'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	return NULL;
#line 790 "rygel-media-object.c"
}


GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error) {
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->serialize (self, writer, http_server, error);
#line 797 "rygel-media-object.c"
}


static gint rygel_media_object_real_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property) {
	gint result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	static GQuark _tmp2_label0 = 0;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	static GQuark _tmp2_label1 = 0;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	static GQuark _tmp2_label2 = 0;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	static GQuark _tmp2_label3 = 0;
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_return_val_if_fail (media_object != NULL, 0);
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_return_val_if_fail (property != NULL, 0);
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp0_ = property;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp1_ = _tmp0_;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("@id")))) {
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		switch (0) {
#line 830 "rygel-media-object.c"
			default:
			{
				const gchar* _tmp4_;
				RygelMediaObject* _tmp5_;
				const gchar* _tmp6_;
				gint _tmp7_ = 0;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_tmp4_ = self->id;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_tmp5_ = media_object;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_tmp6_ = _tmp5_->id;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_tmp7_ = rygel_media_object_compare_string_props (self, _tmp4_, _tmp6_);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				result = _tmp7_;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				return result;
#line 849 "rygel-media-object.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("@parentID")))) {
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		switch (0) {
#line 855 "rygel-media-object.c"
			default:
			{
				RygelMediaContainer* _tmp8_;
				const gchar* _tmp9_;
				RygelMediaObject* _tmp10_;
				RygelMediaContainer* _tmp11_;
				const gchar* _tmp12_;
				gint _tmp13_ = 0;
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_tmp8_ = self->parent;
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_tmp9_ = ((RygelMediaObject*) _tmp8_)->id;
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_tmp10_ = media_object;
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_tmp11_ = _tmp10_->parent;
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_tmp12_ = ((RygelMediaObject*) _tmp11_)->id;
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_tmp13_ = rygel_media_object_compare_string_props (self, _tmp9_, _tmp12_);
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				result = _tmp13_;
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				return result;
#line 880 "rygel-media-object.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("dc:title")))) {
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		switch (0) {
#line 886 "rygel-media-object.c"
			default:
			{
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				RygelMediaObject* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				gint _tmp19_ = 0;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_tmp14_ = rygel_media_object_get_title (self);
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_tmp15_ = _tmp14_;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_tmp16_ = media_object;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_tmp17_ = rygel_media_object_get_title (_tmp16_);
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_tmp18_ = _tmp17_;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_tmp19_ = rygel_media_object_compare_string_props (self, _tmp15_, _tmp18_);
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				result = _tmp19_;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				return result;
#line 911 "rygel-media-object.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("upnp:class")))) {
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		switch (0) {
#line 917 "rygel-media-object.c"
			default:
			{
				const gchar* _tmp20_;
				RygelMediaObject* _tmp21_;
				const gchar* _tmp22_;
				gint _tmp23_ = 0;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_tmp20_ = self->upnp_class;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_tmp21_ = media_object;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_tmp22_ = _tmp21_->upnp_class;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				_tmp23_ = rygel_media_object_compare_string_props (self, _tmp20_, _tmp22_);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				result = _tmp23_;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				return result;
#line 936 "rygel-media-object.c"
			}
		}
	} else {
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		switch (0) {
#line 942 "rygel-media-object.c"
			default:
			{
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				result = 0;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
				return result;
#line 949 "rygel-media-object.c"
			}
		}
	}
}


gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property) {
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->compare_by_property (self, media_object, property);
#line 959 "rygel-media-object.c"
}


gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2) {
	gint result = 0;
	const gchar* _tmp0_;
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_return_val_if_fail (prop1 != NULL, 0);
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_return_val_if_fail (prop2 != NULL, 0);
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp0_ = prop1;
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	if (_tmp0_ == NULL) {
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		result = -1;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		return result;
#line 980 "rygel-media-object.c"
	} else {
		const gchar* _tmp1_;
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp1_ = prop2;
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		if (_tmp1_ == NULL) {
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			result = 1;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			return result;
#line 991 "rygel-media-object.c"
		} else {
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			gint _tmp4_ = 0;
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_tmp2_ = prop1;
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_tmp3_ = prop2;
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			_tmp4_ = g_utf8_collate (_tmp2_, _tmp3_);
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			result = _tmp4_;
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			return result;
#line 1006 "rygel-media-object.c"
		}
	}
}


gint rygel_media_object_compare_int_props (RygelMediaObject* self, gint prop1, gint prop2) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_ = 0;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp0_ = prop1;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp1_ = prop2;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp2_ = CLAMP (_tmp0_ - _tmp1_, -1, 1);
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	result = _tmp2_;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	return result;
#line 1029 "rygel-media-object.c"
}


static void rygel_media_object_check_writable_data_free (gpointer _data) {
	RygelMediaObjectCheckWritableData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_g_object_unref0 (_data_->file);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_g_object_unref0 (_data_->cancellable);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_slice_free (RygelMediaObjectCheckWritableData, _data_);
#line 1044 "rygel-media-object.c"
}


static void rygel_media_object_check_writable (RygelMediaObject* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectCheckWritableData* _data_;
	RygelMediaObject* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_ = g_slice_new0 (RygelMediaObjectCheckWritableData);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_check_writable);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_check_writable_data_free);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp1_ = file;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->file = _tmp2_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp3_ = cancellable;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->cancellable = _tmp4_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	rygel_media_object_check_writable_co (_data_);
#line 1079 "rygel-media-object.c"
}


static gboolean rygel_media_object_check_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	RygelMediaObjectCheckWritableData* _data_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		return FALSE;
#line 1090 "rygel-media-object.c"
	}
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	result = _data_->result;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	return result;
#line 1098 "rygel-media-object.c"
}


static void rygel_media_object_check_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectCheckWritableData* _data_;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_ = _user_data_;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->_source_object_ = source_object;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->_res_ = _res_;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	rygel_media_object_check_writable_co (_data_);
#line 1112 "rygel-media-object.c"
}


static gboolean rygel_media_object_check_writable_co (RygelMediaObjectCheckWritableData* _data_) {
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	switch (_data_->_state_) {
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		case 0:
#line 1121 "rygel-media-object.c"
		goto _state_0;
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		case 1:
#line 1125 "rygel-media-object.c"
		goto _state_1;
		default:
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_assert_not_reached ();
#line 1130 "rygel-media-object.c"
	}
	_state_0:
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->_tmp0_ = _data_->file;
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->_tmp1_ = FALSE;
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_data_->_tmp1_ = g_file_is_native (_data_->_tmp0_);
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	if (!_data_->_tmp1_) {
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->result = FALSE;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		if (_data_->_state_ == 0) {
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1147 "rygel-media-object.c"
		} else {
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1151 "rygel-media-object.c"
		}
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_object_unref (_data_->_async_result);
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		return FALSE;
#line 1157 "rygel-media-object.c"
	}
	{
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_tmp2_ = _data_->file;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_tmp3_ = _data_->cancellable;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_state_ = 1;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_file_query_info_async (_data_->_tmp2_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->_tmp3_, rygel_media_object_check_writable_ready, _data_);
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		return FALSE;
#line 1170 "rygel-media-object.c"
		_state_1:
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_tmp4_ = NULL;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_tmp4_ = g_file_query_info_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->info = _data_->_tmp4_;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		if (_data_->_inner_error_ != NULL) {
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
#line 1182 "rygel-media-object.c"
				goto __catch46_g_io_error_not_found;
			}
			goto __finally46;
		}
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_tmp5_ = _data_->info;
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_tmp6_ = FALSE;
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_tmp6_ = g_file_info_get_attribute_boolean (_data_->_tmp5_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE);
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->result = _data_->_tmp6_;
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_g_object_unref0 (_data_->info);
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		if (_data_->_state_ == 0) {
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1201 "rygel-media-object.c"
		} else {
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1205 "rygel-media-object.c"
		}
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_object_unref (_data_->_async_result);
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		return FALSE;
#line 1211 "rygel-media-object.c"
	}
	goto __finally46;
	__catch46_g_io_error_not_found:
	{
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->_inner_error_ = NULL;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_data_->result = TRUE;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_g_error_free0 (_data_->_error_);
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		if (_data_->_state_ == 0) {
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1228 "rygel-media-object.c"
		} else {
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1232 "rygel-media-object.c"
		}
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_object_unref (_data_->_async_result);
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		return FALSE;
#line 1238 "rygel-media-object.c"
	}
	__finally46:
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_error_free (_data_->_inner_error_);
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1249 "rygel-media-object.c"
	} else {
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1253 "rygel-media-object.c"
	}
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	return FALSE;
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1263 "rygel-media-object.c"
	} else {
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1267 "rygel-media-object.c"
	}
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	return FALSE;
#line 1273 "rygel-media-object.c"
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject * self = NULL;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	self = (RygelMediaObject*) g_object_new (object_type, NULL);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	return self;
#line 1283 "rygel-media-object.c"
}


RygelMediaContainer* rygel_media_object_get_parent_ref (RygelMediaObject* self) {
	RygelMediaContainer* result;
	RygelMediaContainer* _tmp0_;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp0_ = self->priv->_parent_ref;
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	result = _tmp0_;
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	return result;
#line 1298 "rygel-media-object.c"
}


void rygel_media_object_set_parent_ref (RygelMediaObject* self, RygelMediaContainer* value) {
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelMediaContainer* _tmp2_;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp0_ = value;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	self->parent = _tmp0_;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp1_ = value;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_g_object_unref0 (self->priv->_parent_ref);
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	self->priv->_parent_ref = _tmp2_;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "parent-ref");
#line 1322 "rygel-media-object.c"
}


const gchar* rygel_media_object_get_title (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp0_ = self->priv->_title;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	result = _tmp0_;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	return result;
#line 1337 "rygel-media-object.c"
}


void rygel_media_object_set_title (RygelMediaObject* self, const gchar* value) {
	GError * _inner_error_ = NULL;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 1345 "rygel-media-object.c"
	{
		GRegex* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		GRegex* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp0_ = rygel_media_object_real_name_regex;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp1_ = value;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp2_ = g_get_real_name ();
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp3_ = g_regex_replace_literal (_tmp0_, _tmp1_, (gssize) (-1), 0, _tmp2_, 0, &_inner_error_);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp4_ = _tmp3_;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		if (_inner_error_ != NULL) {
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1376 "rygel-media-object.c"
				goto __catch47_g_regex_error;
			}
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			g_clear_error (&_inner_error_);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			return;
#line 1385 "rygel-media-object.c"
		}
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_g_free0 (self->priv->_title);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		self->priv->_title = _tmp4_;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp5_ = rygel_media_object_user_name_regex;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp6_ = self->priv->_title;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp7_ = g_get_user_name ();
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp8_ = g_regex_replace_literal (_tmp5_, _tmp6_, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp9_ = _tmp8_;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		if (_inner_error_ != NULL) {
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1405 "rygel-media-object.c"
				goto __catch47_g_regex_error;
			}
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			g_clear_error (&_inner_error_);
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			return;
#line 1414 "rygel-media-object.c"
		}
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_g_free0 (self->priv->_title);
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		self->priv->_title = _tmp9_;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp10_ = rygel_media_object_host_name_regex;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp11_ = self->priv->_title;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp12_ = g_get_host_name ();
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp13_ = g_regex_replace_literal (_tmp10_, _tmp11_, (gssize) (-1), 0, _tmp12_, 0, &_inner_error_);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp14_ = _tmp13_;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		if (_inner_error_ != NULL) {
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1434 "rygel-media-object.c"
				goto __catch47_g_regex_error;
			}
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			g_clear_error (&_inner_error_);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			return;
#line 1443 "rygel-media-object.c"
		}
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_g_free0 (self->priv->_title);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		self->priv->_title = _tmp14_;
#line 1449 "rygel-media-object.c"
	}
	goto __finally47;
	__catch47_g_regex_error:
	{
		GError* err = NULL;
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		err = _inner_error_;
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_inner_error_ = NULL;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_assert_not_reached ();
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_g_error_free0 (err);
#line 1463 "rygel-media-object.c"
	}
	__finally47:
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	if (_inner_error_ != NULL) {
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_clear_error (&_inner_error_);
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		return;
#line 1474 "rygel-media-object.c"
	}
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "title");
#line 1478 "rygel-media-object.c"
}


GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self) {
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->get_ocm_flags (self);
#line 1485 "rygel-media-object.c"
}


gboolean rygel_media_object_get_restricted (RygelMediaObject* self) {
	gboolean result;
	GUPnPOCMFlags _tmp0_;
	GUPnPOCMFlags _tmp1_;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp0_ = rygel_media_object_get_ocm_flags (self);
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp1_ = _tmp0_;
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	result = _tmp1_ == GUPNP_OCM_FLAGS_NONE;
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	return result;
#line 1503 "rygel-media-object.c"
}


static GObject * rygel_media_object_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RygelMediaObject * self;
	GeeArrayList* _tmp0_;
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	parent_class = G_OBJECT_CLASS (rygel_media_object_parent_class);
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	self = RYGEL_MEDIA_OBJECT (obj);
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_g_object_unref0 (self->uris);
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	self->uris = _tmp0_;
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	return obj;
#line 1526 "rygel-media-object.c"
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
	GError * _inner_error_ = NULL;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaObjectPrivate));
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_media_object_real_serialize;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->compare_by_property = rygel_media_object_real_compare_by_property;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_object_get_property;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_object_set_property;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	G_OBJECT_CLASS (klass)->constructor = rygel_media_object_constructor;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_PARENT_REF, g_param_spec_object ("parent-ref", "parent-ref", "parent-ref", RYGEL_TYPE_MEDIA_CONTAINER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_OCM_FLAGS, g_param_spec_flags ("ocm-flags", "ocm-flags", "ocm-flags", GUPNP_TYPE_OCM_FLAGS, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_RESTRICTED, g_param_spec_boolean ("restricted", "restricted", "restricted", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1556 "rygel-media-object.c"
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		GRegex* _tmp7_;
		GRegex* _tmp8_;
		GRegex* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		GRegex* _tmp12_;
		GRegex* _tmp13_;
		GRegex* _tmp14_;
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp0_ = g_regex_escape_string ("@REALNAME@", -1);
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp1_ = _tmp0_;
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp3_ = _tmp2_;
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_g_free0 (_tmp1_);
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp4_ = _tmp3_;
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		if (_inner_error_ != NULL) {
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1589 "rygel-media-object.c"
				goto __catch48_g_regex_error;
			}
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			g_clear_error (&_inner_error_);
#line 1596 "rygel-media-object.c"
		}
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_g_regex_unref0 (rygel_media_object_real_name_regex);
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		rygel_media_object_real_name_regex = _tmp4_;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp5_ = g_regex_escape_string ("@USERNAME@", -1);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp6_ = _tmp5_;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp7_ = g_regex_new (_tmp6_, 0, 0, &_inner_error_);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp8_ = _tmp7_;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_g_free0 (_tmp6_);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp9_ = _tmp8_;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		if (_inner_error_ != NULL) {
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1618 "rygel-media-object.c"
				goto __catch48_g_regex_error;
			}
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			g_clear_error (&_inner_error_);
#line 1625 "rygel-media-object.c"
		}
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_g_regex_unref0 (rygel_media_object_user_name_regex);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		rygel_media_object_user_name_regex = _tmp9_;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp10_ = g_regex_escape_string ("@HOSTNAME@", -1);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp11_ = _tmp10_;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp12_ = g_regex_new (_tmp11_, 0, 0, &_inner_error_);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp13_ = _tmp12_;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_g_free0 (_tmp11_);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_tmp14_ = _tmp13_;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		if (_inner_error_ != NULL) {
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1647 "rygel-media-object.c"
				goto __catch48_g_regex_error;
			}
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
			g_clear_error (&_inner_error_);
#line 1654 "rygel-media-object.c"
		}
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_g_regex_unref0 (rygel_media_object_host_name_regex);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		rygel_media_object_host_name_regex = _tmp14_;
#line 1660 "rygel-media-object.c"
	}
	goto __finally48;
	__catch48_g_regex_error:
	{
		GError* err = NULL;
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		err = _inner_error_;
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_inner_error_ = NULL;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_assert_not_reached ();
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		_g_error_free0 (err);
#line 1674 "rygel-media-object.c"
	}
	__finally48:
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	if (_inner_error_ != NULL) {
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_clear_error (&_inner_error_);
#line 1683 "rygel-media-object.c"
	}
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	self->priv = RYGEL_MEDIA_OBJECT_GET_PRIVATE (self);
#line 1691 "rygel-media-object.c"
}


static void rygel_media_object_finalize (GObject* obj) {
	RygelMediaObject * self;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	self = RYGEL_MEDIA_OBJECT (obj);
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_g_free0 (self->id);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_g_free0 (self->ref_id);
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_g_free0 (self->upnp_class);
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_g_object_unref0 (self->uris);
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_g_object_unref0 (self->priv->_parent_ref);
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	_g_free0 (self->priv->_title);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	G_OBJECT_CLASS (rygel_media_object_parent_class)->finalize (obj);
#line 1713 "rygel-media-object.c"
}


/**
 * Represents a media object (container and item).
 */
GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, NULL };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaObject", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


static void _vala_rygel_media_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaObject * self;
	self = RYGEL_MEDIA_OBJECT (object);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	switch (property_id) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_PARENT_REF:
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_value_set_object (value, rygel_media_object_get_parent_ref (self));
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_TITLE:
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_value_set_string (value, rygel_media_object_get_title (self));
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_RESTRICTED:
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		g_value_set_boolean (value, rygel_media_object_get_restricted (self));
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		break;
#line 1755 "rygel-media-object.c"
		default:
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		break;
#line 1761 "rygel-media-object.c"
	}
}


static void _vala_rygel_media_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaObject * self;
	self = RYGEL_MEDIA_OBJECT (object);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
	switch (property_id) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_PARENT_REF:
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		rygel_media_object_set_parent_ref (self, g_value_get_object (value));
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_TITLE:
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		rygel_media_object_set_title (self, g_value_get_string (value));
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		break;
#line 1783 "rygel-media-object.c"
		default:
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-object.vala"
		break;
#line 1789 "rygel-media-object.c"
	}
}



