/* rygel-http-post-test.c generated by valac 0.14.0, the Vala compiler
 * generated from rygel-http-post-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <libsoup/soup.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_HTTP_POST_TEST (rygel_http_post_test_get_type ())
#define RYGEL_HTTP_POST_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_POST_TEST, RygelHTTPPostTest))
#define RYGEL_HTTP_POST_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_POST_TEST, RygelHTTPPostTestClass))
#define RYGEL_IS_HTTP_POST_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_POST_TEST))
#define RYGEL_IS_HTTP_POST_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_POST_TEST))
#define RYGEL_HTTP_POST_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_POST_TEST, RygelHTTPPostTestClass))

typedef struct _RygelHTTPPostTest RygelHTTPPostTest;
typedef struct _RygelHTTPPostTestClass RygelHTTPPostTestClass;
typedef struct _RygelHTTPPostTestPrivate RygelHTTPPostTestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_CLIENT (rygel_http_client_get_type ())
#define RYGEL_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient))
#define RYGEL_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))
#define RYGEL_IS_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_IS_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_HTTP_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))

typedef struct _RygelHTTPClient RygelHTTPClient;
typedef struct _RygelHTTPClientClass RygelHTTPClientClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_POST (rygel_http_post_get_type ())
#define RYGEL_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPost))
#define RYGEL_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))
#define RYGEL_IS_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_POST))
#define RYGEL_IS_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_POST))
#define RYGEL_HTTP_POST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))

typedef struct _RygelHTTPPost RygelHTTPPost;
typedef struct _RygelHTTPPostClass RygelHTTPPostClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelHttpPostTestHandleClientMessageData RygelHttpPostTestHandleClientMessageData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelHTTPClientPrivate RygelHTTPClientPrivate;
typedef struct _RygelHttpPostTestCheckAndExitData RygelHttpPostTestCheckAndExitData;
typedef struct _Block1Data Block1Data;
typedef struct _RygelHttpClientRunData RygelHttpClientRunData;
typedef struct _Block2Data Block2Data;
typedef struct _RygelMediaContainerFindObjectData RygelMediaContainerFindObjectData;
typedef struct _Block3Data Block3Data;
typedef struct _RygelMediaItemGetWritableData RygelMediaItemGetWritableData;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;
typedef struct _Block4Data Block4Data;
typedef struct _RygelHttpResponseRunData RygelHttpResponseRunData;

#define RYGEL_TYPE_ITEM_REMOVAL_QUEUE (rygel_item_removal_queue_get_type ())
#define RYGEL_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueue))
#define RYGEL_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_ITEM_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))

typedef struct _RygelItemRemovalQueue RygelItemRemovalQueue;
typedef struct _RygelItemRemovalQueueClass RygelItemRemovalQueueClass;
typedef struct _RygelItemRemovalQueuePrivate RygelItemRemovalQueuePrivate;
typedef struct _RygelItemRemovalQueueRemoveNowData RygelItemRemovalQueueRemoveNowData;

typedef enum  {
	RYGEL_TEST_ERROR_SKIP = 77,
	RYGEL_TEST_ERROR_TIMEOUT
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelHTTPPostTest {
	GObject parent_instance;
	RygelHTTPPostTestPrivate * priv;
	RygelHTTPServer* server;
	RygelHTTPClient* client;
};

struct _RygelHTTPPostTestClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPPostTest* self, GError** error);
};

struct _RygelHTTPPostTestPrivate {
	gboolean server_done;
	gboolean client_done;
	GMainLoop* main_loop;
	GError* error;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHttpPostTestHandleClientMessageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPostTest* self;
	SoupMessage* msg;
	SoupMessage* _tmp0_;
	RygelHTTPRequest* _tmp1_;
	RygelHTTPRequest* request;
	RygelHTTPRequest* _tmp2_;
	RygelHTTPRequest* _tmp3_;
	RygelMediaItem* _tmp4_;
	GError* _error_;
	GError* _tmp5_;
	GError* _tmp6_;
	GMainLoop* _tmp7_;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gchar* id;
	RygelMediaItem* item;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	RygelMediaContainer* parent;
	gchar* id;
	glong size;
	glong duration;
	gboolean place_holder;
	GFile* file;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelHTTPClient {
	GObject parent_instance;
	RygelHTTPClientPrivate * priv;
	guint8* content;
	gint content_length1;
	GUPnPContext* context;
	SoupMessage* msg;
};

struct _RygelHTTPClientClass {
	GObjectClass parent_class;
};

struct _RygelHttpPostTestCheckAndExitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPostTest* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	RygelHTTPServer* _tmp4_;
	RygelMediaContainer* _tmp5_;
	RygelMediaItem* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFile* file;
	GFile* _tmp9_;
	GFileInputStream* _tmp10_;
	GFileInputStream* stream;
	guint8* _tmp11_;
	guint8* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	GFileInputStream* _tmp12_;
	guint8* _tmp13_;
	gint _tmp13__length1;
	gint i;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	guint8* _tmp18_;
	gint _tmp18__length1;
	gint _tmp19_;
	guint8 _tmp20_;
	RygelHTTPClient* _tmp21_;
	guint8* _tmp22_;
	gint _tmp22__length1;
	gint _tmp23_;
	guint8 _tmp24_;
	GError* _error_;
	GError* _tmp25_;
	GError* _tmp26_;
	GMainLoop* _tmp27_;
	GError * _inner_error_;
};

struct _RygelHTTPClientPrivate {
	GCancellable* _cancellable;
};

struct _Block1Data {
	int _ref_count_;
	RygelHTTPClient * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpClientRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPClient* self;
	Block1Data* _data1_;
	SoupMessage* _tmp0_;
	SoupMessageBody* _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	GUPnPContext* _tmp3_;
	SoupSession* _tmp4_;
	SoupSession* _tmp5_;
	SoupMessage* _tmp6_;
	SoupMessage* _tmp7_;
};

struct _RygelMediaContainerPrivate {
	GFileMonitor* monitor;
};

struct _Block2Data {
	int _ref_count_;
	RygelMediaContainer * self;
	GSourceFunc find_object_continue;
	gpointer find_object_continue_target;
	GDestroyNotify find_object_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelMediaContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaContainer* self;
	gchar* item_id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	Block2Data* _data2_;
	const gchar* _tmp0_;
	RygelMediaItem* _tmp1_;
	RygelMediaObject* _tmp2_;
};

struct _Block3Data {
	int _ref_count_;
	RygelMediaItem * self;
	GSourceFunc get_writable_continue;
	gpointer get_writable_continue_target;
	GDestroyNotify get_writable_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelMediaItemGetWritableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaItem* self;
	GCancellable* cancellable;
	GFile* result;
	Block3Data* _data3_;
	GFile* _tmp0_;
	GFile* _tmp1_;
};

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
};

struct _RygelHTTPResponsePrivate {
	GCancellable* _cancellable;
	SoupMessage* msg;
	SoupServer* server;
};

struct _Block4Data {
	int _ref_count_;
	RygelHTTPResponse * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpResponseRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPResponse* self;
	Block4Data* _data4_;
	SoupMessage* _tmp0_;
	SoupServer* _tmp1_;
	SoupMessage* _tmp2_;
};

struct _RygelItemRemovalQueue {
	GObject parent_instance;
	RygelItemRemovalQueuePrivate * priv;
};

struct _RygelItemRemovalQueueClass {
	GObjectClass parent_class;
};

struct _RygelItemRemovalQueueRemoveNowData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemRemovalQueue* self;
	RygelMediaItem* item;
	GCancellable* cancellable;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()

static gpointer rygel_http_post_test_parent_class = NULL;
static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_http_client_parent_class = NULL;
static RygelStateMachineIface* rygel_http_client_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_media_container_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_http_response_parent_class = NULL;
static RygelStateMachineIface* rygel_http_response_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_item_removal_queue_parent_class = NULL;
static gpointer rygel_media_object_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GType rygel_http_post_test_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_client_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_POST_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_POST_TEST, RygelHTTPPostTestPrivate))
enum  {
	RYGEL_HTTP_POST_TEST_DUMMY_PROPERTY
};
gint rygel_http_post_test_main (gchar** args, int args_length1);
RygelHTTPPostTest* rygel_http_post_test_new (GError** error);
RygelHTTPPostTest* rygel_http_post_test_construct (GType object_type, GError** error);
void rygel_http_post_test_run (RygelHTTPPostTest* self, GError** error);
RygelHTTPServer* rygel_http_server_new (GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gchar* rygel_http_server_get_uri (RygelHTTPServer* self);
RygelHTTPClient* rygel_http_client_new (GUPnPContext* context, const gchar* uri);
RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context, const gchar* uri);
static void rygel_http_post_test_real_run (RygelHTTPPostTest* self, GError** error);
#define RYGEL_MEDIA_ITEM_URI "file:///tmp/rygel-upload-test.wav"
static gboolean rygel_http_post_test_on_timeout (RygelHTTPPostTest* self);
static gboolean _rygel_http_post_test_on_timeout_gsource_func (gpointer self);
static void rygel_http_post_test_on_message_received (RygelHTTPPostTest* self, RygelHTTPServer* server, SoupMessage* msg);
static void _rygel_http_post_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
static void rygel_http_post_test_on_client_completed (RygelHTTPPostTest* self, RygelStateMachine* client);
static void _rygel_http_post_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
GType rygel_http_request_get_type (void) G_GNUC_CONST;
static RygelHTTPRequest* rygel_http_post_test_create_request (RygelHTTPPostTest* self, SoupMessage* msg, GError** error);
RygelHTTPPost* rygel_http_post_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPPost* rygel_http_post_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GType rygel_http_post_get_type (void) G_GNUC_CONST;
static void rygel_http_post_test_check_and_exit (RygelHTTPPostTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_test_check_and_exit_finish (RygelHTTPPostTest* self, GAsyncResult* _res_);
static void rygel_http_post_test_handle_client_message (RygelHTTPPostTest* self, SoupMessage* msg, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_test_handle_client_message_finish (RygelHTTPPostTest* self, GAsyncResult* _res_);
static void rygel_http_post_test_handle_client_message_data_free (gpointer _data);
static gboolean rygel_http_post_test_handle_client_message_co (RygelHttpPostTestHandleClientMessageData* _data_);
static void rygel_http_post_test_handle_client_message_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
static void rygel_http_post_test_check_and_exit_data_free (gpointer _data);
static gboolean rygel_http_post_test_check_and_exit_co (RygelHttpPostTestCheckAndExitData* _data_);
static void rygel_http_post_test_check_and_exit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
#define RYGEL_HTTP_CLIENT_LENGTH ((gsize) 1024)
static void rygel_http_post_test_finalize (GObject* obj);
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_PATH_ROOT,
	RYGEL_HTTP_SERVER_URI
};
#define RYGEL_HTTP_SERVER_SERVER_PATH "/RygelHTTPServer/Rygel/Test"
static void rygel_http_server_on_request_started (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, SoupClientContext* client);
static void _rygel_http_server_on_request_started_soup_server_request_started (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self);
RygelMediaContainer* rygel_media_container_new (void);
RygelMediaContainer* rygel_media_container_construct (GType object_type);
static void rygel_http_server_on_got_headers (RygelHTTPServer* self, SoupMessage* msg);
static void _rygel_http_server_on_got_headers_soup_message_got_headers (SoupMessage* _sender, gpointer self);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
#define RYGEL_MEDIA_CONTAINER_ITEM_ID "TestItem"
RygelHTTPItemURI* rygel_http_item_uri_new (const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static void rygel_http_server_finalize (GObject* obj);
static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define RYGEL_HTTP_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientPrivate))
enum  {
	RYGEL_HTTP_CLIENT_DUMMY_PROPERTY,
	RYGEL_HTTP_CLIENT_CANCELLABLE
};
static void rygel_http_client_real_run_data_free (gpointer _data);
static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self);
static void __lambda2_ (Block1Data* _data1_, SoupSession* session, SoupMessage* msg);
static void ___lambda2__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void rygel_http_client_finalize (GObject* obj);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define RYGEL_MEDIA_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerPrivate))
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY
};
RygelMediaObject* rygel_media_object_new (void);
RygelMediaObject* rygel_media_object_construct (GType object_type);
RygelMediaItem* rygel_media_item_new (const gchar* id, RygelMediaContainer* parent);
RygelMediaItem* rygel_media_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent);
void rygel_media_container_on_file_changed (RygelMediaContainer* self, GFileMonitor* monitor, GFile* file, GFile* other_file, GFileMonitorEvent event_type);
static void _rygel_media_container_on_file_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static void rygel_media_container_find_object_data_free (gpointer _data);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean _rygel_media_container_find_object_co_gsource_func (gpointer self);
static gboolean __lambda1_ (Block2Data* _data2_);
static gboolean ___lambda1__gsource_func (gpointer self);
static void rygel_media_container_finalize (GObject* obj);
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
static void rygel_media_item_get_writable_data_free (gpointer _data);
void rygel_media_item_get_writable (RygelMediaItem* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_item_get_writable_finish (RygelMediaItem* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_item_get_writable_co (RygelMediaItemGetWritableData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static gboolean _rygel_media_item_get_writable_co_gsource_func (gpointer self);
static gboolean __lambda0_ (Block3Data* _data3_);
static gboolean ___lambda0__gsource_func (gpointer self);
static void rygel_media_item_finalize (GObject* obj);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponsePrivate))
enum  {
	RYGEL_HTTP_RESPONSE_DUMMY_PROPERTY,
	RYGEL_HTTP_RESPONSE_CANCELLABLE
};
RygelHTTPResponse* rygel_http_response_new (RygelHTTPPost* get_request);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPPost* get_request);
static void rygel_http_response_real_run_data_free (gpointer _data);
static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self);
static gboolean __lambda5_ (Block4Data* _data4_);
static gboolean ___lambda5__gsource_func (gpointer self);
static void rygel_http_response_finalize (GObject* obj);
static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType rygel_item_removal_queue_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_ITEM_REMOVAL_QUEUE_DUMMY_PROPERTY
};
RygelItemRemovalQueue* rygel_item_removal_queue_get_default (void);
RygelItemRemovalQueue* rygel_item_removal_queue_new (void);
RygelItemRemovalQueue* rygel_item_removal_queue_construct (GType object_type);
gboolean rygel_item_removal_queue_dequeue (RygelItemRemovalQueue* self, RygelMediaItem* item);
static void rygel_item_removal_queue_remove_now_data_free (gpointer _data);
void rygel_item_removal_queue_remove_now (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_item_removal_queue_remove_now_finish (RygelItemRemovalQueue* self, GAsyncResult* _res_);
static gboolean rygel_item_removal_queue_remove_now_co (RygelItemRemovalQueueRemoveNowData* _data_);
static gboolean _rygel_item_removal_queue_remove_now_co_gsource_func (gpointer self);
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY
};
GQuark rygel_content_directory_error_quark (void);


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


gint rygel_http_post_test_main (gchar** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		RygelHTTPPostTest* _tmp0_;
		RygelHTTPPostTest* test;
		RygelHTTPPostTest* _tmp1_;
#line 45 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_tmp0_ = rygel_http_post_test_new (&_inner_error_);
#line 45 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		test = _tmp0_;
#line 45 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		if (_inner_error_ != NULL) {
#line 45 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 686 "rygel-http-post-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 47 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_tmp1_ = test;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		rygel_http_post_test_run (_tmp1_, &_inner_error_);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		if (_inner_error_ != NULL) {
#line 47 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			_g_object_unref0 (test);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 701 "rygel-http-post-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 44 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_g_object_unref0 (test);
#line 708 "rygel-http-post-test.c"
	}
	goto __finally0;
	__catch0_rygel_test_error_skip:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		gint _tmp3_;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_error_ = _inner_error_;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_inner_error_ = NULL;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_tmp2_ = _error_;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_tmp3_ = _tmp2_->code;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		result = _tmp3_;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_g_error_free0 (_error_);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		return result;
#line 730 "rygel-http-post-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_error_ = _inner_error_;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_inner_error_ = NULL;
#line 51 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_tmp4_ = _error_;
#line 51 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_tmp5_ = _tmp4_->message;
#line 51 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_critical ("rygel-http-post-test.vala:51: %s", _tmp5_);
#line 53 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		result = -1;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_g_error_free0 (_error_);
#line 53 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		return result;
#line 754 "rygel-http-post-test.c"
	}
	__finally0:
#line 44 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (_inner_error_ != NULL) {
#line 44 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_clear_error (&_inner_error_);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		return 0;
#line 765 "rygel-http-post-test.c"
	}
#line 56 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	result = 0;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 771 "rygel-http-post-test.c"
}


int main (int argc, char ** argv) {
#line 43 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_thread_init (NULL);
#line 43 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_type_init ();
#line 43 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return rygel_http_post_test_main (argv, argc);
#line 782 "rygel-http-post-test.c"
}


RygelHTTPPostTest* rygel_http_post_test_construct (GType object_type, GError** error) {
	RygelHTTPPostTest * self = NULL;
	RygelHTTPServer* _tmp0_;
	RygelHTTPServer* _tmp1_;
	RygelHTTPServer* _tmp2_;
	GUPnPContext* _tmp3_;
	RygelHTTPServer* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	RygelHTTPClient* _tmp8_;
	GMainLoop* _tmp9_;
	GError * _inner_error_ = NULL;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = (RygelHTTPPostTest*) g_object_new (object_type, NULL);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = rygel_http_server_new (&_inner_error_);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp1_ = _tmp0_;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (_inner_error_ != NULL) {
#line 60 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_propagate_error (error, _inner_error_);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_g_object_unref0 (self);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		return NULL;
#line 813 "rygel-http-post-test.c"
	}
#line 60 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->server);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->server = _tmp1_;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp2_ = self->server;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp3_ = _tmp2_->context;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp4_ = self->server;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp5_ = rygel_http_server_get_uri (_tmp4_);
#line 61 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp6_ = _tmp5_;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp7_ = _tmp6_;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp8_ = rygel_http_client_new (_tmp3_, _tmp7_);
#line 61 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->client);
#line 61 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->client = _tmp8_;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_free0 (_tmp7_);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp9_ = g_main_loop_new (NULL, FALSE);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_main_loop_unref0 (self->priv->main_loop);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->priv->main_loop = _tmp9_;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return self;
#line 847 "rygel-http-post-test.c"
}


RygelHTTPPostTest* rygel_http_post_test_new (GError** error) {
#line 59 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return rygel_http_post_test_construct (RYGEL_TYPE_HTTP_POST_TEST, error);
#line 854 "rygel-http-post-test.c"
}


static gboolean _rygel_http_post_test_on_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_post_test_on_timeout (self);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 863 "rygel-http-post-test.c"
}


static void _rygel_http_post_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self) {
#line 71 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_http_post_test_on_message_received (self, _sender, message);
#line 870 "rygel-http-post-test.c"
}


static void _rygel_http_post_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 72 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_http_post_test_on_client_completed (self, _sender);
#line 877 "rygel-http-post-test.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 79 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return self ? g_error_copy (self) : NULL;
#line 884 "rygel-http-post-test.c"
}


static void rygel_http_post_test_real_run (RygelHTTPPostTest* self, GError** error) {
	GFile* _tmp0_ = NULL;
	GFile* file;
	GFile* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	RygelHTTPServer* _tmp4_;
	RygelHTTPClient* _tmp5_;
	RygelHTTPClient* _tmp6_;
	GMainLoop* _tmp7_;
	GError* _tmp8_;
	GError * _inner_error_ = NULL;
#line 68 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = g_file_new_for_uri (RYGEL_MEDIA_ITEM_URI);
#line 68 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	file = _tmp0_;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp1_ = file;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp2_ = g_file_get_path (_tmp1_);
#line 69 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp3_ = _tmp2_;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_remove (_tmp3_);
#line 69 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_free0 (_tmp3_);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, _rygel_http_post_test_on_timeout_gsource_func, g_object_ref (self), g_object_unref);
#line 71 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp4_ = self->server;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_signal_connect_object (_tmp4_, "message-received", (GCallback) _rygel_http_post_test_on_message_received_rygel_http_server_message_received, self, 0);
#line 72 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp5_ = self->client;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_signal_connect_object ((RygelStateMachine*) _tmp5_, "completed", (GCallback) _rygel_http_post_test_on_client_completed_rygel_state_machine_completed, self, 0);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp6_ = self->client;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_state_machine_run ((RygelStateMachine*) _tmp6_, NULL, NULL);
#line 76 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp7_ = self->priv->main_loop;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_main_loop_run (_tmp7_);
#line 78 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp8_ = self->priv->error;
#line 78 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (_tmp8_ != NULL) {
#line 936 "rygel-http-post-test.c"
		GError* _tmp9_;
		GError* _tmp10_;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_tmp9_ = self->priv->error;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_tmp10_ = _g_error_copy0 (_tmp9_);
#line 79 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_inner_error_ = _tmp10_;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_propagate_error (error, _inner_error_);
#line 79 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_g_object_unref0 (file);
#line 79 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		return;
#line 951 "rygel-http-post-test.c"
	}
#line 66 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (file);
#line 955 "rygel-http-post-test.c"
}


void rygel_http_post_test_run (RygelHTTPPostTest* self, GError** error) {
#line 66 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_if_fail (self != NULL);
#line 66 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	RYGEL_HTTP_POST_TEST_GET_CLASS (self)->run (self, error);
#line 964 "rygel-http-post-test.c"
}


static RygelHTTPRequest* rygel_http_post_test_create_request (RygelHTTPPostTest* self, SoupMessage* msg, GError** error) {
	RygelHTTPRequest* result = NULL;
	RygelHTTPServer* _tmp0_;
	RygelHTTPServer* _tmp1_;
	GUPnPContext* _tmp2_;
	SoupServer* _tmp3_;
	SoupServer* _tmp4_;
	SoupMessage* _tmp5_;
	RygelHTTPPost* _tmp6_;
#line 83 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 83 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = self->server;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp1_ = self->server;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp2_ = _tmp1_->context;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp3_ = gupnp_context_get_server (_tmp2_);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp4_ = _tmp3_;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp5_ = msg;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp6_ = rygel_http_post_new (_tmp0_, _tmp4_, _tmp5_);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	result = (RygelHTTPRequest*) _tmp6_;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 999 "rygel-http-post-test.c"
}


static void rygel_http_post_test_on_client_completed (RygelHTTPPostTest* self, RygelStateMachine* client) {
#line 89 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_if_fail (self != NULL);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_if_fail (client != NULL);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->priv->client_done = TRUE;
#line 91 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_http_post_test_check_and_exit (self, NULL, NULL);
#line 1012 "rygel-http-post-test.c"
}


static void rygel_http_post_test_on_message_received (RygelHTTPPostTest* self, RygelHTTPServer* server, SoupMessage* msg) {
	SoupMessage* _tmp0_;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_if_fail (self != NULL);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_if_fail (server != NULL);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_if_fail (msg != NULL);
#line 96 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = msg;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_http_post_test_handle_client_message (self, _tmp0_, NULL, NULL);
#line 1028 "rygel-http-post-test.c"
}


static void rygel_http_post_test_handle_client_message_data_free (gpointer _data) {
	RygelHttpPostTestHandleClientMessageData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (_data_->msg);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_slice_free (RygelHttpPostTestHandleClientMessageData, _data_);
#line 1041 "rygel-http-post-test.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 1048 "rygel-http-post-test.c"
}


static void rygel_http_post_test_handle_client_message (RygelHTTPPostTest* self, SoupMessage* msg, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostTestHandleClientMessageData* _data_;
	RygelHTTPPostTest* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_ = g_slice_new0 (RygelHttpPostTestHandleClientMessageData);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_test_handle_client_message);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_test_handle_client_message_data_free);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp1_ = msg;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->msg = _tmp2_;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_http_post_test_handle_client_message_co (_data_);
#line 1075 "rygel-http-post-test.c"
}


static void rygel_http_post_test_handle_client_message_finish (RygelHTTPPostTest* self, GAsyncResult* _res_) {
	RygelHttpPostTestHandleClientMessageData* _data_;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1083 "rygel-http-post-test.c"
}


static void rygel_http_post_test_handle_client_message_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostTestHandleClientMessageData* _data_;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_ = _user_data_;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_source_object_ = source_object;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_res_ = _res_;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_http_post_test_handle_client_message_co (_data_);
#line 1097 "rygel-http-post-test.c"
}


static gboolean rygel_http_post_test_handle_client_message_co (RygelHttpPostTestHandleClientMessageData* _data_) {
#line 99 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	switch (_data_->_state_) {
#line 99 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case 0:
#line 1106 "rygel-http-post-test.c"
		goto _state_0;
#line 99 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case 1:
#line 1110 "rygel-http-post-test.c"
		goto _state_1;
		default:
#line 99 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_assert_not_reached ();
#line 1115 "rygel-http-post-test.c"
	}
	_state_0:
	{
#line 101 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp0_ = _data_->msg;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp1_ = NULL;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp1_ = rygel_http_post_test_create_request (_data_->self, _data_->_tmp0_, &_data_->_inner_error_);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->request = _data_->_tmp1_;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1129 "rygel-http-post-test.c"
			goto __catch1_g_error;
		}
#line 103 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp2_ = _data_->request;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_state_ = 1;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		rygel_state_machine_run ((RygelStateMachine*) _data_->_tmp2_, rygel_http_post_test_handle_client_message_ready, _data_);
#line 103 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		return FALSE;
#line 1140 "rygel-http-post-test.c"
		_state_1:
#line 103 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		rygel_state_machine_run_finish ((RygelStateMachine*) _data_->_tmp2_, _data_->_res_);
#line 105 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp3_ = _data_->request;
#line 105 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp4_ = ((RygelHTTPRequest*) (RYGEL_IS_HTTP_POST (_data_->_tmp3_) ? ((RygelHTTPPost*) _data_->_tmp3_) : NULL))->item;
#line 105 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_assert (_data_->_tmp4_ != NULL);
#line 107 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->self->priv->server_done = TRUE;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		rygel_http_post_test_check_and_exit (_data_->self, NULL, NULL);
#line 100 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_g_object_unref0 (_data_->request);
#line 1156 "rygel-http-post-test.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 100 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_inner_error_ = NULL;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp5_ = _data_->_error_;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp6_ = _g_error_copy0 (_data_->_tmp5_);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_g_error_free0 (_data_->self->priv->error);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->self->priv->error = _data_->_tmp6_;
#line 111 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp7_ = _data_->self->priv->main_loop;
#line 111 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_main_loop_quit (_data_->_tmp7_);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_g_error_free0 (_data_->_error_);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		if (_data_->_state_ == 0) {
#line 113 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1183 "rygel-http-post-test.c"
		} else {
#line 113 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1187 "rygel-http-post-test.c"
		}
#line 113 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_object_unref (_data_->_async_result);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		return FALSE;
#line 1193 "rygel-http-post-test.c"
	}
	__finally1:
#line 100 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (_data_->_inner_error_ != NULL) {
#line 100 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 100 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_clear_error (&_data_->_inner_error_);
#line 100 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		return FALSE;
#line 1204 "rygel-http-post-test.c"
	}
#line 99 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (_data_->_state_ == 0) {
#line 99 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1210 "rygel-http-post-test.c"
	} else {
#line 99 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1214 "rygel-http-post-test.c"
	}
#line 99 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_object_unref (_data_->_async_result);
#line 99 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return FALSE;
#line 1220 "rygel-http-post-test.c"
}


static gboolean rygel_http_post_test_on_timeout (RygelHTTPPostTest* self) {
	gboolean result = FALSE;
	GError* _tmp0_;
	GMainLoop* _tmp1_;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_TIMEOUT, "Timeout");
#line 118 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_error_free0 (self->priv->error);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->priv->error = _tmp0_;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp1_ = self->priv->main_loop;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_main_loop_quit (_tmp1_);
#line 121 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	result = FALSE;
#line 121 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 1244 "rygel-http-post-test.c"
}


static void rygel_http_post_test_check_and_exit_data_free (gpointer _data) {
	RygelHttpPostTestCheckAndExitData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_slice_free (RygelHttpPostTestCheckAndExitData, _data_);
#line 1255 "rygel-http-post-test.c"
}


static void rygel_http_post_test_check_and_exit (RygelHTTPPostTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostTestCheckAndExitData* _data_;
	RygelHTTPPostTest* _tmp0_;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_ = g_slice_new0 (RygelHttpPostTestCheckAndExitData);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_test_check_and_exit);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_test_check_and_exit_data_free);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_http_post_test_check_and_exit_co (_data_);
#line 1274 "rygel-http-post-test.c"
}


static void rygel_http_post_test_check_and_exit_finish (RygelHTTPPostTest* self, GAsyncResult* _res_) {
	RygelHttpPostTestCheckAndExitData* _data_;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1282 "rygel-http-post-test.c"
}


static void rygel_http_post_test_check_and_exit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostTestCheckAndExitData* _data_;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_ = _user_data_;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_source_object_ = source_object;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_res_ = _res_;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_http_post_test_check_and_exit_co (_data_);
#line 1296 "rygel-http-post-test.c"
}


static gboolean rygel_http_post_test_check_and_exit_co (RygelHttpPostTestCheckAndExitData* _data_) {
#line 124 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	switch (_data_->_state_) {
#line 124 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case 0:
#line 1305 "rygel-http-post-test.c"
		goto _state_0;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case 1:
#line 1309 "rygel-http-post-test.c"
		goto _state_1;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case 2:
#line 1313 "rygel-http-post-test.c"
		goto _state_2;
		default:
#line 124 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_assert_not_reached ();
#line 1318 "rygel-http-post-test.c"
	}
	_state_0:
#line 125 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_tmp1_ = _data_->self->priv->server_done;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (_data_->_tmp1_) {
#line 125 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp2_ = _data_->self->priv->client_done;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp0_ = _data_->_tmp2_;
#line 1329 "rygel-http-post-test.c"
	} else {
#line 125 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp0_ = FALSE;
#line 1333 "rygel-http-post-test.c"
	}
#line 125 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_tmp3_ = _data_->_tmp0_;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (!_data_->_tmp3_) {
#line 126 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		if (_data_->_state_ == 0) {
#line 126 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1343 "rygel-http-post-test.c"
		} else {
#line 126 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1347 "rygel-http-post-test.c"
		}
#line 126 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_object_unref (_data_->_async_result);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		return FALSE;
#line 1353 "rygel-http-post-test.c"
	}
	{
#line 130 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp4_ = _data_->self->server;
#line 130 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp5_ = _data_->_tmp4_->root_container;
#line 130 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp6_ = _data_->_tmp5_->item;
#line 130 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp7_ = _data_->_tmp6_->file;
#line 130 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp8_ = _g_object_ref0 (_data_->_tmp7_);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->file = _data_->_tmp8_;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp9_ = _data_->file;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_state_ = 1;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_file_read_async (_data_->_tmp9_, G_PRIORITY_HIGH, NULL, rygel_http_post_test_check_and_exit_ready, _data_);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		return FALSE;
#line 1376 "rygel-http-post-test.c"
		_state_1:
#line 131 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp10_ = NULL;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp10_ = g_file_read_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error_);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->stream = _data_->_tmp10_;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		if (_data_->_inner_error_ != NULL) {
#line 131 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			_g_object_unref0 (_data_->file);
#line 1388 "rygel-http-post-test.c"
			goto __catch2_g_error;
		}
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp11_ = NULL;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp11_ = g_new0 (guint8, RYGEL_HTTP_CLIENT_LENGTH);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->buffer = _data_->_tmp11_;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->buffer_length1 = RYGEL_HTTP_CLIENT_LENGTH;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_buffer_size_ = _data_->buffer_length1;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp12_ = _data_->stream;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp13_ = _data_->buffer;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp13__length1 = _data_->buffer_length1;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_state_ = 2;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_input_stream_read_async ((GInputStream*) _data_->_tmp12_, _data_->_tmp13_, (gsize) _data_->_tmp13__length1, G_PRIORITY_HIGH, NULL, rygel_http_post_test_check_and_exit_ready, _data_);
#line 134 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		return FALSE;
#line 1413 "rygel-http-post-test.c"
		_state_2:
#line 134 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_input_stream_read_finish ((GInputStream*) _data_->_tmp12_, _data_->_res_, &_data_->_inner_error_);
#line 134 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		if (_data_->_inner_error_ != NULL) {
#line 134 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			_data_->buffer = (g_free (_data_->buffer), NULL);
#line 134 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			_g_object_unref0 (_data_->stream);
#line 134 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			_g_object_unref0 (_data_->file);
#line 1425 "rygel-http-post-test.c"
			goto __catch2_g_error;
		}
		{
#line 136 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			_data_->i = 0;
#line 1431 "rygel-http-post-test.c"
			{
#line 136 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
				_data_->_tmp14_ = TRUE;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
				while (TRUE) {
#line 136 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
					_data_->_tmp15_ = _data_->_tmp14_;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
					if (!_data_->_tmp15_) {
#line 136 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
						_data_->_tmp16_ = _data_->i;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
						_data_->i = _data_->_tmp16_ + 1;
#line 1445 "rygel-http-post-test.c"
					}
#line 136 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
					_data_->_tmp14_ = FALSE;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
					_data_->_tmp17_ = _data_->i;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
					if (!(((gsize) _data_->_tmp17_) < RYGEL_HTTP_CLIENT_LENGTH)) {
#line 136 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
						break;
#line 1455 "rygel-http-post-test.c"
					}
#line 137 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
					_data_->_tmp18_ = _data_->buffer;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
					_data_->_tmp18__length1 = _data_->buffer_length1;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
					_data_->_tmp19_ = _data_->i;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
					_data_->_tmp20_ = _data_->_tmp18_[_data_->_tmp19_];
#line 137 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
					_data_->_tmp21_ = _data_->self->client;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
					_data_->_tmp22_ = _data_->_tmp21_->content;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
					_data_->_tmp22__length1 = _data_->_tmp21_->content_length1;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
					_data_->_tmp23_ = _data_->i;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
					_data_->_tmp24_ = _data_->_tmp22_[_data_->_tmp23_];
#line 137 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
					g_assert (_data_->_tmp20_ == _data_->_tmp24_);
#line 1477 "rygel-http-post-test.c"
				}
			}
		}
#line 129 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->buffer = (g_free (_data_->buffer), NULL);
#line 129 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_g_object_unref0 (_data_->stream);
#line 129 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_g_object_unref0 (_data_->file);
#line 1487 "rygel-http-post-test.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
#line 129 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 129 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_inner_error_ = NULL;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp25_ = _data_->_error_;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp26_ = _g_error_copy0 (_data_->_tmp25_);
#line 140 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_g_error_free0 (_data_->self->priv->error);
#line 140 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->self->priv->error = _data_->_tmp26_;
#line 129 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_g_error_free0 (_data_->_error_);
#line 1506 "rygel-http-post-test.c"
	}
	__finally2:
#line 129 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (_data_->_inner_error_ != NULL) {
#line 129 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 129 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_clear_error (&_data_->_inner_error_);
#line 129 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		return FALSE;
#line 1517 "rygel-http-post-test.c"
	}
#line 143 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_tmp27_ = _data_->self->priv->main_loop;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_main_loop_quit (_data_->_tmp27_);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (_data_->_state_ == 0) {
#line 124 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1527 "rygel-http-post-test.c"
	} else {
#line 124 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1531 "rygel-http-post-test.c"
	}
#line 124 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_object_unref (_data_->_async_result);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return FALSE;
#line 1537 "rygel-http-post-test.c"
}


static void rygel_http_post_test_class_init (RygelHTTPPostTestClass * klass) {
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_http_post_test_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPPostTestPrivate));
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	RYGEL_HTTP_POST_TEST_CLASS (klass)->run = rygel_http_post_test_real_run;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_post_test_finalize;
#line 1550 "rygel-http-post-test.c"
}


static void rygel_http_post_test_instance_init (RygelHTTPPostTest * self) {
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->priv = RYGEL_HTTP_POST_TEST_GET_PRIVATE (self);
#line 1557 "rygel-http-post-test.c"
}


static void rygel_http_post_test_finalize (GObject* obj) {
	RygelHTTPPostTest * self;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = RYGEL_HTTP_POST_TEST (obj);
#line 33 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->server);
#line 34 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->client);
#line 39 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_main_loop_unref0 (self->priv->main_loop);
#line 41 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_error_free0 (self->priv->error);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	G_OBJECT_CLASS (rygel_http_post_test_parent_class)->finalize (obj);
#line 1575 "rygel-http-post-test.c"
}


GType rygel_http_post_test_get_type (void) {
	static volatile gsize rygel_http_post_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_post_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPPostTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_post_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPPostTest), 0, (GInstanceInitFunc) rygel_http_post_test_instance_init, NULL };
		GType rygel_http_post_test_type_id;
		rygel_http_post_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPPostTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_post_test_type_id__volatile, rygel_http_post_test_type_id);
	}
	return rygel_http_post_test_type_id__volatile;
}


static void _rygel_http_server_on_request_started_soup_server_request_started (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self) {
#line 180 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_http_server_on_request_started (self, _sender, msg, client);
#line 1594 "rygel-http-post-test.c"
}


RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error) {
	RygelHTTPServer * self = NULL;
	GUPnPContext* _tmp3_;
	GUPnPContext* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GUPnPContext* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	GUPnPContext* _tmp10_;
	SoupServer* _tmp11_;
	SoupServer* _tmp12_;
	RygelMediaContainer* _tmp13_;
	GError * _inner_error_ = NULL;
#line 169 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
#line 1614 "rygel-http-post-test.c"
	{
		GUPnPContext* _tmp0_;
		GUPnPContext* _tmp1_;
#line 171 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_tmp0_ = gupnp_context_new (NULL, "lo", (guint) 0, &_inner_error_);
#line 171 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_tmp1_ = _tmp0_;
#line 171 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		if (_inner_error_ != NULL) {
#line 1624 "rygel-http-post-test.c"
			goto __catch3_g_error;
		}
#line 171 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_g_object_unref0 (self->context);
#line 171 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		self->context = _tmp1_;
#line 1631 "rygel-http-post-test.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
#line 170 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_error_ = _inner_error_;
#line 170 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_inner_error_ = NULL;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_tmp2_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP, "Network context not available");
#line 173 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_inner_error_ = _tmp2_;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_g_error_free0 (_error_);
#line 1648 "rygel-http-post-test.c"
		goto __finally3;
	}
	__finally3:
#line 170 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (_inner_error_ != NULL) {
#line 170 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
#line 170 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			g_propagate_error (error, _inner_error_);
#line 170 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			_g_object_unref0 (self);
#line 170 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			return NULL;
#line 1662 "rygel-http-post-test.c"
		} else {
#line 170 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 170 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			g_clear_error (&_inner_error_);
#line 170 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			return NULL;
#line 1670 "rygel-http-post-test.c"
		}
	}
#line 176 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp3_ = self->context;
#line 176 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_assert (_tmp3_ != NULL);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp4_ = self->context;
#line 177 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp5_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp4_);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp6_ = _tmp5_;
#line 177 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_assert (_tmp6_ != NULL);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp7_ = self->context;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp8_ = gupnp_context_get_port (_tmp7_);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp9_ = _tmp8_;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_assert (_tmp9_ > ((guint) 0));
#line 180 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp10_ = self->context;
#line 180 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp11_ = gupnp_context_get_server (_tmp10_);
#line 180 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp12_ = _tmp11_;
#line 180 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_signal_connect_object (_tmp12_, "request-started", (GCallback) _rygel_http_server_on_request_started_soup_server_request_started, self, 0);
#line 182 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp13_ = rygel_media_container_new ();
#line 182 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->root_container);
#line 182 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->root_container = _tmp13_;
#line 169 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return self;
#line 1709 "rygel-http-post-test.c"
}


RygelHTTPServer* rygel_http_server_new (GError** error) {
#line 169 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, error);
#line 1716 "rygel-http-post-test.c"
}


static void _rygel_http_server_on_got_headers_soup_message_got_headers (SoupMessage* _sender, gpointer self) {
#line 188 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_http_server_on_got_headers (self, _sender);
#line 1723 "rygel-http-post-test.c"
}


static void rygel_http_server_on_request_started (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, SoupClientContext* client) {
	SoupMessage* _tmp0_;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_if_fail (self != NULL);
#line 185 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_if_fail (server != NULL);
#line 185 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_if_fail (msg != NULL);
#line 185 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_if_fail (client != NULL);
#line 188 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = msg;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_signal_connect_object (_tmp0_, "got-headers", (GCallback) _rygel_http_server_on_got_headers_soup_message_got_headers, self, 0);
#line 1741 "rygel-http-post-test.c"
}


static void rygel_http_server_on_got_headers (RygelHTTPServer* self, SoupMessage* msg) {
	SoupMessage* _tmp0_;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_if_fail (self != NULL);
#line 191 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_if_fail (msg != NULL);
#line 192 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = msg;
#line 192 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_signal_emit_by_name (self, "message-received", _tmp0_);
#line 1755 "rygel-http-post-test.c"
}


const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self) {
	const gchar* result;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	result = RYGEL_HTTP_SERVER_SERVER_PATH;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 1767 "rygel-http-post-test.c"
}


gchar* rygel_http_server_get_uri (RygelHTTPServer* self) {
	gchar* result;
	RygelMediaContainer* _tmp0_;
	RygelHTTPItemURI* _tmp1_;
	RygelHTTPItemURI* item_uri;
	gchar* _tmp2_ = NULL;
#line 159 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = self->root_container;
#line 160 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp1_ = rygel_http_item_uri_new (RYGEL_MEDIA_CONTAINER_ITEM_ID, self, -1, -1, NULL);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	item_uri = _tmp1_;
#line 163 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp2_ = rygel_http_item_uri_to_string (item_uri);
#line 163 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	result = _tmp2_;
#line 163 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (item_uri);
#line 163 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 1793 "rygel-http-post-test.c"
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
#line 147 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_server_get_property;
#line 147 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
#line 147 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_PATH_ROOT, g_param_spec_string ("path-root", "path-root", "path-root", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 147 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 147 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_signal_new ("message_received", RYGEL_TYPE_HTTP_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, soup_message_get_type ());
#line 1810 "rygel-http-post-test.c"
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
#line 147 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = RYGEL_HTTP_SERVER (obj);
#line 155 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->root_container);
#line 156 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->context);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
#line 1828 "rygel-http-post-test.c"
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	switch (property_id) {
#line 147 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case RYGEL_HTTP_SERVER_PATH_ROOT:
#line 147 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_value_set_string (value, rygel_http_server_get_path_root (self));
#line 147 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		break;
#line 147 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case RYGEL_HTTP_SERVER_URI:
#line 147 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_value_take_string (value, rygel_http_server_get_uri (self));
#line 147 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		break;
#line 1861 "rygel-http-post-test.c"
		default:
#line 147 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		break;
#line 1867 "rygel-http-post-test.c"
	}
}


RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context, const gchar* uri) {
	RygelHTTPClient * self = NULL;
	GUPnPContext* _tmp0_;
	GUPnPContext* _tmp1_;
	guint8* _tmp2_ = NULL;
	const gchar* _tmp3_;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = (RygelHTTPClient*) g_object_new (object_type, NULL);
#line 208 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = context;
#line 208 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 208 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->context);
#line 208 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->context = _tmp1_;
#line 209 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp2_ = g_new0 (guint8, 1024);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->content = (g_free (self->content), NULL);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->content = _tmp2_;
#line 209 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->content_length1 = 1024;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp3_ = uri;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp4_ = soup_message_new ("POST", _tmp3_);
#line 211 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->msg);
#line 211 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->msg = _tmp4_;
#line 212 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp5_ = self->msg;
#line 212 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_assert (_tmp5_ != NULL);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return self;
#line 1916 "rygel-http-post-test.c"
}


RygelHTTPClient* rygel_http_client_new (GUPnPContext* context, const gchar* uri) {
#line 206 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return rygel_http_client_construct (RYGEL_TYPE_HTTP_CLIENT, context, uri);
#line 1923 "rygel-http-post-test.c"
}


static void rygel_http_client_real_run_data_free (gpointer _data) {
	RygelHttpClientRunData* _data_;
	_data_ = _data;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (_data_->self);
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_slice_free (RygelHttpClientRunData, _data_);
#line 1934 "rygel-http-post-test.c"
}


static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPClient * self;
	RygelHttpClientRunData* _data_;
	RygelHTTPClient* _tmp0_;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = (RygelHTTPClient*) base;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_ = g_slice_new0 (RygelHttpClientRunData);
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_client_real_run);
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_client_real_run_data_free);
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->self = _tmp0_;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_http_client_real_run_co (_data_);
#line 1956 "rygel-http-post-test.c"
}


static void rygel_http_client_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpClientRunData* _data_;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1964 "rygel-http-post-test.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return _data1_;
#line 1973 "rygel-http-post-test.c"
}


static void block1_data_unref (Block1Data* _data1_) {
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_g_object_unref0 (_data1_->self);
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		(_data1_->run_continue_target_destroy_notify == NULL) ? NULL : (_data1_->run_continue_target_destroy_notify (_data1_->run_continue_target), NULL);
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data1_->run_continue = NULL;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data1_->run_continue_target = NULL;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data1_->run_continue_target_destroy_notify = NULL;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_slice_free (Block1Data, _data1_);
#line 1992 "rygel-http-post-test.c"
	}
}


static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_client_real_run_co (self);
#line 216 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 2002 "rygel-http-post-test.c"
}


static void __lambda2_ (Block1Data* _data1_, SoupSession* session, SoupMessage* msg) {
	RygelHTTPClient * self;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = _data1_->self;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_if_fail (session != NULL);
#line 220 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_if_fail (msg != NULL);
#line 221 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data1_->run_continue (_data1_->run_continue_target);
#line 2016 "rygel-http-post-test.c"
}


static void ___lambda2__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
#line 220 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	__lambda2_ (self, session, msg);
#line 2023 "rygel-http-post-test.c"
}


static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* _data_) {
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	switch (_data_->_state_) {
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case 0:
#line 2032 "rygel-http-post-test.c"
		goto _state_0;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case 1:
#line 2036 "rygel-http-post-test.c"
		goto _state_1;
		default:
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_assert_not_reached ();
#line 2041 "rygel-http-post-test.c"
	}
	_state_0:
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data1_->self = g_object_ref (_data_->self);
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 216 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data1_->run_continue = _rygel_http_client_real_run_co_gsource_func;
#line 216 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data1_->run_continue_target = _data_;
#line 216 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data1_->run_continue_target_destroy_notify = NULL;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_tmp0_ = _data_->self->msg;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_tmp1_ = _data_->_tmp0_->request_body;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_tmp2_ = _data_->self->content;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_tmp2__length1 = _data_->self->content_length1;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	soup_message_body_append (_data_->_tmp1_, SOUP_MEMORY_COPY, _data_->_tmp2_, (gsize) _data_->_tmp2__length1);
#line 220 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_tmp3_ = _data_->self->context;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_tmp4_ = gupnp_context_get_session (_data_->_tmp3_);
#line 220 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_tmp6_ = _data_->self->msg;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_tmp7_ = _g_object_ref0 (_data_->_tmp6_);
#line 220 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	soup_session_queue_message (_data_->_tmp5_, _data_->_tmp7_, ___lambda2__soup_session_callback, _data_->_data1_);
#line 224 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_state_ = 1;
#line 224 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return FALSE;
#line 2084 "rygel-http-post-test.c"
	_state_1:
	;
#line 226 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	block1_data_unref (_data_->_data1_);
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data1_ = NULL;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (_data_->_state_ == 0) {
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2097 "rygel-http-post-test.c"
	} else {
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2101 "rygel-http-post-test.c"
	}
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_object_unref (_data_->_async_result);
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return FALSE;
#line 2107 "rygel-http-post-test.c"
}


static GCancellable* rygel_http_client_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPClient* self;
	GCancellable* _tmp0_;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = (RygelHTTPClient*) base;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = self->priv->_cancellable;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	result = _tmp0_;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 2123 "rygel-http-post-test.c"
}


static void rygel_http_client_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPClient* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = (RygelHTTPClient*) base;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = value;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 204 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 204 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->priv->_cancellable = _tmp1_;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 2143 "rygel-http-post-test.c"
}


static void rygel_http_client_class_init (RygelHTTPClientClass * klass) {
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_http_client_parent_class = g_type_class_peek_parent (klass);
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPClientPrivate));
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_client_get_property;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_client_set_property;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_client_finalize;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_CLIENT_CANCELLABLE, "cancellable");
#line 2160 "rygel-http-post-test.c"
}


static void rygel_http_client_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_http_client_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_client_real_run;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	iface->run_finish = rygel_http_client_real_run_finish;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	iface->get_cancellable = rygel_http_client_real_get_cancellable;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	iface->set_cancellable = rygel_http_client_real_set_cancellable;
#line 2175 "rygel-http-post-test.c"
}


static void rygel_http_client_instance_init (RygelHTTPClient * self) {
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->priv = RYGEL_HTTP_CLIENT_GET_PRIVATE (self);
#line 2182 "rygel-http-post-test.c"
}


static void rygel_http_client_finalize (GObject* obj) {
	RygelHTTPClient * self;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = RYGEL_HTTP_CLIENT (obj);
#line 199 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->content = (g_free (self->content), NULL);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->context);
#line 202 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->msg);
#line 204 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	G_OBJECT_CLASS (rygel_http_client_parent_class)->finalize (obj);
#line 2200 "rygel-http-post-test.c"
}


GType rygel_http_client_get_type (void) {
	static volatile gsize rygel_http_client_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPClient), 0, (GInstanceInitFunc) rygel_http_client_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_client_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_client_type_id;
		rygel_http_client_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPClient", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_client_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_client_type_id__volatile, rygel_http_client_type_id);
	}
	return rygel_http_client_type_id__volatile;
}


static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (object);
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	switch (property_id) {
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		break;
#line 2229 "rygel-http-post-test.c"
		default:
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		break;
#line 2235 "rygel-http-post-test.c"
	}
}


static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (object);
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	switch (property_id) {
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		break;
#line 2251 "rygel-http-post-test.c"
		default:
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 196 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		break;
#line 2257 "rygel-http-post-test.c"
	}
}


static void _rygel_media_container_on_file_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
#line 244 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_media_container_on_file_changed (self, _sender, file, other_file, event_type);
#line 2265 "rygel-http-post-test.c"
}


RygelMediaContainer* rygel_media_container_construct (GType object_type) {
	RygelMediaContainer * self = NULL;
	RygelMediaItem* _tmp0_;
	RygelMediaItem* _tmp1_;
	GFile* _tmp2_;
	GFileMonitor* _tmp3_ = NULL;
	GFileMonitor* _tmp4_;
	GFileMonitor* _tmp5_;
	GError * _inner_error_ = NULL;
#line 240 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = (RygelMediaContainer*) rygel_media_object_construct (object_type);
#line 241 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = rygel_media_item_new (RYGEL_MEDIA_CONTAINER_ITEM_ID, self);
#line 241 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->item);
#line 241 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->item = _tmp0_;
#line 243 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp1_ = self->item;
#line 243 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp2_ = _tmp1_->file;
#line 243 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp3_ = g_file_monitor_file (_tmp2_, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
#line 243 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp4_ = _tmp3_;
#line 243 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (_inner_error_ != NULL) {
#line 243 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 243 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_clear_error (&_inner_error_);
#line 243 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		return NULL;
#line 2302 "rygel-http-post-test.c"
	}
#line 243 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->priv->monitor);
#line 243 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->priv->monitor = _tmp4_;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp5_ = self->priv->monitor;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_signal_connect_object (_tmp5_, "changed", (GCallback) _rygel_media_container_on_file_changed_g_file_monitor_changed, self, 0);
#line 240 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return self;
#line 2314 "rygel-http-post-test.c"
}


RygelMediaContainer* rygel_media_container_new (void) {
#line 240 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return rygel_media_container_construct (RYGEL_TYPE_MEDIA_CONTAINER);
#line 2321 "rygel-http-post-test.c"
}


static void rygel_media_container_find_object_data_free (gpointer _data) {
	RygelMediaContainerFindObjectData* _data_;
	_data_ = _data;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_free0 (_data_->item_id);
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (_data_->cancellable);
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (_data_->result);
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (_data_->self);
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_slice_free (RygelMediaContainerFindObjectData, _data_);
#line 2338 "rygel-http-post-test.c"
}


void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaContainerFindObjectData* _data_;
	RygelMediaContainer* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_ = g_slice_new0 (RygelMediaContainerFindObjectData);
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_container_find_object);
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_container_find_object_data_free);
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->self = _tmp0_;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp1_ = item_id;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->item_id = _tmp2_;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp3_ = cancellable;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->cancellable = _tmp4_;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_media_container_find_object_co (_data_);
#line 2373 "rygel-http-post-test.c"
}


RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaContainerFindObjectData* _data_;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		return NULL;
#line 2384 "rygel-http-post-test.c"
	}
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	result = _data_->result;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->result = NULL;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 2394 "rygel-http-post-test.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return _data2_;
#line 2403 "rygel-http-post-test.c"
}


static void block2_data_unref (Block2Data* _data2_) {
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_g_object_unref0 (_data2_->self);
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		(_data2_->find_object_continue_target_destroy_notify == NULL) ? NULL : (_data2_->find_object_continue_target_destroy_notify (_data2_->find_object_continue_target), NULL);
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data2_->find_object_continue = NULL;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data2_->find_object_continue_target = NULL;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data2_->find_object_continue_target_destroy_notify = NULL;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_slice_free (Block2Data, _data2_);
#line 2422 "rygel-http-post-test.c"
	}
}


static gboolean _rygel_media_container_find_object_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_media_container_find_object_co (self);
#line 250 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 2432 "rygel-http-post-test.c"
}


static gboolean __lambda1_ (Block2Data* _data2_) {
	RygelMediaContainer * self;
	gboolean result = FALSE;
	GSourceFunc _tmp0_;
	void* _tmp0__target;
#line 251 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = _data2_->self;
#line 252 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = _data2_->find_object_continue;
#line 252 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0__target = _data2_->find_object_continue_target;
#line 252 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ (_tmp0__target);
#line 254 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	result = FALSE;
#line 254 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 2453 "rygel-http-post-test.c"
}


static gboolean ___lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda1_ (self);
#line 251 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 2462 "rygel-http-post-test.c"
}


static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* _data_) {
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	switch (_data_->_state_) {
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case 0:
#line 2471 "rygel-http-post-test.c"
		goto _state_0;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case 1:
#line 2475 "rygel-http-post-test.c"
		goto _state_1;
		default:
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_assert_not_reached ();
#line 2480 "rygel-http-post-test.c"
	}
	_state_0:
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data2_->self = g_object_ref (_data_->self);
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 250 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data2_->find_object_continue = _rygel_media_container_find_object_co_gsource_func;
#line 250 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data2_->find_object_continue_target = _data_;
#line 250 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data2_->find_object_continue_target_destroy_notify = NULL;
#line 251 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda1__gsource_func, block2_data_ref (_data_->_data2_), block2_data_unref);
#line 257 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_state_ = 1;
#line 257 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return FALSE;
#line 2503 "rygel-http-post-test.c"
	_state_1:
	;
#line 259 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_tmp0_ = _data_->item_id;
#line 259 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (g_strcmp0 (_data_->_tmp0_, RYGEL_MEDIA_CONTAINER_ITEM_ID) == 0) {
#line 260 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp1_ = _data_->self->item;
#line 260 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_tmp2_ = _g_object_ref0 ((RygelMediaObject*) _data_->_tmp1_);
#line 260 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->result = _data_->_tmp2_;
#line 260 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		block2_data_unref (_data_->_data2_);
#line 260 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_data2_ = NULL;
#line 260 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		if (_data_->_state_ == 0) {
#line 260 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2524 "rygel-http-post-test.c"
		} else {
#line 260 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2528 "rygel-http-post-test.c"
		}
#line 260 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_object_unref (_data_->_async_result);
#line 260 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		return FALSE;
#line 2534 "rygel-http-post-test.c"
	} else {
#line 262 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->result = NULL;
#line 262 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		block2_data_unref (_data_->_data2_);
#line 262 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data_->_data2_ = NULL;
#line 262 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		if (_data_->_state_ == 0) {
#line 262 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2546 "rygel-http-post-test.c"
		} else {
#line 262 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2550 "rygel-http-post-test.c"
		}
#line 262 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_object_unref (_data_->_async_result);
#line 262 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		return FALSE;
#line 2556 "rygel-http-post-test.c"
	}
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	block2_data_unref (_data_->_data2_);
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data2_ = NULL;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (_data_->_state_ == 0) {
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2566 "rygel-http-post-test.c"
	} else {
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2570 "rygel-http-post-test.c"
	}
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_object_unref (_data_->_async_result);
#line 247 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return FALSE;
#line 2576 "rygel-http-post-test.c"
}


void rygel_media_container_on_file_changed (RygelMediaContainer* self, GFileMonitor* monitor, GFile* file, GFile* other_file, GFileMonitorEvent event_type) {
	RygelMediaItem* _tmp0_;
#line 266 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_if_fail (self != NULL);
#line 266 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_if_fail (monitor != NULL);
#line 266 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_if_fail (file != NULL);
#line 270 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = self->item;
#line 270 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_->place_holder = FALSE;
#line 271 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_signal_emit_by_name (self, "container-updated", self);
#line 2594 "rygel-http-post-test.c"
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaContainerPrivate));
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_container_finalize;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_signal_new ("container_updated", RYGEL_TYPE_MEDIA_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_MEDIA_CONTAINER);
#line 2607 "rygel-http-post-test.c"
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
	gchar* _tmp0_;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->priv = RYGEL_MEDIA_CONTAINER_GET_PRIVATE (self);
#line 235 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = g_strdup ("TesContainer");
#line 235 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->id = _tmp0_;
#line 2619 "rygel-http-post-test.c"
}


static void rygel_media_container_finalize (GObject* obj) {
	RygelMediaContainer * self;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = RYGEL_MEDIA_CONTAINER (obj);
#line 235 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_free0 (self->id);
#line 236 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->item);
#line 238 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->priv->monitor);
#line 230 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	G_OBJECT_CLASS (rygel_media_container_parent_class)->finalize (obj);
#line 2635 "rygel-http-post-test.c"
}


GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}


RygelMediaItem* rygel_media_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent) {
	RygelMediaItem * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	RygelMediaContainer* _tmp2_;
	GFile* _tmp3_ = NULL;
#line 288 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 288 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 288 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
#line 289 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = id;
#line 289 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 289 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_free0 (self->id);
#line 289 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->id = _tmp1_;
#line 290 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp2_ = parent;
#line 290 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->parent = _tmp2_;
#line 292 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp3_ = g_file_new_for_uri (RYGEL_MEDIA_ITEM_URI);
#line 292 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->file);
#line 292 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->file = _tmp3_;
#line 288 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return self;
#line 2683 "rygel-http-post-test.c"
}


RygelMediaItem* rygel_media_item_new (const gchar* id, RygelMediaContainer* parent) {
#line 288 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return rygel_media_item_construct (RYGEL_TYPE_MEDIA_ITEM, id, parent);
#line 2690 "rygel-http-post-test.c"
}


static void rygel_media_item_get_writable_data_free (gpointer _data) {
	RygelMediaItemGetWritableData* _data_;
	_data_ = _data;
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (_data_->cancellable);
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (_data_->result);
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (_data_->self);
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_slice_free (RygelMediaItemGetWritableData, _data_);
#line 2705 "rygel-http-post-test.c"
}


void rygel_media_item_get_writable (RygelMediaItem* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaItemGetWritableData* _data_;
	RygelMediaItem* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_ = g_slice_new0 (RygelMediaItemGetWritableData);
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_item_get_writable);
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_item_get_writable_data_free);
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->self = _tmp0_;
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp1_ = cancellable;
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->cancellable = _tmp2_;
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_media_item_get_writable_co (_data_);
#line 2732 "rygel-http-post-test.c"
}


GFile* rygel_media_item_get_writable_finish (RygelMediaItem* self, GAsyncResult* _res_, GError** error) {
	GFile* result;
	RygelMediaItemGetWritableData* _data_;
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		return NULL;
#line 2743 "rygel-http-post-test.c"
	}
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	result = _data_->result;
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->result = NULL;
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 2753 "rygel-http-post-test.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return _data3_;
#line 2762 "rygel-http-post-test.c"
}


static void block3_data_unref (Block3Data* _data3_) {
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_g_object_unref0 (_data3_->self);
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		(_data3_->get_writable_continue_target_destroy_notify == NULL) ? NULL : (_data3_->get_writable_continue_target_destroy_notify (_data3_->get_writable_continue_target), NULL);
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data3_->get_writable_continue = NULL;
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data3_->get_writable_continue_target = NULL;
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data3_->get_writable_continue_target_destroy_notify = NULL;
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_slice_free (Block3Data, _data3_);
#line 2781 "rygel-http-post-test.c"
	}
}


static gboolean _rygel_media_item_get_writable_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_media_item_get_writable_co (self);
#line 304 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 2791 "rygel-http-post-test.c"
}


static gboolean __lambda0_ (Block3Data* _data3_) {
	RygelMediaItem * self;
	gboolean result = FALSE;
#line 306 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = _data3_->self;
#line 307 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data3_->get_writable_continue (_data3_->get_writable_continue_target);
#line 309 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	result = FALSE;
#line 309 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 2806 "rygel-http-post-test.c"
}


static gboolean ___lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda0_ (self);
#line 306 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 2815 "rygel-http-post-test.c"
}


static gboolean rygel_media_item_get_writable_co (RygelMediaItemGetWritableData* _data_) {
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	switch (_data_->_state_) {
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case 0:
#line 2824 "rygel-http-post-test.c"
		goto _state_0;
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case 1:
#line 2828 "rygel-http-post-test.c"
		goto _state_1;
		default:
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_assert_not_reached ();
#line 2833 "rygel-http-post-test.c"
	}
	_state_0:
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data3_ = g_slice_new0 (Block3Data);
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data3_->_ref_count_ = 1;
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data3_->self = g_object_ref (_data_->self);
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data3_->_async_data_ = _data_;
#line 304 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data3_->get_writable_continue = _rygel_media_item_get_writable_co_gsource_func;
#line 304 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data3_->get_writable_continue_target = _data_;
#line 304 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data3_->get_writable_continue_target_destroy_notify = NULL;
#line 306 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda0__gsource_func, block3_data_ref (_data_->_data3_), block3_data_unref);
#line 312 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_state_ = 1;
#line 312 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return FALSE;
#line 2856 "rygel-http-post-test.c"
	_state_1:
	;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_tmp0_ = _data_->self->file;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
#line 314 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->result = _data_->_tmp1_;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	block3_data_unref (_data_->_data3_);
#line 314 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data3_ = NULL;
#line 314 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (_data_->_state_ == 0) {
#line 314 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2873 "rygel-http-post-test.c"
	} else {
#line 314 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2877 "rygel-http-post-test.c"
	}
#line 314 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_object_unref (_data_->_async_result);
#line 314 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return FALSE;
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	block3_data_unref (_data_->_data3_);
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data3_ = NULL;
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (_data_->_state_ == 0) {
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2891 "rygel-http-post-test.c"
	} else {
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2895 "rygel-http-post-test.c"
	}
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_object_unref (_data_->_async_result);
#line 303 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return FALSE;
#line 2901 "rygel-http-post-test.c"
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
#line 2910 "rygel-http-post-test.c"
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
#line 281 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->size = (glong) 1024;
#line 282 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->duration = (glong) 1024;
#line 284 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->place_holder = TRUE;
#line 2921 "rygel-http-post-test.c"
}


static void rygel_media_item_finalize (GObject* obj) {
	RygelMediaItem * self;
	GError * _inner_error_ = NULL;
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = RYGEL_MEDIA_ITEM (obj);
#line 2930 "rygel-http-post-test.c"
	{
		GFile* _tmp0_;
#line 297 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_tmp0_ = self->file;
#line 297 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_file_delete (_tmp0_, NULL, &_inner_error_);
#line 297 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		if (_inner_error_ != NULL) {
#line 2939 "rygel-http-post-test.c"
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
#line 296 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_error_ = _inner_error_;
#line 296 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_inner_error_ = NULL;
#line 299 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_assert_not_reached ();
#line 296 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_g_error_free0 (_error_);
#line 2955 "rygel-http-post-test.c"
	}
	__finally4:
#line 296 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (_inner_error_ != NULL) {
#line 296 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 296 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_clear_error (&_inner_error_);
#line 2964 "rygel-http-post-test.c"
	}
#line 280 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_free0 (self->id);
#line 286 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->file);
#line 275 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
#line 2972 "rygel-http-post-test.c"
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPPost* get_request) {
	RygelHTTPResponse * self = NULL;
	RygelHTTPPost* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
	RygelHTTPPost* _tmp3_;
	SoupServer* _tmp4_;
	SoupServer* _tmp5_;
#line 324 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_val_if_fail (get_request != NULL, NULL);
#line 324 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = (RygelHTTPResponse*) g_object_new (object_type, NULL);
#line 325 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = get_request;
#line 325 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 325 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 325 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->priv->msg);
#line 325 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->priv->msg = _tmp2_;
#line 326 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp3_ = get_request;
#line 326 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp4_ = ((RygelHTTPRequest*) _tmp3_)->server;
#line 326 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 326 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->priv->server);
#line 326 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->priv->server = _tmp5_;
#line 324 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return self;
#line 3022 "rygel-http-post-test.c"
}


RygelHTTPResponse* rygel_http_response_new (RygelHTTPPost* get_request) {
#line 324 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return rygel_http_response_construct (RYGEL_TYPE_HTTP_RESPONSE, get_request);
#line 3029 "rygel-http-post-test.c"
}


static void rygel_http_response_real_run_data_free (gpointer _data) {
	RygelHttpResponseRunData* _data_;
	_data_ = _data;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (_data_->self);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_slice_free (RygelHttpResponseRunData, _data_);
#line 3040 "rygel-http-post-test.c"
}


static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPResponse * self;
	RygelHttpResponseRunData* _data_;
	RygelHTTPResponse* _tmp0_;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = (RygelHTTPResponse*) base;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_ = g_slice_new0 (RygelHttpResponseRunData);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_response_real_run);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_response_real_run_data_free);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->self = _tmp0_;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_http_response_real_run_co (_data_);
#line 3062 "rygel-http-post-test.c"
}


static void rygel_http_response_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpResponseRunData* _data_;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3070 "rygel-http-post-test.c"
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return _data4_;
#line 3079 "rygel-http-post-test.c"
}


static void block4_data_unref (Block4Data* _data4_) {
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_g_object_unref0 (_data4_->self);
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		(_data4_->run_continue_target_destroy_notify == NULL) ? NULL : (_data4_->run_continue_target_destroy_notify (_data4_->run_continue_target), NULL);
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data4_->run_continue = NULL;
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data4_->run_continue_target = NULL;
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		_data4_->run_continue_target_destroy_notify = NULL;
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_slice_free (Block4Data, _data4_);
#line 3098 "rygel-http-post-test.c"
	}
}


static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_response_real_run_co (self);
#line 330 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 3108 "rygel-http-post-test.c"
}


static gboolean __lambda5_ (Block4Data* _data4_) {
	RygelHTTPResponse * self;
	gboolean result = FALSE;
#line 332 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = _data4_->self;
#line 333 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data4_->run_continue (_data4_->run_continue_target);
#line 335 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	result = FALSE;
#line 335 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 3123 "rygel-http-post-test.c"
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ (self);
#line 332 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 3132 "rygel-http-post-test.c"
}


static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* _data_) {
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	switch (_data_->_state_) {
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case 0:
#line 3141 "rygel-http-post-test.c"
		goto _state_0;
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case 1:
#line 3145 "rygel-http-post-test.c"
		goto _state_1;
		default:
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_assert_not_reached ();
#line 3150 "rygel-http-post-test.c"
	}
	_state_0:
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data4_ = g_slice_new0 (Block4Data);
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data4_->_ref_count_ = 1;
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data4_->self = g_object_ref (_data_->self);
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data4_->_async_data_ = _data_;
#line 330 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data4_->run_continue = _rygel_http_response_real_run_co_gsource_func;
#line 330 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data4_->run_continue_target = _data_;
#line 330 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data4_->run_continue_target_destroy_notify = NULL;
#line 332 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda5__gsource_func, block4_data_ref (_data_->_data4_), block4_data_unref);
#line 338 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_state_ = 1;
#line 338 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return FALSE;
#line 3173 "rygel-http-post-test.c"
	_state_1:
	;
#line 340 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_tmp0_ = _data_->self->priv->msg;
#line 340 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	soup_message_set_status (_data_->_tmp0_, (guint) SOUP_STATUS_OK);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_tmp1_ = _data_->self->priv->server;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_tmp2_ = _data_->self->priv->msg;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	soup_server_unpause_message (_data_->_tmp1_, _data_->_tmp2_);
#line 343 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	block4_data_unref (_data_->_data4_);
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_data4_ = NULL;
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (_data_->_state_ == 0) {
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3196 "rygel-http-post-test.c"
	} else {
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3200 "rygel-http-post-test.c"
	}
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_object_unref (_data_->_async_result);
#line 329 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return FALSE;
#line 3206 "rygel-http-post-test.c"
}


static GCancellable* rygel_http_response_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPResponse* self;
	GCancellable* _tmp0_;
#line 319 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = (RygelHTTPResponse*) base;
#line 319 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = self->priv->_cancellable;
#line 319 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	result = _tmp0_;
#line 319 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 3222 "rygel-http-post-test.c"
}


static void rygel_http_response_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPResponse* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 319 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = (RygelHTTPResponse*) base;
#line 319 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = value;
#line 319 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 319 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 319 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->priv->_cancellable = _tmp1_;
#line 319 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 3242 "rygel-http-post-test.c"
}


static void rygel_http_response_class_init (RygelHTTPResponseClass * klass) {
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_http_response_parent_class = g_type_class_peek_parent (klass);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPResponsePrivate));
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_response_get_property;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_response_set_property;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_response_finalize;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_RESPONSE_CANCELLABLE, "cancellable");
#line 3259 "rygel-http-post-test.c"
}


static void rygel_http_response_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_http_response_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_response_real_run;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	iface->run_finish = rygel_http_response_real_run_finish;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	iface->get_cancellable = rygel_http_response_real_get_cancellable;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	iface->set_cancellable = rygel_http_response_real_set_cancellable;
#line 3274 "rygel-http-post-test.c"
}


static void rygel_http_response_instance_init (RygelHTTPResponse * self) {
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self->priv = RYGEL_HTTP_RESPONSE_GET_PRIVATE (self);
#line 3281 "rygel-http-post-test.c"
}


static void rygel_http_response_finalize (GObject* obj) {
	RygelHTTPResponse * self;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = RYGEL_HTTP_RESPONSE (obj);
#line 319 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 321 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->priv->msg);
#line 322 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (self->priv->server);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	G_OBJECT_CLASS (rygel_http_response_parent_class)->finalize (obj);
#line 3297 "rygel-http-post-test.c"
}


GType rygel_http_response_get_type (void) {
	static volatile gsize rygel_http_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPResponse), 0, (GInstanceInitFunc) rygel_http_response_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_response_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_response_type_id;
		rygel_http_response_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPResponse", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_response_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_response_type_id__volatile, rygel_http_response_type_id);
	}
	return rygel_http_response_type_id__volatile;
}


static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (object);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	switch (property_id) {
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		break;
#line 3326 "rygel-http-post-test.c"
		default:
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		break;
#line 3332 "rygel-http-post-test.c"
	}
}


static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (object);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	switch (property_id) {
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		break;
#line 3348 "rygel-http-post-test.c"
		default:
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		break;
#line 3354 "rygel-http-post-test.c"
	}
}


RygelItemRemovalQueue* rygel_item_removal_queue_get_default (void) {
	RygelItemRemovalQueue* result = NULL;
	RygelItemRemovalQueue* _tmp0_;
#line 349 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = rygel_item_removal_queue_new ();
#line 349 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	result = _tmp0_;
#line 349 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 3368 "rygel-http-post-test.c"
}


gboolean rygel_item_removal_queue_dequeue (RygelItemRemovalQueue* self, RygelMediaItem* item) {
	gboolean result = FALSE;
#line 352 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 352 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_return_val_if_fail (item != NULL, FALSE);
#line 353 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	result = TRUE;
#line 353 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 3382 "rygel-http-post-test.c"
}


static void rygel_item_removal_queue_remove_now_data_free (gpointer _data) {
	RygelItemRemovalQueueRemoveNowData* _data_;
	_data_ = _data;
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (_data_->item);
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (_data_->cancellable);
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_g_object_unref0 (_data_->self);
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_slice_free (RygelItemRemovalQueueRemoveNowData, _data_);
#line 3397 "rygel-http-post-test.c"
}


void rygel_item_removal_queue_remove_now (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemRemovalQueueRemoveNowData* _data_;
	RygelItemRemovalQueue* _tmp0_;
	RygelMediaItem* _tmp1_;
	RygelMediaItem* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_ = g_slice_new0 (RygelItemRemovalQueueRemoveNowData);
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_removal_queue_remove_now);
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_removal_queue_remove_now_data_free);
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->self = _tmp0_;
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp1_ = item;
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->item = _tmp2_;
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp3_ = cancellable;
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->cancellable = _tmp4_;
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_item_removal_queue_remove_now_co (_data_);
#line 3432 "rygel-http-post-test.c"
}


void rygel_item_removal_queue_remove_now_finish (RygelItemRemovalQueue* self, GAsyncResult* _res_) {
	RygelItemRemovalQueueRemoveNowData* _data_;
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3440 "rygel-http-post-test.c"
}


static gboolean _rygel_item_removal_queue_remove_now_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_item_removal_queue_remove_now_co (self);
#line 357 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return result;
#line 3449 "rygel-http-post-test.c"
}


static gboolean rygel_item_removal_queue_remove_now_co (RygelItemRemovalQueueRemoveNowData* _data_) {
#line 356 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	switch (_data_->_state_) {
#line 356 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case 0:
#line 3458 "rygel-http-post-test.c"
		goto _state_0;
#line 356 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		case 1:
#line 3462 "rygel-http-post-test.c"
		goto _state_1;
		default:
#line 356 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_assert_not_reached ();
#line 3467 "rygel-http-post-test.c"
	}
	_state_0:
#line 357 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_item_removal_queue_remove_now_co_gsource_func, _data_, NULL);
#line 359 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	_data_->_state_ = 1;
#line 359 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return FALSE;
#line 3476 "rygel-http-post-test.c"
	_state_1:
	;
#line 356 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	if (_data_->_state_ == 0) {
#line 356 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3483 "rygel-http-post-test.c"
	} else {
#line 356 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3487 "rygel-http-post-test.c"
	}
#line 356 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	g_object_unref (_data_->_async_result);
#line 356 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return FALSE;
#line 3493 "rygel-http-post-test.c"
}


RygelItemRemovalQueue* rygel_item_removal_queue_construct (GType object_type) {
	RygelItemRemovalQueue * self = NULL;
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = (RygelItemRemovalQueue*) g_object_new (object_type, NULL);
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return self;
#line 3503 "rygel-http-post-test.c"
}


RygelItemRemovalQueue* rygel_item_removal_queue_new (void) {
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return rygel_item_removal_queue_construct (RYGEL_TYPE_ITEM_REMOVAL_QUEUE);
#line 3510 "rygel-http-post-test.c"
}


static void rygel_item_removal_queue_class_init (RygelItemRemovalQueueClass * klass) {
#line 347 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_item_removal_queue_parent_class = g_type_class_peek_parent (klass);
#line 3517 "rygel-http-post-test.c"
}


static void rygel_item_removal_queue_instance_init (RygelItemRemovalQueue * self) {
}


GType rygel_item_removal_queue_get_type (void) {
	static volatile gsize rygel_item_removal_queue_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_item_removal_queue_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelItemRemovalQueueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_item_removal_queue_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelItemRemovalQueue), 0, (GInstanceInitFunc) rygel_item_removal_queue_instance_init, NULL };
		GType rygel_item_removal_queue_type_id;
		rygel_item_removal_queue_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelItemRemovalQueue", &g_define_type_info, 0);
		g_once_init_leave (&rygel_item_removal_queue_type_id__volatile, rygel_item_removal_queue_type_id);
	}
	return rygel_item_removal_queue_type_id__volatile;
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject * self = NULL;
#line 363 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	self = (RygelMediaObject*) g_object_new (object_type, NULL);
#line 363 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return self;
#line 3543 "rygel-http-post-test.c"
}


RygelMediaObject* rygel_media_object_new (void) {
#line 363 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	return rygel_media_object_construct (RYGEL_TYPE_MEDIA_OBJECT);
#line 3550 "rygel-http-post-test.c"
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
#line 363 "/home/jens/Source/rygel/tests/rygel-http-post-test.vala"
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
#line 3557 "rygel-http-post-test.c"
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
}


GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, NULL };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaObject", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


GQuark rygel_content_directory_error_quark (void) {
	return g_quark_from_static_string ("rygel_content_directory_error-quark");
}



