/* rygel-tracker-search-container.c generated by valac 0.15.0.96-556a, the Vala compiler
 * generated from rygel-tracker-search-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2010 MediaNet Inh.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TRACKER_TYPE_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;
typedef struct _RygelTrackerSearchContainerPrivate RygelTrackerSearchContainerPrivate;

#define RYGEL_TRACKER_TYPE_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))
#define RYGEL_TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;

#define RYGEL_TRACKER_TYPE_SELECTION_QUERY (rygel_tracker_selection_query_get_type ())
#define RYGEL_TRACKER_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQuery))
#define RYGEL_TRACKER_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))
#define RYGEL_TRACKER_IS_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_IS_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_SELECTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))

typedef struct _RygelTrackerSelectionQuery RygelTrackerSelectionQuery;
typedef struct _RygelTrackerSelectionQueryClass RygelTrackerSelectionQueryClass;

#define RYGEL_TRACKER_TYPE_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_TRACKER_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;

#define RYGEL_TRACKER_TYPE_RESOURCES_IFACE (rygel_tracker_resources_iface_get_type ())
#define RYGEL_TRACKER_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE, RygelTrackerResourcesIface))
#define RYGEL_TRACKER_IS_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE))
#define RYGEL_TRACKER_RESOURCES_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE, RygelTrackerResourcesIfaceIface))

typedef struct _RygelTrackerResourcesIface RygelTrackerResourcesIface;
typedef struct _RygelTrackerResourcesIfaceIface RygelTrackerResourcesIfaceIface;

#define RYGEL_TRACKER_TYPE_RESOURCES_IFACE_PROXY (rygel_tracker_resources_iface_proxy_get_type ())
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))
#define _rygel_tracker_item_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_item_factory_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;
typedef struct _RygelTrackerItemFactoryPrivate RygelTrackerItemFactoryPrivate;

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLET (rygel_tracker_query_triplet_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTriplet))
#define RYGEL_TRACKER_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_QUERY_TRIPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))

typedef struct _RygelTrackerQueryTriplet RygelTrackerQueryTriplet;
typedef struct _RygelTrackerQueryTripletClass RygelTrackerQueryTripletClass;
#define _rygel_tracker_query_triplet_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_triplet_unref (var), NULL)))

#define RYGEL_TRACKER_TYPE_KEY_CHAIN_MAP (rygel_tracker_key_chain_map_get_type ())
#define RYGEL_TRACKER_KEY_CHAIN_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_KEY_CHAIN_MAP, RygelTrackerKeyChainMap))
#define RYGEL_TRACKER_KEY_CHAIN_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_KEY_CHAIN_MAP, RygelTrackerKeyChainMapClass))
#define RYGEL_TRACKER_IS_KEY_CHAIN_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_KEY_CHAIN_MAP))
#define RYGEL_TRACKER_IS_KEY_CHAIN_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_KEY_CHAIN_MAP))
#define RYGEL_TRACKER_KEY_CHAIN_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_KEY_CHAIN_MAP, RygelTrackerKeyChainMapClass))

typedef struct _RygelTrackerKeyChainMap RygelTrackerKeyChainMap;
typedef struct _RygelTrackerKeyChainMapClass RygelTrackerKeyChainMapClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelTrackerSearchContainerGetChildrenData RygelTrackerSearchContainerGetChildrenData;
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;
typedef struct _RygelTrackerSelectionQueryPrivate RygelTrackerSelectionQueryPrivate;
typedef struct _RygelTrackerSearchContainerExecuteQueryData RygelTrackerSearchContainerExecuteQueryData;
typedef struct _RygelTrackerSearchContainerFindObjectData RygelTrackerSearchContainerFindObjectData;
typedef struct _RygelTrackerSearchContainerGetChildrenCountData RygelTrackerSearchContainerGetChildrenCountData;
typedef struct _RygelTrackerQueryTripletPrivate RygelTrackerQueryTripletPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _RygelTrackerSearchContainer {
	RygelSimpleContainer parent_instance;
	RygelTrackerSearchContainerPrivate * priv;
	RygelTrackerSelectionQuery* query;
	RygelTrackerItemFactory* item_factory;
};

struct _RygelTrackerSearchContainerClass {
	RygelSimpleContainerClass parent_class;
};

struct _RygelTrackerResourcesIfaceIface {
	GTypeInterface parent_iface;
	void (*sparql_query) (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*sparql_query_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
	void (*sparql_update) (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*sparql_update_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, GError** error);
	void (*sparql_update_blank) (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*sparql_update_blank_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _RygelTrackerSearchContainerPrivate {
	RygelTrackerResourcesIface* resources;
};

struct _RygelTrackerItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerItemFactoryPrivate * priv;
	gchar* category;
	gchar* category_iri;
	gchar* upnp_class;
	gchar* upload_dir;
	GeeArrayList* properties;
};

struct _RygelTrackerItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerItemFactory *self);
	RygelMediaItem* (*create) (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, gchar** metadata, int metadata_length1, GError** error);
	void (*set_metadata) (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, gchar** metadata, int metadata_length1, GError** error);
};

struct _RygelTrackerSearchContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	guint offset;
	guint max_count;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelRelationalExpression* _tmp0_;
	RygelRelationalExpression* expression;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	guint total_matches;
	guint _tmp4_;
	guint _tmp5_;
	GCancellable* _tmp6_;
	guint _tmp7_;
	RygelMediaObjects* _tmp8_;
	RygelMediaObjects* _tmp9_;
	GError * _inner_error_;
};

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* triplets;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	gchar* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerSelectionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerSelectionQueryPrivate * priv;
	GeeArrayList* variables;
	GeeArrayList* filters;
	gchar* order_by;
	gint offset;
	gint max_count;
	gchar** result;
	gint result_length1;
	gint result_length2;
};

struct _RygelTrackerSelectionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerSearchContainerExecuteQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	gboolean generic_type;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* results;
	RygelSearchExpression* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gboolean _tmp4_;
	RygelTrackerSelectionQuery* _tmp5_;
	RygelTrackerSelectionQuery* query;
	RygelTrackerSelectionQuery* _tmp6_;
	RygelTrackerSelectionQuery* _tmp7_;
	RygelTrackerResourcesIface* _tmp8_;
	guint i;
	gboolean _tmp9_;
	gboolean _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	RygelTrackerSelectionQuery* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gint _tmp14__length2;
	gint _tmp15_;
	RygelTrackerSelectionQuery* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gint _tmp17__length2;
	guint _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* id;
	RygelTrackerSelectionQuery* _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gint _tmp22__length2;
	guint _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* uri;
	RygelTrackerSelectionQuery* _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	gint _tmp27__length2;
	guint _tmp28_;
	gint _tmp29_;
	gchar** _tmp30_;
	gchar** metadata;
	gint metadata_length1;
	gint _metadata_size_;
	RygelTrackerItemFactory* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	RygelMediaItem* _tmp35_;
	RygelMediaItem* item;
	RygelMediaObjects* _tmp36_;
	RygelMediaItem* _tmp37_;
	RygelMediaObjects* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	GError * _inner_error_;
};

struct _RygelTrackerSearchContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	RygelRelationalExpression* _tmp2_;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp3_;
	RygelRelationalExpression* _tmp4_;
	gchar* _tmp5_;
	RygelRelationalExpression* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	guint total_matches;
	RygelRelationalExpression* _tmp9_;
	GCancellable* _tmp10_;
	guint _tmp11_;
	RygelMediaObjects* _tmp12_;
	RygelMediaObjects* results;
	RygelMediaObjects* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	RygelMediaObjects* _tmp16_;
	gpointer _tmp17_;
	GError * _inner_error_;
};

struct _RygelTrackerSearchContainerGetChildrenCountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	RygelTrackerSelectionQuery* _tmp0_;
	RygelTrackerSelectionQuery* _tmp1_;
	RygelTrackerSelectionQuery* query;
	RygelTrackerSelectionQuery* _tmp2_;
	GeeArrayList* _tmp3_;
	RygelTrackerSelectionQuery* _tmp4_;
	GeeArrayList* _tmp5_;
	RygelTrackerSelectionQuery* _tmp6_;
	RygelTrackerResourcesIface* _tmp7_;
	RygelTrackerSelectionQuery* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gint _tmp9__length2;
	const gchar* _tmp10_;
	gint _tmp11_;
	GError* _error_;
	const gchar* _tmp12_;
	RygelTrackerItemFactory* _tmp13_;
	const gchar* _tmp14_;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError * _inner_error_;
};

struct _RygelTrackerQueryTriplet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryTripletPrivate * priv;
	gchar* graph;
	gchar* subject;
	gchar* predicate;
	gchar* obj;
	RygelTrackerQueryTriplet* next;
};

struct _RygelTrackerQueryTripletClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQueryTriplet *self);
};


static gpointer rygel_tracker_search_container_parent_class = NULL;
static GeeHashMap* rygel_tracker_search_container_update_id_hash;
static GeeHashMap* rygel_tracker_search_container_update_id_hash = NULL;

GType rygel_tracker_search_container_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query (const GValue* value);
GType rygel_tracker_query_get_type (void) G_GNUC_CONST;
GType rygel_tracker_selection_query_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_tracker_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void) G_GNUC_CONST;
GType rygel_tracker_resources_iface_proxy_get_type (void) G_GNUC_CONST;
guint rygel_tracker_resources_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_tracker_resources_iface_get_type (void) G_GNUC_CONST;
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerPrivate))
enum  {
	RYGEL_TRACKER_SEARCH_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_TRACKER_SEARCH_CONTAINER_TRACKER_SERVICE "org.freedesktop.Tracker1"
#define RYGEL_TRACKER_SEARCH_CONTAINER_RESOURCES_PATH "/org/freedesktop/Tracker1/Resources"
#define RYGEL_TRACKER_SEARCH_CONTAINER_MODIFIED_PROPERTY "nfo:fileLastModified"
GType rygel_tracker_query_triplets_get_type (void) G_GNUC_CONST;
RygelTrackerSearchContainer* rygel_tracker_search_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters);
RygelTrackerSearchContainer* rygel_tracker_search_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters);
static void __lambda2_ (RygelTrackerSearchContainer* self, RygelMediaContainer* container, RygelMediaContainer* origin);
static void ___lambda2__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
#define RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE "?item"
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new (void);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct (GType object_type);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_new (const gchar* subject, const gchar* predicate, const gchar* obj);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_construct (GType object_type, const gchar* subject, const gchar* predicate, const gchar* obj);
gpointer rygel_tracker_query_triplet_ref (gpointer instance);
void rygel_tracker_query_triplet_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query_triplet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query_triplet (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query_triplet (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query_triplet (const GValue* value);
GType rygel_tracker_query_triplet_get_type (void) G_GNUC_CONST;
GType rygel_tracker_key_chain_map_get_type (void) G_GNUC_CONST;
RygelTrackerKeyChainMap* rygel_tracker_key_chain_map_get_key_chain_map (void);
gchar* rygel_tracker_key_chain_map_map_property (RygelTrackerKeyChainMap* self, const gchar* property);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new (GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const gchar* order_by, gint offset, gint max_count);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct (GType object_type, GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const gchar* order_by, gint offset, gint max_count);
void rygel_tracker_search_container_get_children_count (RygelTrackerSearchContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_search_container_get_children_count_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_);
static void rygel_tracker_search_container_real_get_children_data_free (gpointer _data);
static void rygel_tracker_search_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_search_container_real_get_children_co (RygelTrackerSearchContainerGetChildrenData* _data_);
void rygel_tracker_search_container_execute_query (RygelTrackerSearchContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, gboolean generic_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_tracker_search_container_execute_query_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_tracker_search_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_tracker_search_container_execute_query_data_free (gpointer _data);
static gboolean rygel_tracker_search_container_execute_query_co (RygelTrackerSearchContainerExecuteQueryData* _data_);
static RygelTrackerSelectionQuery* rygel_tracker_search_container_create_query (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression, gint offset, gint max_count, gboolean generic_type);
void rygel_tracker_query_execute (RygelTrackerQuery* self, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_query_execute_finish (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
static void rygel_tracker_search_container_execute_query_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* rygel_tracker_search_container_create_child_id_for_urn (RygelTrackerSearchContainer* self, const gchar* urn);
static gchar** rygel_tracker_search_container_slice_strvv_tail (RygelTrackerSearchContainer* self, gchar** strvv, int strvv_length1, int strvv_length2, guint row, guint index, int* result_length1);
RygelMediaItem* rygel_tracker_item_factory_create (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, gchar** metadata, int metadata_length1, GError** error);
static void rygel_tracker_search_container_real_find_object_data_free (gpointer _data);
static void rygel_tracker_search_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_search_container_real_find_object_co (RygelTrackerSearchContainerFindObjectData* _data_);
static gboolean rygel_tracker_search_container_is_our_child (RygelTrackerSearchContainer* self, const gchar* id);
static void rygel_tracker_search_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* rygel_tracker_search_container_get_item_info (RygelTrackerSearchContainer* self, const gchar* item_id, gchar** parent_id);
static void rygel_tracker_search_container_get_children_count_data_free (gpointer _data);
static gboolean rygel_tracker_search_container_get_children_count_co (RygelTrackerSearchContainerGetChildrenCountData* _data_);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new_clone (RygelTrackerSelectionQuery* query);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct_clone (GType object_type, RygelTrackerSelectionQuery* query);
static void rygel_tracker_search_container_get_children_count_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar* rygel_tracker_search_container_create_filter_for_child (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression);
static gchar* rygel_tracker_search_container_urn_to_utf8 (RygelTrackerSearchContainer* self, const gchar* urn);
gchar* rygel_tracker_query_escape_string (const gchar* literal);
gchar* rygel_tracker_query_escape_regex (const gchar* literal);
static void rygel_tracker_search_container_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void __lambda2_ (RygelTrackerSearchContainer* self, RygelMediaContainer* container, RygelMediaContainer* origin) {
	RygelMediaContainer* _tmp0_;
	g_return_if_fail (container != NULL);
	g_return_if_fail (origin != NULL);
	_tmp0_ = origin;
	if (_tmp0_ == RYGEL_MEDIA_CONTAINER (self)) {
		GeeHashMap* _tmp1_;
		const gchar* _tmp2_;
		guint32 _tmp3_;
		_tmp1_ = rygel_tracker_search_container_update_id_hash;
		_tmp2_ = ((RygelMediaObject*) self)->id;
		_tmp3_ = ((RygelMediaContainer*) self)->update_id;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, _tmp2_, GUINT_TO_POINTER ((guint) _tmp3_));
	}
}


static void ___lambda2__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
	__lambda2_ (self, _sender, container);
}


static gpointer _rygel_tracker_item_factory_ref0 (gpointer self) {
	return self ? rygel_tracker_item_factory_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelTrackerSearchContainer* rygel_tracker_search_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters) {
	RygelTrackerSearchContainer * self = NULL;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GeeHashMap* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	RygelTrackerItemFactory* _tmp12_;
	RygelTrackerItemFactory* _tmp13_;
	GeeArrayList* _tmp14_;
	GeeArrayList* variables;
	GeeArrayList* _tmp15_;
	RygelTrackerQueryTriplets* our_triplets = NULL;
	RygelTrackerQueryTriplets* _tmp16_;
	RygelTrackerQueryTriplets* _tmp20_;
	RygelTrackerItemFactory* _tmp21_;
	const gchar* _tmp22_;
	RygelTrackerQueryTriplet* _tmp23_;
	RygelTrackerQueryTriplet* _tmp24_;
	RygelTrackerKeyChainMap* _tmp25_ = NULL;
	RygelTrackerKeyChainMap* key_chain_map;
	gchar* _tmp43_;
	gchar* order_by;
	GeeArrayList* _tmp44_;
	RygelTrackerQueryTriplets* _tmp45_;
	GeeArrayList* _tmp46_;
	RygelTrackerSelectionQuery* _tmp47_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (item_factory != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = parent;
	_tmp2_ = title;
	self = (RygelTrackerSearchContainer*) rygel_simple_container_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = rygel_tracker_search_container_update_id_hash;
	_tmp4_ = G_UNLIKELY (_tmp3_ == NULL);
	if (_tmp4_) {
		GeeHashMap* _tmp5_;
		_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (rygel_tracker_search_container_update_id_hash);
		rygel_tracker_search_container_update_id_hash = _tmp5_;
	}
	_tmp6_ = rygel_tracker_search_container_update_id_hash;
	_tmp7_ = ((RygelMediaObject*) self)->id;
	_tmp8_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp6_, _tmp7_);
	if (_tmp8_) {
		GeeHashMap* _tmp9_;
		const gchar* _tmp10_;
		gpointer _tmp11_ = NULL;
		_tmp9_ = rygel_tracker_search_container_update_id_hash;
		_tmp10_ = ((RygelMediaObject*) self)->id;
		_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, _tmp10_);
		((RygelMediaContainer*) self)->update_id = (guint32) GPOINTER_TO_UINT (_tmp11_);
	}
	g_signal_connect_object ((RygelMediaContainer*) self, "container-updated", (GCallback) ___lambda2__rygel_media_container_container_updated, self, 0);
	_tmp12_ = item_factory;
	_tmp13_ = _rygel_tracker_item_factory_ref0 (_tmp12_);
	_rygel_tracker_item_factory_unref0 (self->item_factory);
	self->item_factory = _tmp13_;
	_tmp14_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	variables = _tmp14_;
	_tmp15_ = variables;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE);
	_tmp16_ = triplets;
	if (_tmp16_ != NULL) {
		RygelTrackerQueryTriplets* _tmp17_;
		RygelTrackerQueryTriplets* _tmp18_;
		_tmp17_ = triplets;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		_g_object_unref0 (our_triplets);
		our_triplets = _tmp18_;
	} else {
		RygelTrackerQueryTriplets* _tmp19_;
		_tmp19_ = rygel_tracker_query_triplets_new ();
		_g_object_unref0 (our_triplets);
		our_triplets = _tmp19_;
	}
	_tmp20_ = our_triplets;
	_tmp21_ = item_factory;
	_tmp22_ = _tmp21_->category;
	_tmp23_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE, "a", _tmp22_);
	_tmp24_ = _tmp23_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp24_);
	_rygel_tracker_query_triplet_unref0 (_tmp24_);
	_tmp25_ = rygel_tracker_key_chain_map_get_key_chain_map ();
	key_chain_map = _tmp25_;
	{
		RygelTrackerItemFactory* _tmp26_;
		GeeArrayList* _tmp27_;
		GeeArrayList* _tmp28_;
		GeeArrayList* _property_list;
		GeeArrayList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _property_size;
		gint _property_index;
		_tmp26_ = self->item_factory;
		_tmp27_ = _tmp26_->properties;
		_tmp28_ = _g_object_ref0 (_tmp27_);
		_property_list = _tmp28_;
		_tmp29_ = _property_list;
		_tmp30_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_property_size = _tmp31_;
		_property_index = -1;
		while (TRUE) {
			gint _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			GeeArrayList* _tmp35_;
			gint _tmp36_;
			gpointer _tmp37_ = NULL;
			gchar* property;
			GeeArrayList* _tmp38_;
			RygelTrackerKeyChainMap* _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_;
			_tmp32_ = _property_index;
			_property_index = _tmp32_ + 1;
			_tmp33_ = _property_index;
			_tmp34_ = _property_size;
			if (!(_tmp33_ < _tmp34_)) {
				break;
			}
			_tmp35_ = _property_list;
			_tmp36_ = _property_index;
			_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, _tmp36_);
			property = (gchar*) _tmp37_;
			_tmp38_ = variables;
			_tmp39_ = key_chain_map;
			_tmp40_ = property;
			_tmp41_ = rygel_tracker_key_chain_map_map_property (_tmp39_, _tmp40_);
			_tmp42_ = _tmp41_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp38_, _tmp42_);
			_g_free0 (_tmp42_);
			_g_free0 (property);
		}
		_g_object_unref0 (_property_list);
	}
	_tmp43_ = g_strdup (RYGEL_TRACKER_SEARCH_CONTAINER_MODIFIED_PROPERTY "(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ")");
	order_by = _tmp43_;
	_tmp44_ = variables;
	_tmp45_ = our_triplets;
	_tmp46_ = filters;
	_tmp47_ = rygel_tracker_selection_query_new (_tmp44_, _tmp45_, _tmp46_, order_by, 0, -1);
	_rygel_tracker_query_unref0 (self->query);
	self->query = _tmp47_;
	{
		RygelTrackerResourcesIface* _tmp48_ = NULL;
		RygelTrackerResourcesIface* _tmp49_;
		_tmp48_ = g_initable_new (RYGEL_TRACKER_TYPE_RESOURCES_IFACE_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", RYGEL_TRACKER_SEARCH_CONTAINER_TRACKER_SERVICE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RYGEL_TRACKER_SEARCH_CONTAINER_RESOURCES_PATH, "g-interface-name", "org.freedesktop.Tracker1.Resources", NULL);
		_tmp49_ = (RygelTrackerResourcesIface*) _tmp48_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch4_g_io_error;
			}
			_g_free0 (order_by);
			_g_object_unref0 (key_chain_map);
			_g_object_unref0 (our_triplets);
			_g_object_unref0 (variables);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (self->priv->resources);
		self->priv->resources = _tmp49_;
		rygel_tracker_search_container_get_children_count (self, NULL, NULL);
	}
	goto __finally4;
	__catch4_g_io_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp50_ = NULL;
		GError* _tmp51_;
		const gchar* _tmp52_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp50_ = _ ("Failed to connect to session bus: %s");
		_tmp51_ = _error_;
		_tmp52_ = _tmp51_->message;
		g_critical (_tmp50_, _tmp52_);
		_g_error_free0 (_error_);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (order_by);
		_g_object_unref0 (key_chain_map);
		_g_object_unref0 (our_triplets);
		_g_object_unref0 (variables);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (order_by);
	_g_object_unref0 (key_chain_map);
	_g_object_unref0 (our_triplets);
	_g_object_unref0 (variables);
	return self;
}


RygelTrackerSearchContainer* rygel_tracker_search_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters) {
	return rygel_tracker_search_container_construct (RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, id, parent, title, item_factory, triplets, filters);
}


static void rygel_tracker_search_container_real_get_children_data_free (gpointer _data) {
	RygelTrackerSearchContainerGetChildrenData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerSearchContainerGetChildrenData, _data_);
}


static void rygel_tracker_search_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainer * self;
	RygelTrackerSearchContainerGetChildrenData* _data_;
	RygelTrackerSearchContainer* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	self = (RygelTrackerSearchContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerGetChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_real_get_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_real_get_children_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = offset;
	_data_->offset = _tmp1_;
	_tmp2_ = max_count;
	_data_->max_count = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->cancellable = _tmp4_;
	rygel_tracker_search_container_real_get_children_co (_data_);
}


static RygelMediaObjects* rygel_tracker_search_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelTrackerSearchContainerGetChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_search_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_tracker_search_container_real_get_children_co (_data_);
}


static gboolean rygel_tracker_search_container_real_get_children_co (RygelTrackerSearchContainerGetChildrenData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_relational_expression_new ();
	_data_->expression = _data_->_tmp0_;
	((RygelSearchExpression*) _data_->expression)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_EQ);
	_data_->_tmp1_ = g_strdup ("@parentID");
	_g_free0 (((RygelSearchExpression*) _data_->expression)->operand1);
	((RygelSearchExpression*) _data_->expression)->operand1 = _data_->_tmp1_;
	_data_->_tmp2_ = ((RygelMediaObject*) _data_->self)->id;
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
	_g_free0 (((RygelSearchExpression*) _data_->expression)->operand2);
	((RygelSearchExpression*) _data_->expression)->operand2 = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->offset;
	_data_->_tmp5_ = _data_->max_count;
	_data_->_tmp6_ = _data_->cancellable;
	_data_->_tmp7_ = 0U;
	_data_->_state_ = 1;
	rygel_tracker_search_container_execute_query (_data_->self, (RygelSearchExpression*) _data_->expression, _data_->_tmp4_, _data_->_tmp5_, _data_->_tmp6_, FALSE, rygel_tracker_search_container_get_children_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = rygel_tracker_search_container_execute_query_finish (_data_->self, _data_->_res_, &_data_->_tmp7_, &_data_->_inner_error_);
	_data_->total_matches = _data_->_tmp7_;
	_data_->_tmp9_ = _data_->_tmp8_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_rygel_search_expression_unref0 (_data_->expression);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_tmp9_;
	_rygel_search_expression_unref0 (_data_->expression);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_rygel_search_expression_unref0 (_data_->expression);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_tracker_search_container_execute_query_data_free (gpointer _data) {
	RygelTrackerSearchContainerExecuteQueryData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerSearchContainerExecuteQueryData, _data_);
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


void rygel_tracker_search_container_execute_query (RygelTrackerSearchContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, gboolean generic_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainerExecuteQueryData* _data_;
	RygelTrackerSearchContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	gboolean _tmp7_;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerExecuteQueryData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_execute_query);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_execute_query_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = expression;
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
	_data_->expression = _tmp2_;
	_tmp3_ = offset;
	_data_->offset = _tmp3_;
	_tmp4_ = max_count;
	_data_->max_count = _tmp4_;
	_tmp5_ = cancellable;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_data_->cancellable = _tmp6_;
	_tmp7_ = generic_type;
	_data_->generic_type = _tmp7_;
	rygel_tracker_search_container_execute_query_co (_data_);
}


RygelMediaObjects* rygel_tracker_search_container_execute_query_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelTrackerSearchContainerExecuteQueryData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_search_container_execute_query_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerExecuteQueryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_tracker_search_container_execute_query_co (_data_);
}


static gboolean rygel_tracker_search_container_execute_query_co (RygelTrackerSearchContainerExecuteQueryData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_media_objects_new ();
	_data_->results = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->expression;
	_data_->_tmp2_ = _data_->offset;
	_data_->_tmp3_ = _data_->max_count;
	_data_->_tmp4_ = _data_->generic_type;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = rygel_tracker_search_container_create_query (_data_->self, RYGEL_IS_RELATIONAL_EXPRESSION (_data_->_tmp1_) ? ((RygelRelationalExpression*) _data_->_tmp1_) : NULL, (gint) _data_->_tmp2_, (gint) _data_->_tmp3_, _data_->_tmp4_);
	_data_->query = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->query;
	if (_data_->_tmp6_ != NULL) {
		_data_->_tmp7_ = _data_->query;
		_data_->_tmp8_ = _data_->self->priv->resources;
		_data_->_state_ = 1;
		rygel_tracker_query_execute ((RygelTrackerQuery*) _data_->_tmp7_, _data_->_tmp8_, rygel_tracker_search_container_execute_query_ready, _data_);
		return FALSE;
		_state_1:
		rygel_tracker_query_execute_finish ((RygelTrackerQuery*) _data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_rygel_tracker_query_unref0 (_data_->query);
			_g_object_unref0 (_data_->results);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		{
			_data_->i = (guint) 0;
			{
				_data_->_tmp9_ = TRUE;
				while (TRUE) {
					_data_->_tmp10_ = _data_->_tmp9_;
					if (!_data_->_tmp10_) {
						_data_->_tmp11_ = _data_->i;
						_data_->i = _data_->_tmp11_ + 1;
					}
					_data_->_tmp9_ = FALSE;
					_data_->_tmp12_ = _data_->i;
					_data_->_tmp13_ = _data_->query;
					_data_->_tmp14_ = _data_->_tmp13_->result;
					_data_->_tmp14__length1 = _data_->_tmp13_->result_length1;
					_data_->_tmp14__length2 = _data_->_tmp13_->result_length2;
					_data_->_tmp15_ = _data_->_tmp14__length1;
					if (!(_data_->_tmp12_ < ((guint) _data_->_tmp15_))) {
						break;
					}
					_data_->_tmp16_ = _data_->query;
					_data_->_tmp17_ = _data_->_tmp16_->result;
					_data_->_tmp17__length1 = _data_->_tmp16_->result_length1;
					_data_->_tmp17__length2 = _data_->_tmp16_->result_length2;
					_data_->_tmp18_ = _data_->i;
					_data_->_tmp19_ = _data_->_tmp17_[(_data_->_tmp18_ * _data_->_tmp17__length2) + 0];
					_data_->_tmp20_ = NULL;
					_data_->_tmp20_ = rygel_tracker_search_container_create_child_id_for_urn (_data_->self, _data_->_tmp19_);
					_data_->id = _data_->_tmp20_;
					_data_->_tmp21_ = _data_->query;
					_data_->_tmp22_ = _data_->_tmp21_->result;
					_data_->_tmp22__length1 = _data_->_tmp21_->result_length1;
					_data_->_tmp22__length2 = _data_->_tmp21_->result_length2;
					_data_->_tmp23_ = _data_->i;
					_data_->_tmp24_ = _data_->_tmp22_[(_data_->_tmp23_ * _data_->_tmp22__length2) + 1];
					_data_->_tmp25_ = g_strdup (_data_->_tmp24_);
					_data_->uri = _data_->_tmp25_;
					_data_->_tmp26_ = _data_->query;
					_data_->_tmp27_ = _data_->_tmp26_->result;
					_data_->_tmp27__length1 = _data_->_tmp26_->result_length1;
					_data_->_tmp27__length2 = _data_->_tmp26_->result_length2;
					_data_->_tmp28_ = _data_->i;
					_data_->_tmp29_ = 0;
					_data_->_tmp30_ = NULL;
					_data_->_tmp30_ = rygel_tracker_search_container_slice_strvv_tail (_data_->self, _data_->_tmp27_, _data_->_tmp27__length1, _data_->_tmp27__length2, _data_->_tmp28_, (guint) 1, &_data_->_tmp29_);
					_data_->metadata = _data_->_tmp30_;
					_data_->metadata_length1 = _data_->_tmp29_;
					_data_->_metadata_size_ = _data_->metadata_length1;
					_data_->_tmp31_ = _data_->self->item_factory;
					_data_->_tmp32_ = _data_->id;
					_data_->_tmp33_ = _data_->uri;
					_data_->_tmp34_ = _data_->metadata;
					_data_->_tmp34__length1 = _data_->metadata_length1;
					_data_->_tmp35_ = NULL;
					_data_->_tmp35_ = rygel_tracker_item_factory_create (_data_->_tmp31_, _data_->_tmp32_, _data_->_tmp33_, _data_->self, _data_->_tmp34_, _data_->_tmp34__length1, &_data_->_inner_error_);
					_data_->item = _data_->_tmp35_;
					if (_data_->_inner_error_ != NULL) {
						g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
						g_error_free (_data_->_inner_error_);
						_data_->metadata = (_vala_array_free (_data_->metadata, _data_->metadata_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_data_->uri);
						_g_free0 (_data_->id);
						_rygel_tracker_query_unref0 (_data_->query);
						_g_object_unref0 (_data_->results);
						if (_data_->_state_ == 0) {
							g_simple_async_result_complete_in_idle (_data_->_async_result);
						} else {
							g_simple_async_result_complete (_data_->_async_result);
						}
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_data_->_tmp36_ = _data_->results;
					_data_->_tmp37_ = _data_->item;
					gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp36_, (RygelMediaObject*) _data_->_tmp37_);
					_g_object_unref0 (_data_->item);
					_data_->metadata = (_vala_array_free (_data_->metadata, _data_->metadata_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->uri);
					_g_free0 (_data_->id);
				}
			}
		}
	}
	_data_->_tmp38_ = _data_->results;
	_data_->_tmp39_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp38_);
	_data_->_tmp40_ = _data_->_tmp39_;
	_data_->total_matches = (guint) _data_->_tmp40_;
	_data_->result = _data_->results;
	_rygel_tracker_query_unref0 (_data_->query);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_rygel_tracker_query_unref0 (_data_->query);
	_g_object_unref0 (_data_->results);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_tracker_search_container_real_find_object_data_free (gpointer _data) {
	RygelTrackerSearchContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerSearchContainerFindObjectData, _data_);
}


static void rygel_tracker_search_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainer * self;
	RygelTrackerSearchContainerFindObjectData* _data_;
	RygelTrackerSearchContainer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	self = (RygelTrackerSearchContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_real_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_real_find_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->id = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->cancellable = _tmp4_;
	rygel_tracker_search_container_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_tracker_search_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelTrackerSearchContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_search_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerFindObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_tracker_search_container_real_find_object_co (_data_);
}


static gboolean rygel_tracker_search_container_real_find_object_co (RygelTrackerSearchContainerFindObjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->id;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = rygel_tracker_search_container_is_our_child (_data_->self, _data_->_tmp0_);
	if (!_data_->_tmp1_) {
		_data_->result = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = rygel_relational_expression_new ();
	_data_->expression = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->expression;
	((RygelSearchExpression*) _data_->_tmp3_)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_EQ);
	_data_->_tmp4_ = _data_->expression;
	_data_->_tmp5_ = g_strdup ("@id");
	_g_free0 (((RygelSearchExpression*) _data_->_tmp4_)->operand1);
	((RygelSearchExpression*) _data_->_tmp4_)->operand1 = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->expression;
	_data_->_tmp7_ = _data_->id;
	_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
	_g_free0 (((RygelSearchExpression*) _data_->_tmp6_)->operand2);
	((RygelSearchExpression*) _data_->_tmp6_)->operand2 = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->expression;
	_data_->_tmp10_ = _data_->cancellable;
	_data_->_tmp11_ = 0U;
	_data_->_state_ = 1;
	rygel_tracker_search_container_execute_query (_data_->self, (RygelSearchExpression*) _data_->_tmp9_, (guint) 0, (guint) 1, _data_->_tmp10_, TRUE, rygel_tracker_search_container_find_object_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = rygel_tracker_search_container_execute_query_finish (_data_->self, _data_->_res_, &_data_->_tmp11_, &_data_->_inner_error_);
	_data_->total_matches = _data_->_tmp11_;
	_data_->results = _data_->_tmp12_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_rygel_search_expression_unref0 (_data_->expression);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = _data_->results;
	_data_->_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp13_);
	_data_->_tmp15_ = _data_->_tmp14_;
	if (_data_->_tmp15_ > 0) {
		_data_->_tmp16_ = _data_->results;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp16_, 0);
		_data_->result = (RygelMediaObject*) _data_->_tmp17_;
		_g_object_unref0 (_data_->results);
		_rygel_search_expression_unref0 (_data_->expression);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->result = NULL;
		_g_object_unref0 (_data_->results);
		_rygel_search_expression_unref0 (_data_->expression);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->results);
	_rygel_search_expression_unref0 (_data_->expression);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


gchar* rygel_tracker_search_container_create_child_id_for_urn (RygelTrackerSearchContainer* self, const gchar* urn) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (urn != NULL, NULL);
	_tmp0_ = ((RygelMediaObject*) self)->id;
	_tmp1_ = g_strconcat (_tmp0_, ",", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = urn;
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	result = _tmp5_;
	return result;
}


gchar* rygel_tracker_search_container_get_item_info (RygelTrackerSearchContainer* self, const gchar* item_id, gchar** parent_id) {
	gchar* _vala_parent_id = NULL;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gboolean _tmp3_ = FALSE;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gboolean _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item_id != NULL, NULL);
	_tmp0_ = item_id;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ",", 2);
	tokens = _tmp2_;
	tokens_length1 = _vala_array_length (_tmp1_);
	_tokens_size_ = tokens_length1;
	_tmp4_ = tokens;
	_tmp4__length1 = tokens_length1;
	_tmp5_ = _tmp4_[0];
	if (_tmp5_ != NULL) {
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		_tmp6_ = tokens;
		_tmp6__length1 = tokens_length1;
		_tmp7_ = _tmp6_[1];
		_tmp3_ = _tmp7_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp8_ = _tmp3_;
	if (_tmp8_) {
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar** _tmp12_;
		gint _tmp12__length1;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp9_ = tokens;
		_tmp9__length1 = tokens_length1;
		_tmp10_ = _tmp9_[0];
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (_vala_parent_id);
		_vala_parent_id = _tmp11_;
		_tmp12_ = tokens;
		_tmp12__length1 = tokens_length1;
		_tmp13_ = _tmp12_[1];
		_tmp14_ = g_strdup (_tmp13_);
		result = _tmp14_;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (parent_id) {
			*parent_id = _vala_parent_id;
		} else {
			_g_free0 (_vala_parent_id);
		}
		return result;
	} else {
		_g_free0 (_vala_parent_id);
		_vala_parent_id = NULL;
		result = NULL;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (parent_id) {
			*parent_id = _vala_parent_id;
		} else {
			_g_free0 (_vala_parent_id);
		}
		return result;
	}
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	if (parent_id) {
		*parent_id = _vala_parent_id;
	} else {
		_g_free0 (_vala_parent_id);
	}
}


static void rygel_tracker_search_container_get_children_count_data_free (gpointer _data) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerSearchContainerGetChildrenCountData, _data_);
}


void rygel_tracker_search_container_get_children_count (RygelTrackerSearchContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	RygelTrackerSearchContainer* _tmp0_;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerGetChildrenCountData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_get_children_count);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_get_children_count_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_tracker_search_container_get_children_count_co (_data_);
}


void rygel_tracker_search_container_get_children_count_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_tracker_search_container_get_children_count_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_tracker_search_container_get_children_count_co (_data_);
}


static gboolean rygel_tracker_search_container_get_children_count_co (RygelTrackerSearchContainerGetChildrenCountData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->query;
		_data_->_tmp1_ = rygel_tracker_selection_query_new_clone (_data_->_tmp0_);
		_data_->query = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->query;
		_data_->_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
		_g_object_unref0 (_data_->_tmp2_->variables);
		_data_->_tmp2_->variables = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->query;
		_data_->_tmp5_ = _data_->_tmp4_->variables;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp5_, "COUNT(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ") AS x");
		_data_->_tmp6_ = _data_->query;
		_data_->_tmp7_ = _data_->self->priv->resources;
		_data_->_state_ = 1;
		rygel_tracker_query_execute ((RygelTrackerQuery*) _data_->_tmp6_, _data_->_tmp7_, rygel_tracker_search_container_get_children_count_ready, _data_);
		return FALSE;
		_state_1:
		rygel_tracker_query_execute_finish ((RygelTrackerQuery*) _data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			_rygel_tracker_query_unref0 (_data_->query);
			goto __catch5_g_error;
		}
		_data_->_tmp8_ = _data_->query;
		_data_->_tmp9_ = _data_->_tmp8_->result;
		_data_->_tmp9__length1 = _data_->_tmp8_->result_length1;
		_data_->_tmp9__length2 = _data_->_tmp8_->result_length2;
		_data_->_tmp10_ = _data_->_tmp9_[(0 * _data_->_tmp9__length2) + 0];
		_data_->_tmp11_ = 0;
		_data_->_tmp11_ = atoi (_data_->_tmp10_);
		((RygelMediaContainer*) _data_->self)->child_count = _data_->_tmp11_;
		rygel_media_container_updated ((RygelMediaContainer*) _data_->self);
		_rygel_tracker_query_unref0 (_data_->query);
	}
	goto __finally5;
	__catch5_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _ ("Error getting item count under category '%s': %s");
		_data_->_tmp13_ = _data_->self->item_factory;
		_data_->_tmp14_ = _data_->_tmp13_->category;
		_data_->_tmp15_ = _data_->_error_;
		_data_->_tmp16_ = _data_->_tmp15_->message;
		g_critical (_data_->_tmp12_, _data_->_tmp14_, _data_->_tmp16_);
		_g_error_free0 (_data_->_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally5:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean rygel_tracker_search_container_is_our_child (RygelTrackerSearchContainer* self, const gchar* id) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp0_ = id;
	_tmp1_ = ((RygelMediaObject*) self)->id;
	_tmp2_ = g_strconcat (_tmp1_, ",", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_str_has_prefix (_tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static RygelTrackerSelectionQuery* rygel_tracker_search_container_create_query (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression, gint offset, gint max_count, gboolean generic_type) {
	RygelTrackerSelectionQuery* result = NULL;
	gboolean _tmp0_ = FALSE;
	RygelRelationalExpression* _tmp1_;
	gconstpointer _tmp2_;
	gboolean _tmp8_;
	RygelTrackerSelectionQuery* _tmp9_;
	RygelTrackerSelectionQuery* _tmp10_;
	RygelTrackerSelectionQuery* query;
	RygelRelationalExpression* _tmp11_;
	gconstpointer _tmp12_;
	gboolean _tmp24_;
	RygelTrackerSelectionQuery* _tmp46_;
	gint _tmp47_;
	RygelTrackerSelectionQuery* _tmp48_;
	gint _tmp49_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = expression;
	_tmp2_ = ((RygelSearchExpression*) _tmp1_)->operand1;
	if (g_strcmp0 ((const gchar*) _tmp2_, "upnp:class") == 0) {
		RygelTrackerItemFactory* _tmp3_;
		const gchar* _tmp4_;
		RygelRelationalExpression* _tmp5_;
		gconstpointer _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp3_ = self->item_factory;
		_tmp4_ = _tmp3_->upnp_class;
		_tmp5_ = expression;
		_tmp6_ = ((RygelSearchExpression*) _tmp5_)->operand2;
		_tmp7_ = g_str_has_prefix (_tmp4_, (const gchar*) _tmp6_);
		_tmp0_ = !_tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp8_ = _tmp0_;
	if (_tmp8_) {
		result = NULL;
		return result;
	}
	_tmp9_ = self->query;
	_tmp10_ = rygel_tracker_selection_query_new_clone (_tmp9_);
	query = _tmp10_;
	_tmp11_ = expression;
	_tmp12_ = ((RygelSearchExpression*) _tmp11_)->operand1;
	if (g_strcmp0 ((const gchar*) _tmp12_, "@parentID") == 0) {
		RygelRelationalExpression* _tmp13_;
		const gchar* _tmp14_;
		gboolean _tmp15_ = FALSE;
		_tmp13_ = expression;
		_tmp14_ = ((RygelMediaObject*) self)->id;
		_tmp15_ = rygel_relational_expression_compare_string (_tmp13_, _tmp14_);
		if (!_tmp15_) {
			result = NULL;
			_rygel_tracker_query_unref0 (query);
			return result;
		}
	} else {
		RygelRelationalExpression* _tmp16_;
		gconstpointer _tmp17_;
		_tmp16_ = expression;
		_tmp17_ = ((RygelSearchExpression*) _tmp16_)->operand1;
		if (g_strcmp0 ((const gchar*) _tmp17_, "upnp:class") != 0) {
			RygelRelationalExpression* _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* filter;
			const gchar* _tmp20_;
			_tmp18_ = expression;
			_tmp19_ = rygel_tracker_search_container_create_filter_for_child (self, _tmp18_);
			filter = _tmp19_;
			_tmp20_ = filter;
			if (_tmp20_ != NULL) {
				RygelTrackerSelectionQuery* _tmp21_;
				GeeArrayList* _tmp22_;
				const gchar* _tmp23_;
				_tmp21_ = query;
				_tmp22_ = _tmp21_->filters;
				_tmp23_ = filter;
				gee_abstract_list_insert ((GeeAbstractList*) _tmp22_, 0, _tmp23_);
			} else {
				result = NULL;
				_g_free0 (filter);
				_rygel_tracker_query_unref0 (query);
				return result;
			}
			_g_free0 (filter);
		}
	}
	_tmp24_ = generic_type;
	if (_tmp24_) {
		{
			RygelTrackerSelectionQuery* _tmp25_;
			RygelTrackerQueryTriplets* _tmp26_;
			RygelTrackerQueryTriplets* _tmp27_;
			RygelTrackerQueryTriplets* _triplet_list;
			RygelTrackerQueryTriplets* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			gint _triplet_size;
			gint _triplet_index;
			_tmp25_ = query;
			_tmp26_ = ((RygelTrackerQuery*) _tmp25_)->triplets;
			_tmp27_ = _g_object_ref0 (_tmp26_);
			_triplet_list = _tmp27_;
			_tmp28_ = _triplet_list;
			_tmp29_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp28_);
			_tmp30_ = _tmp29_;
			_triplet_size = _tmp30_;
			_triplet_index = -1;
			while (TRUE) {
				gint _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				RygelTrackerQueryTriplets* _tmp34_;
				gint _tmp35_;
				gpointer _tmp36_ = NULL;
				RygelTrackerQueryTriplet* triplet;
				gboolean _tmp37_ = FALSE;
				RygelTrackerQueryTriplet* _tmp38_;
				const gchar* _tmp39_;
				gboolean _tmp43_;
				_tmp31_ = _triplet_index;
				_triplet_index = _tmp31_ + 1;
				_tmp32_ = _triplet_index;
				_tmp33_ = _triplet_size;
				if (!(_tmp32_ < _tmp33_)) {
					break;
				}
				_tmp34_ = _triplet_list;
				_tmp35_ = _triplet_index;
				_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _tmp35_);
				triplet = (RygelTrackerQueryTriplet*) _tmp36_;
				_tmp38_ = triplet;
				_tmp39_ = _tmp38_->predicate;
				if (g_strcmp0 (_tmp39_, "a") == 0) {
					RygelTrackerQueryTriplet* _tmp40_;
					const gchar* _tmp41_;
					gboolean _tmp42_ = FALSE;
					_tmp40_ = triplet;
					_tmp41_ = _tmp40_->obj;
					_tmp42_ = g_str_has_prefix (_tmp41_, "nmm:");
					_tmp37_ = _tmp42_;
				} else {
					_tmp37_ = FALSE;
				}
				_tmp43_ = _tmp37_;
				if (_tmp43_) {
					RygelTrackerQueryTriplet* _tmp44_;
					gchar* _tmp45_;
					_tmp44_ = triplet;
					_tmp45_ = g_strdup ("nfo:Media");
					_g_free0 (_tmp44_->obj);
					_tmp44_->obj = _tmp45_;
				}
				_rygel_tracker_query_triplet_unref0 (triplet);
			}
			_g_object_unref0 (_triplet_list);
		}
	}
	_tmp46_ = query;
	_tmp47_ = offset;
	_tmp46_->offset = _tmp47_;
	_tmp48_ = query;
	_tmp49_ = max_count;
	_tmp48_->max_count = _tmp49_;
	result = query;
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* rygel_tracker_search_container_urn_to_utf8 (RygelTrackerSearchContainer* self, const gchar* urn) {
	gchar* result = NULL;
	GString* _tmp0_;
	GString* urn_builder;
	const gchar* _tmp1_;
	const gchar* s;
	GString* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (urn != NULL, NULL);
	_tmp0_ = g_string_new ("");
	urn_builder = _tmp0_;
	_tmp1_ = urn;
	s = _tmp1_;
	{
		gboolean _tmp2_;
		_tmp2_ = TRUE;
		while (TRUE) {
			gboolean _tmp3_;
			const gchar* _tmp6_;
			gunichar _tmp7_ = 0U;
			const gchar* _tmp8_;
			gunichar _tmp9_ = 0U;
			gunichar character;
			gboolean _tmp10_ = FALSE;
			gunichar _tmp11_;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp15_;
			_tmp3_ = _tmp2_;
			if (!_tmp3_) {
				const gchar* _tmp4_;
				const gchar* _tmp5_ = NULL;
				_tmp4_ = s;
				_tmp5_ = g_utf8_next_char (_tmp4_);
				s = _tmp5_;
			}
			_tmp2_ = FALSE;
			_tmp6_ = s;
			_tmp7_ = string_get_char (_tmp6_, (glong) 0);
			if (!(_tmp7_ != ((gunichar) 0))) {
				break;
			}
			_tmp8_ = s;
			_tmp9_ = string_get_char (_tmp8_, (glong) 0);
			character = _tmp9_;
			_tmp11_ = character;
			_tmp12_ = g_unichar_iscntrl (_tmp11_);
			if (_tmp12_) {
				_tmp10_ = TRUE;
			} else {
				gunichar _tmp13_;
				gboolean _tmp14_ = FALSE;
				_tmp13_ = character;
				_tmp14_ = g_unichar_validate (_tmp13_);
				_tmp10_ = !_tmp14_;
			}
			_tmp15_ = _tmp10_;
			if (!_tmp15_) {
				GString* _tmp16_;
				gunichar _tmp17_;
				_tmp16_ = urn_builder;
				_tmp17_ = character;
				g_string_append_unichar (_tmp16_, _tmp17_);
			}
		}
	}
	_tmp18_ = urn_builder;
	_tmp19_ = _tmp18_->str;
	_tmp20_ = g_strdup (_tmp19_);
	result = _tmp20_;
	_g_string_free0 (urn_builder);
	return result;
}


static gchar* rygel_tracker_search_container_create_filter_for_child (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression) {
	gchar* result = NULL;
	gchar* filter;
	gchar* variable;
	gchar* value;
	RygelRelationalExpression* _tmp0_;
	gconstpointer _tmp1_;
	gboolean _tmp30_ = FALSE;
	const gchar* _tmp31_;
	gboolean _tmp33_;
	RygelRelationalExpression* _tmp34_;
	gconstpointer _tmp35_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expression != NULL, NULL);
	filter = NULL;
	variable = NULL;
	value = NULL;
	_tmp0_ = expression;
	_tmp1_ = ((RygelSearchExpression*) _tmp0_)->operand1;
	if (g_strcmp0 ((const gchar*) _tmp1_, "@id") == 0) {
		gchar* _tmp2_;
		gchar* parent_id = NULL;
		RygelRelationalExpression* _tmp3_;
		gconstpointer _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* urn;
		const gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp13_;
		gboolean _tmp15_;
		gboolean _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_ = NULL;
		RygelRelationalExpression* _tmp21_;
		gconstpointer _tmp22_;
		_tmp2_ = g_strdup (RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE);
		_g_free0 (variable);
		variable = _tmp2_;
		_tmp3_ = expression;
		_tmp4_ = ((RygelSearchExpression*) _tmp3_)->operand2;
		_tmp6_ = rygel_tracker_search_container_get_item_info (self, (const gchar*) _tmp4_, &_tmp5_);
		_g_free0 (parent_id);
		parent_id = _tmp5_;
		urn = _tmp6_;
		_tmp7_ = urn;
		_tmp8_ = g_utf8_validate (_tmp7_, (gssize) (-1), NULL);
		if (!_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			_tmp9_ = urn;
			_tmp10_ = rygel_tracker_search_container_urn_to_utf8 (self, _tmp9_);
			_g_free0 (urn);
			urn = _tmp10_;
		}
		_tmp13_ = urn;
		if (_tmp13_ == NULL) {
			_tmp12_ = TRUE;
		} else {
			const gchar* _tmp14_;
			_tmp14_ = parent_id;
			_tmp12_ = _tmp14_ == NULL;
		}
		_tmp15_ = _tmp12_;
		if (_tmp15_) {
			_tmp11_ = TRUE;
		} else {
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp16_ = parent_id;
			_tmp17_ = ((RygelMediaObject*) self)->id;
			_tmp11_ = g_strcmp0 (_tmp16_, _tmp17_) != 0;
		}
		_tmp18_ = _tmp11_;
		if (_tmp18_) {
			result = NULL;
			_g_free0 (urn);
			_g_free0 (parent_id);
			_g_free0 (value);
			_g_free0 (variable);
			_g_free0 (filter);
			return result;
		}
		_tmp19_ = urn;
		_tmp20_ = rygel_tracker_query_escape_string (_tmp19_);
		_g_free0 (urn);
		urn = _tmp20_;
		_tmp21_ = expression;
		_tmp22_ = ((RygelSearchExpression*) _tmp21_)->op;
		switch (GPOINTER_TO_INT (_tmp22_)) {
			case GUPNP_SEARCH_CRITERIA_OP_EQ:
			{
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp23_ = urn;
				_tmp24_ = g_strconcat ("<", _tmp23_, NULL);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strconcat (_tmp25_, ">", NULL);
				_g_free0 (value);
				value = _tmp26_;
				_g_free0 (_tmp25_);
				break;
			}
			case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
			{
				RygelRelationalExpression* _tmp27_;
				gconstpointer _tmp28_;
				gchar* _tmp29_;
				_tmp27_ = expression;
				_tmp28_ = ((RygelSearchExpression*) _tmp27_)->operand2;
				_tmp29_ = g_strdup ((const gchar*) _tmp28_);
				_g_free0 (value);
				value = _tmp29_;
				break;
			}
			default:
			break;
		}
		_g_free0 (urn);
		_g_free0 (parent_id);
	}
	_tmp31_ = variable;
	if (_tmp31_ == NULL) {
		_tmp30_ = TRUE;
	} else {
		const gchar* _tmp32_;
		_tmp32_ = value;
		_tmp30_ = _tmp32_ == NULL;
	}
	_tmp33_ = _tmp30_;
	if (_tmp33_) {
		result = NULL;
		_g_free0 (value);
		_g_free0 (variable);
		_g_free0 (filter);
		return result;
	}
	_tmp34_ = expression;
	_tmp35_ = ((RygelSearchExpression*) _tmp34_)->op;
	switch (GPOINTER_TO_INT (_tmp35_)) {
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		{
			const gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			const gchar* _tmp39_;
			gchar* _tmp40_;
			_tmp36_ = variable;
			_tmp37_ = g_strconcat (_tmp36_, " = ", NULL);
			_tmp38_ = _tmp37_;
			_tmp39_ = value;
			_tmp40_ = g_strconcat (_tmp38_, _tmp39_, NULL);
			_g_free0 (filter);
			filter = _tmp40_;
			_g_free0 (_tmp38_);
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			const gchar* _tmp41_;
			gchar* _tmp42_ = NULL;
			gchar* regex;
			const gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			const gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			_tmp41_ = value;
			_tmp42_ = rygel_tracker_query_escape_regex (_tmp41_);
			regex = _tmp42_;
			_tmp43_ = variable;
			_tmp44_ = g_strconcat ("regex(", _tmp43_, NULL);
			_tmp45_ = _tmp44_;
			_tmp46_ = g_strconcat (_tmp45_, ", \"", NULL);
			_tmp47_ = _tmp46_;
			_tmp48_ = regex;
			_tmp49_ = g_strconcat (_tmp47_, _tmp48_, NULL);
			_tmp50_ = _tmp49_;
			_tmp51_ = g_strconcat (_tmp50_, "\", \"i\")", NULL);
			_g_free0 (filter);
			filter = _tmp51_;
			_g_free0 (_tmp50_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp45_);
			_g_free0 (regex);
			break;
		}
		default:
		break;
	}
	result = filter;
	_g_free0 (value);
	_g_free0 (variable);
	return result;
}


/**
     * Chops the tail of a particular row in a 2-dimensional string array.
     *
     * param strvv the 2-dimenstional string array to chop the tail of.
     * param row the row whose tail needs to be chopped off.
     * param index index of the first element in the tail.
     *
     * FIXME: Stop using it once vala supports array slicing syntax for
     *        multi-dimentional arrays.
     */
static gchar** rygel_tracker_search_container_slice_strvv_tail (RygelTrackerSearchContainer* self, gchar** strvv, int strvv_length1, int strvv_length2, guint row, guint index, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	guint _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** slice;
	gint slice_length1;
	gint _slice_size_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strvv;
	_tmp0__length1 = strvv_length1;
	_tmp0__length2 = strvv_length2;
	_tmp1_ = _tmp0__length2;
	_tmp2_ = index;
	_tmp3_ = g_new0 (gchar*, (_tmp1_ - _tmp2_) + 1);
	slice = _tmp3_;
	slice_length1 = _tmp1_ - _tmp2_;
	_slice_size_ = slice_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				gchar** _tmp8_;
				gint _tmp8__length1;
				gchar** _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				gchar** _tmp11_;
				gint _tmp11__length1;
				gint _tmp11__length2;
				guint _tmp12_;
				gint _tmp13_;
				guint _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = slice;
				_tmp8__length1 = slice_length1;
				if (!(_tmp7_ < _tmp8__length1)) {
					break;
				}
				_tmp9_ = slice;
				_tmp9__length1 = slice_length1;
				_tmp10_ = i;
				_tmp11_ = strvv;
				_tmp11__length1 = strvv_length1;
				_tmp11__length2 = strvv_length2;
				_tmp12_ = row;
				_tmp13_ = i;
				_tmp14_ = index;
				_tmp15_ = _tmp11_[(_tmp12_ * _tmp11__length2) + (_tmp13_ + _tmp14_)];
				_tmp16_ = g_strdup (_tmp15_);
				_g_free0 (_tmp9_[_tmp10_]);
				_tmp9_[_tmp10_] = _tmp16_;
				_tmp17_ = _tmp9_[_tmp10_];
			}
		}
	}
	_tmp18_ = slice;
	_tmp18__length1 = slice_length1;
	if (result_length1) {
		*result_length1 = _tmp18__length1;
	}
	result = _tmp18_;
	return result;
}


static void rygel_tracker_search_container_class_init (RygelTrackerSearchContainerClass * klass) {
	rygel_tracker_search_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTrackerSearchContainerPrivate));
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_tracker_search_container_real_get_children;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_tracker_search_container_real_get_children_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_tracker_search_container_real_find_object;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_tracker_search_container_real_find_object_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_tracker_search_container_finalize;
}


static void rygel_tracker_search_container_instance_init (RygelTrackerSearchContainer * self) {
	self->priv = RYGEL_TRACKER_SEARCH_CONTAINER_GET_PRIVATE (self);
}


static void rygel_tracker_search_container_finalize (GObject* obj) {
	RygelTrackerSearchContainer * self;
	self = RYGEL_TRACKER_SEARCH_CONTAINER (obj);
	_rygel_tracker_query_unref0 (self->query);
	_rygel_tracker_item_factory_unref0 (self->item_factory);
	_g_object_unref0 (self->priv->resources);
	G_OBJECT_CLASS (rygel_tracker_search_container_parent_class)->finalize (obj);
}


/**
 * A container listing a Tracker search result.
 */
GType rygel_tracker_search_container_get_type (void) {
	static volatile gsize rygel_tracker_search_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_search_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerSearchContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_search_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerSearchContainer), 0, (GInstanceInitFunc) rygel_tracker_search_container_instance_init, NULL };
		GType rygel_tracker_search_container_type_id;
		rygel_tracker_search_container_type_id = g_type_register_static (RYGEL_TYPE_SIMPLE_CONTAINER, "RygelTrackerSearchContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_tracker_search_container_type_id__volatile, rygel_tracker_search_container_type_id);
	}
	return rygel_tracker_search_container_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



