/* rygel-main.c generated by valac 0.15.0.96-556a, the Vala compiler
 * generated from rygel-main.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <gio/gio.h>
#include <libgssdp/gssdp.h>
#include <locale.h>
#include <unistd.h>


#define RYGEL_TYPE_MAIN (rygel_main_get_type ())
#define RYGEL_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MAIN, RygelMain))
#define RYGEL_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MAIN, RygelMainClass))
#define RYGEL_IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MAIN))
#define RYGEL_IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MAIN))
#define RYGEL_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MAIN, RygelMainClass))

typedef struct _RygelMain RygelMain;
typedef struct _RygelMainClass RygelMainClass;
typedef struct _RygelMainPrivate RygelMainPrivate;

#define RYGEL_TYPE_PLUGIN_LOADER (rygel_plugin_loader_get_type ())
#define RYGEL_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoader))
#define RYGEL_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderClass))
#define RYGEL_IS_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN_LOADER))
#define RYGEL_IS_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN_LOADER))
#define RYGEL_PLUGIN_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderClass))

typedef struct _RygelPluginLoader RygelPluginLoader;
typedef struct _RygelPluginLoaderClass RygelPluginLoaderClass;

#define RYGEL_TYPE_ROOT_DEVICE_FACTORY (rygel_root_device_factory_get_type ())
#define RYGEL_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory))
#define RYGEL_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))
#define RYGEL_IS_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_IS_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))

typedef struct _RygelRootDeviceFactory RygelRootDeviceFactory;
typedef struct _RygelRootDeviceFactoryClass RygelRootDeviceFactoryClass;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_LOG_HANDLER (rygel_log_handler_get_type ())
#define RYGEL_LOG_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LOG_HANDLER, RygelLogHandler))
#define RYGEL_LOG_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LOG_HANDLER, RygelLogHandlerClass))
#define RYGEL_IS_LOG_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LOG_HANDLER))
#define RYGEL_IS_LOG_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LOG_HANDLER))
#define RYGEL_LOG_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LOG_HANDLER, RygelLogHandlerClass))

typedef struct _RygelLogHandler RygelLogHandler;
typedef struct _RygelLogHandlerClass RygelLogHandlerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_root_device_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_root_device_factory_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelRootDeviceFactoryPrivate RygelRootDeviceFactoryPrivate;
typedef struct _RygelPluginPrivate RygelPluginPrivate;

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
typedef struct _RygelMainCreateDeviceData RygelMainCreateDeviceData;

#define RYGEL_TYPE_DBUS_SERVICE (rygel_dbus_service_get_type ())
#define RYGEL_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DBUS_SERVICE, RygelDBusService))
#define RYGEL_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DBUS_SERVICE, RygelDBusServiceClass))
#define RYGEL_IS_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DBUS_SERVICE))
#define RYGEL_IS_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DBUS_SERVICE))
#define RYGEL_DBUS_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DBUS_SERVICE, RygelDBusServiceClass))

typedef struct _RygelDBusService RygelDBusService;
typedef struct _RygelDBusServiceClass RygelDBusServiceClass;

struct _RygelMain {
	GObject parent_instance;
	RygelMainPrivate * priv;
	gboolean need_restart;
};

struct _RygelMainClass {
	GObjectClass parent_class;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_aac_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_avc_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelMainPrivate {
	RygelPluginLoader* plugin_loader;
	GUPnPContextManager* context_manager;
	GeeArrayList* factories;
	GeeArrayList* root_devices;
	RygelConfiguration* config;
	RygelLogHandler* log_handler;
	GMainLoop* main_loop;
	gint exit_code;
};

struct _RygelRootDeviceFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelRootDeviceFactoryPrivate * priv;
	GUPnPContext* context;
};

struct _RygelRootDeviceFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelRootDeviceFactory *self);
};

struct _RygelPlugin {
	GUPnPResourceFactory parent_instance;
	RygelPluginPrivate * priv;
	gchar* name;
	gchar* title;
	gchar* description;
	gchar* desc_path;
	GeeArrayList* resource_infos;
	GeeArrayList* icon_infos;
	GeeArrayList* default_icons;
};

struct _RygelPluginClass {
	GUPnPResourceFactoryClass parent_class;
};

struct _RygelMainCreateDeviceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMain* self;
	RygelPlugin* plugin;
	RygelRootDeviceFactory* factory;
	RygelRootDeviceFactory* _tmp0_;
	RygelPlugin* _tmp1_;
	RygelRootDevice* _tmp2_;
	RygelRootDevice* device;
	gboolean _tmp3_;
	RygelPlugin* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	RygelConfiguration* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	RygelRootDevice* _tmp10_;
	gboolean _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* _tmp13_;
	RygelRootDevice* _tmp14_;
	RygelPlugin* _tmp15_;
	GError* _error_;
	const gchar* _tmp16_;
	RygelPlugin* _tmp17_;
	const gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY
} RygelCmdlineConfigError;
#define RYGEL_CMDLINE_CONFIG_ERROR rygel_cmdline_config_error_quark ()

static gpointer rygel_main_parent_class = NULL;
static gint rygel_main_PLUGIN_TIMEOUT;
static gint rygel_main_PLUGIN_TIMEOUT = 5;

GType rygel_main_get_type (void) G_GNUC_CONST;
GType rygel_plugin_loader_get_type (void) G_GNUC_CONST;
gpointer rygel_root_device_factory_ref (gpointer instance);
void rygel_root_device_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_root_device_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_root_device_factory (GValue* value, gpointer v_object);
void rygel_value_take_root_device_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_root_device_factory (const GValue* value);
GType rygel_root_device_factory_get_type (void) G_GNUC_CONST;
GType rygel_root_device_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
GType rygel_log_handler_get_type (void) G_GNUC_CONST;
#define RYGEL_MAIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MAIN, RygelMainPrivate))
enum  {
	RYGEL_MAIN_DUMMY_PROPERTY
};
static RygelMain* rygel_main_new (GError** error);
static RygelMain* rygel_main_construct (GType object_type, GError** error);
RygelLogHandler* rygel_log_handler_get_default (void);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
RygelPluginLoader* rygel_plugin_loader_new (void);
RygelPluginLoader* rygel_plugin_loader_construct (GType object_type);
GType rygel_plugin_get_type (void) G_GNUC_CONST;
static void rygel_main_on_plugin_loaded (RygelMain* self, RygelPluginLoader* plugin_loader, RygelPlugin* plugin);
static void _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender, RygelPlugin* plugin, gpointer self);
void rygel_signal_handler_setup (RygelMain* _main);
void rygel_main_exit (RygelMain* self, gint exit_code);
void rygel_signal_handler_cleanup (void);
void rygel_main_restart (RygelMain* self);
static gint rygel_main_run (RygelMain* self);
void rygel_main_dbus_available (RygelMain* self);
static GUPnPContextManager* rygel_main_create_context_manager (RygelMain* self);
void rygel_plugin_loader_load_plugins (RygelPluginLoader* self);
gint rygel_configuration_get_int (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
static gboolean __lambda18_ (RygelMain* self);
GeeCollection* rygel_plugin_loader_list_plugins (RygelPluginLoader* self);
static gboolean ___lambda18__gsource_func (gpointer self);
static void rygel_main_create_device (RygelMain* self, RygelPlugin* plugin, RygelRootDeviceFactory* factory, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_main_create_device_finish (RygelMain* self, GAsyncResult* _res_);
gint rygel_configuration_get_port (RygelConfiguration* self, GError** error);
static void rygel_main_on_context_available (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context);
static void _rygel_main_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self);
static void rygel_main_on_context_unavailable (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context);
static void _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self);
gchar* rygel_configuration_get_interface (RygelConfiguration* self, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error);
static void rygel_main_create_device_data_free (gpointer _data);
static gboolean rygel_main_create_device_co (RygelMainCreateDeviceData* _data_);
static gboolean _rygel_main_create_device_co_gsource_func (gpointer self);
RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error);
gboolean rygel_plugin_get_active (RygelPlugin* self);
gboolean rygel_configuration_get_upnp_enabled (RygelConfiguration* self, GError** error);
static void rygel_main_on_plugin_active_notify (RygelMain* self, GObject* obj, GParamSpec* spec);
static void _rygel_main_on_plugin_active_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
static gint rygel_main_main (gchar** args, int args_length1);
GType rygel_dbus_service_get_type (void) G_GNUC_CONST;
guint rygel_dbus_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
static gchar** _vala_array_dup1 (gchar** self, int length);
GQuark rygel_cmdline_config_error_quark (void);
void rygel_cmdline_config_parse_args (gchar*** args, int* args_length1, GError** error);
RygelDBusService* rygel_dbus_service_new (RygelMain* main);
RygelDBusService* rygel_dbus_service_construct (GType object_type, RygelMain* main);
void rygel_dbus_service_publish (RygelDBusService* self);
void rygel_dbus_service_unpublish (RygelDBusService* self);
static void rygel_main_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender, RygelPlugin* plugin, gpointer self) {
	rygel_main_on_plugin_loaded (self, _sender, plugin);
}


static RygelMain* rygel_main_construct (GType object_type, GError** error) {
	RygelMain * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelLogHandler* _tmp1_ = NULL;
	RygelMetaConfig* _tmp2_ = NULL;
	RygelPluginLoader* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GMainLoop* _tmp6_;
	RygelPluginLoader* _tmp7_;
	self = (RygelMain*) g_object_new (object_type, NULL);
	_tmp0_ = _ (PACKAGE_NAME);
	g_set_application_name (_tmp0_);
	_tmp1_ = rygel_log_handler_get_default ();
	_g_object_unref0 (self->priv->log_handler);
	self->priv->log_handler = _tmp1_;
	_tmp2_ = rygel_meta_config_get_default ();
	_g_object_unref0 (self->priv->config);
	self->priv->config = (RygelConfiguration*) _tmp2_;
	_tmp3_ = rygel_plugin_loader_new ();
	_g_object_unref0 (self->priv->plugin_loader);
	self->priv->plugin_loader = _tmp3_;
	_tmp4_ = gee_array_list_new (RYGEL_TYPE_ROOT_DEVICE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_g_object_unref0 (self->priv->root_devices);
	self->priv->root_devices = _tmp4_;
	_tmp5_ = gee_array_list_new (RYGEL_TYPE_ROOT_DEVICE_FACTORY, (GBoxedCopyFunc) rygel_root_device_factory_ref, rygel_root_device_factory_unref, NULL);
	_g_object_unref0 (self->priv->factories);
	self->priv->factories = _tmp5_;
	_tmp6_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->main_loop);
	self->priv->main_loop = _tmp6_;
	self->priv->exit_code = 0;
	_tmp7_ = self->priv->plugin_loader;
	g_signal_connect_object (_tmp7_, "plugin-available", (GCallback) _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available, self, 0);
	rygel_signal_handler_setup (self);
	return self;
}


static RygelMain* rygel_main_new (GError** error) {
	return rygel_main_construct (RYGEL_TYPE_MAIN, error);
}


void rygel_main_exit (RygelMain* self, gint exit_code) {
	gint _tmp0_;
	GMainLoop* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = exit_code;
	self->priv->exit_code = _tmp0_;
	_g_object_unref0 (self->priv->root_devices);
	self->priv->root_devices = NULL;
	_tmp1_ = self->priv->main_loop;
	g_main_loop_quit (_tmp1_);
	rygel_signal_handler_cleanup ();
}


void rygel_main_restart (RygelMain* self) {
	g_return_if_fail (self != NULL);
	self->need_restart = TRUE;
	rygel_main_exit (self, 0);
}


static gint rygel_main_run (RygelMain* self) {
	gint result = 0;
	GMainLoop* _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->main_loop;
	g_main_loop_run (_tmp0_);
	_tmp1_ = self->priv->exit_code;
	result = _tmp1_;
	return result;
}


static gboolean __lambda18_ (RygelMain* self) {
	gboolean result = FALSE;
	RygelPluginLoader* _tmp0_;
	GeeCollection* _tmp1_ = NULL;
	GeeCollection* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	_tmp0_ = self->priv->plugin_loader;
	_tmp1_ = rygel_plugin_loader_list_plugins (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_collection_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ == 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp5_) {
		gint _tmp6_;
		const gchar* _tmp7_ = NULL;
		gint _tmp8_;
		_tmp6_ = rygel_main_PLUGIN_TIMEOUT;
		_tmp7_ = ngettext ("No plugins found in %d second; giving up..", "No plugins found in %d seconds; giving up..", (gulong) _tmp6_);
		_tmp8_ = rygel_main_PLUGIN_TIMEOUT;
		g_warning (_tmp7_, _tmp8_);
		rygel_main_exit (self, -82);
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda18__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda18_ (self);
	return result;
}


void rygel_main_dbus_available (RygelMain* self) {
	GUPnPContextManager* _tmp0_ = NULL;
	RygelPluginLoader* _tmp1_;
	gint _tmp2_;
	gint timeout;
	gint _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = rygel_main_create_context_manager (self);
	_g_object_unref0 (self->priv->context_manager);
	self->priv->context_manager = _tmp0_;
	_tmp1_ = self->priv->plugin_loader;
	rygel_plugin_loader_load_plugins (_tmp1_);
	_tmp2_ = rygel_main_PLUGIN_TIMEOUT;
	timeout = _tmp2_;
	{
		RygelMetaConfig* _tmp3_ = NULL;
		RygelMetaConfig* config;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_ = 0;
		gint _tmp7_;
		_tmp3_ = rygel_meta_config_get_default ();
		config = _tmp3_;
		_tmp4_ = rygel_main_PLUGIN_TIMEOUT;
		_tmp5_ = G_MAXINT;
		_tmp6_ = rygel_configuration_get_int ((RygelConfiguration*) config, "plugin", "TIMEOUT", _tmp4_, _tmp5_, &_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (config);
			goto __catch97_g_error;
		}
		timeout = _tmp7_;
		_g_object_unref0 (config);
	}
	goto __finally97;
	__catch97_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally97:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = timeout;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp8_, ___lambda18__gsource_func, g_object_ref (self), g_object_unref);
}


static void rygel_main_on_plugin_loaded (RygelMain* self, RygelPluginLoader* plugin_loader, RygelPlugin* plugin) {
	GeeArrayList* _tmp0_;
	GeeIterator* _tmp1_ = NULL;
	GeeIterator* iterator;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin_loader != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = self->priv->factories;
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
	iterator = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_;
		gboolean _tmp3_ = FALSE;
		RygelPlugin* _tmp4_;
		GeeIterator* _tmp5_;
		gpointer _tmp6_ = NULL;
		RygelRootDeviceFactory* _tmp7_;
		_tmp2_ = iterator;
		_tmp3_ = gee_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = plugin;
		_tmp5_ = iterator;
		_tmp6_ = gee_iterator_get (_tmp5_);
		_tmp7_ = (RygelRootDeviceFactory*) _tmp6_;
		rygel_main_create_device (self, _tmp4_, _tmp7_, NULL, NULL);
		_rygel_root_device_factory_unref0 (_tmp7_);
	}
	_g_object_unref0 (iterator);
}


static void _rygel_main_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self) {
	rygel_main_on_context_available (self, _sender, p0);
}


static void _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self) {
	rygel_main_on_context_unavailable (self, _sender, p0);
}


static GUPnPContextManager* rygel_main_create_context_manager (RygelMain* self) {
	GUPnPContextManager* result = NULL;
	gint port;
	gint _tmp3_;
	GUPnPContextManager* _tmp4_ = NULL;
	GUPnPContextManager* manager;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	port = 0;
	{
		RygelConfiguration* _tmp0_;
		gint _tmp1_ = 0;
		gint _tmp2_;
		_tmp0_ = self->priv->config;
		_tmp1_ = rygel_configuration_get_port (_tmp0_, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch98_g_error;
		}
		port = _tmp2_;
	}
	goto __finally98;
	__catch98_g_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally98:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp3_ = port;
	_tmp4_ = gupnp_context_manager_create ((guint) _tmp3_);
	manager = _tmp4_;
	g_signal_connect_object (manager, "context-available", (GCallback) _rygel_main_on_context_available_gupnp_context_manager_context_available, self, 0);
	g_signal_connect_object (manager, "context-unavailable", (GCallback) _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable, self, 0);
	result = manager;
	return result;
}


static void rygel_main_on_context_available (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context) {
	gchar* iface;
	GUPnPContext* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GUPnPContext* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GUPnPContext* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	gboolean _tmp19_;
	gboolean _tmp24_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	g_return_if_fail (context != NULL);
	iface = NULL;
	_tmp0_ = context;
	_tmp1_ = gssdp_client_get_network ((GSSDPClient*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = context;
	_tmp4_ = gssdp_client_get_interface ((GSSDPClient*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = context;
	_tmp7_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_debug ("rygel-main.vala:137: New network %s (%s) context available. IP: %s", _tmp2_, _tmp5_, _tmp8_);
	{
		RygelConfiguration* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp9_ = self->priv->config;
		_tmp10_ = rygel_configuration_get_interface (_tmp9_, &_inner_error_);
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			goto __catch99_g_error;
		}
		_g_free0 (iface);
		iface = _tmp11_;
	}
	goto __finally99;
	__catch99_g_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally99:
	if (_inner_error_ != NULL) {
		_g_free0 (iface);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp14_ = iface;
	if (_tmp14_ == NULL) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp15_;
		GUPnPContext* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp15_ = iface;
		_tmp16_ = context;
		_tmp17_ = gssdp_client_get_interface ((GSSDPClient*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp13_ = g_strcmp0 (_tmp15_, _tmp18_) == 0;
	}
	_tmp19_ = _tmp13_;
	if (_tmp19_) {
		_tmp12_ = TRUE;
	} else {
		const gchar* _tmp20_;
		GUPnPContext* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp20_ = iface;
		_tmp21_ = context;
		_tmp22_ = gssdp_client_get_network ((GSSDPClient*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp12_ = g_strcmp0 (_tmp20_, _tmp23_) == 0;
	}
	_tmp24_ = _tmp12_;
	if (_tmp24_) {
		{
			GUPnPContext* _tmp25_;
			RygelRootDeviceFactory* _tmp26_;
			RygelRootDeviceFactory* factory;
			GeeArrayList* _tmp27_;
			RygelRootDeviceFactory* _tmp28_;
			RygelPluginLoader* _tmp29_;
			GeeCollection* _tmp30_ = NULL;
			GeeCollection* _tmp31_;
			GeeIterator* _tmp32_ = NULL;
			GeeIterator* _tmp33_;
			GeeIterator* iterator;
			_tmp25_ = context;
			_tmp26_ = rygel_root_device_factory_new (_tmp25_, &_inner_error_);
			factory = _tmp26_;
			if (_inner_error_ != NULL) {
				goto __catch100_g_error;
			}
			_tmp27_ = self->priv->factories;
			_tmp28_ = factory;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp28_);
			_tmp29_ = self->priv->plugin_loader;
			_tmp30_ = rygel_plugin_loader_list_plugins (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = gee_iterable_iterator ((GeeIterable*) _tmp31_);
			_tmp33_ = _tmp32_;
			_g_object_unref0 (_tmp31_);
			iterator = _tmp33_;
			while (TRUE) {
				GeeIterator* _tmp34_;
				gboolean _tmp35_ = FALSE;
				GeeIterator* _tmp36_;
				gpointer _tmp37_ = NULL;
				RygelPlugin* _tmp38_;
				RygelRootDeviceFactory* _tmp39_;
				_tmp34_ = iterator;
				_tmp35_ = gee_iterator_next (_tmp34_);
				if (!_tmp35_) {
					break;
				}
				_tmp36_ = iterator;
				_tmp37_ = gee_iterator_get (_tmp36_);
				_tmp38_ = (RygelPlugin*) _tmp37_;
				_tmp39_ = factory;
				rygel_main_create_device (self, _tmp38_, _tmp39_, NULL, NULL);
				_g_object_unref0 (_tmp38_);
			}
			_g_object_unref0 (iterator);
			_rygel_root_device_factory_unref0 (factory);
		}
		goto __finally100;
		__catch100_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp40_ = NULL;
			GError* _tmp41_;
			const gchar* _tmp42_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp40_ = _ ("Failed to create root device factory: %s");
			_tmp41_ = err;
			_tmp42_ = _tmp41_->message;
			g_warning (_tmp40_, _tmp42_);
			_g_error_free0 (err);
		}
		__finally100:
		if (_inner_error_ != NULL) {
			_g_free0 (iface);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		GUPnPContext* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		GUPnPContext* _tmp46_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		_tmp43_ = context;
		_tmp44_ = gssdp_client_get_network ((GSSDPClient*) _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = context;
		_tmp47_ = gssdp_client_get_interface ((GSSDPClient*) _tmp46_);
		_tmp48_ = _tmp47_;
		g_debug ("rygel-main.vala:162: Ignoring network %s (%s) context.", _tmp45_, _tmp48_);
	}
	_g_free0 (iface);
}


static void rygel_main_on_context_unavailable (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context) {
	GUPnPContext* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GUPnPContext* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GUPnPContext* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeIterator* _tmp10_ = NULL;
	GeeIterator* factory_iter;
	GeeArrayList* _tmp20_;
	GeeIterator* _tmp21_ = NULL;
	GeeIterator* device_iter;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	_tmp1_ = gssdp_client_get_network ((GSSDPClient*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = context;
	_tmp4_ = gssdp_client_get_interface ((GSSDPClient*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = context;
	_tmp7_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_debug ("rygel-main.vala:170: Network %s (%s) context now unavailable. IP: %s", _tmp2_, _tmp5_, _tmp8_);
	_tmp9_ = self->priv->factories;
	_tmp10_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp9_);
	factory_iter = _tmp10_;
	while (TRUE) {
		GeeIterator* _tmp11_;
		gboolean _tmp12_ = FALSE;
		GUPnPContext* _tmp13_;
		GeeIterator* _tmp14_;
		gpointer _tmp15_ = NULL;
		RygelRootDeviceFactory* _tmp16_;
		GUPnPContext* _tmp17_;
		gboolean _tmp18_;
		_tmp11_ = factory_iter;
		_tmp12_ = gee_iterator_next (_tmp11_);
		if (!_tmp12_) {
			break;
		}
		_tmp13_ = context;
		_tmp14_ = factory_iter;
		_tmp15_ = gee_iterator_get (_tmp14_);
		_tmp16_ = (RygelRootDeviceFactory*) _tmp15_;
		_tmp17_ = _tmp16_->context;
		_tmp18_ = _tmp13_ == _tmp17_;
		_rygel_root_device_factory_unref0 (_tmp16_);
		if (_tmp18_) {
			GeeIterator* _tmp19_;
			_tmp19_ = factory_iter;
			gee_iterator_remove (_tmp19_);
		}
	}
	_tmp20_ = self->priv->root_devices;
	_tmp21_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp20_);
	device_iter = _tmp21_;
	while (TRUE) {
		GeeIterator* _tmp22_;
		gboolean _tmp23_ = FALSE;
		GUPnPContext* _tmp24_;
		GeeIterator* _tmp25_;
		gpointer _tmp26_ = NULL;
		RygelRootDevice* _tmp27_;
		GUPnPContext* _tmp28_;
		GUPnPContext* _tmp29_;
		gboolean _tmp30_;
		_tmp22_ = device_iter;
		_tmp23_ = gee_iterator_next (_tmp22_);
		if (!_tmp23_) {
			break;
		}
		_tmp24_ = context;
		_tmp25_ = device_iter;
		_tmp26_ = gee_iterator_get (_tmp25_);
		_tmp27_ = (RygelRootDevice*) _tmp26_;
		_tmp28_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = _tmp24_ == _tmp29_;
		_g_object_unref0 (_tmp27_);
		if (_tmp30_) {
			GeeIterator* _tmp31_;
			_tmp31_ = device_iter;
			gee_iterator_remove (_tmp31_);
		}
	}
	_g_object_unref0 (device_iter);
	_g_object_unref0 (factory_iter);
}


static void rygel_main_create_device_data_free (gpointer _data) {
	RygelMainCreateDeviceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->plugin);
	_rygel_root_device_factory_unref0 (_data_->factory);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMainCreateDeviceData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _rygel_root_device_factory_ref0 (gpointer self) {
	return self ? rygel_root_device_factory_ref (self) : NULL;
}


static void rygel_main_create_device (RygelMain* self, RygelPlugin* plugin, RygelRootDeviceFactory* factory, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMainCreateDeviceData* _data_;
	RygelMain* _tmp0_;
	RygelPlugin* _tmp1_;
	RygelPlugin* _tmp2_;
	RygelRootDeviceFactory* _tmp3_;
	RygelRootDeviceFactory* _tmp4_;
	_data_ = g_slice_new0 (RygelMainCreateDeviceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_main_create_device);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_main_create_device_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = plugin;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->plugin = _tmp2_;
	_tmp3_ = factory;
	_tmp4_ = _rygel_root_device_factory_ref0 (_tmp3_);
	_data_->factory = _tmp4_;
	rygel_main_create_device_co (_data_);
}


static void rygel_main_create_device_finish (RygelMain* self, GAsyncResult* _res_) {
	RygelMainCreateDeviceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _rygel_main_create_device_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_main_create_device_co (self);
	return result;
}


static void _rygel_main_on_plugin_active_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_main_on_plugin_active_notify (self, _sender, pspec);
}


static gboolean rygel_main_create_device_co (RygelMainCreateDeviceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_main_create_device_co_gsource_func, _data_, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	{
		_data_->_tmp0_ = _data_->factory;
		_data_->_tmp1_ = _data_->plugin;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = rygel_root_device_factory_create (_data_->_tmp0_, _data_->_tmp1_, &_data_->_inner_error_);
		_data_->device = _data_->_tmp2_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch101_g_error;
		}
		_data_->_tmp4_ = _data_->plugin;
		_data_->_tmp5_ = rygel_plugin_get_active (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		if (_data_->_tmp6_) {
			_data_->_tmp7_ = _data_->self->priv->config;
			_data_->_tmp8_ = FALSE;
			_data_->_tmp8_ = rygel_configuration_get_upnp_enabled (_data_->_tmp7_, &_data_->_inner_error_);
			_data_->_tmp9_ = _data_->_tmp8_;
			if (_data_->_inner_error_ != NULL) {
				_g_object_unref0 (_data_->device);
				goto __catch101_g_error;
			}
			_data_->_tmp3_ = _data_->_tmp9_;
		} else {
			_data_->_tmp3_ = FALSE;
		}
		_data_->_tmp10_ = _data_->device;
		_data_->_tmp11_ = _data_->_tmp3_;
		gupnp_root_device_set_available ((GUPnPRootDevice*) _data_->_tmp10_, _data_->_tmp11_);
		_data_->_tmp12_ = _data_->self->priv->root_devices;
		if (_data_->_tmp12_ != NULL) {
			_data_->_tmp13_ = _data_->self->priv->root_devices;
			_data_->_tmp14_ = _data_->device;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp13_, _data_->_tmp14_);
			_data_->_tmp15_ = _data_->plugin;
			g_signal_connect_object ((GObject*) _data_->_tmp15_, "notify::active", (GCallback) _rygel_main_on_plugin_active_notify_g_object_notify, _data_->self, 0);
		}
		_g_object_unref0 (_data_->device);
	}
	goto __finally101;
	__catch101_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _ ("Failed to create RootDevice for %s. Reason: %s");
		_data_->_tmp17_ = _data_->plugin;
		_data_->_tmp18_ = _data_->_tmp17_->name;
		_data_->_tmp19_ = _data_->_error_;
		_data_->_tmp20_ = _data_->_tmp19_->message;
		g_warning (_data_->_tmp16_, _data_->_tmp18_, _data_->_tmp20_);
		_g_error_free0 (_data_->_error_);
	}
	__finally101:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_main_on_plugin_active_notify (RygelMain* self, GObject* obj, GParamSpec* spec) {
	GeeArrayList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GObject* _tmp2_;
	RygelPlugin* _tmp3_;
	RygelPlugin* plugin;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (spec != NULL);
	_tmp0_ = self->priv->root_devices;
	_tmp1_ = G_UNLIKELY (_tmp0_ == NULL);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = obj;
	_tmp3_ = _g_object_ref0 (RYGEL_IS_PLUGIN (_tmp2_) ? ((RygelPlugin*) _tmp2_) : NULL);
	plugin = _tmp3_;
	{
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		GeeArrayList* _device_list;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _device_size;
		gint _device_index;
		_tmp4_ = self->priv->root_devices;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_device_list = _tmp5_;
		_tmp6_ = _device_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_device_size = _tmp8_;
		_device_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GeeArrayList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_ = NULL;
			RygelRootDevice* device;
			RygelRootDevice* _tmp15_;
			GUPnPResourceFactory* _tmp16_;
			GUPnPResourceFactory* _tmp17_;
			RygelPlugin* _tmp18_;
			_tmp9_ = _device_index;
			_device_index = _tmp9_ + 1;
			_tmp10_ = _device_index;
			_tmp11_ = _device_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _device_list;
			_tmp13_ = _device_index;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
			device = (RygelRootDevice*) _tmp14_;
			_tmp15_ = device;
			_tmp16_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = plugin;
			if (_tmp17_ == GUPNP_RESOURCE_FACTORY (_tmp18_)) {
				RygelRootDevice* _tmp19_;
				RygelPlugin* _tmp20_;
				gboolean _tmp21_;
				gboolean _tmp22_;
				_tmp19_ = device;
				_tmp20_ = plugin;
				_tmp21_ = rygel_plugin_get_active (_tmp20_);
				_tmp22_ = _tmp21_;
				gupnp_root_device_set_available ((GUPnPRootDevice*) _tmp19_, _tmp22_);
			}
			_g_object_unref0 (device);
		}
		_g_object_unref0 (_device_list);
	}
	_g_object_unref0 (plugin);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gint rygel_main_main (gchar** args, int args_length1) {
	gint result = 0;
	RygelMain* main;
	RygelDBusService* service;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** original_args;
	gint original_args_length1;
	gint _original_args_size_;
	RygelMain* _tmp8_;
	gint _tmp9_ = 0;
	gint exit_code;
	RygelDBusService* _tmp10_;
	RygelMain* _tmp12_;
	gboolean _tmp13_;
	GError * _inner_error_ = NULL;
	main = NULL;
	service = NULL;
	_tmp0_ = args;
	_tmp0__length1 = args_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	original_args = _tmp1_;
	original_args_length1 = _tmp1__length1;
	_original_args_size_ = original_args_length1;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	{
		RygelMain* _tmp2_;
		RygelMain* _tmp3_;
		RygelMain* _tmp4_;
		RygelDBusService* _tmp5_;
		RygelDBusService* _tmp6_;
		rygel_cmdline_config_parse_args (&args, &args_length1, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY)) {
				goto __catch102_rygel_cmdline_config_error_version_only;
			}
			goto __catch102_g_error;
		}
		_tmp2_ = rygel_main_new (&_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY)) {
				goto __catch102_rygel_cmdline_config_error_version_only;
			}
			goto __catch102_g_error;
		}
		_g_object_unref0 (main);
		main = _tmp3_;
		_tmp4_ = main;
		_tmp5_ = rygel_dbus_service_new (_tmp4_);
		_g_object_unref0 (service);
		service = _tmp5_;
		_tmp6_ = service;
		rygel_dbus_service_publish (_tmp6_);
	}
	goto __finally102;
	__catch102_rygel_cmdline_config_error_version_only:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		result = 0;
		_g_error_free0 (err);
		original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (service);
		_g_object_unref0 (main);
		return result;
	}
	goto __finally102;
	__catch102_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp7_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = err->message;
		g_error ("rygel-main.vala:259: %s", _tmp7_);
		_g_error_free0 (err);
	}
	__finally102:
	if (_inner_error_ != NULL) {
		original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (service);
		_g_object_unref0 (main);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp8_ = main;
	_tmp9_ = rygel_main_run (_tmp8_);
	exit_code = _tmp9_;
	_tmp10_ = service;
	if (_tmp10_ != NULL) {
		RygelDBusService* _tmp11_;
		_tmp11_ = service;
		rygel_dbus_service_unpublish (_tmp11_);
	}
	_tmp12_ = main;
	_tmp13_ = _tmp12_->need_restart;
	if (_tmp13_) {
		gchar** _tmp14_;
		gint _tmp14__length1;
		const gchar* _tmp15_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		_tmp14_ = original_args;
		_tmp14__length1 = original_args_length1;
		_tmp15_ = _tmp14_[0];
		_tmp16_ = original_args;
		_tmp16__length1 = original_args_length1;
		execvp (_tmp15_, _tmp16_);
	}
	result = exit_code;
	original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (service);
	_g_object_unref0 (main);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return rygel_main_main (argv, argc);
}


static void rygel_main_class_init (RygelMainClass * klass) {
	rygel_main_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMainPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_main_finalize;
}


static void rygel_main_instance_init (RygelMain * self) {
	self->priv = RYGEL_MAIN_GET_PRIVATE (self);
}


static void rygel_main_finalize (GObject* obj) {
	RygelMain * self;
	self = RYGEL_MAIN (obj);
	_g_object_unref0 (self->priv->plugin_loader);
	_g_object_unref0 (self->priv->context_manager);
	_g_object_unref0 (self->priv->factories);
	_g_object_unref0 (self->priv->root_devices);
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->log_handler);
	_g_main_loop_unref0 (self->priv->main_loop);
	G_OBJECT_CLASS (rygel_main_parent_class)->finalize (obj);
}


GType rygel_main_get_type (void) {
	static volatile gsize rygel_main_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_main_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMain), 0, (GInstanceInitFunc) rygel_main_instance_init, NULL };
		GType rygel_main_type_id;
		rygel_main_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMain", &g_define_type_info, 0);
		g_once_init_leave (&rygel_main_type_id__volatile, rygel_main_type_id);
	}
	return rygel_main_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



