/* rygel-playbin-player.c generated by valac 0.15.2.4-51044, the Vala compiler
 * generated from rygel-playbin-player.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_PLAYBIN_TYPE_PLAYER (rygel_playbin_player_get_type ())
#define RYGEL_PLAYBIN_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer))
#define RYGEL_PLAYBIN_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerClass))
#define RYGEL_PLAYBIN_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_PLAYBIN_TYPE_PLAYER))
#define RYGEL_PLAYBIN_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_PLAYBIN_TYPE_PLAYER))
#define RYGEL_PLAYBIN_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerClass))

typedef struct _RygelPlaybinPlayer RygelPlaybinPlayer;
typedef struct _RygelPlaybinPlayerClass RygelPlaybinPlayerClass;
typedef struct _RygelPlaybinPlayerPrivate RygelPlaybinPlayerPrivate;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelPlaybinPlayer {
	GObject parent_instance;
	RygelPlaybinPlayerPrivate * priv;
};

struct _RygelPlaybinPlayerClass {
	GObjectClass parent_class;
};

struct _RygelPlaybinPlayerPrivate {
	GstElement* playbin;
	gchar* _playback_state;
};


static gpointer rygel_playbin_player_parent_class = NULL;
static RygelPlaybinPlayer* rygel_playbin_player_player;
static RygelPlaybinPlayer* rygel_playbin_player_player = NULL;
static RygelMediaPlayerIface* rygel_playbin_player_rygel_media_player_parent_iface = NULL;

GType rygel_playbin_player_get_type (void) G_GNUC_CONST;
#define RYGEL_PLAYBIN_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerPrivate))
enum  {
	RYGEL_PLAYBIN_PLAYER_DUMMY_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE,
	RYGEL_PLAYBIN_PLAYER_URI,
	RYGEL_PLAYBIN_PLAYER_VOLUME,
	RYGEL_PLAYBIN_PLAYER_DURATION,
	RYGEL_PLAYBIN_PLAYER_POSITION
};
static RygelPlaybinPlayer* rygel_playbin_player_new (void);
static RygelPlaybinPlayer* rygel_playbin_player_construct (GType object_type);
static gboolean rygel_playbin_player_bus_handler (RygelPlaybinPlayer* self, GstBus* bus, GstMessage* message);
static gboolean _rygel_playbin_player_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
RygelPlaybinPlayer* rygel_playbin_player_get_default (void);
static gboolean rygel_playbin_player_real_seek (RygelMediaPlayer* base, GstClockTime time);
static gchar** rygel_playbin_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** rygel_playbin_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gboolean rygel_playbin_player_is_rendering_image (RygelPlaybinPlayer* self);
static inline GstCaps* _dynamic_get_caps0 (GstElement* obj);
static inline gchar* _dynamic_get_uri1 (GstElement* obj);
static inline void _dynamic_set_uri2 (GstElement* obj, const gchar* value);
static inline gdouble _dynamic_get_volume3 (GstElement* obj);
static inline void _dynamic_set_volume4 (GstElement* obj, gdouble value);
static void rygel_playbin_player_finalize (GObject* obj);
static void _vala_rygel_playbin_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_playbin_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gchar* RYGEL_PLAYBIN_PLAYER_protocols[2] = {"http-get", "rtsp"};
static const gchar* RYGEL_PLAYBIN_PLAYER_mime_types[29] = {"audio/mpeg", "application/ogg", "audio/x-vorbis", "audio/x-vorbis+ogg", "audio/x-ms-wma", "audio/x-ms-asf", "audio/x-flac", "audio/x-mod", "audio/x-wav", "audio/x-ac3", "audio/x-m4a", "image/jpeg", "image/png", "video/x-theora", "video/x-dirac", "video/x-wmv", "video/x-wma", "video/x-msvideo", "video/x-3ivx", "video/x-3ivx", "video/x-matroska", "video/x-mkv", "video/mpeg", "video/mp4", "video/x-ms-asf", "video/x-xvid", "video/x-ms-wmv", "audio/L16;rate=44100;channels=2", "audio/L16;rate=44100;channels=1"};

static gboolean _rygel_playbin_player_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = rygel_playbin_player_bus_handler (self, bus, message);
	return result;
}


static RygelPlaybinPlayer* rygel_playbin_player_construct (GType object_type) {
	RygelPlaybinPlayer * self = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_;
	GstElement* _tmp2_;
	GstBus* _tmp3_ = NULL;
	GstBus* bus;
	self = (RygelPlaybinPlayer*) g_object_new (object_type, NULL);
	_tmp0_ = gst_element_factory_make ("playbin2", NULL);
	gst_object_ref_sink (_tmp0_);
	_gst_object_unref0 (self->priv->playbin);
	self->priv->playbin = _tmp0_;
	_tmp1_ = self->priv->playbin;
	g_assert (_tmp1_ != NULL);
	_tmp2_ = self->priv->playbin;
	_tmp3_ = gst_element_get_bus (_tmp2_);
	bus = _tmp3_;
	gst_bus_add_watch_full (bus, G_PRIORITY_DEFAULT, _rygel_playbin_player_bus_handler_gst_bus_func, g_object_ref (self), g_object_unref);
	_gst_object_unref0 (bus);
	return self;
}


static RygelPlaybinPlayer* rygel_playbin_player_new (void) {
	return rygel_playbin_player_construct (RYGEL_PLAYBIN_TYPE_PLAYER);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelPlaybinPlayer* rygel_playbin_player_get_default (void) {
	RygelPlaybinPlayer* result = NULL;
	RygelPlaybinPlayer* _tmp0_;
	RygelPlaybinPlayer* _tmp2_;
	RygelPlaybinPlayer* _tmp3_;
	_tmp0_ = rygel_playbin_player_player;
	if (_tmp0_ == NULL) {
		RygelPlaybinPlayer* _tmp1_;
		_tmp1_ = rygel_playbin_player_new ();
		_g_object_unref0 (rygel_playbin_player_player);
		rygel_playbin_player_player = _tmp1_;
	}
	_tmp2_ = rygel_playbin_player_player;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static gboolean rygel_playbin_player_real_seek (RygelMediaPlayer* base, GstClockTime time) {
	RygelPlaybinPlayer * self;
	gboolean result = FALSE;
	GstElement* _tmp0_;
	GstClockTime _tmp1_;
	gboolean _tmp2_ = FALSE;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->playbin;
	_tmp1_ = time;
	_tmp2_ = gst_element_seek (_tmp0_, 1.0, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH, GST_SEEK_TYPE_SET, (gint64) _tmp1_, GST_SEEK_TYPE_NONE, (gint64) (-1));
	result = _tmp2_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** rygel_playbin_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1) {
	RygelPlaybinPlayer * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = (RYGEL_PLAYBIN_PLAYER_protocols != NULL) ? _vala_array_dup1 (RYGEL_PLAYBIN_PLAYER_protocols, G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_protocols)) : ((gpointer) RYGEL_PLAYBIN_PLAYER_protocols);
	_tmp0__length1 = G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_protocols);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** rygel_playbin_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1) {
	RygelPlaybinPlayer * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = (RYGEL_PLAYBIN_PLAYER_mime_types != NULL) ? _vala_array_dup2 (RYGEL_PLAYBIN_PLAYER_mime_types, G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_mime_types)) : ((gpointer) RYGEL_PLAYBIN_PLAYER_mime_types);
	_tmp0__length1 = G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_mime_types);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static inline GstCaps* _dynamic_get_caps0 (GstElement* obj) {
	GstCaps* result;
	g_object_get (obj, "caps", &result, NULL);
	return result;
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


static gboolean rygel_playbin_player_is_rendering_image (RygelPlaybinPlayer* self) {
	gboolean result = FALSE;
	GstElement* typefind = NULL;
	GstElement* _tmp0_;
	GstElement* _tmp1_ = NULL;
	GstElement* _tmp2_;
	GstCaps* _tmp3_;
	GstCaps* _tmp4_;
	GstCaps* caps;
	GstCaps* _tmp5_;
	const GstStructure* _tmp6_ = NULL;
	GstStructure* _tmp7_;
	GstStructure* structure;
	gboolean _tmp8_ = FALSE;
	const GstStructure* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp13_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->playbin;
	_tmp1_ = gst_bin_get_by_name (GST_IS_BIN (_tmp0_) ? ((GstBin*) _tmp0_) : NULL, "typefind");
	_gst_object_unref0 (typefind);
	typefind = _tmp1_;
	_tmp2_ = typefind;
	_tmp3_ = _dynamic_get_caps0 (_tmp2_);
	_tmp4_ = _tmp3_;
	caps = _tmp4_;
	_tmp5_ = caps;
	_tmp6_ = gst_caps_get_structure (_tmp5_, (guint) 0);
	_tmp7_ = _gst_structure_copy0 (_tmp6_);
	structure = _tmp7_;
	_tmp9_ = structure;
	_tmp10_ = gst_structure_get_name (_tmp9_);
	if (g_strcmp0 (_tmp10_, "image/jpeg") == 0) {
		_tmp8_ = TRUE;
	} else {
		const GstStructure* _tmp11_;
		const gchar* _tmp12_ = NULL;
		_tmp11_ = structure;
		_tmp12_ = gst_structure_get_name (_tmp11_);
		_tmp8_ = g_strcmp0 (_tmp12_, "image/png") == 0;
	}
	_tmp13_ = _tmp8_;
	result = _tmp13_;
	_gst_structure_free0 (structure);
	_gst_caps_unref0 (caps);
	_gst_object_unref0 (typefind);
	return result;
}


static gboolean rygel_playbin_player_bus_handler (RygelPlaybinPlayer* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	GstMessage* _tmp0_;
	GstMessageType _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = message;
	_tmp1_ = _tmp0_->type;
	switch (_tmp1_) {
		case GST_MESSAGE_STATE_CHANGED:
		{
			GstMessage* _tmp2_;
			GstObject* _tmp3_;
			GstElement* _tmp4_;
			_tmp2_ = message;
			_tmp3_ = _tmp2_->src;
			_tmp4_ = self->priv->playbin;
			if (_tmp3_ == GST_OBJECT (_tmp4_)) {
				GstState old_state = 0;
				GstState new_state = 0;
				GstMessage* _tmp5_;
				GstState _tmp6_ = 0;
				GstState _tmp7_ = 0;
				gboolean _tmp8_ = FALSE;
				GstState _tmp9_;
				gboolean _tmp11_;
				_tmp5_ = message;
				gst_message_parse_state_changed (_tmp5_, &_tmp6_, &_tmp7_, NULL);
				old_state = _tmp6_;
				new_state = _tmp7_;
				_tmp9_ = old_state;
				if (_tmp9_ == GST_STATE_READY) {
					GstState _tmp10_;
					_tmp10_ = new_state;
					_tmp8_ = _tmp10_ == GST_STATE_PAUSED;
				} else {
					_tmp8_ = FALSE;
				}
				_tmp11_ = _tmp8_;
				if (_tmp11_) {
					g_object_notify ((GObject*) self, "duration");
				}
			}
			break;
		}
		case GST_MESSAGE_EOS:
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = rygel_playbin_player_is_rendering_image (self);
			if (!_tmp12_) {
				g_debug ("rygel-playbin-player.vala:199: EOS");
				rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
			} else {
				g_debug ("rygel-playbin-player.vala:202: Content is image, ignoring EOS");
			}
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			GError* _error_ = NULL;
			gchar* error_message = NULL;
			GstMessage* _tmp13_;
			GError* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			GstElement* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp13_ = message;
			gst_message_parse_error (_tmp13_, &_tmp14_, &_tmp15_);
			_g_error_free0 (_error_);
			_error_ = _tmp14_;
			_g_free0 (error_message);
			error_message = _tmp15_;
			_tmp16_ = self->priv->playbin;
			_tmp17_ = gst_object_get_name ((GstObject*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = _tmp18_;
			_tmp20_ = error_message;
			g_warning ("rygel-playbin-player.vala:212: Error from GStreamer element %s: %s", _tmp19_, _tmp20_);
			_g_free0 (_tmp19_);
			g_warning ("rygel-playbin-player.vala:215: Going to STOPPED state");
			rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
			_g_free0 (error_message);
			_g_error_free0 (_error_);
			break;
		}
		default:
		break;
	}
	result = TRUE;
	return result;
}


static gchar* rygel_playbin_player_real_get_playback_state (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->_playback_state;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_playbin_player_real_set_playback_state (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = value;
	g_debug ("rygel-playbin-player.vala:69: Changing playback state to %s.", _tmp0_);
	_tmp1_ = value;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->_playback_state);
	self->priv->_playback_state = _tmp2_;
	_tmp3_ = self->priv->_playback_state;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("STOPPED")))) {
		switch (0) {
			default:
			{
				GstElement* _tmp7_;
				_tmp7_ = self->priv->playbin;
				gst_element_set_state (_tmp7_, GST_STATE_NULL);
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
		switch (0) {
			default:
			{
				GstElement* _tmp8_;
				_tmp8_ = self->priv->playbin;
				gst_element_set_state (_tmp8_, GST_STATE_PAUSED);
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("PLAYING")))) {
		switch (0) {
			default:
			{
				GstElement* _tmp9_;
				_tmp9_ = self->priv->playbin;
				gst_element_set_state (_tmp9_, GST_STATE_PLAYING);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	g_object_notify ((GObject *) self, "playback-state");
}


static inline gchar* _dynamic_get_uri1 (GstElement* obj) {
	gchar* result;
	g_object_get (obj, "uri", &result, NULL);
	return result;
}


static gchar* rygel_playbin_player_real_get_uri (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	GstElement* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->playbin;
	_tmp1_ = _dynamic_get_uri1 (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static inline void _dynamic_set_uri2 (GstElement* obj, const gchar* value) {
	g_object_set (obj, "uri", value, NULL);
}


static void rygel_playbin_player_real_set_uri (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	GstElement* _tmp0_;
	GstElement* _tmp1_;
	const gchar* _tmp2_;
	GstElement* _tmp3_;
	const gchar* _tmp4_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->playbin;
	gst_element_set_state (_tmp0_, GST_STATE_NULL);
	_tmp1_ = self->priv->playbin;
	_tmp2_ = value;
	_dynamic_set_uri2 (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->playbin;
	gst_element_set_state (_tmp3_, GST_STATE_PLAYING);
	_tmp4_ = value;
	g_debug ("rygel-playbin-player.vala:97: URI set to %s.", _tmp4_);
	g_object_notify ((GObject *) self, "uri");
}


static inline gdouble _dynamic_get_volume3 (GstElement* obj) {
	gdouble result;
	g_object_get (obj, "volume", &result, NULL);
	return result;
}


static gdouble rygel_playbin_player_real_get_volume (RygelMediaPlayer* base) {
	gdouble result;
	RygelPlaybinPlayer* self;
	GstElement* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->playbin;
	_tmp1_ = _dynamic_get_volume3 (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static inline void _dynamic_set_volume4 (GstElement* obj, gdouble value) {
	g_object_set (obj, "volume", value, NULL);
}


static void rygel_playbin_player_real_set_volume (RygelMediaPlayer* base, gdouble value) {
	RygelPlaybinPlayer* self;
	GstElement* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = self->priv->playbin;
	_tmp1_ = value;
	_dynamic_set_volume4 (_tmp0_, _tmp1_);
	_tmp2_ = value;
	g_debug ("rygel-playbin-player.vala:108: volume set to %f.", _tmp2_);
	g_object_notify ((GObject *) self, "volume");
}


static gint64 rygel_playbin_player_real_get_duration (RygelMediaPlayer* base) {
	gint64 result;
	RygelPlaybinPlayer* self;
	GstFormat format;
	gint64 dur = 0LL;
	GstElement* _tmp0_;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
	self = (RygelPlaybinPlayer*) base;
	format = GST_FORMAT_TIME;
	_tmp0_ = self->priv->playbin;
	_tmp2_ = gst_element_query_duration (_tmp0_, &format, &_tmp1_);
	dur = _tmp1_;
	if (_tmp2_) {
		gint64 _tmp3_;
		_tmp3_ = dur;
		result = _tmp3_;
		return result;
	} else {
		result = (gint64) 0;
		return result;
	}
}


static gint64 rygel_playbin_player_real_get_position (RygelMediaPlayer* base) {
	gint64 result;
	RygelPlaybinPlayer* self;
	GstFormat format;
	gint64 pos = 0LL;
	GstElement* _tmp0_;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
	self = (RygelPlaybinPlayer*) base;
	format = GST_FORMAT_TIME;
	_tmp0_ = self->priv->playbin;
	_tmp2_ = gst_element_query_position (_tmp0_, &format, &_tmp1_);
	pos = _tmp1_;
	if (_tmp2_) {
		gint64 _tmp3_;
		_tmp3_ = pos;
		result = _tmp3_;
		return result;
	} else {
		result = (gint64) 0;
		return result;
	}
}


static void rygel_playbin_player_class_init (RygelPlaybinPlayerClass * klass) {
	rygel_playbin_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelPlaybinPlayerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_playbin_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_playbin_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_playbin_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE, g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_VOLUME, g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_DURATION, g_param_spec_int64 ("duration", "duration", "duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_POSITION, g_param_spec_int64 ("position", "position", "position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_playbin_player_rygel_media_player_interface_init (RygelMediaPlayerIface * iface) {
	rygel_playbin_player_rygel_media_player_parent_iface = g_type_interface_peek_parent (iface);
	iface->seek = (gboolean (*)(RygelMediaPlayer*, GstClockTime)) rygel_playbin_player_real_seek;
	iface->get_protocols = (gchar** (*)(RygelMediaPlayer*, int*)) rygel_playbin_player_real_get_protocols;
	iface->get_mime_types = (gchar** (*)(RygelMediaPlayer*, int*)) rygel_playbin_player_real_get_mime_types;
	iface->get_playback_state = rygel_playbin_player_real_get_playback_state;
	iface->set_playback_state = rygel_playbin_player_real_set_playback_state;
	iface->get_uri = rygel_playbin_player_real_get_uri;
	iface->set_uri = rygel_playbin_player_real_set_uri;
	iface->get_volume = rygel_playbin_player_real_get_volume;
	iface->set_volume = rygel_playbin_player_real_set_volume;
	iface->get_duration = rygel_playbin_player_real_get_duration;
	iface->get_position = rygel_playbin_player_real_get_position;
}


static void rygel_playbin_player_instance_init (RygelPlaybinPlayer * self) {
	gchar* _tmp0_;
	self->priv = RYGEL_PLAYBIN_PLAYER_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("STOPPED");
	self->priv->_playback_state = _tmp0_;
}


static void rygel_playbin_player_finalize (GObject* obj) {
	RygelPlaybinPlayer * self;
	self = RYGEL_PLAYBIN_PLAYER (obj);
	_gst_object_unref0 (self->priv->playbin);
	_g_free0 (self->priv->_playback_state);
	G_OBJECT_CLASS (rygel_playbin_player_parent_class)->finalize (obj);
}


GType rygel_playbin_player_get_type (void) {
	static volatile gsize rygel_playbin_player_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_playbin_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlaybinPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_playbin_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaybinPlayer), 0, (GInstanceInitFunc) rygel_playbin_player_instance_init, NULL };
		static const GInterfaceInfo rygel_media_player_info = { (GInterfaceInitFunc) rygel_playbin_player_rygel_media_player_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_playbin_player_type_id;
		rygel_playbin_player_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPlaybinPlayer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_playbin_player_type_id, RYGEL_TYPE_MEDIA_PLAYER, &rygel_media_player_info);
		g_once_init_leave (&rygel_playbin_player_type_id__volatile, rygel_playbin_player_type_id);
	}
	return rygel_playbin_player_type_id__volatile;
}


static void _vala_rygel_playbin_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelPlaybinPlayer * self;
	self = RYGEL_PLAYBIN_PLAYER (object);
	switch (property_id) {
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE:
		g_value_take_string (value, rygel_media_player_get_playback_state ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_URI:
		g_value_take_string (value, rygel_media_player_get_uri ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_VOLUME:
		g_value_set_double (value, rygel_media_player_get_volume ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_DURATION:
		g_value_set_int64 (value, rygel_media_player_get_duration ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_POSITION:
		g_value_set_int64 (value, rygel_media_player_get_position ((RygelMediaPlayer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_playbin_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelPlaybinPlayer * self;
	self = RYGEL_PLAYBIN_PLAYER (object);
	switch (property_id) {
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE:
		rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_URI:
		rygel_media_player_set_uri ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_VOLUME:
		rygel_media_player_set_volume ((RygelMediaPlayer*) self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



