/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __RYGEL_TRACKER_VIDEO_CATEGORY_H__
#define __RYGEL_TRACKER_VIDEO_CATEGORY_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-media-container.h>
#include <rygel-media-item.h>
#include "rygel-tracker-category.h"

G_BEGIN_DECLS


#define RYGEL_TYPE_TRACKER_VIDEO_CATEGORY (rygel_tracker_video_category_get_type ())
#define RYGEL_TRACKER_VIDEO_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_VIDEO_CATEGORY, RygelTrackerVideoCategory))
#define RYGEL_TRACKER_VIDEO_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_VIDEO_CATEGORY, RygelTrackerVideoCategoryClass))
#define RYGEL_IS_TRACKER_VIDEO_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_VIDEO_CATEGORY))
#define RYGEL_IS_TRACKER_VIDEO_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_VIDEO_CATEGORY))
#define RYGEL_TRACKER_VIDEO_CATEGORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_VIDEO_CATEGORY, RygelTrackerVideoCategoryClass))

typedef struct _RygelTrackerVideoCategory RygelTrackerVideoCategory;
typedef struct _RygelTrackerVideoCategoryClass RygelTrackerVideoCategoryClass;
typedef struct _RygelTrackerVideoCategoryPrivate RygelTrackerVideoCategoryPrivate;

/**
 * Represents Tracker Video category.
 */
struct _RygelTrackerVideoCategory {
	RygelTrackerCategory parent_instance;
	RygelTrackerVideoCategoryPrivate * priv;
};

struct _RygelTrackerVideoCategoryClass {
	RygelTrackerCategoryClass parent_class;
};


RygelTrackerVideoCategory* rygel_tracker_video_category_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title);
RygelTrackerVideoCategory* rygel_tracker_video_category_new (const char* id, RygelMediaContainer* parent, const char* title);
GType rygel_tracker_video_category_get_type (void);


G_END_DECLS

#endif
