/*
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __RYGEL_HTTP_RESPONSE_H__
#define __RYGEL_HTTP_RESPONSE_H__

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <gst/gst.h>
#include "rygel-state-machine.h"

G_BEGIN_DECLS


#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;

#define RYGEL_TYPE_SEEK (rygel_seek_get_type ())
#define RYGEL_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEEK, RygelSeek))
#define RYGEL_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEEK, RygelSeekClass))
#define RYGEL_IS_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEEK))
#define RYGEL_IS_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEEK))
#define RYGEL_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEEK, RygelSeekClass))

typedef struct _RygelSeek RygelSeek;
typedef struct _RygelSeekClass RygelSeekClass;
typedef struct _RygelSeekPrivate RygelSeekPrivate;

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
	SoupMessage* msg;
	GCancellable* cancellable;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPResponse* self, GCancellable* cancellable);
	void (*end) (RygelHTTPResponse* self, gboolean aborted, guint status);
};

struct _RygelSeek {
	GObject parent_instance;
	RygelSeekPrivate * priv;
};

struct _RygelSeekClass {
	GObjectClass parent_class;
};


RygelHTTPResponse* rygel_http_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, gboolean partial);
RygelHTTPResponse* rygel_http_response_new (SoupServer* server, SoupMessage* msg, gboolean partial);
void rygel_http_response_run (RygelHTTPResponse* self, GCancellable* cancellable);
void rygel_http_response_push_data (RygelHTTPResponse* self, void* data, gsize length);
void rygel_http_response_end (RygelHTTPResponse* self, gboolean aborted, guint status);
SoupServer* rygel_http_response_get_server (RygelHTTPResponse* self);
GType rygel_http_response_get_type (void);
RygelSeek* rygel_seek_construct (GType object_type, GstFormat format, gint64 start, gint64 stop);
RygelSeek* rygel_seek_new (GstFormat format, gint64 start, gint64 stop);
GstFormat rygel_seek_get_format (RygelSeek* self);
gint64 rygel_seek_get_start (RygelSeek* self);
void rygel_seek_set_start (RygelSeek* self, gint64 value);
gint64 rygel_seek_get_stop (RygelSeek* self);
void rygel_seek_set_stop (RygelSeek* self, gint64 value);
gint64 rygel_seek_get_length (RygelSeek* self);
GType rygel_seek_get_type (void);


G_END_DECLS

#endif
