/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-media-item.h"




enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
static GstElement* rygel_media_item_real_create_stream_source (RygelMediaItem* self);
static gpointer rygel_media_item_parent_class = NULL;
static void rygel_media_item_finalize (GObject* obj);



RygelMediaItem* rygel_media_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class) {
	RygelMediaItem * self;
	char* _tmp1;
	const char* _tmp0;
	char* _tmp3;
	const char* _tmp2;
	char* _tmp5;
	const char* _tmp4;
	GeeArrayList* _tmp6;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	((RygelMediaObject*) self)->id = (_tmp1 = (_tmp0 = id, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), ((RygelMediaObject*) self)->id = (g_free (((RygelMediaObject*) self)->id), NULL), _tmp1);
	((RygelMediaObject*) self)->parent = parent;
	_tmp3 = NULL;
	_tmp2 = NULL;
	((RygelMediaObject*) self)->title = (_tmp3 = (_tmp2 = title, (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), ((RygelMediaObject*) self)->title = (g_free (((RygelMediaObject*) self)->title), NULL), _tmp3);
	_tmp5 = NULL;
	_tmp4 = NULL;
	self->upnp_class = (_tmp5 = (_tmp4 = upnp_class, (_tmp4 == NULL) ? NULL : g_strdup (_tmp4)), self->upnp_class = (g_free (self->upnp_class), NULL), _tmp5);
	_tmp6 = NULL;
	self->uris = (_tmp6 = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal), (self->uris == NULL) ? NULL : (self->uris = (g_object_unref (self->uris), NULL)), _tmp6);
	return self;
}


RygelMediaItem* rygel_media_item_new (const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class) {
	return rygel_media_item_construct (RYGEL_TYPE_MEDIA_ITEM, id, parent, title, upnp_class);
}


/* Live media items need to provide a nice working implementation of this
 method if they can/do no provide a valid URI*/
static GstElement* rygel_media_item_real_create_stream_source (RygelMediaItem* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NULL;
}


GstElement* rygel_media_item_create_stream_source (RygelMediaItem* self) {
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->create_stream_source (self);
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
	RYGEL_MEDIA_ITEM_CLASS (klass)->create_stream_source = rygel_media_item_real_create_stream_source;
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	self->size = (glong) (-1);
	self->duration = (glong) (-1);
	self->bitrate = -1;
	self->sample_freq = -1;
	self->bits_per_sample = -1;
	self->n_audio_channels = -1;
	self->track_number = -1;
	self->width = -1;
	self->height = -1;
	self->color_depth = -1;
}


static void rygel_media_item_finalize (GObject* obj) {
	RygelMediaItem * self;
	self = RYGEL_MEDIA_ITEM (obj);
	self->author = (g_free (self->author), NULL);
	self->album = (g_free (self->album), NULL);
	self->date = (g_free (self->date), NULL);
	self->upnp_class = (g_free (self->upnp_class), NULL);
	(self->uris == NULL) ? NULL : (self->uris = (g_object_unref (self->uris), NULL));
	self->mime_type = (g_free (self->mime_type), NULL);
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
}


GType rygel_media_item_get_type (void) {
	static GType rygel_media_item_type_id = 0;
	if (rygel_media_item_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, 0);
	}
	return rygel_media_item_type_id;
}




