/*
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __RYGEL_MEDIA_SERVER_FACTORY_H__
#define __RYGEL_MEDIA_SERVER_FACTORY_H__

#include <glib.h>
#include <glib-object.h>
#include "rygel-media-server.h"
#include "rygel-plugin.h"

G_BEGIN_DECLS


#define RYGEL_TYPE_MEDIA_SERVER_FACTORY (rygel_media_server_factory_get_type ())
#define RYGEL_MEDIA_SERVER_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_SERVER_FACTORY, RygelMediaServerFactory))
#define RYGEL_MEDIA_SERVER_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_SERVER_FACTORY, RygelMediaServerFactoryClass))
#define RYGEL_IS_MEDIA_SERVER_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_SERVER_FACTORY))
#define RYGEL_IS_MEDIA_SERVER_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_SERVER_FACTORY))
#define RYGEL_MEDIA_SERVER_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_SERVER_FACTORY, RygelMediaServerFactoryClass))

typedef struct _RygelMediaServerFactory RygelMediaServerFactory;
typedef struct _RygelMediaServerFactoryClass RygelMediaServerFactoryClass;
typedef struct _RygelMediaServerFactoryPrivate RygelMediaServerFactoryPrivate;
typedef struct _RygelParamSpecMediaServerFactory RygelParamSpecMediaServerFactory;

typedef enum  {
	MEDIA_SERVER_FACTORY_ERROR_XML_PARSE
} MediaServerFactoryError;
#define MEDIA_SERVER_FACTORY_ERROR media_server_factory_error_quark ()
/**
 * Factory for MediaServer objects. Give it a plugin and it will create a
 * MediaServer device for that.
 */
struct _RygelMediaServerFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaServerFactoryPrivate * priv;
};

struct _RygelMediaServerFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaServerFactory *self);
};

struct _RygelParamSpecMediaServerFactory {
	GParamSpec parent_instance;
};


GQuark media_server_factory_error_quark (void);
#define RYGEL_MEDIA_SERVER_FACTORY_DESC_DOC "xml/description.xml"
#define RYGEL_MEDIA_SERVER_FACTORY_XBOX_DESC_DOC "xml/description-xbox360.xml"
#define RYGEL_MEDIA_SERVER_FACTORY_DESC_PREFIX "Rygel"
#define RYGEL_MEDIA_SERVER_FACTORY_ROOT_GCONF_PATH "/apps/rygel/"
RygelMediaServerFactory* rygel_media_server_factory_construct (GType object_type, GError** error);
RygelMediaServerFactory* rygel_media_server_factory_new (GError** error);
RygelMediaServer* rygel_media_server_factory_create_media_server (RygelMediaServerFactory* self, RygelPlugin* plugin, GError** error);
GParamSpec* rygel_param_spec_media_server_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
gpointer rygel_value_get_media_server_factory (const GValue* value);
void rygel_value_set_media_server_factory (GValue* value, gpointer v_object);
GType rygel_media_server_factory_get_type (void);
gpointer rygel_media_server_factory_ref (gpointer instance);
void rygel_media_server_factory_unref (gpointer instance);


G_END_DECLS

#endif
