/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-media-tracker.h"
#include <gee/arraylist.h>
#include <rygel-http-server.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-media-item.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <gee/collection.h>
#include <rygel-media-object.h>
#include <rygel-media-container.h>
#include "rygel-tracker-container.h"




struct _RygelMediaTrackerPrivate {
	GeeArrayList* containers;
	GUPnPSearchCriteriaParser* search_parser;
};

#define RYGEL_MEDIA_TRACKER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_TRACKER, RygelMediaTrackerPrivate))
enum  {
	RYGEL_MEDIA_TRACKER_DUMMY_PROPERTY
};
static void _rygel_media_tracker_on_item_requested_rygel_http_server_item_requested (RygelHTTPServer* _sender, const char* item_id, RygelMediaItem* item, gpointer self);
static void rygel_media_tracker_real_constructed (GObject* base);
static void rygel_media_tracker_real_add_children_metadata (RygelContentDirectory* base, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error);
static void rygel_media_tracker_real_add_metadata (RygelContentDirectory* base, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error);
static void rygel_media_tracker_real_add_root_children_metadata (RygelContentDirectory* base, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error);
static RygelTrackerContainer* rygel_media_tracker_find_container_by_id (RygelMediaTracker* self, const char* container_id);
static RygelTrackerContainer* rygel_media_tracker_get_item_parent (RygelMediaTracker* self, const char* uri);
static void rygel_media_tracker_on_item_requested (RygelMediaTracker* self, RygelHTTPServer* http_server, const char* item_id, RygelMediaItem** item);
static gpointer rygel_media_tracker_parent_class = NULL;
static void rygel_media_tracker_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _rygel_media_tracker_on_item_requested_rygel_http_server_item_requested (RygelHTTPServer* _sender, const char* item_id, RygelMediaItem* item, gpointer self) {
	rygel_media_tracker_on_item_requested (self, _sender, item_id, item);
}


/* Pubic methods */
static void rygel_media_tracker_real_constructed (GObject* base) {
	RygelMediaTracker * self;
	GeeArrayList* _tmp0;
	RygelTrackerContainer* _tmp1;
	RygelTrackerContainer* _tmp2;
	RygelTrackerContainer* _tmp3;
	GUPnPSearchCriteriaParser* _tmp4;
	self = (RygelMediaTracker*) base;
	/* Chain-up to base first*/
	G_OBJECT_CLASS (rygel_media_tracker_parent_class)->constructed ((GObject*) RYGEL_CONTENT_DIRECTORY (self));
	g_signal_connect_object (((RygelContentDirectory*) self)->http_server, "item-requested", (GCallback) _rygel_media_tracker_on_item_requested_rygel_http_server_item_requested, self, 0);
	_tmp0 = NULL;
	self->priv->containers = (_tmp0 = gee_array_list_new (RYGEL_TYPE_TRACKER_CONTAINER, (GBoxedCopyFunc) rygel_media_object_ref, rygel_media_object_unref, g_direct_equal), (self->priv->containers == NULL) ? NULL : (self->priv->containers = (g_object_unref (self->priv->containers), NULL)), _tmp0);
	_tmp1 = NULL;
	gee_collection_add ((GeeCollection*) self->priv->containers, _tmp1 = rygel_tracker_container_new ("16", ((RygelMediaObject*) ((RygelContentDirectory*) self)->root_container)->id, "All Images", "Images", RYGEL_MEDIA_ITEM_IMAGE_CLASS, ((RygelContentDirectory*) self)->http_server));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (rygel_media_object_unref (_tmp1), NULL));
	_tmp2 = NULL;
	gee_collection_add ((GeeCollection*) self->priv->containers, _tmp2 = rygel_tracker_container_new ("14", ((RygelMediaObject*) ((RygelContentDirectory*) self)->root_container)->id, "All Music", "Music", RYGEL_MEDIA_ITEM_MUSIC_CLASS, ((RygelContentDirectory*) self)->http_server));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (rygel_media_object_unref (_tmp2), NULL));
	_tmp3 = NULL;
	gee_collection_add ((GeeCollection*) self->priv->containers, _tmp3 = rygel_tracker_container_new ("15", ((RygelMediaObject*) ((RygelContentDirectory*) self)->root_container)->id, "All Videos", "Videos", RYGEL_MEDIA_ITEM_VIDEO_CLASS, ((RygelContentDirectory*) self)->http_server));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (rygel_media_object_unref (_tmp3), NULL));
	/* Now we know how many top-level containers we have*/
	((RygelContentDirectory*) self)->root_container->child_count = (guint) gee_collection_get_size ((GeeCollection*) self->priv->containers);
	_tmp4 = NULL;
	self->priv->search_parser = (_tmp4 = gupnp_search_criteria_parser_new (), (self->priv->search_parser == NULL) ? NULL : (self->priv->search_parser = (g_object_unref (self->priv->search_parser), NULL)), _tmp4);
}


static void rygel_media_tracker_real_add_children_metadata (RygelContentDirectory* base, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error) {
	RygelMediaTracker * self;
	GError * inner_error;
	RygelTrackerContainer* container;
	RygelTrackerContainer* _tmp0;
	self = (RygelMediaTracker*) base;
	g_return_if_fail (didl_writer != NULL);
	g_return_if_fail (args != NULL);
	inner_error = NULL;
	container = NULL;
	if (args->requested_count == 0) {
		args->requested_count = (guint) RYGEL_MEDIA_TRACKER_MAX_REQUESTED_COUNT;
	}
	_tmp0 = NULL;
	container = (_tmp0 = rygel_media_tracker_find_container_by_id (self, args->object_id), (container == NULL) ? NULL : (container = (rygel_media_object_unref (container), NULL)), _tmp0);
	if (container == NULL) {
		args->number_returned = (guint) 0;
	} else {
		args->number_returned = rygel_tracker_container_add_children_from_db (container, didl_writer, args->index, args->requested_count, &args->total_matches);
	}
	if (args->number_returned > 0) {
		args->update_id = (guint) G_MAXUINT32;
	} else {
		inner_error = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, "No such object");
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			(container == NULL) ? NULL : (container = (rygel_media_object_unref (container), NULL));
			return;
		}
	}
	(container == NULL) ? NULL : (container = (rygel_media_object_unref (container), NULL));
}


static void rygel_media_tracker_real_add_metadata (RygelContentDirectory* base, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error) {
	RygelMediaTracker * self;
	GError * inner_error;
	gboolean found;
	RygelTrackerContainer* container;
	RygelTrackerContainer* _tmp0;
	self = (RygelMediaTracker*) base;
	g_return_if_fail (didl_writer != NULL);
	g_return_if_fail (args != NULL);
	inner_error = NULL;
	found = FALSE;
	container = NULL;
	/* First try containers */
	_tmp0 = NULL;
	container = (_tmp0 = rygel_media_tracker_find_container_by_id (self, args->object_id), (container == NULL) ? NULL : (container = (rygel_media_object_unref (container), NULL)), _tmp0);
	if (container != NULL) {
		rygel_media_object_serialize ((RygelMediaObject*) container, didl_writer, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			(container == NULL) ? NULL : (container = (rygel_media_object_unref (container), NULL));
			return;
		}
		found = TRUE;
	} else {
		RygelTrackerContainer* _tmp1;
		/* Now try items */
		_tmp1 = NULL;
		container = (_tmp1 = rygel_media_tracker_get_item_parent (self, args->object_id), (container == NULL) ? NULL : (container = (rygel_media_object_unref (container), NULL)), _tmp1);
		if (container != NULL) {
			found = rygel_tracker_container_add_item_from_db (container, didl_writer, args->object_id);
		}
	}
	if (!found) {
		inner_error = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, "No such object");
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			(container == NULL) ? NULL : (container = (rygel_media_object_unref (container), NULL));
			return;
		}
	}
	args->update_id = (guint) G_MAXUINT32;
	(container == NULL) ? NULL : (container = (rygel_media_object_unref (container), NULL));
}


static void rygel_media_tracker_real_add_root_children_metadata (RygelContentDirectory* base, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error) {
	RygelMediaTracker * self;
	GError * inner_error;
	self = (RygelMediaTracker*) base;
	g_return_if_fail (didl_writer != NULL);
	g_return_if_fail (args != NULL);
	inner_error = NULL;
	{
		GeeIterator* _container_it;
		_container_it = gee_iterable_iterator ((GeeIterable*) self->priv->containers);
		while (gee_iterator_next (_container_it)) {
			RygelTrackerContainer* container;
			container = (RygelTrackerContainer*) gee_iterator_get (_container_it);
			rygel_media_object_serialize ((RygelMediaObject*) container, didl_writer, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				(container == NULL) ? NULL : (container = (rygel_media_object_unref (container), NULL));
				(_container_it == NULL) ? NULL : (_container_it = (g_object_unref (_container_it), NULL));
				return;
			}
			(container == NULL) ? NULL : (container = (rygel_media_object_unref (container), NULL));
		}
		(_container_it == NULL) ? NULL : (_container_it = (g_object_unref (_container_it), NULL));
	}
	args->total_matches = args->number_returned = (guint) gee_collection_get_size ((GeeCollection*) self->priv->containers);
	args->update_id = (guint) G_MAXUINT32;
}


/* Private methods */
static RygelTrackerContainer* rygel_media_tracker_find_container_by_id (RygelMediaTracker* self, const char* container_id) {
	RygelTrackerContainer* container;
	RygelTrackerContainer* _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (container_id != NULL, NULL);
	container = NULL;
	_tmp0 = NULL;
	container = (_tmp0 = NULL, (container == NULL) ? NULL : (container = (rygel_media_object_unref (container), NULL)), _tmp0);
	{
		GeeIterator* _tmp_it;
		_tmp_it = gee_iterable_iterator ((GeeIterable*) self->priv->containers);
		while (gee_iterator_next (_tmp_it)) {
			RygelTrackerContainer* tmp;
			tmp = (RygelTrackerContainer*) gee_iterator_get (_tmp_it);
			if (_vala_strcmp0 (container_id, ((RygelMediaObject*) tmp)->id) == 0) {
				RygelTrackerContainer* _tmp2;
				RygelTrackerContainer* _tmp1;
				_tmp2 = NULL;
				_tmp1 = NULL;
				container = (_tmp2 = (_tmp1 = tmp, (_tmp1 == NULL) ? NULL : rygel_media_object_ref (_tmp1)), (container == NULL) ? NULL : (container = (rygel_media_object_unref (container), NULL)), _tmp2);
				(tmp == NULL) ? NULL : (tmp = (rygel_media_object_unref (tmp), NULL));
				break;
			}
			(tmp == NULL) ? NULL : (tmp = (rygel_media_object_unref (tmp), NULL));
		}
		(_tmp_it == NULL) ? NULL : (_tmp_it = (g_object_unref (_tmp_it), NULL));
	}
	return container;
}


static RygelTrackerContainer* rygel_media_tracker_get_item_parent (RygelMediaTracker* self, const char* uri) {
	GError * inner_error;
	RygelTrackerContainer* container;
	char* category;
	RygelTrackerContainer* _tmp5;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	inner_error = NULL;
	container = NULL;
	category = NULL;
	{
		char* _tmp0;
		char* _tmp1;
		_tmp0 = rygel_tracker_container_get_file_category (uri, &inner_error);
		if (inner_error != NULL) {
			goto __catch0_g_error;
			goto __finally0;
		}
		_tmp1 = NULL;
		category = (_tmp1 = _tmp0, category = (g_free (category), NULL), _tmp1);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			RygelTrackerContainer* _tmp2;
			g_critical ("rygel-media-tracker.vala:164: failed to find service type for %s: %s", uri, error->message);
			_tmp2 = NULL;
			return (_tmp2 = NULL, (error == NULL) ? NULL : (error = (g_error_free (error), NULL)), (container == NULL) ? NULL : (container = (rygel_media_object_unref (container), NULL)), category = (g_free (category), NULL), _tmp2);
		}
	}
	__finally0:
	if (inner_error != NULL) {
		(container == NULL) ? NULL : (container = (rygel_media_object_unref (container), NULL));
		category = (g_free (category), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return NULL;
	}
	{
		GeeIterator* _tmp_it;
		_tmp_it = gee_iterable_iterator ((GeeIterable*) self->priv->containers);
		while (gee_iterator_next (_tmp_it)) {
			RygelTrackerContainer* tmp;
			tmp = (RygelTrackerContainer*) gee_iterator_get (_tmp_it);
			if (_vala_strcmp0 (tmp->category, category) == 0) {
				RygelTrackerContainer* _tmp4;
				RygelTrackerContainer* _tmp3;
				_tmp4 = NULL;
				_tmp3 = NULL;
				container = (_tmp4 = (_tmp3 = tmp, (_tmp3 == NULL) ? NULL : rygel_media_object_ref (_tmp3)), (container == NULL) ? NULL : (container = (rygel_media_object_unref (container), NULL)), _tmp4);
				(tmp == NULL) ? NULL : (tmp = (rygel_media_object_unref (tmp), NULL));
				break;
			}
			(tmp == NULL) ? NULL : (tmp = (rygel_media_object_unref (tmp), NULL));
		}
		(_tmp_it == NULL) ? NULL : (_tmp_it = (g_object_unref (_tmp_it), NULL));
	}
	_tmp5 = NULL;
	return (_tmp5 = container, category = (g_free (category), NULL), _tmp5);
}


static void rygel_media_tracker_on_item_requested (RygelMediaTracker* self, RygelHTTPServer* http_server, const char* item_id, RygelMediaItem** item) {
	GError * inner_error;
	RygelTrackerContainer* container;
	g_return_if_fail (self != NULL);
	g_return_if_fail (http_server != NULL);
	g_return_if_fail (item_id != NULL);
	*item = NULL;
	inner_error = NULL;
	container = rygel_media_tracker_get_item_parent (self, item_id);
	if (container != NULL) {
		RygelMediaItem* _tmp0;
		RygelMediaItem* _tmp1;
		_tmp0 = rygel_tracker_container_get_item_from_db (container, item_id, &inner_error);
		if (inner_error != NULL) {
			(container == NULL) ? NULL : (container = (rygel_media_object_unref (container), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
		_tmp1 = NULL;
		(*item) = (_tmp1 = _tmp0, ((*item) == NULL) ? NULL : ((*item) = (rygel_media_object_unref ((*item)), NULL)), _tmp1);
	}
	(container == NULL) ? NULL : (container = (rygel_media_object_unref (container), NULL));
}


/**
 * Implementation of Tracker-based ContentDirectory service.
 */
RygelMediaTracker* rygel_media_tracker_construct (GType object_type) {
	RygelMediaTracker * self;
	self = (RygelMediaTracker*) rygel_content_directory_construct (object_type);
	return self;
}


RygelMediaTracker* rygel_media_tracker_new (void) {
	return rygel_media_tracker_construct (RYGEL_TYPE_MEDIA_TRACKER);
}


static void rygel_media_tracker_class_init (RygelMediaTrackerClass * klass) {
	rygel_media_tracker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaTrackerPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_tracker_finalize;
	G_OBJECT_CLASS (klass)->constructed = rygel_media_tracker_real_constructed;
	RYGEL_CONTENT_DIRECTORY_CLASS (klass)->add_children_metadata = rygel_media_tracker_real_add_children_metadata;
	RYGEL_CONTENT_DIRECTORY_CLASS (klass)->add_metadata = rygel_media_tracker_real_add_metadata;
	RYGEL_CONTENT_DIRECTORY_CLASS (klass)->add_root_children_metadata = rygel_media_tracker_real_add_root_children_metadata;
}


static void rygel_media_tracker_instance_init (RygelMediaTracker * self) {
	self->priv = RYGEL_MEDIA_TRACKER_GET_PRIVATE (self);
}


static void rygel_media_tracker_finalize (GObject* obj) {
	RygelMediaTracker * self;
	self = RYGEL_MEDIA_TRACKER (obj);
	(self->priv->containers == NULL) ? NULL : (self->priv->containers = (g_object_unref (self->priv->containers), NULL));
	(self->priv->search_parser == NULL) ? NULL : (self->priv->search_parser = (g_object_unref (self->priv->search_parser), NULL));
	G_OBJECT_CLASS (rygel_media_tracker_parent_class)->finalize (obj);
}


GType rygel_media_tracker_get_type (void) {
	static GType rygel_media_tracker_type_id = 0;
	if (rygel_media_tracker_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaTrackerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_tracker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaTracker), 0, (GInstanceInitFunc) rygel_media_tracker_instance_init, NULL };
		rygel_media_tracker_type_id = g_type_register_static (RYGEL_TYPE_CONTENT_DIRECTORY, "RygelMediaTracker", &g_define_type_info, 0);
	}
	return rygel_media_tracker_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




