/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-tracker-container.h"
#include <rygel-media-object.h>
#include "rygel-tracker-video-item.h"
#include "rygel-tracker-image-item.h"
#include "rygel-tracker-music-item.h"




enum  {
	RYGEL_TRACKER_CONTAINER_DUMMY_PROPERTY
};
DBusGProxy* rygel_tracker_container_metadata = NULL;
DBusGProxy* rygel_tracker_container_files = NULL;
DBusGProxy* rygel_tracker_container_tracker = NULL;
#define RYGEL_TRACKER_CONTAINER_TRACKER_SERVICE "org.freedesktop.Tracker"
#define RYGEL_TRACKER_CONTAINER_TRACKER_PATH "/org/freedesktop/tracker"
#define RYGEL_TRACKER_CONTAINER_TRACKER_IFACE "org.freedesktop.Tracker"
#define RYGEL_TRACKER_CONTAINER_FILES_IFACE "org.freedesktop.Tracker.Files"
#define RYGEL_TRACKER_CONTAINER_METADATA_IFACE "org.freedesktop.Tracker.Metadata"
static void rygel_tracker_container_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* didl_writer, GError** error);
char*** _dynamic_GetStats0 (DBusGProxy* self, int* result_length1, GError** error);
static guint rygel_tracker_container_get_children_count (RygelTrackerContainer* self);
char** _dynamic_GetByServiceType1 (DBusGProxy* self, gint param1, const char* param2, gint param3, gint param4, int* result_length1, GError** error);
static char** rygel_tracker_container_get_children_from_db (RygelTrackerContainer* self, guint offset, guint max_count, guint* child_count, int* result_length1);
char* _dynamic_GetServiceType2 (DBusGProxy* self, const char* param1, GError** error);
static gpointer rygel_tracker_container_parent_class = NULL;
static void rygel_tracker_container_finalize (RygelMediaObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



RygelTrackerContainer* rygel_tracker_container_construct (GType object_type, const char* id, const char* parent_id, const char* title, const char* category, const char* child_class, RygelHTTPServer* http_server) {
	RygelTrackerContainer* self;
	char* _tmp1;
	const char* _tmp0;
	char* _tmp3;
	const char* _tmp2;
	RygelHTTPServer* _tmp5;
	RygelHTTPServer* _tmp4;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent_id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (category != NULL, NULL);
	g_return_val_if_fail (child_class != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	self = (RygelTrackerContainer*) rygel_media_container_construct (object_type, id, parent_id, title, (guint) 0);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->category = (_tmp1 = (_tmp0 = category, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), self->category = (g_free (self->category), NULL), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->child_class = (_tmp3 = (_tmp2 = child_class, (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), self->child_class = (g_free (self->child_class), NULL), _tmp3);
	_tmp5 = NULL;
	_tmp4 = NULL;
	self->http_server = (_tmp5 = (_tmp4 = http_server, (_tmp4 == NULL) ? NULL : g_object_ref (_tmp4)), (self->http_server == NULL) ? NULL : (self->http_server = (g_object_unref (self->http_server), NULL)), _tmp5);
	return self;
}


RygelTrackerContainer* rygel_tracker_container_new (const char* id, const char* parent_id, const char* title, const char* category, const char* child_class, RygelHTTPServer* http_server) {
	return rygel_tracker_container_construct (RYGEL_TYPE_TRACKER_CONTAINER, id, parent_id, title, category, child_class, http_server);
}


static void rygel_tracker_container_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* didl_writer, GError** error) {
	RygelTrackerContainer * self;
	GError * inner_error;
	self = (RygelTrackerContainer*) base;
	g_return_if_fail (didl_writer != NULL);
	inner_error = NULL;
	/* Update the child count */
	((RygelMediaContainer*) self)->child_count = rygel_tracker_container_get_children_count (self);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_tracker_container_parent_class)->serialize ((RygelMediaObject*) RYGEL_MEDIA_CONTAINER (self), didl_writer, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
}


char*** _dynamic_GetStats0 (DBusGProxy* self, int* result_length1, GError** error) {
	GPtrArray* result;
	dbus_g_proxy_call (self, "GetStats", error, G_TYPE_INVALID, dbus_g_type_get_collection ("GPtrArray", G_TYPE_STRV), &result, G_TYPE_INVALID);
	if (*error) {
		return NULL;
	}
	*result_length1 = result->len;
	return (char***) result->pdata;
}


static guint rygel_tracker_container_get_children_count (RygelTrackerContainer* self) {
	GError * inner_error;
	gint stats_size;
	gint stats_length1;
	char*** stats;
	guint count;
	guint _tmp5;
	g_return_val_if_fail (self != NULL, 0U);
	inner_error = NULL;
	stats = (stats_length1 = 0, NULL);
	{
		char*** _tmp2;
		gint _tmp1_size;
		gint _tmp1_length1;
		gint _tmp0;
		char*** _tmp1;
		char*** _tmp3;
		_tmp2 = NULL;
		_tmp1 = (_tmp2 = _dynamic_GetStats0 (rygel_tracker_container_tracker, &_tmp0, &inner_error), _tmp1_length1 = _tmp0, _tmp1_size = _tmp1_length1, _tmp2);
		if (inner_error != NULL) {
			goto __catch1_g_error;
			goto __finally1;
		}
		_tmp3 = NULL;
		stats = (_tmp3 = _tmp1, stats = (_vala_array_free (stats, stats_length1, (GDestroyNotify) g_free), NULL), stats_length1 = _tmp1_length1, stats_size = stats_length1, _tmp3);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			guint _tmp4;
			g_critical ("rygel-tracker-container.vala:100: error getting tracker statistics: %s", error->message);
			return (_tmp4 = (guint) 0, (error == NULL) ? NULL : (error = (g_error_free (error), NULL)), stats = (_vala_array_free (stats, stats_length1, (GDestroyNotify) g_free), NULL), _tmp4);
		}
	}
	__finally1:
	if (inner_error != NULL) {
		stats = (_vala_array_free (stats, stats_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return 0U;
	}
	count = (guint) 0;
	{
		guint i;
		i = (guint) 0;
		for (; i < stats_length1; i++) {
			if (_vala_strcmp0 (stats[i][0], self->category) == 0) {
				count = (guint) atoi (stats[i][1]);
			}
		}
	}
	return (_tmp5 = count, stats = (_vala_array_free (stats, stats_length1, (GDestroyNotify) g_free), NULL), _tmp5);
}


guint rygel_tracker_container_add_children_from_db (RygelTrackerContainer* self, GUPnPDIDLLiteWriter* didl_writer, guint offset, guint max_count, guint* child_count) {
	gint children_size;
	gint children_length1;
	char** children;
	char** _tmp1;
	gint _tmp0;
	guint _tmp3;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (didl_writer != NULL, 0U);
	children = (children_length1 = 0, NULL);
	_tmp1 = NULL;
	children = (_tmp1 = rygel_tracker_container_get_children_from_db (self, offset, max_count, &(*child_count), &_tmp0), children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_free), NULL), children_length1 = _tmp0, children_size = children_length1, _tmp1);
	if (children == NULL) {
		guint _tmp2;
		return (_tmp2 = (guint) 0, children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_free), NULL), _tmp2);
	}
	{
		guint i;
		/* Iterate through all items */
		i = (guint) 0;
		for (; i < children_length1; i++) {
			rygel_tracker_container_add_item_from_db (self, didl_writer, children[i]);
		}
	}
	return (_tmp3 = (guint) children_length1, children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_free), NULL), _tmp3);
}


char** _dynamic_GetByServiceType1 (DBusGProxy* self, gint param1, const char* param2, gint param3, gint param4, int* result_length1, GError** error) {
	char** result;
	dbus_g_proxy_call (self, "GetByServiceType", error, G_TYPE_INT, param1, G_TYPE_STRING, param2, G_TYPE_INT, param3, G_TYPE_INT, param4, G_TYPE_INVALID, G_TYPE_STRV, &result, G_TYPE_INVALID);
	if (*error) {
		return NULL;
	}
	*result_length1 = g_strv_length (result);
	return result;
}


static char** rygel_tracker_container_get_children_from_db (RygelTrackerContainer* self, guint offset, guint max_count, guint* child_count, int* result_length1) {
	GError * inner_error;
	char** _tmp0;
	gint children_size;
	gint children_length1;
	char** children;
	char** _tmp7;
	g_return_val_if_fail (self != NULL, NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	children = (_tmp0 = NULL, children_length1 = 0, children_size = children_length1, _tmp0);
	(*child_count) = rygel_tracker_container_get_children_count (self);
	{
		char** _tmp3;
		gint _tmp2_size;
		gint _tmp2_length1;
		gint _tmp1;
		char** _tmp2;
		char** _tmp4;
		_tmp3 = NULL;
		_tmp2 = (_tmp3 = _dynamic_GetByServiceType1 (rygel_tracker_container_files, 0, self->category, (gint) offset, (gint) max_count, &_tmp1, &inner_error), _tmp2_length1 = _tmp1, _tmp2_size = _tmp2_length1, _tmp3);
		if (inner_error != NULL) {
			goto __catch2_g_error;
			goto __finally2;
		}
		_tmp4 = NULL;
		children = (_tmp4 = _tmp2, children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_free), NULL), children_length1 = _tmp2_length1, children_size = children_length1, _tmp4);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			gpointer _tmp5;
			char** _tmp6;
			g_critical ("rygel-tracker-container.vala:147: error: %s", error->message);
			_tmp6 = NULL;
			return (_tmp6 = (_tmp5 = NULL, *result_length1 = 0, _tmp5), (error == NULL) ? NULL : (error = (g_error_free (error), NULL)), children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_free), NULL), _tmp6);
		}
	}
	__finally2:
	if (inner_error != NULL) {
		children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return NULL;
	}
	_tmp7 = NULL;
	return (_tmp7 = children, *result_length1 = children_length1, _tmp7);
}


gboolean rygel_tracker_container_add_item_from_db (RygelTrackerContainer* self, GUPnPDIDLLiteWriter* didl_writer, const char* path) {
	GError * inner_error;
	RygelMediaItem* item;
	gboolean _tmp4;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (didl_writer != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	inner_error = NULL;
	item = NULL;
	{
		RygelMediaItem* _tmp0;
		RygelMediaItem* _tmp1;
		_tmp0 = rygel_tracker_container_get_item_from_db (self, path, &inner_error);
		if (inner_error != NULL) {
			goto __catch3_g_error;
			goto __finally3;
		}
		_tmp1 = NULL;
		item = (_tmp1 = _tmp0, (item == NULL) ? NULL : (item = (rygel_media_object_unref (item), NULL)), _tmp1);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			gboolean _tmp2;
			g_critical ("rygel-tracker-container.vala:162: Failed to fetch item %s. Reason: %s", ((RygelMediaObject*) item)->id, error->message);
			return (_tmp2 = FALSE, (error == NULL) ? NULL : (error = (g_error_free (error), NULL)), (item == NULL) ? NULL : (item = (rygel_media_object_unref (item), NULL)), _tmp2);
		}
	}
	__finally3:
	if (inner_error != NULL) {
		(item == NULL) ? NULL : (item = (rygel_media_object_unref (item), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
	{
		rygel_media_object_serialize ((RygelMediaObject*) item, didl_writer, &inner_error);
		if (inner_error != NULL) {
			goto __catch4_g_error;
			goto __finally4;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			gboolean _tmp3;
			g_critical ("rygel-tracker-container.vala:172: Failed to serialize item %s. Reason: %s", ((RygelMediaObject*) item)->id, error->message);
			return (_tmp3 = FALSE, (error == NULL) ? NULL : (error = (g_error_free (error), NULL)), (item == NULL) ? NULL : (item = (rygel_media_object_unref (item), NULL)), _tmp3);
		}
	}
	__finally4:
	if (inner_error != NULL) {
		(item == NULL) ? NULL : (item = (rygel_media_object_unref (item), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
	return (_tmp4 = TRUE, (item == NULL) ? NULL : (item = (rygel_media_object_unref (item), NULL)), _tmp4);
}


char* _dynamic_GetServiceType2 (DBusGProxy* self, const char* param1, GError** error) {
	char* result;
	dbus_g_proxy_call (self, "GetServiceType", error, G_TYPE_STRING, param1, G_TYPE_INVALID, G_TYPE_STRING, &result, G_TYPE_INVALID);
	if (*error) {
		return NULL;
	}
	return result;
}


char* rygel_tracker_container_get_file_category (const char* uri, GError** error) {
	GError * inner_error;
	char* category;
	char* _tmp0;
	char* _tmp1;
	g_return_val_if_fail (uri != NULL, NULL);
	inner_error = NULL;
	category = NULL;
	_tmp0 = _dynamic_GetServiceType2 (rygel_tracker_container_files, uri, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		category = (g_free (category), NULL);
		return NULL;
	}
	_tmp1 = NULL;
	category = (_tmp1 = _tmp0, category = (g_free (category), NULL), _tmp1);
	return category;
}


RygelMediaItem* rygel_tracker_container_get_item_from_db (RygelTrackerContainer* self, const char* path, GError** error) {
	GError * inner_error;
	RygelMediaItem* item;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	inner_error = NULL;
	item = NULL;
	if (_vala_strcmp0 (self->child_class, RYGEL_MEDIA_ITEM_VIDEO_CLASS) == 0) {
		RygelMediaItem* _tmp0;
		_tmp0 = NULL;
		item = (_tmp0 = (RygelMediaItem*) rygel_tracker_video_item_new (path, path, self, &inner_error), (item == NULL) ? NULL : (item = (rygel_media_object_unref (item), NULL)), _tmp0);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			(item == NULL) ? NULL : (item = (rygel_media_object_unref (item), NULL));
			return NULL;
		}
	} else {
		if (_vala_strcmp0 (self->child_class, RYGEL_MEDIA_ITEM_IMAGE_CLASS) == 0) {
			RygelMediaItem* _tmp1;
			_tmp1 = NULL;
			item = (_tmp1 = (RygelMediaItem*) rygel_tracker_image_item_new (path, path, self, &inner_error), (item == NULL) ? NULL : (item = (rygel_media_object_unref (item), NULL)), _tmp1);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				(item == NULL) ? NULL : (item = (rygel_media_object_unref (item), NULL));
				return NULL;
			}
		} else {
			RygelMediaItem* _tmp2;
			_tmp2 = NULL;
			item = (_tmp2 = (RygelMediaItem*) rygel_tracker_music_item_new (path, path, self, &inner_error), (item == NULL) ? NULL : (item = (rygel_media_object_unref (item), NULL)), _tmp2);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				(item == NULL) ? NULL : (item = (rygel_media_object_unref (item), NULL));
				return NULL;
			}
		}
	}
	return item;
}


static void rygel_tracker_container_class_init (RygelTrackerContainerClass * klass) {
	GError * inner_error;
	rygel_tracker_container_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_tracker_container_finalize;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_tracker_container_real_serialize;
	inner_error = NULL;
	{
		DBusGConnection* connection;
		DBusGProxy* _tmp2;
		DBusGProxy* _tmp3;
		DBusGProxy* _tmp4;
		connection = NULL;
		{
			DBusGConnection* _tmp0;
			DBusGConnection* _tmp1;
			_tmp0 = dbus_g_bus_get (DBUS_BUS_SESSION, &inner_error);
			if (inner_error != NULL) {
				if (inner_error->domain == DBUS_GERROR) {
					goto __catch5_dbus_gerror;
				}
				goto __finally5;
			}
			_tmp1 = NULL;
			connection = (_tmp1 = _tmp0, (connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL)), _tmp1);
		}
		goto __finally5;
		__catch5_dbus_gerror:
		{
			GError * error;
			error = inner_error;
			inner_error = NULL;
			{
				g_critical ("rygel-tracker-container.vala:55: Failed to connect to Session bus: %s\n", error->message);
				(error == NULL) ? NULL : (error = (g_error_free (error), NULL));
			}
		}
		__finally5:
		if (inner_error != NULL) {
			(connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
		}
		_tmp2 = NULL;
		rygel_tracker_container_metadata = (_tmp2 = dbus_g_proxy_new_for_name (connection, RYGEL_TRACKER_CONTAINER_TRACKER_SERVICE, RYGEL_TRACKER_CONTAINER_TRACKER_PATH, RYGEL_TRACKER_CONTAINER_METADATA_IFACE), (rygel_tracker_container_metadata == NULL) ? NULL : (rygel_tracker_container_metadata = (g_object_unref (rygel_tracker_container_metadata), NULL)), _tmp2);
		_tmp3 = NULL;
		rygel_tracker_container_files = (_tmp3 = dbus_g_proxy_new_for_name (connection, RYGEL_TRACKER_CONTAINER_TRACKER_SERVICE, RYGEL_TRACKER_CONTAINER_TRACKER_PATH, RYGEL_TRACKER_CONTAINER_FILES_IFACE), (rygel_tracker_container_files == NULL) ? NULL : (rygel_tracker_container_files = (g_object_unref (rygel_tracker_container_files), NULL)), _tmp3);
		_tmp4 = NULL;
		rygel_tracker_container_tracker = (_tmp4 = dbus_g_proxy_new_for_name (connection, RYGEL_TRACKER_CONTAINER_TRACKER_SERVICE, RYGEL_TRACKER_CONTAINER_TRACKER_PATH, RYGEL_TRACKER_CONTAINER_TRACKER_IFACE), (rygel_tracker_container_tracker == NULL) ? NULL : (rygel_tracker_container_tracker = (g_object_unref (rygel_tracker_container_tracker), NULL)), _tmp4);
		(connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL));
	}
}


static void rygel_tracker_container_instance_init (RygelTrackerContainer * self) {
}


static void rygel_tracker_container_finalize (RygelMediaObject* obj) {
	RygelTrackerContainer * self;
	self = RYGEL_TRACKER_CONTAINER (obj);
	(self->http_server == NULL) ? NULL : (self->http_server = (g_object_unref (self->http_server), NULL));
	self->category = (g_free (self->category), NULL);
	self->child_class = (g_free (self->child_class), NULL);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_tracker_container_parent_class)->finalize (obj);
}


GType rygel_tracker_container_get_type (void) {
	static GType rygel_tracker_container_type_id = 0;
	if (rygel_tracker_container_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerContainer), 0, (GInstanceInitFunc) rygel_tracker_container_instance_init, NULL };
		rygel_tracker_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelTrackerContainer", &g_define_type_info, 0);
	}
	return rygel_tracker_container_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




