/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <rygel-media-container.h>




enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY
};
static void rygel_media_container_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* didl_writer, GError** error);
static gpointer rygel_media_container_parent_class = NULL;
static void rygel_media_container_finalize (RygelMediaObject* obj);



RygelMediaContainer* rygel_media_container_construct (GType object_type, const char* id, const char* parent_id, const char* title, guint child_count) {
	RygelMediaContainer* self;
	char* _tmp1;
	const char* _tmp0;
	char* _tmp3;
	const char* _tmp2;
	char* _tmp5;
	const char* _tmp4;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent_id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	self = (RygelMediaContainer*) g_type_create_instance (object_type);
	_tmp1 = NULL;
	_tmp0 = NULL;
	((RygelMediaObject*) self)->id = (_tmp1 = (_tmp0 = id, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), ((RygelMediaObject*) self)->id = (g_free (((RygelMediaObject*) self)->id), NULL), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	((RygelMediaObject*) self)->parent_id = (_tmp3 = (_tmp2 = parent_id, (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), ((RygelMediaObject*) self)->parent_id = (g_free (((RygelMediaObject*) self)->parent_id), NULL), _tmp3);
	_tmp5 = NULL;
	_tmp4 = NULL;
	((RygelMediaObject*) self)->title = (_tmp5 = (_tmp4 = title, (_tmp4 == NULL) ? NULL : g_strdup (_tmp4)), ((RygelMediaObject*) self)->title = (g_free (((RygelMediaObject*) self)->title), NULL), _tmp5);
	self->child_count = child_count;
	return self;
}


RygelMediaContainer* rygel_media_container_new (const char* id, const char* parent_id, const char* title, guint child_count) {
	return rygel_media_container_construct (RYGEL_TYPE_MEDIA_CONTAINER, id, parent_id, title, child_count);
}


RygelMediaContainer* rygel_media_container_construct_root (GType object_type, const char* title, guint child_count) {
	RygelMediaContainer* self;
	g_return_val_if_fail (title != NULL, NULL);
	self = (RygelMediaContainer*) rygel_media_container_construct (object_type, "0", "-1", title, child_count);
	return self;
}


RygelMediaContainer* rygel_media_container_new_root (const char* title, guint child_count) {
	return rygel_media_container_construct_root (RYGEL_TYPE_MEDIA_CONTAINER, title, child_count);
}


static void rygel_media_container_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* didl_writer, GError** error) {
	RygelMediaContainer * self;
	self = (RygelMediaContainer*) base;
	g_return_if_fail (didl_writer != NULL);
	gupnp_didl_lite_writer_start_container (didl_writer, ((RygelMediaObject*) self)->id, ((RygelMediaObject*) self)->parent_id, (gint) self->child_count, FALSE, FALSE);
	gupnp_didl_lite_writer_add_string (didl_writer, "class", GUPNP_DIDL_LITE_WRITER_NAMESPACE_UPNP, NULL, "object.container.storageFolder");
	gupnp_didl_lite_writer_add_string (didl_writer, "title", GUPNP_DIDL_LITE_WRITER_NAMESPACE_DC, NULL, ((RygelMediaObject*) self)->title);
	/* End of Container */
	gupnp_didl_lite_writer_end_container (didl_writer);
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_media_container_finalize;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_media_container_real_serialize;
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
}


static void rygel_media_container_finalize (RygelMediaObject* obj) {
	RygelMediaContainer * self;
	self = RYGEL_MEDIA_CONTAINER (obj);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_media_container_parent_class)->finalize (obj);
}


GType rygel_media_container_get_type (void) {
	static GType rygel_media_container_type_id = 0;
	if (rygel_media_container_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, 0);
	}
	return rygel_media_container_type_id;
}




