/* rygel-gst-rendering-control.c generated by valac, the Vala compiler
 * generated from rygel-gst-rendering-control.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_GST_RENDERING_CONTROL (rygel_gst_rendering_control_get_type ())
#define RYGEL_GST_RENDERING_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_RENDERING_CONTROL, RygelGstRenderingControl))
#define RYGEL_GST_RENDERING_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_RENDERING_CONTROL, RygelGstRenderingControlClass))
#define RYGEL_IS_GST_RENDERING_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_RENDERING_CONTROL))
#define RYGEL_IS_GST_RENDERING_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_RENDERING_CONTROL))
#define RYGEL_GST_RENDERING_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_RENDERING_CONTROL, RygelGstRenderingControlClass))

typedef struct _RygelGstRenderingControl RygelGstRenderingControl;
typedef struct _RygelGstRenderingControlClass RygelGstRenderingControlClass;
typedef struct _RygelGstRenderingControlPrivate RygelGstRenderingControlPrivate;

#define RYGEL_TYPE_GST_CHANGE_LOG (rygel_gst_change_log_get_type ())
#define RYGEL_GST_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_CHANGE_LOG, RygelGstChangeLog))
#define RYGEL_GST_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_CHANGE_LOG, RygelGstChangeLogClass))
#define RYGEL_IS_GST_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_CHANGE_LOG))
#define RYGEL_IS_GST_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_CHANGE_LOG))
#define RYGEL_GST_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_CHANGE_LOG, RygelGstChangeLogClass))

typedef struct _RygelGstChangeLog RygelGstChangeLog;
typedef struct _RygelGstChangeLogClass RygelGstChangeLogClass;

#define RYGEL_TYPE_GST_PLAYER (rygel_gst_player_get_type ())
#define RYGEL_GST_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_PLAYER, RygelGstPlayer))
#define RYGEL_GST_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_PLAYER, RygelGstPlayerClass))
#define RYGEL_IS_GST_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_PLAYER))
#define RYGEL_IS_GST_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_PLAYER))
#define RYGEL_GST_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_PLAYER, RygelGstPlayerClass))

typedef struct _RygelGstPlayer RygelGstPlayer;
typedef struct _RygelGstPlayerClass RygelGstPlayerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_VOLUME (volume_get_type ())
#define VOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VOLUME, Volume))
#define VOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VOLUME, VolumeClass))
#define IS_VOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VOLUME))
#define IS_VOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VOLUME))
#define VOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VOLUME, VolumeClass))

typedef struct _Volume Volume;
typedef struct _VolumeClass VolumeClass;
typedef struct _VolumePrivate VolumePrivate;
typedef struct _ParamSpecVolume ParamSpecVolume;

struct _RygelGstRenderingControl {
	GUPnPService parent_instance;
	RygelGstRenderingControlPrivate * priv;
};

struct _RygelGstRenderingControlClass {
	GUPnPServiceClass parent_class;
};

struct _RygelGstRenderingControlPrivate {
	gboolean _mute;
	guint _volume;
	char* preset_name_list;
	RygelGstChangeLog* changelog;
	RygelGstPlayer* player;
};

struct _Volume {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VolumePrivate * priv;
};

struct _VolumeClass {
	GTypeClass parent_class;
	void (*finalize) (Volume *self);
};

struct _ParamSpecVolume {
	GParamSpec parent_instance;
};


static gpointer rygel_gst_rendering_control_parent_class = NULL;
static gpointer volume_parent_class = NULL;

GType rygel_gst_rendering_control_get_type (void);
GType rygel_gst_change_log_get_type (void);
GType rygel_gst_player_get_type (void);
#define RYGEL_GST_RENDERING_CONTROL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_GST_RENDERING_CONTROL, RygelGstRenderingControlPrivate))
enum  {
	RYGEL_GST_RENDERING_CONTROL_DUMMY_PROPERTY,
	RYGEL_GST_RENDERING_CONTROL_MUTE,
	RYGEL_GST_RENDERING_CONTROL_VOLUME
};
#define RYGEL_GST_RENDERING_CONTROL_UPNP_ID "urn:upnp-org:serviceId:RenderingControl"
#define RYGEL_GST_RENDERING_CONTROL_UPNP_TYPE "urn:schemas-upnp-org:service:RenderingControl:2"
#define RYGEL_GST_RENDERING_CONTROL_DESCRIPTION_PATH "xml/RenderingControl2.xml"
#define RYGEL_GST_RENDERING_CONTROL_LAST_CHANGE_NS "urn:schemas-upnp-org:metadata-1-0/RCS/"
RygelGstChangeLog* rygel_gst_change_log_new (GUPnPService* service, const char* service_ns);
RygelGstChangeLog* rygel_gst_change_log_construct (GType object_type, GUPnPService* service, const char* service_ns);
RygelGstPlayer* rygel_gst_player_get_default (void);
static void rygel_gst_rendering_control_query_last_change_cb (RygelGstRenderingControl* self, GUPnPService* service, const char* variable, GValue* value);
static void _rygel_gst_rendering_control_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const char* variable, GValue* value, gpointer self);
static void rygel_gst_rendering_control_list_presets_cb (RygelGstRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_rendering_control_list_presets_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_rendering_control_select_preset_cb (RygelGstRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_rendering_control_select_preset_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_rendering_control_get_mute_cb (RygelGstRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_rendering_control_get_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_rendering_control_set_mute_cb (RygelGstRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_rendering_control_set_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_rendering_control_get_volume_cb (RygelGstRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_rendering_control_get_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_rendering_control_set_volume_cb (RygelGstRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_rendering_control_set_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
guint volume_to_percentage (double volume);
double rygel_gst_player_get_volume (RygelGstPlayer* self);
static void rygel_gst_rendering_control_real_constructed (GObject* base);
gboolean rygel_gst_rendering_control_get_mute (RygelGstRenderingControl* self);
void rygel_gst_change_log_log_with_channel (RygelGstChangeLog* self, const char* variable, const char* value, const char* channel);
guint rygel_gst_rendering_control_get_volume (RygelGstRenderingControl* self);
char* rygel_gst_change_log_finish (RygelGstChangeLog* self);
static gboolean rygel_gst_rendering_control_check_instance_id (RygelGstRenderingControl* self, GUPnPServiceAction* action);
static gboolean rygel_gst_rendering_control_check_channel (RygelGstRenderingControl* self, GUPnPServiceAction* action);
void rygel_gst_rendering_control_set_mute (RygelGstRenderingControl* self, gboolean value);
void rygel_gst_rendering_control_set_volume (RygelGstRenderingControl* self, guint value);
RygelGstRenderingControl* rygel_gst_rendering_control_new (void);
RygelGstRenderingControl* rygel_gst_rendering_control_construct (GType object_type);
void rygel_gst_player_set_volume (RygelGstPlayer* self, double value);
double volume_from_percentage (guint percentage);
static void rygel_gst_rendering_control_finalize (GObject* obj);
static void rygel_gst_rendering_control_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_gst_rendering_control_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
gpointer volume_ref (gpointer instance);
void volume_unref (gpointer instance);
GParamSpec* param_spec_volume (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_volume (GValue* value, gpointer v_object);
gpointer value_get_volume (const GValue* value);
GType volume_get_type (void);
enum  {
	VOLUME_DUMMY_PROPERTY
};
Volume* volume_new (void);
Volume* volume_construct (GType object_type);
static void volume_finalize (Volume* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 100 "rygel-gst-rendering-control.vala"
static void _rygel_gst_rendering_control_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const char* variable, GValue* value, gpointer self) {
#line 189 "rygel-gst-rendering-control.c"
	rygel_gst_rendering_control_query_last_change_cb (self, _sender, variable, value);
}


#line 127 "rygel-gst-rendering-control.vala"
static void _rygel_gst_rendering_control_list_presets_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 196 "rygel-gst-rendering-control.c"
	rygel_gst_rendering_control_list_presets_cb (self, _sender, action);
}


#line 140 "rygel-gst-rendering-control.vala"
static void _rygel_gst_rendering_control_select_preset_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 203 "rygel-gst-rendering-control.c"
	rygel_gst_rendering_control_select_preset_cb (self, _sender, action);
}


#line 172 "rygel-gst-rendering-control.vala"
static void _rygel_gst_rendering_control_get_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 210 "rygel-gst-rendering-control.c"
	rygel_gst_rendering_control_get_mute_cb (self, _sender, action);
}


#line 187 "rygel-gst-rendering-control.vala"
static void _rygel_gst_rendering_control_set_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 217 "rygel-gst-rendering-control.c"
	rygel_gst_rendering_control_set_mute_cb (self, _sender, action);
}


#line 206 "rygel-gst-rendering-control.vala"
static void _rygel_gst_rendering_control_get_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 224 "rygel-gst-rendering-control.c"
	rygel_gst_rendering_control_get_volume_cb (self, _sender, action);
}


#line 221 "rygel-gst-rendering-control.vala"
static void _rygel_gst_rendering_control_set_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 231 "rygel-gst-rendering-control.c"
	rygel_gst_rendering_control_set_volume_cb (self, _sender, action);
}


#line 84 "rygel-gst-rendering-control.vala"
static void rygel_gst_rendering_control_real_constructed (GObject* base) {
#line 238 "rygel-gst-rendering-control.c"
	RygelGstRenderingControl * self;
	RygelGstChangeLog* _tmp0_;
	RygelGstPlayer* _tmp1_;
	self = (RygelGstRenderingControl*) base;
#line 85 "rygel-gst-rendering-control.vala"
	self->priv->changelog = (_tmp0_ = rygel_gst_change_log_new ((GUPnPService*) self, RYGEL_GST_RENDERING_CONTROL_LAST_CHANGE_NS), _g_object_unref0 (self->priv->changelog), _tmp0_);
#line 86 "rygel-gst-rendering-control.vala"
	self->priv->player = (_tmp1_ = rygel_gst_player_get_default (), _g_object_unref0 (self->priv->player), _tmp1_);
#line 88 "rygel-gst-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_gst_rendering_control_query_last_change_cb_gupnp_service_query_variable, self, 0);
#line 90 "rygel-gst-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::ListPresets", (GCallback) _rygel_gst_rendering_control_list_presets_cb_gupnp_service_action_invoked, self, 0);
#line 91 "rygel-gst-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SelectPreset", (GCallback) _rygel_gst_rendering_control_select_preset_cb_gupnp_service_action_invoked, self, 0);
#line 92 "rygel-gst-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMute", (GCallback) _rygel_gst_rendering_control_get_mute_cb_gupnp_service_action_invoked, self, 0);
#line 93 "rygel-gst-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetMute", (GCallback) _rygel_gst_rendering_control_set_mute_cb_gupnp_service_action_invoked, self, 0);
#line 94 "rygel-gst-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetVolume", (GCallback) _rygel_gst_rendering_control_get_volume_cb_gupnp_service_action_invoked, self, 0);
#line 95 "rygel-gst-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetVolume", (GCallback) _rygel_gst_rendering_control_set_volume_cb_gupnp_service_action_invoked, self, 0);
#line 97 "rygel-gst-rendering-control.vala"
	self->priv->_volume = volume_to_percentage (rygel_gst_player_get_volume (self->priv->player));
#line 263 "rygel-gst-rendering-control.c"
}


#line 100 "rygel-gst-rendering-control.vala"
static void rygel_gst_rendering_control_query_last_change_cb (RygelGstRenderingControl* self, GUPnPService* service, const char* variable, GValue* value) {
#line 269 "rygel-gst-rendering-control.c"
	RygelGstChangeLog* log;
	const char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
#line 100 "rygel-gst-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 100 "rygel-gst-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 100 "rygel-gst-rendering-control.vala"
	g_return_if_fail (variable != NULL);
#line 104 "rygel-gst-rendering-control.vala"
	log = rygel_gst_change_log_new (NULL, RYGEL_GST_RENDERING_CONTROL_LAST_CHANGE_NS);
#line 282 "rygel-gst-rendering-control.c"
	_tmp0_ = NULL;
#line 106 "rygel-gst-rendering-control.vala"
	if (rygel_gst_rendering_control_get_mute (self)) {
#line 106 "rygel-gst-rendering-control.vala"
		_tmp0_ = "1";
#line 288 "rygel-gst-rendering-control.c"
	} else {
#line 106 "rygel-gst-rendering-control.vala"
		_tmp0_ = "0";
#line 292 "rygel-gst-rendering-control.c"
	}
#line 106 "rygel-gst-rendering-control.vala"
	rygel_gst_change_log_log_with_channel (log, "Mute", _tmp0_, "Master");
#line 107 "rygel-gst-rendering-control.vala"
	rygel_gst_change_log_log_with_channel (log, "Volume", _tmp1_ = g_strdup_printf ("%u", rygel_gst_rendering_control_get_volume (self)), "Master");
#line 298 "rygel-gst-rendering-control.c"
	_g_free0 (_tmp1_);
#line 109 "rygel-gst-rendering-control.vala"
	g_value_init (value, G_TYPE_STRING);
#line 110 "rygel-gst-rendering-control.vala"
	g_value_set_string (value, _tmp2_ = rygel_gst_change_log_finish (log));
#line 304 "rygel-gst-rendering-control.c"
	_g_free0 (_tmp2_);
	_g_object_unref0 (log);
}


#line 114 "rygel-gst-rendering-control.vala"
static gboolean rygel_gst_rendering_control_check_instance_id (RygelGstRenderingControl* self, GUPnPServiceAction* action) {
#line 312 "rygel-gst-rendering-control.c"
	gboolean result;
	guint instance_id = 0U;
#line 114 "rygel-gst-rendering-control.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 114 "rygel-gst-rendering-control.vala"
	g_return_val_if_fail (action != NULL, FALSE);
#line 117 "rygel-gst-rendering-control.vala"
	gupnp_service_action_get (action, "InstanceID", G_TYPE_UINT, &instance_id, NULL);
#line 118 "rygel-gst-rendering-control.vala"
	if (instance_id != 0) {
#line 119 "rygel-gst-rendering-control.vala"
		gupnp_service_action_return_error (action, (guint) 702, "Invalid InstanceID");
#line 325 "rygel-gst-rendering-control.c"
		result = FALSE;
#line 121 "rygel-gst-rendering-control.vala"
		return result;
#line 329 "rygel-gst-rendering-control.c"
	}
	result = TRUE;
#line 124 "rygel-gst-rendering-control.vala"
	return result;
#line 334 "rygel-gst-rendering-control.c"
}


#line 127 "rygel-gst-rendering-control.vala"
static void rygel_gst_rendering_control_list_presets_cb (RygelGstRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 127 "rygel-gst-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 127 "rygel-gst-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 127 "rygel-gst-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 129 "rygel-gst-rendering-control.vala"
	if (!rygel_gst_rendering_control_check_instance_id (self, action)) {
#line 130 "rygel-gst-rendering-control.vala"
		return;
#line 350 "rygel-gst-rendering-control.c"
	}
#line 133 "rygel-gst-rendering-control.vala"
	gupnp_service_action_set (action, "CurrentPresetNameList", G_TYPE_STRING, self->priv->preset_name_list, NULL);
#line 137 "rygel-gst-rendering-control.vala"
	gupnp_service_action_return (action);
#line 356 "rygel-gst-rendering-control.c"
}


#line 140 "rygel-gst-rendering-control.vala"
static void rygel_gst_rendering_control_select_preset_cb (RygelGstRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 362 "rygel-gst-rendering-control.c"
	char* preset_name;
#line 140 "rygel-gst-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 140 "rygel-gst-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 140 "rygel-gst-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 142 "rygel-gst-rendering-control.vala"
	if (!rygel_gst_rendering_control_check_instance_id (self, action)) {
#line 143 "rygel-gst-rendering-control.vala"
		return;
#line 374 "rygel-gst-rendering-control.c"
	}
	preset_name = NULL;
#line 148 "rygel-gst-rendering-control.vala"
	gupnp_service_action_get (action, "PresetName", G_TYPE_STRING, &preset_name, NULL);
#line 149 "rygel-gst-rendering-control.vala"
	if (_vala_strcmp0 (preset_name, "") != 0) {
#line 150 "rygel-gst-rendering-control.vala"
		gupnp_service_action_return_error (action, (guint) 701, "Invalid Name");
#line 383 "rygel-gst-rendering-control.c"
		_g_free0 (preset_name);
#line 152 "rygel-gst-rendering-control.vala"
		return;
#line 387 "rygel-gst-rendering-control.c"
	}
#line 155 "rygel-gst-rendering-control.vala"
	gupnp_service_action_return (action);
#line 391 "rygel-gst-rendering-control.c"
	_g_free0 (preset_name);
}


#line 159 "rygel-gst-rendering-control.vala"
static gboolean rygel_gst_rendering_control_check_channel (RygelGstRenderingControl* self, GUPnPServiceAction* action) {
#line 398 "rygel-gst-rendering-control.c"
	gboolean result;
	char* channel;
#line 159 "rygel-gst-rendering-control.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 159 "rygel-gst-rendering-control.vala"
	g_return_val_if_fail (action != NULL, FALSE);
#line 405 "rygel-gst-rendering-control.c"
	channel = NULL;
#line 162 "rygel-gst-rendering-control.vala"
	gupnp_service_action_get (action, "Channel", G_TYPE_STRING, &channel, NULL);
#line 163 "rygel-gst-rendering-control.vala"
	if (_vala_strcmp0 (channel, "Master") != 0) {
#line 164 "rygel-gst-rendering-control.vala"
		gupnp_service_action_return_error (action, (guint) 501, "Action Failed");
#line 413 "rygel-gst-rendering-control.c"
		result = FALSE;
		_g_free0 (channel);
#line 166 "rygel-gst-rendering-control.vala"
		return result;
#line 418 "rygel-gst-rendering-control.c"
	}
	result = TRUE;
	_g_free0 (channel);
#line 169 "rygel-gst-rendering-control.vala"
	return result;
#line 424 "rygel-gst-rendering-control.c"
}


#line 172 "rygel-gst-rendering-control.vala"
static void rygel_gst_rendering_control_get_mute_cb (RygelGstRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 172 "rygel-gst-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 172 "rygel-gst-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 172 "rygel-gst-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 174 "rygel-gst-rendering-control.vala"
	if (!rygel_gst_rendering_control_check_instance_id (self, action)) {
#line 175 "rygel-gst-rendering-control.vala"
		return;
#line 440 "rygel-gst-rendering-control.c"
	}
#line 178 "rygel-gst-rendering-control.vala"
	if (!rygel_gst_rendering_control_check_channel (self, action)) {
#line 179 "rygel-gst-rendering-control.vala"
		return;
#line 446 "rygel-gst-rendering-control.c"
	}
#line 182 "rygel-gst-rendering-control.vala"
	gupnp_service_action_set (action, "CurrentMute", G_TYPE_BOOLEAN, rygel_gst_rendering_control_get_mute (self), NULL);
#line 184 "rygel-gst-rendering-control.vala"
	gupnp_service_action_return (action);
#line 452 "rygel-gst-rendering-control.c"
}


#line 187 "rygel-gst-rendering-control.vala"
static void rygel_gst_rendering_control_set_mute_cb (RygelGstRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 458 "rygel-gst-rendering-control.c"
	gboolean mute = FALSE;
#line 187 "rygel-gst-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 187 "rygel-gst-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 187 "rygel-gst-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 189 "rygel-gst-rendering-control.vala"
	if (!rygel_gst_rendering_control_check_instance_id (self, action)) {
#line 190 "rygel-gst-rendering-control.vala"
		return;
#line 470 "rygel-gst-rendering-control.c"
	}
#line 193 "rygel-gst-rendering-control.vala"
	if (!rygel_gst_rendering_control_check_channel (self, action)) {
#line 194 "rygel-gst-rendering-control.vala"
		return;
#line 476 "rygel-gst-rendering-control.c"
	}
#line 199 "rygel-gst-rendering-control.vala"
	gupnp_service_action_get (action, "DesiredMute", G_TYPE_BOOLEAN, &mute, NULL);
#line 201 "rygel-gst-rendering-control.vala"
	rygel_gst_rendering_control_set_mute (self, mute);
#line 203 "rygel-gst-rendering-control.vala"
	gupnp_service_action_return (action);
#line 484 "rygel-gst-rendering-control.c"
}


#line 206 "rygel-gst-rendering-control.vala"
static void rygel_gst_rendering_control_get_volume_cb (RygelGstRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 206 "rygel-gst-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 206 "rygel-gst-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 206 "rygel-gst-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 208 "rygel-gst-rendering-control.vala"
	if (!rygel_gst_rendering_control_check_instance_id (self, action)) {
#line 209 "rygel-gst-rendering-control.vala"
		return;
#line 500 "rygel-gst-rendering-control.c"
	}
#line 212 "rygel-gst-rendering-control.vala"
	if (!rygel_gst_rendering_control_check_channel (self, action)) {
#line 213 "rygel-gst-rendering-control.vala"
		return;
#line 506 "rygel-gst-rendering-control.c"
	}
#line 216 "rygel-gst-rendering-control.vala"
	gupnp_service_action_set (action, "CurrentVolume", G_TYPE_UINT, rygel_gst_rendering_control_get_volume (self), NULL);
#line 218 "rygel-gst-rendering-control.vala"
	gupnp_service_action_return (action);
#line 512 "rygel-gst-rendering-control.c"
}


#line 221 "rygel-gst-rendering-control.vala"
static void rygel_gst_rendering_control_set_volume_cb (RygelGstRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 518 "rygel-gst-rendering-control.c"
	guint volume = 0U;
#line 221 "rygel-gst-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 221 "rygel-gst-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 221 "rygel-gst-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 223 "rygel-gst-rendering-control.vala"
	if (!rygel_gst_rendering_control_check_instance_id (self, action)) {
#line 224 "rygel-gst-rendering-control.vala"
		return;
#line 530 "rygel-gst-rendering-control.c"
	}
#line 227 "rygel-gst-rendering-control.vala"
	if (!rygel_gst_rendering_control_check_channel (self, action)) {
#line 228 "rygel-gst-rendering-control.vala"
		return;
#line 536 "rygel-gst-rendering-control.c"
	}
#line 233 "rygel-gst-rendering-control.vala"
	gupnp_service_action_get (action, "DesiredVolume", G_TYPE_UINT, &volume, NULL);
#line 234 "rygel-gst-rendering-control.vala"
	if (volume > 100) {
#line 235 "rygel-gst-rendering-control.vala"
		gupnp_service_action_return_error (action, (guint) 501, "Action Failed");
#line 237 "rygel-gst-rendering-control.vala"
		return;
#line 546 "rygel-gst-rendering-control.c"
	}
#line 240 "rygel-gst-rendering-control.vala"
	rygel_gst_rendering_control_set_volume (self, volume);
#line 242 "rygel-gst-rendering-control.vala"
	gupnp_service_action_return (action);
#line 552 "rygel-gst-rendering-control.c"
}


#line 31 "rygel-gst-rendering-control.vala"
RygelGstRenderingControl* rygel_gst_rendering_control_construct (GType object_type) {
#line 558 "rygel-gst-rendering-control.c"
	RygelGstRenderingControl * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


#line 31 "rygel-gst-rendering-control.vala"
RygelGstRenderingControl* rygel_gst_rendering_control_new (void) {
#line 31 "rygel-gst-rendering-control.vala"
	return rygel_gst_rendering_control_construct (RYGEL_TYPE_GST_RENDERING_CONTROL);
#line 569 "rygel-gst-rendering-control.c"
}


gboolean rygel_gst_rendering_control_get_mute (RygelGstRenderingControl* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_mute;
#line 42 "rygel-gst-rendering-control.vala"
	return result;
#line 579 "rygel-gst-rendering-control.c"
}


void rygel_gst_rendering_control_set_mute (RygelGstRenderingControl* self, gboolean value) {
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
#line 46 "rygel-gst-rendering-control.vala"
	self->priv->_mute = value;
#line 48 "rygel-gst-rendering-control.vala"
	if (self->priv->_mute) {
#line 49 "rygel-gst-rendering-control.vala"
		rygel_gst_player_set_volume (self->priv->player, (double) 0);
#line 592 "rygel-gst-rendering-control.c"
	} else {
#line 51 "rygel-gst-rendering-control.vala"
		rygel_gst_player_set_volume (self->priv->player, volume_from_percentage (rygel_gst_rendering_control_get_volume (self)));
#line 596 "rygel-gst-rendering-control.c"
	}
	_tmp0_ = NULL;
#line 55 "rygel-gst-rendering-control.vala"
	if (rygel_gst_rendering_control_get_mute (self)) {
#line 55 "rygel-gst-rendering-control.vala"
		_tmp0_ = "1";
#line 603 "rygel-gst-rendering-control.c"
	} else {
#line 55 "rygel-gst-rendering-control.vala"
		_tmp0_ = "0";
#line 607 "rygel-gst-rendering-control.c"
	}
#line 54 "rygel-gst-rendering-control.vala"
	rygel_gst_change_log_log_with_channel (self->priv->changelog, "Mute", _tmp0_, "Master");
#line 611 "rygel-gst-rendering-control.c"
	g_object_notify ((GObject *) self, "mute");
}


guint rygel_gst_rendering_control_get_volume (RygelGstRenderingControl* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_volume;
#line 63 "rygel-gst-rendering-control.vala"
	return result;
#line 622 "rygel-gst-rendering-control.c"
}


void rygel_gst_rendering_control_set_volume (RygelGstRenderingControl* self, guint value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
#line 67 "rygel-gst-rendering-control.vala"
	self->priv->_volume = value;
#line 69 "rygel-gst-rendering-control.vala"
	if (!rygel_gst_rendering_control_get_mute (self)) {
#line 70 "rygel-gst-rendering-control.vala"
		rygel_gst_player_set_volume (self->priv->player, volume_from_percentage (rygel_gst_rendering_control_get_volume (self)));
#line 635 "rygel-gst-rendering-control.c"
	}
#line 73 "rygel-gst-rendering-control.vala"
	rygel_gst_change_log_log_with_channel (self->priv->changelog, "Volume", _tmp0_ = g_strdup_printf ("%u", rygel_gst_rendering_control_get_volume (self)), "Master");
#line 639 "rygel-gst-rendering-control.c"
	_g_free0 (_tmp0_);
	g_object_notify ((GObject *) self, "volume");
}


static void rygel_gst_rendering_control_class_init (RygelGstRenderingControlClass * klass) {
	rygel_gst_rendering_control_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelGstRenderingControlPrivate));
	G_OBJECT_CLASS (klass)->constructed = rygel_gst_rendering_control_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = rygel_gst_rendering_control_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_gst_rendering_control_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_rendering_control_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_RENDERING_CONTROL_MUTE, g_param_spec_boolean ("mute", "mute", "mute", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_RENDERING_CONTROL_VOLUME, g_param_spec_uint ("volume", "volume", "volume", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_gst_rendering_control_instance_init (RygelGstRenderingControl * self) {
	self->priv = RYGEL_GST_RENDERING_CONTROL_GET_PRIVATE (self);
	self->priv->_mute = FALSE;
	self->priv->_volume = (guint) 0;
	self->priv->preset_name_list = g_strdup ("");
}


static void rygel_gst_rendering_control_finalize (GObject* obj) {
	RygelGstRenderingControl * self;
	self = RYGEL_GST_RENDERING_CONTROL (obj);
	_g_free0 (self->priv->preset_name_list);
	_g_object_unref0 (self->priv->changelog);
	_g_object_unref0 (self->priv->player);
	G_OBJECT_CLASS (rygel_gst_rendering_control_parent_class)->finalize (obj);
}


GType rygel_gst_rendering_control_get_type (void) {
	static GType rygel_gst_rendering_control_type_id = 0;
	if (rygel_gst_rendering_control_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstRenderingControlClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_rendering_control_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstRenderingControl), 0, (GInstanceInitFunc) rygel_gst_rendering_control_instance_init, NULL };
		rygel_gst_rendering_control_type_id = g_type_register_static (GUPNP_TYPE_SERVICE, "RygelGstRenderingControl", &g_define_type_info, 0);
	}
	return rygel_gst_rendering_control_type_id;
}


static void rygel_gst_rendering_control_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelGstRenderingControl * self;
	self = RYGEL_GST_RENDERING_CONTROL (object);
	switch (property_id) {
		case RYGEL_GST_RENDERING_CONTROL_MUTE:
		g_value_set_boolean (value, rygel_gst_rendering_control_get_mute (self));
		break;
		case RYGEL_GST_RENDERING_CONTROL_VOLUME:
		g_value_set_uint (value, rygel_gst_rendering_control_get_volume (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_gst_rendering_control_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelGstRenderingControl * self;
	self = RYGEL_GST_RENDERING_CONTROL (object);
	switch (property_id) {
		case RYGEL_GST_RENDERING_CONTROL_MUTE:
		rygel_gst_rendering_control_set_mute (self, g_value_get_boolean (value));
		break;
		case RYGEL_GST_RENDERING_CONTROL_VOLUME:
		rygel_gst_rendering_control_set_volume (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


#line 249 "rygel-gst-rendering-control.vala"
double volume_from_percentage (guint percentage) {
#line 721 "rygel-gst-rendering-control.c"
	double result;
	result = ((double) percentage) / 100.0;
#line 250 "rygel-gst-rendering-control.vala"
	return result;
#line 726 "rygel-gst-rendering-control.c"
}


#line 253 "rygel-gst-rendering-control.vala"
guint volume_to_percentage (double volume) {
#line 732 "rygel-gst-rendering-control.c"
	guint result;
	result = (guint) (volume * 100.0);
#line 254 "rygel-gst-rendering-control.vala"
	return result;
#line 737 "rygel-gst-rendering-control.c"
}


#line 248 "rygel-gst-rendering-control.vala"
Volume* volume_construct (GType object_type) {
#line 743 "rygel-gst-rendering-control.c"
	Volume* self;
	self = (Volume*) g_type_create_instance (object_type);
	return self;
}


#line 248 "rygel-gst-rendering-control.vala"
Volume* volume_new (void) {
#line 248 "rygel-gst-rendering-control.vala"
	return volume_construct (TYPE_VOLUME);
#line 754 "rygel-gst-rendering-control.c"
}


static void value_volume_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_volume_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		volume_unref (value->data[0].v_pointer);
	}
}


static void value_volume_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = volume_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_volume_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_volume_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Volume* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = volume_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_volume_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Volume** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = volume_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_volume (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecVolume* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VOLUME), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_volume (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VOLUME), NULL);
	return value->data[0].v_pointer;
}


void value_set_volume (GValue* value, gpointer v_object) {
	Volume* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VOLUME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VOLUME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		volume_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		volume_unref (old);
	}
}


static void volume_class_init (VolumeClass * klass) {
	volume_parent_class = g_type_class_peek_parent (klass);
	VOLUME_CLASS (klass)->finalize = volume_finalize;
}


static void volume_instance_init (Volume * self) {
	self->ref_count = 1;
}


static void volume_finalize (Volume* obj) {
	Volume * self;
	self = VOLUME (obj);
}


GType volume_get_type (void) {
	static GType volume_type_id = 0;
	if (volume_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { value_volume_init, value_volume_free_value, value_volume_copy_value, value_volume_peek_pointer, "p", value_volume_collect_value, "p", value_volume_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (VolumeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) volume_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Volume), 0, (GInstanceInitFunc) volume_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		volume_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Volume", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return volume_type_id;
}


gpointer volume_ref (gpointer instance) {
	Volume* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void volume_unref (gpointer instance) {
	Volume* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VOLUME_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




