/* rygel-seekable-response.c generated by valac, the Vala compiler
 * generated from rygel-seekable-response.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;

#define RYGEL_TYPE_SEEKABLE_RESPONSE (rygel_seekable_response_get_type ())
#define RYGEL_SEEKABLE_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEEKABLE_RESPONSE, RygelSeekableResponse))
#define RYGEL_SEEKABLE_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEEKABLE_RESPONSE, RygelSeekableResponseClass))
#define RYGEL_IS_SEEKABLE_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEEKABLE_RESPONSE))
#define RYGEL_IS_SEEKABLE_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEEKABLE_RESPONSE))
#define RYGEL_SEEKABLE_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEEKABLE_RESPONSE, RygelSeekableResponseClass))

typedef struct _RygelSeekableResponse RygelSeekableResponse;
typedef struct _RygelSeekableResponseClass RygelSeekableResponseClass;
typedef struct _RygelSeekableResponsePrivate RygelSeekableResponsePrivate;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelSeekableResponseRunData RygelSeekableResponseRunData;
typedef struct _RygelSeekableResponsePerformSeekData RygelSeekableResponsePerformSeekData;
typedef struct _RygelSeekableResponseStartReadingData RygelSeekableResponseStartReadingData;
typedef struct _Block2Data Block2Data;
typedef struct _RygelSeekableResponseReadContentsData RygelSeekableResponseReadContentsData;
typedef struct _RygelSeekableResponseCloseStreamData RygelSeekableResponseCloseStreamData;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
	SoupMessage* msg;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelHTTPResponse* self, GAsyncResult* _res_);
	void (*end) (RygelHTTPResponse* self, gboolean aborted, guint status);
};

struct _RygelSeekableResponse {
	RygelHTTPResponse parent_instance;
	RygelSeekableResponsePrivate * priv;
};

struct _RygelSeekableResponseClass {
	RygelHTTPResponseClass parent_class;
};

struct _RygelSeekableResponsePrivate {
	RygelHTTPSeek* seek;
	GFile* file;
	GFileInputStream* input_stream;
	gchar* buffer;
	gint buffer_length1;
	gint buffer_size;
	gsize total_length;
	gint priority;
};

struct _RygelSeekableResponseRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSeekableResponse* self;
	GFileInputStream* _tmp0_;
	GFileInputStream* _tmp1_;
	char* _tmp2_;
	GError * err;
	GError * _inner_error_;
};

struct _RygelSeekableResponsePerformSeekData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSeekableResponse* self;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	GError * err;
	GError * _inner_error_;
};

struct _RygelSeekableResponseStartReadingData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSeekableResponse* self;
	GError * cancelled_err;
	char* _tmp0_;
	GError * err;
	GError * _inner_error_;
};

struct _Block2Data {
	int _ref_count_;
	RygelSeekableResponse * self;
	GSourceFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

struct _RygelSeekableResponseReadContentsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSeekableResponse* self;
	gssize bytes_read;
	GSourceFunc _tmp0_;
	gssize _tmp1_;
	Block2Data* _data2_;
	GError * _inner_error_;
};

struct _RygelSeekableResponseCloseStreamData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSeekableResponse* self;
	char* _tmp0_;
	GError * err;
	GError * _inner_error_;
};


static gpointer rygel_seekable_response_parent_class = NULL;

GType rygel_state_machine_get_type (void);
GType rygel_http_response_get_type (void);
GType rygel_seekable_response_get_type (void);
GType rygel_http_seek_get_type (void);
#define RYGEL_SEEKABLE_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_SEEKABLE_RESPONSE, RygelSeekableResponsePrivate))
enum  {
	RYGEL_SEEKABLE_RESPONSE_DUMMY_PROPERTY
};
#define RYGEL_SEEKABLE_RESPONSE_BUFFER_LENGTH ((gsize) 4096)
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, gboolean partial, GCancellable* cancellable);
static gint rygel_seekable_response_get_requested_priority (RygelSeekableResponse* self);
RygelSeekableResponse* rygel_seekable_response_new (SoupServer* server, SoupMessage* msg, const char* uri, RygelHTTPSeek* seek, gsize file_length, GCancellable* cancellable);
RygelSeekableResponse* rygel_seekable_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, const char* uri, RygelHTTPSeek* seek, gsize file_length, GCancellable* cancellable);
static void rygel_seekable_response_real_run_data_free (gpointer _data);
static void rygel_seekable_response_real_run (RygelHTTPResponse* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_seekable_response_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
void rygel_http_response_end (RygelHTTPResponse* self, gboolean aborted, guint status);
static void rygel_seekable_response_perform_seek (RygelSeekableResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_seekable_response_perform_seek_finish (RygelSeekableResponse* self, GAsyncResult* _res_);
static gboolean rygel_seekable_response_real_run_co (RygelSeekableResponseRunData* data);
static void rygel_seekable_response_perform_seek_data_free (gpointer _data);
static void rygel_seekable_response_perform_seek_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
static void rygel_seekable_response_start_reading (RygelSeekableResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_seekable_response_start_reading_finish (RygelSeekableResponse* self, GAsyncResult* _res_);
static gboolean rygel_seekable_response_perform_seek_co (RygelSeekableResponsePerformSeekData* data);
static void rygel_seekable_response_start_reading_data_free (gpointer _data);
static void rygel_seekable_response_start_reading_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_seekable_response_read_contents (RygelSeekableResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_seekable_response_read_contents_finish (RygelSeekableResponse* self, GAsyncResult* _res_, GError** error);
static void rygel_seekable_response_close_stream (RygelSeekableResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_seekable_response_close_stream_finish (RygelSeekableResponse* self, GAsyncResult* _res_);
static gboolean rygel_seekable_response_start_reading_co (RygelSeekableResponseStartReadingData* data);
static gsize rygel_seekable_response_bytes_to_read (RygelSeekableResponse* self);
static void rygel_seekable_response_read_contents_data_free (gpointer _data);
static void rygel_seekable_response_read_contents_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean _rygel_seekable_response_read_contents_co_gsource_func (gpointer self);
static void _lambda1_ (SoupMessage* msg, Block2Data* _data2_);
static void __lambda1__soup_message_wrote_chunk (SoupMessage* _sender, gpointer self);
static void _lambda2_ (Block2Data* _data2_);
static void __lambda2__g_cancellable_cancelled (GCancellable* _sender, gpointer self);
void rygel_http_response_push_data (RygelHTTPResponse* self, void* data, gsize length);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean rygel_seekable_response_read_contents_co (RygelSeekableResponseReadContentsData* data);
static void rygel_seekable_response_close_stream_data_free (gpointer _data);
static void rygel_seekable_response_close_stream_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_seekable_response_close_stream_co (RygelSeekableResponseCloseStreamData* data);
static void rygel_seekable_response_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 39 "rygel-seekable-response.vala"
RygelSeekableResponse* rygel_seekable_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, const char* uri, RygelHTTPSeek* seek, gsize file_length, GCancellable* cancellable) {
#line 258 "rygel-seekable-response.c"
	RygelSeekableResponse * self;
	gboolean _tmp0_ = FALSE;
	gboolean partial;
	RygelHTTPSeek* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
#line 39 "rygel-seekable-response.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 39 "rygel-seekable-response.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 39 "rygel-seekable-response.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 45 "rygel-seekable-response.vala"
	if (seek != NULL) {
#line 45 "rygel-seekable-response.vala"
		_tmp0_ = rygel_http_seek_get_length (seek) < file_length;
#line 275 "rygel-seekable-response.c"
	} else {
#line 45 "rygel-seekable-response.vala"
		_tmp0_ = FALSE;
#line 279 "rygel-seekable-response.c"
	}
#line 45 "rygel-seekable-response.vala"
	partial = _tmp0_;
#line 47 "rygel-seekable-response.vala"
	self = (RygelSeekableResponse*) rygel_http_response_construct (object_type, server, msg, partial, cancellable);
#line 49 "rygel-seekable-response.vala"
	self->priv->seek = (_tmp1_ = _g_object_ref0 (seek), _g_object_unref0 (self->priv->seek), _tmp1_);
#line 50 "rygel-seekable-response.vala"
	self->priv->total_length = file_length;
#line 51 "rygel-seekable-response.vala"
	self->priv->priority = rygel_seekable_response_get_requested_priority (self);
#line 53 "rygel-seekable-response.vala"
	if (seek != NULL) {
#line 54 "rygel-seekable-response.vala"
		self->priv->total_length = (gsize) rygel_http_seek_get_length (seek);
#line 295 "rygel-seekable-response.c"
	} else {
#line 56 "rygel-seekable-response.vala"
		self->priv->total_length = file_length;
#line 299 "rygel-seekable-response.c"
	}
#line 59 "rygel-seekable-response.vala"
	self->priv->buffer = (_tmp2_ = g_new0 (gchar, RYGEL_SEEKABLE_RESPONSE_BUFFER_LENGTH), self->priv->buffer = (g_free (self->priv->buffer), NULL), self->priv->buffer_length1 = RYGEL_SEEKABLE_RESPONSE_BUFFER_LENGTH, self->priv->buffer_size = self->priv->buffer_length1, _tmp2_);
#line 60 "rygel-seekable-response.vala"
	self->priv->file = (_tmp3_ = g_file_new_for_uri (uri), _g_object_unref0 (self->priv->file), _tmp3_);
#line 305 "rygel-seekable-response.c"
	return self;
}


#line 39 "rygel-seekable-response.vala"
RygelSeekableResponse* rygel_seekable_response_new (SoupServer* server, SoupMessage* msg, const char* uri, RygelHTTPSeek* seek, gsize file_length, GCancellable* cancellable) {
#line 39 "rygel-seekable-response.vala"
	return rygel_seekable_response_construct (RYGEL_TYPE_SEEKABLE_RESPONSE, server, msg, uri, seek, file_length, cancellable);
#line 314 "rygel-seekable-response.c"
}


static void rygel_seekable_response_real_run_data_free (gpointer _data) {
	RygelSeekableResponseRunData* data;
	data = _data;
	g_slice_free (RygelSeekableResponseRunData, data);
}


static void rygel_seekable_response_real_run (RygelHTTPResponse* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSeekableResponse * self;
	RygelSeekableResponseRunData* _data_;
	self = (RygelSeekableResponse*) base;
	_data_ = g_slice_new0 (RygelSeekableResponseRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_seekable_response_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_seekable_response_real_run_data_free);
	_data_->self = self;
	rygel_seekable_response_real_run_co (_data_);
}


static void rygel_seekable_response_real_run_finish (RygelHTTPResponse* base, GAsyncResult* _res_) {
	RygelSeekableResponseRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_seekable_response_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSeekableResponseRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_seekable_response_real_run_co (data);
}


static gboolean rygel_seekable_response_real_run_co (RygelSeekableResponseRunData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			{
				data->_state_ = 6;
				g_file_read_async (data->self->priv->file, data->self->priv->priority, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), rygel_seekable_response_run_ready, data);
				return FALSE;
				case 6:
				data->_tmp0_ = g_file_read_finish (data->self->priv->file, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					goto __catch30_g_error;
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
#line 65 "rygel-seekable-response.vala"
				data->self->priv->input_stream = (data->_tmp1_ = data->_tmp0_, _g_object_unref0 (data->self->priv->input_stream), data->_tmp1_);
#line 371 "rygel-seekable-response.c"
			}
			goto __finally30;
			__catch30_g_error:
			{
				data->err = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
#line 68 "rygel-seekable-response.vala"
					g_warning ("rygel-seekable-response.vala:68: Failed to read from URI: %s: %s\n", data->_tmp2_ = g_file_get_uri (data->self->priv->file), data->err->message);
#line 381 "rygel-seekable-response.c"
					_g_free0 (data->_tmp2_);
#line 71 "rygel-seekable-response.vala"
					rygel_http_response_end ((RygelHTTPResponse*) data->self, FALSE, (guint) SOUP_STATUS_NOT_FOUND);
#line 385 "rygel-seekable-response.c"
					_g_error_free0 (data->err);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
					_g_error_free0 (data->err);
				}
			}
			__finally30:
			if (data->_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			data->_state_ = 7;
			rygel_seekable_response_perform_seek (data->self, rygel_seekable_response_run_ready, data);
			return FALSE;
			case 7:
#line 76 "rygel-seekable-response.vala"
			rygel_seekable_response_perform_seek_finish (data->self, data->_res_);
#line 411 "rygel-seekable-response.c"
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_seekable_response_perform_seek_data_free (gpointer _data) {
	RygelSeekableResponsePerformSeekData* data;
	data = _data;
	g_slice_free (RygelSeekableResponsePerformSeekData, data);
}


static void rygel_seekable_response_perform_seek (RygelSeekableResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSeekableResponsePerformSeekData* _data_;
	_data_ = g_slice_new0 (RygelSeekableResponsePerformSeekData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_seekable_response_perform_seek);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_seekable_response_perform_seek_data_free);
	_data_->self = self;
	rygel_seekable_response_perform_seek_co (_data_);
}


static void rygel_seekable_response_perform_seek_finish (RygelSeekableResponse* self, GAsyncResult* _res_) {
	RygelSeekableResponsePerformSeekData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_seekable_response_perform_seek_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSeekableResponsePerformSeekData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_seekable_response_perform_seek_co (data);
}


static gboolean rygel_seekable_response_perform_seek_co (RygelSeekableResponsePerformSeekData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
#line 80 "rygel-seekable-response.vala"
			if (data->self->priv->seek != NULL) {
#line 465 "rygel-seekable-response.c"
				{
#line 82 "rygel-seekable-response.vala"
					G_FILE_INPUT_STREAM_GET_CLASS (data->self->priv->input_stream)->seek (data->self->priv->input_stream, rygel_http_seek_get_start (data->self->priv->seek), G_SEEK_SET, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), &data->_inner_error_);
#line 469 "rygel-seekable-response.c"
					if (data->_inner_error_ != NULL) {
						goto __catch31_g_error;
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
						g_clear_error (&data->_inner_error_);
						return FALSE;
					}
				}
				goto __finally31;
				__catch31_g_error:
				{
					data->err = data->_inner_error_;
					data->_inner_error_ = NULL;
					{
#line 86 "rygel-seekable-response.vala"
						g_warning ("rygel-seekable-response.vala:86: Failed to seek to %s-%s on URI %s: %s\n", data->_tmp0_ = g_strdup_printf ("%lli", rygel_http_seek_get_start (data->self->priv->seek)), data->_tmp1_ = g_strdup_printf ("%lli", rygel_http_seek_get_stop (data->self->priv->seek)), data->_tmp2_ = g_file_get_uri (data->self->priv->file), data->err->message);
#line 485 "rygel-seekable-response.c"
						_g_free0 (data->_tmp2_);
						_g_free0 (data->_tmp1_);
						_g_free0 (data->_tmp0_);
#line 91 "rygel-seekable-response.vala"
						rygel_http_response_end ((RygelHTTPResponse*) data->self, FALSE, (guint) SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE);
#line 491 "rygel-seekable-response.c"
						_g_error_free0 (data->err);
						{
							if (data->_state_ == 0) {
								g_simple_async_result_complete_in_idle (data->_async_result);
							} else {
								g_simple_async_result_complete (data->_async_result);
							}
							g_object_unref (data->_async_result);
							return FALSE;
						}
						_g_error_free0 (data->err);
					}
				}
				__finally31:
				if (data->_inner_error_ != NULL) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
			}
			data->_state_ = 8;
			rygel_seekable_response_start_reading (data->self, rygel_seekable_response_perform_seek_ready, data);
			return FALSE;
			case 8:
#line 97 "rygel-seekable-response.vala"
			rygel_seekable_response_start_reading_finish (data->self, data->_res_);
#line 518 "rygel-seekable-response.c"
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_seekable_response_start_reading_data_free (gpointer _data) {
	RygelSeekableResponseStartReadingData* data;
	data = _data;
	g_slice_free (RygelSeekableResponseStartReadingData, data);
}


static void rygel_seekable_response_start_reading (RygelSeekableResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSeekableResponseStartReadingData* _data_;
	_data_ = g_slice_new0 (RygelSeekableResponseStartReadingData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_seekable_response_start_reading);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_seekable_response_start_reading_data_free);
	_data_->self = self;
	rygel_seekable_response_start_reading_co (_data_);
}


static void rygel_seekable_response_start_reading_finish (RygelSeekableResponse* self, GAsyncResult* _res_) {
	RygelSeekableResponseStartReadingData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_seekable_response_start_reading_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSeekableResponseStartReadingData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_seekable_response_start_reading_co (data);
}


static gboolean rygel_seekable_response_start_reading_co (RygelSeekableResponseStartReadingData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			{
				data->_state_ = 9;
				rygel_seekable_response_read_contents (data->self, rygel_seekable_response_start_reading_ready, data);
				return FALSE;
				case 9:
#line 102 "rygel-seekable-response.vala"
				rygel_seekable_response_read_contents_finish (data->self, data->_res_, &data->_inner_error_);
#line 577 "rygel-seekable-response.c"
				if (data->_inner_error_ != NULL) {
					if (g_error_matches (data->_inner_error_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
						goto __catch32_g_io_error_cancelled;
					}
					goto __catch32_g_error;
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
			}
			goto __finally32;
			__catch32_g_io_error_cancelled:
			{
				data->cancelled_err = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
					_g_error_free0 (data->cancelled_err);
				}
			}
			goto __finally32;
			__catch32_g_error:
			{
				data->err = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
#line 106 "rygel-seekable-response.vala"
					g_warning ("rygel-seekable-response.vala:106: Failed to read contents from URI: %s: %s\n", data->_tmp0_ = g_file_get_uri (data->self->priv->file), data->err->message);
#line 605 "rygel-seekable-response.c"
					_g_free0 (data->_tmp0_);
#line 109 "rygel-seekable-response.vala"
					rygel_http_response_end ((RygelHTTPResponse*) data->self, FALSE, (guint) SOUP_STATUS_NOT_FOUND);
#line 609 "rygel-seekable-response.c"
					_g_error_free0 (data->err);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
					_g_error_free0 (data->err);
				}
			}
			__finally32:
			if (data->_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			data->_state_ = 10;
			rygel_seekable_response_close_stream (data->self, rygel_seekable_response_start_reading_ready, data);
			return FALSE;
			case 10:
#line 114 "rygel-seekable-response.vala"
			rygel_seekable_response_close_stream_finish (data->self, data->_res_);
#line 635 "rygel-seekable-response.c"
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


#line 117 "rygel-seekable-response.vala"
static gsize rygel_seekable_response_bytes_to_read (RygelSeekableResponse* self) {
#line 652 "rygel-seekable-response.c"
	gsize result;
#line 117 "rygel-seekable-response.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 656 "rygel-seekable-response.c"
	result = MIN (self->priv->total_length, RYGEL_SEEKABLE_RESPONSE_BUFFER_LENGTH);
#line 118 "rygel-seekable-response.vala"
	return result;
#line 660 "rygel-seekable-response.c"
}


static void rygel_seekable_response_read_contents_data_free (gpointer _data) {
	RygelSeekableResponseReadContentsData* data;
	data = _data;
	g_slice_free (RygelSeekableResponseReadContentsData, data);
}


static void rygel_seekable_response_read_contents (RygelSeekableResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSeekableResponseReadContentsData* _data_;
	_data_ = g_slice_new0 (RygelSeekableResponseReadContentsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_seekable_response_read_contents);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_seekable_response_read_contents_data_free);
	_data_->self = self;
	rygel_seekable_response_read_contents_co (_data_);
}


static void rygel_seekable_response_read_contents_finish (RygelSeekableResponse* self, GAsyncResult* _res_, GError** error) {
	RygelSeekableResponseReadContentsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_seekable_response_read_contents_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSeekableResponseReadContentsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_seekable_response_read_contents_co (data);
}


#line 122 "rygel-seekable-response.vala"
static gboolean _rygel_seekable_response_read_contents_co_gsource_func (gpointer self) {
#line 700 "rygel-seekable-response.c"
	return rygel_seekable_response_read_contents_co (self);
}


#line 129 "rygel-seekable-response.vala"
static void _lambda1_ (SoupMessage* msg, Block2Data* _data2_) {
#line 707 "rygel-seekable-response.c"
	RygelSeekableResponse * self;
	self = _data2_->self;
#line 129 "rygel-seekable-response.vala"
	g_return_if_fail (msg != NULL);
#line 130 "rygel-seekable-response.vala"
	_data2_->cb (_data2_->cb_target);
#line 714 "rygel-seekable-response.c"
}


#line 129 "rygel-seekable-response.vala"
static void __lambda1__soup_message_wrote_chunk (SoupMessage* _sender, gpointer self) {
#line 720 "rygel-seekable-response.c"
	_lambda1_ (_sender, self);
}


#line 133 "rygel-seekable-response.vala"
static void _lambda2_ (Block2Data* _data2_) {
#line 727 "rygel-seekable-response.c"
	RygelSeekableResponse * self;
	self = _data2_->self;
#line 134 "rygel-seekable-response.vala"
	_data2_->cb (_data2_->cb_target);
#line 732 "rygel-seekable-response.c"
}


#line 133 "rygel-seekable-response.vala"
static void __lambda2__g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
#line 738 "rygel-seekable-response.c"
	_lambda2_ (self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	++_data2_->_ref_count_;
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if ((--_data2_->_ref_count_) == 0) {
		_g_object_unref0 (_data2_->self);
		(_data2_->cb_target_destroy_notify == NULL) ? NULL : _data2_->cb_target_destroy_notify (_data2_->cb_target);
		_data2_->cb = NULL;
		_data2_->cb_target = NULL;
		_data2_->cb_target_destroy_notify = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean rygel_seekable_response_read_contents_co (RygelSeekableResponseReadContentsData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->_data2_ = g_slice_new0 (Block2Data);
			data->_data2_->_ref_count_ = 1;
			data->_data2_->self = g_object_ref (data->self);
			data->_state_ = 11;
			g_input_stream_read_async ((GInputStream*) data->self->priv->input_stream, data->self->priv->buffer, rygel_seekable_response_bytes_to_read (data->self), data->self->priv->priority, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), rygel_seekable_response_read_contents_ready, data);
			return FALSE;
			case 11:
			data->bytes_read = g_input_stream_read_finish ((GInputStream*) data->self->priv->input_stream, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				block2_data_unref (data->_data2_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			data->_data2_->cb = (data->_tmp0_ = _rygel_seekable_response_read_contents_co_gsource_func, data->_data2_->cb_target = data, data->_data2_->cb_target_destroy_notify = NULL, data->_tmp0_);
#line 129 "rygel-seekable-response.vala"
			g_signal_connect_data (((RygelHTTPResponse*) data->self)->msg, "wrote-chunk", (GCallback) __lambda1__soup_message_wrote_chunk, block2_data_ref (data->_data2_), (GClosureNotify) block2_data_unref, 0);
#line 132 "rygel-seekable-response.vala"
			if (rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self) != NULL) {
#line 133 "rygel-seekable-response.vala"
				g_signal_connect_data (rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), "cancelled", (GCallback) __lambda2__g_cancellable_cancelled, block2_data_ref (data->_data2_), (GClosureNotify) block2_data_unref, 0);
#line 796 "rygel-seekable-response.c"
			}
#line 138 "rygel-seekable-response.vala"
			while (TRUE) {
#line 138 "rygel-seekable-response.vala"
				if (!(data->bytes_read > 0)) {
#line 138 "rygel-seekable-response.vala"
					break;
#line 804 "rygel-seekable-response.c"
				}
#line 139 "rygel-seekable-response.vala"
				rygel_http_response_push_data ((RygelHTTPResponse*) data->self, data->self->priv->buffer, (gsize) data->bytes_read);
#line 140 "rygel-seekable-response.vala"
				data->self->priv->total_length = data->self->priv->total_length - ((gsize) data->bytes_read);
#line 810 "rygel-seekable-response.c"
				data->_state_ = 12;
				return FALSE;
				case 12:
				;
				data->_state_ = 13;
				g_input_stream_read_async ((GInputStream*) data->self->priv->input_stream, data->self->priv->buffer, rygel_seekable_response_bytes_to_read (data->self), data->self->priv->priority, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), rygel_seekable_response_read_contents_ready, data);
				return FALSE;
				case 13:
				data->_tmp1_ = g_input_stream_read_finish ((GInputStream*) data->self->priv->input_stream, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					block2_data_unref (data->_data2_);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
#line 146 "rygel-seekable-response.vala"
				data->bytes_read = data->_tmp1_;
#line 836 "rygel-seekable-response.c"
			}
			block2_data_unref (data->_data2_);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_seekable_response_close_stream_data_free (gpointer _data) {
	RygelSeekableResponseCloseStreamData* data;
	data = _data;
	g_slice_free (RygelSeekableResponseCloseStreamData, data);
}


static void rygel_seekable_response_close_stream (RygelSeekableResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSeekableResponseCloseStreamData* _data_;
	_data_ = g_slice_new0 (RygelSeekableResponseCloseStreamData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_seekable_response_close_stream);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_seekable_response_close_stream_data_free);
	_data_->self = self;
	rygel_seekable_response_close_stream_co (_data_);
}


static void rygel_seekable_response_close_stream_finish (RygelSeekableResponse* self, GAsyncResult* _res_) {
	RygelSeekableResponseCloseStreamData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_seekable_response_close_stream_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSeekableResponseCloseStreamData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_seekable_response_close_stream_co (data);
}


static gboolean rygel_seekable_response_close_stream_co (RygelSeekableResponseCloseStreamData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			{
				data->_state_ = 14;
				g_input_stream_close_async ((GInputStream*) data->self->priv->input_stream, data->self->priv->priority, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), rygel_seekable_response_close_stream_ready, data);
				return FALSE;
				case 14:
#line 156 "rygel-seekable-response.vala"
				g_input_stream_close_finish ((GInputStream*) data->self->priv->input_stream, data->_res_, &data->_inner_error_);
#line 897 "rygel-seekable-response.c"
				if (data->_inner_error_ != NULL) {
					goto __catch33_g_error;
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
			}
			goto __finally33;
			__catch33_g_error:
			{
				data->err = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
#line 159 "rygel-seekable-response.vala"
					g_warning ("rygel-seekable-response.vala:159: Failed to close stream to URI %s: %s\n", data->_tmp0_ = g_file_get_uri (data->self->priv->file), data->err->message);
#line 913 "rygel-seekable-response.c"
					_g_free0 (data->_tmp0_);
					_g_error_free0 (data->err);
				}
			}
			__finally33:
			if (data->_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
#line 164 "rygel-seekable-response.vala"
			rygel_http_response_end ((RygelHTTPResponse*) data->self, FALSE, (guint) SOUP_STATUS_NONE);
#line 926 "rygel-seekable-response.c"
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


#line 167 "rygel-seekable-response.vala"
static gint rygel_seekable_response_get_requested_priority (RygelSeekableResponse* self) {
#line 943 "rygel-seekable-response.c"
	gint result;
	char* mode;
	gboolean _tmp0_ = FALSE;
#line 167 "rygel-seekable-response.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 168 "rygel-seekable-response.vala"
	mode = g_strdup (soup_message_headers_get (((RygelHTTPResponse*) self)->msg->request_headers, "transferMode.dlna.org"));
#line 170 "rygel-seekable-response.vala"
	if (mode == NULL) {
#line 170 "rygel-seekable-response.vala"
		_tmp0_ = TRUE;
#line 955 "rygel-seekable-response.c"
	} else {
#line 170 "rygel-seekable-response.vala"
		_tmp0_ = _vala_strcmp0 (mode, "Interactive") == 0;
#line 959 "rygel-seekable-response.c"
	}
#line 170 "rygel-seekable-response.vala"
	if (_tmp0_) {
#line 963 "rygel-seekable-response.c"
		result = G_PRIORITY_DEFAULT;
		_g_free0 (mode);
#line 171 "rygel-seekable-response.vala"
		return result;
#line 968 "rygel-seekable-response.c"
	} else {
#line 172 "rygel-seekable-response.vala"
		if (_vala_strcmp0 (mode, "Streaming") == 0) {
#line 972 "rygel-seekable-response.c"
			result = G_PRIORITY_HIGH;
			_g_free0 (mode);
#line 173 "rygel-seekable-response.vala"
			return result;
#line 977 "rygel-seekable-response.c"
		} else {
#line 174 "rygel-seekable-response.vala"
			if (_vala_strcmp0 (mode, "Background") == 0) {
#line 981 "rygel-seekable-response.c"
				result = G_PRIORITY_LOW;
				_g_free0 (mode);
#line 175 "rygel-seekable-response.vala"
				return result;
#line 986 "rygel-seekable-response.c"
			} else {
				result = G_PRIORITY_DEFAULT;
				_g_free0 (mode);
#line 177 "rygel-seekable-response.vala"
				return result;
#line 992 "rygel-seekable-response.c"
			}
		}
	}
	_g_free0 (mode);
}


static void rygel_seekable_response_class_init (RygelSeekableResponseClass * klass) {
	rygel_seekable_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelSeekableResponsePrivate));
	RYGEL_HTTP_RESPONSE_CLASS (klass)->run = rygel_seekable_response_real_run;
	RYGEL_HTTP_RESPONSE_CLASS (klass)->run_finish = rygel_seekable_response_real_run_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_seekable_response_finalize;
}


static void rygel_seekable_response_instance_init (RygelSeekableResponse * self) {
	self->priv = RYGEL_SEEKABLE_RESPONSE_GET_PRIVATE (self);
}


static void rygel_seekable_response_finalize (GObject* obj) {
	RygelSeekableResponse * self;
	self = RYGEL_SEEKABLE_RESPONSE (obj);
	_g_object_unref0 (self->priv->seek);
	_g_object_unref0 (self->priv->file);
	_g_object_unref0 (self->priv->input_stream);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	G_OBJECT_CLASS (rygel_seekable_response_parent_class)->finalize (obj);
}


GType rygel_seekable_response_get_type (void) {
	static GType rygel_seekable_response_type_id = 0;
	if (rygel_seekable_response_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSeekableResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_seekable_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSeekableResponse), 0, (GInstanceInitFunc) rygel_seekable_response_instance_init, NULL };
		rygel_seekable_response_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE, "RygelSeekableResponse", &g_define_type_info, 0);
	}
	return rygel_seekable_response_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




