/* rygel-media-db.c generated by valac, the Vala compiler
 * generated from rygel-media-db.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <gee.h>
#include <gst/gst.h>


#define RYGEL_TYPE_MEDIA_DB_OBJECT_TYPE (rygel_media_db_object_type_get_type ())

#define RYGEL_TYPE_MEDIA_DB (rygel_media_db_get_type ())
#define RYGEL_MEDIA_DB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_DB, RygelMediaDB))
#define RYGEL_MEDIA_DB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_DB, RygelMediaDBClass))
#define RYGEL_IS_MEDIA_DB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_DB))
#define RYGEL_IS_MEDIA_DB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_DB))
#define RYGEL_MEDIA_DB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_DB, RygelMediaDBClass))

typedef struct _RygelMediaDB RygelMediaDB;
typedef struct _RygelMediaDBClass RygelMediaDBClass;
typedef struct _RygelMediaDBPrivate RygelMediaDBPrivate;

#define RYGEL_TYPE_DATABASE (rygel_database_get_type ())
#define RYGEL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATABASE, RygelDatabase))
#define RYGEL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DATABASE, RygelDatabaseClass))
#define RYGEL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATABASE))
#define RYGEL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DATABASE))
#define RYGEL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DATABASE, RygelDatabaseClass))

typedef struct _RygelDatabase RygelDatabase;
typedef struct _RygelDatabaseClass RygelDatabaseClass;

#define RYGEL_TYPE_MEDIA_DB_OBJECT_FACTORY (rygel_media_db_object_factory_get_type ())
#define RYGEL_MEDIA_DB_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_DB_OBJECT_FACTORY, RygelMediaDBObjectFactory))
#define RYGEL_MEDIA_DB_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_DB_OBJECT_FACTORY, RygelMediaDBObjectFactoryClass))
#define RYGEL_IS_MEDIA_DB_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_DB_OBJECT_FACTORY))
#define RYGEL_IS_MEDIA_DB_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_DB_OBJECT_FACTORY))
#define RYGEL_MEDIA_DB_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_DB_OBJECT_FACTORY, RygelMediaDBObjectFactoryClass))

typedef struct _RygelMediaDBObjectFactory RygelMediaDBObjectFactory;
typedef struct _RygelMediaDBObjectFactoryClass RygelMediaDBObjectFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _Block3Data Block3Data;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;

typedef enum  {
	RYGEL_MEDIA_DB_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_DB_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_DB_ERROR_INVALID_TYPE
} RygelMediaDBError;
#define RYGEL_MEDIA_DB_ERROR rygel_media_db_error_quark ()
typedef enum  {
	RYGEL_MEDIA_DB_OBJECT_TYPE_CONTAINER,
	RYGEL_MEDIA_DB_OBJECT_TYPE_ITEM
} RygelMediaDBObjectType;

struct _RygelMediaDB {
	GObject parent_instance;
	RygelMediaDBPrivate * priv;
};

struct _RygelMediaDBClass {
	GObjectClass parent_class;
};

struct _RygelMediaDBPrivate {
	RygelDatabase* db;
	RygelMediaDBObjectFactory* factory;
};

typedef enum  {
	RYGEL_DATABASE_ERROR_SQLITE_ERROR
} RygelDatabaseError;
#define RYGEL_DATABASE_ERROR rygel_database_error_quark ()
typedef gboolean (*RygelDatabaseRowCallback) (sqlite3_stmt* stmt, void* user_data);
struct _Block4Data {
	int _ref_count_;
	Block3Data * _data3_;
	gint rows;
};

struct _Block3Data {
	int _ref_count_;
	RygelMediaDB * self;
	gint old_version;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
	RygelMediaContainer* parent_ref;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* author;
	char* album;
	char* date;
	char* upnp_class;
	char* mime_type;
	char* dlna_profile;
	glong size;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint n_audio_channels;
	gint track_number;
	gint width;
	gint height;
	gint pixel_width;
	gint pixel_height;
	gint color_depth;
	GeeArrayList* thumbnails;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*should_stream) (RygelMediaItem* self);
};

struct _Block5Data {
	int _ref_count_;
	RygelMediaDB * self;
	RygelMediaObject* obj;
};

struct _Block6Data {
	int _ref_count_;
	RygelMediaDB * self;
	RygelMediaObject* parent;
};

struct _Block7Data {
	int _ref_count_;
	RygelMediaDB * self;
	GeeArrayList* children;
};

struct _Block8Data {
	int _ref_count_;
	RygelMediaDB * self;
	gint count;
};

struct _Block9Data {
	int _ref_count_;
	RygelMediaDB * self;
	gboolean exists;
	gint64 tmp_timestamp;
};

struct _Block10Data {
	int _ref_count_;
	RygelMediaDB * self;
	RygelMediaContainer* parent;
	GeeArrayList* children;
};


static gpointer rygel_media_db_parent_class = NULL;

GQuark rygel_media_db_error_quark (void);
GType rygel_media_db_object_type_get_type (void);
GType rygel_media_db_get_type (void);
GType rygel_database_get_type (void);
GType rygel_media_db_object_factory_get_type (void);
#define RYGEL_MEDIA_DB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_DB, RygelMediaDBPrivate))
enum  {
	RYGEL_MEDIA_DB_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_DB_schema_version "5"
#define RYGEL_MEDIA_DB_SCHEMA_STRING "CREATE TABLE schema_info (version TEXT NOT NULL); " "CREATE TABLE object_type (id INTEGER PRIMARY KEY, " "desc TEXT NOT NULL);" "CREATE TABLE meta_data (size INTEGER NOT NULL, " "mime_type TEXT NOT NULL, " "duration INTEGER, " "width INTEGER, " "height INTEGER, " "class TEXT NOT NULL, " "author TEXT, " "album TEXT, " "date TEXT, " "bitrate INTEGER, " "sample_freq INTEGER, " "bits_per_sample INTEGER, " "channels INTEGER, " "track INTEGER, " "color_depth INTEGER, " "object_fk TEXT UNIQUE CONSTRAINT " "object_fk_id REFERENCES Object(upnp_id) " "ON DELETE CASCADE);" "CREATE TABLE object (parent TEXT CONSTRAINT parent_fk_id " "REFERENCES Object(upnp_id), " "upnp_id TEXT PRIMARY KEY, " "type_fk INTEGER CONSTRAINT type_fk_id " "REFERENCES Object_Type(id), " "title TEXT NOT NULL, " "timestamp INTEGER NOT NULL);" "CREATE TABLE uri (object_fk TEXT " "CONSTRAINT object_fk_id REFERENCES Object(upnp_id) " "ON DELETE CASCADE, " "uri TEXT NOT NULL);" "INSERT INTO object_type (id, desc) VALUES (0, 'Container'); " "INSERT INTO object_type (id, desc) VALUES (1, 'Item'); " "INSERT INTO schema_info (version) VALUES ('" RYGEL_MEDIA_DB_schema_version "'); "
#define RYGEL_MEDIA_DB_CREATE_CLOSURE_TABLE "CREATE TABLE closure (ancestor TEXT, descendant TEXT, depth INTEGER)"
#define RYGEL_MEDIA_DB_CREATE_CLOSURE_TRIGGER_STRING "CREATE TRIGGER trgr_update_closure " "AFTER INSERT ON Object " "FOR EACH ROW BEGIN " "INSERT INTO Closure (ancestor, descendant, depth) " "VALUES (NEW.upnp_id, NEW.upnp_id, 0); " "INSERT INTO Closure (ancestor, descendant, depth) " "SELECT ancestor, NEW.upnp_id, depth + 1 FROM Closure " "WHERE descendant = NEW.parent;" "END;" "CREATE TRIGGER trgr_delete_closure " "AFTER DELETE ON Object " "FOR EACH ROW BEGIN " "DELETE FROM Closure WHERE descendant = OLD.upnp_id;" "END;"
#define RYGEL_MEDIA_DB_CREATE_TRIGGER_STRING "CREATE TRIGGER trgr_delete_metadata " "BEFORE DELETE ON Object " "FOR EACH ROW BEGIN " "DELETE FROM meta_data WHERE meta_data.object_fk = OLD.upnp_id; " "END;" "CREATE TRIGGER trgr_delete_uris " "BEFORE DELETE ON Object " "FOR EACH ROW BEGIN " "DELETE FROM Uri WHERE Uri.object_fk = OLD.upnp_id;" "END;"
#define RYGEL_MEDIA_DB_CREATE_INDICES_STRING "CREATE INDEX idx_parent on Object(parent);" "CREATE INDEX idx_uri_fk on Uri(object_fk);" "CREATE INDEX idx_meta_data_fk on meta_data(object_fk);" "CREATE INDEX idx_closure on Closure(descendant,depth);"
#define RYGEL_MEDIA_DB_INSERT_META_DATA_STRING "INSERT INTO meta_data " "(size, mime_type, width, height, class, " "author, album, date, bitrate, " "sample_freq, bits_per_sample, channels, " "track, color_depth, duration, object_fk) VALUES " "(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"
#define RYGEL_MEDIA_DB_UPDATE_META_DATA_STRING "UPDATE meta_data SET " "size = ?, mime_type = ?, width = ?, height = ?, class = ?, " "author = ?, album = ?, date = ?, bitrate = ?, " "sample_freq = ?, bits_per_sample = ?, channels = ?, " "track = ?, color_depth = ?, duration = ? " "WHERE object_fk = ?"
#define RYGEL_MEDIA_DB_INSERT_OBJECT_STRING "INSERT INTO Object (upnp_id, title, type_fk, parent, timestamp) " "VALUES (?,?,?,?,?)"
#define RYGEL_MEDIA_DB_UPDATE_OBJECT_STRING "UPDATE Object SET title = ?, timestamp = ? WHERE upnp_id = ?"
#define RYGEL_MEDIA_DB_INSERT_URI_STRING "INSERT INTO Uri (object_fk, uri) VALUES (?,?)"
#define RYGEL_MEDIA_DB_DELETE_URI_STRING "DELETE FROM Uri WHERE object_fk = ?"
#define RYGEL_MEDIA_DB_DELETE_BY_ID_STRING "DELETE FROM Object WHERE upnp_id = " "(SELECT descendant FROM closure WHERE ancestor = ?)"
#define RYGEL_MEDIA_DB_GET_OBJECT_WITH_CLOSURE "SELECT o.type_fk, o.title, m.size, m.mime_type, m.width, m.height, " "m.class, m.author, m.album, m.date, m.bitrate, m.sample_freq, " "m.bits_per_sample, m.channels, m.track, m.color_depth, " "m.duration, o.parent, o.upnp_id " "FROM Object o " "JOIN Closure c ON (o.upnp_id = c.ancestor) " "LEFT OUTER JOIN meta_data m ON (o.upnp_id = m.object_fk) " "WHERE c.descendant = ? ORDER BY c.depth DESC"
#define RYGEL_MEDIA_DB_GET_CHILDREN_STRING "SELECT o.type_fk, o.title, m.size, m.mime_type, " "m.width, m.height, m.class, m.author, m.album, " "m.date, m.bitrate, m.sample_freq, m.bits_per_sample, " "m.channels, m.track, m.color_depth, m.duration, " "o.upnp_id, o.parent, o.timestamp " "FROM Object o LEFT OUTER JOIN meta_data m " "ON o.upnp_id = m.object_fk " "WHERE o.parent = ? " "ORDER BY o.type_fk ASC, " "m.class ASC, " "m.track ASC, " "o.title ASC " "LIMIT ?,?"
#define RYGEL_MEDIA_DB_URI_GET_STRING "SELECT uri FROM Uri WHERE Uri.object_fk = ?"
#define RYGEL_MEDIA_DB_CHILDREN_COUNT_STRING "SELECT COUNT(upnp_id) FROM Object WHERE Object.parent = ?"
#define RYGEL_MEDIA_DB_OBJECT_EXISTS_STRING "SELECT COUNT(upnp_id), timestamp FROM Object WHERE Object.upnp_id = ?"
#define RYGEL_MEDIA_DB_OBJECT_DELETE_STRING "DELETE FROM Object WHERE Object.upnp_id = ?"
#define RYGEL_MEDIA_DB_GET_CHILD_ID_STRING "SELECT upnp_id FROM OBJECT WHERE parent = ?"
#define RYGEL_MEDIA_DB_UPDATE_V3_V4_STRING_1 "ALTER TABLE meta_data ADD object_fk TEXT"
#define RYGEL_MEDIA_DB_UPDATE_V3_V4_STRING_2 "UPDATE meta_data SET object_fk = " "(SELECT upnp_id FROM Object WHERE metadata_fk = meta_data.id)"
#define RYGEL_MEDIA_DB_UPDATE_V3_V4_STRING_3 "ALTER TABLE Object ADD timestamp INTEGER"
#define RYGEL_MEDIA_DB_UPDATE_V3_V4_STRING_4 "UPDATE Object SET timestamp = 0"
GQuark rygel_database_error_quark (void);
void rygel_database_begin (RygelDatabase* self, GError** error);
gint rygel_database_exec (RygelDatabase* self, const char* sql, GValue* values, int values_length1, RygelDatabaseRowCallback callback, void* callback_target, GError** error);
void rygel_database_commit (RygelDatabase* self, GError** error);
void rygel_database_rollback (RygelDatabase* self);
static void rygel_media_db_update_v3_v4 (RygelMediaDB* self);
void rygel_database_analyze (RygelDatabase* self);
static void rygel_media_db_update_v4_v5 (RygelMediaDB* self);
RygelDatabase* rygel_database_new (const char* name);
RygelDatabase* rygel_database_construct (GType object_type, const char* name);
static gboolean _lambda8_ (sqlite3_stmt* stmt, Block3Data* _data3_);
static gboolean __lambda8__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static gboolean _lambda9_ (sqlite3_stmt* stmt, Block4Data* _data4_);
static gboolean __lambda9__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static gboolean rygel_media_db_create_schema (RygelMediaDB* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void rygel_media_db_open_db (RygelMediaDB* self, const char* name);
static RygelMediaDB* rygel_media_db_new (const char* name, RygelMediaDBObjectFactory* factory);
static RygelMediaDB* rygel_media_db_construct (GType object_type, const char* name, RygelMediaDBObjectFactory* factory);
RygelMediaDBObjectFactory* rygel_media_db_object_factory_new (void);
RygelMediaDBObjectFactory* rygel_media_db_object_factory_construct (GType object_type);
RygelMediaDB* rygel_media_db_create (const char* name, GError** error);
RygelMediaDB* rygel_media_db_create_with_factory (const char* name, RygelMediaDBObjectFactory* factory, GError** error);
static void _vala_GValue_array_free (GValue* array, gint array_length);
void rygel_media_db_remove_by_id (RygelMediaDB* self, const char* id, GError** error);
GType rygel_media_object_get_type (void);
GType rygel_media_container_get_type (void);
GType rygel_media_item_get_type (void);
void rygel_media_db_remove_object (RygelMediaDB* self, RygelMediaObject* obj, GError** error);
void rygel_media_db_save_item (RygelMediaDB* self, RygelMediaItem* item, GError** error);
void rygel_media_db_save_container (RygelMediaDB* self, RygelMediaContainer* container, GError** error);
void rygel_media_db_save_object (RygelMediaDB* self, RygelMediaObject* obj, GError** error);
static void rygel_media_db_create_object (RygelMediaDB* self, RygelMediaObject* item, GError** error);
static void rygel_media_db_save_uris (RygelMediaDB* self, RygelMediaObject* obj, GError** error);
static void rygel_media_db_save_metadata (RygelMediaDB* self, RygelMediaItem* item, const char* sql, GError** error);
static void rygel_media_db_remove_uris (RygelMediaDB* self, RygelMediaObject* obj, GError** error);
static void rygel_media_db_update_object_internal (RygelMediaDB* self, RygelMediaObject* obj, GError** error);
void rygel_media_db_update_object (RygelMediaDB* self, RygelMediaObject* obj, GError** error);
const char* rygel_media_object_get_title (RygelMediaObject* self);
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void);
GType rygel_thumbnail_get_type (void);
void rygel_database_null (GValue* result);
void rygel_media_item_add_uri (RygelMediaItem* self, const char* uri, RygelThumbnail* thumbnail);
static gboolean _lambda6_ (sqlite3_stmt* stmt, Block5Data* _data5_);
static gboolean __lambda6__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static void rygel_media_db_add_uris (RygelMediaDB* self, RygelMediaObject* obj, GError** error);
RygelMediaContainer* rygel_media_db_object_factory_get_container (RygelMediaDBObjectFactory* self, RygelMediaDB* media_db, const char* id, const char* title, guint child_count);
RygelMediaItem* rygel_media_db_object_factory_get_item (RygelMediaDBObjectFactory* self, RygelMediaDB* media_db, RygelMediaContainer* parent, const char* id, const char* title, const char* upnp_class);
static void rygel_media_db_fill_item (RygelMediaDB* self, sqlite3_stmt* statement, RygelMediaItem* item);
static RygelMediaObject* rygel_media_db_get_object_from_statement (RygelMediaDB* self, RygelMediaContainer* parent, const char* object_id, sqlite3_stmt* statement);
static gboolean _lambda5_ (sqlite3_stmt* stmt, Block6Data* _data6_);
static gboolean __lambda5__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
RygelMediaObject* rygel_media_db_get_object (RygelMediaDB* self, const char* object_id, GError** error);
RygelMediaItem* rygel_media_db_get_item (RygelMediaDB* self, const char* item_id, GError** error);
RygelMediaContainer* rygel_media_db_get_container (RygelMediaDB* self, const char* container_id, GError** error);
static gboolean _lambda10_ (sqlite3_stmt* stmt, Block7Data* _data7_);
static gboolean __lambda10__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
GeeArrayList* rygel_media_db_get_child_ids (RygelMediaDB* self, const char* container_id, GError** error);
static gboolean _lambda4_ (sqlite3_stmt* stmt, Block8Data* _data8_);
static gboolean __lambda4__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
gint rygel_media_db_get_child_count (RygelMediaDB* self, const char* container_id, GError** error);
static gboolean _lambda11_ (sqlite3_stmt* stmt, Block9Data* _data9_);
static gboolean __lambda11__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (Block9Data* _data9_);
gboolean rygel_media_db_exists (RygelMediaDB* self, const char* object_id, gint64* timestamp, GError** error);
static gboolean _lambda7_ (sqlite3_stmt* stmt, Block10Data* _data10_);
static gboolean __lambda7__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
GeeArrayList* rygel_media_db_get_children (RygelMediaDB* self, const char* container_id, glong offset, glong max_count, GError** error);
static void rygel_media_db_finalize (GObject* obj);



GQuark rygel_media_db_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_db_error-quark");
}



GType rygel_media_db_object_type_get_type (void) {
	static GType rygel_media_db_object_type_type_id = 0;
	if (G_UNLIKELY (rygel_media_db_object_type_type_id == 0)) {
		static const GEnumValue values[] = {{RYGEL_MEDIA_DB_OBJECT_TYPE_CONTAINER, "RYGEL_MEDIA_DB_OBJECT_TYPE_CONTAINER", "container"}, {RYGEL_MEDIA_DB_OBJECT_TYPE_ITEM, "RYGEL_MEDIA_DB_OBJECT_TYPE_ITEM", "item"}, {0, NULL, NULL}};
		rygel_media_db_object_type_type_id = g_enum_register_static ("RygelMediaDBObjectType", values);
	}
	return rygel_media_db_object_type_type_id;
}


static void rygel_media_db_update_v3_v4 (RygelMediaDB* self) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		rygel_database_begin (self->priv->db, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch43_rygel_database_error;
			}
			goto __finally43;
		}
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_UPDATE_V3_V4_STRING_1, NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch43_rygel_database_error;
			}
			goto __finally43;
		}
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_UPDATE_V3_V4_STRING_2, NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch43_rygel_database_error;
			}
			goto __finally43;
		}
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_UPDATE_V3_V4_STRING_3, NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch43_rygel_database_error;
			}
			goto __finally43;
		}
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_UPDATE_V3_V4_STRING_4, NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch43_rygel_database_error;
			}
			goto __finally43;
		}
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_CREATE_TRIGGER_STRING, NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch43_rygel_database_error;
			}
			goto __finally43;
		}
		rygel_database_exec (self->priv->db, "UPDATE schema_info SET version = '4'", NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch43_rygel_database_error;
			}
			goto __finally43;
		}
		rygel_database_commit (self->priv->db, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch43_rygel_database_error;
			}
			goto __finally43;
		}
	}
	goto __finally43;
	__catch43_rygel_database_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			RygelDatabase* _tmp0_;
			rygel_database_rollback (self->priv->db);
			g_warning ("rygel-media-db.vala:233: Database upgrade failed: %s", err->message);
			self->priv->db = (_tmp0_ = NULL, _g_object_unref0 (self->priv->db), _tmp0_);
			_g_error_free0 (err);
		}
	}
	__finally43:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_db_update_v4_v5 (RygelMediaDB* self) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		rygel_database_begin (self->priv->db, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch44_rygel_database_error;
			}
			goto __finally44;
		}
		rygel_database_exec (self->priv->db, "DROP TRIGGER IF EXISTS trgr_delete_children", NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch44_rygel_database_error;
			}
			goto __finally44;
		}
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_CREATE_CLOSURE_TABLE, NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch44_rygel_database_error;
			}
			goto __finally44;
		}
		rygel_database_exec (self->priv->db, "ALTER TABLE Object RENAME TO _Object", NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch44_rygel_database_error;
			}
			goto __finally44;
		}
		rygel_database_exec (self->priv->db, "CREATE TABLE Object AS SELECT * FROM _Object", NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch44_rygel_database_error;
			}
			goto __finally44;
		}
		rygel_database_exec (self->priv->db, "DELETE FROM Object", NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch44_rygel_database_error;
			}
			goto __finally44;
		}
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_CREATE_CLOSURE_TRIGGER_STRING, NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch44_rygel_database_error;
			}
			goto __finally44;
		}
		rygel_database_exec (self->priv->db, "INSERT INTO Object SELECT * FROM _Object", NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch44_rygel_database_error;
			}
			goto __finally44;
		}
		rygel_database_exec (self->priv->db, "DROP TABLE Object", NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch44_rygel_database_error;
			}
			goto __finally44;
		}
		rygel_database_exec (self->priv->db, "ALTER TABLE _Object RENAME TO Object", NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch44_rygel_database_error;
			}
			goto __finally44;
		}
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_CREATE_CLOSURE_TRIGGER_STRING, NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch44_rygel_database_error;
			}
			goto __finally44;
		}
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_CREATE_INDICES_STRING, NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch44_rygel_database_error;
			}
			goto __finally44;
		}
		rygel_database_exec (self->priv->db, "UPDATE schema_info SET version = '5'", NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch44_rygel_database_error;
			}
			goto __finally44;
		}
		rygel_database_commit (self->priv->db, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch44_rygel_database_error;
			}
			goto __finally44;
		}
		rygel_database_exec (self->priv->db, "VACUUM", NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch44_rygel_database_error;
			}
			goto __finally44;
		}
		rygel_database_analyze (self->priv->db);
	}
	goto __finally44;
	__catch44_rygel_database_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			RygelDatabase* _tmp0_;
			rygel_database_rollback (self->priv->db);
			g_warning ("rygel-media-db.vala:261: Database upgrade failed: %s", err->message);
			self->priv->db = (_tmp0_ = NULL, _g_object_unref0 (self->priv->db), _tmp0_);
			_g_error_free0 (err);
		}
	}
	__finally44:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gboolean _lambda8_ (sqlite3_stmt* stmt, Block3Data* _data3_) {
	RygelMediaDB * self;
	gboolean result;
	self = _data3_->self;
	g_return_val_if_fail (stmt != NULL, FALSE);
	_data3_->old_version = sqlite3_column_int (stmt, 0);
	result = FALSE;
	return result;
}


static gboolean __lambda8__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	return _lambda8_ (stmt, self);
}


static gboolean _lambda9_ (sqlite3_stmt* stmt, Block4Data* _data4_) {
	Block3Data* _data3_;
	RygelMediaDB * self;
	gboolean result;
	_data3_ = _data4_->_data3_;
	self = _data3_->self;
	g_return_val_if_fail (stmt != NULL, FALSE);
	_data4_->rows = sqlite3_column_int (stmt, 0);
}


static gboolean __lambda9__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	return _lambda9_ (stmt, self);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	++_data4_->_ref_count_;
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if ((--_data4_->_ref_count_) == 0) {
		block3_data_unref (_data4_->_data3_);
		g_slice_free (Block4Data, _data4_);
	}
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	++_data3_->_ref_count_;
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if ((--_data3_->_ref_count_) == 0) {
		_g_object_unref0 (_data3_->self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void rygel_media_db_open_db (RygelMediaDB* self, const char* name) {
	GError * _inner_error_;
	Block3Data* _data3_;
	RygelDatabase* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_inner_error_ = NULL;
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	self->priv->db = (_tmp0_ = rygel_database_new (name), _g_object_unref0 (self->priv->db), _tmp0_);
	_data3_->old_version = -1;
	{
		gint current_version;
		rygel_database_exec (self->priv->db, "SELECT version FROM schema_info", NULL, 0, __lambda8__rygel_database_row_callback, _data3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch45_rygel_database_error;
			}
			goto __finally45;
		}
		current_version = atoi (RYGEL_MEDIA_DB_schema_version);
		if (_data3_->old_version == current_version) {
			g_debug ("rygel-media-db.vala:279: Media DB schema has current version");
		} else {
			if (_data3_->old_version < current_version) {
				g_debug ("rygel-media-db.vala:282: Older schema detected. Upgrading...");
				switch (_data3_->old_version) {
					case 3:
					{
						rygel_media_db_update_v3_v4 (self);
						break;
					}
					case 4:
					{
						rygel_media_db_update_v4_v5 (self);
						break;
					}
					default:
					{
						RygelDatabase* _tmp1_;
						g_warning ("rygel-media-db.vala:291: Cannot upgrade");
						self->priv->db = (_tmp1_ = NULL, _g_object_unref0 (self->priv->db), _tmp1_);
						break;
					}
				}
			} else {
				RygelDatabase* _tmp2_;
				g_warning ("The version \"%d\" of the detected database" " is newer than our supported version \"%d\"", _data3_->old_version, current_version);
				self->priv->db = (_tmp2_ = NULL, _g_object_unref0 (self->priv->db), _tmp2_);
			}
		}
	}
	goto __finally45;
	__catch45_rygel_database_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_debug ("rygel-media-db.vala:303: Could not find schema version; checking for empty database...");
			{
				Block4Data* _data4_;
				_data4_ = g_slice_new0 (Block4Data);
				_data4_->_ref_count_ = 1;
				_data4_->_data3_ = block3_data_ref (_data3_);
				_data4_->rows = -1;
				rygel_database_exec (self->priv->db, "SELECT count(type) FROM sqlite_master " "WHERE rowid=1", NULL, 0, __lambda9__rygel_database_row_callback, _data4_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
						goto __catch46_rygel_database_error;
					}
					goto __finally46;
				}
				if (_data4_->rows == 0) {
					g_debug ("rygel-media-db.vala:313: Empty database, creating new schema version %s", RYGEL_MEDIA_DB_schema_version);
					if (!rygel_media_db_create_schema (self)) {
						RygelDatabase* _tmp3_;
						self->priv->db = (_tmp3_ = NULL, _g_object_unref0 (self->priv->db), _tmp3_);
						block4_data_unref (_data4_);
						_g_error_free0 (err);
						block3_data_unref (_data3_);
						return;
					}
				} else {
					RygelDatabase* _tmp4_;
					g_warning ("rygel-media-db.vala:320: Incompatible schema... cannot proceed");
					self->priv->db = (_tmp4_ = NULL, _g_object_unref0 (self->priv->db), _tmp4_);
					block4_data_unref (_data4_);
					_g_error_free0 (err);
					block3_data_unref (_data3_);
					return;
				}
				block4_data_unref (_data4_);
			}
			goto __finally46;
			__catch46_rygel_database_error:
			{
				GError * err2;
				err2 = _inner_error_;
				_inner_error_ = NULL;
				{
					RygelDatabase* _tmp5_;
					g_warning ("rygel-media-db.vala:325: Something weird going on: %s", err2->message);
					self->priv->db = (_tmp5_ = NULL, _g_object_unref0 (self->priv->db), _tmp5_);
					_g_error_free0 (err2);
				}
			}
			__finally46:
			if (_inner_error_ != NULL) {
				_g_error_free0 (err);
				goto __finally45;
			}
			_g_error_free0 (err);
		}
	}
	__finally45:
	if (_inner_error_ != NULL) {
		block3_data_unref (_data3_);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	block3_data_unref (_data3_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static RygelMediaDB* rygel_media_db_construct (GType object_type, const char* name, RygelMediaDBObjectFactory* factory) {
	RygelMediaDB * self;
	RygelMediaDBObjectFactory* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (factory != NULL, NULL);
	self = (RygelMediaDB*) g_object_new (object_type, NULL);
	rygel_media_db_open_db (self, name);
	self->priv->factory = (_tmp0_ = _g_object_ref0 (factory), _g_object_unref0 (self->priv->factory), _tmp0_);
	return self;
}


static RygelMediaDB* rygel_media_db_new (const char* name, RygelMediaDBObjectFactory* factory) {
	return rygel_media_db_construct (RYGEL_TYPE_MEDIA_DB, name, factory);
}


RygelMediaDB* rygel_media_db_create (const char* name, GError** error) {
	RygelMediaDB* result;
	GError * _inner_error_;
	RygelMediaDBObjectFactory* _tmp0_;
	RygelMediaDB* _tmp1_;
	RygelMediaDB* instance;
	g_return_val_if_fail (name != NULL, NULL);
	_inner_error_ = NULL;
	instance = (_tmp1_ = rygel_media_db_new (name, _tmp0_ = rygel_media_db_object_factory_new ()), _g_object_unref0 (_tmp0_), _tmp1_);
	if (instance->priv->db != NULL) {
		result = instance;
		return result;
	}
	_inner_error_ = g_error_new_literal (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_GENERAL_ERROR, "Invalid database");
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (instance);
			return NULL;
		} else {
			_g_object_unref0 (instance);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (instance);
}


RygelMediaDB* rygel_media_db_create_with_factory (const char* name, RygelMediaDBObjectFactory* factory, GError** error) {
	RygelMediaDB* result;
	GError * _inner_error_;
	RygelMediaDB* instance;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (factory != NULL, NULL);
	_inner_error_ = NULL;
	instance = rygel_media_db_new (name, factory);
	if (instance->priv->db != NULL) {
		result = instance;
		return result;
	}
	_inner_error_ = g_error_new_literal (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_GENERAL_ERROR, "Invalid database");
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (instance);
			return NULL;
		} else {
			_g_object_unref0 (instance);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (instance);
}


static void _vala_GValue_array_free (GValue* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}


void rygel_media_db_remove_by_id (RygelMediaDB* self, const char* id, GError** error) {
	GError * _inner_error_;
	GValue* _tmp2_;
	gint values_size;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_inner_error_ = NULL;
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, id), _tmp0_), _tmp1_), values_length1 = 1, values_size = values_length1, _tmp2_);
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_DELETE_BY_ID_STRING, values, values_length1, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			return;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_signal_emit_by_name (self, "object-removed", id);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


void rygel_media_db_remove_object (RygelMediaDB* self, RygelMediaObject* obj, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_inner_error_ = NULL;
	rygel_media_db_remove_by_id (self, obj->id, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (RYGEL_IS_MEDIA_ITEM (obj)) {
		g_signal_emit_by_name (self, "item-removed", obj->id);
	} else {
		if (RYGEL_IS_MEDIA_CONTAINER (obj)) {
			g_signal_emit_by_name (self, "container-removed", obj->id);
		} else {
			_inner_error_ = g_error_new_literal (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_INVALID_TYPE, "Invalid object type");
			if (_inner_error_ != NULL) {
				if ((_inner_error_->domain == RYGEL_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


void rygel_media_db_save_object (RygelMediaDB* self, RygelMediaObject* obj, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_inner_error_ = NULL;
	if (RYGEL_IS_MEDIA_ITEM (obj)) {
		rygel_media_db_save_item (self, RYGEL_MEDIA_ITEM (obj), &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	} else {
		if (RYGEL_IS_MEDIA_CONTAINER (obj)) {
			rygel_media_db_save_container (self, RYGEL_MEDIA_CONTAINER (obj), &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				return;
			}
		} else {
			_inner_error_ = g_error_new_literal (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_INVALID_TYPE, "Invalid object type");
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				return;
			}
		}
	}
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


void rygel_media_db_save_container (RygelMediaDB* self, RygelMediaContainer* container, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	_inner_error_ = NULL;
	{
		rygel_database_begin (self->priv->db, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch47_rygel_database_error;
			}
			goto __finally47;
		}
		rygel_media_db_create_object (self, (RygelMediaObject*) container, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch47_rygel_database_error;
			}
			goto __finally47;
		}
		rygel_media_db_save_uris (self, (RygelMediaObject*) container, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch47_rygel_database_error;
			}
			goto __finally47;
		}
		rygel_database_commit (self->priv->db, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch47_rygel_database_error;
			}
			goto __finally47;
		}
		g_signal_emit_by_name (self, "object-added", ((RygelMediaObject*) container)->id);
		g_signal_emit_by_name (self, "container-added", ((RygelMediaObject*) container)->id);
	}
	goto __finally47;
	__catch47_rygel_database_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			rygel_database_rollback (self->priv->db);
			_inner_error_ = _g_error_copy0 (err);
			if (_inner_error_ != NULL) {
				_g_error_free0 (err);
				goto __finally47;
			}
			_g_error_free0 (err);
		}
	}
	__finally47:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void rygel_media_db_save_item (RygelMediaDB* self, RygelMediaItem* item, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_inner_error_ = NULL;
	{
		rygel_database_begin (self->priv->db, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch48_rygel_database_error;
			}
			goto __finally48;
		}
		rygel_media_db_save_metadata (self, item, RYGEL_MEDIA_DB_INSERT_META_DATA_STRING, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch48_rygel_database_error;
			}
			goto __finally48;
		}
		rygel_media_db_create_object (self, (RygelMediaObject*) item, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch48_rygel_database_error;
			}
			goto __finally48;
		}
		rygel_media_db_save_uris (self, (RygelMediaObject*) item, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch48_rygel_database_error;
			}
			goto __finally48;
		}
		rygel_database_commit (self->priv->db, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch48_rygel_database_error;
			}
			goto __finally48;
		}
		g_signal_emit_by_name (self, "object-added", ((RygelMediaObject*) item)->id);
		g_signal_emit_by_name (self, "item-added", ((RygelMediaObject*) item)->id);
	}
	goto __finally48;
	__catch48_rygel_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("rygel-media-db.vala:419: Failed to add item with id %s: %s", ((RygelMediaObject*) item)->id, _error_->message);
			rygel_database_rollback (self->priv->db);
			_inner_error_ = _g_error_copy0 (_error_);
			if (_inner_error_ != NULL) {
				_g_error_free0 (_error_);
				goto __finally48;
			}
			_g_error_free0 (_error_);
		}
	}
	__finally48:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void rygel_media_db_update_object (RygelMediaDB* self, RygelMediaObject* obj, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_inner_error_ = NULL;
	{
		rygel_database_begin (self->priv->db, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch49_g_error;
			goto __finally49;
		}
		rygel_media_db_remove_uris (self, obj, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch49_g_error;
			goto __finally49;
		}
		if (RYGEL_IS_MEDIA_ITEM (obj)) {
			rygel_media_db_save_metadata (self, RYGEL_MEDIA_ITEM (obj), RYGEL_MEDIA_DB_UPDATE_META_DATA_STRING, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch49_g_error;
				goto __finally49;
			}
		}
		rygel_media_db_update_object_internal (self, obj, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch49_g_error;
			goto __finally49;
		}
		rygel_media_db_save_uris (self, obj, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch49_g_error;
			goto __finally49;
		}
		rygel_database_commit (self->priv->db, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch49_g_error;
			goto __finally49;
		}
		g_signal_emit_by_name (self, "object-updated", obj->id);
		if (RYGEL_IS_MEDIA_ITEM (obj)) {
			g_signal_emit_by_name (self, "item-updated", obj->id);
		} else {
			if (RYGEL_IS_MEDIA_CONTAINER (obj)) {
				g_signal_emit_by_name (self, "container-updated", obj->id);
			}
		}
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("rygel-media-db.vala:444: Failed to add item with id %s: %s", obj->id, _error_->message);
			rygel_database_rollback (self->priv->db);
			_inner_error_ = _g_error_copy0 (_error_);
			if (_inner_error_ != NULL) {
				_g_error_free0 (_error_);
				goto __finally49;
			}
			_g_error_free0 (_error_);
		}
	}
	__finally49:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void rygel_media_db_update_object_internal (RygelMediaDB* self, RygelMediaObject* obj, GError** error) {
	GError * _inner_error_;
	GValue* _tmp4_;
	gint values_size;
	gint values_length1;
	GValue* _tmp3_ = NULL;
	GValue _tmp2_ = {0};
	GValue _tmp1_ = {0};
	GValue _tmp0_ = {0};
	GValue* values;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_inner_error_ = NULL;
	values = (_tmp4_ = (_tmp3_ = g_new0 (GValue, 3), _tmp3_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, rygel_media_object_get_title (obj)), _tmp0_), _tmp3_[1] = (g_value_init (&_tmp1_, G_TYPE_INT64), g_value_set_int64 (&_tmp1_, (gint64) obj->modified), _tmp1_), _tmp3_[2] = (g_value_init (&_tmp2_, G_TYPE_STRING), g_value_set_string (&_tmp2_, obj->id), _tmp2_), _tmp3_), values_length1 = 3, values_size = values_length1, _tmp4_);
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_UPDATE_OBJECT_STRING, values, values_length1, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


static void rygel_media_db_remove_uris (RygelMediaDB* self, RygelMediaObject* obj, GError** error) {
	GError * _inner_error_;
	GValue* _tmp2_;
	gint values_size;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_inner_error_ = NULL;
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, obj->id), _tmp0_), _tmp1_), values_length1 = 1, values_size = values_length1, _tmp2_);
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_DELETE_URI_STRING, values, values_length1, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


static void rygel_media_db_save_metadata (RygelMediaDB* self, RygelMediaItem* item, const char* sql, GError** error) {
	GError * _inner_error_;
	GValue* _tmp17_;
	gint values_size;
	gint values_length1;
	GValue* _tmp16_ = NULL;
	GValue _tmp15_ = {0};
	GValue _tmp14_ = {0};
	GValue _tmp13_ = {0};
	GValue _tmp12_ = {0};
	GValue _tmp11_ = {0};
	GValue _tmp10_ = {0};
	GValue _tmp9_ = {0};
	GValue _tmp8_ = {0};
	GValue _tmp7_ = {0};
	GValue _tmp6_ = {0};
	GValue _tmp5_ = {0};
	GValue _tmp4_ = {0};
	GValue _tmp3_ = {0};
	GValue _tmp2_ = {0};
	GValue _tmp1_ = {0};
	GValue _tmp0_ = {0};
	GValue* values;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	values = (_tmp17_ = (_tmp16_ = g_new0 (GValue, 16), _tmp16_[0] = (g_value_init (&_tmp0_, G_TYPE_LONG), g_value_set_long (&_tmp0_, item->size), _tmp0_), _tmp16_[1] = (g_value_init (&_tmp1_, G_TYPE_STRING), g_value_set_string (&_tmp1_, item->mime_type), _tmp1_), _tmp16_[2] = (g_value_init (&_tmp2_, G_TYPE_INT), g_value_set_int (&_tmp2_, item->width), _tmp2_), _tmp16_[3] = (g_value_init (&_tmp3_, G_TYPE_INT), g_value_set_int (&_tmp3_, item->height), _tmp3_), _tmp16_[4] = (g_value_init (&_tmp4_, G_TYPE_STRING), g_value_set_string (&_tmp4_, item->upnp_class), _tmp4_), _tmp16_[5] = (g_value_init (&_tmp5_, G_TYPE_STRING), g_value_set_string (&_tmp5_, item->author), _tmp5_), _tmp16_[6] = (g_value_init (&_tmp6_, G_TYPE_STRING), g_value_set_string (&_tmp6_, item->album), _tmp6_), _tmp16_[7] = (g_value_init (&_tmp7_, G_TYPE_STRING), g_value_set_string (&_tmp7_, item->date), _tmp7_), _tmp16_[8] = (g_value_init (&_tmp8_, G_TYPE_INT), g_value_set_int (&_tmp8_, item->bitrate), _tmp8_), _tmp16_[9] = (g_value_init (&_tmp9_, G_TYPE_INT), g_value_set_int (&_tmp9_, item->sample_freq), _tmp9_), _tmp16_[10] = (g_value_init (&_tmp10_, G_TYPE_INT), g_value_set_int (&_tmp10_, item->bits_per_sample), _tmp10_), _tmp16_[11] = (g_value_init (&_tmp11_, G_TYPE_INT), g_value_set_int (&_tmp11_, item->n_audio_channels), _tmp11_), _tmp16_[12] = (g_value_init (&_tmp12_, G_TYPE_INT), g_value_set_int (&_tmp12_, item->track_number), _tmp12_), _tmp16_[13] = (g_value_init (&_tmp13_, G_TYPE_INT), g_value_set_int (&_tmp13_, item->color_depth), _tmp13_), _tmp16_[14] = (g_value_init (&_tmp14_, G_TYPE_LONG), g_value_set_long (&_tmp14_, item->duration), _tmp14_), _tmp16_[15] = (g_value_init (&_tmp15_, G_TYPE_STRING), g_value_set_string (&_tmp15_, ((RygelMediaObject*) item)->id), _tmp15_), _tmp16_), values_length1 = 16, values_size = values_length1, _tmp17_);
	rygel_database_exec (self->priv->db, sql, values, values_length1, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


static void rygel_media_db_create_object (RygelMediaDB* self, RygelMediaObject* item, GError** error) {
	GError * _inner_error_;
	gint _tmp0_ = 0;
	GValue _tmp1_ = {0};
	GValue* _tmp12_;
	gint values_size;
	gint values_length1;
	GValue* _tmp11_ = NULL;
	GValue _tmp10_ = {0};
	GValue _tmp9_ = {0};
	GValue _tmp8_ = {0};
	GValue _tmp7_ = {0};
	GValue _tmp6_ = {0};
	GValue* values;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_inner_error_ = NULL;
	if (RYGEL_IS_MEDIA_ITEM (item)) {
		_tmp0_ = (gint) RYGEL_MEDIA_DB_OBJECT_TYPE_ITEM;
	} else {
		_tmp0_ = (gint) RYGEL_MEDIA_DB_OBJECT_TYPE_CONTAINER;
	}
	if (item->parent == NULL) {
		GValue _tmp3_;
		GValue _tmp2_ = {0};
		_tmp1_ = (_tmp3_ = (rygel_database_null (&_tmp2_), _tmp2_), G_IS_VALUE (&_tmp1_) ? (g_value_unset (&_tmp1_), NULL) : NULL, _tmp3_);
	} else {
		GValue _tmp5_;
		GValue _tmp4_ = {0};
		_tmp1_ = (_tmp5_ = (g_value_init (&_tmp4_, G_TYPE_STRING), g_value_set_string (&_tmp4_, ((RygelMediaObject*) item->parent)->id), _tmp4_), G_IS_VALUE (&_tmp1_) ? (g_value_unset (&_tmp1_), NULL) : NULL, _tmp5_);
	}
	values = (_tmp12_ = (_tmp11_ = g_new0 (GValue, 5), _tmp11_[0] = (g_value_init (&_tmp6_, G_TYPE_STRING), g_value_set_string (&_tmp6_, item->id), _tmp6_), _tmp11_[1] = (g_value_init (&_tmp7_, G_TYPE_STRING), g_value_set_string (&_tmp7_, rygel_media_object_get_title (item)), _tmp7_), _tmp11_[2] = (g_value_init (&_tmp8_, G_TYPE_INT), g_value_set_int (&_tmp8_, _tmp0_), _tmp8_), _tmp11_[3] = G_IS_VALUE (&_tmp1_) ? (g_value_init (&_tmp9_, G_VALUE_TYPE (&_tmp1_)), g_value_copy (&_tmp1_, &_tmp9_), _tmp9_) : _tmp1_, _tmp11_[4] = (g_value_init (&_tmp10_, G_TYPE_INT64), g_value_set_int64 (&_tmp10_, (gint64) item->modified), _tmp10_), _tmp11_), values_length1 = 5, values_size = values_length1, _tmp12_);
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_INSERT_OBJECT_STRING, values, values_length1, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&_tmp1_) ? (g_value_unset (&_tmp1_), NULL) : NULL;
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	G_IS_VALUE (&_tmp1_) ? (g_value_unset (&_tmp1_), NULL) : NULL;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


static void rygel_media_db_save_uris (RygelMediaDB* self, RygelMediaObject* obj, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_inner_error_ = NULL;
	{
		GeeIterator* _uri_it;
		_uri_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) obj->uris);
		while (TRUE) {
			char* uri;
			GValue* _tmp3_;
			gint values_size;
			gint values_length1;
			GValue* _tmp2_ = NULL;
			GValue _tmp1_ = {0};
			GValue _tmp0_ = {0};
			GValue* values;
			if (!gee_iterator_next (_uri_it)) {
				break;
			}
			uri = (char*) gee_iterator_get (_uri_it);
			values = (_tmp3_ = (_tmp2_ = g_new0 (GValue, 2), _tmp2_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, obj->id), _tmp0_), _tmp2_[1] = (g_value_init (&_tmp1_, G_TYPE_STRING), g_value_set_string (&_tmp1_, uri), _tmp1_), _tmp2_), values_length1 = 2, values_size = values_length1, _tmp3_);
			rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_INSERT_URI_STRING, values, values_length1, NULL, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (uri);
				values = (_vala_GValue_array_free (values, values_length1), NULL);
				_g_object_unref0 (_uri_it);
				return;
			}
			_g_free0 (uri);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
		}
		_g_object_unref0 (_uri_it);
	}
}


static gboolean rygel_media_db_create_schema (RygelMediaDB* self) {
	gboolean result;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	{
		rygel_database_begin (self->priv->db, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch50_g_error;
			goto __finally50;
		}
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_SCHEMA_STRING, NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch50_g_error;
			goto __finally50;
		}
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_CREATE_TRIGGER_STRING, NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch50_g_error;
			goto __finally50;
		}
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_CREATE_CLOSURE_TABLE, NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch50_g_error;
			goto __finally50;
		}
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_CREATE_INDICES_STRING, NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch50_g_error;
			goto __finally50;
		}
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_CREATE_CLOSURE_TRIGGER_STRING, NULL, 0, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch50_g_error;
			goto __finally50;
		}
		rygel_database_commit (self->priv->db, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch50_g_error;
			goto __finally50;
		}
		rygel_database_analyze (self->priv->db);
		result = TRUE;
		return result;
	}
	goto __finally50;
	__catch50_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("rygel-media-db.vala:523: Failed to create schema: %s", err->message);
			rygel_database_rollback (self->priv->db);
			_g_error_free0 (err);
		}
	}
	__finally50:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static gboolean _lambda6_ (sqlite3_stmt* stmt, Block5Data* _data5_) {
	RygelMediaDB * self;
	gboolean result;
	self = _data5_->self;
	g_return_val_if_fail (stmt != NULL, FALSE);
	if (RYGEL_IS_MEDIA_ITEM (_data5_->obj)) {
		rygel_media_item_add_uri (RYGEL_MEDIA_ITEM (_data5_->obj), sqlite3_column_text (stmt, 0), NULL);
	} else {
		gee_abstract_collection_add ((GeeAbstractCollection*) _data5_->obj->uris, sqlite3_column_text (stmt, 0));
	}
}


static gboolean __lambda6__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	return _lambda6_ (stmt, self);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	++_data5_->_ref_count_;
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if ((--_data5_->_ref_count_) == 0) {
		_g_object_unref0 (_data5_->self);
		_g_object_unref0 (_data5_->obj);
		g_slice_free (Block5Data, _data5_);
	}
}


static void rygel_media_db_add_uris (RygelMediaDB* self, RygelMediaObject* obj, GError** error) {
	GError * _inner_error_;
	Block5Data* _data5_;
	GValue* _tmp2_;
	gint values_size;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_inner_error_ = NULL;
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->obj = _g_object_ref0 (obj);
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, _data5_->obj->id), _tmp0_), _tmp1_), values_length1 = 1, values_size = values_length1, _tmp2_);
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_URI_GET_STRING, values, values_length1, __lambda6__rygel_database_row_callback, _data5_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block5_data_unref (_data5_);
			return;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block5_data_unref (_data5_);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block5_data_unref (_data5_);
}


static RygelMediaObject* rygel_media_db_get_object_from_statement (RygelMediaDB* self, RygelMediaContainer* parent, const char* object_id, sqlite3_stmt* statement) {
	RygelMediaObject* result;
	GError * _inner_error_;
	RygelMediaObject* obj;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object_id != NULL, NULL);
	g_return_val_if_fail (statement != NULL, NULL);
	_inner_error_ = NULL;
	obj = NULL;
	switch (sqlite3_column_int (statement, 0)) {
		case 0:
		{
			RygelMediaObject* _tmp0_;
			obj = (_tmp0_ = (RygelMediaObject*) rygel_media_db_object_factory_get_container (self->priv->factory, self, object_id, sqlite3_column_text (statement, 1), (guint) 0), _g_object_unref0 (obj), _tmp0_);
			break;
		}
		case 1:
		{
			RygelMediaObject* _tmp1_;
			obj = (_tmp1_ = (RygelMediaObject*) rygel_media_db_object_factory_get_item (self->priv->factory, self, parent, object_id, sqlite3_column_text (statement, 1), sqlite3_column_text (statement, 6)), _g_object_unref0 (obj), _tmp1_);
			rygel_media_db_fill_item (self, statement, RYGEL_MEDIA_ITEM (obj));
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	{
		if (obj != NULL) {
			obj->modified = (guint64) sqlite3_column_int64 (statement, 18);
			rygel_media_db_add_uris (self, obj, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
					goto __catch51_rygel_database_error;
				}
				goto __finally51;
			}
		}
	}
	goto __finally51;
	__catch51_rygel_database_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			RygelMediaObject* _tmp2_;
			g_warning ("rygel-media-db.vala:573: Failed to load uris from database: %s", err->message);
			obj = (_tmp2_ = NULL, _g_object_unref0 (obj), _tmp2_);
			_g_error_free0 (err);
		}
	}
	__finally51:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (obj);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = obj;
	return result;
}


static gboolean _lambda5_ (sqlite3_stmt* stmt, Block6Data* _data6_) {
	RygelMediaDB * self;
	gboolean result;
	RygelMediaObject* obj;
	RygelMediaContainer* _tmp0_;
	RygelMediaObject* _tmp1_;
	self = _data6_->self;
	g_return_val_if_fail (stmt != NULL, FALSE);
	obj = rygel_media_db_get_object_from_statement (self, RYGEL_MEDIA_CONTAINER (_data6_->parent), sqlite3_column_text (stmt, 18), stmt);
	obj->parent = RYGEL_MEDIA_CONTAINER (_data6_->parent);
	obj->parent_ref = (_tmp0_ = _g_object_ref0 (RYGEL_MEDIA_CONTAINER (_data6_->parent)), _g_object_unref0 (obj->parent_ref), _tmp0_);
	_data6_->parent = (_tmp1_ = _g_object_ref0 (obj), _g_object_unref0 (_data6_->parent), _tmp1_);
	result = TRUE;
	_g_object_unref0 (obj);
	return result;
}


static gboolean __lambda5__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	return _lambda5_ (stmt, self);
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	++_data6_->_ref_count_;
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if ((--_data6_->_ref_count_) == 0) {
		_g_object_unref0 (_data6_->self);
		_g_object_unref0 (_data6_->parent);
		g_slice_free (Block6Data, _data6_);
	}
}


RygelMediaObject* rygel_media_db_get_object (RygelMediaDB* self, const char* object_id, GError** error) {
	RygelMediaObject* result;
	GError * _inner_error_;
	Block6Data* _data6_;
	GValue* _tmp2_;
	gint values_size;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
	RygelDatabaseRowCallback _tmp3_;
	GDestroyNotify cb_target_destroy_notify;
	void* cb_target = NULL;
	RygelDatabaseRowCallback cb;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object_id != NULL, NULL);
	_inner_error_ = NULL;
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, object_id), _tmp0_), _tmp1_), values_length1 = 1, values_size = values_length1, _tmp2_);
	_data6_->parent = NULL;
	cb = (_tmp3_ = __lambda5__rygel_database_row_callback, cb_target = block6_data_ref (_data6_), cb_target_destroy_notify = block6_data_unref, _tmp3_);
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_GET_OBJECT_WITH_CLOSURE, values, values_length1, cb, cb_target, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			(cb_target_destroy_notify == NULL) ? NULL : cb_target_destroy_notify (cb_target);
			cb = NULL;
			cb_target = NULL;
			cb_target_destroy_notify = NULL;
			block6_data_unref (_data6_);
			return NULL;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			(cb_target_destroy_notify == NULL) ? NULL : cb_target_destroy_notify (cb_target);
			cb = NULL;
			cb_target = NULL;
			cb_target_destroy_notify = NULL;
			block6_data_unref (_data6_);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _g_object_ref0 (_data6_->parent);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	(cb_target_destroy_notify == NULL) ? NULL : cb_target_destroy_notify (cb_target);
	cb = NULL;
	cb_target = NULL;
	cb_target_destroy_notify = NULL;
	block6_data_unref (_data6_);
	return result;
}


RygelMediaItem* rygel_media_db_get_item (RygelMediaDB* self, const char* item_id, GError** error) {
	RygelMediaItem* result;
	GError * _inner_error_;
	RygelMediaObject* obj;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item_id != NULL, NULL);
	_inner_error_ = NULL;
	obj = rygel_media_db_get_object (self, item_id, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (obj != NULL) {
		_tmp0_ = !RYGEL_IS_MEDIA_ITEM (obj);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_inner_error_ = g_error_new (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_INVALID_TYPE, "Object with id %s is not a" "MediaItem", item_id);
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == RYGEL_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (obj);
				return NULL;
			} else {
				_g_object_unref0 (obj);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = _g_object_ref0 (RYGEL_MEDIA_ITEM (obj));
	_g_object_unref0 (obj);
	return result;
}


RygelMediaContainer* rygel_media_db_get_container (RygelMediaDB* self, const char* container_id, GError** error) {
	RygelMediaContainer* result;
	GError * _inner_error_;
	RygelMediaObject* obj;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (container_id != NULL, NULL);
	_inner_error_ = NULL;
	obj = rygel_media_db_get_object (self, container_id, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (obj != NULL) {
		_tmp0_ = !RYGEL_IS_MEDIA_CONTAINER (obj);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_inner_error_ = g_error_new (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_INVALID_TYPE, "Object with id %s is not a" "MediaContainer", container_id);
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == RYGEL_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (obj);
				return NULL;
			} else {
				_g_object_unref0 (obj);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = _g_object_ref0 (RYGEL_MEDIA_CONTAINER (obj));
	_g_object_unref0 (obj);
	return result;
}


static void rygel_media_db_fill_item (RygelMediaDB* self, sqlite3_stmt* statement, RygelMediaItem* item) {
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (statement != NULL);
	g_return_if_fail (item != NULL);
	item->author = (_tmp0_ = g_strdup (sqlite3_column_text (statement, 7)), _g_free0 (item->author), _tmp0_);
	item->album = (_tmp1_ = g_strdup (sqlite3_column_text (statement, 8)), _g_free0 (item->album), _tmp1_);
	item->date = (_tmp2_ = g_strdup (sqlite3_column_text (statement, 9)), _g_free0 (item->date), _tmp2_);
	item->mime_type = (_tmp3_ = g_strdup (sqlite3_column_text (statement, 3)), _g_free0 (item->mime_type), _tmp3_);
	item->duration = (glong) sqlite3_column_int64 (statement, 16);
	item->size = (glong) sqlite3_column_int64 (statement, 2);
	item->bitrate = sqlite3_column_int (statement, 10);
	item->sample_freq = sqlite3_column_int (statement, 11);
	item->bits_per_sample = sqlite3_column_int (statement, 12);
	item->n_audio_channels = sqlite3_column_int (statement, 13);
	item->track_number = sqlite3_column_int (statement, 14);
	item->width = sqlite3_column_int (statement, 4);
	item->height = sqlite3_column_int (statement, 5);
	item->color_depth = sqlite3_column_int (statement, 15);
}


static gboolean _lambda10_ (sqlite3_stmt* stmt, Block7Data* _data7_) {
	RygelMediaDB * self;
	gboolean result;
	self = _data7_->self;
	g_return_val_if_fail (stmt != NULL, FALSE);
	gee_abstract_collection_add ((GeeAbstractCollection*) _data7_->children, sqlite3_column_text (stmt, 0));
	result = TRUE;
	return result;
}


static gboolean __lambda10__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	return _lambda10_ (stmt, self);
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	++_data7_->_ref_count_;
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if ((--_data7_->_ref_count_) == 0) {
		_g_object_unref0 (_data7_->self);
		_g_object_unref0 (_data7_->children);
		g_slice_free (Block7Data, _data7_);
	}
}


GeeArrayList* rygel_media_db_get_child_ids (RygelMediaDB* self, const char* container_id, GError** error) {
	GeeArrayList* result;
	GError * _inner_error_;
	Block7Data* _data7_;
	GValue* _tmp2_;
	gint values_size;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (container_id != NULL, NULL);
	_inner_error_ = NULL;
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_data7_->children = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, container_id), _tmp0_), _tmp1_), values_length1 = 1, values_size = values_length1, _tmp2_);
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_GET_CHILD_ID_STRING, values, values_length1, __lambda10__rygel_database_row_callback, _data7_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block7_data_unref (_data7_);
			return NULL;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block7_data_unref (_data7_);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _g_object_ref0 (_data7_->children);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block7_data_unref (_data7_);
	return result;
}


static gboolean _lambda4_ (sqlite3_stmt* stmt, Block8Data* _data8_) {
	RygelMediaDB * self;
	gboolean result;
	self = _data8_->self;
	g_return_val_if_fail (stmt != NULL, FALSE);
	_data8_->count = sqlite3_column_int (stmt, 0);
	result = FALSE;
	return result;
}


static gboolean __lambda4__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	return _lambda4_ (stmt, self);
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	++_data8_->_ref_count_;
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if ((--_data8_->_ref_count_) == 0) {
		_g_object_unref0 (_data8_->self);
		g_slice_free (Block8Data, _data8_);
	}
}


gint rygel_media_db_get_child_count (RygelMediaDB* self, const char* container_id, GError** error) {
	gint result;
	GError * _inner_error_;
	Block8Data* _data8_;
	GValue* _tmp2_;
	gint values_size;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (container_id != NULL, 0);
	_inner_error_ = NULL;
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_data8_->count = 0;
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, container_id), _tmp0_), _tmp1_), values_length1 = 1, values_size = values_length1, _tmp2_);
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_CHILDREN_COUNT_STRING, values, values_length1, __lambda4__rygel_database_row_callback, _data8_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block8_data_unref (_data8_);
			return 0;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block8_data_unref (_data8_);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _data8_->count;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block8_data_unref (_data8_);
	return result;
}


static gboolean _lambda11_ (sqlite3_stmt* stmt, Block9Data* _data9_) {
	RygelMediaDB * self;
	gboolean result;
	self = _data9_->self;
	g_return_val_if_fail (stmt != NULL, FALSE);
	_data9_->exists = sqlite3_column_int (stmt, 0) == 1;
	_data9_->tmp_timestamp = sqlite3_column_int64 (stmt, 1);
	result = FALSE;
	return result;
}


static gboolean __lambda11__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	return _lambda11_ (stmt, self);
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	++_data9_->_ref_count_;
	return _data9_;
}


static void block9_data_unref (Block9Data* _data9_) {
	if ((--_data9_->_ref_count_) == 0) {
		_g_object_unref0 (_data9_->self);
		g_slice_free (Block9Data, _data9_);
	}
}


gboolean rygel_media_db_exists (RygelMediaDB* self, const char* object_id, gint64* timestamp, GError** error) {
	gboolean result;
	GError * _inner_error_;
	Block9Data* _data9_;
	GValue* _tmp2_;
	gint values_size;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (object_id != NULL, FALSE);
	_inner_error_ = NULL;
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_data9_->exists = FALSE;
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, object_id), _tmp0_), _tmp1_), values_length1 = 1, values_size = values_length1, _tmp2_);
	_data9_->tmp_timestamp = (gint64) 0;
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_OBJECT_EXISTS_STRING, values, values_length1, __lambda11__rygel_database_row_callback, _data9_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block9_data_unref (_data9_);
			return FALSE;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block9_data_unref (_data9_);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	*timestamp = _data9_->tmp_timestamp;
	result = _data9_->exists;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block9_data_unref (_data9_);
	return result;
}


static gboolean _lambda7_ (sqlite3_stmt* stmt, Block10Data* _data10_) {
	RygelMediaDB * self;
	gboolean result;
	char* child_id;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaContainer* _tmp4_;
	RygelMediaContainer* *_tmp3_;
	RygelMediaObject* _tmp2_;
	self = _data10_->self;
	g_return_val_if_fail (stmt != NULL, FALSE);
	child_id = g_strdup (sqlite3_column_text (stmt, 17));
	gee_abstract_collection_add ((GeeAbstractCollection*) _data10_->children, _tmp0_ = rygel_media_db_get_object_from_statement (self, _data10_->parent, child_id, stmt));
	_g_object_unref0 (_tmp0_);
	(_tmp1_ = (RygelMediaObject*) gee_abstract_list_get ((GeeAbstractList*) _data10_->children, gee_collection_get_size ((GeeCollection*) _data10_->children) - 1))->parent = _data10_->parent;
	_g_object_unref0 (_tmp1_);
	_tmp3_ = &(_tmp2_ = (RygelMediaObject*) gee_abstract_list_get ((GeeAbstractList*) _data10_->children, gee_collection_get_size ((GeeCollection*) _data10_->children) - 1))->parent_ref;
	(*_tmp3_) = (_tmp4_ = _g_object_ref0 (_data10_->parent), _g_object_unref0 ((*_tmp3_)), _tmp4_);
	_g_object_unref0 (_tmp2_);
	result = TRUE;
	_g_free0 (child_id);
	return result;
}


static gboolean __lambda7__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	return _lambda7_ (stmt, self);
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	++_data10_->_ref_count_;
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if ((--_data10_->_ref_count_) == 0) {
		_g_object_unref0 (_data10_->self);
		_g_object_unref0 (_data10_->parent);
		_g_object_unref0 (_data10_->children);
		g_slice_free (Block10Data, _data10_);
	}
}


GeeArrayList* rygel_media_db_get_children (RygelMediaDB* self, const char* container_id, glong offset, glong max_count, GError** error) {
	GeeArrayList* result;
	GError * _inner_error_;
	Block10Data* _data10_;
	RygelMediaObject* _tmp0_;
	RygelMediaContainer* _tmp1_;
	GValue* _tmp6_;
	gint values_size;
	gint values_length1;
	GValue* _tmp5_ = NULL;
	GValue _tmp4_ = {0};
	GValue _tmp3_ = {0};
	GValue _tmp2_ = {0};
	GValue* values;
	RygelDatabaseRowCallback _tmp7_;
	GDestroyNotify cb_target_destroy_notify;
	void* cb_target = NULL;
	RygelDatabaseRowCallback cb;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (container_id != NULL, NULL);
	_inner_error_ = NULL;
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_data10_->parent = NULL;
	_data10_->children = gee_array_list_new (RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_tmp0_ = rygel_media_db_get_object (self, container_id, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		block10_data_unref (_data10_);
		return NULL;
	}
	_data10_->parent = (_tmp1_ = RYGEL_MEDIA_CONTAINER (_tmp0_), _g_object_unref0 (_data10_->parent), _tmp1_);
	values = (_tmp6_ = (_tmp5_ = g_new0 (GValue, 3), _tmp5_[0] = (g_value_init (&_tmp2_, G_TYPE_STRING), g_value_set_string (&_tmp2_, container_id), _tmp2_), _tmp5_[1] = (g_value_init (&_tmp3_, G_TYPE_INT64), g_value_set_int64 (&_tmp3_, (gint64) offset), _tmp3_), _tmp5_[2] = (g_value_init (&_tmp4_, G_TYPE_INT64), g_value_set_int64 (&_tmp4_, (gint64) max_count), _tmp4_), _tmp5_), values_length1 = 3, values_size = values_length1, _tmp6_);
	cb = (_tmp7_ = __lambda7__rygel_database_row_callback, cb_target = block10_data_ref (_data10_), cb_target_destroy_notify = block10_data_unref, _tmp7_);
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_GET_CHILDREN_STRING, values, values_length1, cb, cb_target, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		(cb_target_destroy_notify == NULL) ? NULL : cb_target_destroy_notify (cb_target);
		cb = NULL;
		cb_target = NULL;
		cb_target_destroy_notify = NULL;
		block10_data_unref (_data10_);
		return NULL;
	}
	result = _g_object_ref0 (_data10_->children);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	(cb_target_destroy_notify == NULL) ? NULL : cb_target_destroy_notify (cb_target);
	cb = NULL;
	cb_target = NULL;
	cb_target_destroy_notify = NULL;
	block10_data_unref (_data10_);
	return result;
}


static void rygel_media_db_class_init (RygelMediaDBClass * klass) {
	rygel_media_db_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaDBPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_db_finalize;
	g_signal_new ("object_added", RYGEL_TYPE_MEDIA_DB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("object_removed", RYGEL_TYPE_MEDIA_DB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("object_updated", RYGEL_TYPE_MEDIA_DB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("item_removed", RYGEL_TYPE_MEDIA_DB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("item_added", RYGEL_TYPE_MEDIA_DB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("item_updated", RYGEL_TYPE_MEDIA_DB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("container_added", RYGEL_TYPE_MEDIA_DB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("container_removed", RYGEL_TYPE_MEDIA_DB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("container_updated", RYGEL_TYPE_MEDIA_DB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void rygel_media_db_instance_init (RygelMediaDB * self) {
	self->priv = RYGEL_MEDIA_DB_GET_PRIVATE (self);
}


static void rygel_media_db_finalize (GObject* obj) {
	RygelMediaDB * self;
	self = RYGEL_MEDIA_DB (obj);
	_g_object_unref0 (self->priv->db);
	_g_object_unref0 (self->priv->factory);
	G_OBJECT_CLASS (rygel_media_db_parent_class)->finalize (obj);
}


GType rygel_media_db_get_type (void) {
	static GType rygel_media_db_type_id = 0;
	if (rygel_media_db_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaDBClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_db_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaDB), 0, (GInstanceInitFunc) rygel_media_db_instance_init, NULL };
		rygel_media_db_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaDB", &g_define_type_info, 0);
	}
	return rygel_media_db_type_id;
}




