/* rygel-simple-container.c generated by valac, the Vala compiler
 * generated from rygel-simple-container.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_SIMPLE_CONTAINER (rygel_simple_container_get_type ())
#define RYGEL_SIMPLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer))
#define RYGEL_SIMPLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainerClass))
#define RYGEL_IS_SIMPLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SIMPLE_CONTAINER))
#define RYGEL_IS_SIMPLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SIMPLE_CONTAINER))
#define RYGEL_SIMPLE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainerClass))

typedef struct _RygelSimpleContainer RygelSimpleContainer;
typedef struct _RygelSimpleContainerClass RygelSimpleContainerClass;
typedef struct _RygelSimpleContainerPrivate RygelSimpleContainerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelSimpleContainerGetChildrenData RygelSimpleContainerGetChildrenData;
typedef struct _RygelSimpleContainerFindObjectData RygelSimpleContainerFindObjectData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelSimpleContainerFindObjectInChildrenData RygelSimpleContainerFindObjectInChildrenData;

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
	RygelMediaContainer* parent_ref;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	guint child_count;
	guint32 update_id;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelSimpleContainer {
	RygelMediaContainer parent_instance;
	RygelSimpleContainerPrivate * priv;
	GeeArrayList* children;
};

struct _RygelSimpleContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelSimpleContainerGetChildrenData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSimpleContainer* self;
	guint offset;
	guint max_count;
	GCancellable* cancellable;
	GeeList* result;
	guint stop;
};

struct _RygelSimpleContainerFindObjectData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSimpleContainer* self;
	char* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelMediaObject* child;
	GeeIterator* _tmp_it;
	RygelMediaObject* tmp;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaObject* _tmp2_;
	GError * _inner_error_;
};

struct _RygelSimpleContainerFindObjectInChildrenData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSimpleContainer* self;
	char* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelMediaObject* child;
	GeeIterator* _tmp_it;
	RygelMediaObject* tmp;
	RygelMediaContainer* container;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaObject* _tmp2_;
	GError * _inner_error_;
};


static gpointer rygel_simple_container_parent_class = NULL;

GType rygel_media_object_get_type (void);
GType rygel_media_container_get_type (void);
GType rygel_simple_container_get_type (void);
enum  {
	RYGEL_SIMPLE_CONTAINER_DUMMY_PROPERTY
};
RygelMediaContainer* rygel_media_container_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, guint child_count);
RygelSimpleContainer* rygel_simple_container_new (const char* id, RygelMediaContainer* parent, const char* title);
RygelSimpleContainer* rygel_simple_container_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title);
RygelSimpleContainer* rygel_simple_container_new_root (const char* title);
RygelSimpleContainer* rygel_simple_container_construct_root (GType object_type, const char* title);
void rygel_simple_container_add_child (RygelSimpleContainer* self, RygelMediaObject* child);
void rygel_simple_container_remove_child (RygelSimpleContainer* self, RygelMediaObject* child);
static void rygel_simple_container_real_get_children_data_free (gpointer _data);
static void rygel_simple_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_simple_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_simple_container_real_get_children_co (RygelSimpleContainerGetChildrenData* data);
static void rygel_simple_container_real_find_object_data_free (gpointer _data);
static void rygel_simple_container_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_simple_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_simple_container_find_object_in_children (RygelSimpleContainer* self, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_simple_container_find_object_in_children_finish (RygelSimpleContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_simple_container_real_find_object_co (RygelSimpleContainerFindObjectData* data);
static void rygel_simple_container_find_object_in_children_data_free (gpointer _data);
static void rygel_simple_container_find_object_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_simple_container_find_object_in_children_co (RygelSimpleContainerFindObjectInChildrenData* data);
static void rygel_simple_container_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



RygelSimpleContainer* rygel_simple_container_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title) {
	RygelSimpleContainer * self;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	self = (RygelSimpleContainer*) rygel_media_container_construct (object_type, id, parent, title, (guint) 0);
	self->children = (_tmp0_ = gee_array_list_new (RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->children), _tmp0_);
	return self;
}


RygelSimpleContainer* rygel_simple_container_new (const char* id, RygelMediaContainer* parent, const char* title) {
	return rygel_simple_container_construct (RYGEL_TYPE_SIMPLE_CONTAINER, id, parent, title);
}


RygelSimpleContainer* rygel_simple_container_construct_root (GType object_type, const char* title) {
	RygelSimpleContainer * self;
	g_return_val_if_fail (title != NULL, NULL);
	self = (RygelSimpleContainer*) rygel_simple_container_construct (object_type, "0", NULL, title);
	return self;
}


RygelSimpleContainer* rygel_simple_container_new_root (const char* title) {
	return rygel_simple_container_construct_root (RYGEL_TYPE_SIMPLE_CONTAINER, title);
}


void rygel_simple_container_add_child (RygelSimpleContainer* self, RygelMediaObject* child) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) self->children, child);
	((RygelMediaContainer*) self)->child_count++;
}


void rygel_simple_container_remove_child (RygelSimpleContainer* self, RygelMediaObject* child) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	gee_abstract_collection_remove ((GeeAbstractCollection*) self->children, child);
	((RygelMediaContainer*) self)->child_count--;
}


static void rygel_simple_container_real_get_children_data_free (gpointer _data) {
	RygelSimpleContainerGetChildrenData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_slice_free (RygelSimpleContainerGetChildrenData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_simple_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSimpleContainer * self;
	RygelSimpleContainerGetChildrenData* _data_;
	self = (RygelSimpleContainer*) base;
	_data_ = g_slice_new0 (RygelSimpleContainerGetChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_simple_container_real_get_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_simple_container_real_get_children_data_free);
	_data_->self = self;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_simple_container_real_get_children_co (_data_);
}


static GeeList* rygel_simple_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	GeeList* result;
	RygelSimpleContainerGetChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_simple_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSimpleContainerGetChildrenData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_simple_container_real_get_children_co (data);
}


static gboolean rygel_simple_container_real_get_children_co (RygelSimpleContainerGetChildrenData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->stop = data->offset + data->max_count;
			data->stop = CLAMP (data->stop, (guint) 0, ((RygelMediaContainer*) data->self)->child_count);
			data->result = gee_abstract_list_slice ((GeeAbstractList*) data->self->children, (gint) data->offset, (gint) data->stop);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_simple_container_real_find_object_data_free (gpointer _data) {
	RygelSimpleContainerFindObjectData* data;
	data = _data;
	_g_free0 (data->id);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_slice_free (RygelSimpleContainerFindObjectData, data);
}


static void rygel_simple_container_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSimpleContainer * self;
	RygelSimpleContainerFindObjectData* _data_;
	self = (RygelSimpleContainer*) base;
	_data_ = g_slice_new0 (RygelSimpleContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_simple_container_real_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_simple_container_real_find_object_data_free);
	_data_->self = self;
	_data_->id = g_strdup (id);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_simple_container_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_simple_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelSimpleContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_simple_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSimpleContainerFindObjectData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_simple_container_real_find_object_co (data);
}


static gboolean rygel_simple_container_real_find_object_co (RygelSimpleContainerFindObjectData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->child = NULL;
			{
				data->_tmp_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) data->self->children);
				while (TRUE) {
					if (!gee_iterator_next (data->_tmp_it)) {
						break;
					}
					data->tmp = (RygelMediaObject*) gee_iterator_get (data->_tmp_it);
					if (_vala_strcmp0 (data->id, data->tmp->id) == 0) {
						data->child = (data->_tmp0_ = _g_object_ref0 (data->tmp), _g_object_unref0 (data->child), data->_tmp0_);
						_g_object_unref0 (data->tmp);
						break;
					}
					_g_object_unref0 (data->tmp);
				}
				_g_object_unref0 (data->_tmp_it);
			}
			if (data->child == NULL) {
				rygel_simple_container_find_object_in_children (data->self, data->id, data->cancellable, rygel_simple_container_find_object_ready, data);
				data->_state_ = 17;
				return FALSE;
				case 17:
				data->_tmp1_ = rygel_simple_container_find_object_in_children_finish (data->self, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->child);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
				data->child = (data->_tmp2_ = data->_tmp1_, _g_object_unref0 (data->child), data->_tmp2_);
			}
			data->result = data->child;
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_object_unref0 (data->child);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_simple_container_find_object_in_children_data_free (gpointer _data) {
	RygelSimpleContainerFindObjectInChildrenData* data;
	data = _data;
	_g_free0 (data->id);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_slice_free (RygelSimpleContainerFindObjectInChildrenData, data);
}


void rygel_simple_container_find_object_in_children (RygelSimpleContainer* self, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSimpleContainerFindObjectInChildrenData* _data_;
	_data_ = g_slice_new0 (RygelSimpleContainerFindObjectInChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_simple_container_find_object_in_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_simple_container_find_object_in_children_data_free);
	_data_->self = self;
	_data_->id = g_strdup (id);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_simple_container_find_object_in_children_co (_data_);
}


RygelMediaObject* rygel_simple_container_find_object_in_children_finish (RygelSimpleContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelSimpleContainerFindObjectInChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_simple_container_find_object_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSimpleContainerFindObjectInChildrenData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_simple_container_find_object_in_children_co (data);
}


static gboolean rygel_simple_container_find_object_in_children_co (RygelSimpleContainerFindObjectInChildrenData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->child = NULL;
			{
				data->_tmp_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) data->self->children);
				while (TRUE) {
					if (!gee_iterator_next (data->_tmp_it)) {
						break;
					}
					data->tmp = (RygelMediaObject*) gee_iterator_get (data->_tmp_it);
					if (RYGEL_IS_MEDIA_CONTAINER (data->tmp)) {
						data->container = _g_object_ref0 ((data->_tmp0_ = data->tmp, RYGEL_IS_MEDIA_CONTAINER (data->_tmp0_) ? ((RygelMediaContainer*) data->_tmp0_) : NULL));
						rygel_media_container_find_object (data->container, data->id, data->cancellable, rygel_simple_container_find_object_in_children_ready, data);
						data->_state_ = 18;
						return FALSE;
						case 18:
						data->_tmp1_ = rygel_media_container_find_object_finish (data->container, data->_res_, &data->_inner_error_);
						if (data->_inner_error_ != NULL) {
							g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
							g_error_free (data->_inner_error_);
							_g_object_unref0 (data->container);
							_g_object_unref0 (data->tmp);
							_g_object_unref0 (data->_tmp_it);
							_g_object_unref0 (data->child);
							{
								if (data->_state_ == 0) {
									g_simple_async_result_complete_in_idle (data->_async_result);
								} else {
									g_simple_async_result_complete (data->_async_result);
								}
								g_object_unref (data->_async_result);
								return FALSE;
							}
						}
						data->child = (data->_tmp2_ = data->_tmp1_, _g_object_unref0 (data->child), data->_tmp2_);
						if (data->child != NULL) {
							_g_object_unref0 (data->container);
							_g_object_unref0 (data->tmp);
							break;
						}
						_g_object_unref0 (data->container);
					}
					_g_object_unref0 (data->tmp);
				}
				_g_object_unref0 (data->_tmp_it);
			}
			data->result = data->child;
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_object_unref0 (data->child);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_simple_container_class_init (RygelSimpleContainerClass * klass) {
	rygel_simple_container_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_simple_container_real_get_children;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_simple_container_real_get_children_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_simple_container_real_find_object;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_simple_container_real_find_object_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_simple_container_finalize;
}


static void rygel_simple_container_instance_init (RygelSimpleContainer * self) {
}


static void rygel_simple_container_finalize (GObject* obj) {
	RygelSimpleContainer * self;
	self = RYGEL_SIMPLE_CONTAINER (obj);
	_g_object_unref0 (self->children);
	G_OBJECT_CLASS (rygel_simple_container_parent_class)->finalize (obj);
}


GType rygel_simple_container_get_type (void) {
	static GType rygel_simple_container_type_id = 0;
	if (rygel_simple_container_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSimpleContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_simple_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSimpleContainer), 0, (GInstanceInitFunc) rygel_simple_container_instance_init, NULL };
		rygel_simple_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelSimpleContainer", &g_define_type_info, 0);
	}
	return rygel_simple_container_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




