/* rygel-gst-av-transport.c generated by valac, the Vala compiler
 * generated from rygel-gst-av-transport.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_TYPE_GST_AV_TRANSPORT (rygel_gst_av_transport_get_type ())
#define RYGEL_GST_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_AV_TRANSPORT, RygelGstAVTransport))
#define RYGEL_GST_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_AV_TRANSPORT, RygelGstAVTransportClass))
#define RYGEL_IS_GST_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_AV_TRANSPORT))
#define RYGEL_IS_GST_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_AV_TRANSPORT))
#define RYGEL_GST_AV_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_AV_TRANSPORT, RygelGstAVTransportClass))

typedef struct _RygelGstAVTransport RygelGstAVTransport;
typedef struct _RygelGstAVTransportClass RygelGstAVTransportClass;
typedef struct _RygelGstAVTransportPrivate RygelGstAVTransportPrivate;

#define RYGEL_TYPE_GST_CHANGE_LOG (rygel_gst_change_log_get_type ())
#define RYGEL_GST_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_CHANGE_LOG, RygelGstChangeLog))
#define RYGEL_GST_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_CHANGE_LOG, RygelGstChangeLogClass))
#define RYGEL_IS_GST_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_CHANGE_LOG))
#define RYGEL_IS_GST_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_CHANGE_LOG))
#define RYGEL_GST_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_CHANGE_LOG, RygelGstChangeLogClass))

typedef struct _RygelGstChangeLog RygelGstChangeLog;
typedef struct _RygelGstChangeLogClass RygelGstChangeLogClass;

#define RYGEL_TYPE_GST_PLAYER (rygel_gst_player_get_type ())
#define RYGEL_GST_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_PLAYER, RygelGstPlayer))
#define RYGEL_GST_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_PLAYER, RygelGstPlayerClass))
#define RYGEL_IS_GST_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_PLAYER))
#define RYGEL_IS_GST_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_PLAYER))
#define RYGEL_GST_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_PLAYER, RygelGstPlayerClass))

typedef struct _RygelGstPlayer RygelGstPlayer;
typedef struct _RygelGstPlayerClass RygelGstPlayerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelGstAVTransport {
	GUPnPService parent_instance;
	RygelGstAVTransportPrivate * priv;
};

struct _RygelGstAVTransportClass {
	GUPnPServiceClass parent_class;
};

struct _RygelGstAVTransportPrivate {
	guint _n_tracks;
	guint _track;
	char* _metadata;
	char* _status;
	char* _speed;
	char* _mode;
	RygelGstChangeLog* changelog;
	RygelGstPlayer* player;
};


static gpointer rygel_gst_av_transport_parent_class = NULL;

GType rygel_gst_av_transport_get_type (void);
GType rygel_gst_change_log_get_type (void);
GType rygel_gst_player_get_type (void);
#define RYGEL_GST_AV_TRANSPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_GST_AV_TRANSPORT, RygelGstAVTransportPrivate))
enum  {
	RYGEL_GST_AV_TRANSPORT_DUMMY_PROPERTY,
	RYGEL_GST_AV_TRANSPORT_N_TRACKS,
	RYGEL_GST_AV_TRANSPORT_TRACK,
	RYGEL_GST_AV_TRANSPORT_METADATA,
	RYGEL_GST_AV_TRANSPORT_URI,
	RYGEL_GST_AV_TRANSPORT_STATUS,
	RYGEL_GST_AV_TRANSPORT_SPEED,
	RYGEL_GST_AV_TRANSPORT_MODE
};
#define RYGEL_GST_AV_TRANSPORT_UPNP_ID "urn:upnp-org:serviceId:AVTransport"
#define RYGEL_GST_AV_TRANSPORT_UPNP_TYPE "urn:schemas-upnp-org:service:AVTransport:2"
#define RYGEL_GST_AV_TRANSPORT_DESCRIPTION_PATH "xml/AVTransport2.xml"
#define RYGEL_GST_AV_TRANSPORT_LAST_CHANGE_NS "urn:schemas-upnp-org:metadata-1-0/AVT/"
RygelGstChangeLog* rygel_gst_change_log_new (GUPnPService* service, const char* service_ns);
RygelGstChangeLog* rygel_gst_change_log_construct (GType object_type, GUPnPService* service, const char* service_ns);
RygelGstPlayer* rygel_gst_player_get_default (void);
static void rygel_gst_av_transport_query_last_change_cb (RygelGstAVTransport* self, GUPnPService* service, const char* variable, GValue* value);
static void _rygel_gst_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const char* variable, GValue* value, gpointer self);
static void rygel_gst_av_transport_set_av_transport_uri_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_av_transport_get_media_info_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_av_transport_get_transport_info_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_av_transport_get_position_info_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_av_transport_get_device_capabilities_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_av_transport_get_transport_settings_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_av_transport_stop_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_av_transport_play_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_av_transport_pause_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_av_transport_seek_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_av_transport_next_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_av_transport_previous_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_gst_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_gst_av_transport_notify_state_cb (RygelGstAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_gst_av_transport_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_gst_av_transport_notify_duration_cb (RygelGstAVTransport* self, GObject* window, GParamSpec* p);
static void _rygel_gst_av_transport_notify_duration_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_gst_av_transport_real_constructed (GObject* base);
void rygel_gst_change_log_log (RygelGstChangeLog* self, const char* variable, const char* value);
const char* rygel_gst_player_get_playback_state (RygelGstPlayer* self);
const char* rygel_gst_av_transport_get_status (RygelGstAVTransport* self);
const char* rygel_gst_av_transport_get_mode (RygelGstAVTransport* self);
const char* rygel_gst_av_transport_get_speed (RygelGstAVTransport* self);
guint rygel_gst_av_transport_get_n_tracks (RygelGstAVTransport* self);
guint rygel_gst_av_transport_get_track (RygelGstAVTransport* self);
char* rygel_gst_player_get_duration (RygelGstPlayer* self);
char* rygel_gst_av_transport_get_metadata (RygelGstAVTransport* self);
char* rygel_gst_av_transport_get_uri (RygelGstAVTransport* self);
char* rygel_gst_change_log_finish (RygelGstChangeLog* self);
static gboolean rygel_gst_av_transport_check_instance_id (RygelGstAVTransport* self, GUPnPServiceAction* action);
void rygel_gst_av_transport_set_uri (RygelGstAVTransport* self, const char* value);
void rygel_gst_av_transport_set_metadata (RygelGstAVTransport* self, const char* value);
char* rygel_gst_player_get_position (RygelGstPlayer* self);
void rygel_gst_player_set_playback_state (RygelGstPlayer* self, const char* value);
gboolean rygel_gst_player_seek (RygelGstPlayer* self, const char* time);
RygelGstAVTransport* rygel_gst_av_transport_new (void);
RygelGstAVTransport* rygel_gst_av_transport_construct (GType object_type);
void rygel_gst_av_transport_set_n_tracks (RygelGstAVTransport* self, guint value);
void rygel_gst_av_transport_set_track (RygelGstAVTransport* self, guint value);
const char* rygel_gst_player_get_uri (RygelGstPlayer* self);
void rygel_gst_player_set_uri (RygelGstPlayer* self, const char* value);
void rygel_gst_av_transport_set_status (RygelGstAVTransport* self, const char* value);
void rygel_gst_av_transport_set_speed (RygelGstAVTransport* self, const char* value);
void rygel_gst_av_transport_set_mode (RygelGstAVTransport* self, const char* value);
static void rygel_gst_av_transport_finalize (GObject* obj);
static void rygel_gst_av_transport_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_gst_av_transport_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _rygel_gst_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const char* variable, GValue* value, gpointer self) {
	rygel_gst_av_transport_query_last_change_cb (self, _sender, variable, value);
}


static void _rygel_gst_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_gst_av_transport_set_av_transport_uri_cb (self, _sender, action);
}


static void _rygel_gst_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_gst_av_transport_get_media_info_cb (self, _sender, action);
}


static void _rygel_gst_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_gst_av_transport_get_transport_info_cb (self, _sender, action);
}


static void _rygel_gst_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_gst_av_transport_get_position_info_cb (self, _sender, action);
}


static void _rygel_gst_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_gst_av_transport_get_device_capabilities_cb (self, _sender, action);
}


static void _rygel_gst_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_gst_av_transport_get_transport_settings_cb (self, _sender, action);
}


static void _rygel_gst_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_gst_av_transport_stop_cb (self, _sender, action);
}


static void _rygel_gst_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_gst_av_transport_play_cb (self, _sender, action);
}


static void _rygel_gst_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_gst_av_transport_pause_cb (self, _sender, action);
}


static void _rygel_gst_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_gst_av_transport_seek_cb (self, _sender, action);
}


static void _rygel_gst_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_gst_av_transport_next_cb (self, _sender, action);
}


static void _rygel_gst_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_gst_av_transport_previous_cb (self, _sender, action);
}


static void _rygel_gst_av_transport_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_gst_av_transport_notify_state_cb (self, _sender, pspec);
}


static void _rygel_gst_av_transport_notify_duration_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_gst_av_transport_notify_duration_cb (self, _sender, pspec);
}


static void rygel_gst_av_transport_real_constructed (GObject* base) {
	RygelGstAVTransport * self;
	RygelGstChangeLog* _tmp0_;
	RygelGstPlayer* _tmp1_;
	self = (RygelGstAVTransport*) base;
	self->priv->changelog = (_tmp0_ = rygel_gst_change_log_new ((GUPnPService*) self, RYGEL_GST_AV_TRANSPORT_LAST_CHANGE_NS), _g_object_unref0 (self->priv->changelog), _tmp0_);
	self->priv->player = (_tmp1_ = rygel_gst_player_get_default (), _g_object_unref0 (self->priv->player), _tmp1_);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_gst_av_transport_query_last_change_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetAVTransportURI", (GCallback) _rygel_gst_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMediaInfo", (GCallback) _rygel_gst_av_transport_get_media_info_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportInfo", (GCallback) _rygel_gst_av_transport_get_transport_info_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetPositionInfo", (GCallback) _rygel_gst_av_transport_get_position_info_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetDeviceCapabilities", (GCallback) _rygel_gst_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportSettings", (GCallback) _rygel_gst_av_transport_get_transport_settings_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Stop", (GCallback) _rygel_gst_av_transport_stop_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Play", (GCallback) _rygel_gst_av_transport_play_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Pause", (GCallback) _rygel_gst_av_transport_pause_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Seek", (GCallback) _rygel_gst_av_transport_seek_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Next", (GCallback) _rygel_gst_av_transport_next_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Previous", (GCallback) _rygel_gst_av_transport_previous_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GObject*) self->priv->player, "notify::playback-state", (GCallback) _rygel_gst_av_transport_notify_state_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self->priv->player, "notify::duration", (GCallback) _rygel_gst_av_transport_notify_duration_cb_g_object_notify, self, 0);
}


static void rygel_gst_av_transport_query_last_change_cb (RygelGstAVTransport* self, GUPnPService* service, const char* variable, GValue* value) {
	RygelGstChangeLog* log;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (variable != NULL);
	log = rygel_gst_change_log_new (NULL, RYGEL_GST_AV_TRANSPORT_LAST_CHANGE_NS);
	rygel_gst_change_log_log (log, "TransportState", rygel_gst_player_get_playback_state (self->priv->player));
	rygel_gst_change_log_log (log, "TransportStatus", rygel_gst_av_transport_get_status (self));
	rygel_gst_change_log_log (log, "PlaybackStorageMedium", "NOT_IMPLEMENTED");
	rygel_gst_change_log_log (log, "RecordStorageMedium", "NOT_IMPLEMENTED");
	rygel_gst_change_log_log (log, "PossiblePlaybackStorageMedia", "NOT_IMPLEMENTED");
	rygel_gst_change_log_log (log, "PossibleRecordStorageMedia", "NOT_IMPLEMENTED");
	rygel_gst_change_log_log (log, "CurrentPlayMode", rygel_gst_av_transport_get_mode (self));
	rygel_gst_change_log_log (log, "TransportPlaySpeed", rygel_gst_av_transport_get_speed (self));
	rygel_gst_change_log_log (log, "RecordMediumWriteStatus", "NOT_IMPLEMENTED");
	rygel_gst_change_log_log (log, "CurrentRecordQualityMode", "NOT_IMPLEMENTED");
	rygel_gst_change_log_log (log, "PossibleRecordQualityMode", "NOT_IMPLEMENTED");
	rygel_gst_change_log_log (log, "NumberOfTracks", _tmp0_ = g_strdup_printf ("%u", rygel_gst_av_transport_get_n_tracks (self)));
	_g_free0 (_tmp0_);
	rygel_gst_change_log_log (log, "CurrentTrack", _tmp1_ = g_strdup_printf ("%u", rygel_gst_av_transport_get_track (self)));
	_g_free0 (_tmp1_);
	rygel_gst_change_log_log (log, "CurrentTrackDuration", _tmp2_ = rygel_gst_player_get_duration (self->priv->player));
	_g_free0 (_tmp2_);
	rygel_gst_change_log_log (log, "CurrentMediaDuration", _tmp3_ = rygel_gst_player_get_duration (self->priv->player));
	_g_free0 (_tmp3_);
	rygel_gst_change_log_log (log, "CurrentTrackMetadata", _tmp4_ = rygel_gst_av_transport_get_metadata (self));
	_g_free0 (_tmp4_);
	rygel_gst_change_log_log (log, "CurrentTrackURI", _tmp5_ = rygel_gst_av_transport_get_uri (self));
	_g_free0 (_tmp5_);
	rygel_gst_change_log_log (log, "AVTransportURI", _tmp6_ = rygel_gst_av_transport_get_uri (self));
	_g_free0 (_tmp6_);
	rygel_gst_change_log_log (log, "NextAVTransportURI", "NOT_IMPLEMENTED");
	g_value_init (value, G_TYPE_STRING);
	g_value_set_string (value, _tmp7_ = rygel_gst_change_log_finish (log));
	_g_free0 (_tmp7_);
	_g_object_unref0 (log);
}


static gboolean rygel_gst_av_transport_check_instance_id (RygelGstAVTransport* self, GUPnPServiceAction* action) {
	gboolean result;
	guint instance_id = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (action != NULL, FALSE);
	gupnp_service_action_get (action, "InstanceID", G_TYPE_UINT, &instance_id, NULL);
	if (instance_id != 0) {
		gupnp_service_action_return_error (action, (guint) 718, "Invalid InstanceID");
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void rygel_gst_av_transport_set_av_transport_uri_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	char* _uri;
	char* _metadata;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_gst_av_transport_check_instance_id (self, action)) {
		return;
	}
	_uri = NULL;
	_metadata = NULL;
	gupnp_service_action_get (action, "CurrentURI", G_TYPE_STRING, &_uri, "CurrentURIMetaData", G_TYPE_STRING, &_metadata, NULL);
	rygel_gst_av_transport_set_uri (self, _uri);
	rygel_gst_av_transport_set_metadata (self, _metadata);
	gupnp_service_action_return (action);
	_g_free0 (_uri);
	_g_free0 (_metadata);
}


static void rygel_gst_av_transport_get_media_info_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_gst_av_transport_check_instance_id (self, action)) {
		return;
	}
	gupnp_service_action_set (action, "NrTracks", G_TYPE_UINT, rygel_gst_av_transport_get_n_tracks (self), "MediaDuration", G_TYPE_STRING, _tmp0_ = rygel_gst_player_get_duration (self->priv->player), "CurrentURI", G_TYPE_STRING, _tmp1_ = rygel_gst_av_transport_get_uri (self), "CurrentURIMetaData", G_TYPE_STRING, _tmp2_ = rygel_gst_av_transport_get_metadata (self), "NextURI", G_TYPE_STRING, "NOT_IMPLEMENTED", "NextURIMetaData", G_TYPE_STRING, "NOT_IMPLEMENTED", "PlayMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecordMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "WriteStatus", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
	gupnp_service_action_return (action);
}


static void rygel_gst_av_transport_get_transport_info_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_gst_av_transport_check_instance_id (self, action)) {
		return;
	}
	gupnp_service_action_set (action, "CurrentTransportState", G_TYPE_STRING, rygel_gst_player_get_playback_state (self->priv->player), "CurrentTransportStatus", G_TYPE_STRING, rygel_gst_av_transport_get_status (self), "CurrentSpeed", G_TYPE_STRING, rygel_gst_av_transport_get_speed (self), NULL);
	gupnp_service_action_return (action);
}


static void rygel_gst_av_transport_get_position_info_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	char* _tmp4_;
	char* _tmp3_;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_gst_av_transport_check_instance_id (self, action)) {
		return;
	}
	gupnp_service_action_set (action, "Track", G_TYPE_UINT, rygel_gst_av_transport_get_track (self), "TrackDuration", G_TYPE_STRING, _tmp0_ = rygel_gst_player_get_duration (self->priv->player), "TrackMetaData", G_TYPE_STRING, _tmp1_ = rygel_gst_av_transport_get_metadata (self), "TrackURI", G_TYPE_STRING, _tmp2_ = rygel_gst_av_transport_get_uri (self), "RelTime", G_TYPE_STRING, _tmp3_ = rygel_gst_player_get_position (self->priv->player), "AbsTime", G_TYPE_STRING, _tmp4_ = rygel_gst_player_get_position (self->priv->player), "RelCount", G_TYPE_INT, G_MAXINT, "AbsCount", G_TYPE_INT, G_MAXINT, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
	gupnp_service_action_return (action);
}


static void rygel_gst_av_transport_get_device_capabilities_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_gst_av_transport_check_instance_id (self, action)) {
		return;
	}
	gupnp_service_action_set (action, "PlayMedia", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecMedia", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecQualityModes", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
	gupnp_service_action_return (action);
}


static void rygel_gst_av_transport_get_transport_settings_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_gst_av_transport_check_instance_id (self, action)) {
		return;
	}
	gupnp_service_action_set (action, "PlayMode", G_TYPE_STRING, rygel_gst_av_transport_get_mode (self), "RecQualityMode", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
	gupnp_service_action_return (action);
}


static void rygel_gst_av_transport_stop_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_gst_av_transport_check_instance_id (self, action)) {
		return;
	}
	rygel_gst_player_set_playback_state (self->priv->player, "STOPPED");
	gupnp_service_action_return (action);
}


static void rygel_gst_av_transport_play_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	char* speed;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_gst_av_transport_check_instance_id (self, action)) {
		return;
	}
	speed = NULL;
	gupnp_service_action_get (action, "Speed", G_TYPE_STRING, &speed, NULL);
	if (_vala_strcmp0 (speed, "1") != 0) {
		gupnp_service_action_return_error (action, (guint) 717, "Play speed not supported");
		_g_free0 (speed);
		return;
	}
	rygel_gst_player_set_playback_state (self->priv->player, "PLAYING");
	gupnp_service_action_return (action);
	_g_free0 (speed);
}


static void rygel_gst_av_transport_pause_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_gst_av_transport_check_instance_id (self, action)) {
		return;
	}
	rygel_gst_player_set_playback_state (self->priv->player, "PAUSED_PLAYBACK");
	gupnp_service_action_return (action);
}


static void rygel_gst_av_transport_seek_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	char* unit;
	char* target;
	GQuark _tmp1_;
	const char* _tmp0_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	if (!rygel_gst_av_transport_check_instance_id (self, action)) {
		return;
	}
	unit = NULL;
	target = NULL;
	gupnp_service_action_get (action, "Unit", G_TYPE_STRING, &unit, "Target", G_TYPE_STRING, &target, NULL);
	_tmp0_ = unit;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if ((_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("ABS_TIME")))) || (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("REL_TIME")))))
	do {
		if (!rygel_gst_player_seek (self->priv->player, target)) {
			gupnp_service_action_return_error (action, (guint) 710, "Seek mode not supported");
			_g_free0 (unit);
			_g_free0 (target);
			return;
		}
		gupnp_service_action_return (action);
		_g_free0 (unit);
		_g_free0 (target);
		return;
	} while (0); else
	do {
		gupnp_service_action_return_error (action, (guint) 710, "Seek mode not supported");
		_g_free0 (unit);
		_g_free0 (target);
		return;
	} while (0);
	_g_free0 (unit);
	_g_free0 (target);
}


static void rygel_gst_av_transport_next_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	gupnp_service_action_return_error (action, (guint) 701, "Transition not available");
}


static void rygel_gst_av_transport_previous_cb (RygelGstAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	gupnp_service_action_return_error (action, (guint) 701, "Transition not available");
}


static void rygel_gst_av_transport_notify_state_cb (RygelGstAVTransport* self, GObject* player, GParamSpec* p) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	rygel_gst_change_log_log (self->priv->changelog, "TransportState", rygel_gst_player_get_playback_state (self->priv->player));
}


static void rygel_gst_av_transport_notify_duration_cb (RygelGstAVTransport* self, GObject* window, GParamSpec* p) {
	char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_return_if_fail (p != NULL);
	rygel_gst_change_log_log (self->priv->changelog, "CurrentTrackDuration", _tmp0_ = rygel_gst_player_get_duration (self->priv->player));
	_g_free0 (_tmp0_);
	rygel_gst_change_log_log (self->priv->changelog, "CurrentMediaDuration", _tmp1_ = rygel_gst_player_get_duration (self->priv->player));
	_g_free0 (_tmp1_);
}


RygelGstAVTransport* rygel_gst_av_transport_construct (GType object_type) {
	RygelGstAVTransport * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


RygelGstAVTransport* rygel_gst_av_transport_new (void) {
	return rygel_gst_av_transport_construct (RYGEL_TYPE_GST_AV_TRANSPORT);
}


guint rygel_gst_av_transport_get_n_tracks (RygelGstAVTransport* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_n_tracks;
	return result;
}


void rygel_gst_av_transport_set_n_tracks (RygelGstAVTransport* self, guint value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_n_tracks = value;
	rygel_gst_change_log_log (self->priv->changelog, "NumberOfTracks", _tmp0_ = g_strdup_printf ("%u", self->priv->_n_tracks));
	_g_free0 (_tmp0_);
	g_object_notify ((GObject *) self, "n-tracks");
}


guint rygel_gst_av_transport_get_track (RygelGstAVTransport* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_track;
	return result;
}


void rygel_gst_av_transport_set_track (RygelGstAVTransport* self, guint value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_track = value;
	rygel_gst_change_log_log (self->priv->changelog, "CurrentTrack", _tmp0_ = g_strdup_printf ("%u", self->priv->_track));
	_g_free0 (_tmp0_);
	g_object_notify ((GObject *) self, "track");
}


char* rygel_gst_av_transport_get_metadata (RygelGstAVTransport* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_metadata != NULL) {
		result = g_markup_escape_text (self->priv->_metadata, -1);
		return result;
	} else {
		result = g_strdup ("");
		return result;
	}
}


void rygel_gst_av_transport_set_metadata (RygelGstAVTransport* self, const char* value) {
	char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_metadata = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_metadata), _tmp0_);
	rygel_gst_change_log_log (self->priv->changelog, "CurrentTrackMetadata", _tmp1_ = rygel_gst_av_transport_get_metadata (self));
	_g_free0 (_tmp1_);
	g_object_notify ((GObject *) self, "metadata");
}


char* rygel_gst_av_transport_get_uri (RygelGstAVTransport* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (rygel_gst_player_get_uri (self->priv->player) != NULL) {
		result = g_markup_escape_text (rygel_gst_player_get_uri (self->priv->player), -1);
		return result;
	} else {
		result = g_strdup ("");
		return result;
	}
}


void rygel_gst_av_transport_set_uri (RygelGstAVTransport* self, const char* value) {
	char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	rygel_gst_player_set_uri (self->priv->player, value);
	rygel_gst_change_log_log (self->priv->changelog, "CurrentTrackURI", _tmp0_ = rygel_gst_av_transport_get_uri (self));
	_g_free0 (_tmp0_);
	rygel_gst_change_log_log (self->priv->changelog, "AVTransportURI", _tmp1_ = rygel_gst_av_transport_get_uri (self));
	_g_free0 (_tmp1_);
	g_object_notify ((GObject *) self, "uri");
}


const char* rygel_gst_av_transport_get_status (RygelGstAVTransport* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_status;
	return result;
}


void rygel_gst_av_transport_set_status (RygelGstAVTransport* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_status = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_status), _tmp0_);
	rygel_gst_change_log_log (self->priv->changelog, "TransportStatus", self->priv->_status);
	g_object_notify ((GObject *) self, "status");
}


const char* rygel_gst_av_transport_get_speed (RygelGstAVTransport* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_speed;
	return result;
}


void rygel_gst_av_transport_set_speed (RygelGstAVTransport* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_speed = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_speed), _tmp0_);
	rygel_gst_change_log_log (self->priv->changelog, "TransportPlaySpeed", self->priv->_speed);
	g_object_notify ((GObject *) self, "speed");
}


const char* rygel_gst_av_transport_get_mode (RygelGstAVTransport* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_mode;
	return result;
}


void rygel_gst_av_transport_set_mode (RygelGstAVTransport* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_mode = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_mode), _tmp0_);
	rygel_gst_change_log_log (self->priv->changelog, "CurrentPlayMode", self->priv->_mode);
	g_object_notify ((GObject *) self, "mode");
}


static void rygel_gst_av_transport_class_init (RygelGstAVTransportClass * klass) {
	rygel_gst_av_transport_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelGstAVTransportPrivate));
	G_OBJECT_CLASS (klass)->constructed = rygel_gst_av_transport_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = rygel_gst_av_transport_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_gst_av_transport_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_av_transport_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_AV_TRANSPORT_N_TRACKS, g_param_spec_uint ("n-tracks", "n-tracks", "n-tracks", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_AV_TRANSPORT_TRACK, g_param_spec_uint ("track", "track", "track", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_AV_TRANSPORT_METADATA, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_AV_TRANSPORT_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_AV_TRANSPORT_STATUS, g_param_spec_string ("status", "status", "status", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_AV_TRANSPORT_SPEED, g_param_spec_string ("speed", "speed", "speed", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_AV_TRANSPORT_MODE, g_param_spec_string ("mode", "mode", "mode", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_gst_av_transport_instance_init (RygelGstAVTransport * self) {
	self->priv = RYGEL_GST_AV_TRANSPORT_GET_PRIVATE (self);
	self->priv->_n_tracks = (guint) 0;
	self->priv->_track = (guint) 0;
	self->priv->_metadata = g_strdup ("");
	self->priv->_status = g_strdup ("OK");
	self->priv->_speed = g_strdup ("1");
	self->priv->_mode = g_strdup ("NORMAL");
}


static void rygel_gst_av_transport_finalize (GObject* obj) {
	RygelGstAVTransport * self;
	self = RYGEL_GST_AV_TRANSPORT (obj);
	_g_free0 (self->priv->_metadata);
	_g_free0 (self->priv->_status);
	_g_free0 (self->priv->_speed);
	_g_free0 (self->priv->_mode);
	_g_object_unref0 (self->priv->changelog);
	_g_object_unref0 (self->priv->player);
	G_OBJECT_CLASS (rygel_gst_av_transport_parent_class)->finalize (obj);
}


GType rygel_gst_av_transport_get_type (void) {
	static GType rygel_gst_av_transport_type_id = 0;
	if (rygel_gst_av_transport_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstAVTransportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_av_transport_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstAVTransport), 0, (GInstanceInitFunc) rygel_gst_av_transport_instance_init, NULL };
		rygel_gst_av_transport_type_id = g_type_register_static (GUPNP_TYPE_SERVICE, "RygelGstAVTransport", &g_define_type_info, 0);
	}
	return rygel_gst_av_transport_type_id;
}


static void rygel_gst_av_transport_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelGstAVTransport * self;
	self = RYGEL_GST_AV_TRANSPORT (object);
	switch (property_id) {
		case RYGEL_GST_AV_TRANSPORT_N_TRACKS:
		g_value_set_uint (value, rygel_gst_av_transport_get_n_tracks (self));
		break;
		case RYGEL_GST_AV_TRANSPORT_TRACK:
		g_value_set_uint (value, rygel_gst_av_transport_get_track (self));
		break;
		case RYGEL_GST_AV_TRANSPORT_METADATA:
		g_value_set_string (value, rygel_gst_av_transport_get_metadata (self));
		break;
		case RYGEL_GST_AV_TRANSPORT_URI:
		g_value_set_string (value, rygel_gst_av_transport_get_uri (self));
		break;
		case RYGEL_GST_AV_TRANSPORT_STATUS:
		g_value_set_string (value, rygel_gst_av_transport_get_status (self));
		break;
		case RYGEL_GST_AV_TRANSPORT_SPEED:
		g_value_set_string (value, rygel_gst_av_transport_get_speed (self));
		break;
		case RYGEL_GST_AV_TRANSPORT_MODE:
		g_value_set_string (value, rygel_gst_av_transport_get_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_gst_av_transport_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelGstAVTransport * self;
	self = RYGEL_GST_AV_TRANSPORT (object);
	switch (property_id) {
		case RYGEL_GST_AV_TRANSPORT_N_TRACKS:
		rygel_gst_av_transport_set_n_tracks (self, g_value_get_uint (value));
		break;
		case RYGEL_GST_AV_TRANSPORT_TRACK:
		rygel_gst_av_transport_set_track (self, g_value_get_uint (value));
		break;
		case RYGEL_GST_AV_TRANSPORT_METADATA:
		rygel_gst_av_transport_set_metadata (self, g_value_get_string (value));
		break;
		case RYGEL_GST_AV_TRANSPORT_URI:
		rygel_gst_av_transport_set_uri (self, g_value_get_string (value));
		break;
		case RYGEL_GST_AV_TRANSPORT_STATUS:
		rygel_gst_av_transport_set_status (self, g_value_get_string (value));
		break;
		case RYGEL_GST_AV_TRANSPORT_SPEED:
		rygel_gst_av_transport_set_speed (self, g_value_get_string (value));
		break;
		case RYGEL_GST_AV_TRANSPORT_MODE:
		rygel_gst_av_transport_set_mode (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




