/* rygel-external-interfaces.c generated by valac, the Vala compiler
 * generated from rygel-external-interfaces.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <dbus/dbus.h>


#define RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT (rygel_external_media_object_get_type ())
#define RYGEL_EXTERNAL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT, RygelExternalMediaObject))
#define RYGEL_IS_EXTERNAL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT))
#define RYGEL_EXTERNAL_MEDIA_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT, RygelExternalMediaObjectIface))

typedef struct _RygelExternalMediaObject RygelExternalMediaObject;
typedef struct _RygelExternalMediaObjectIface RygelExternalMediaObjectIface;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelExternalMediaObjectDBusProxy RygelExternalMediaObjectDBusProxy;
typedef DBusGProxyClass RygelExternalMediaObjectDBusProxyClass;

#define RYGEL_TYPE_EXTERNAL_MEDIA_CONTAINER (rygel_external_media_container_get_type ())
#define RYGEL_EXTERNAL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_CONTAINER, RygelExternalMediaContainer))
#define RYGEL_IS_EXTERNAL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_CONTAINER))
#define RYGEL_EXTERNAL_MEDIA_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_CONTAINER, RygelExternalMediaContainerIface))

typedef struct _RygelExternalMediaContainer RygelExternalMediaContainer;
typedef struct _RygelExternalMediaContainerIface RygelExternalMediaContainerIface;
typedef struct _RygelExternalMediaContainerDBusProxy RygelExternalMediaContainerDBusProxy;
typedef DBusGProxyClass RygelExternalMediaContainerDBusProxyClass;

#define RYGEL_TYPE_EXTERNAL_MEDIA_ITEM (rygel_external_media_item_get_type ())
#define RYGEL_EXTERNAL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_ITEM, RygelExternalMediaItem))
#define RYGEL_IS_EXTERNAL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_ITEM))
#define RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_ITEM, RygelExternalMediaItemIface))

typedef struct _RygelExternalMediaItem RygelExternalMediaItem;
typedef struct _RygelExternalMediaItemIface RygelExternalMediaItemIface;
typedef struct _RygelExternalMediaItemDBusProxy RygelExternalMediaItemDBusProxy;
typedef DBusGProxyClass RygelExternalMediaItemDBusProxyClass;

#define FREE_DESKTOP_TYPE_DBUS_OBJECT (free_desktop_dbus_object_get_type ())
#define FREE_DESKTOP_DBUS_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FREE_DESKTOP_TYPE_DBUS_OBJECT, FreeDesktopDBusObject))
#define FREE_DESKTOP_IS_DBUS_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FREE_DESKTOP_TYPE_DBUS_OBJECT))
#define FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FREE_DESKTOP_TYPE_DBUS_OBJECT, FreeDesktopDBusObjectIface))

typedef struct _FreeDesktopDBusObject FreeDesktopDBusObject;
typedef struct _FreeDesktopDBusObjectIface FreeDesktopDBusObjectIface;
typedef struct _FreeDesktopDBusObjectDBusProxy FreeDesktopDBusObjectDBusProxy;
typedef DBusGProxyClass FreeDesktopDBusObjectDBusProxyClass;
typedef struct _FreeDesktopDBusObjectDBusProxyListNamesData FreeDesktopDBusObjectDBusProxyListNamesData;
typedef struct _FreeDesktopDBusObjectDBusProxyListActivatableNamesData FreeDesktopDBusObjectDBusProxyListActivatableNamesData;

#define FREE_DESKTOP_TYPE_PROPERTIES (free_desktop_properties_get_type ())
#define FREE_DESKTOP_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FREE_DESKTOP_TYPE_PROPERTIES, FreeDesktopProperties))
#define FREE_DESKTOP_IS_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FREE_DESKTOP_TYPE_PROPERTIES))
#define FREE_DESKTOP_PROPERTIES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FREE_DESKTOP_TYPE_PROPERTIES, FreeDesktopPropertiesIface))

typedef struct _FreeDesktopProperties FreeDesktopProperties;
typedef struct _FreeDesktopPropertiesIface FreeDesktopPropertiesIface;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _FreeDesktopPropertiesDBusProxy FreeDesktopPropertiesDBusProxy;
typedef DBusGProxyClass FreeDesktopPropertiesDBusProxyClass;
typedef struct _FreeDesktopPropertiesDBusProxyGetAllData FreeDesktopPropertiesDBusProxyGetAllData;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _RygelExternalMediaObjectIface {
	GTypeInterface parent_iface;
	char* (*get_parent) (RygelExternalMediaObject* self);
	void (*set_parent) (RygelExternalMediaObject* self, const char* value);
	char* (*get_display_name) (RygelExternalMediaObject* self);
	void (*set_display_name) (RygelExternalMediaObject* self, const char* value);
};

struct _RygelExternalMediaObjectDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _RygelExternalMediaContainerIface {
	GTypeInterface parent_iface;
	char** (*get_items) (RygelExternalMediaContainer* self, int* result_length1);
	void (*set_items) (RygelExternalMediaContainer* self, char** value, int value_length1);
	char** (*get_containers) (RygelExternalMediaContainer* self, int* result_length1);
	void (*set_containers) (RygelExternalMediaContainer* self, char** value, int value_length1);
	guint (*get_item_count) (RygelExternalMediaContainer* self);
	void (*set_item_count) (RygelExternalMediaContainer* self, guint value);
	guint (*get_container_count) (RygelExternalMediaContainer* self);
	void (*set_container_count) (RygelExternalMediaContainer* self, guint value);
	char* (*get_icon) (RygelExternalMediaContainer* self);
	void (*set_icon) (RygelExternalMediaContainer* self, const char* value);
};

struct _RygelExternalMediaContainerDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _RygelExternalMediaItemIface {
	GTypeInterface parent_iface;
	char** (*get_urls) (RygelExternalMediaItem* self, int* result_length1);
	void (*set_urls) (RygelExternalMediaItem* self, char** value, int value_length1);
	char* (*get_mime_type) (RygelExternalMediaItem* self);
	void (*set_mime_type) (RygelExternalMediaItem* self, const char* value);
	char* (*get_media_type) (RygelExternalMediaItem* self);
	void (*set_media_type) (RygelExternalMediaItem* self, const char* value);
	gint (*get_size) (RygelExternalMediaItem* self);
	void (*set_size) (RygelExternalMediaItem* self, gint value);
	char* (*get_artist) (RygelExternalMediaItem* self);
	void (*set_artist) (RygelExternalMediaItem* self, const char* value);
	char* (*get_album) (RygelExternalMediaItem* self);
	void (*set_album) (RygelExternalMediaItem* self, const char* value);
	char* (*get_date) (RygelExternalMediaItem* self);
	void (*set_date) (RygelExternalMediaItem* self, const char* value);
	char* (*get_genre) (RygelExternalMediaItem* self);
	void (*set_genre) (RygelExternalMediaItem* self, const char* value);
	char* (*get_dlna_profile) (RygelExternalMediaItem* self);
	void (*set_dlna_profile) (RygelExternalMediaItem* self, const char* value);
	gint (*get_duration) (RygelExternalMediaItem* self);
	void (*set_duration) (RygelExternalMediaItem* self, gint value);
	gint (*get_bitrate) (RygelExternalMediaItem* self);
	void (*set_bitrate) (RygelExternalMediaItem* self, gint value);
	gint (*get_sample_rate) (RygelExternalMediaItem* self);
	void (*set_sample_rate) (RygelExternalMediaItem* self, gint value);
	gint (*get_bits_per_sample) (RygelExternalMediaItem* self);
	void (*set_bits_per_sample) (RygelExternalMediaItem* self, gint value);
	gint (*get_width) (RygelExternalMediaItem* self);
	void (*set_width) (RygelExternalMediaItem* self, gint value);
	gint (*get_height) (RygelExternalMediaItem* self);
	void (*set_height) (RygelExternalMediaItem* self, gint value);
	gint (*get_color_depth) (RygelExternalMediaItem* self);
	void (*set_color_depth) (RygelExternalMediaItem* self, gint value);
	char* (*get_thumbnail) (RygelExternalMediaItem* self);
	void (*set_thumbnail) (RygelExternalMediaItem* self, const char* value);
	char* (*get_album_art) (RygelExternalMediaItem* self);
	void (*set_album_art) (RygelExternalMediaItem* self, const char* value);
};

struct _RygelExternalMediaItemDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _FreeDesktopDBusObjectIface {
	GTypeInterface parent_iface;
	void (*list_names) (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*list_names_finish) (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*list_activatable_names) (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*list_activatable_names_finish) (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
};

struct _FreeDesktopDBusObjectDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _FreeDesktopDBusObjectDBusProxyListNamesData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _FreeDesktopDBusObjectDBusProxyListActivatableNamesData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _FreeDesktopPropertiesIface {
	GTypeInterface parent_iface;
	void (*get_all) (FreeDesktopProperties* self, const char* iface, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*get_all_finish) (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error);
};

struct _FreeDesktopPropertiesDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _FreeDesktopPropertiesDBusProxyGetAllData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



GType rygel_external_media_object_get_type (void);
char* rygel_external_media_object_get_parent (RygelExternalMediaObject* self);
void rygel_external_media_object_set_parent (RygelExternalMediaObject* self, const char* value);
char* rygel_external_media_object_get_display_name (RygelExternalMediaObject* self);
void rygel_external_media_object_set_display_name (RygelExternalMediaObject* self, const char* value);
void rygel_external_media_object_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _rygel_external_media_object_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult rygel_external_media_object_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_rygel_external_media_object_introspect (RygelExternalMediaObject* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_external_media_object_property_get (RygelExternalMediaObject* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_external_media_object_property_set (RygelExternalMediaObject* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_external_media_object_property_get_all (RygelExternalMediaObject* self, DBusConnection* connection, DBusMessage* message);
GType rygel_external_media_object_dbus_proxy_get_type (void);
RygelExternalMediaObject* rygel_external_media_object_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
DBusHandlerResult rygel_external_media_object_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	RYGEL_EXTERNAL_MEDIA_OBJECT_DBUS_PROXY_DUMMY_PROPERTY,
	RYGEL_EXTERNAL_MEDIA_OBJECT_DBUS_PROXY_PARENT,
	RYGEL_EXTERNAL_MEDIA_OBJECT_DBUS_PROXY_DISPLAY_NAME
};
static char* rygel_external_media_object_dbus_proxy_get_parent (RygelExternalMediaObject* self);
static void rygel_external_media_object_dbus_proxy_set_parent (RygelExternalMediaObject* self, const char* value);
static char* rygel_external_media_object_dbus_proxy_get_display_name (RygelExternalMediaObject* self);
static void rygel_external_media_object_dbus_proxy_set_display_name (RygelExternalMediaObject* self, const char* value);
static void rygel_external_media_object_dbus_proxy_rygel_external_media_object__interface_init (RygelExternalMediaObjectIface* iface);
static void rygel_external_media_object_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_external_media_object_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType rygel_external_media_container_get_type (void);
char** rygel_external_media_container_get_items (RygelExternalMediaContainer* self, int* result_length1);
void rygel_external_media_container_set_items (RygelExternalMediaContainer* self, char** value, int value_length1);
char** rygel_external_media_container_get_containers (RygelExternalMediaContainer* self, int* result_length1);
void rygel_external_media_container_set_containers (RygelExternalMediaContainer* self, char** value, int value_length1);
guint rygel_external_media_container_get_item_count (RygelExternalMediaContainer* self);
void rygel_external_media_container_set_item_count (RygelExternalMediaContainer* self, guint value);
guint rygel_external_media_container_get_container_count (RygelExternalMediaContainer* self);
void rygel_external_media_container_set_container_count (RygelExternalMediaContainer* self, guint value);
char* rygel_external_media_container_get_icon (RygelExternalMediaContainer* self);
void rygel_external_media_container_set_icon (RygelExternalMediaContainer* self, const char* value);
void rygel_external_media_container_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _rygel_external_media_container_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult rygel_external_media_container_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_rygel_external_media_container_introspect (RygelExternalMediaContainer* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_external_media_container_property_get (RygelExternalMediaContainer* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_external_media_container_property_set (RygelExternalMediaContainer* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_external_media_container_property_get_all (RygelExternalMediaContainer* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_rygel_external_media_container_updated (GObject* _sender, DBusConnection* _connection);
GType rygel_external_media_container_dbus_proxy_get_type (void);
RygelExternalMediaContainer* rygel_external_media_container_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
static void _dbus_handle_rygel_external_media_container_updated (RygelExternalMediaContainer* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult rygel_external_media_container_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	RYGEL_EXTERNAL_MEDIA_CONTAINER_DBUS_PROXY_DUMMY_PROPERTY,
	RYGEL_EXTERNAL_MEDIA_CONTAINER_DBUS_PROXY_PARENT,
	RYGEL_EXTERNAL_MEDIA_CONTAINER_DBUS_PROXY_DISPLAY_NAME,
	RYGEL_EXTERNAL_MEDIA_CONTAINER_DBUS_PROXY_ITEM_COUNT,
	RYGEL_EXTERNAL_MEDIA_CONTAINER_DBUS_PROXY_CONTAINER_COUNT,
	RYGEL_EXTERNAL_MEDIA_CONTAINER_DBUS_PROXY_ICON
};
static char* rygel_external_media_container_dbus_proxy_get_parent (RygelExternalMediaObject* self);
static void rygel_external_media_container_dbus_proxy_set_parent (RygelExternalMediaObject* self, const char* value);
static char* rygel_external_media_container_dbus_proxy_get_display_name (RygelExternalMediaObject* self);
static void rygel_external_media_container_dbus_proxy_set_display_name (RygelExternalMediaObject* self, const char* value);
static void rygel_external_media_container_dbus_proxy_rygel_external_media_object__interface_init (RygelExternalMediaObjectIface* iface);
static char** rygel_external_media_container_dbus_proxy_get_items (RygelExternalMediaContainer* self, int* result_length1);
static void rygel_external_media_container_dbus_proxy_set_items (RygelExternalMediaContainer* self, char** value, int value_length1);
static char** rygel_external_media_container_dbus_proxy_get_containers (RygelExternalMediaContainer* self, int* result_length1);
static void rygel_external_media_container_dbus_proxy_set_containers (RygelExternalMediaContainer* self, char** value, int value_length1);
static guint rygel_external_media_container_dbus_proxy_get_item_count (RygelExternalMediaContainer* self);
static void rygel_external_media_container_dbus_proxy_set_item_count (RygelExternalMediaContainer* self, guint value);
static guint rygel_external_media_container_dbus_proxy_get_container_count (RygelExternalMediaContainer* self);
static void rygel_external_media_container_dbus_proxy_set_container_count (RygelExternalMediaContainer* self, guint value);
static char* rygel_external_media_container_dbus_proxy_get_icon (RygelExternalMediaContainer* self);
static void rygel_external_media_container_dbus_proxy_set_icon (RygelExternalMediaContainer* self, const char* value);
static void rygel_external_media_container_dbus_proxy_rygel_external_media_container__interface_init (RygelExternalMediaContainerIface* iface);
static void rygel_external_media_container_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_external_media_container_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType rygel_external_media_item_get_type (void);
char** rygel_external_media_item_get_urls (RygelExternalMediaItem* self, int* result_length1);
void rygel_external_media_item_set_urls (RygelExternalMediaItem* self, char** value, int value_length1);
char* rygel_external_media_item_get_mime_type (RygelExternalMediaItem* self);
void rygel_external_media_item_set_mime_type (RygelExternalMediaItem* self, const char* value);
char* rygel_external_media_item_get_media_type (RygelExternalMediaItem* self);
void rygel_external_media_item_set_media_type (RygelExternalMediaItem* self, const char* value);
gint rygel_external_media_item_get_size (RygelExternalMediaItem* self);
void rygel_external_media_item_set_size (RygelExternalMediaItem* self, gint value);
char* rygel_external_media_item_get_artist (RygelExternalMediaItem* self);
void rygel_external_media_item_set_artist (RygelExternalMediaItem* self, const char* value);
char* rygel_external_media_item_get_album (RygelExternalMediaItem* self);
void rygel_external_media_item_set_album (RygelExternalMediaItem* self, const char* value);
char* rygel_external_media_item_get_date (RygelExternalMediaItem* self);
void rygel_external_media_item_set_date (RygelExternalMediaItem* self, const char* value);
char* rygel_external_media_item_get_genre (RygelExternalMediaItem* self);
void rygel_external_media_item_set_genre (RygelExternalMediaItem* self, const char* value);
char* rygel_external_media_item_get_dlna_profile (RygelExternalMediaItem* self);
void rygel_external_media_item_set_dlna_profile (RygelExternalMediaItem* self, const char* value);
gint rygel_external_media_item_get_duration (RygelExternalMediaItem* self);
void rygel_external_media_item_set_duration (RygelExternalMediaItem* self, gint value);
gint rygel_external_media_item_get_bitrate (RygelExternalMediaItem* self);
void rygel_external_media_item_set_bitrate (RygelExternalMediaItem* self, gint value);
gint rygel_external_media_item_get_sample_rate (RygelExternalMediaItem* self);
void rygel_external_media_item_set_sample_rate (RygelExternalMediaItem* self, gint value);
gint rygel_external_media_item_get_bits_per_sample (RygelExternalMediaItem* self);
void rygel_external_media_item_set_bits_per_sample (RygelExternalMediaItem* self, gint value);
gint rygel_external_media_item_get_width (RygelExternalMediaItem* self);
void rygel_external_media_item_set_width (RygelExternalMediaItem* self, gint value);
gint rygel_external_media_item_get_height (RygelExternalMediaItem* self);
void rygel_external_media_item_set_height (RygelExternalMediaItem* self, gint value);
gint rygel_external_media_item_get_color_depth (RygelExternalMediaItem* self);
void rygel_external_media_item_set_color_depth (RygelExternalMediaItem* self, gint value);
char* rygel_external_media_item_get_thumbnail (RygelExternalMediaItem* self);
void rygel_external_media_item_set_thumbnail (RygelExternalMediaItem* self, const char* value);
char* rygel_external_media_item_get_album_art (RygelExternalMediaItem* self);
void rygel_external_media_item_set_album_art (RygelExternalMediaItem* self, const char* value);
void rygel_external_media_item_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _rygel_external_media_item_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult rygel_external_media_item_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_rygel_external_media_item_introspect (RygelExternalMediaItem* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_external_media_item_property_get (RygelExternalMediaItem* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_external_media_item_property_set (RygelExternalMediaItem* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_external_media_item_property_get_all (RygelExternalMediaItem* self, DBusConnection* connection, DBusMessage* message);
GType rygel_external_media_item_dbus_proxy_get_type (void);
RygelExternalMediaItem* rygel_external_media_item_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
DBusHandlerResult rygel_external_media_item_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_DUMMY_PROPERTY,
	RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_PARENT,
	RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_DISPLAY_NAME,
	RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_MIME_TYPE,
	RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_MEDIA_TYPE,
	RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_SIZE,
	RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_ARTIST,
	RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_ALBUM,
	RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_DATE,
	RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_GENRE,
	RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_DLNA_PROFILE,
	RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_DURATION,
	RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_BITRATE,
	RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_SAMPLE_RATE,
	RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_BITS_PER_SAMPLE,
	RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_WIDTH,
	RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_HEIGHT,
	RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_COLOR_DEPTH,
	RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_THUMBNAIL,
	RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_ALBUM_ART
};
static char* rygel_external_media_item_dbus_proxy_get_parent (RygelExternalMediaObject* self);
static void rygel_external_media_item_dbus_proxy_set_parent (RygelExternalMediaObject* self, const char* value);
static char* rygel_external_media_item_dbus_proxy_get_display_name (RygelExternalMediaObject* self);
static void rygel_external_media_item_dbus_proxy_set_display_name (RygelExternalMediaObject* self, const char* value);
static void rygel_external_media_item_dbus_proxy_rygel_external_media_object__interface_init (RygelExternalMediaObjectIface* iface);
static char** rygel_external_media_item_dbus_proxy_get_urls (RygelExternalMediaItem* self, int* result_length1);
static void rygel_external_media_item_dbus_proxy_set_urls (RygelExternalMediaItem* self, char** value, int value_length1);
static char* rygel_external_media_item_dbus_proxy_get_mime_type (RygelExternalMediaItem* self);
static void rygel_external_media_item_dbus_proxy_set_mime_type (RygelExternalMediaItem* self, const char* value);
static char* rygel_external_media_item_dbus_proxy_get_media_type (RygelExternalMediaItem* self);
static void rygel_external_media_item_dbus_proxy_set_media_type (RygelExternalMediaItem* self, const char* value);
static gint rygel_external_media_item_dbus_proxy_get_size (RygelExternalMediaItem* self);
static void rygel_external_media_item_dbus_proxy_set_size (RygelExternalMediaItem* self, gint value);
static char* rygel_external_media_item_dbus_proxy_get_artist (RygelExternalMediaItem* self);
static void rygel_external_media_item_dbus_proxy_set_artist (RygelExternalMediaItem* self, const char* value);
static char* rygel_external_media_item_dbus_proxy_get_album (RygelExternalMediaItem* self);
static void rygel_external_media_item_dbus_proxy_set_album (RygelExternalMediaItem* self, const char* value);
static char* rygel_external_media_item_dbus_proxy_get_date (RygelExternalMediaItem* self);
static void rygel_external_media_item_dbus_proxy_set_date (RygelExternalMediaItem* self, const char* value);
static char* rygel_external_media_item_dbus_proxy_get_genre (RygelExternalMediaItem* self);
static void rygel_external_media_item_dbus_proxy_set_genre (RygelExternalMediaItem* self, const char* value);
static char* rygel_external_media_item_dbus_proxy_get_dlna_profile (RygelExternalMediaItem* self);
static void rygel_external_media_item_dbus_proxy_set_dlna_profile (RygelExternalMediaItem* self, const char* value);
static gint rygel_external_media_item_dbus_proxy_get_duration (RygelExternalMediaItem* self);
static void rygel_external_media_item_dbus_proxy_set_duration (RygelExternalMediaItem* self, gint value);
static gint rygel_external_media_item_dbus_proxy_get_bitrate (RygelExternalMediaItem* self);
static void rygel_external_media_item_dbus_proxy_set_bitrate (RygelExternalMediaItem* self, gint value);
static gint rygel_external_media_item_dbus_proxy_get_sample_rate (RygelExternalMediaItem* self);
static void rygel_external_media_item_dbus_proxy_set_sample_rate (RygelExternalMediaItem* self, gint value);
static gint rygel_external_media_item_dbus_proxy_get_bits_per_sample (RygelExternalMediaItem* self);
static void rygel_external_media_item_dbus_proxy_set_bits_per_sample (RygelExternalMediaItem* self, gint value);
static gint rygel_external_media_item_dbus_proxy_get_width (RygelExternalMediaItem* self);
static void rygel_external_media_item_dbus_proxy_set_width (RygelExternalMediaItem* self, gint value);
static gint rygel_external_media_item_dbus_proxy_get_height (RygelExternalMediaItem* self);
static void rygel_external_media_item_dbus_proxy_set_height (RygelExternalMediaItem* self, gint value);
static gint rygel_external_media_item_dbus_proxy_get_color_depth (RygelExternalMediaItem* self);
static void rygel_external_media_item_dbus_proxy_set_color_depth (RygelExternalMediaItem* self, gint value);
static char* rygel_external_media_item_dbus_proxy_get_thumbnail (RygelExternalMediaItem* self);
static void rygel_external_media_item_dbus_proxy_set_thumbnail (RygelExternalMediaItem* self, const char* value);
static char* rygel_external_media_item_dbus_proxy_get_album_art (RygelExternalMediaItem* self);
static void rygel_external_media_item_dbus_proxy_set_album_art (RygelExternalMediaItem* self, const char* value);
static void rygel_external_media_item_dbus_proxy_rygel_external_media_item__interface_init (RygelExternalMediaItemIface* iface);
static void rygel_external_media_item_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_external_media_item_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType free_desktop_dbus_object_get_type (void);
void free_desktop_dbus_object_list_names (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
char** free_desktop_dbus_object_list_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
void free_desktop_dbus_object_list_activatable_names (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
char** free_desktop_dbus_object_list_activatable_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
void free_desktop_dbus_object_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _free_desktop_dbus_object_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult free_desktop_dbus_object_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_free_desktop_dbus_object_introspect (FreeDesktopDBusObject* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_free_desktop_dbus_object_property_get_all (FreeDesktopDBusObject* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_free_desktop_dbus_object_list_names (FreeDesktopDBusObject* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_free_desktop_dbus_object_list_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static DBusHandlerResult _dbus_free_desktop_dbus_object_list_activatable_names (FreeDesktopDBusObject* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_free_desktop_dbus_object_list_activatable_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static void _dbus_free_desktop_dbus_object_name_owner_changed (GObject* _sender, const char* name, const char* old_owner, const char* new_owner, DBusConnection* _connection);
GType free_desktop_dbus_object_dbus_proxy_get_type (void);
FreeDesktopDBusObject* free_desktop_dbus_object_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
static void _dbus_handle_free_desktop_dbus_object_name_owner_changed (FreeDesktopDBusObject* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult free_desktop_dbus_object_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	FREE_DESKTOP_DBUS_OBJECT_DBUS_PROXY_DUMMY_PROPERTY
};
static void free_desktop_dbus_object_dbus_proxy_list_names_async (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void free_desktop_dbus_object_dbus_proxy_list_names_ready (DBusPendingCall* pending, void* user_data);
static char** free_desktop_dbus_object_dbus_proxy_list_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void free_desktop_dbus_object_dbus_proxy_list_activatable_names_async (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void free_desktop_dbus_object_dbus_proxy_list_activatable_names_ready (DBusPendingCall* pending, void* user_data);
static char** free_desktop_dbus_object_dbus_proxy_list_activatable_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void free_desktop_dbus_object_dbus_proxy_free_desktop_dbus_object__interface_init (FreeDesktopDBusObjectIface* iface);
static void free_desktop_dbus_object_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void free_desktop_dbus_object_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType free_desktop_properties_get_type (void);
void free_desktop_properties_get_all (FreeDesktopProperties* self, const char* iface, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* free_desktop_properties_get_all_finish (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error);
void free_desktop_properties_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _free_desktop_properties_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult free_desktop_properties_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_free_desktop_properties_introspect (FreeDesktopProperties* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_free_desktop_properties_property_get_all (FreeDesktopProperties* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_free_desktop_properties_get_all (FreeDesktopProperties* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_free_desktop_properties_get_all_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
GType free_desktop_properties_dbus_proxy_get_type (void);
FreeDesktopProperties* free_desktop_properties_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
DBusHandlerResult free_desktop_properties_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	FREE_DESKTOP_PROPERTIES_DBUS_PROXY_DUMMY_PROPERTY
};
static void free_desktop_properties_dbus_proxy_get_all_async (FreeDesktopProperties* self, const char* iface, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void free_desktop_properties_dbus_proxy_get_all_ready (DBusPendingCall* pending, void* user_data);
static GHashTable* free_desktop_properties_dbus_proxy_get_all_finish (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error);
static void free_desktop_properties_dbus_proxy_free_desktop_properties__interface_init (FreeDesktopPropertiesIface* iface);
static void free_desktop_properties_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void free_desktop_properties_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _rygel_external_media_object_dbus_path_vtable = {_rygel_external_media_object_dbus_unregister, rygel_external_media_object_dbus_message};
static const _DBusObjectVTable _rygel_external_media_object_dbus_vtable = {rygel_external_media_object_dbus_register_object};
static const DBusObjectPathVTable _rygel_external_media_container_dbus_path_vtable = {_rygel_external_media_container_dbus_unregister, rygel_external_media_container_dbus_message};
static const _DBusObjectVTable _rygel_external_media_container_dbus_vtable = {rygel_external_media_container_dbus_register_object};
static const DBusObjectPathVTable _rygel_external_media_item_dbus_path_vtable = {_rygel_external_media_item_dbus_unregister, rygel_external_media_item_dbus_message};
static const _DBusObjectVTable _rygel_external_media_item_dbus_vtable = {rygel_external_media_item_dbus_register_object};
static const DBusObjectPathVTable _free_desktop_dbus_object_dbus_path_vtable = {_free_desktop_dbus_object_dbus_unregister, free_desktop_dbus_object_dbus_message};
static const _DBusObjectVTable _free_desktop_dbus_object_dbus_vtable = {free_desktop_dbus_object_dbus_register_object};
static const DBusObjectPathVTable _free_desktop_properties_dbus_path_vtable = {_free_desktop_properties_dbus_unregister, free_desktop_properties_dbus_message};
static const _DBusObjectVTable _free_desktop_properties_dbus_vtable = {free_desktop_properties_dbus_register_object};

static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

char* rygel_external_media_object_get_parent (RygelExternalMediaObject* self) {
	return RYGEL_EXTERNAL_MEDIA_OBJECT_GET_INTERFACE (self)->get_parent (self);
}


void rygel_external_media_object_set_parent (RygelExternalMediaObject* self, const char* value) {
	RYGEL_EXTERNAL_MEDIA_OBJECT_GET_INTERFACE (self)->set_parent (self, value);
}


char* rygel_external_media_object_get_display_name (RygelExternalMediaObject* self) {
	return RYGEL_EXTERNAL_MEDIA_OBJECT_GET_INTERFACE (self)->get_display_name (self);
}


void rygel_external_media_object_set_display_name (RygelExternalMediaObject* self, const char* value) {
	RYGEL_EXTERNAL_MEDIA_OBJECT_GET_INTERFACE (self)->set_display_name (self, value);
}


void _rygel_external_media_object_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_rygel_external_media_object_introspect (RygelExternalMediaObject* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaObject1\">\n  <property name=\"Parent\" type=\"o\" access=\"readwrite\"/>\n  <property name=\"DisplayName\" type=\"s\" access=\"readwrite\"/>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_external_media_object_property_get (RygelExternalMediaObject* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	char* property_name;
	const char* _tmp1_;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp1_);
	if ((strcmp (interface_name, "org.gnome.UPnP.MediaObject1") == 0) && (strcmp (property_name, "Parent") == 0)) {
		char* result;
		const char* _tmp2_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "o", &subiter);
		result = rygel_external_media_object_get_parent (self);
		_tmp2_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_OBJECT_PATH, &_tmp2_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaObject1") == 0) && (strcmp (property_name, "DisplayName") == 0)) {
		char* result;
		const char* _tmp3_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = rygel_external_media_object_get_display_name (self);
		_tmp3_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp3_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_external_media_object_property_set (RygelExternalMediaObject* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, subiter;
	char* interface_name;
	const char* _tmp4_;
	char* property_name;
	const char* _tmp5_;
	if (strcmp (dbus_message_get_signature (message), "ssv")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_get_basic (&iter, &_tmp4_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp4_);
	dbus_message_iter_get_basic (&iter, &_tmp5_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp5_);
	dbus_message_iter_recurse (&iter, &subiter);
	if ((strcmp (interface_name, "org.gnome.UPnP.MediaObject1") == 0) && (strcmp (property_name, "Parent") == 0)) {
		char* value;
		const char* _tmp6_;
		dbus_message_iter_get_basic (&subiter, &_tmp6_);
		dbus_message_iter_next (&subiter);
		value = g_strdup (_tmp6_);
		rygel_external_media_object_set_parent (self, value);
		_g_free0 (value);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaObject1") == 0) && (strcmp (property_name, "DisplayName") == 0)) {
		char* value;
		const char* _tmp7_;
		dbus_message_iter_get_basic (&subiter, &_tmp7_);
		dbus_message_iter_next (&subiter);
		value = g_strdup (_tmp7_);
		rygel_external_media_object_set_display_name (self, value);
		_g_free0 (value);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_external_media_object_property_get_all (RygelExternalMediaObject* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp8_;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp8_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp8_);
	if (strcmp (interface_name, "org.gnome.UPnP.MediaObject1") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		{
			char* result;
			const char* _tmp9_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Parent";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "o", &value_iter);
			result = rygel_external_media_object_get_parent (self);
			_tmp9_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_OBJECT_PATH, &_tmp9_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp10_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "DisplayName";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = rygel_external_media_object_get_display_name (self);
			_tmp10_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp10_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult rygel_external_media_object_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_rygel_external_media_object_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		result = _dbus_rygel_external_media_object_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Set")) {
		result = _dbus_rygel_external_media_object_property_set (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_rygel_external_media_object_property_get_all (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void rygel_external_media_object_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_rygel_external_media_object_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void rygel_external_media_object_base_init (RygelExternalMediaObjectIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("parent", "parent", "parent", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_type_set_qdata (RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_rygel_external_media_object_dbus_vtable));
	}
}


GType rygel_external_media_object_get_type (void) {
	static volatile gsize rygel_external_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_external_media_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelExternalMediaObjectIface), (GBaseInitFunc) rygel_external_media_object_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_external_media_object_type_id;
		rygel_external_media_object_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelExternalMediaObject", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_external_media_object_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (rygel_external_media_object_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &rygel_external_media_object_dbus_proxy_get_type);
		g_once_init_leave (&rygel_external_media_object_type_id__volatile, rygel_external_media_object_type_id);
	}
	return rygel_external_media_object_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (RygelExternalMediaObjectDBusProxy, rygel_external_media_object_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT, rygel_external_media_object_dbus_proxy_rygel_external_media_object__interface_init) );
RygelExternalMediaObject* rygel_external_media_object_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	RygelExternalMediaObject* self;
	self = g_object_new (rygel_external_media_object_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.UPnP.MediaObject1", NULL);
	return self;
}


static GObject* rygel_external_media_object_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (rygel_external_media_object_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), rygel_external_media_object_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult rygel_external_media_object_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void rygel_external_media_object_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((RygelExternalMediaObjectDBusProxy*) self)->disposed) {
		return;
	}
	((RygelExternalMediaObjectDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), rygel_external_media_object_dbus_proxy_filter, self);
	G_OBJECT_CLASS (rygel_external_media_object_dbus_proxy_parent_class)->dispose (self);
}


static void rygel_external_media_object_dbus_proxy_class_init (RygelExternalMediaObjectDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = rygel_external_media_object_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = rygel_external_media_object_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = rygel_external_media_object_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_external_media_object_dbus_proxy_set_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_OBJECT_DBUS_PROXY_PARENT, "parent");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_OBJECT_DBUS_PROXY_DISPLAY_NAME, "display-name");
}


static void rygel_external_media_object_dbus_proxy_init (RygelExternalMediaObjectDBusProxy* self) {
}


static char* rygel_external_media_object_dbus_proxy_get_parent (RygelExternalMediaObject* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp11_;
	const char* _tmp12_;
	char* _result;
	const char* _tmp13_;
	if (((RygelExternalMediaObjectDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp11_ = "org.gnome.UPnP.MediaObject1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp11_);
	_tmp12_ = "Parent";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp12_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "o")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "o", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp13_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp13_);
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_object_dbus_proxy_set_parent (RygelExternalMediaObject* self, const char* value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp14_;
	const char* _tmp15_;
	const char* _tmp16_;
	if (((RygelExternalMediaObjectDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp14_ = "org.gnome.UPnP.MediaObject1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp14_);
	_tmp15_ = "Parent";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp15_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "o", &_subiter);
	_tmp16_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_OBJECT_PATH, &_tmp16_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char* rygel_external_media_object_dbus_proxy_get_display_name (RygelExternalMediaObject* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp17_;
	const char* _tmp18_;
	char* _result;
	const char* _tmp19_;
	if (((RygelExternalMediaObjectDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp17_ = "org.gnome.UPnP.MediaObject1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp17_);
	_tmp18_ = "DisplayName";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp18_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp19_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp19_);
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_object_dbus_proxy_set_display_name (RygelExternalMediaObject* self, const char* value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp20_;
	const char* _tmp21_;
	const char* _tmp22_;
	if (((RygelExternalMediaObjectDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp20_ = "org.gnome.UPnP.MediaObject1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp20_);
	_tmp21_ = "DisplayName";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp21_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "s", &_subiter);
	_tmp22_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_STRING, &_tmp22_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void rygel_external_media_object_dbus_proxy_rygel_external_media_object__interface_init (RygelExternalMediaObjectIface* iface) {
	iface->get_parent = rygel_external_media_object_dbus_proxy_get_parent;
	iface->set_parent = rygel_external_media_object_dbus_proxy_set_parent;
	iface->get_display_name = rygel_external_media_object_dbus_proxy_get_display_name;
	iface->set_display_name = rygel_external_media_object_dbus_proxy_set_display_name;
}


static void rygel_external_media_object_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void rygel_external_media_object_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


char** rygel_external_media_container_get_items (RygelExternalMediaContainer* self, int* result_length1) {
	return RYGEL_EXTERNAL_MEDIA_CONTAINER_GET_INTERFACE (self)->get_items (self, result_length1);
}


void rygel_external_media_container_set_items (RygelExternalMediaContainer* self, char** value, int value_length1) {
	RYGEL_EXTERNAL_MEDIA_CONTAINER_GET_INTERFACE (self)->set_items (self, value, value_length1);
}


char** rygel_external_media_container_get_containers (RygelExternalMediaContainer* self, int* result_length1) {
	return RYGEL_EXTERNAL_MEDIA_CONTAINER_GET_INTERFACE (self)->get_containers (self, result_length1);
}


void rygel_external_media_container_set_containers (RygelExternalMediaContainer* self, char** value, int value_length1) {
	RYGEL_EXTERNAL_MEDIA_CONTAINER_GET_INTERFACE (self)->set_containers (self, value, value_length1);
}


guint rygel_external_media_container_get_item_count (RygelExternalMediaContainer* self) {
	return RYGEL_EXTERNAL_MEDIA_CONTAINER_GET_INTERFACE (self)->get_item_count (self);
}


void rygel_external_media_container_set_item_count (RygelExternalMediaContainer* self, guint value) {
	RYGEL_EXTERNAL_MEDIA_CONTAINER_GET_INTERFACE (self)->set_item_count (self, value);
}


guint rygel_external_media_container_get_container_count (RygelExternalMediaContainer* self) {
	return RYGEL_EXTERNAL_MEDIA_CONTAINER_GET_INTERFACE (self)->get_container_count (self);
}


void rygel_external_media_container_set_container_count (RygelExternalMediaContainer* self, guint value) {
	RYGEL_EXTERNAL_MEDIA_CONTAINER_GET_INTERFACE (self)->set_container_count (self, value);
}


char* rygel_external_media_container_get_icon (RygelExternalMediaContainer* self) {
	return RYGEL_EXTERNAL_MEDIA_CONTAINER_GET_INTERFACE (self)->get_icon (self);
}


void rygel_external_media_container_set_icon (RygelExternalMediaContainer* self, const char* value) {
	RYGEL_EXTERNAL_MEDIA_CONTAINER_GET_INTERFACE (self)->set_icon (self, value);
}


void _rygel_external_media_container_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_rygel_external_media_container_introspect (RygelExternalMediaContainer* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaContainer1\">\n  <property name=\"Items\" type=\"ao\" access=\"readwrite\"/>\n  <property name=\"Containers\" type=\"ao\" access=\"readwrite\"/>\n  <property name=\"ItemCount\" type=\"u\" access=\"readwrite\"/>\n  <property name=\"ContainerCount\" type=\"u\" access=\"readwrite\"/>\n  <property name=\"Icon\" type=\"o\" access=\"readwrite\"/>\n  <signal name=\"Updated\">\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_external_media_container_property_get (RygelExternalMediaContainer* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp23_;
	char* property_name;
	const char* _tmp24_;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp23_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp23_);
	dbus_message_iter_get_basic (&iter, &_tmp24_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp24_);
	if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) && (strcmp (property_name, "Items") == 0)) {
		char** result;
		int result_length1;
		char** _tmp25_;
		DBusMessageIter _tmp26_;
		int _tmp27_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "ao", &subiter);
		result = rygel_external_media_container_get_items (self, &result_length1);
		_tmp25_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "o", &_tmp26_);
		for (_tmp27_ = 0; _tmp27_ < result_length1; _tmp27_++) {
			const char* _tmp28_;
			_tmp28_ = *_tmp25_;
			dbus_message_iter_append_basic (&_tmp26_, DBUS_TYPE_OBJECT_PATH, &_tmp28_);
			_tmp25_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp26_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) && (strcmp (property_name, "Containers") == 0)) {
		char** result;
		int result_length1;
		char** _tmp29_;
		DBusMessageIter _tmp30_;
		int _tmp31_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "ao", &subiter);
		result = rygel_external_media_container_get_containers (self, &result_length1);
		_tmp29_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "o", &_tmp30_);
		for (_tmp31_ = 0; _tmp31_ < result_length1; _tmp31_++) {
			const char* _tmp32_;
			_tmp32_ = *_tmp29_;
			dbus_message_iter_append_basic (&_tmp30_, DBUS_TYPE_OBJECT_PATH, &_tmp32_);
			_tmp29_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp30_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) && (strcmp (property_name, "ItemCount") == 0)) {
		guint result;
		dbus_uint32_t _tmp33_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "u", &subiter);
		result = rygel_external_media_container_get_item_count (self);
		_tmp33_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_UINT32, &_tmp33_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) && (strcmp (property_name, "ContainerCount") == 0)) {
		guint result;
		dbus_uint32_t _tmp34_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "u", &subiter);
		result = rygel_external_media_container_get_container_count (self);
		_tmp34_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_UINT32, &_tmp34_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) && (strcmp (property_name, "Icon") == 0)) {
		char* result;
		const char* _tmp35_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "o", &subiter);
		result = rygel_external_media_container_get_icon (self);
		_tmp35_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_OBJECT_PATH, &_tmp35_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_external_media_container_property_set (RygelExternalMediaContainer* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, subiter;
	char* interface_name;
	const char* _tmp36_;
	char* property_name;
	const char* _tmp37_;
	if (strcmp (dbus_message_get_signature (message), "ssv")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_get_basic (&iter, &_tmp36_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp36_);
	dbus_message_iter_get_basic (&iter, &_tmp37_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp37_);
	dbus_message_iter_recurse (&iter, &subiter);
	if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) && (strcmp (property_name, "Items") == 0)) {
		char** value;
		char** _tmp38_;
		int _tmp38__length;
		int _tmp38__size;
		int _tmp38__length1;
		DBusMessageIter _tmp39_;
		int value_length1;
		_tmp38_ = g_new (char*, 5);
		_tmp38__length = 0;
		_tmp38__size = 4;
		_tmp38__length1 = 0;
		dbus_message_iter_recurse (&subiter, &_tmp39_);
		for (; dbus_message_iter_get_arg_type (&_tmp39_); _tmp38__length1++) {
			const char* _tmp40_;
			if (_tmp38__size == _tmp38__length) {
				_tmp38__size = 2 * _tmp38__size;
				_tmp38_ = g_renew (char*, _tmp38_, _tmp38__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp39_, &_tmp40_);
			dbus_message_iter_next (&_tmp39_);
			_tmp38_[_tmp38__length++] = g_strdup (_tmp40_);
		}
		value_length1 = _tmp38__length1;
		_tmp38_[_tmp38__length] = NULL;
		dbus_message_iter_next (&subiter);
		value = _tmp38_;
		rygel_external_media_container_set_items (self, value, value_length1);
		value = (_vala_array_free (value, value_length1, (GDestroyNotify) g_free), NULL);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) && (strcmp (property_name, "Containers") == 0)) {
		char** value;
		char** _tmp41_;
		int _tmp41__length;
		int _tmp41__size;
		int _tmp41__length1;
		DBusMessageIter _tmp42_;
		int value_length1;
		_tmp41_ = g_new (char*, 5);
		_tmp41__length = 0;
		_tmp41__size = 4;
		_tmp41__length1 = 0;
		dbus_message_iter_recurse (&subiter, &_tmp42_);
		for (; dbus_message_iter_get_arg_type (&_tmp42_); _tmp41__length1++) {
			const char* _tmp43_;
			if (_tmp41__size == _tmp41__length) {
				_tmp41__size = 2 * _tmp41__size;
				_tmp41_ = g_renew (char*, _tmp41_, _tmp41__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp42_, &_tmp43_);
			dbus_message_iter_next (&_tmp42_);
			_tmp41_[_tmp41__length++] = g_strdup (_tmp43_);
		}
		value_length1 = _tmp41__length1;
		_tmp41_[_tmp41__length] = NULL;
		dbus_message_iter_next (&subiter);
		value = _tmp41_;
		rygel_external_media_container_set_containers (self, value, value_length1);
		value = (_vala_array_free (value, value_length1, (GDestroyNotify) g_free), NULL);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) && (strcmp (property_name, "ItemCount") == 0)) {
		guint value;
		dbus_uint32_t _tmp44_;
		dbus_message_iter_get_basic (&subiter, &_tmp44_);
		dbus_message_iter_next (&subiter);
		value = _tmp44_;
		rygel_external_media_container_set_item_count (self, value);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) && (strcmp (property_name, "ContainerCount") == 0)) {
		guint value;
		dbus_uint32_t _tmp45_;
		dbus_message_iter_get_basic (&subiter, &_tmp45_);
		dbus_message_iter_next (&subiter);
		value = _tmp45_;
		rygel_external_media_container_set_container_count (self, value);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) && (strcmp (property_name, "Icon") == 0)) {
		char* value;
		const char* _tmp46_;
		dbus_message_iter_get_basic (&subiter, &_tmp46_);
		dbus_message_iter_next (&subiter);
		value = g_strdup (_tmp46_);
		rygel_external_media_container_set_icon (self, value);
		_g_free0 (value);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_external_media_container_property_get_all (RygelExternalMediaContainer* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp47_;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp47_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp47_);
	if (strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		{
			char** result;
			int result_length1;
			char** _tmp48_;
			DBusMessageIter _tmp49_;
			int _tmp50_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Items";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "ao", &value_iter);
			result = rygel_external_media_container_get_items (self, &result_length1);
			_tmp48_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "o", &_tmp49_);
			for (_tmp50_ = 0; _tmp50_ < result_length1; _tmp50_++) {
				const char* _tmp51_;
				_tmp51_ = *_tmp48_;
				dbus_message_iter_append_basic (&_tmp49_, DBUS_TYPE_OBJECT_PATH, &_tmp51_);
				_tmp48_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp49_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char** result;
			int result_length1;
			char** _tmp52_;
			DBusMessageIter _tmp53_;
			int _tmp54_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Containers";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "ao", &value_iter);
			result = rygel_external_media_container_get_containers (self, &result_length1);
			_tmp52_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "o", &_tmp53_);
			for (_tmp54_ = 0; _tmp54_ < result_length1; _tmp54_++) {
				const char* _tmp55_;
				_tmp55_ = *_tmp52_;
				dbus_message_iter_append_basic (&_tmp53_, DBUS_TYPE_OBJECT_PATH, &_tmp55_);
				_tmp52_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp53_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			guint result;
			dbus_uint32_t _tmp56_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "ItemCount";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "u", &value_iter);
			result = rygel_external_media_container_get_item_count (self);
			_tmp56_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_UINT32, &_tmp56_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			guint result;
			dbus_uint32_t _tmp57_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "ContainerCount";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "u", &value_iter);
			result = rygel_external_media_container_get_container_count (self);
			_tmp57_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_UINT32, &_tmp57_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp58_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Icon";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "o", &value_iter);
			result = rygel_external_media_container_get_icon (self);
			_tmp58_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_OBJECT_PATH, &_tmp58_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult rygel_external_media_container_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_rygel_external_media_container_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		result = _dbus_rygel_external_media_container_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Set")) {
		result = _dbus_rygel_external_media_container_property_set (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_rygel_external_media_container_property_get_all (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_rygel_external_media_container_updated (GObject* _sender, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.UPnP.MediaContainer1", "Updated");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void rygel_external_media_container_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_rygel_external_media_container_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "updated", (GCallback) _dbus_rygel_external_media_container_updated, connection);
}


static void rygel_external_media_container_base_init (RygelExternalMediaContainerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_uint ("item-count", "item-count", "item-count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_uint ("container-count", "container-count", "container-count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("icon", "icon", "icon", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_signal_new ("updated", RYGEL_TYPE_EXTERNAL_MEDIA_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_type_set_qdata (RYGEL_TYPE_EXTERNAL_MEDIA_CONTAINER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_rygel_external_media_container_dbus_vtable));
	}
}


GType rygel_external_media_container_get_type (void) {
	static volatile gsize rygel_external_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_external_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelExternalMediaContainerIface), (GBaseInitFunc) rygel_external_media_container_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_external_media_container_type_id;
		rygel_external_media_container_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelExternalMediaContainer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_external_media_container_type_id, DBUS_TYPE_G_PROXY);
		g_type_interface_add_prerequisite (rygel_external_media_container_type_id, RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT);
		g_type_set_qdata (rygel_external_media_container_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &rygel_external_media_container_dbus_proxy_get_type);
		g_once_init_leave (&rygel_external_media_container_type_id__volatile, rygel_external_media_container_type_id);
	}
	return rygel_external_media_container_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (RygelExternalMediaContainerDBusProxy, rygel_external_media_container_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT, rygel_external_media_container_dbus_proxy_rygel_external_media_object__interface_init) G_IMPLEMENT_INTERFACE (RYGEL_TYPE_EXTERNAL_MEDIA_CONTAINER, rygel_external_media_container_dbus_proxy_rygel_external_media_container__interface_init) );
RygelExternalMediaContainer* rygel_external_media_container_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	RygelExternalMediaContainer* self;
	self = g_object_new (rygel_external_media_container_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.UPnP.MediaContainer1", NULL);
	return self;
}


static GObject* rygel_external_media_container_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (rygel_external_media_container_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), rygel_external_media_container_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_rygel_external_media_container_updated (RygelExternalMediaContainer* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	g_signal_emit_by_name (self, "updated");
}


DBusHandlerResult rygel_external_media_container_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.gnome.UPnP.MediaContainer1", "Updated")) {
			_dbus_handle_rygel_external_media_container_updated (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void rygel_external_media_container_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((RygelExternalMediaContainerDBusProxy*) self)->disposed) {
		return;
	}
	((RygelExternalMediaContainerDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), rygel_external_media_container_dbus_proxy_filter, self);
	G_OBJECT_CLASS (rygel_external_media_container_dbus_proxy_parent_class)->dispose (self);
}


static void rygel_external_media_container_dbus_proxy_class_init (RygelExternalMediaContainerDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = rygel_external_media_container_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = rygel_external_media_container_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = rygel_external_media_container_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_external_media_container_dbus_proxy_set_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_CONTAINER_DBUS_PROXY_PARENT, "parent");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_CONTAINER_DBUS_PROXY_DISPLAY_NAME, "display-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_CONTAINER_DBUS_PROXY_ITEM_COUNT, "item-count");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_CONTAINER_DBUS_PROXY_CONTAINER_COUNT, "container-count");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_CONTAINER_DBUS_PROXY_ICON, "icon");
}


static void rygel_external_media_container_dbus_proxy_init (RygelExternalMediaContainerDBusProxy* self) {
}


static char* rygel_external_media_container_dbus_proxy_get_parent (RygelExternalMediaObject* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp59_;
	const char* _tmp60_;
	char* _result;
	const char* _tmp61_;
	if (((RygelExternalMediaObjectDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp59_ = "org.gnome.UPnP.MediaObject1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp59_);
	_tmp60_ = "Parent";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp60_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "o")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "o", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp61_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp61_);
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_container_dbus_proxy_set_parent (RygelExternalMediaObject* self, const char* value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp62_;
	const char* _tmp63_;
	const char* _tmp64_;
	if (((RygelExternalMediaObjectDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp62_ = "org.gnome.UPnP.MediaObject1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp62_);
	_tmp63_ = "Parent";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp63_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "o", &_subiter);
	_tmp64_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_OBJECT_PATH, &_tmp64_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char* rygel_external_media_container_dbus_proxy_get_display_name (RygelExternalMediaObject* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp65_;
	const char* _tmp66_;
	char* _result;
	const char* _tmp67_;
	if (((RygelExternalMediaObjectDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp65_ = "org.gnome.UPnP.MediaObject1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp65_);
	_tmp66_ = "DisplayName";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp66_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp67_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp67_);
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_container_dbus_proxy_set_display_name (RygelExternalMediaObject* self, const char* value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp68_;
	const char* _tmp69_;
	const char* _tmp70_;
	if (((RygelExternalMediaObjectDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp68_ = "org.gnome.UPnP.MediaObject1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp68_);
	_tmp69_ = "DisplayName";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp69_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "s", &_subiter);
	_tmp70_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_STRING, &_tmp70_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void rygel_external_media_container_dbus_proxy_rygel_external_media_object__interface_init (RygelExternalMediaObjectIface* iface) {
	iface->get_parent = rygel_external_media_container_dbus_proxy_get_parent;
	iface->set_parent = rygel_external_media_container_dbus_proxy_set_parent;
	iface->get_display_name = rygel_external_media_container_dbus_proxy_get_display_name;
	iface->set_display_name = rygel_external_media_container_dbus_proxy_set_display_name;
}


static char** rygel_external_media_container_dbus_proxy_get_items (RygelExternalMediaContainer* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp71_;
	const char* _tmp72_;
	char** _result;
	int _result_length1;
	char** _tmp73_;
	int _tmp73__length;
	int _tmp73__size;
	int _tmp73__length1;
	DBusMessageIter _tmp74_;
	if (((RygelExternalMediaContainerDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp71_ = "org.gnome.UPnP.MediaContainer1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp71_);
	_tmp72_ = "Items";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp72_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "ao")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "ao", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp73_ = g_new (char*, 5);
	_tmp73__length = 0;
	_tmp73__size = 4;
	_tmp73__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp74_);
	for (; dbus_message_iter_get_arg_type (&_tmp74_); _tmp73__length1++) {
		const char* _tmp75_;
		if (_tmp73__size == _tmp73__length) {
			_tmp73__size = 2 * _tmp73__size;
			_tmp73_ = g_renew (char*, _tmp73_, _tmp73__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp74_, &_tmp75_);
		dbus_message_iter_next (&_tmp74_);
		_tmp73_[_tmp73__length++] = g_strdup (_tmp75_);
	}
	_result_length1 = _tmp73__length1;
	_tmp73_[_tmp73__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp73_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_container_dbus_proxy_set_items (RygelExternalMediaContainer* self, char** value, int value_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp76_;
	const char* _tmp77_;
	char** _tmp78_;
	DBusMessageIter _tmp79_;
	int _tmp80_;
	if (((RygelExternalMediaContainerDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp76_ = "org.gnome.UPnP.MediaContainer1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp76_);
	_tmp77_ = "Items";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp77_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "ao", &_subiter);
	_tmp78_ = value;
	dbus_message_iter_open_container (&_subiter, DBUS_TYPE_ARRAY, "o", &_tmp79_);
	for (_tmp80_ = 0; _tmp80_ < value_length1; _tmp80_++) {
		const char* _tmp81_;
		_tmp81_ = *_tmp78_;
		dbus_message_iter_append_basic (&_tmp79_, DBUS_TYPE_OBJECT_PATH, &_tmp81_);
		_tmp78_++;
	}
	dbus_message_iter_close_container (&_subiter, &_tmp79_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char** rygel_external_media_container_dbus_proxy_get_containers (RygelExternalMediaContainer* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp82_;
	const char* _tmp83_;
	char** _result;
	int _result_length1;
	char** _tmp84_;
	int _tmp84__length;
	int _tmp84__size;
	int _tmp84__length1;
	DBusMessageIter _tmp85_;
	if (((RygelExternalMediaContainerDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp82_ = "org.gnome.UPnP.MediaContainer1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp82_);
	_tmp83_ = "Containers";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp83_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "ao")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "ao", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp84_ = g_new (char*, 5);
	_tmp84__length = 0;
	_tmp84__size = 4;
	_tmp84__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp85_);
	for (; dbus_message_iter_get_arg_type (&_tmp85_); _tmp84__length1++) {
		const char* _tmp86_;
		if (_tmp84__size == _tmp84__length) {
			_tmp84__size = 2 * _tmp84__size;
			_tmp84_ = g_renew (char*, _tmp84_, _tmp84__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp85_, &_tmp86_);
		dbus_message_iter_next (&_tmp85_);
		_tmp84_[_tmp84__length++] = g_strdup (_tmp86_);
	}
	_result_length1 = _tmp84__length1;
	_tmp84_[_tmp84__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp84_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_container_dbus_proxy_set_containers (RygelExternalMediaContainer* self, char** value, int value_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp87_;
	const char* _tmp88_;
	char** _tmp89_;
	DBusMessageIter _tmp90_;
	int _tmp91_;
	if (((RygelExternalMediaContainerDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp87_ = "org.gnome.UPnP.MediaContainer1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp87_);
	_tmp88_ = "Containers";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp88_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "ao", &_subiter);
	_tmp89_ = value;
	dbus_message_iter_open_container (&_subiter, DBUS_TYPE_ARRAY, "o", &_tmp90_);
	for (_tmp91_ = 0; _tmp91_ < value_length1; _tmp91_++) {
		const char* _tmp92_;
		_tmp92_ = *_tmp89_;
		dbus_message_iter_append_basic (&_tmp90_, DBUS_TYPE_OBJECT_PATH, &_tmp92_);
		_tmp89_++;
	}
	dbus_message_iter_close_container (&_subiter, &_tmp90_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static guint rygel_external_media_container_dbus_proxy_get_item_count (RygelExternalMediaContainer* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp93_;
	const char* _tmp94_;
	guint _result;
	dbus_uint32_t _tmp95_;
	if (((RygelExternalMediaContainerDBusProxy*) self)->disposed) {
		return 0U;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp93_ = "org.gnome.UPnP.MediaContainer1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp93_);
	_tmp94_ = "ItemCount";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp94_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0U;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0U;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "u")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "u", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0U;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp95_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp95_;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_container_dbus_proxy_set_item_count (RygelExternalMediaContainer* self, guint value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp96_;
	const char* _tmp97_;
	dbus_uint32_t _tmp98_;
	if (((RygelExternalMediaContainerDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp96_ = "org.gnome.UPnP.MediaContainer1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp96_);
	_tmp97_ = "ItemCount";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp97_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "u", &_subiter);
	_tmp98_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_UINT32, &_tmp98_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static guint rygel_external_media_container_dbus_proxy_get_container_count (RygelExternalMediaContainer* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp99_;
	const char* _tmp100_;
	guint _result;
	dbus_uint32_t _tmp101_;
	if (((RygelExternalMediaContainerDBusProxy*) self)->disposed) {
		return 0U;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp99_ = "org.gnome.UPnP.MediaContainer1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp99_);
	_tmp100_ = "ContainerCount";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp100_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0U;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0U;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "u")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "u", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0U;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp101_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp101_;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_container_dbus_proxy_set_container_count (RygelExternalMediaContainer* self, guint value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp102_;
	const char* _tmp103_;
	dbus_uint32_t _tmp104_;
	if (((RygelExternalMediaContainerDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp102_ = "org.gnome.UPnP.MediaContainer1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp102_);
	_tmp103_ = "ContainerCount";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp103_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "u", &_subiter);
	_tmp104_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_UINT32, &_tmp104_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char* rygel_external_media_container_dbus_proxy_get_icon (RygelExternalMediaContainer* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp105_;
	const char* _tmp106_;
	char* _result;
	const char* _tmp107_;
	if (((RygelExternalMediaContainerDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp105_ = "org.gnome.UPnP.MediaContainer1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp105_);
	_tmp106_ = "Icon";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp106_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "o")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "o", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp107_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp107_);
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_container_dbus_proxy_set_icon (RygelExternalMediaContainer* self, const char* value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp108_;
	const char* _tmp109_;
	const char* _tmp110_;
	if (((RygelExternalMediaContainerDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp108_ = "org.gnome.UPnP.MediaContainer1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp108_);
	_tmp109_ = "Icon";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp109_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "o", &_subiter);
	_tmp110_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_OBJECT_PATH, &_tmp110_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void rygel_external_media_container_dbus_proxy_rygel_external_media_container__interface_init (RygelExternalMediaContainerIface* iface) {
	iface->get_items = rygel_external_media_container_dbus_proxy_get_items;
	iface->set_items = rygel_external_media_container_dbus_proxy_set_items;
	iface->get_containers = rygel_external_media_container_dbus_proxy_get_containers;
	iface->set_containers = rygel_external_media_container_dbus_proxy_set_containers;
	iface->get_item_count = rygel_external_media_container_dbus_proxy_get_item_count;
	iface->set_item_count = rygel_external_media_container_dbus_proxy_set_item_count;
	iface->get_container_count = rygel_external_media_container_dbus_proxy_get_container_count;
	iface->set_container_count = rygel_external_media_container_dbus_proxy_set_container_count;
	iface->get_icon = rygel_external_media_container_dbus_proxy_get_icon;
	iface->set_icon = rygel_external_media_container_dbus_proxy_set_icon;
}


static void rygel_external_media_container_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void rygel_external_media_container_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


char** rygel_external_media_item_get_urls (RygelExternalMediaItem* self, int* result_length1) {
	return RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->get_urls (self, result_length1);
}


void rygel_external_media_item_set_urls (RygelExternalMediaItem* self, char** value, int value_length1) {
	RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->set_urls (self, value, value_length1);
}


char* rygel_external_media_item_get_mime_type (RygelExternalMediaItem* self) {
	return RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->get_mime_type (self);
}


void rygel_external_media_item_set_mime_type (RygelExternalMediaItem* self, const char* value) {
	RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->set_mime_type (self, value);
}


char* rygel_external_media_item_get_media_type (RygelExternalMediaItem* self) {
	return RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->get_media_type (self);
}


void rygel_external_media_item_set_media_type (RygelExternalMediaItem* self, const char* value) {
	RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->set_media_type (self, value);
}


gint rygel_external_media_item_get_size (RygelExternalMediaItem* self) {
	return RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->get_size (self);
}


void rygel_external_media_item_set_size (RygelExternalMediaItem* self, gint value) {
	RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->set_size (self, value);
}


char* rygel_external_media_item_get_artist (RygelExternalMediaItem* self) {
	return RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->get_artist (self);
}


void rygel_external_media_item_set_artist (RygelExternalMediaItem* self, const char* value) {
	RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->set_artist (self, value);
}


char* rygel_external_media_item_get_album (RygelExternalMediaItem* self) {
	return RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->get_album (self);
}


void rygel_external_media_item_set_album (RygelExternalMediaItem* self, const char* value) {
	RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->set_album (self, value);
}


char* rygel_external_media_item_get_date (RygelExternalMediaItem* self) {
	return RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->get_date (self);
}


void rygel_external_media_item_set_date (RygelExternalMediaItem* self, const char* value) {
	RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->set_date (self, value);
}


char* rygel_external_media_item_get_genre (RygelExternalMediaItem* self) {
	return RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->get_genre (self);
}


void rygel_external_media_item_set_genre (RygelExternalMediaItem* self, const char* value) {
	RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->set_genre (self, value);
}


char* rygel_external_media_item_get_dlna_profile (RygelExternalMediaItem* self) {
	return RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->get_dlna_profile (self);
}


void rygel_external_media_item_set_dlna_profile (RygelExternalMediaItem* self, const char* value) {
	RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->set_dlna_profile (self, value);
}


gint rygel_external_media_item_get_duration (RygelExternalMediaItem* self) {
	return RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->get_duration (self);
}


void rygel_external_media_item_set_duration (RygelExternalMediaItem* self, gint value) {
	RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->set_duration (self, value);
}


gint rygel_external_media_item_get_bitrate (RygelExternalMediaItem* self) {
	return RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->get_bitrate (self);
}


void rygel_external_media_item_set_bitrate (RygelExternalMediaItem* self, gint value) {
	RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->set_bitrate (self, value);
}


gint rygel_external_media_item_get_sample_rate (RygelExternalMediaItem* self) {
	return RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->get_sample_rate (self);
}


void rygel_external_media_item_set_sample_rate (RygelExternalMediaItem* self, gint value) {
	RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->set_sample_rate (self, value);
}


gint rygel_external_media_item_get_bits_per_sample (RygelExternalMediaItem* self) {
	return RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->get_bits_per_sample (self);
}


void rygel_external_media_item_set_bits_per_sample (RygelExternalMediaItem* self, gint value) {
	RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->set_bits_per_sample (self, value);
}


gint rygel_external_media_item_get_width (RygelExternalMediaItem* self) {
	return RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->get_width (self);
}


void rygel_external_media_item_set_width (RygelExternalMediaItem* self, gint value) {
	RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->set_width (self, value);
}


gint rygel_external_media_item_get_height (RygelExternalMediaItem* self) {
	return RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->get_height (self);
}


void rygel_external_media_item_set_height (RygelExternalMediaItem* self, gint value) {
	RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->set_height (self, value);
}


gint rygel_external_media_item_get_color_depth (RygelExternalMediaItem* self) {
	return RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->get_color_depth (self);
}


void rygel_external_media_item_set_color_depth (RygelExternalMediaItem* self, gint value) {
	RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->set_color_depth (self, value);
}


char* rygel_external_media_item_get_thumbnail (RygelExternalMediaItem* self) {
	return RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->get_thumbnail (self);
}


void rygel_external_media_item_set_thumbnail (RygelExternalMediaItem* self, const char* value) {
	RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->set_thumbnail (self, value);
}


char* rygel_external_media_item_get_album_art (RygelExternalMediaItem* self) {
	return RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->get_album_art (self);
}


void rygel_external_media_item_set_album_art (RygelExternalMediaItem* self, const char* value) {
	RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE (self)->set_album_art (self, value);
}


void _rygel_external_media_item_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_rygel_external_media_item_introspect (RygelExternalMediaItem* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaItem1\">\n  <property name=\"URLs\" type=\"as\" access=\"readwrite\"/>\n  <property name=\"MimeType\" type=\"s\" access=\"readwrite\"/>\n  <property name=\"Type\" type=\"s\" access=\"readwrite\"/>\n  <property name=\"Size\" type=\"i\" access=\"readwrite\"/>\n  <property name=\"Artist\" type=\"s\" access=\"readwrite\"/>\n  <property name=\"Album\" type=\"s\" access=\"readwrite\"/>\n  <property name=\"Date\" type=\"s\" access=\"readwrite\"/>\n  <property name=\"Genre\" type=\"s\" access=\"readwrite\"/>\n  <property name=\"DlnaProfile\" type=\"s\" access=\"readwrite\"/>\n  <property name=\"Duration\" type=\"i\" access=\"readwrite\"/>\n  <property name=\"Bitrate\" type=\"i\" access=\"readwrite\"/>\n  <property name=\"SampleRate\" type=\"i\" access=\"readwrite\"/>\n  <property name=\"BitsPerSample\" type=\"i\" access=\"readwrite\"/>\n  <property name=\"Width\" type=\"i\" access=\"readwrite\"/>\n  <property name=\"Height\" type=\"i\" access=\"readwrite\"/>\n  <property name=\"ColorDepth\" type=\"i\" access=\"readwrite\"/>\n  <property name=\"Thumbnail\" type=\"o\" access=\"readwrite\"/>\n  <property name=\"AlbumArt\" type=\"o\" access=\"readwrite\"/>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_external_media_item_property_get (RygelExternalMediaItem* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp111_;
	char* property_name;
	const char* _tmp112_;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp111_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp111_);
	dbus_message_iter_get_basic (&iter, &_tmp112_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp112_);
	if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "URLs") == 0)) {
		char** result;
		int result_length1;
		char** _tmp113_;
		DBusMessageIter _tmp114_;
		int _tmp115_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "as", &subiter);
		result = rygel_external_media_item_get_urls (self, &result_length1);
		_tmp113_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "s", &_tmp114_);
		for (_tmp115_ = 0; _tmp115_ < result_length1; _tmp115_++) {
			const char* _tmp116_;
			_tmp116_ = *_tmp113_;
			dbus_message_iter_append_basic (&_tmp114_, DBUS_TYPE_STRING, &_tmp116_);
			_tmp113_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp114_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "MimeType") == 0)) {
		char* result;
		const char* _tmp117_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = rygel_external_media_item_get_mime_type (self);
		_tmp117_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp117_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Type") == 0)) {
		char* result;
		const char* _tmp118_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = rygel_external_media_item_get_media_type (self);
		_tmp118_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp118_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Size") == 0)) {
		gint result;
		dbus_int32_t _tmp119_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "i", &subiter);
		result = rygel_external_media_item_get_size (self);
		_tmp119_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_INT32, &_tmp119_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Artist") == 0)) {
		char* result;
		const char* _tmp120_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = rygel_external_media_item_get_artist (self);
		_tmp120_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp120_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Album") == 0)) {
		char* result;
		const char* _tmp121_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = rygel_external_media_item_get_album (self);
		_tmp121_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp121_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Date") == 0)) {
		char* result;
		const char* _tmp122_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = rygel_external_media_item_get_date (self);
		_tmp122_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp122_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Genre") == 0)) {
		char* result;
		const char* _tmp123_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = rygel_external_media_item_get_genre (self);
		_tmp123_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp123_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "DlnaProfile") == 0)) {
		char* result;
		const char* _tmp124_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = rygel_external_media_item_get_dlna_profile (self);
		_tmp124_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp124_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Duration") == 0)) {
		gint result;
		dbus_int32_t _tmp125_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "i", &subiter);
		result = rygel_external_media_item_get_duration (self);
		_tmp125_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_INT32, &_tmp125_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Bitrate") == 0)) {
		gint result;
		dbus_int32_t _tmp126_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "i", &subiter);
		result = rygel_external_media_item_get_bitrate (self);
		_tmp126_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_INT32, &_tmp126_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "SampleRate") == 0)) {
		gint result;
		dbus_int32_t _tmp127_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "i", &subiter);
		result = rygel_external_media_item_get_sample_rate (self);
		_tmp127_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_INT32, &_tmp127_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "BitsPerSample") == 0)) {
		gint result;
		dbus_int32_t _tmp128_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "i", &subiter);
		result = rygel_external_media_item_get_bits_per_sample (self);
		_tmp128_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_INT32, &_tmp128_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Width") == 0)) {
		gint result;
		dbus_int32_t _tmp129_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "i", &subiter);
		result = rygel_external_media_item_get_width (self);
		_tmp129_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_INT32, &_tmp129_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Height") == 0)) {
		gint result;
		dbus_int32_t _tmp130_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "i", &subiter);
		result = rygel_external_media_item_get_height (self);
		_tmp130_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_INT32, &_tmp130_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "ColorDepth") == 0)) {
		gint result;
		dbus_int32_t _tmp131_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "i", &subiter);
		result = rygel_external_media_item_get_color_depth (self);
		_tmp131_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_INT32, &_tmp131_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Thumbnail") == 0)) {
		char* result;
		const char* _tmp132_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "o", &subiter);
		result = rygel_external_media_item_get_thumbnail (self);
		_tmp132_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_OBJECT_PATH, &_tmp132_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "AlbumArt") == 0)) {
		char* result;
		const char* _tmp133_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "o", &subiter);
		result = rygel_external_media_item_get_album_art (self);
		_tmp133_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_OBJECT_PATH, &_tmp133_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_external_media_item_property_set (RygelExternalMediaItem* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, subiter;
	char* interface_name;
	const char* _tmp134_;
	char* property_name;
	const char* _tmp135_;
	if (strcmp (dbus_message_get_signature (message), "ssv")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_get_basic (&iter, &_tmp134_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp134_);
	dbus_message_iter_get_basic (&iter, &_tmp135_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp135_);
	dbus_message_iter_recurse (&iter, &subiter);
	if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "URLs") == 0)) {
		char** value;
		char** _tmp136_;
		int _tmp136__length;
		int _tmp136__size;
		int _tmp136__length1;
		DBusMessageIter _tmp137_;
		int value_length1;
		_tmp136_ = g_new (char*, 5);
		_tmp136__length = 0;
		_tmp136__size = 4;
		_tmp136__length1 = 0;
		dbus_message_iter_recurse (&subiter, &_tmp137_);
		for (; dbus_message_iter_get_arg_type (&_tmp137_); _tmp136__length1++) {
			const char* _tmp138_;
			if (_tmp136__size == _tmp136__length) {
				_tmp136__size = 2 * _tmp136__size;
				_tmp136_ = g_renew (char*, _tmp136_, _tmp136__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp137_, &_tmp138_);
			dbus_message_iter_next (&_tmp137_);
			_tmp136_[_tmp136__length++] = g_strdup (_tmp138_);
		}
		value_length1 = _tmp136__length1;
		_tmp136_[_tmp136__length] = NULL;
		dbus_message_iter_next (&subiter);
		value = _tmp136_;
		rygel_external_media_item_set_urls (self, value, value_length1);
		value = (_vala_array_free (value, value_length1, (GDestroyNotify) g_free), NULL);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "MimeType") == 0)) {
		char* value;
		const char* _tmp139_;
		dbus_message_iter_get_basic (&subiter, &_tmp139_);
		dbus_message_iter_next (&subiter);
		value = g_strdup (_tmp139_);
		rygel_external_media_item_set_mime_type (self, value);
		_g_free0 (value);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Type") == 0)) {
		char* value;
		const char* _tmp140_;
		dbus_message_iter_get_basic (&subiter, &_tmp140_);
		dbus_message_iter_next (&subiter);
		value = g_strdup (_tmp140_);
		rygel_external_media_item_set_media_type (self, value);
		_g_free0 (value);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Size") == 0)) {
		gint value;
		dbus_int32_t _tmp141_;
		dbus_message_iter_get_basic (&subiter, &_tmp141_);
		dbus_message_iter_next (&subiter);
		value = _tmp141_;
		rygel_external_media_item_set_size (self, value);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Artist") == 0)) {
		char* value;
		const char* _tmp142_;
		dbus_message_iter_get_basic (&subiter, &_tmp142_);
		dbus_message_iter_next (&subiter);
		value = g_strdup (_tmp142_);
		rygel_external_media_item_set_artist (self, value);
		_g_free0 (value);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Album") == 0)) {
		char* value;
		const char* _tmp143_;
		dbus_message_iter_get_basic (&subiter, &_tmp143_);
		dbus_message_iter_next (&subiter);
		value = g_strdup (_tmp143_);
		rygel_external_media_item_set_album (self, value);
		_g_free0 (value);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Date") == 0)) {
		char* value;
		const char* _tmp144_;
		dbus_message_iter_get_basic (&subiter, &_tmp144_);
		dbus_message_iter_next (&subiter);
		value = g_strdup (_tmp144_);
		rygel_external_media_item_set_date (self, value);
		_g_free0 (value);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Genre") == 0)) {
		char* value;
		const char* _tmp145_;
		dbus_message_iter_get_basic (&subiter, &_tmp145_);
		dbus_message_iter_next (&subiter);
		value = g_strdup (_tmp145_);
		rygel_external_media_item_set_genre (self, value);
		_g_free0 (value);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "DlnaProfile") == 0)) {
		char* value;
		const char* _tmp146_;
		dbus_message_iter_get_basic (&subiter, &_tmp146_);
		dbus_message_iter_next (&subiter);
		value = g_strdup (_tmp146_);
		rygel_external_media_item_set_dlna_profile (self, value);
		_g_free0 (value);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Duration") == 0)) {
		gint value;
		dbus_int32_t _tmp147_;
		dbus_message_iter_get_basic (&subiter, &_tmp147_);
		dbus_message_iter_next (&subiter);
		value = _tmp147_;
		rygel_external_media_item_set_duration (self, value);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Bitrate") == 0)) {
		gint value;
		dbus_int32_t _tmp148_;
		dbus_message_iter_get_basic (&subiter, &_tmp148_);
		dbus_message_iter_next (&subiter);
		value = _tmp148_;
		rygel_external_media_item_set_bitrate (self, value);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "SampleRate") == 0)) {
		gint value;
		dbus_int32_t _tmp149_;
		dbus_message_iter_get_basic (&subiter, &_tmp149_);
		dbus_message_iter_next (&subiter);
		value = _tmp149_;
		rygel_external_media_item_set_sample_rate (self, value);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "BitsPerSample") == 0)) {
		gint value;
		dbus_int32_t _tmp150_;
		dbus_message_iter_get_basic (&subiter, &_tmp150_);
		dbus_message_iter_next (&subiter);
		value = _tmp150_;
		rygel_external_media_item_set_bits_per_sample (self, value);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Width") == 0)) {
		gint value;
		dbus_int32_t _tmp151_;
		dbus_message_iter_get_basic (&subiter, &_tmp151_);
		dbus_message_iter_next (&subiter);
		value = _tmp151_;
		rygel_external_media_item_set_width (self, value);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Height") == 0)) {
		gint value;
		dbus_int32_t _tmp152_;
		dbus_message_iter_get_basic (&subiter, &_tmp152_);
		dbus_message_iter_next (&subiter);
		value = _tmp152_;
		rygel_external_media_item_set_height (self, value);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "ColorDepth") == 0)) {
		gint value;
		dbus_int32_t _tmp153_;
		dbus_message_iter_get_basic (&subiter, &_tmp153_);
		dbus_message_iter_next (&subiter);
		value = _tmp153_;
		rygel_external_media_item_set_color_depth (self, value);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Thumbnail") == 0)) {
		char* value;
		const char* _tmp154_;
		dbus_message_iter_get_basic (&subiter, &_tmp154_);
		dbus_message_iter_next (&subiter);
		value = g_strdup (_tmp154_);
		rygel_external_media_item_set_thumbnail (self, value);
		_g_free0 (value);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "AlbumArt") == 0)) {
		char* value;
		const char* _tmp155_;
		dbus_message_iter_get_basic (&subiter, &_tmp155_);
		dbus_message_iter_next (&subiter);
		value = g_strdup (_tmp155_);
		rygel_external_media_item_set_album_art (self, value);
		_g_free0 (value);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_external_media_item_property_get_all (RygelExternalMediaItem* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp156_;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp156_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp156_);
	if (strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		{
			char** result;
			int result_length1;
			char** _tmp157_;
			DBusMessageIter _tmp158_;
			int _tmp159_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "URLs";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "as", &value_iter);
			result = rygel_external_media_item_get_urls (self, &result_length1);
			_tmp157_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "s", &_tmp158_);
			for (_tmp159_ = 0; _tmp159_ < result_length1; _tmp159_++) {
				const char* _tmp160_;
				_tmp160_ = *_tmp157_;
				dbus_message_iter_append_basic (&_tmp158_, DBUS_TYPE_STRING, &_tmp160_);
				_tmp157_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp158_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp161_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "MimeType";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = rygel_external_media_item_get_mime_type (self);
			_tmp161_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp161_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp162_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Type";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = rygel_external_media_item_get_media_type (self);
			_tmp162_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp162_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			gint result;
			dbus_int32_t _tmp163_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Size";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "i", &value_iter);
			result = rygel_external_media_item_get_size (self);
			_tmp163_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_INT32, &_tmp163_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp164_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Artist";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = rygel_external_media_item_get_artist (self);
			_tmp164_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp164_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp165_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Album";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = rygel_external_media_item_get_album (self);
			_tmp165_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp165_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp166_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Date";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = rygel_external_media_item_get_date (self);
			_tmp166_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp166_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp167_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Genre";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = rygel_external_media_item_get_genre (self);
			_tmp167_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp167_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp168_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "DlnaProfile";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = rygel_external_media_item_get_dlna_profile (self);
			_tmp168_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp168_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			gint result;
			dbus_int32_t _tmp169_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Duration";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "i", &value_iter);
			result = rygel_external_media_item_get_duration (self);
			_tmp169_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_INT32, &_tmp169_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			gint result;
			dbus_int32_t _tmp170_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Bitrate";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "i", &value_iter);
			result = rygel_external_media_item_get_bitrate (self);
			_tmp170_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_INT32, &_tmp170_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			gint result;
			dbus_int32_t _tmp171_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "SampleRate";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "i", &value_iter);
			result = rygel_external_media_item_get_sample_rate (self);
			_tmp171_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_INT32, &_tmp171_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			gint result;
			dbus_int32_t _tmp172_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "BitsPerSample";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "i", &value_iter);
			result = rygel_external_media_item_get_bits_per_sample (self);
			_tmp172_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_INT32, &_tmp172_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			gint result;
			dbus_int32_t _tmp173_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Width";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "i", &value_iter);
			result = rygel_external_media_item_get_width (self);
			_tmp173_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_INT32, &_tmp173_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			gint result;
			dbus_int32_t _tmp174_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Height";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "i", &value_iter);
			result = rygel_external_media_item_get_height (self);
			_tmp174_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_INT32, &_tmp174_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			gint result;
			dbus_int32_t _tmp175_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "ColorDepth";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "i", &value_iter);
			result = rygel_external_media_item_get_color_depth (self);
			_tmp175_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_INT32, &_tmp175_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp176_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Thumbnail";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "o", &value_iter);
			result = rygel_external_media_item_get_thumbnail (self);
			_tmp176_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_OBJECT_PATH, &_tmp176_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp177_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "AlbumArt";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "o", &value_iter);
			result = rygel_external_media_item_get_album_art (self);
			_tmp177_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_OBJECT_PATH, &_tmp177_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult rygel_external_media_item_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_rygel_external_media_item_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		result = _dbus_rygel_external_media_item_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Set")) {
		result = _dbus_rygel_external_media_item_property_set (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_rygel_external_media_item_property_get_all (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void rygel_external_media_item_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_rygel_external_media_item_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void rygel_external_media_item_base_init (RygelExternalMediaItemIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("media-type", "media-type", "media-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("artist", "artist", "artist", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("album", "album", "album", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("date", "date", "date", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("genre", "genre", "genre", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("dlna-profile", "dlna-profile", "dlna-profile", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_int ("duration", "duration", "duration", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_int ("bitrate", "bitrate", "bitrate", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_int ("sample-rate", "sample-rate", "sample-rate", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_int ("bits-per-sample", "bits-per-sample", "bits-per-sample", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_int ("color-depth", "color-depth", "color-depth", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("thumbnail", "thumbnail", "thumbnail", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("album-art", "album-art", "album-art", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_type_set_qdata (RYGEL_TYPE_EXTERNAL_MEDIA_ITEM, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_rygel_external_media_item_dbus_vtable));
	}
}


GType rygel_external_media_item_get_type (void) {
	static volatile gsize rygel_external_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_external_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelExternalMediaItemIface), (GBaseInitFunc) rygel_external_media_item_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_external_media_item_type_id;
		rygel_external_media_item_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelExternalMediaItem", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_external_media_item_type_id, DBUS_TYPE_G_PROXY);
		g_type_interface_add_prerequisite (rygel_external_media_item_type_id, RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT);
		g_type_set_qdata (rygel_external_media_item_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &rygel_external_media_item_dbus_proxy_get_type);
		g_once_init_leave (&rygel_external_media_item_type_id__volatile, rygel_external_media_item_type_id);
	}
	return rygel_external_media_item_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (RygelExternalMediaItemDBusProxy, rygel_external_media_item_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT, rygel_external_media_item_dbus_proxy_rygel_external_media_object__interface_init) G_IMPLEMENT_INTERFACE (RYGEL_TYPE_EXTERNAL_MEDIA_ITEM, rygel_external_media_item_dbus_proxy_rygel_external_media_item__interface_init) );
RygelExternalMediaItem* rygel_external_media_item_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	RygelExternalMediaItem* self;
	self = g_object_new (rygel_external_media_item_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.UPnP.MediaItem1", NULL);
	return self;
}


static GObject* rygel_external_media_item_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (rygel_external_media_item_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), rygel_external_media_item_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult rygel_external_media_item_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void rygel_external_media_item_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return;
	}
	((RygelExternalMediaItemDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), rygel_external_media_item_dbus_proxy_filter, self);
	G_OBJECT_CLASS (rygel_external_media_item_dbus_proxy_parent_class)->dispose (self);
}


static void rygel_external_media_item_dbus_proxy_class_init (RygelExternalMediaItemDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = rygel_external_media_item_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = rygel_external_media_item_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = rygel_external_media_item_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_external_media_item_dbus_proxy_set_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_PARENT, "parent");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_DISPLAY_NAME, "display-name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_MIME_TYPE, "mime-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_MEDIA_TYPE, "media-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_SIZE, "size");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_ARTIST, "artist");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_ALBUM, "album");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_DATE, "date");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_GENRE, "genre");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_DLNA_PROFILE, "dlna-profile");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_DURATION, "duration");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_BITRATE, "bitrate");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_SAMPLE_RATE, "sample-rate");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_BITS_PER_SAMPLE, "bits-per-sample");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_WIDTH, "width");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_HEIGHT, "height");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_COLOR_DEPTH, "color-depth");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_THUMBNAIL, "thumbnail");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_MEDIA_ITEM_DBUS_PROXY_ALBUM_ART, "album-art");
}


static void rygel_external_media_item_dbus_proxy_init (RygelExternalMediaItemDBusProxy* self) {
}


static char* rygel_external_media_item_dbus_proxy_get_parent (RygelExternalMediaObject* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp178_;
	const char* _tmp179_;
	char* _result;
	const char* _tmp180_;
	if (((RygelExternalMediaObjectDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp178_ = "org.gnome.UPnP.MediaObject1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp178_);
	_tmp179_ = "Parent";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp179_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "o")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "o", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp180_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp180_);
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_item_dbus_proxy_set_parent (RygelExternalMediaObject* self, const char* value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp181_;
	const char* _tmp182_;
	const char* _tmp183_;
	if (((RygelExternalMediaObjectDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp181_ = "org.gnome.UPnP.MediaObject1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp181_);
	_tmp182_ = "Parent";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp182_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "o", &_subiter);
	_tmp183_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_OBJECT_PATH, &_tmp183_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char* rygel_external_media_item_dbus_proxy_get_display_name (RygelExternalMediaObject* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp184_;
	const char* _tmp185_;
	char* _result;
	const char* _tmp186_;
	if (((RygelExternalMediaObjectDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp184_ = "org.gnome.UPnP.MediaObject1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp184_);
	_tmp185_ = "DisplayName";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp185_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp186_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp186_);
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_item_dbus_proxy_set_display_name (RygelExternalMediaObject* self, const char* value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp187_;
	const char* _tmp188_;
	const char* _tmp189_;
	if (((RygelExternalMediaObjectDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp187_ = "org.gnome.UPnP.MediaObject1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp187_);
	_tmp188_ = "DisplayName";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp188_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "s", &_subiter);
	_tmp189_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_STRING, &_tmp189_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void rygel_external_media_item_dbus_proxy_rygel_external_media_object__interface_init (RygelExternalMediaObjectIface* iface) {
	iface->get_parent = rygel_external_media_item_dbus_proxy_get_parent;
	iface->set_parent = rygel_external_media_item_dbus_proxy_set_parent;
	iface->get_display_name = rygel_external_media_item_dbus_proxy_get_display_name;
	iface->set_display_name = rygel_external_media_item_dbus_proxy_set_display_name;
}


static char** rygel_external_media_item_dbus_proxy_get_urls (RygelExternalMediaItem* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp190_;
	const char* _tmp191_;
	char** _result;
	int _result_length1;
	char** _tmp192_;
	int _tmp192__length;
	int _tmp192__size;
	int _tmp192__length1;
	DBusMessageIter _tmp193_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp190_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp190_);
	_tmp191_ = "URLs";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp191_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "as")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "as", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp192_ = g_new (char*, 5);
	_tmp192__length = 0;
	_tmp192__size = 4;
	_tmp192__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp193_);
	for (; dbus_message_iter_get_arg_type (&_tmp193_); _tmp192__length1++) {
		const char* _tmp194_;
		if (_tmp192__size == _tmp192__length) {
			_tmp192__size = 2 * _tmp192__size;
			_tmp192_ = g_renew (char*, _tmp192_, _tmp192__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp193_, &_tmp194_);
		dbus_message_iter_next (&_tmp193_);
		_tmp192_[_tmp192__length++] = g_strdup (_tmp194_);
	}
	_result_length1 = _tmp192__length1;
	_tmp192_[_tmp192__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp192_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_item_dbus_proxy_set_urls (RygelExternalMediaItem* self, char** value, int value_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp195_;
	const char* _tmp196_;
	char** _tmp197_;
	DBusMessageIter _tmp198_;
	int _tmp199_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp195_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp195_);
	_tmp196_ = "URLs";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp196_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "as", &_subiter);
	_tmp197_ = value;
	dbus_message_iter_open_container (&_subiter, DBUS_TYPE_ARRAY, "s", &_tmp198_);
	for (_tmp199_ = 0; _tmp199_ < value_length1; _tmp199_++) {
		const char* _tmp200_;
		_tmp200_ = *_tmp197_;
		dbus_message_iter_append_basic (&_tmp198_, DBUS_TYPE_STRING, &_tmp200_);
		_tmp197_++;
	}
	dbus_message_iter_close_container (&_subiter, &_tmp198_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char* rygel_external_media_item_dbus_proxy_get_mime_type (RygelExternalMediaItem* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp201_;
	const char* _tmp202_;
	char* _result;
	const char* _tmp203_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp201_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp201_);
	_tmp202_ = "MimeType";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp202_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp203_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp203_);
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_item_dbus_proxy_set_mime_type (RygelExternalMediaItem* self, const char* value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp204_;
	const char* _tmp205_;
	const char* _tmp206_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp204_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp204_);
	_tmp205_ = "MimeType";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp205_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "s", &_subiter);
	_tmp206_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_STRING, &_tmp206_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char* rygel_external_media_item_dbus_proxy_get_media_type (RygelExternalMediaItem* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp207_;
	const char* _tmp208_;
	char* _result;
	const char* _tmp209_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp207_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp207_);
	_tmp208_ = "Type";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp208_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp209_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp209_);
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_item_dbus_proxy_set_media_type (RygelExternalMediaItem* self, const char* value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp210_;
	const char* _tmp211_;
	const char* _tmp212_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp210_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp210_);
	_tmp211_ = "Type";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp211_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "s", &_subiter);
	_tmp212_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_STRING, &_tmp212_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gint rygel_external_media_item_dbus_proxy_get_size (RygelExternalMediaItem* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp213_;
	const char* _tmp214_;
	gint _result;
	dbus_int32_t _tmp215_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return 0;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp213_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp213_);
	_tmp214_ = "Size";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp214_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "i")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "i", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp215_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp215_;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_item_dbus_proxy_set_size (RygelExternalMediaItem* self, gint value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp216_;
	const char* _tmp217_;
	dbus_int32_t _tmp218_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp216_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp216_);
	_tmp217_ = "Size";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp217_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "i", &_subiter);
	_tmp218_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_INT32, &_tmp218_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char* rygel_external_media_item_dbus_proxy_get_artist (RygelExternalMediaItem* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp219_;
	const char* _tmp220_;
	char* _result;
	const char* _tmp221_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp219_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp219_);
	_tmp220_ = "Artist";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp220_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp221_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp221_);
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_item_dbus_proxy_set_artist (RygelExternalMediaItem* self, const char* value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp222_;
	const char* _tmp223_;
	const char* _tmp224_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp222_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp222_);
	_tmp223_ = "Artist";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp223_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "s", &_subiter);
	_tmp224_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_STRING, &_tmp224_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char* rygel_external_media_item_dbus_proxy_get_album (RygelExternalMediaItem* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp225_;
	const char* _tmp226_;
	char* _result;
	const char* _tmp227_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp225_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp225_);
	_tmp226_ = "Album";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp226_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp227_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp227_);
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_item_dbus_proxy_set_album (RygelExternalMediaItem* self, const char* value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp228_;
	const char* _tmp229_;
	const char* _tmp230_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp228_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp228_);
	_tmp229_ = "Album";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp229_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "s", &_subiter);
	_tmp230_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_STRING, &_tmp230_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char* rygel_external_media_item_dbus_proxy_get_date (RygelExternalMediaItem* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp231_;
	const char* _tmp232_;
	char* _result;
	const char* _tmp233_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp231_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp231_);
	_tmp232_ = "Date";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp232_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp233_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp233_);
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_item_dbus_proxy_set_date (RygelExternalMediaItem* self, const char* value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp234_;
	const char* _tmp235_;
	const char* _tmp236_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp234_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp234_);
	_tmp235_ = "Date";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp235_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "s", &_subiter);
	_tmp236_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_STRING, &_tmp236_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char* rygel_external_media_item_dbus_proxy_get_genre (RygelExternalMediaItem* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp237_;
	const char* _tmp238_;
	char* _result;
	const char* _tmp239_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp237_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp237_);
	_tmp238_ = "Genre";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp238_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp239_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp239_);
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_item_dbus_proxy_set_genre (RygelExternalMediaItem* self, const char* value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp240_;
	const char* _tmp241_;
	const char* _tmp242_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp240_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp240_);
	_tmp241_ = "Genre";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp241_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "s", &_subiter);
	_tmp242_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_STRING, &_tmp242_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char* rygel_external_media_item_dbus_proxy_get_dlna_profile (RygelExternalMediaItem* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp243_;
	const char* _tmp244_;
	char* _result;
	const char* _tmp245_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp243_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp243_);
	_tmp244_ = "DlnaProfile";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp244_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp245_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp245_);
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_item_dbus_proxy_set_dlna_profile (RygelExternalMediaItem* self, const char* value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp246_;
	const char* _tmp247_;
	const char* _tmp248_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp246_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp246_);
	_tmp247_ = "DlnaProfile";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp247_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "s", &_subiter);
	_tmp248_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_STRING, &_tmp248_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gint rygel_external_media_item_dbus_proxy_get_duration (RygelExternalMediaItem* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp249_;
	const char* _tmp250_;
	gint _result;
	dbus_int32_t _tmp251_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return 0;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp249_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp249_);
	_tmp250_ = "Duration";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp250_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "i")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "i", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp251_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp251_;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_item_dbus_proxy_set_duration (RygelExternalMediaItem* self, gint value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp252_;
	const char* _tmp253_;
	dbus_int32_t _tmp254_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp252_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp252_);
	_tmp253_ = "Duration";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp253_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "i", &_subiter);
	_tmp254_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_INT32, &_tmp254_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gint rygel_external_media_item_dbus_proxy_get_bitrate (RygelExternalMediaItem* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp255_;
	const char* _tmp256_;
	gint _result;
	dbus_int32_t _tmp257_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return 0;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp255_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp255_);
	_tmp256_ = "Bitrate";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp256_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "i")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "i", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp257_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp257_;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_item_dbus_proxy_set_bitrate (RygelExternalMediaItem* self, gint value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp258_;
	const char* _tmp259_;
	dbus_int32_t _tmp260_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp258_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp258_);
	_tmp259_ = "Bitrate";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp259_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "i", &_subiter);
	_tmp260_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_INT32, &_tmp260_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gint rygel_external_media_item_dbus_proxy_get_sample_rate (RygelExternalMediaItem* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp261_;
	const char* _tmp262_;
	gint _result;
	dbus_int32_t _tmp263_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return 0;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp261_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp261_);
	_tmp262_ = "SampleRate";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp262_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "i")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "i", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp263_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp263_;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_item_dbus_proxy_set_sample_rate (RygelExternalMediaItem* self, gint value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp264_;
	const char* _tmp265_;
	dbus_int32_t _tmp266_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp264_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp264_);
	_tmp265_ = "SampleRate";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp265_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "i", &_subiter);
	_tmp266_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_INT32, &_tmp266_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gint rygel_external_media_item_dbus_proxy_get_bits_per_sample (RygelExternalMediaItem* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp267_;
	const char* _tmp268_;
	gint _result;
	dbus_int32_t _tmp269_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return 0;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp267_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp267_);
	_tmp268_ = "BitsPerSample";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp268_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "i")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "i", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp269_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp269_;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_item_dbus_proxy_set_bits_per_sample (RygelExternalMediaItem* self, gint value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp270_;
	const char* _tmp271_;
	dbus_int32_t _tmp272_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp270_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp270_);
	_tmp271_ = "BitsPerSample";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp271_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "i", &_subiter);
	_tmp272_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_INT32, &_tmp272_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gint rygel_external_media_item_dbus_proxy_get_width (RygelExternalMediaItem* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp273_;
	const char* _tmp274_;
	gint _result;
	dbus_int32_t _tmp275_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return 0;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp273_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp273_);
	_tmp274_ = "Width";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp274_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "i")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "i", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp275_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp275_;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_item_dbus_proxy_set_width (RygelExternalMediaItem* self, gint value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp276_;
	const char* _tmp277_;
	dbus_int32_t _tmp278_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp276_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp276_);
	_tmp277_ = "Width";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp277_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "i", &_subiter);
	_tmp278_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_INT32, &_tmp278_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gint rygel_external_media_item_dbus_proxy_get_height (RygelExternalMediaItem* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp279_;
	const char* _tmp280_;
	gint _result;
	dbus_int32_t _tmp281_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return 0;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp279_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp279_);
	_tmp280_ = "Height";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp280_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "i")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "i", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp281_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp281_;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_item_dbus_proxy_set_height (RygelExternalMediaItem* self, gint value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp282_;
	const char* _tmp283_;
	dbus_int32_t _tmp284_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp282_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp282_);
	_tmp283_ = "Height";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp283_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "i", &_subiter);
	_tmp284_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_INT32, &_tmp284_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gint rygel_external_media_item_dbus_proxy_get_color_depth (RygelExternalMediaItem* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp285_;
	const char* _tmp286_;
	gint _result;
	dbus_int32_t _tmp287_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return 0;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp285_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp285_);
	_tmp286_ = "ColorDepth";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp286_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "i")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "i", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp287_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp287_;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_item_dbus_proxy_set_color_depth (RygelExternalMediaItem* self, gint value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp288_;
	const char* _tmp289_;
	dbus_int32_t _tmp290_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp288_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp288_);
	_tmp289_ = "ColorDepth";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp289_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "i", &_subiter);
	_tmp290_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_INT32, &_tmp290_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char* rygel_external_media_item_dbus_proxy_get_thumbnail (RygelExternalMediaItem* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp291_;
	const char* _tmp292_;
	char* _result;
	const char* _tmp293_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp291_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp291_);
	_tmp292_ = "Thumbnail";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp292_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "o")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "o", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp293_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp293_);
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_item_dbus_proxy_set_thumbnail (RygelExternalMediaItem* self, const char* value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp294_;
	const char* _tmp295_;
	const char* _tmp296_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp294_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp294_);
	_tmp295_ = "Thumbnail";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp295_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "o", &_subiter);
	_tmp296_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_OBJECT_PATH, &_tmp296_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char* rygel_external_media_item_dbus_proxy_get_album_art (RygelExternalMediaItem* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp297_;
	const char* _tmp298_;
	char* _result;
	const char* _tmp299_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp297_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp297_);
	_tmp298_ = "AlbumArt";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp298_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "o")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "o", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp299_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp299_);
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_external_media_item_dbus_proxy_set_album_art (RygelExternalMediaItem* self, const char* value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp300_;
	const char* _tmp301_;
	const char* _tmp302_;
	if (((RygelExternalMediaItemDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp300_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp300_);
	_tmp301_ = "AlbumArt";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp301_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "o", &_subiter);
	_tmp302_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_OBJECT_PATH, &_tmp302_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void rygel_external_media_item_dbus_proxy_rygel_external_media_item__interface_init (RygelExternalMediaItemIface* iface) {
	iface->get_urls = rygel_external_media_item_dbus_proxy_get_urls;
	iface->set_urls = rygel_external_media_item_dbus_proxy_set_urls;
	iface->get_mime_type = rygel_external_media_item_dbus_proxy_get_mime_type;
	iface->set_mime_type = rygel_external_media_item_dbus_proxy_set_mime_type;
	iface->get_media_type = rygel_external_media_item_dbus_proxy_get_media_type;
	iface->set_media_type = rygel_external_media_item_dbus_proxy_set_media_type;
	iface->get_size = rygel_external_media_item_dbus_proxy_get_size;
	iface->set_size = rygel_external_media_item_dbus_proxy_set_size;
	iface->get_artist = rygel_external_media_item_dbus_proxy_get_artist;
	iface->set_artist = rygel_external_media_item_dbus_proxy_set_artist;
	iface->get_album = rygel_external_media_item_dbus_proxy_get_album;
	iface->set_album = rygel_external_media_item_dbus_proxy_set_album;
	iface->get_date = rygel_external_media_item_dbus_proxy_get_date;
	iface->set_date = rygel_external_media_item_dbus_proxy_set_date;
	iface->get_genre = rygel_external_media_item_dbus_proxy_get_genre;
	iface->set_genre = rygel_external_media_item_dbus_proxy_set_genre;
	iface->get_dlna_profile = rygel_external_media_item_dbus_proxy_get_dlna_profile;
	iface->set_dlna_profile = rygel_external_media_item_dbus_proxy_set_dlna_profile;
	iface->get_duration = rygel_external_media_item_dbus_proxy_get_duration;
	iface->set_duration = rygel_external_media_item_dbus_proxy_set_duration;
	iface->get_bitrate = rygel_external_media_item_dbus_proxy_get_bitrate;
	iface->set_bitrate = rygel_external_media_item_dbus_proxy_set_bitrate;
	iface->get_sample_rate = rygel_external_media_item_dbus_proxy_get_sample_rate;
	iface->set_sample_rate = rygel_external_media_item_dbus_proxy_set_sample_rate;
	iface->get_bits_per_sample = rygel_external_media_item_dbus_proxy_get_bits_per_sample;
	iface->set_bits_per_sample = rygel_external_media_item_dbus_proxy_set_bits_per_sample;
	iface->get_width = rygel_external_media_item_dbus_proxy_get_width;
	iface->set_width = rygel_external_media_item_dbus_proxy_set_width;
	iface->get_height = rygel_external_media_item_dbus_proxy_get_height;
	iface->set_height = rygel_external_media_item_dbus_proxy_set_height;
	iface->get_color_depth = rygel_external_media_item_dbus_proxy_get_color_depth;
	iface->set_color_depth = rygel_external_media_item_dbus_proxy_set_color_depth;
	iface->get_thumbnail = rygel_external_media_item_dbus_proxy_get_thumbnail;
	iface->set_thumbnail = rygel_external_media_item_dbus_proxy_set_thumbnail;
	iface->get_album_art = rygel_external_media_item_dbus_proxy_get_album_art;
	iface->set_album_art = rygel_external_media_item_dbus_proxy_set_album_art;
}


static void rygel_external_media_item_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void rygel_external_media_item_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


void free_desktop_dbus_object_list_names (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE (self)->list_names (self, _callback_, _user_data_);
}


char** free_desktop_dbus_object_list_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	return FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE (self)->list_names_finish (self, _res_, result_length1, error);
}


void free_desktop_dbus_object_list_activatable_names (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE (self)->list_activatable_names (self, _callback_, _user_data_);
}


char** free_desktop_dbus_object_list_activatable_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	return FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE (self)->list_activatable_names_finish (self, _res_, result_length1, error);
}


void _free_desktop_dbus_object_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_free_desktop_dbus_object_introspect (FreeDesktopDBusObject* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus\">\n  <method name=\"ListNames\">\n    <arg name=\"result\" type=\"as\" direction=\"out\"/>\n  </method>\n  <method name=\"ListActivatableNames\">\n    <arg name=\"result\" type=\"as\" direction=\"out\"/>\n  </method>\n  <signal name=\"NameOwnerChanged\">\n    <arg name=\"name\" type=\"s\"/>\n    <arg name=\"old_owner\" type=\"s\"/>\n    <arg name=\"new_owner\" type=\"s\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_free_desktop_dbus_object_property_get_all (FreeDesktopDBusObject* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp303_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp303_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp303_);
	if (strcmp (interface_name, "org.freedesktop.DBus") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_free_desktop_dbus_object_list_names (FreeDesktopDBusObject* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	free_desktop_dbus_object_list_names (self, _dbus_free_desktop_dbus_object_list_names_ready, _user_data_);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_free_desktop_dbus_object_list_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	DBusMessage* reply;
	char** _tmp304_;
	DBusMessageIter _tmp305_;
	int _tmp306_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result_length1 = 0;
	result = free_desktop_dbus_object_list_names_finish (source_object, _res_, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp304_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "s", &_tmp305_);
	for (_tmp306_ = 0; _tmp306_ < result_length1; _tmp306_++) {
		const char* _tmp307_;
		_tmp307_ = *_tmp304_;
		dbus_message_iter_append_basic (&_tmp305_, DBUS_TYPE_STRING, &_tmp307_);
		_tmp304_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp305_);
	result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


static DBusHandlerResult _dbus_free_desktop_dbus_object_list_activatable_names (FreeDesktopDBusObject* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	free_desktop_dbus_object_list_activatable_names (self, _dbus_free_desktop_dbus_object_list_activatable_names_ready, _user_data_);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_free_desktop_dbus_object_list_activatable_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	DBusMessage* reply;
	char** _tmp308_;
	DBusMessageIter _tmp309_;
	int _tmp310_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result_length1 = 0;
	result = free_desktop_dbus_object_list_activatable_names_finish (source_object, _res_, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp308_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "s", &_tmp309_);
	for (_tmp310_ = 0; _tmp310_ < result_length1; _tmp310_++) {
		const char* _tmp311_;
		_tmp311_ = *_tmp308_;
		dbus_message_iter_append_basic (&_tmp309_, DBUS_TYPE_STRING, &_tmp311_);
		_tmp308_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp309_);
	result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


DBusHandlerResult free_desktop_dbus_object_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_free_desktop_dbus_object_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_free_desktop_dbus_object_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus", "ListNames")) {
		result = _dbus_free_desktop_dbus_object_list_names (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus", "ListActivatableNames")) {
		result = _dbus_free_desktop_dbus_object_list_activatable_names (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_free_desktop_dbus_object_name_owner_changed (GObject* _sender, const char* name, const char* old_owner, const char* new_owner, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	const char* _tmp312_;
	const char* _tmp313_;
	const char* _tmp314_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.DBus", "NameOwnerChanged");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp312_ = name;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp312_);
	_tmp313_ = old_owner;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp313_);
	_tmp314_ = new_owner;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp314_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void free_desktop_dbus_object_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_free_desktop_dbus_object_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "name-owner-changed", (GCallback) _dbus_free_desktop_dbus_object_name_owner_changed, connection);
}


static void free_desktop_dbus_object_base_init (FreeDesktopDBusObjectIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("name_owner_changed", FREE_DESKTOP_TYPE_DBUS_OBJECT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
		g_type_set_qdata (FREE_DESKTOP_TYPE_DBUS_OBJECT, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_free_desktop_dbus_object_dbus_vtable));
	}
}


GType free_desktop_dbus_object_get_type (void) {
	static volatile gsize free_desktop_dbus_object_type_id__volatile = 0;
	if (g_once_init_enter (&free_desktop_dbus_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FreeDesktopDBusObjectIface), (GBaseInitFunc) free_desktop_dbus_object_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType free_desktop_dbus_object_type_id;
		free_desktop_dbus_object_type_id = g_type_register_static (G_TYPE_INTERFACE, "FreeDesktopDBusObject", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (free_desktop_dbus_object_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (free_desktop_dbus_object_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &free_desktop_dbus_object_dbus_proxy_get_type);
		g_once_init_leave (&free_desktop_dbus_object_type_id__volatile, free_desktop_dbus_object_type_id);
	}
	return free_desktop_dbus_object_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (FreeDesktopDBusObjectDBusProxy, free_desktop_dbus_object_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (FREE_DESKTOP_TYPE_DBUS_OBJECT, free_desktop_dbus_object_dbus_proxy_free_desktop_dbus_object__interface_init) );
FreeDesktopDBusObject* free_desktop_dbus_object_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	FreeDesktopDBusObject* self;
	self = g_object_new (free_desktop_dbus_object_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.DBus", NULL);
	return self;
}


static GObject* free_desktop_dbus_object_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (free_desktop_dbus_object_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), free_desktop_dbus_object_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_free_desktop_dbus_object_name_owner_changed (FreeDesktopDBusObject* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* name = NULL;
	const char* _tmp315_;
	char* old_owner = NULL;
	const char* _tmp316_;
	char* new_owner = NULL;
	const char* _tmp317_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "sss")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp315_);
	dbus_message_iter_next (&iter);
	name = g_strdup (_tmp315_);
	dbus_message_iter_get_basic (&iter, &_tmp316_);
	dbus_message_iter_next (&iter);
	old_owner = g_strdup (_tmp316_);
	dbus_message_iter_get_basic (&iter, &_tmp317_);
	dbus_message_iter_next (&iter);
	new_owner = g_strdup (_tmp317_);
	g_signal_emit_by_name (self, "name-owner-changed", name, old_owner, new_owner);
	_g_free0 (name);
	_g_free0 (old_owner);
	_g_free0 (new_owner);
}


DBusHandlerResult free_desktop_dbus_object_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.freedesktop.DBus", "NameOwnerChanged")) {
			_dbus_handle_free_desktop_dbus_object_name_owner_changed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void free_desktop_dbus_object_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((FreeDesktopDBusObjectDBusProxy*) self)->disposed) {
		return;
	}
	((FreeDesktopDBusObjectDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), free_desktop_dbus_object_dbus_proxy_filter, self);
	G_OBJECT_CLASS (free_desktop_dbus_object_dbus_proxy_parent_class)->dispose (self);
}


static void free_desktop_dbus_object_dbus_proxy_class_init (FreeDesktopDBusObjectDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = free_desktop_dbus_object_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = free_desktop_dbus_object_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = free_desktop_dbus_object_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = free_desktop_dbus_object_dbus_proxy_set_property;
}


static void free_desktop_dbus_object_dbus_proxy_init (FreeDesktopDBusObjectDBusProxy* self) {
}


static void free_desktop_dbus_object_dbus_proxy_list_names_async (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	FreeDesktopDBusObjectDBusProxyListNamesData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus", "ListNames");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (FreeDesktopDBusObjectDBusProxyListNamesData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, free_desktop_dbus_object_dbus_proxy_list_names_ready, _data_, NULL);
}


static void free_desktop_dbus_object_dbus_proxy_list_names_ready (DBusPendingCall* pending, void* user_data) {
	FreeDesktopDBusObjectDBusProxyListNamesData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (FreeDesktopDBusObjectDBusProxyListNamesData, _data_);
	dbus_pending_call_unref (pending);
}


static char** free_desktop_dbus_object_dbus_proxy_list_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	FreeDesktopDBusObjectDBusProxyListNamesData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	char** _tmp322_;
	int _tmp322__length;
	int _tmp322__size;
	int _tmp322__length1;
	DBusMessageIter _tmp323_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp321_;
			_edomain = DBUS_GERROR;
			_tmp321_ = _dbus_error.name + 27;
			if (strcmp (_tmp321_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp321_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp321_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp321_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp321_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp321_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp321_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp321_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp321_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp321_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp321_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp321_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp321_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp321_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp321_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp321_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp321_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp321_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp321_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp321_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp321_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp321_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp321_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp321_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp321_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp321_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp321_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp321_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp321_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp321_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp321_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp321_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp321_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "as")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "as", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp322_ = g_new (char*, 5);
	_tmp322__length = 0;
	_tmp322__size = 4;
	_tmp322__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp323_);
	for (; dbus_message_iter_get_arg_type (&_tmp323_); _tmp322__length1++) {
		const char* _tmp324_;
		if (_tmp322__size == _tmp322__length) {
			_tmp322__size = 2 * _tmp322__size;
			_tmp322_ = g_renew (char*, _tmp322_, _tmp322__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp323_, &_tmp324_);
		dbus_message_iter_next (&_tmp323_);
		_tmp322_[_tmp322__length++] = g_strdup (_tmp324_);
	}
	_result_length1 = _tmp322__length1;
	_tmp322_[_tmp322__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp322_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static void free_desktop_dbus_object_dbus_proxy_list_activatable_names_async (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	FreeDesktopDBusObjectDBusProxyListActivatableNamesData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus", "ListActivatableNames");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (FreeDesktopDBusObjectDBusProxyListActivatableNamesData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, free_desktop_dbus_object_dbus_proxy_list_activatable_names_ready, _data_, NULL);
}


static void free_desktop_dbus_object_dbus_proxy_list_activatable_names_ready (DBusPendingCall* pending, void* user_data) {
	FreeDesktopDBusObjectDBusProxyListActivatableNamesData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (FreeDesktopDBusObjectDBusProxyListActivatableNamesData, _data_);
	dbus_pending_call_unref (pending);
}


static char** free_desktop_dbus_object_dbus_proxy_list_activatable_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	FreeDesktopDBusObjectDBusProxyListActivatableNamesData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	char** _tmp329_;
	int _tmp329__length;
	int _tmp329__size;
	int _tmp329__length1;
	DBusMessageIter _tmp330_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp328_;
			_edomain = DBUS_GERROR;
			_tmp328_ = _dbus_error.name + 27;
			if (strcmp (_tmp328_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp328_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp328_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp328_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp328_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp328_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp328_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp328_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp328_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp328_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp328_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp328_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp328_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp328_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp328_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp328_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp328_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp328_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp328_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp328_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp328_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp328_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp328_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp328_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp328_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp328_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp328_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp328_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp328_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp328_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp328_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp328_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp328_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "as")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "as", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp329_ = g_new (char*, 5);
	_tmp329__length = 0;
	_tmp329__size = 4;
	_tmp329__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp330_);
	for (; dbus_message_iter_get_arg_type (&_tmp330_); _tmp329__length1++) {
		const char* _tmp331_;
		if (_tmp329__size == _tmp329__length) {
			_tmp329__size = 2 * _tmp329__size;
			_tmp329_ = g_renew (char*, _tmp329_, _tmp329__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp330_, &_tmp331_);
		dbus_message_iter_next (&_tmp330_);
		_tmp329_[_tmp329__length++] = g_strdup (_tmp331_);
	}
	_result_length1 = _tmp329__length1;
	_tmp329_[_tmp329__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp329_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static void free_desktop_dbus_object_dbus_proxy_free_desktop_dbus_object__interface_init (FreeDesktopDBusObjectIface* iface) {
	iface->list_names = free_desktop_dbus_object_dbus_proxy_list_names_async;
	iface->list_names_finish = free_desktop_dbus_object_dbus_proxy_list_names_finish;
	iface->list_activatable_names = free_desktop_dbus_object_dbus_proxy_list_activatable_names_async;
	iface->list_activatable_names_finish = free_desktop_dbus_object_dbus_proxy_list_activatable_names_finish;
}


static void free_desktop_dbus_object_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void free_desktop_dbus_object_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


void free_desktop_properties_get_all (FreeDesktopProperties* self, const char* iface, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FREE_DESKTOP_PROPERTIES_GET_INTERFACE (self)->get_all (self, iface, _callback_, _user_data_);
}


GHashTable* free_desktop_properties_get_all_finish (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error) {
	return FREE_DESKTOP_PROPERTIES_GET_INTERFACE (self)->get_all_finish (self, _res_, error);
}


void _free_desktop_properties_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_free_desktop_properties_introspect (FreeDesktopProperties* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"GetAll\">\n    <arg name=\"iface\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"a{sv}\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_free_desktop_properties_property_get_all (FreeDesktopProperties* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp332_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp332_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp332_);
	if (strcmp (interface_name, "org.freedesktop.DBus.Properties") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_free_desktop_properties_get_all (FreeDesktopProperties* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* iface = NULL;
	const char* _tmp333_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp333_);
	dbus_message_iter_next (&iter);
	iface = g_strdup (_tmp333_);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	free_desktop_properties_get_all (self, iface, _dbus_free_desktop_properties_get_all_ready, _user_data_);
	_g_free0 (iface);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_free_desktop_properties_get_all_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	GHashTable* result;
	DBusMessage* reply;
	DBusMessageIter _tmp334_, _tmp335_;
	GHashTableIter _tmp336_;
	gpointer _tmp337_, _tmp338_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result = free_desktop_properties_get_all_finish (source_object, _res_, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "{sv}", &_tmp334_);
	g_hash_table_iter_init (&_tmp336_, result);
	while (g_hash_table_iter_next (&_tmp336_, &_tmp337_, &_tmp338_)) {
		char* _key;
		GValue* _value;
		const char* _tmp339_;
		DBusMessageIter _tmp340_;
		dbus_message_iter_open_container (&_tmp334_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp335_);
		_key = (char*) _tmp337_;
		_value = (GValue*) _tmp338_;
		_tmp339_ = _key;
		dbus_message_iter_append_basic (&_tmp335_, DBUS_TYPE_STRING, &_tmp339_);
		if (G_VALUE_TYPE (_value) == G_TYPE_UCHAR) {
			guint8 _tmp341_;
			dbus_message_iter_open_container (&_tmp335_, DBUS_TYPE_VARIANT, "y", &_tmp340_);
			_tmp341_ = g_value_get_uchar (_value);
			dbus_message_iter_append_basic (&_tmp340_, DBUS_TYPE_BYTE, &_tmp341_);
			dbus_message_iter_close_container (&_tmp335_, &_tmp340_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_BOOLEAN) {
			dbus_bool_t _tmp342_;
			dbus_message_iter_open_container (&_tmp335_, DBUS_TYPE_VARIANT, "b", &_tmp340_);
			_tmp342_ = g_value_get_boolean (_value);
			dbus_message_iter_append_basic (&_tmp340_, DBUS_TYPE_BOOLEAN, &_tmp342_);
			dbus_message_iter_close_container (&_tmp335_, &_tmp340_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_INT) {
			dbus_int32_t _tmp343_;
			dbus_message_iter_open_container (&_tmp335_, DBUS_TYPE_VARIANT, "i", &_tmp340_);
			_tmp343_ = g_value_get_int (_value);
			dbus_message_iter_append_basic (&_tmp340_, DBUS_TYPE_INT32, &_tmp343_);
			dbus_message_iter_close_container (&_tmp335_, &_tmp340_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT) {
			dbus_uint32_t _tmp344_;
			dbus_message_iter_open_container (&_tmp335_, DBUS_TYPE_VARIANT, "u", &_tmp340_);
			_tmp344_ = g_value_get_uint (_value);
			dbus_message_iter_append_basic (&_tmp340_, DBUS_TYPE_UINT32, &_tmp344_);
			dbus_message_iter_close_container (&_tmp335_, &_tmp340_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_INT64) {
			dbus_int64_t _tmp345_;
			dbus_message_iter_open_container (&_tmp335_, DBUS_TYPE_VARIANT, "x", &_tmp340_);
			_tmp345_ = g_value_get_int64 (_value);
			dbus_message_iter_append_basic (&_tmp340_, DBUS_TYPE_INT64, &_tmp345_);
			dbus_message_iter_close_container (&_tmp335_, &_tmp340_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT64) {
			dbus_uint64_t _tmp346_;
			dbus_message_iter_open_container (&_tmp335_, DBUS_TYPE_VARIANT, "t", &_tmp340_);
			_tmp346_ = g_value_get_uint64 (_value);
			dbus_message_iter_append_basic (&_tmp340_, DBUS_TYPE_UINT64, &_tmp346_);
			dbus_message_iter_close_container (&_tmp335_, &_tmp340_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_DOUBLE) {
			double _tmp347_;
			dbus_message_iter_open_container (&_tmp335_, DBUS_TYPE_VARIANT, "d", &_tmp340_);
			_tmp347_ = g_value_get_double (_value);
			dbus_message_iter_append_basic (&_tmp340_, DBUS_TYPE_DOUBLE, &_tmp347_);
			dbus_message_iter_close_container (&_tmp335_, &_tmp340_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_STRING) {
			const char* _tmp348_;
			dbus_message_iter_open_container (&_tmp335_, DBUS_TYPE_VARIANT, "s", &_tmp340_);
			_tmp348_ = g_value_get_string (_value);
			dbus_message_iter_append_basic (&_tmp340_, DBUS_TYPE_STRING, &_tmp348_);
			dbus_message_iter_close_container (&_tmp335_, &_tmp340_);
		}
		dbus_message_iter_close_container (&_tmp334_, &_tmp335_);
	}
	dbus_message_iter_close_container (&iter, &_tmp334_);
	_g_hash_table_unref0 (result);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


DBusHandlerResult free_desktop_properties_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_free_desktop_properties_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_free_desktop_properties_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_free_desktop_properties_get_all (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void free_desktop_properties_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_free_desktop_properties_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void free_desktop_properties_base_init (FreeDesktopPropertiesIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (FREE_DESKTOP_TYPE_PROPERTIES, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_free_desktop_properties_dbus_vtable));
	}
}


GType free_desktop_properties_get_type (void) {
	static volatile gsize free_desktop_properties_type_id__volatile = 0;
	if (g_once_init_enter (&free_desktop_properties_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FreeDesktopPropertiesIface), (GBaseInitFunc) free_desktop_properties_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType free_desktop_properties_type_id;
		free_desktop_properties_type_id = g_type_register_static (G_TYPE_INTERFACE, "FreeDesktopProperties", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (free_desktop_properties_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (free_desktop_properties_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &free_desktop_properties_dbus_proxy_get_type);
		g_once_init_leave (&free_desktop_properties_type_id__volatile, free_desktop_properties_type_id);
	}
	return free_desktop_properties_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (FreeDesktopPropertiesDBusProxy, free_desktop_properties_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (FREE_DESKTOP_TYPE_PROPERTIES, free_desktop_properties_dbus_proxy_free_desktop_properties__interface_init) );
FreeDesktopProperties* free_desktop_properties_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	FreeDesktopProperties* self;
	self = g_object_new (free_desktop_properties_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.DBus.Properties", NULL);
	return self;
}


static GObject* free_desktop_properties_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (free_desktop_properties_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), free_desktop_properties_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult free_desktop_properties_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void free_desktop_properties_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((FreeDesktopPropertiesDBusProxy*) self)->disposed) {
		return;
	}
	((FreeDesktopPropertiesDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), free_desktop_properties_dbus_proxy_filter, self);
	G_OBJECT_CLASS (free_desktop_properties_dbus_proxy_parent_class)->dispose (self);
}


static void free_desktop_properties_dbus_proxy_class_init (FreeDesktopPropertiesDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = free_desktop_properties_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = free_desktop_properties_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = free_desktop_properties_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = free_desktop_properties_dbus_proxy_set_property;
}


static void free_desktop_properties_dbus_proxy_init (FreeDesktopPropertiesDBusProxy* self) {
}


static void free_desktop_properties_dbus_proxy_get_all_async (FreeDesktopProperties* self, const char* iface, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	const char* _tmp349_;
	FreeDesktopPropertiesDBusProxyGetAllData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "GetAll");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp349_ = iface;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp349_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (FreeDesktopPropertiesDBusProxyGetAllData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, free_desktop_properties_dbus_proxy_get_all_ready, _data_, NULL);
}


static void free_desktop_properties_dbus_proxy_get_all_ready (DBusPendingCall* pending, void* user_data) {
	FreeDesktopPropertiesDBusProxyGetAllData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (FreeDesktopPropertiesDBusProxyGetAllData, _data_);
	dbus_pending_call_unref (pending);
}


static GHashTable* free_desktop_properties_dbus_proxy_get_all_finish (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error) {
	FreeDesktopPropertiesDBusProxyGetAllData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	GHashTable* _result;
	GHashTable* _tmp370_;
	DBusMessageIter _tmp371_;
	DBusMessageIter _tmp372_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp368_;
			_edomain = DBUS_GERROR;
			_tmp368_ = _dbus_error.name + 27;
			if (strcmp (_tmp368_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp368_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp368_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp368_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp368_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp368_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp368_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp368_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp368_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp368_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp368_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp368_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp368_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp368_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp368_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp368_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp368_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp368_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp368_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp368_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp368_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp368_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp368_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp368_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp368_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp368_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp368_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp368_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp368_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp368_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp368_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp368_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp368_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "a{sv}")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "a{sv}", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_tmp370_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	dbus_message_iter_recurse (&_iter, &_tmp371_);
	while (dbus_message_iter_get_arg_type (&_tmp371_)) {
		char* _key;
		GValue* _value;
		const char* _tmp373_;
		GValue _tmp374_ = {0};
		DBusMessageIter _tmp375_;
		dbus_message_iter_recurse (&_tmp371_, &_tmp372_);
		dbus_message_iter_get_basic (&_tmp372_, &_tmp373_);
		dbus_message_iter_next (&_tmp372_);
		_key = g_strdup (_tmp373_);
		dbus_message_iter_recurse (&_tmp372_, &_tmp375_);
		if (dbus_message_iter_get_arg_type (&_tmp375_) == DBUS_TYPE_BYTE) {
			guint8 _tmp376_;
			dbus_message_iter_get_basic (&_tmp375_, &_tmp376_);
			g_value_init (&_tmp374_, G_TYPE_UCHAR);
			g_value_set_uchar (&_tmp374_, _tmp376_);
		} else if (dbus_message_iter_get_arg_type (&_tmp375_) == DBUS_TYPE_BOOLEAN) {
			dbus_bool_t _tmp377_;
			dbus_message_iter_get_basic (&_tmp375_, &_tmp377_);
			g_value_init (&_tmp374_, G_TYPE_BOOLEAN);
			g_value_set_boolean (&_tmp374_, _tmp377_);
		} else if (dbus_message_iter_get_arg_type (&_tmp375_) == DBUS_TYPE_INT16) {
			dbus_int16_t _tmp378_;
			dbus_message_iter_get_basic (&_tmp375_, &_tmp378_);
			g_value_init (&_tmp374_, G_TYPE_INT);
			g_value_set_int (&_tmp374_, _tmp378_);
		} else if (dbus_message_iter_get_arg_type (&_tmp375_) == DBUS_TYPE_UINT16) {
			dbus_uint16_t _tmp379_;
			dbus_message_iter_get_basic (&_tmp375_, &_tmp379_);
			g_value_init (&_tmp374_, G_TYPE_UINT);
			g_value_set_uint (&_tmp374_, _tmp379_);
		} else if (dbus_message_iter_get_arg_type (&_tmp375_) == DBUS_TYPE_INT32) {
			dbus_int32_t _tmp380_;
			dbus_message_iter_get_basic (&_tmp375_, &_tmp380_);
			g_value_init (&_tmp374_, G_TYPE_INT);
			g_value_set_int (&_tmp374_, _tmp380_);
		} else if (dbus_message_iter_get_arg_type (&_tmp375_) == DBUS_TYPE_UINT32) {
			dbus_uint32_t _tmp381_;
			dbus_message_iter_get_basic (&_tmp375_, &_tmp381_);
			g_value_init (&_tmp374_, G_TYPE_UINT);
			g_value_set_uint (&_tmp374_, _tmp381_);
		} else if (dbus_message_iter_get_arg_type (&_tmp375_) == DBUS_TYPE_INT64) {
			dbus_int64_t _tmp382_;
			dbus_message_iter_get_basic (&_tmp375_, &_tmp382_);
			g_value_init (&_tmp374_, G_TYPE_INT64);
			g_value_set_int64 (&_tmp374_, _tmp382_);
		} else if (dbus_message_iter_get_arg_type (&_tmp375_) == DBUS_TYPE_UINT64) {
			dbus_uint64_t _tmp383_;
			dbus_message_iter_get_basic (&_tmp375_, &_tmp383_);
			g_value_init (&_tmp374_, G_TYPE_UINT64);
			g_value_set_uint64 (&_tmp374_, _tmp383_);
		} else if (dbus_message_iter_get_arg_type (&_tmp375_) == DBUS_TYPE_DOUBLE) {
			double _tmp384_;
			dbus_message_iter_get_basic (&_tmp375_, &_tmp384_);
			g_value_init (&_tmp374_, G_TYPE_DOUBLE);
			g_value_set_double (&_tmp374_, _tmp384_);
		} else if (dbus_message_iter_get_arg_type (&_tmp375_) == DBUS_TYPE_STRING) {
			const char* _tmp385_;
			dbus_message_iter_get_basic (&_tmp375_, &_tmp385_);
			g_value_init (&_tmp374_, G_TYPE_STRING);
			g_value_take_string (&_tmp374_, g_strdup (_tmp385_));
		} else if (dbus_message_iter_get_arg_type (&_tmp375_) == DBUS_TYPE_OBJECT_PATH) {
			const char* _tmp386_;
			dbus_message_iter_get_basic (&_tmp375_, &_tmp386_);
			g_value_init (&_tmp374_, G_TYPE_STRING);
			g_value_take_string (&_tmp374_, g_strdup (_tmp386_));
		} else if (dbus_message_iter_get_arg_type (&_tmp375_) == DBUS_TYPE_SIGNATURE) {
			const char* _tmp387_;
			dbus_message_iter_get_basic (&_tmp375_, &_tmp387_);
			g_value_init (&_tmp374_, G_TYPE_STRING);
			g_value_take_string (&_tmp374_, g_strdup (_tmp387_));
		}
		dbus_message_iter_next (&_tmp372_);
		_value = g_memdup (&_tmp374_, sizeof (GValue));
		g_hash_table_insert (_tmp370_, _key, _value);
		dbus_message_iter_next (&_tmp371_);
	}
	dbus_message_iter_next (&_iter);
	_result = _tmp370_;
	dbus_message_unref (_reply);
	return _result;
}


static void free_desktop_properties_dbus_proxy_free_desktop_properties__interface_init (FreeDesktopPropertiesIface* iface) {
	iface->get_all = free_desktop_properties_dbus_proxy_get_all_async;
	iface->get_all_finish = free_desktop_properties_dbus_proxy_get_all_finish;
}


static void free_desktop_properties_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void free_desktop_properties_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}



static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), data2);
}



