/* rygel-tracker-metadata-values.c generated by valac, the Vala compiler
 * generated from rygel-tracker-metadata-values.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gio/gio.h>
#include <gee.h>


#define RYGEL_TYPE_TRACKER_METADATA_VALUES (rygel_tracker_metadata_values_get_type ())
#define RYGEL_TRACKER_METADATA_VALUES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_METADATA_VALUES, RygelTrackerMetadataValues))
#define RYGEL_TRACKER_METADATA_VALUES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_METADATA_VALUES, RygelTrackerMetadataValuesClass))
#define RYGEL_IS_TRACKER_METADATA_VALUES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_METADATA_VALUES))
#define RYGEL_IS_TRACKER_METADATA_VALUES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_METADATA_VALUES))
#define RYGEL_TRACKER_METADATA_VALUES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_METADATA_VALUES, RygelTrackerMetadataValuesClass))

typedef struct _RygelTrackerMetadataValues RygelTrackerMetadataValues;
typedef struct _RygelTrackerMetadataValuesClass RygelTrackerMetadataValuesClass;
typedef struct _RygelTrackerMetadataValuesPrivate RygelTrackerMetadataValuesPrivate;

#define RYGEL_TYPE_TRACKER_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_IS_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_ITEM_FACTORY))
#define RYGEL_IS_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;

#define RYGEL_TYPE_TRACKER_RESOURCES_IFACE (rygel_tracker_resources_iface_get_type ())
#define RYGEL_TRACKER_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_RESOURCES_IFACE, RygelTrackerResourcesIface))
#define RYGEL_IS_TRACKER_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_RESOURCES_IFACE))
#define RYGEL_TRACKER_RESOURCES_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKER_RESOURCES_IFACE, RygelTrackerResourcesIfaceIface))

typedef struct _RygelTrackerResourcesIface RygelTrackerResourcesIface;
typedef struct _RygelTrackerResourcesIfaceIface RygelTrackerResourcesIfaceIface;

#define RYGEL_TYPE_TRACKER_RESOURCES_CLASS_IFACE (rygel_tracker_resources_class_iface_get_type ())
#define RYGEL_TRACKER_RESOURCES_CLASS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_RESOURCES_CLASS_IFACE, RygelTrackerResourcesClassIface))
#define RYGEL_IS_TRACKER_RESOURCES_CLASS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_RESOURCES_CLASS_IFACE))
#define RYGEL_TRACKER_RESOURCES_CLASS_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKER_RESOURCES_CLASS_IFACE, RygelTrackerResourcesClassIfaceIface))

typedef struct _RygelTrackerResourcesClassIface RygelTrackerResourcesClassIface;
typedef struct _RygelTrackerResourcesClassIfaceIface RygelTrackerResourcesClassIfaceIface;
#define _rygel_tracker_item_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_item_factory_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_TRACKER_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_IS_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_QUERY_TRIPLETS))
#define RYGEL_IS_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define RYGEL_TYPE_TRACKER_QUERY_TRIPLET (rygel_tracker_query_triplet_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_QUERY_TRIPLET, RygelTrackerQueryTriplet))
#define RYGEL_TRACKER_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_QUERY_TRIPLET, RygelTrackerQueryTripletClass))
#define RYGEL_IS_TRACKER_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_QUERY_TRIPLET))
#define RYGEL_IS_TRACKER_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_QUERY_TRIPLET))
#define RYGEL_TRACKER_QUERY_TRIPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_QUERY_TRIPLET, RygelTrackerQueryTripletClass))

typedef struct _RygelTrackerQueryTriplet RygelTrackerQueryTriplet;
typedef struct _RygelTrackerQueryTripletClass RygelTrackerQueryTripletClass;
#define _rygel_tracker_query_triplet_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_triplet_unref (var), NULL)))
typedef struct _RygelTrackerItemFactoryPrivate RygelTrackerItemFactoryPrivate;

#define RYGEL_TYPE_TRACKER_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_IS_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_SEARCH_CONTAINER))
#define RYGEL_IS_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;

#define RYGEL_TYPE_TRACKER_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_QUERY, RygelTrackerQueryClass))
#define RYGEL_IS_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_QUERY))
#define RYGEL_IS_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;

#define RYGEL_TYPE_TRACKER_SELECTION_QUERY (rygel_tracker_selection_query_get_type ())
#define RYGEL_TRACKER_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_SELECTION_QUERY, RygelTrackerSelectionQuery))
#define RYGEL_TRACKER_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_SELECTION_QUERY, RygelTrackerSelectionQueryClass))
#define RYGEL_IS_TRACKER_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_SELECTION_QUERY))
#define RYGEL_IS_TRACKER_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_SELECTION_QUERY))
#define RYGEL_TRACKER_SELECTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_SELECTION_QUERY, RygelTrackerSelectionQueryClass))

typedef struct _RygelTrackerSelectionQuery RygelTrackerSelectionQuery;
typedef struct _RygelTrackerSelectionQueryClass RygelTrackerSelectionQueryClass;
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;
typedef struct _RygelTrackerSelectionQueryPrivate RygelTrackerSelectionQueryPrivate;
typedef struct _RygelTrackerQueryTripletPrivate RygelTrackerQueryTripletPrivate;
typedef struct _RygelTrackerMetadataValuesFetchMetadataValuesData RygelTrackerMetadataValuesFetchMetadataValuesData;
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))

typedef char* (*RygelTrackerMetadataValuesIDFunc) (const char* value, void* user_data);
typedef char* (*RygelTrackerMetadataValuesFilterFunc) (const char* variable, const char* value, void* user_data);
struct _RygelTrackerMetadataValues {
	RygelSimpleContainer parent_instance;
	RygelTrackerMetadataValuesPrivate * priv;
	char** key_chain;
	gint key_chain_length1;
	RygelTrackerMetadataValuesIDFunc id_func;
	gpointer id_func_target;
	GDestroyNotify id_func_target_destroy_notify;
	RygelTrackerMetadataValuesIDFunc title_func;
	gpointer title_func_target;
	GDestroyNotify title_func_target_destroy_notify;
	RygelTrackerMetadataValuesFilterFunc filter_func;
	gpointer filter_func_target;
	GDestroyNotify filter_func_target_destroy_notify;
};

struct _RygelTrackerMetadataValuesClass {
	RygelSimpleContainerClass parent_class;
};

struct _RygelTrackerResourcesIfaceIface {
	GTypeInterface parent_iface;
	void (*sparql_query) (RygelTrackerResourcesIface* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*sparql_query_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
	void (*sparql_update_blank) (RygelTrackerResourcesIface* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*sparql_update_blank_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _RygelTrackerResourcesClassIfaceIface {
	GTypeInterface parent_iface;
};

struct _RygelTrackerMetadataValuesPrivate {
	RygelTrackerItemFactory* item_factory;
	RygelTrackerResourcesIface* resources;
	RygelTrackerResourcesClassIface* resources_class;
};

struct _RygelTrackerItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerItemFactoryPrivate * priv;
	char* category;
	char* upnp_class;
	char* resources_class_path;
	char* upload_dir;
	GeeArrayList* key_chains;
};

struct _RygelTrackerItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerItemFactory *self);
	RygelMediaItem* (*create) (RygelTrackerItemFactory* self, const char* id, const char* uri, RygelTrackerSearchContainer* parent, char** metadata, int metadata_length1, GError** error);
};

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* mandatory;
	RygelTrackerQueryTriplets* optional;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	char* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerSelectionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerSelectionQueryPrivate * priv;
	GeeArrayList* variables;
	GeeArrayList* filters;
	char* order_by;
	gint offset;
	gint max_count;
	char** result;
	gint result_length1;
	gint result_length2;
};

struct _RygelTrackerSelectionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerQueryTriplet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryTripletPrivate * priv;
	char* subject;
	char* predicate;
	char* obj;
	gboolean optional;
	RygelTrackerQueryTriplet* next;
};

struct _RygelTrackerQueryTripletClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQueryTriplet *self);
};

struct _RygelTrackerMetadataValuesFetchMetadataValuesData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerMetadataValues* self;
	gint i;
	RygelTrackerQueryTriplets* mandatory;
	gint num_keys;
	char** variables;
	char** _tmp0_;
	gint variables_size;
	gint variables_length1;
	gboolean _tmp1_;
	char* _tmp3_;
	char* _tmp2_;
	char* subject;
	char* _tmp4_;
	char* _tmp5_;
	RygelTrackerQueryTriplet* _tmp6_;
	RygelTrackerQueryTriplet* _tmp7_;
	GeeArrayList* selected;
	char* last_variable;
	char* _tmp8_;
	RygelTrackerSelectionQuery* query;
	char* _tmp9_;
	GError * _error_;
	gboolean _tmp10_;
	char* value;
	char* id;
	char* title;
	RygelTrackerQueryTriplets* child_mandatory;
	GeeArrayList* filters;
	char* filter;
	RygelTrackerQueryTriplet* _tmp11_;
	char* _tmp12_;
	RygelTrackerSearchContainer* container;
	GError * _inner_error_;
};


static gpointer rygel_tracker_metadata_values_parent_class = NULL;

GType rygel_tracker_metadata_values_get_type (void);
gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_tracker_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_tracker_item_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_tracker_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void);
GType rygel_tracker_resources_iface_get_type (void);
GType rygel_tracker_resources_class_iface_get_type (void);
#define RYGEL_TRACKER_METADATA_VALUES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TRACKER_METADATA_VALUES, RygelTrackerMetadataValuesPrivate))
enum  {
	RYGEL_TRACKER_METADATA_VALUES_DUMMY_PROPERTY
};
#define RYGEL_TRACKER_METADATA_VALUES_TRACKER_SERVICE "org.freedesktop.Tracker1"
#define RYGEL_TRACKER_METADATA_VALUES_RESOURCES_PATH "/org/freedesktop/Tracker1/Resources"
#define RYGEL_TRACKER_METADATA_VALUES_ITEM_VARIABLE "?item"
static char** _vala_array_dup1 (char** self, int length);
static void rygel_tracker_metadata_values_create_proxies (RygelTrackerMetadataValues* self, GError** error);
static void rygel_tracker_metadata_values_fetch_metadata_values (RygelTrackerMetadataValues* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_metadata_values_fetch_metadata_values_finish (RygelTrackerMetadataValues* self, GAsyncResult* _res_);
static void rygel_tracker_metadata_values_hook_to_changes (RygelTrackerMetadataValues* self);
RygelTrackerMetadataValues* rygel_tracker_metadata_values_new (const char* id, RygelMediaContainer* parent, const char* title, RygelTrackerItemFactory* item_factory, char** key_chain, int key_chain_length1, RygelTrackerMetadataValuesIDFunc id_func, void* id_func_target, RygelTrackerMetadataValuesIDFunc title_func, void* title_func_target, RygelTrackerMetadataValuesFilterFunc filter_func, void* filter_func_target);
RygelTrackerMetadataValues* rygel_tracker_metadata_values_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, RygelTrackerItemFactory* item_factory, char** key_chain, int key_chain_length1, RygelTrackerMetadataValuesIDFunc id_func, void* id_func_target, RygelTrackerMetadataValuesIDFunc title_func, void* title_func_target, RygelTrackerMetadataValuesFilterFunc filter_func, void* filter_func_target);
static void rygel_tracker_metadata_values_fetch_metadata_values_data_free (gpointer _data);
static void rygel_tracker_metadata_values_fetch_metadata_values_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new (void);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct (GType object_type);
GType rygel_tracker_query_triplets_get_type (void);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_new (const char* subject, const char* predicate, const char* obj, gboolean optional);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_construct (GType object_type, const char* subject, const char* predicate, const char* obj, gboolean optional);
gpointer rygel_tracker_query_triplet_ref (gpointer instance);
void rygel_tracker_query_triplet_unref (gpointer instance);
GParamSpec* rygel_param_spec_tracker_query_triplet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_tracker_query_triplet (GValue* value, gpointer v_object);
gpointer rygel_value_get_tracker_query_triplet (const GValue* value);
GType rygel_tracker_query_triplet_get_type (void);
GType rygel_tracker_search_container_get_type (void);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new (GeeArrayList* variables, RygelTrackerQueryTriplets* mandatory, RygelTrackerQueryTriplets* optional, GeeArrayList* filters, const char* order_by, gint offset, gint max_count);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct (GType object_type, GeeArrayList* variables, RygelTrackerQueryTriplets* mandatory, RygelTrackerQueryTriplets* optional, GeeArrayList* filters, const char* order_by, gint offset, gint max_count);
gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_param_spec_tracker_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_tracker_query (GValue* value, gpointer v_object);
gpointer rygel_value_get_tracker_query (const GValue* value);
GType rygel_tracker_query_get_type (void);
GType rygel_tracker_selection_query_get_type (void);
void rygel_tracker_query_execute (RygelTrackerQuery* self, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_query_execute_finish (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_tracker_metadata_values_is_child_id_unique (RygelTrackerMetadataValues* self, const char* child_id);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new_clone (RygelTrackerQueryTriplets* triplets);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct_clone (GType object_type, RygelTrackerQueryTriplets* triplets);
RygelTrackerSearchContainer* rygel_tracker_search_container_new (const char* id, RygelMediaContainer* parent, const char* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* mandatory, GeeArrayList* filters);
RygelTrackerSearchContainer* rygel_tracker_search_container_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* mandatory, GeeArrayList* filters);
static gboolean rygel_tracker_metadata_values_fetch_metadata_values_co (RygelTrackerMetadataValuesFetchMetadataValuesData* data);
char* rygel_tracker_metadata_values_default_id_func (const char* value);
char* rygel_tracker_metadata_values_default_filter_func (const char* variable, const char* value);
static void _lambda0_ (char** subjects, int subjects_length1, RygelTrackerMetadataValues* self);
static void __lambda0__rygel_tracker_resources_class_iface_subjects_added (RygelTrackerResourcesClassIface* _sender, char** subjects, int subjects_length1, gpointer self);
static void _lambda1_ (char** subjects, int subjects_length1, RygelTrackerMetadataValues* self);
static void __lambda1__rygel_tracker_resources_class_iface_subjects_removed (RygelTrackerResourcesClassIface* _sender, char** subjects, int subjects_length1, gpointer self);
static void _lambda2_ (char** before, int before_length1, char** after, int after_length1, RygelTrackerMetadataValues* self);
static void __lambda2__rygel_tracker_resources_class_iface_subjects_changed (RygelTrackerResourcesClassIface* _sender, char** before, int before_length1, char** after, int after_length1, gpointer self);
static void rygel_tracker_metadata_values_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _rygel_tracker_item_factory_ref0 (gpointer self) {
	return self ? rygel_tracker_item_factory_ref (self) : NULL;
}


static char** _vala_array_dup1 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


#line 53 "rygel-tracker-metadata-values.vala"
RygelTrackerMetadataValues* rygel_tracker_metadata_values_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, RygelTrackerItemFactory* item_factory, char** key_chain, int key_chain_length1, RygelTrackerMetadataValuesIDFunc id_func, void* id_func_target, RygelTrackerMetadataValuesIDFunc title_func, void* title_func_target, RygelTrackerMetadataValuesFilterFunc filter_func, void* filter_func_target) {
#line 374 "rygel-tracker-metadata-values.c"
	GError * _inner_error_;
	RygelTrackerMetadataValues * self;
	RygelTrackerItemFactory* _tmp0_;
	char** _tmp2_;
	char** _tmp1_;
	RygelTrackerMetadataValuesIDFunc _tmp3_;
	RygelTrackerMetadataValuesIDFunc _tmp4_;
	RygelTrackerMetadataValuesFilterFunc _tmp5_;
#line 53 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 53 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 53 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 53 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (item_factory != NULL, NULL);
#line 391 "rygel-tracker-metadata-values.c"
	_inner_error_ = NULL;
#line 64 "rygel-tracker-metadata-values.vala"
	self = (RygelTrackerMetadataValues*) rygel_simple_container_construct (object_type, id, parent, title);
#line 66 "rygel-tracker-metadata-values.vala"
	self->priv->item_factory = (_tmp0_ = _rygel_tracker_item_factory_ref0 (item_factory), _rygel_tracker_item_factory_unref0 (self->priv->item_factory), _tmp0_);
#line 67 "rygel-tracker-metadata-values.vala"
	self->key_chain = (_tmp2_ = (_tmp1_ = key_chain, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup1 (_tmp1_, key_chain_length1)), self->key_chain = (_vala_array_free (self->key_chain, self->key_chain_length1, (GDestroyNotify) g_free), NULL), self->key_chain_length1 = key_chain_length1, _tmp2_);
#line 68 "rygel-tracker-metadata-values.vala"
	self->id_func = (_tmp3_ = id_func, ((self->id_func_target_destroy_notify == NULL) ? NULL : self->id_func_target_destroy_notify (self->id_func_target), self->id_func = NULL, self->id_func_target = NULL, self->id_func_target_destroy_notify = NULL), self->id_func_target = id_func_target, self->id_func_target_destroy_notify = NULL, _tmp3_);
#line 69 "rygel-tracker-metadata-values.vala"
	self->title_func = (_tmp4_ = title_func, ((self->title_func_target_destroy_notify == NULL) ? NULL : self->title_func_target_destroy_notify (self->title_func_target), self->title_func = NULL, self->title_func_target = NULL, self->title_func_target_destroy_notify = NULL), self->title_func_target = title_func_target, self->title_func_target_destroy_notify = NULL, _tmp4_);
#line 70 "rygel-tracker-metadata-values.vala"
	self->filter_func = (_tmp5_ = filter_func, ((self->filter_func_target_destroy_notify == NULL) ? NULL : self->filter_func_target_destroy_notify (self->filter_func_target), self->filter_func = NULL, self->filter_func_target = NULL, self->filter_func_target_destroy_notify = NULL), self->filter_func_target = filter_func_target, self->filter_func_target_destroy_notify = NULL, _tmp5_);
#line 405 "rygel-tracker-metadata-values.c"
	{
#line 73 "rygel-tracker-metadata-values.vala"
		rygel_tracker_metadata_values_create_proxies (self, &_inner_error_);
#line 409 "rygel-tracker-metadata-values.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch1_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally1;
	__catch1_dbus_gerror:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 75 "rygel-tracker-metadata-values.vala"
			g_critical ("rygel-tracker-metadata-values.vala:75: Failed to create to Session bus: %s\n", _error_->message);
#line 428 "rygel-tracker-metadata-values.c"
			_g_error_free0 (_error_);
#line 78 "rygel-tracker-metadata-values.vala"
			return self;
#line 432 "rygel-tracker-metadata-values.c"
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 81 "rygel-tracker-metadata-values.vala"
	rygel_tracker_metadata_values_fetch_metadata_values (self, NULL, NULL);
#line 83 "rygel-tracker-metadata-values.vala"
	rygel_tracker_metadata_values_hook_to_changes (self);
#line 445 "rygel-tracker-metadata-values.c"
	return self;
}


#line 53 "rygel-tracker-metadata-values.vala"
RygelTrackerMetadataValues* rygel_tracker_metadata_values_new (const char* id, RygelMediaContainer* parent, const char* title, RygelTrackerItemFactory* item_factory, char** key_chain, int key_chain_length1, RygelTrackerMetadataValuesIDFunc id_func, void* id_func_target, RygelTrackerMetadataValuesIDFunc title_func, void* title_func_target, RygelTrackerMetadataValuesFilterFunc filter_func, void* filter_func_target) {
#line 53 "rygel-tracker-metadata-values.vala"
	return rygel_tracker_metadata_values_construct (RYGEL_TYPE_TRACKER_METADATA_VALUES, id, parent, title, item_factory, key_chain, key_chain_length1, id_func, id_func_target, title_func, title_func_target, filter_func, filter_func_target);
#line 454 "rygel-tracker-metadata-values.c"
}


static void rygel_tracker_metadata_values_fetch_metadata_values_data_free (gpointer _data) {
	RygelTrackerMetadataValuesFetchMetadataValuesData* data;
	data = _data;
	g_slice_free (RygelTrackerMetadataValuesFetchMetadataValuesData, data);
}


static void rygel_tracker_metadata_values_fetch_metadata_values (RygelTrackerMetadataValues* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerMetadataValuesFetchMetadataValuesData* _data_;
	_data_ = g_slice_new0 (RygelTrackerMetadataValuesFetchMetadataValuesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_metadata_values_fetch_metadata_values);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_metadata_values_fetch_metadata_values_data_free);
	_data_->self = self;
	rygel_tracker_metadata_values_fetch_metadata_values_co (_data_);
}


static void rygel_tracker_metadata_values_fetch_metadata_values_finish (RygelTrackerMetadataValues* self, GAsyncResult* _res_) {
	RygelTrackerMetadataValuesFetchMetadataValuesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_tracker_metadata_values_fetch_metadata_values_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerMetadataValuesFetchMetadataValuesData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_tracker_metadata_values_fetch_metadata_values_co (data);
}


#line 1025 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 491 "rygel-tracker-metadata-values.c"
	char* result;
	GError * _inner_error_;
#line 1025 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1025 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1025 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 500 "rygel-tracker-metadata-values.c"
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1027 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 509 "rygel-tracker-metadata-values.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1028 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 520 "rygel-tracker-metadata-values.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1028 "glib-2.0.vapi"
		return result;
#line 535 "rygel-tracker-metadata-values.c"
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1030 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 546 "rygel-tracker-metadata-values.c"
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gboolean rygel_tracker_metadata_values_fetch_metadata_values_co (RygelTrackerMetadataValuesFetchMetadataValuesData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
#line 88 "rygel-tracker-metadata-values.vala"
			rygel_simple_container_clear ((RygelSimpleContainer*) data->self);
#line 567 "rygel-tracker-metadata-values.c"
			data->mandatory = rygel_tracker_query_triplets_new ();
			data->num_keys = data->self->key_chain_length1 - 1;
			data->variables = (data->_tmp0_ = g_new0 (char*, data->num_keys + 1), data->variables_length1 = data->num_keys, data->variables_size = data->variables_length1, data->_tmp0_);
			{
#line 96 "rygel-tracker-metadata-values.vala"
				data->i = 0;
#line 574 "rygel-tracker-metadata-values.c"
				data->_tmp1_ = TRUE;
#line 96 "rygel-tracker-metadata-values.vala"
				while (TRUE) {
#line 96 "rygel-tracker-metadata-values.vala"
					if (!data->_tmp1_) {
#line 96 "rygel-tracker-metadata-values.vala"
						data->i++;
#line 582 "rygel-tracker-metadata-values.c"
					}
#line 96 "rygel-tracker-metadata-values.vala"
					data->_tmp1_ = FALSE;
#line 96 "rygel-tracker-metadata-values.vala"
					if (!(data->i < data->num_keys)) {
#line 96 "rygel-tracker-metadata-values.vala"
						break;
#line 590 "rygel-tracker-metadata-values.c"
					}
#line 97 "rygel-tracker-metadata-values.vala"
					data->variables[data->i] = (data->_tmp3_ = g_strconcat ("?", data->_tmp2_ = string_replace (data->self->key_chain[data->i], ":", "_"), NULL), _g_free0 (data->variables[data->i]), data->_tmp3_);
#line 594 "rygel-tracker-metadata-values.c"
					_g_free0 (data->_tmp2_);
#line 100 "rygel-tracker-metadata-values.vala"
					if (data->i == 0) {
#line 101 "rygel-tracker-metadata-values.vala"
						data->subject = (data->_tmp4_ = NULL, _g_free0 (data->subject), data->_tmp4_);
#line 600 "rygel-tracker-metadata-values.c"
					} else {
#line 103 "rygel-tracker-metadata-values.vala"
						data->subject = (data->_tmp5_ = g_strdup (data->variables[data->i - 1]), _g_free0 (data->subject), data->_tmp5_);
#line 604 "rygel-tracker-metadata-values.c"
					}
#line 106 "rygel-tracker-metadata-values.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) data->mandatory, data->_tmp6_ = rygel_tracker_query_triplet_new (data->subject, data->self->key_chain[data->i], data->variables[data->i], FALSE));
#line 608 "rygel-tracker-metadata-values.c"
					_rygel_tracker_query_triplet_unref0 (data->_tmp6_);
					_g_free0 (data->subject);
				}
			}
#line 112 "rygel-tracker-metadata-values.vala"
			gee_abstract_list_insert ((GeeAbstractList*) data->mandatory, 0, data->_tmp7_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_METADATA_VALUES_ITEM_VARIABLE, "a", data->self->priv->item_factory->category, FALSE));
#line 615 "rygel-tracker-metadata-values.c"
			_rygel_tracker_query_triplet_unref0 (data->_tmp7_);
			data->selected = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
			data->last_variable = g_strdup (data->variables[data->num_keys - 1]);
#line 122 "rygel-tracker-metadata-values.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) data->selected, data->_tmp8_ = g_strconcat ("DISTINCT ", data->last_variable, NULL));
#line 621 "rygel-tracker-metadata-values.c"
			_g_free0 (data->_tmp8_);
			data->query = rygel_tracker_selection_query_new (data->selected, data->mandatory, NULL, NULL, data->last_variable, 0, -1);
			{
				data->_state_ = 1;
				rygel_tracker_query_execute ((RygelTrackerQuery*) data->query, data->self->priv->resources, rygel_tracker_metadata_values_fetch_metadata_values_ready, data);
				return FALSE;
				case 1:
#line 131 "rygel-tracker-metadata-values.vala"
				rygel_tracker_query_execute_finish ((RygelTrackerQuery*) data->query, data->_res_, &data->_inner_error_);
#line 631 "rygel-tracker-metadata-values.c"
				if (data->_inner_error_ != NULL) {
					if (data->_inner_error_->domain == DBUS_GERROR) {
						goto __catch3_dbus_gerror;
					}
					_g_object_unref0 (data->mandatory);
					data->variables = (_vala_array_free (data->variables, data->variables_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (data->selected);
					_g_free0 (data->last_variable);
					_rygel_tracker_query_unref0 (data->query);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
			}
			goto __finally3;
			__catch3_dbus_gerror:
			{
				data->_error_ = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
#line 133 "rygel-tracker-metadata-values.vala"
					g_critical ("rygel-tracker-metadata-values.vala:133: error getting all values for '%s': %s", data->_tmp9_ = g_strjoinv (" -> ", data->self->key_chain), data->_error_->message);
#line 654 "rygel-tracker-metadata-values.c"
					_g_free0 (data->_tmp9_);
					_g_error_free0 (data->_error_);
					_g_object_unref0 (data->mandatory);
					data->variables = (_vala_array_free (data->variables, data->variables_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (data->selected);
					_g_free0 (data->last_variable);
					_rygel_tracker_query_unref0 (data->query);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
					_g_error_free0 (data->_error_);
				}
			}
			__finally3:
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->mandatory);
				data->variables = (_vala_array_free (data->variables, data->variables_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (data->selected);
				_g_free0 (data->last_variable);
				_rygel_tracker_query_unref0 (data->query);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			{
#line 141 "rygel-tracker-metadata-values.vala"
				data->i = 0;
#line 688 "rygel-tracker-metadata-values.c"
				data->_tmp10_ = TRUE;
#line 141 "rygel-tracker-metadata-values.vala"
				while (TRUE) {
#line 141 "rygel-tracker-metadata-values.vala"
					if (!data->_tmp10_) {
#line 141 "rygel-tracker-metadata-values.vala"
						data->i++;
#line 696 "rygel-tracker-metadata-values.c"
					}
#line 141 "rygel-tracker-metadata-values.vala"
					data->_tmp10_ = FALSE;
#line 141 "rygel-tracker-metadata-values.vala"
					if (!(data->i < data->query->result_length1)) {
#line 141 "rygel-tracker-metadata-values.vala"
						break;
#line 704 "rygel-tracker-metadata-values.c"
					}
					data->value = g_strdup (data->query->result[(data->i * data->query->result_length2) + 0]);
#line 144 "rygel-tracker-metadata-values.vala"
					if (_vala_strcmp0 (data->value, "") == 0) {
#line 709 "rygel-tracker-metadata-values.c"
						_g_free0 (data->value);
#line 145 "rygel-tracker-metadata-values.vala"
						continue;
#line 713 "rygel-tracker-metadata-values.c"
					}
					data->id = data->self->id_func (data->value, data->self->id_func_target);
#line 149 "rygel-tracker-metadata-values.vala"
					if (!rygel_tracker_metadata_values_is_child_id_unique (data->self, data->id)) {
#line 718 "rygel-tracker-metadata-values.c"
						_g_free0 (data->value);
						_g_free0 (data->id);
#line 150 "rygel-tracker-metadata-values.vala"
						continue;
#line 723 "rygel-tracker-metadata-values.c"
					}
					data->title = data->self->title_func (data->value, data->self->title_func_target);
					data->child_mandatory = rygel_tracker_query_triplets_new_clone (data->mandatory);
					data->filters = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
					data->filter = (data->_tmp12_ = data->self->filter_func ((data->_tmp11_ = (RygelTrackerQueryTriplet*) gee_abstract_list_last ((GeeAbstractList*) data->child_mandatory))->obj, data->value, data->self->filter_func_target), _rygel_tracker_query_triplet_unref0 (data->_tmp11_), data->_tmp12_);
#line 162 "rygel-tracker-metadata-values.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) data->filters, data->filter);
#line 731 "rygel-tracker-metadata-values.c"
					data->container = rygel_tracker_search_container_new (data->id, (RygelMediaContainer*) data->self, data->title, data->self->priv->item_factory, data->child_mandatory, data->filters);
#line 171 "rygel-tracker-metadata-values.vala"
					rygel_simple_container_add_child ((RygelSimpleContainer*) data->self, (RygelMediaObject*) data->container);
#line 735 "rygel-tracker-metadata-values.c"
					_g_free0 (data->value);
					_g_free0 (data->id);
					_g_free0 (data->title);
					_g_object_unref0 (data->child_mandatory);
					_g_object_unref0 (data->filters);
					_g_free0 (data->filter);
					_g_object_unref0 (data->container);
				}
			}
#line 174 "rygel-tracker-metadata-values.vala"
			rygel_media_container_updated ((RygelMediaContainer*) data->self);
#line 747 "rygel-tracker-metadata-values.c"
			_g_object_unref0 (data->mandatory);
			data->variables = (_vala_array_free (data->variables, data->variables_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (data->selected);
			_g_free0 (data->last_variable);
			_rygel_tracker_query_unref0 (data->query);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


#line 177 "rygel-tracker-metadata-values.vala"
char* rygel_tracker_metadata_values_default_id_func (const char* value) {
#line 769 "rygel-tracker-metadata-values.c"
	char* result;
#line 177 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (value != NULL, NULL);
#line 773 "rygel-tracker-metadata-values.c"
	result = g_strdup (value);
#line 178 "rygel-tracker-metadata-values.vala"
	return result;
#line 777 "rygel-tracker-metadata-values.c"
}


#line 181 "rygel-tracker-metadata-values.vala"
char* rygel_tracker_metadata_values_default_filter_func (const char* variable, const char* value) {
#line 783 "rygel-tracker-metadata-values.c"
	char* result;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp2_;
#line 181 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (variable != NULL, NULL);
#line 181 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (value != NULL, NULL);
#line 792 "rygel-tracker-metadata-values.c"
	result = (_tmp2_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (variable, " = \"", NULL), value, NULL), "\"", NULL), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
#line 182 "rygel-tracker-metadata-values.vala"
	return result;
#line 796 "rygel-tracker-metadata-values.c"
}


#line 185 "rygel-tracker-metadata-values.vala"
static void rygel_tracker_metadata_values_create_proxies (RygelTrackerMetadataValues* self, GError** error) {
#line 802 "rygel-tracker-metadata-values.c"
	GError * _inner_error_;
	DBusGConnection* connection;
	RygelTrackerResourcesIface* _tmp0_;
	RygelTrackerResourcesClassIface* _tmp1_;
#line 185 "rygel-tracker-metadata-values.vala"
	g_return_if_fail (self != NULL);
#line 809 "rygel-tracker-metadata-values.c"
	_inner_error_ = NULL;
#line 186 "rygel-tracker-metadata-values.vala"
	connection = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
#line 813 "rygel-tracker-metadata-values.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
#line 188 "rygel-tracker-metadata-values.vala"
	self->priv->resources = (_tmp0_ = rygel_tracker_resources_iface_dbus_proxy_new (connection, RYGEL_TRACKER_METADATA_VALUES_TRACKER_SERVICE, RYGEL_TRACKER_METADATA_VALUES_RESOURCES_PATH), _g_object_unref0 (self->priv->resources), _tmp0_);
#line 191 "rygel-tracker-metadata-values.vala"
	self->priv->resources_class = (_tmp1_ = rygel_tracker_resources_class_iface_dbus_proxy_new (connection, RYGEL_TRACKER_METADATA_VALUES_TRACKER_SERVICE, self->priv->item_factory->resources_class_path), _g_object_unref0 (self->priv->resources_class), _tmp1_);
#line 828 "rygel-tracker-metadata-values.c"
	_dbus_g_connection_unref0 (connection);
}


#line 199 "rygel-tracker-metadata-values.vala"
static void _lambda0_ (char** subjects, int subjects_length1, RygelTrackerMetadataValues* self) {
#line 200 "rygel-tracker-metadata-values.vala"
	rygel_tracker_metadata_values_fetch_metadata_values (self, NULL, NULL);
#line 837 "rygel-tracker-metadata-values.c"
}


#line 199 "rygel-tracker-metadata-values.vala"
static void __lambda0__rygel_tracker_resources_class_iface_subjects_added (RygelTrackerResourcesClassIface* _sender, char** subjects, int subjects_length1, gpointer self) {
#line 843 "rygel-tracker-metadata-values.c"
	_lambda0_ (subjects, subjects_length1, self);
}


#line 202 "rygel-tracker-metadata-values.vala"
static void _lambda1_ (char** subjects, int subjects_length1, RygelTrackerMetadataValues* self) {
#line 203 "rygel-tracker-metadata-values.vala"
	rygel_tracker_metadata_values_fetch_metadata_values (self, NULL, NULL);
#line 852 "rygel-tracker-metadata-values.c"
}


#line 202 "rygel-tracker-metadata-values.vala"
static void __lambda1__rygel_tracker_resources_class_iface_subjects_removed (RygelTrackerResourcesClassIface* _sender, char** subjects, int subjects_length1, gpointer self) {
#line 858 "rygel-tracker-metadata-values.c"
	_lambda1_ (subjects, subjects_length1, self);
}


#line 205 "rygel-tracker-metadata-values.vala"
static void _lambda2_ (char** before, int before_length1, char** after, int after_length1, RygelTrackerMetadataValues* self) {
#line 206 "rygel-tracker-metadata-values.vala"
	rygel_tracker_metadata_values_fetch_metadata_values (self, NULL, NULL);
#line 867 "rygel-tracker-metadata-values.c"
}


#line 205 "rygel-tracker-metadata-values.vala"
static void __lambda2__rygel_tracker_resources_class_iface_subjects_changed (RygelTrackerResourcesClassIface* _sender, char** before, int before_length1, char** after, int after_length1, gpointer self) {
#line 873 "rygel-tracker-metadata-values.c"
	_lambda2_ (before, before_length1, after, after_length1, self);
}


#line 197 "rygel-tracker-metadata-values.vala"
static void rygel_tracker_metadata_values_hook_to_changes (RygelTrackerMetadataValues* self) {
#line 197 "rygel-tracker-metadata-values.vala"
	g_return_if_fail (self != NULL);
#line 199 "rygel-tracker-metadata-values.vala"
	g_signal_connect_object (self->priv->resources_class, "subjects-added", (GCallback) __lambda0__rygel_tracker_resources_class_iface_subjects_added, self, 0);
#line 202 "rygel-tracker-metadata-values.vala"
	g_signal_connect_object (self->priv->resources_class, "subjects-removed", (GCallback) __lambda1__rygel_tracker_resources_class_iface_subjects_removed, self, 0);
#line 205 "rygel-tracker-metadata-values.vala"
	g_signal_connect_object (self->priv->resources_class, "subjects-changed", (GCallback) __lambda2__rygel_tracker_resources_class_iface_subjects_changed, self, 0);
#line 888 "rygel-tracker-metadata-values.c"
}


#line 210 "rygel-tracker-metadata-values.vala"
static gboolean rygel_tracker_metadata_values_is_child_id_unique (RygelTrackerMetadataValues* self, const char* child_id) {
#line 894 "rygel-tracker-metadata-values.c"
	gboolean result;
	gboolean unique;
#line 210 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 210 "rygel-tracker-metadata-values.vala"
	g_return_val_if_fail (child_id != NULL, FALSE);
#line 211 "rygel-tracker-metadata-values.vala"
	unique = TRUE;
#line 903 "rygel-tracker-metadata-values.c"
	{
		GeeIterator* _child_it;
		_child_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) ((RygelSimpleContainer*) self)->children);
#line 213 "rygel-tracker-metadata-values.vala"
		while (TRUE) {
#line 909 "rygel-tracker-metadata-values.c"
			RygelMediaObject* child;
#line 213 "rygel-tracker-metadata-values.vala"
			if (!gee_iterator_next (_child_it)) {
#line 213 "rygel-tracker-metadata-values.vala"
				break;
#line 915 "rygel-tracker-metadata-values.c"
			}
#line 213 "rygel-tracker-metadata-values.vala"
			child = (RygelMediaObject*) gee_iterator_get (_child_it);
#line 214 "rygel-tracker-metadata-values.vala"
			if (_vala_strcmp0 (child->id, child_id) == 0) {
#line 215 "rygel-tracker-metadata-values.vala"
				unique = FALSE;
#line 923 "rygel-tracker-metadata-values.c"
				_g_object_unref0 (child);
#line 217 "rygel-tracker-metadata-values.vala"
				break;
#line 927 "rygel-tracker-metadata-values.c"
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
	result = unique;
#line 221 "rygel-tracker-metadata-values.vala"
	return result;
#line 936 "rygel-tracker-metadata-values.c"
}


static void rygel_tracker_metadata_values_class_init (RygelTrackerMetadataValuesClass * klass) {
	rygel_tracker_metadata_values_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTrackerMetadataValuesPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_tracker_metadata_values_finalize;
}


static void rygel_tracker_metadata_values_instance_init (RygelTrackerMetadataValues * self) {
	self->priv = RYGEL_TRACKER_METADATA_VALUES_GET_PRIVATE (self);
}


static void rygel_tracker_metadata_values_finalize (GObject* obj) {
	RygelTrackerMetadataValues * self;
	self = RYGEL_TRACKER_METADATA_VALUES (obj);
	_rygel_tracker_item_factory_unref0 (self->priv->item_factory);
	self->key_chain = (_vala_array_free (self->key_chain, self->key_chain_length1, (GDestroyNotify) g_free), NULL);
	(self->id_func_target_destroy_notify == NULL) ? NULL : self->id_func_target_destroy_notify (self->id_func_target);
	self->id_func = NULL;
	self->id_func_target = NULL;
	self->id_func_target_destroy_notify = NULL;
	(self->title_func_target_destroy_notify == NULL) ? NULL : self->title_func_target_destroy_notify (self->title_func_target);
	self->title_func = NULL;
	self->title_func_target = NULL;
	self->title_func_target_destroy_notify = NULL;
	(self->filter_func_target_destroy_notify == NULL) ? NULL : self->filter_func_target_destroy_notify (self->filter_func_target);
	self->filter_func = NULL;
	self->filter_func_target = NULL;
	self->filter_func_target_destroy_notify = NULL;
	_g_object_unref0 (self->priv->resources);
	_g_object_unref0 (self->priv->resources_class);
	G_OBJECT_CLASS (rygel_tracker_metadata_values_parent_class)->finalize (obj);
}


GType rygel_tracker_metadata_values_get_type (void) {
	static GType rygel_tracker_metadata_values_type_id = 0;
	if (rygel_tracker_metadata_values_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerMetadataValuesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_metadata_values_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerMetadataValues), 0, (GInstanceInitFunc) rygel_tracker_metadata_values_instance_init, NULL };
		rygel_tracker_metadata_values_type_id = g_type_register_static (RYGEL_TYPE_SIMPLE_CONTAINER, "RygelTrackerMetadataValues", &g_define_type_info, 0);
	}
	return rygel_tracker_metadata_values_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




