/* rygel-live-response.c generated by valac, the Vala compiler
 * generated from rygel-live-response.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;

#define RYGEL_TYPE_LIVE_RESPONSE (rygel_live_response_get_type ())
#define RYGEL_LIVE_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LIVE_RESPONSE, RygelLiveResponse))
#define RYGEL_LIVE_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LIVE_RESPONSE, RygelLiveResponseClass))
#define RYGEL_IS_LIVE_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LIVE_RESPONSE))
#define RYGEL_IS_LIVE_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LIVE_RESPONSE))
#define RYGEL_LIVE_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LIVE_RESPONSE, RygelLiveResponseClass))

typedef struct _RygelLiveResponse RygelLiveResponse;
typedef struct _RygelLiveResponseClass RygelLiveResponseClass;
typedef struct _RygelLiveResponsePrivate RygelLiveResponsePrivate;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelLiveResponseRunData RygelLiveResponseRunData;
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _gst_buffer_unref0(var) ((var == NULL) ? NULL : (var = (gst_buffer_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	RYGEL_LIVE_RESPONSE_ERROR_MISSING_PLUGIN,
	RYGEL_LIVE_RESPONSE_ERROR_LINK
} RygelLiveResponseError;
#define RYGEL_LIVE_RESPONSE_ERROR rygel_live_response_error_quark ()
struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
	SoupMessage* msg;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelHTTPResponse* self, GAsyncResult* _res_);
	void (*end) (RygelHTTPResponse* self, gboolean aborted, guint status);
};

struct _RygelLiveResponse {
	RygelHTTPResponse parent_instance;
	RygelLiveResponsePrivate * priv;
};

struct _RygelLiveResponseClass {
	RygelHTTPResponseClass parent_class;
};

struct _RygelLiveResponsePrivate {
	GstPipeline* pipeline;
	RygelHTTPSeek* time_range;
	guint idle_id;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
};

struct _RygelLiveResponseRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelLiveResponse* self;
	gboolean _tmp0_;
	GSourceFunc _tmp1_;
};

struct _Block2Data {
	int _ref_count_;
	RygelLiveResponse * self;
	GstBuffer* buffer;
};


static gpointer rygel_live_response_parent_class = NULL;

GQuark rygel_live_response_error_quark (void);
GType rygel_state_machine_get_type (void);
GType rygel_http_response_get_type (void);
GType rygel_live_response_get_type (void);
GType rygel_http_seek_get_type (void);
#define RYGEL_LIVE_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_LIVE_RESPONSE, RygelLiveResponsePrivate))
enum  {
	RYGEL_LIVE_RESPONSE_DUMMY_PROPERTY
};
#define RYGEL_LIVE_RESPONSE_SINK_NAME "fakesink"
RygelHTTPResponse* rygel_http_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, gboolean partial, GCancellable* cancellable);
static void rygel_live_response_prepare_pipeline (RygelLiveResponse* self, const char* name, GstElement* src, GError** error);
RygelLiveResponse* rygel_live_response_new (SoupServer* server, SoupMessage* msg, const char* name, GstElement* src, RygelHTTPSeek* time_range, GCancellable* cancellable, GError** error);
RygelLiveResponse* rygel_live_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, const char* name, GstElement* src, RygelHTTPSeek* time_range, GCancellable* cancellable, GError** error);
static void rygel_live_response_real_run_data_free (gpointer _data);
static void rygel_live_response_real_run (RygelHTTPResponse* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_live_response_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
void rygel_http_response_run (RygelHTTPResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_response_run_finish (RygelHTTPResponse* self, GAsyncResult* _res_);
static gboolean _rygel_live_response_real_run_co_gsource_func (gpointer self);
static gboolean rygel_live_response_real_run_co (RygelLiveResponseRunData* data);
void rygel_http_response_end (RygelHTTPResponse* self, gboolean aborted, guint status);
static void rygel_live_response_real_end (RygelHTTPResponse* base, gboolean aborted, guint status);
static inline void _dynamic_set_signal_handoffs0 (GstElement* obj, gboolean value);
static void rygel_live_response_on_new_buffer (RygelLiveResponse* self, GstElement* sink, GstBuffer* buffer, GstPad* pad);
static void _rygel_live_response_on_new_buffer_dynamic_handoff0_ (GstElement* _sender, GstBuffer* buffer, GstPad* pad, gpointer self);
void _dynamic_handoff1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data);
static void rygel_live_response_src_pad_added (RygelLiveResponse* self, GstElement* src, GstPad* src_pad);
static void _rygel_live_response_src_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
static gboolean rygel_live_response_bus_handler (RygelLiveResponse* self, GstBus* bus, GstMessage* message);
static gboolean _rygel_live_response_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps);
void rygel_http_response_push_data (RygelHTTPResponse* self, void* data, gsize length);
static gboolean _lambda1_ (Block2Data* _data2_);
static gboolean __lambda1__gsource_func (gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean rygel_live_response_seek (RygelLiveResponse* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
static void rygel_live_response_finalize (GObject* obj);


static void g_cclosure_user_marshal_VOID__POINTER_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

GQuark rygel_live_response_error_quark (void) {
	return g_quark_from_static_string ("rygel_live_response_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 44 "rygel-live-response.vala"
RygelLiveResponse* rygel_live_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, const char* name, GstElement* src, RygelHTTPSeek* time_range, GCancellable* cancellable, GError** error) {
#line 205 "rygel-live-response.c"
	GError * _inner_error_;
	RygelLiveResponse * self;
	RygelHTTPSeek* _tmp0_;
#line 44 "rygel-live-response.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 44 "rygel-live-response.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 44 "rygel-live-response.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 44 "rygel-live-response.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 217 "rygel-live-response.c"
	_inner_error_ = NULL;
#line 50 "rygel-live-response.vala"
	self = (RygelLiveResponse*) rygel_http_response_construct (object_type, server, msg, FALSE, cancellable);
#line 52 "rygel-live-response.vala"
	soup_message_headers_set_encoding (((RygelHTTPResponse*) self)->msg->response_headers, SOUP_ENCODING_EOF);
#line 54 "rygel-live-response.vala"
	rygel_live_response_prepare_pipeline (self, name, src, &_inner_error_);
#line 225 "rygel-live-response.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		g_object_unref (self);
		return NULL;
	}
#line 55 "rygel-live-response.vala"
	self->priv->time_range = (_tmp0_ = _g_object_ref0 (time_range), _g_object_unref0 (self->priv->time_range), _tmp0_);
#line 233 "rygel-live-response.c"
	return self;
}


#line 44 "rygel-live-response.vala"
RygelLiveResponse* rygel_live_response_new (SoupServer* server, SoupMessage* msg, const char* name, GstElement* src, RygelHTTPSeek* time_range, GCancellable* cancellable, GError** error) {
#line 44 "rygel-live-response.vala"
	return rygel_live_response_construct (RYGEL_TYPE_LIVE_RESPONSE, server, msg, name, src, time_range, cancellable, error);
#line 242 "rygel-live-response.c"
}


static void rygel_live_response_real_run_data_free (gpointer _data) {
	RygelLiveResponseRunData* data;
	data = _data;
	g_slice_free (RygelLiveResponseRunData, data);
}


static void rygel_live_response_real_run (RygelHTTPResponse* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelLiveResponse * self;
	RygelLiveResponseRunData* _data_;
	self = (RygelLiveResponse*) base;
	_data_ = g_slice_new0 (RygelLiveResponseRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_live_response_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_live_response_real_run_data_free);
	_data_->self = self;
	rygel_live_response_real_run_co (_data_);
}


static void rygel_live_response_real_run_finish (RygelHTTPResponse* base, GAsyncResult* _res_) {
	RygelLiveResponseRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_live_response_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelLiveResponseRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_live_response_real_run_co (data);
}


#line 58 "rygel-live-response.vala"
static gboolean _rygel_live_response_real_run_co_gsource_func (gpointer self) {
#line 281 "rygel-live-response.c"
	return rygel_live_response_real_run_co (self);
}


static gboolean rygel_live_response_real_run_co (RygelLiveResponseRunData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
#line 60 "rygel-live-response.vala"
			if (data->self->priv->time_range != NULL) {
#line 60 "rygel-live-response.vala"
				data->_tmp0_ = rygel_http_seek_get_start (data->self->priv->time_range) > 0;
#line 296 "rygel-live-response.c"
			} else {
#line 60 "rygel-live-response.vala"
				data->_tmp0_ = FALSE;
#line 300 "rygel-live-response.c"
			}
#line 60 "rygel-live-response.vala"
			if (data->_tmp0_) {
#line 61 "rygel-live-response.vala"
				gst_element_set_state ((GstElement*) data->self->priv->pipeline, GST_STATE_PAUSED);
#line 306 "rygel-live-response.c"
			} else {
#line 63 "rygel-live-response.vala"
				gst_element_set_state ((GstElement*) data->self->priv->pipeline, GST_STATE_PLAYING);
#line 310 "rygel-live-response.c"
			}
#line 66 "rygel-live-response.vala"
			data->self->priv->run_continue = (data->_tmp1_ = _rygel_live_response_real_run_co_gsource_func, ((data->self->priv->run_continue_target_destroy_notify == NULL) ? NULL : data->self->priv->run_continue_target_destroy_notify (data->self->priv->run_continue_target), data->self->priv->run_continue = NULL, data->self->priv->run_continue_target = NULL, data->self->priv->run_continue_target_destroy_notify = NULL), data->self->priv->run_continue_target = data, data->self->priv->run_continue_target_destroy_notify = NULL, data->_tmp1_);
#line 314 "rygel-live-response.c"
			data->_state_ = 12;
			return FALSE;
			case 12:
			;
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


#line 71 "rygel-live-response.vala"
static void rygel_live_response_real_end (RygelHTTPResponse* base, gboolean aborted, guint status) {
#line 335 "rygel-live-response.c"
	RygelLiveResponse * self;
	self = (RygelLiveResponse*) base;
#line 72 "rygel-live-response.vala"
	gst_element_set_state ((GstElement*) self->priv->pipeline, GST_STATE_NULL);
#line 74 "rygel-live-response.vala"
	if (self->priv->idle_id != 0) {
#line 75 "rygel-live-response.vala"
		g_source_remove (self->priv->idle_id);
#line 76 "rygel-live-response.vala"
		self->priv->idle_id = (guint) 0;
#line 346 "rygel-live-response.c"
	}
#line 79 "rygel-live-response.vala"
	if (!aborted) {
#line 80 "rygel-live-response.vala"
		soup_message_body_complete (((RygelHTTPResponse*) self)->msg->response_body);
#line 352 "rygel-live-response.c"
	}
#line 83 "rygel-live-response.vala"
	RYGEL_HTTP_RESPONSE_CLASS (rygel_live_response_parent_class)->end (RYGEL_HTTP_RESPONSE (self), aborted, status);
#line 85 "rygel-live-response.vala"
	self->priv->run_continue (self->priv->run_continue_target);
#line 358 "rygel-live-response.c"
}


static inline void _dynamic_set_signal_handoffs0 (GstElement* obj, gboolean value) {
	g_object_set (obj, "signal-handoffs", value, NULL);
}


#line 158 "rygel-live-response.vala"
static void _rygel_live_response_on_new_buffer_dynamic_handoff0_ (GstElement* _sender, GstBuffer* buffer, GstPad* pad, gpointer self) {
#line 369 "rygel-live-response.c"
	rygel_live_response_on_new_buffer (self, _sender, buffer, pad);
}


void _dynamic_handoff1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data) {
	g_signal_connect_object (obj, signal_name, handler, data, 0);
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


#line 122 "rygel-live-response.vala"
static void _rygel_live_response_src_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
#line 386 "rygel-live-response.c"
	rygel_live_response_src_pad_added (self, _sender, pad);
}


#line 171 "rygel-live-response.vala"
static gboolean _rygel_live_response_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
#line 393 "rygel-live-response.c"
	return rygel_live_response_bus_handler (self, bus, message);
}


#line 88 "rygel-live-response.vala"
static void rygel_live_response_prepare_pipeline (RygelLiveResponse* self, const char* name, GstElement* src, GError** error) {
#line 400 "rygel-live-response.c"
	GError * _inner_error_;
	GstElement* sink;
	GstPipeline* _tmp0_;
	GstBus* bus;
#line 88 "rygel-live-response.vala"
	g_return_if_fail (self != NULL);
#line 88 "rygel-live-response.vala"
	g_return_if_fail (name != NULL);
#line 88 "rygel-live-response.vala"
	g_return_if_fail (src != NULL);
#line 411 "rygel-live-response.c"
	_inner_error_ = NULL;
#line 90 "rygel-live-response.vala"
	sink = gst_element_factory_make ("fakesink", RYGEL_LIVE_RESPONSE_SINK_NAME);
#line 92 "rygel-live-response.vala"
	if (sink == NULL) {
#line 417 "rygel-live-response.c"
		_inner_error_ = g_error_new_literal (RYGEL_LIVE_RESPONSE_ERROR, RYGEL_LIVE_RESPONSE_ERROR_MISSING_PLUGIN, "Required plugin 'fakesink' missing");
		{
			g_propagate_error (error, _inner_error_);
			_gst_object_unref0 (sink);
			return;
		}
	}
#line 97 "rygel-live-response.vala"
	_dynamic_set_signal_handoffs0 (sink, TRUE);
#line 98 "rygel-live-response.vala"
	_dynamic_handoff1_connect (sink, "handoff", (GCallback) _rygel_live_response_on_new_buffer_dynamic_handoff0_, self);
#line 100 "rygel-live-response.vala"
	self->priv->pipeline = (_tmp0_ = (GstPipeline*) gst_pipeline_new (name), _gst_object_unref0 (self->priv->pipeline), _tmp0_);
#line 101 "rygel-live-response.vala"
	g_assert (self->priv->pipeline != NULL);
#line 103 "rygel-live-response.vala"
	gst_bin_add_many ((GstBin*) self->priv->pipeline, _gst_object_ref0 (src), _gst_object_ref0 (sink), NULL);
#line 105 "rygel-live-response.vala"
	if (src->numpads == 0) {
#line 107 "rygel-live-response.vala"
		g_signal_connect_object (src, "pad-added", (GCallback) _rygel_live_response_src_pad_added_gst_element_pad_added, self, 0);
#line 439 "rygel-live-response.c"
	} else {
#line 110 "rygel-live-response.vala"
		if (!gst_element_link (src, sink)) {
#line 443 "rygel-live-response.c"
			_inner_error_ = g_error_new (RYGEL_LIVE_RESPONSE_ERROR, RYGEL_LIVE_RESPONSE_ERROR_LINK, "Failed to link %s to %s", gst_object_get_name ((GstObject*) src), gst_object_get_name ((GstObject*) sink));
			{
				g_propagate_error (error, _inner_error_);
				_gst_object_unref0 (sink);
				return;
			}
		}
	}
#line 118 "rygel-live-response.vala"
	bus = gst_pipeline_get_bus (self->priv->pipeline);
#line 119 "rygel-live-response.vala"
	gst_bus_add_watch_full (bus, G_PRIORITY_DEFAULT, _rygel_live_response_bus_handler_gst_bus_func, g_object_ref (self), g_object_unref);
#line 456 "rygel-live-response.c"
	_gst_object_unref0 (sink);
	_gst_object_unref0 (bus);
}


#line 122 "rygel-live-response.vala"
static void rygel_live_response_src_pad_added (RygelLiveResponse* self, GstElement* src, GstPad* src_pad) {
#line 464 "rygel-live-response.c"
	GstCaps* caps;
	GstElement* sink;
	GstPad* sink_pad;
	GstElement* depay;
#line 122 "rygel-live-response.vala"
	g_return_if_fail (self != NULL);
#line 122 "rygel-live-response.vala"
	g_return_if_fail (src != NULL);
#line 122 "rygel-live-response.vala"
	g_return_if_fail (src_pad != NULL);
#line 124 "rygel-live-response.vala"
	caps = gst_pad_get_caps (src_pad);
#line 126 "rygel-live-response.vala"
	sink = gst_bin_get_by_name ((GstBin*) self->priv->pipeline, RYGEL_LIVE_RESPONSE_SINK_NAME);
#line 479 "rygel-live-response.c"
	sink_pad = NULL;
#line 129 "rygel-live-response.vala"
	depay = rygel_gst_utils_get_rtp_depayloader (caps);
#line 130 "rygel-live-response.vala"
	if (depay != NULL) {
#line 485 "rygel-live-response.c"
		GstPad* _tmp0_;
#line 131 "rygel-live-response.vala"
		gst_bin_add ((GstBin*) self->priv->pipeline, _gst_object_ref0 (depay));
#line 132 "rygel-live-response.vala"
		if (!gst_element_link (depay, sink)) {
#line 133 "rygel-live-response.vala"
			g_critical ("rygel-live-response.vala:133: Failed to link %s to %s", gst_object_get_name ((GstObject*) depay), gst_object_get_name ((GstObject*) sink));
#line 136 "rygel-live-response.vala"
			rygel_http_response_end ((RygelHTTPResponse*) self, FALSE, (guint) SOUP_STATUS_NONE);
#line 495 "rygel-live-response.c"
			_gst_caps_unref0 (caps);
			_gst_object_unref0 (sink);
			_gst_object_unref0 (sink_pad);
			_gst_object_unref0 (depay);
#line 137 "rygel-live-response.vala"
			return;
#line 502 "rygel-live-response.c"
		}
#line 140 "rygel-live-response.vala"
		sink_pad = (_tmp0_ = _gst_object_ref0 (gst_element_get_compatible_pad (depay, src_pad, caps)), _gst_object_unref0 (sink_pad), _tmp0_);
#line 506 "rygel-live-response.c"
	} else {
		GstPad* _tmp1_;
#line 142 "rygel-live-response.vala"
		sink_pad = (_tmp1_ = _gst_object_ref0 (gst_element_get_compatible_pad (sink, src_pad, caps)), _gst_object_unref0 (sink_pad), _tmp1_);
#line 511 "rygel-live-response.c"
	}
#line 145 "rygel-live-response.vala"
	if (gst_pad_link (src_pad, sink_pad) != GST_PAD_LINK_OK) {
#line 146 "rygel-live-response.vala"
		g_critical ("rygel-live-response.vala:146: Failed to link pad %s to %s", gst_object_get_name ((GstObject*) src_pad), gst_object_get_name ((GstObject*) sink_pad));
#line 149 "rygel-live-response.vala"
		rygel_http_response_end ((RygelHTTPResponse*) self, FALSE, (guint) SOUP_STATUS_NONE);
#line 519 "rygel-live-response.c"
		_gst_caps_unref0 (caps);
		_gst_object_unref0 (sink);
		_gst_object_unref0 (sink_pad);
		_gst_object_unref0 (depay);
#line 150 "rygel-live-response.vala"
		return;
#line 526 "rygel-live-response.c"
	}
#line 153 "rygel-live-response.vala"
	if (depay != NULL) {
#line 154 "rygel-live-response.vala"
		gst_element_sync_state_with_parent (depay);
#line 532 "rygel-live-response.c"
	}
	_gst_caps_unref0 (caps);
	_gst_object_unref0 (sink);
	_gst_object_unref0 (sink_pad);
	_gst_object_unref0 (depay);
}


#line 162 "rygel-live-response.vala"
static gboolean _lambda1_ (Block2Data* _data2_) {
#line 543 "rygel-live-response.c"
	RygelLiveResponse * self;
	gboolean result;
	self = _data2_->self;
#line 163 "rygel-live-response.vala"
	rygel_http_response_push_data ((RygelHTTPResponse*) self, _data2_->buffer->data, (gsize) _data2_->buffer->size);
#line 165 "rygel-live-response.vala"
	self->priv->idle_id = (guint) 0;
#line 551 "rygel-live-response.c"
	result = FALSE;
#line 167 "rygel-live-response.vala"
	return result;
#line 555 "rygel-live-response.c"
}


#line 162 "rygel-live-response.vala"
static gboolean __lambda1__gsource_func (gpointer self) {
#line 561 "rygel-live-response.c"
	return _lambda1_ (self);
}


static gpointer _gst_buffer_ref0 (gpointer self) {
	return self ? gst_buffer_ref (self) : NULL;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	++_data2_->_ref_count_;
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if ((--_data2_->_ref_count_) == 0) {
		_g_object_unref0 (_data2_->self);
		_gst_buffer_unref0 (_data2_->buffer);
		g_slice_free (Block2Data, _data2_);
	}
}


#line 158 "rygel-live-response.vala"
static void rygel_live_response_on_new_buffer (RygelLiveResponse* self, GstElement* sink, GstBuffer* buffer, GstPad* pad) {
#line 588 "rygel-live-response.c"
	Block2Data* _data2_;
#line 158 "rygel-live-response.vala"
	g_return_if_fail (self != NULL);
#line 158 "rygel-live-response.vala"
	g_return_if_fail (sink != NULL);
#line 158 "rygel-live-response.vala"
	g_return_if_fail (buffer != NULL);
#line 158 "rygel-live-response.vala"
	g_return_if_fail (pad != NULL);
#line 598 "rygel-live-response.c"
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->buffer = _gst_buffer_ref0 (buffer);
#line 161 "rygel-live-response.vala"
	self->priv->idle_id = g_idle_add_full (G_PRIORITY_HIGH_IDLE, __lambda1__gsource_func, block2_data_ref (_data2_), block2_data_unref);
#line 605 "rygel-live-response.c"
	block2_data_unref (_data2_);
}


#line 171 "rygel-live-response.vala"
static gboolean rygel_live_response_bus_handler (RygelLiveResponse* self, GstBus* bus, GstMessage* message) {
#line 612 "rygel-live-response.c"
	gboolean result;
	gboolean ret;
#line 171 "rygel-live-response.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 171 "rygel-live-response.vala"
	g_return_val_if_fail (bus != NULL, FALSE);
#line 171 "rygel-live-response.vala"
	g_return_val_if_fail (message != NULL, FALSE);
#line 173 "rygel-live-response.vala"
	ret = TRUE;
#line 175 "rygel-live-response.vala"
	if (message->type == GST_MESSAGE_EOS) {
#line 176 "rygel-live-response.vala"
		ret = FALSE;
#line 627 "rygel-live-response.c"
	} else {
#line 177 "rygel-live-response.vala"
		if (message->type == GST_MESSAGE_STATE_CHANGED) {
#line 631 "rygel-live-response.c"
			gboolean _tmp0_ = FALSE;
#line 178 "rygel-live-response.vala"
			if (message->src != GST_OBJECT (self->priv->pipeline)) {
#line 635 "rygel-live-response.c"
				result = TRUE;
#line 179 "rygel-live-response.vala"
				return result;
#line 639 "rygel-live-response.c"
			}
#line 182 "rygel-live-response.vala"
			if (self->priv->time_range != NULL) {
#line 182 "rygel-live-response.vala"
				_tmp0_ = rygel_http_seek_get_start (self->priv->time_range) > 0;
#line 645 "rygel-live-response.c"
			} else {
#line 182 "rygel-live-response.vala"
				_tmp0_ = FALSE;
#line 649 "rygel-live-response.c"
			}
#line 182 "rygel-live-response.vala"
			if (_tmp0_) {
#line 653 "rygel-live-response.c"
				GstState old_state = 0;
				GstState new_state = 0;
				gboolean _tmp1_ = FALSE;
#line 186 "rygel-live-response.vala"
				gst_message_parse_state_changed (message, &old_state, &new_state, NULL);
#line 190 "rygel-live-response.vala"
				if (old_state == GST_STATE_READY) {
#line 190 "rygel-live-response.vala"
					_tmp1_ = new_state == GST_STATE_PAUSED;
#line 663 "rygel-live-response.c"
				} else {
#line 190 "rygel-live-response.vala"
					_tmp1_ = FALSE;
#line 667 "rygel-live-response.c"
				}
#line 190 "rygel-live-response.vala"
				if (_tmp1_) {
#line 191 "rygel-live-response.vala"
					if (rygel_live_response_seek (self)) {
#line 192 "rygel-live-response.vala"
						gst_element_set_state ((GstElement*) self->priv->pipeline, GST_STATE_PLAYING);
#line 675 "rygel-live-response.c"
					}
				}
			}
		} else {
			GError* err;
			char* err_msg;
			err = NULL;
			err_msg = NULL;
#line 200 "rygel-live-response.vala"
			if (message->type == GST_MESSAGE_ERROR) {
#line 686 "rygel-live-response.c"
				char* _tmp5_;
				char* _tmp4_ = NULL;
				GError* _tmp3_;
				GError* _tmp2_ = NULL;
#line 201 "rygel-live-response.vala"
				(gst_message_parse_error (message, &_tmp2_, &_tmp4_), err = (_tmp3_ = _tmp2_, _g_error_free0 (err), _tmp3_));
#line 201 "rygel-live-response.vala"
				err_msg = (_tmp5_ = _tmp4_, _g_free0 (err_msg), _tmp5_);
#line 202 "rygel-live-response.vala"
				g_critical ("rygel-live-response.vala:202: Error from pipeline %s:%s", gst_object_get_name ((GstObject*) self->priv->pipeline), err_msg);
#line 206 "rygel-live-response.vala"
				ret = FALSE;
#line 699 "rygel-live-response.c"
			} else {
#line 207 "rygel-live-response.vala"
				if (message->type == GST_MESSAGE_WARNING) {
#line 703 "rygel-live-response.c"
					char* _tmp9_;
					char* _tmp8_ = NULL;
					GError* _tmp7_;
					GError* _tmp6_ = NULL;
#line 208 "rygel-live-response.vala"
					(gst_message_parse_warning (message, &_tmp6_, &_tmp8_), err = (_tmp7_ = _tmp6_, _g_error_free0 (err), _tmp7_));
#line 208 "rygel-live-response.vala"
					err_msg = (_tmp9_ = _tmp8_, _g_free0 (err_msg), _tmp9_);
#line 209 "rygel-live-response.vala"
					g_warning ("rygel-live-response.vala:209: Warning from pipeline %s:%s", gst_object_get_name ((GstObject*) self->priv->pipeline), err_msg);
#line 714 "rygel-live-response.c"
				}
			}
			_g_error_free0 (err);
			_g_free0 (err_msg);
		}
	}
#line 215 "rygel-live-response.vala"
	if (!ret) {
#line 216 "rygel-live-response.vala"
		rygel_http_response_end ((RygelHTTPResponse*) self, FALSE, (guint) SOUP_STATUS_NONE);
#line 725 "rygel-live-response.c"
	}
	result = ret;
#line 219 "rygel-live-response.vala"
	return result;
#line 730 "rygel-live-response.c"
}


#line 222 "rygel-live-response.vala"
static gboolean rygel_live_response_seek (RygelLiveResponse* self) {
#line 736 "rygel-live-response.c"
	gboolean result;
	GstSeekType stop_type = 0;
#line 222 "rygel-live-response.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 225 "rygel-live-response.vala"
	if (rygel_http_seek_get_stop (self->priv->time_range) > 0) {
#line 226 "rygel-live-response.vala"
		stop_type = GST_SEEK_TYPE_SET;
#line 745 "rygel-live-response.c"
	} else {
#line 228 "rygel-live-response.vala"
		stop_type = GST_SEEK_TYPE_NONE;
#line 749 "rygel-live-response.c"
	}
#line 231 "rygel-live-response.vala"
	if (!gst_element_seek ((GstElement*) self->priv->pipeline, 1.0, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH, GST_SEEK_TYPE_SET, rygel_http_seek_get_start (self->priv->time_range), stop_type, rygel_http_seek_get_stop (self->priv->time_range))) {
#line 238 "rygel-live-response.vala"
		g_warning ("rygel-live-response.vala:238: Failed to seek to offset %lld", rygel_http_seek_get_start (self->priv->time_range));
#line 240 "rygel-live-response.vala"
		rygel_http_response_end ((RygelHTTPResponse*) self, FALSE, (guint) SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE);
#line 757 "rygel-live-response.c"
		result = FALSE;
#line 243 "rygel-live-response.vala"
		return result;
#line 761 "rygel-live-response.c"
	}
	result = TRUE;
#line 246 "rygel-live-response.vala"
	return result;
#line 766 "rygel-live-response.c"
}


static void rygel_live_response_class_init (RygelLiveResponseClass * klass) {
	rygel_live_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelLiveResponsePrivate));
	RYGEL_HTTP_RESPONSE_CLASS (klass)->run = rygel_live_response_real_run;
	RYGEL_HTTP_RESPONSE_CLASS (klass)->run_finish = rygel_live_response_real_run_finish;
	RYGEL_HTTP_RESPONSE_CLASS (klass)->end = rygel_live_response_real_end;
	G_OBJECT_CLASS (klass)->finalize = rygel_live_response_finalize;
}


static void rygel_live_response_instance_init (RygelLiveResponse * self) {
	self->priv = RYGEL_LIVE_RESPONSE_GET_PRIVATE (self);
}


static void rygel_live_response_finalize (GObject* obj) {
	RygelLiveResponse * self;
	self = RYGEL_LIVE_RESPONSE (obj);
	_gst_object_unref0 (self->priv->pipeline);
	_g_object_unref0 (self->priv->time_range);
	(self->priv->run_continue_target_destroy_notify == NULL) ? NULL : self->priv->run_continue_target_destroy_notify (self->priv->run_continue_target);
	self->priv->run_continue = NULL;
	self->priv->run_continue_target = NULL;
	self->priv->run_continue_target_destroy_notify = NULL;
	G_OBJECT_CLASS (rygel_live_response_parent_class)->finalize (obj);
}


GType rygel_live_response_get_type (void) {
	static GType rygel_live_response_type_id = 0;
	if (rygel_live_response_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelLiveResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_live_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLiveResponse), 0, (GInstanceInitFunc) rygel_live_response_instance_init, NULL };
		rygel_live_response_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE, "RygelLiveResponse", &g_define_type_info, 0);
	}
	return rygel_live_response_type_id;
}



static void g_cclosure_user_marshal_VOID__POINTER_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__POINTER_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, gst_value_get_mini_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}



