/* rygel-media-export-plugin.c generated by valac 0.9.5, the Vala compiler
 * generated from rygel-media-export-plugin.vala, do not modify */

/*
 * Copyright (C) 2008-2009 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <libgupnp/gupnp.h>


#define RYGEL_MEDIA_EXPORT_TYPE_PLUGIN (rygel_media_export_plugin_get_type ())
#define RYGEL_MEDIA_EXPORT_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLUGIN, RygelMediaExportPlugin))
#define RYGEL_MEDIA_EXPORT_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLUGIN, RygelMediaExportPluginClass))
#define RYGEL_MEDIA_EXPORT_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLUGIN))
#define RYGEL_MEDIA_EXPORT_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLUGIN))
#define RYGEL_MEDIA_EXPORT_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLUGIN, RygelMediaExportPluginClass))

typedef struct _RygelMediaExportPlugin RygelMediaExportPlugin;
typedef struct _RygelMediaExportPluginClass RygelMediaExportPluginClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER (rygel_media_export_root_container_get_type ())
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainer))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))

typedef struct _RygelMediaExportRootContainer RygelMediaExportRootContainer;
typedef struct _RygelMediaExportRootContainerClass RygelMediaExportRootContainerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaExportPluginPrivate RygelMediaExportPluginPrivate;

struct _Block1Data {
	int _ref_count_;
	RygelMediaExportPlugin* plugin;
	RygelPluginLoader* loader;
};

struct _RygelMediaExportPlugin {
	RygelMediaServerPlugin parent_instance;
	RygelMediaExportPluginPrivate * priv;
};

struct _RygelMediaExportPluginClass {
	RygelMediaServerPluginClass parent_class;
};


static gpointer rygel_media_export_plugin_parent_class = NULL;

#define TRACKER_PLUGIN "Tracker"
#define OUR_PLUGIN "MediaExport"
RygelMediaExportPlugin* rygel_media_export_plugin_new (void);
RygelMediaExportPlugin* rygel_media_export_plugin_construct (GType object_type);
GType rygel_media_export_plugin_get_type (void) G_GNUC_CONST;
void on_plugin_available (RygelPlugin* plugin, RygelPlugin* our_plugin);
static void _lambda17_ (RygelPlugin* new_plugin, Block1Data* _data1_);
static void __lambda17__rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender, RygelPlugin* plugin, gpointer self);
static gboolean _lambda16_ (Block1Data* _data1_);
static gboolean __lambda16__gsource_func (gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
void module_init (RygelPluginLoader* loader);
RygelMediaContainer* rygel_media_export_root_container_get_instance (void);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_root_container_get_type (void) G_GNUC_CONST;
void rygel_media_export_root_container_shutdown (RygelMediaExportRootContainer* self);
enum  {
	RYGEL_MEDIA_EXPORT_PLUGIN_DUMMY_PROPERTY
};
static RygelMediaContainer* rygel_media_export_plugin_real_get_root_container (RygelMediaServerPlugin* base, GUPnPContext* context);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 39 "rygel-media-export-plugin.vala"
static void _lambda17_ (RygelPlugin* new_plugin, Block1Data* _data1_) {
#line 39 "rygel-media-export-plugin.vala"
	g_return_if_fail (new_plugin != NULL);
#line 40 "rygel-media-export-plugin.vala"
	on_plugin_available (new_plugin, (RygelPlugin*) _data1_->plugin);
#line 118 "rygel-media-export-plugin.c"
}


#line 39 "rygel-media-export-plugin.vala"
static void __lambda17__rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender, RygelPlugin* plugin, gpointer self) {
#line 124 "rygel-media-export-plugin.c"
	_lambda17_ (plugin, self);
}


#line 34 "rygel-media-export-plugin.vala"
static gboolean _lambda16_ (Block1Data* _data1_) {
#line 131 "rygel-media-export-plugin.c"
	gboolean result = FALSE;
	{
		GeeCollection* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _loaded_plugin_it;
#line 35 "rygel-media-export-plugin.vala"
		_loaded_plugin_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = rygel_plugin_loader_list_plugins (_data1_->loader))), _g_object_unref0 (_tmp0_), _tmp1_);
#line 35 "rygel-media-export-plugin.vala"
		while (TRUE) {
#line 141 "rygel-media-export-plugin.c"
			RygelPlugin* loaded_plugin;
#line 35 "rygel-media-export-plugin.vala"
			if (!gee_iterator_next (_loaded_plugin_it)) {
#line 35 "rygel-media-export-plugin.vala"
				break;
#line 147 "rygel-media-export-plugin.c"
			}
#line 35 "rygel-media-export-plugin.vala"
			loaded_plugin = (RygelPlugin*) gee_iterator_get (_loaded_plugin_it);
#line 36 "rygel-media-export-plugin.vala"
			on_plugin_available (loaded_plugin, (RygelPlugin*) _data1_->plugin);
#line 153 "rygel-media-export-plugin.c"
			_g_object_unref0 (loaded_plugin);
		}
		_g_object_unref0 (_loaded_plugin_it);
	}
#line 39 "rygel-media-export-plugin.vala"
	g_signal_connect_data (_data1_->loader, "plugin-available", (GCallback) __lambda17__rygel_plugin_loader_plugin_available, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 160 "rygel-media-export-plugin.c"
	result = FALSE;
#line 43 "rygel-media-export-plugin.vala"
	return result;
#line 164 "rygel-media-export-plugin.c"
}


#line 34 "rygel-media-export-plugin.vala"
static gboolean __lambda16__gsource_func (gpointer self) {
#line 170 "rygel-media-export-plugin.c"
	gboolean result;
	result = _lambda16_ (self);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->plugin);
		_g_object_unref0 (_data1_->loader);
		g_slice_free (Block1Data, _data1_);
	}
}


/**
 * Simple plugin which exposes the media contents of a directory via UPnP.
 *
 */
#line 31 "rygel-media-export-plugin.vala"
void module_init (RygelPluginLoader* loader) {
#line 203 "rygel-media-export-plugin.c"
	Block1Data* _data1_;
#line 31 "rygel-media-export-plugin.vala"
	g_return_if_fail (loader != NULL);
#line 207 "rygel-media-export-plugin.c"
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->loader = _g_object_ref0 (loader);
	_data1_->plugin = rygel_media_export_plugin_new ();
#line 34 "rygel-media-export-plugin.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda16__gsource_func, block1_data_ref (_data1_), block1_data_unref);
#line 46 "rygel-media-export-plugin.vala"
	rygel_plugin_loader_add_plugin (_data1_->loader, (RygelPlugin*) _data1_->plugin);
#line 216 "rygel-media-export-plugin.c"
	block1_data_unref (_data1_);
}


#line 49 "rygel-media-export-plugin.vala"
void on_plugin_available (RygelPlugin* plugin, RygelPlugin* our_plugin) {
#line 223 "rygel-media-export-plugin.c"
	GError * _inner_error_;
	gboolean _tmp0_ = FALSE;
#line 49 "rygel-media-export-plugin.vala"
	g_return_if_fail (plugin != NULL);
#line 49 "rygel-media-export-plugin.vala"
	g_return_if_fail (our_plugin != NULL);
#line 230 "rygel-media-export-plugin.c"
	_inner_error_ = NULL;
#line 50 "rygel-media-export-plugin.vala"
	if (_vala_strcmp0 (plugin->name, TRACKER_PLUGIN) == 0) {
#line 51 "rygel-media-export-plugin.vala"
		_tmp0_ = rygel_plugin_get_available (our_plugin) == rygel_plugin_get_available (plugin);
#line 236 "rygel-media-export-plugin.c"
	} else {
#line 50 "rygel-media-export-plugin.vala"
		_tmp0_ = FALSE;
#line 240 "rygel-media-export-plugin.c"
	}
#line 50 "rygel-media-export-plugin.vala"
	if (_tmp0_) {
#line 52 "rygel-media-export-plugin.vala"
		if (rygel_plugin_get_available (plugin)) {
#line 53 "rygel-media-export-plugin.vala"
			g_message ("rygel-media-export-plugin.vala:53: Disabling plugin '%s' in favor of p" \
"lugin '%s'", OUR_PLUGIN, TRACKER_PLUGIN);
#line 248 "rygel-media-export-plugin.c"
			{
				RygelMetaConfig* config;
				gboolean enabled;
#line 57 "rygel-media-export-plugin.vala"
				config = rygel_meta_config_get_default ();
#line 58 "rygel-media-export-plugin.vala"
				enabled = rygel_configuration_get_bool ((RygelConfiguration*) config, "MediaExport", "enabled", &_inner_error_);
#line 256 "rygel-media-export-plugin.c"
				if (_inner_error_ != NULL) {
					_g_object_unref0 (config);
					goto __catch0_g_error;
				}
#line 59 "rygel-media-export-plugin.vala"
				if (enabled) {
#line 263 "rygel-media-export-plugin.c"
					RygelMediaContainer* _tmp1_;
					RygelMediaExportRootContainer* root;
#line 60 "rygel-media-export-plugin.vala"
					root = (_tmp1_ = rygel_media_export_root_container_get_instance (), RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER (_tmp1_) ? ((RygelMediaExportRootContainer*) _tmp1_) : NULL);
#line 63 "rygel-media-export-plugin.vala"
					rygel_media_export_root_container_shutdown (root);
#line 270 "rygel-media-export-plugin.c"
					_g_object_unref0 (root);
				}
				_g_object_unref0 (config);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError * _error_;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (_error_);
				}
			}
			__finally0:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			;
		} else {
#line 67 "rygel-media-export-plugin.vala"
			g_message ("rygel-media-export-plugin.vala:67: Plugin '%s' disabled, enabling '%s'" \
" plugin", TRACKER_PLUGIN, OUR_PLUGIN);
#line 295 "rygel-media-export-plugin.c"
		}
#line 72 "rygel-media-export-plugin.vala"
		rygel_plugin_set_available (our_plugin, !rygel_plugin_get_available (plugin));
#line 299 "rygel-media-export-plugin.c"
	}
}


#line 77 "rygel-media-export-plugin.vala"
RygelMediaExportPlugin* rygel_media_export_plugin_construct (GType object_type) {
#line 306 "rygel-media-export-plugin.c"
	RygelMediaExportPlugin * self;
#line 78 "rygel-media-export-plugin.vala"
	self = (RygelMediaExportPlugin*) rygel_media_server_plugin_construct (object_type, OUR_PLUGIN, _ ("@REALNAME@'s media"), NULL);
#line 310 "rygel-media-export-plugin.c"
	return self;
}


#line 77 "rygel-media-export-plugin.vala"
RygelMediaExportPlugin* rygel_media_export_plugin_new (void) {
#line 77 "rygel-media-export-plugin.vala"
	return rygel_media_export_plugin_construct (RYGEL_MEDIA_EXPORT_TYPE_PLUGIN);
#line 319 "rygel-media-export-plugin.c"
}


#line 81 "rygel-media-export-plugin.vala"
static RygelMediaContainer* rygel_media_export_plugin_real_get_root_container (RygelMediaServerPlugin* base, GUPnPContext* context) {
#line 325 "rygel-media-export-plugin.c"
	RygelMediaExportPlugin * self;
	RygelMediaContainer* result = NULL;
	self = (RygelMediaExportPlugin*) base;
#line 81 "rygel-media-export-plugin.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 331 "rygel-media-export-plugin.c"
	result = rygel_media_export_root_container_get_instance ();
#line 82 "rygel-media-export-plugin.vala"
	return result;
#line 335 "rygel-media-export-plugin.c"
}


static void rygel_media_export_plugin_class_init (RygelMediaExportPluginClass * klass) {
	rygel_media_export_plugin_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_SERVER_PLUGIN_CLASS (klass)->get_root_container = rygel_media_export_plugin_real_get_root_container;
}


static void rygel_media_export_plugin_instance_init (RygelMediaExportPlugin * self) {
}


GType rygel_media_export_plugin_get_type (void) {
	static volatile gsize rygel_media_export_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportPlugin), 0, (GInstanceInitFunc) rygel_media_export_plugin_instance_init, NULL };
		GType rygel_media_export_plugin_type_id;
		rygel_media_export_plugin_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_SERVER_PLUGIN, "RygelMediaExportPlugin", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_plugin_type_id__volatile, rygel_media_export_plugin_type_id);
	}
	return rygel_media_export_plugin_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




