/* rygel-live-response.c generated by valac 0.9.5, the Vala compiler
 * generated from rygel-live-response.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;

#define RYGEL_TYPE_LIVE_RESPONSE (rygel_live_response_get_type ())
#define RYGEL_LIVE_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LIVE_RESPONSE, RygelLiveResponse))
#define RYGEL_LIVE_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LIVE_RESPONSE, RygelLiveResponseClass))
#define RYGEL_IS_LIVE_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LIVE_RESPONSE))
#define RYGEL_IS_LIVE_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LIVE_RESPONSE))
#define RYGEL_LIVE_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LIVE_RESPONSE, RygelLiveResponseClass))

typedef struct _RygelLiveResponse RygelLiveResponse;
typedef struct _RygelLiveResponseClass RygelLiveResponseClass;
typedef struct _RygelLiveResponsePrivate RygelLiveResponsePrivate;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelLiveResponseRunData RygelLiveResponseRunData;
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _gst_buffer_unref0(var) ((var == NULL) ? NULL : (var = (gst_buffer_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
	SoupMessage* msg;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelHTTPResponse* self, GAsyncResult* _res_);
	void (*end) (RygelHTTPResponse* self, gboolean aborted, guint status);
};

struct _RygelLiveResponse {
	RygelHTTPResponse parent_instance;
	RygelLiveResponsePrivate * priv;
};

struct _RygelLiveResponseClass {
	RygelHTTPResponseClass parent_class;
};

struct _RygelLiveResponsePrivate {
	GstPipeline* pipeline;
	RygelHTTPSeek* time_range;
	gint64 buffered;
	gboolean out_of_sync;
};

struct _RygelLiveResponseRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelLiveResponse* self;
	gboolean _tmp0_;
	GSourceFunc _tmp1_;
};

typedef enum  {
	RYGEL_GST_ERROR_MISSING_PLUGIN,
	RYGEL_GST_ERROR_LINK
} RygelGstError;
#define RYGEL_GST_ERROR rygel_gst_error_quark ()
struct _Block2Data {
	int _ref_count_;
	RygelLiveResponse * self;
	GstBuffer* buffer;
};


static gpointer rygel_live_response_parent_class = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_response_get_type (void) G_GNUC_CONST;
GType rygel_live_response_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
#define RYGEL_LIVE_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_LIVE_RESPONSE, RygelLiveResponsePrivate))
enum  {
	RYGEL_LIVE_RESPONSE_DUMMY_PROPERTY
};
#define RYGEL_LIVE_RESPONSE_SINK_NAME "fakesink"
#define RYGEL_LIVE_RESPONSE_MAX_BUFFERED_CHUNKS ((guint) 32)
#define RYGEL_LIVE_RESPONSE_MIN_BUFFERED_CHUNKS ((guint) 4)
RygelHTTPResponse* rygel_http_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, gboolean partial, GCancellable* cancellable);
static void rygel_live_response_prepare_pipeline (RygelLiveResponse* self, const char* name, GstElement* src, GError** error);
RygelLiveResponse* rygel_live_response_new (SoupServer* server, SoupMessage* msg, const char* name, GstElement* src, RygelHTTPSeek* time_range, GCancellable* cancellable, GError** error);
RygelLiveResponse* rygel_live_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, const char* name, GstElement* src, RygelHTTPSeek* time_range, GCancellable* cancellable, GError** error);
static void rygel_live_response_real_run_data_free (gpointer _data);
static void rygel_live_response_real_run (RygelHTTPResponse* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_live_response_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_live_response_on_wrote_chunk (RygelLiveResponse* self, SoupMessage* msg);
static void _rygel_live_response_on_wrote_chunk_soup_message_wrote_chunk (SoupMessage* _sender, gpointer self);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
void rygel_http_response_run (RygelHTTPResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_response_run_finish (RygelHTTPResponse* self, GAsyncResult* _res_);
static gboolean _rygel_live_response_real_run_co_gsource_func (gpointer self);
static gboolean rygel_live_response_real_run_co (RygelLiveResponseRunData* data);
SoupServer* rygel_http_response_get_server (RygelHTTPResponse* self);
void rygel_http_response_end (RygelHTTPResponse* self, gboolean aborted, guint status);
static void rygel_live_response_real_end (RygelHTTPResponse* base, gboolean aborted, guint status);
GQuark rygel_gst_error_quark (void);
static inline void _dynamic_set_signal_handoffs0 (GstElement* obj, gboolean value);
static void rygel_live_response_on_new_buffer (GstElement* sink, GstBuffer* buffer, GstPad* pad, RygelLiveResponse* self);
static void rygel_live_response_src_pad_added (RygelLiveResponse* self, GstElement* src, GstPad* src_pad);
static void _rygel_live_response_src_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
static gboolean rygel_live_response_bus_handler (RygelLiveResponse* self, GstBus* bus, GstMessage* message);
static gboolean _rygel_live_response_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
void rygel_http_response_push_data (RygelHTTPResponse* self, void* data, gsize length);
static gboolean _lambda2_ (Block2Data* _data2_);
static gboolean __lambda2__gsource_func (gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean rygel_live_response_seek (RygelLiveResponse* self);
static gboolean _lambda3_ (RygelLiveResponse* self);
static gboolean __lambda3__gsource_func (gpointer self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
static void rygel_live_response_finalize (GObject* obj);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 42 "rygel-live-response.vala"
RygelLiveResponse* rygel_live_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, const char* name, GstElement* src, RygelHTTPSeek* time_range, GCancellable* cancellable, GError** error) {
#line 207 "rygel-live-response.c"
	GError * _inner_error_;
	RygelLiveResponse * self;
	RygelHTTPSeek* _tmp0_;
#line 42 "rygel-live-response.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 42 "rygel-live-response.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 42 "rygel-live-response.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 42 "rygel-live-response.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 219 "rygel-live-response.c"
	_inner_error_ = NULL;
#line 48 "rygel-live-response.vala"
	self = (RygelLiveResponse*) rygel_http_response_construct (object_type, server, msg, FALSE, cancellable);
#line 50 "rygel-live-response.vala"
	soup_message_headers_set_encoding (((RygelHTTPResponse*) self)->msg->response_headers, SOUP_ENCODING_EOF);
#line 52 "rygel-live-response.vala"
	rygel_live_response_prepare_pipeline (self, name, src, &_inner_error_);
#line 227 "rygel-live-response.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
#line 53 "rygel-live-response.vala"
	self->priv->time_range = (_tmp0_ = _g_object_ref0 (time_range), _g_object_unref0 (self->priv->time_range), _tmp0_);
#line 55 "rygel-live-response.vala"
	self->priv->buffered = (gint64) 0;
#line 56 "rygel-live-response.vala"
	self->priv->out_of_sync = FALSE;
#line 239 "rygel-live-response.c"
	return self;
}


#line 42 "rygel-live-response.vala"
RygelLiveResponse* rygel_live_response_new (SoupServer* server, SoupMessage* msg, const char* name, GstElement* src, RygelHTTPSeek* time_range, GCancellable* cancellable, GError** error) {
#line 42 "rygel-live-response.vala"
	return rygel_live_response_construct (RYGEL_TYPE_LIVE_RESPONSE, server, msg, name, src, time_range, cancellable, error);
#line 248 "rygel-live-response.c"
}


static void rygel_live_response_real_run_data_free (gpointer _data) {
	RygelLiveResponseRunData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelLiveResponseRunData, data);
}


static void rygel_live_response_real_run (RygelHTTPResponse* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelLiveResponse * self;
	RygelLiveResponseRunData* _data_;
	self = (RygelLiveResponse*) base;
	_data_ = g_slice_new0 (RygelLiveResponseRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_live_response_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_live_response_real_run_data_free);
	_data_->self = g_object_ref (self);
	rygel_live_response_real_run_co (_data_);
}


static void rygel_live_response_real_run_finish (RygelHTTPResponse* base, GAsyncResult* _res_) {
	RygelLiveResponseRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_live_response_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelLiveResponseRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_live_response_real_run_co (data);
}


#line 185 "rygel-live-response.vala"
static void _rygel_live_response_on_wrote_chunk_soup_message_wrote_chunk (SoupMessage* _sender, gpointer self) {
#line 288 "rygel-live-response.c"
	rygel_live_response_on_wrote_chunk (self, _sender);
}


#line 59 "rygel-live-response.vala"
static gboolean _rygel_live_response_real_run_co_gsource_func (gpointer self) {
#line 295 "rygel-live-response.c"
	gboolean result;
	result = rygel_live_response_real_run_co (self);
	return result;
}


static gboolean rygel_live_response_real_run_co (RygelLiveResponseRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 10:
		goto _state_10;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
#line 60 "rygel-live-response.vala"
		g_signal_connect_object (((RygelHTTPResponse*) data->self)->msg, "wrote-chunk", (GCallback) _rygel_live_response_on_wrote_chunk_soup_message_wrote_chunk, data->self, 0);
#line 63 "rygel-live-response.vala"
		if (data->self->priv->time_range != NULL) {
#line 63 "rygel-live-response.vala"
			data->_tmp0_ = rygel_http_seek_get_start (data->self->priv->time_range) > 0;
#line 319 "rygel-live-response.c"
		} else {
#line 63 "rygel-live-response.vala"
			data->_tmp0_ = FALSE;
#line 323 "rygel-live-response.c"
		}
#line 63 "rygel-live-response.vala"
		if (data->_tmp0_) {
#line 64 "rygel-live-response.vala"
			gst_element_set_state ((GstElement*) data->self->priv->pipeline, GST_STATE_PAUSED);
#line 329 "rygel-live-response.c"
		} else {
#line 66 "rygel-live-response.vala"
			gst_element_set_state ((GstElement*) data->self->priv->pipeline, GST_STATE_PLAYING);
#line 333 "rygel-live-response.c"
		}
#line 69 "rygel-live-response.vala"
		((RygelHTTPResponse*) data->self)->run_continue = (data->_tmp1_ = _rygel_live_response_real_run_co_gsource_func, ((((RygelHTTPResponse*) ((RygelHTTPResponse*) data->self))->run_continue_target_destroy_notify == NULL) ? NULL : (((RygelHTTPResponse*) ((RygelHTTPResponse*) data->self))->run_continue_target_destroy_notify (((RygelHTTPResponse*) ((RygelHTTPResponse*) data->self))->run_continue_target), NULL), ((RygelHTTPResponse*) data->self)->run_continue = NULL, ((RygelHTTPResponse*) ((RygelHTTPResponse*) data->self))->run_continue_target = NULL, ((RygelHTTPResponse*) ((RygelHTTPResponse*) data->self))->run_continue_target_destroy_notify = NULL), ((RygelHTTPResponse*) ((RygelHTTPResponse*) data->self))->run_continue_target = data, ((RygelHTTPResponse*) ((RygelHTTPResponse*) data->self))->run_continue_target_destroy_notify = NULL, data->_tmp1_);
#line 337 "rygel-live-response.c"
		data->_state_ = 10;
		return FALSE;
		_state_10:
		;
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 74 "rygel-live-response.vala"
static void rygel_live_response_real_end (RygelHTTPResponse* base, gboolean aborted, guint status) {
#line 357 "rygel-live-response.c"
	RygelLiveResponse * self;
	guint _tmp0_;
	self = (RygelLiveResponse*) base;
#line 75 "rygel-live-response.vala"
	gst_element_set_state ((GstElement*) self->priv->pipeline, GST_STATE_NULL);
#line 76 "rygel-live-response.vala"
	g_signal_parse_name ("wrote-chunk", SOUP_TYPE_MESSAGE, &_tmp0_, NULL, FALSE);
#line 76 "rygel-live-response.vala"
	g_signal_handlers_disconnect_matched (((RygelHTTPResponse*) self)->msg, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _rygel_live_response_on_wrote_chunk_soup_message_wrote_chunk, self);
#line 78 "rygel-live-response.vala"
	if (!aborted) {
#line 79 "rygel-live-response.vala"
		soup_message_body_complete (((RygelHTTPResponse*) self)->msg->response_body);
#line 80 "rygel-live-response.vala"
		soup_server_unpause_message (rygel_http_response_get_server ((RygelHTTPResponse*) self), ((RygelHTTPResponse*) self)->msg);
#line 373 "rygel-live-response.c"
	}
#line 83 "rygel-live-response.vala"
	RYGEL_HTTP_RESPONSE_CLASS (rygel_live_response_parent_class)->end (RYGEL_HTTP_RESPONSE (self), aborted, status);
#line 377 "rygel-live-response.c"
}


static inline void _dynamic_set_signal_handoffs0 (GstElement* obj, gboolean value) {
	g_object_set (obj, "signal-handoffs", value, NULL);
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


#line 126 "rygel-live-response.vala"
static void _rygel_live_response_src_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
#line 393 "rygel-live-response.c"
	rygel_live_response_src_pad_added (self, _sender, pad);
}


#line 194 "rygel-live-response.vala"
static gboolean _rygel_live_response_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
#line 400 "rygel-live-response.c"
	gboolean result;
	result = rygel_live_response_bus_handler (self, bus, message);
	return result;
}


#line 86 "rygel-live-response.vala"
static void rygel_live_response_prepare_pipeline (RygelLiveResponse* self, const char* name, GstElement* src, GError** error) {
#line 409 "rygel-live-response.c"
	GError * _inner_error_;
	GstElement* sink;
	GstPipeline* _tmp0_;
	GstBus* bus;
#line 86 "rygel-live-response.vala"
	g_return_if_fail (self != NULL);
#line 86 "rygel-live-response.vala"
	g_return_if_fail (name != NULL);
#line 86 "rygel-live-response.vala"
	g_return_if_fail (src != NULL);
#line 420 "rygel-live-response.c"
	_inner_error_ = NULL;
#line 88 "rygel-live-response.vala"
	sink = gst_element_factory_make ("fakesink", RYGEL_LIVE_RESPONSE_SINK_NAME);
#line 90 "rygel-live-response.vala"
	if (sink == NULL) {
#line 426 "rygel-live-response.c"
		_inner_error_ = g_error_new_literal (RYGEL_GST_ERROR, RYGEL_GST_ERROR_MISSING_PLUGIN, _ ("Plugin 'fakesink' missing"));
		{
			g_propagate_error (error, _inner_error_);
			_gst_object_unref0 (sink);
			return;
		}
	}
#line 95 "rygel-live-response.vala"
	_dynamic_set_signal_handoffs0 (sink, TRUE);
#line 98 "rygel-live-response.vala"
	g_signal_connect_object (sink, "handoff", (GCallback) rygel_live_response_on_new_buffer, (GObject*) self, G_CONNECT_AFTER);
#line 104 "rygel-live-response.vala"
	self->priv->pipeline = (_tmp0_ = (GstPipeline*) gst_pipeline_new (name), _gst_object_unref0 (self->priv->pipeline), _tmp0_);
#line 105 "rygel-live-response.vala"
	g_assert (self->priv->pipeline != NULL);
#line 107 "rygel-live-response.vala"
	gst_bin_add_many ((GstBin*) self->priv->pipeline, _gst_object_ref0 (src), _gst_object_ref0 (sink), NULL);
#line 109 "rygel-live-response.vala"
	if (src->numpads == 0) {
#line 111 "rygel-live-response.vala"
		g_signal_connect_object (src, "pad-added", (GCallback) _rygel_live_response_src_pad_added_gst_element_pad_added, self, 0);
#line 448 "rygel-live-response.c"
	} else {
#line 114 "rygel-live-response.vala"
		if (!gst_element_link (src, sink)) {
#line 452 "rygel-live-response.c"
			_inner_error_ = g_error_new (RYGEL_GST_ERROR, RYGEL_GST_ERROR_LINK, _ ("Failed to link %s to %s"), gst_object_get_name ((GstObject*) src), gst_object_get_name ((GstObject*) sink));
			{
				g_propagate_error (error, _inner_error_);
				_gst_object_unref0 (sink);
				return;
			}
		}
	}
#line 122 "rygel-live-response.vala"
	bus = gst_pipeline_get_bus (self->priv->pipeline);
#line 123 "rygel-live-response.vala"
	gst_bus_add_watch_full (bus, G_PRIORITY_DEFAULT, _rygel_live_response_bus_handler_gst_bus_func, g_object_ref (self), g_object_unref);
#line 465 "rygel-live-response.c"
	_gst_object_unref0 (bus);
	_gst_object_unref0 (sink);
}


#line 126 "rygel-live-response.vala"
static void rygel_live_response_src_pad_added (RygelLiveResponse* self, GstElement* src, GstPad* src_pad) {
#line 473 "rygel-live-response.c"
	GstCaps* caps;
	GstElement* sink;
	GstPad* sink_pad;
	GstElement* depay;
#line 126 "rygel-live-response.vala"
	g_return_if_fail (self != NULL);
#line 126 "rygel-live-response.vala"
	g_return_if_fail (src != NULL);
#line 126 "rygel-live-response.vala"
	g_return_if_fail (src_pad != NULL);
#line 128 "rygel-live-response.vala"
	caps = gst_pad_get_caps (src_pad);
#line 130 "rygel-live-response.vala"
	sink = gst_bin_get_by_name ((GstBin*) self->priv->pipeline, RYGEL_LIVE_RESPONSE_SINK_NAME);
#line 488 "rygel-live-response.c"
	sink_pad = NULL;
#line 133 "rygel-live-response.vala"
	depay = rygel_gst_utils_get_rtp_depayloader (caps);
#line 134 "rygel-live-response.vala"
	if (depay != NULL) {
#line 494 "rygel-live-response.c"
		GstPad* _tmp0_;
#line 135 "rygel-live-response.vala"
		gst_bin_add ((GstBin*) self->priv->pipeline, _gst_object_ref0 (depay));
#line 136 "rygel-live-response.vala"
		if (!gst_element_link (depay, sink)) {
#line 137 "rygel-live-response.vala"
			g_critical (_ ("Failed to link %s to %s"), gst_object_get_name ((GstObject*) depay), gst_object_get_name ((GstObject*) sink));
#line 140 "rygel-live-response.vala"
			rygel_http_response_end ((RygelHTTPResponse*) self, FALSE, (guint) SOUP_STATUS_NONE);
#line 504 "rygel-live-response.c"
			_gst_object_unref0 (depay);
			_gst_object_unref0 (sink_pad);
			_gst_object_unref0 (sink);
			_gst_caps_unref0 (caps);
#line 141 "rygel-live-response.vala"
			return;
#line 511 "rygel-live-response.c"
		}
#line 144 "rygel-live-response.vala"
		sink_pad = (_tmp0_ = gst_element_get_compatible_pad (depay, src_pad, caps), _gst_object_unref0 (sink_pad), _tmp0_);
#line 515 "rygel-live-response.c"
	} else {
		GstPad* _tmp1_;
#line 146 "rygel-live-response.vala"
		sink_pad = (_tmp1_ = gst_element_get_compatible_pad (sink, src_pad, caps), _gst_object_unref0 (sink_pad), _tmp1_);
#line 520 "rygel-live-response.c"
	}
#line 149 "rygel-live-response.vala"
	if (gst_pad_link (src_pad, sink_pad) != GST_PAD_LINK_OK) {
#line 150 "rygel-live-response.vala"
		g_critical (_ ("Failed to link pad %s to %s"), gst_object_get_name ((GstObject*) src_pad), gst_object_get_name ((GstObject*) sink_pad));
#line 153 "rygel-live-response.vala"
		rygel_http_response_end ((RygelHTTPResponse*) self, FALSE, (guint) SOUP_STATUS_NONE);
#line 528 "rygel-live-response.c"
		_gst_object_unref0 (depay);
		_gst_object_unref0 (sink_pad);
		_gst_object_unref0 (sink);
		_gst_caps_unref0 (caps);
#line 154 "rygel-live-response.vala"
		return;
#line 535 "rygel-live-response.c"
	}
#line 157 "rygel-live-response.vala"
	if (depay != NULL) {
#line 158 "rygel-live-response.vala"
		gst_element_sync_state_with_parent (depay);
#line 541 "rygel-live-response.c"
	}
	_gst_object_unref0 (depay);
	_gst_object_unref0 (sink_pad);
	_gst_object_unref0 (sink);
	_gst_caps_unref0 (caps);
}


#line 167 "rygel-live-response.vala"
static gboolean _lambda2_ (Block2Data* _data2_) {
#line 552 "rygel-live-response.c"
	RygelLiveResponse * self;
	gboolean result = FALSE;
	self = _data2_->self;
#line 168 "rygel-live-response.vala"
	if (g_cancellable_is_cancelled (rygel_state_machine_get_cancellable ((RygelStateMachine*) self))) {
#line 558 "rygel-live-response.c"
		result = FALSE;
#line 169 "rygel-live-response.vala"
		return result;
#line 562 "rygel-live-response.c"
	}
#line 172 "rygel-live-response.vala"
	rygel_http_response_push_data ((RygelHTTPResponse*) self, _data2_->buffer->data, (gsize) _data2_->buffer->size);
#line 173 "rygel-live-response.vala"
	self->priv->buffered++;
#line 175 "rygel-live-response.vala"
	if (self->priv->buffered > RYGEL_LIVE_RESPONSE_MAX_BUFFERED_CHUNKS) {
#line 177 "rygel-live-response.vala"
		gst_element_set_state ((GstElement*) self->priv->pipeline, GST_STATE_PAUSED);
#line 178 "rygel-live-response.vala"
		self->priv->out_of_sync = TRUE;
#line 574 "rygel-live-response.c"
	}
	result = FALSE;
#line 181 "rygel-live-response.vala"
	return result;
#line 579 "rygel-live-response.c"
}


#line 167 "rygel-live-response.vala"
static gboolean __lambda2__gsource_func (gpointer self) {
#line 585 "rygel-live-response.c"
	gboolean result;
	result = _lambda2_ (self);
	return result;
}


static gpointer _gst_buffer_ref0 (gpointer self) {
	return self ? gst_buffer_ref (self) : NULL;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_gst_buffer_unref0 (_data2_->buffer);
		g_slice_free (Block2Data, _data2_);
	}
}


#line 163 "rygel-live-response.vala"
static void rygel_live_response_on_new_buffer (GstElement* sink, GstBuffer* buffer, GstPad* pad, RygelLiveResponse* self) {
#line 614 "rygel-live-response.c"
	Block2Data* _data2_;
#line 163 "rygel-live-response.vala"
	g_return_if_fail (self != NULL);
#line 163 "rygel-live-response.vala"
	g_return_if_fail (sink != NULL);
#line 163 "rygel-live-response.vala"
	g_return_if_fail (buffer != NULL);
#line 163 "rygel-live-response.vala"
	g_return_if_fail (pad != NULL);
#line 624 "rygel-live-response.c"
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->buffer = _gst_buffer_ref0 (buffer);
#line 166 "rygel-live-response.vala"
	g_idle_add_full (G_PRIORITY_HIGH_IDLE, __lambda2__gsource_func, block2_data_ref (_data2_), block2_data_unref);
#line 631 "rygel-live-response.c"
	block2_data_unref (_data2_);
}


#line 185 "rygel-live-response.vala"
static void rygel_live_response_on_wrote_chunk (RygelLiveResponse* self, SoupMessage* msg) {
#line 638 "rygel-live-response.c"
	gboolean _tmp0_ = FALSE;
#line 185 "rygel-live-response.vala"
	g_return_if_fail (self != NULL);
#line 185 "rygel-live-response.vala"
	g_return_if_fail (msg != NULL);
#line 186 "rygel-live-response.vala"
	self->priv->buffered--;
#line 188 "rygel-live-response.vala"
	if (self->priv->out_of_sync) {
#line 188 "rygel-live-response.vala"
		_tmp0_ = self->priv->buffered < RYGEL_LIVE_RESPONSE_MIN_BUFFERED_CHUNKS;
#line 650 "rygel-live-response.c"
	} else {
#line 188 "rygel-live-response.vala"
		_tmp0_ = FALSE;
#line 654 "rygel-live-response.c"
	}
#line 188 "rygel-live-response.vala"
	if (_tmp0_) {
#line 189 "rygel-live-response.vala"
		gst_element_set_state ((GstElement*) self->priv->pipeline, GST_STATE_PLAYING);
#line 190 "rygel-live-response.vala"
		self->priv->out_of_sync = FALSE;
#line 662 "rygel-live-response.c"
	}
}


#line 240 "rygel-live-response.vala"
static gboolean _lambda3_ (RygelLiveResponse* self) {
#line 669 "rygel-live-response.c"
	gboolean result = FALSE;
#line 241 "rygel-live-response.vala"
	rygel_http_response_end ((RygelHTTPResponse*) self, FALSE, (guint) SOUP_STATUS_NONE);
#line 673 "rygel-live-response.c"
	result = FALSE;
#line 243 "rygel-live-response.vala"
	return result;
#line 677 "rygel-live-response.c"
}


#line 240 "rygel-live-response.vala"
static gboolean __lambda3__gsource_func (gpointer self) {
#line 683 "rygel-live-response.c"
	gboolean result;
	result = _lambda3_ (self);
	return result;
}


#line 194 "rygel-live-response.vala"
static gboolean rygel_live_response_bus_handler (RygelLiveResponse* self, GstBus* bus, GstMessage* message) {
#line 692 "rygel-live-response.c"
	gboolean result = FALSE;
	gboolean ret;
#line 194 "rygel-live-response.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 194 "rygel-live-response.vala"
	g_return_val_if_fail (bus != NULL, FALSE);
#line 194 "rygel-live-response.vala"
	g_return_val_if_fail (message != NULL, FALSE);
#line 196 "rygel-live-response.vala"
	ret = TRUE;
#line 198 "rygel-live-response.vala"
	if (message->type == GST_MESSAGE_EOS) {
#line 199 "rygel-live-response.vala"
		ret = FALSE;
#line 707 "rygel-live-response.c"
	} else {
#line 200 "rygel-live-response.vala"
		if (message->type == GST_MESSAGE_STATE_CHANGED) {
#line 711 "rygel-live-response.c"
			gboolean _tmp0_ = FALSE;
#line 201 "rygel-live-response.vala"
			if (message->src != GST_OBJECT (self->priv->pipeline)) {
#line 715 "rygel-live-response.c"
				result = TRUE;
#line 202 "rygel-live-response.vala"
				return result;
#line 719 "rygel-live-response.c"
			}
#line 205 "rygel-live-response.vala"
			if (self->priv->time_range != NULL) {
#line 205 "rygel-live-response.vala"
				_tmp0_ = rygel_http_seek_get_start (self->priv->time_range) > 0;
#line 725 "rygel-live-response.c"
			} else {
#line 205 "rygel-live-response.vala"
				_tmp0_ = FALSE;
#line 729 "rygel-live-response.c"
			}
#line 205 "rygel-live-response.vala"
			if (_tmp0_) {
#line 733 "rygel-live-response.c"
				GstState old_state = 0;
				GstState new_state = 0;
				gboolean _tmp1_ = FALSE;
#line 209 "rygel-live-response.vala"
				gst_message_parse_state_changed (message, &old_state, &new_state, NULL);
#line 213 "rygel-live-response.vala"
				if (old_state == GST_STATE_READY) {
#line 213 "rygel-live-response.vala"
					_tmp1_ = new_state == GST_STATE_PAUSED;
#line 743 "rygel-live-response.c"
				} else {
#line 213 "rygel-live-response.vala"
					_tmp1_ = FALSE;
#line 747 "rygel-live-response.c"
				}
#line 213 "rygel-live-response.vala"
				if (_tmp1_) {
#line 214 "rygel-live-response.vala"
					if (rygel_live_response_seek (self)) {
#line 215 "rygel-live-response.vala"
						gst_element_set_state ((GstElement*) self->priv->pipeline, GST_STATE_PLAYING);
#line 755 "rygel-live-response.c"
					}
				}
			}
		} else {
			GError* err;
			char* err_msg;
			err = NULL;
			err_msg = NULL;
#line 223 "rygel-live-response.vala"
			if (message->type == GST_MESSAGE_ERROR) {
#line 766 "rygel-live-response.c"
				char* _tmp5_;
				char* _tmp4_ = NULL;
				GError* _tmp3_;
				GError* _tmp2_ = NULL;
#line 224 "rygel-live-response.vala"
				(gst_message_parse_error (message, &_tmp2_, &_tmp4_), err = (_tmp3_ = _tmp2_, _g_error_free0 (err), _tmp3_));
#line 224 "rygel-live-response.vala"
				err_msg = (_tmp5_ = _tmp4_, _g_free0 (err_msg), _tmp5_);
#line 225 "rygel-live-response.vala"
				g_critical (_ ("Error from pipeline %s: %s"), gst_object_get_name ((GstObject*) self->priv->pipeline), err_msg);
#line 229 "rygel-live-response.vala"
				ret = FALSE;
#line 779 "rygel-live-response.c"
			} else {
#line 230 "rygel-live-response.vala"
				if (message->type == GST_MESSAGE_WARNING) {
#line 783 "rygel-live-response.c"
					char* _tmp9_;
					char* _tmp8_ = NULL;
					GError* _tmp7_;
					GError* _tmp6_ = NULL;
#line 231 "rygel-live-response.vala"
					(gst_message_parse_warning (message, &_tmp6_, &_tmp8_), err = (_tmp7_ = _tmp6_, _g_error_free0 (err), _tmp7_));
#line 231 "rygel-live-response.vala"
					err_msg = (_tmp9_ = _tmp8_, _g_free0 (err_msg), _tmp9_);
#line 232 "rygel-live-response.vala"
					g_warning (_ ("Warning from pipeline %s: %s"), gst_object_get_name ((GstObject*) self->priv->pipeline), err_msg);
#line 794 "rygel-live-response.c"
				}
			}
			_g_free0 (err_msg);
			_g_error_free0 (err);
		}
	}
#line 238 "rygel-live-response.vala"
	if (!ret) {
#line 239 "rygel-live-response.vala"
		g_idle_add_full (G_PRIORITY_HIGH_IDLE, __lambda3__gsource_func, g_object_ref (self), g_object_unref);
#line 805 "rygel-live-response.c"
	}
	result = ret;
#line 247 "rygel-live-response.vala"
	return result;
#line 810 "rygel-live-response.c"
}


#line 250 "rygel-live-response.vala"
static gboolean rygel_live_response_seek (RygelLiveResponse* self) {
#line 816 "rygel-live-response.c"
	gboolean result = FALSE;
	GstSeekType stop_type = 0;
#line 250 "rygel-live-response.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 253 "rygel-live-response.vala"
	if (rygel_http_seek_get_stop (self->priv->time_range) > 0) {
#line 254 "rygel-live-response.vala"
		stop_type = GST_SEEK_TYPE_SET;
#line 825 "rygel-live-response.c"
	} else {
#line 256 "rygel-live-response.vala"
		stop_type = GST_SEEK_TYPE_NONE;
#line 829 "rygel-live-response.c"
	}
#line 259 "rygel-live-response.vala"
	if (!gst_element_seek ((GstElement*) self->priv->pipeline, 1.0, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH, GST_SEEK_TYPE_SET, rygel_http_seek_get_start (self->priv->time_range), stop_type, rygel_http_seek_get_stop (self->priv->time_range))) {
#line 266 "rygel-live-response.vala"
		g_warning (_ ("Failed to seek to offset %lld"), rygel_http_seek_get_start (self->priv->time_range));
#line 268 "rygel-live-response.vala"
		rygel_http_response_end ((RygelHTTPResponse*) self, FALSE, (guint) SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE);
#line 837 "rygel-live-response.c"
		result = FALSE;
#line 271 "rygel-live-response.vala"
		return result;
#line 841 "rygel-live-response.c"
	}
	result = TRUE;
#line 274 "rygel-live-response.vala"
	return result;
#line 846 "rygel-live-response.c"
}


static void rygel_live_response_class_init (RygelLiveResponseClass * klass) {
	rygel_live_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelLiveResponsePrivate));
	RYGEL_HTTP_RESPONSE_CLASS (klass)->run = rygel_live_response_real_run;
	RYGEL_HTTP_RESPONSE_CLASS (klass)->run_finish = rygel_live_response_real_run_finish;
	RYGEL_HTTP_RESPONSE_CLASS (klass)->end = rygel_live_response_real_end;
	G_OBJECT_CLASS (klass)->finalize = rygel_live_response_finalize;
}


static void rygel_live_response_instance_init (RygelLiveResponse * self) {
	self->priv = RYGEL_LIVE_RESPONSE_GET_PRIVATE (self);
}


static void rygel_live_response_finalize (GObject* obj) {
	RygelLiveResponse * self;
	self = RYGEL_LIVE_RESPONSE (obj);
	_gst_object_unref0 (self->priv->pipeline);
	_g_object_unref0 (self->priv->time_range);
	G_OBJECT_CLASS (rygel_live_response_parent_class)->finalize (obj);
}


GType rygel_live_response_get_type (void) {
	static volatile gsize rygel_live_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_live_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelLiveResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_live_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLiveResponse), 0, (GInstanceInitFunc) rygel_live_response_instance_init, NULL };
		GType rygel_live_response_type_id;
		rygel_live_response_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE, "RygelLiveResponse", &g_define_type_info, 0);
		g_once_init_leave (&rygel_live_response_type_id__volatile, rygel_live_response_type_id);
	}
	return rygel_live_response_type_id__volatile;
}




