/* rygel-media-container.c generated by valac 0.9.5, the Vala compiler
 * generated from rygel-media-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <libgupnp-av/gupnp-av.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelMediaContainerSearchData RygelMediaContainerSearchData;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
typedef struct _RygelMediaContainerFindObjectData RygelMediaContainerFindObjectData;
typedef struct _RygelMediaContainerAddItemData RygelMediaContainerAddItemData;
typedef struct _RygelMediaContainerSearchInChildrenData RygelMediaContainerSearchInChildrenData;

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gint child_count;
	guint32 update_id;
	GeeArrayList* create_classes;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*search) (RygelMediaContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelMediaContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	void (*find_object) (RygelMediaContainer* self, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_item) (RygelMediaContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaContainerSearchData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* _result_;
	RygelMediaObjects* children;
	guint limit;
	gboolean _tmp0_;
	GeeIterator* _child_it;
	RygelMediaObject* child;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	guint _tmp4_;
	guint child_limit;
	RygelMediaObjects* child_results;
	gboolean _tmp5_;
	guint start;
	guint stop;
	gboolean _tmp6_;
	GeeList* _tmp7_;
	GError * _inner_error_;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	char* (*to_string) (RygelSearchExpression* self);
};

struct _RygelMediaContainerFindObjectData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaContainer* self;
	char* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelRelationalExpression* expression;
	char* _tmp0_;
	char* _tmp1_;
	guint total_matches;
	RygelMediaObjects* results;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelMediaContainerAddItemData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaContainer* self;
	RygelMediaItem* item;
	GCancellable* cancellable;
	GFile* dir;
	GFile* file;
	GFileOutputStream* _tmp0_;
	char* uri;
	char* _tmp1_;
	GError * _inner_error_;
};

struct _RygelMediaContainerSearchInChildrenData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaContainer* self;
	RygelSearchExpression* expression;
	RygelMediaObjects* children;
	guint limit;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* _result_;
	GeeIterator* _child_it;
	RygelMediaObject* child;
	RygelMediaContainer* container;
	RygelMediaObject* _tmp0_;
	guint tmp;
	RygelMediaObjects* child_result;
	gboolean _tmp1_;
	GError * _inner_error_;
};


static gpointer rygel_media_container_parent_class = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY
};
RygelMediaObject* rygel_media_object_construct (GType object_type);
void rygel_media_object_set_title (RygelMediaObject* self, const char* value);
static void rygel_media_container_on_container_updated (RygelMediaContainer* self, RygelMediaContainer* container, RygelMediaContainer* updated_container);
static void _rygel_media_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
RygelMediaContainer* rygel_media_container_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, gint child_count);
RygelMediaContainer* rygel_media_container_construct_root (GType object_type, const char* title, gint child_count);
void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_media_container_real_search_data_free (gpointer _data);
static void rygel_media_container_real_search (RygelMediaContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
RygelMediaObjects* rygel_media_objects_new (void);
RygelMediaObjects* rygel_media_objects_construct (GType object_type);
gboolean rygel_search_expression_satisfied_by (RygelSearchExpression* self, RygelMediaObject* media_object);
static void rygel_media_container_search_in_children (RygelMediaContainer* self, RygelSearchExpression* expression, RygelMediaObjects* children, guint limit, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObjects* rygel_media_container_search_in_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
void rygel_media_container_search (RygelMediaContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_container_search_finish (RygelMediaContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static gboolean rygel_media_container_real_search_co (RygelMediaContainerSearchData* data);
static void rygel_media_container_real_find_object_data_free (gpointer _data);
static void rygel_media_container_real_find_object (RygelMediaContainer* self, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
void rygel_media_container_find_object (RygelMediaContainer* self, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_container_real_find_object_co (RygelMediaContainerFindObjectData* data);
static void rygel_media_container_real_add_item_data_free (gpointer _data);
static void rygel_media_container_real_add_item (RygelMediaContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_container_add_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
GQuark rygel_content_directory_error_quark (void);
const char* rygel_media_object_get_title (RygelMediaObject* self);
void rygel_media_container_add_item (RygelMediaContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_container_add_item_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_container_real_add_item_co (RygelMediaContainerAddItemData* data);
void rygel_media_container_updated (RygelMediaContainer* self);
#define RYGEL_MEDIA_ITEM_IMAGE_CLASS "object.item.imageItem"
#define RYGEL_MEDIA_ITEM_VIDEO_CLASS "object.item.videoItem"
#define RYGEL_MEDIA_ITEM_AUDIO_CLASS "object.item.audioItem"
void rygel_media_container_set_uri (RygelMediaContainer* self, const char* uri, GeeArrayList* create_classes);
static void rygel_media_container_search_in_children_data_free (gpointer _data);
static void rygel_media_container_search_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_media_container_search_in_children_co (RygelMediaContainerSearchInChildrenData* data);
static void rygel_media_container_finalize (GObject* obj);



#line 298 "rygel-media-container.vala"
static void _rygel_media_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
#line 318 "rygel-media-container.c"
	rygel_media_container_on_container_updated (self, _sender, container);
}


#line 46 "rygel-media-container.vala"
RygelMediaContainer* rygel_media_container_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, gint child_count) {
#line 325 "rygel-media-container.c"
	RygelMediaContainer * self;
	char* _tmp0_;
	char* _tmp1_;
	GeeArrayList* _tmp2_;
#line 46 "rygel-media-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 46 "rygel-media-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 46 "rygel-media-container.vala"
	self = (RygelMediaContainer*) rygel_media_object_construct (object_type);
#line 50 "rygel-media-container.vala"
	((RygelMediaObject*) self)->id = (_tmp0_ = g_strdup (id), _g_free0 (((RygelMediaObject*) self)->id), _tmp0_);
#line 51 "rygel-media-container.vala"
	((RygelMediaObject*) self)->parent = parent;
#line 52 "rygel-media-container.vala"
	rygel_media_object_set_title ((RygelMediaObject*) self, title);
#line 53 "rygel-media-container.vala"
	self->child_count = child_count;
#line 54 "rygel-media-container.vala"
	self->update_id = (guint32) 0;
#line 55 "rygel-media-container.vala"
	((RygelMediaObject*) self)->upnp_class = (_tmp1_ = g_strdup ("object.container.storageFolder"), _g_free0 (((RygelMediaObject*) self)->upnp_class), _tmp1_);
#line 56 "rygel-media-container.vala"
	self->create_classes = (_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL), _g_object_unref0 (self->create_classes), _tmp2_);
#line 58 "rygel-media-container.vala"
	g_signal_connect_object (self, "container-updated", (GCallback) _rygel_media_container_on_container_updated_rygel_media_container_container_updated, self, 0);
#line 352 "rygel-media-container.c"
	return self;
}


#line 61 "rygel-media-container.vala"
RygelMediaContainer* rygel_media_container_construct_root (GType object_type, const char* title, gint child_count) {
#line 359 "rygel-media-container.c"
	RygelMediaContainer * self;
#line 61 "rygel-media-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 63 "rygel-media-container.vala"
	self = (RygelMediaContainer*) rygel_media_container_construct (object_type, "0", NULL, title, child_count);
#line 365 "rygel-media-container.c"
	return self;
}


#line 61 "rygel-media-container.vala"
void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 61 "rygel-media-container.vala"
	RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->get_children (self, offset, max_count, cancellable, _callback_, _user_data_);
#line 374 "rygel-media-container.c"
}


#line 61 "rygel-media-container.vala"
RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
#line 61 "rygel-media-container.vala"
	return RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->get_children_finish (self, _res_, error);
#line 382 "rygel-media-container.c"
}


static void rygel_media_container_real_search_data_free (gpointer _data) {
	RygelMediaContainerSearchData* data;
	data = _data;
	_rygel_search_expression_unref0 (data->expression);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelMediaContainerSearchData, data);
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_media_container_real_search (RygelMediaContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaContainerSearchData* _data_;
	_data_ = g_slice_new0 (RygelMediaContainerSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_container_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_container_real_search_data_free);
	_data_->self = g_object_ref (self);
	_data_->expression = _rygel_search_expression_ref0 (expression);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_container_real_search_co (_data_);
}


static RygelMediaObjects* rygel_media_container_real_search_finish (RygelMediaContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelMediaContainerSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*total_matches = _data_->total_matches;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaContainerSearchData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_container_real_search_co (data);
}


/**
     * Recursively searches for all media objects the satisfy the given search
     * expression in this container.
     *
     * @param expression the search expression or `null` for wildcard
     * @param offet zero-based index of the first object to return
     * @param max_count maximum number of objects to return
     * @param total_matches sets it to the actual number of objects that satisfy
     *                      the given search expression. If it is not possible
     *                      to compute this value (in a timely mannger), it is
     *                      set to '0'.
     * @param cancellable optional cancellable for this operation
     *
     * return A list of media objects.
     */
static gboolean rygel_media_container_real_search_co (RygelMediaContainerSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 23:
		goto _state_23;
		case 24:
		goto _state_24;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_result_ = rygel_media_objects_new ();
		data->_state_ = 23;
		rygel_media_container_get_children (data->self, (guint) 0, (guint) data->self->child_count, data->cancellable, rygel_media_container_search_ready, data);
		return FALSE;
		_state_23:
		data->children = rygel_media_container_get_children_finish (data->self, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->_result_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
#line 110 "rygel-media-container.vala"
		if (data->offset > 0) {
#line 110 "rygel-media-container.vala"
			data->_tmp0_ = TRUE;
#line 495 "rygel-media-container.c"
		} else {
#line 110 "rygel-media-container.vala"
			data->_tmp0_ = data->max_count > 0;
#line 499 "rygel-media-container.c"
		}
#line 110 "rygel-media-container.vala"
		if (data->_tmp0_) {
#line 111 "rygel-media-container.vala"
			data->limit = data->offset + data->max_count;
#line 505 "rygel-media-container.c"
		} else {
#line 113 "rygel-media-container.vala"
			data->limit = (guint) 0;
#line 509 "rygel-media-container.c"
		}
		{
			data->_child_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) data->children);
#line 117 "rygel-media-container.vala"
			while (TRUE) {
#line 117 "rygel-media-container.vala"
				if (!gee_iterator_next (data->_child_it)) {
#line 117 "rygel-media-container.vala"
					break;
#line 519 "rygel-media-container.c"
				}
				data->child = (RygelMediaObject*) gee_iterator_get (data->_child_it);
#line 118 "rygel-media-container.vala"
				if (data->expression == NULL) {
#line 118 "rygel-media-container.vala"
					data->_tmp1_ = TRUE;
#line 526 "rygel-media-container.c"
				} else {
#line 118 "rygel-media-container.vala"
					data->_tmp1_ = rygel_search_expression_satisfied_by (data->expression, data->child);
#line 530 "rygel-media-container.c"
				}
#line 118 "rygel-media-container.vala"
				if (data->_tmp1_) {
#line 119 "rygel-media-container.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) data->_result_, data->child);
#line 536 "rygel-media-container.c"
				}
#line 122 "rygel-media-container.vala"
				if (data->limit > 0) {
#line 122 "rygel-media-container.vala"
					data->_tmp2_ = gee_collection_get_size ((GeeCollection*) data->_result_) >= data->limit;
#line 542 "rygel-media-container.c"
				} else {
#line 122 "rygel-media-container.vala"
					data->_tmp2_ = FALSE;
#line 546 "rygel-media-container.c"
				}
#line 122 "rygel-media-container.vala"
				if (data->_tmp2_) {
#line 550 "rygel-media-container.c"
					_g_object_unref0 (data->child);
#line 123 "rygel-media-container.vala"
					break;
#line 554 "rygel-media-container.c"
				}
				_g_object_unref0 (data->child);
			}
			_g_object_unref0 (data->_child_it);
		}
#line 127 "rygel-media-container.vala"
		if (data->limit == 0) {
#line 127 "rygel-media-container.vala"
			data->_tmp3_ = TRUE;
#line 564 "rygel-media-container.c"
		} else {
#line 127 "rygel-media-container.vala"
			data->_tmp3_ = gee_collection_get_size ((GeeCollection*) data->_result_) < data->limit;
#line 568 "rygel-media-container.c"
		}
#line 127 "rygel-media-container.vala"
		if (data->_tmp3_) {
#line 129 "rygel-media-container.vala"
			if (data->limit == 0) {
#line 129 "rygel-media-container.vala"
				data->_tmp4_ = (guint) 0;
#line 576 "rygel-media-container.c"
			} else {
#line 129 "rygel-media-container.vala"
				data->_tmp4_ = data->limit - gee_collection_get_size ((GeeCollection*) data->_result_);
#line 580 "rygel-media-container.c"
			}
			data->child_limit = data->_tmp4_;
			data->_state_ = 24;
			rygel_media_container_search_in_children (data->self, data->expression, data->children, data->child_limit, data->cancellable, rygel_media_container_search_ready, data);
			return FALSE;
			_state_24:
			data->child_results = rygel_media_container_search_in_children_finish (data->self, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->children);
				_g_object_unref0 (data->_result_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
#line 135 "rygel-media-container.vala"
			gee_abstract_collection_add_all ((GeeAbstractCollection*) data->_result_, (GeeCollection*) data->child_results);
#line 605 "rygel-media-container.c"
			_g_object_unref0 (data->child_results);
		}
#line 139 "rygel-media-container.vala"
		if (gee_collection_get_size ((GeeCollection*) data->_result_) > 0) {
#line 139 "rygel-media-container.vala"
			data->_tmp5_ = data->limit > 0;
#line 612 "rygel-media-container.c"
		} else {
#line 139 "rygel-media-container.vala"
			data->_tmp5_ = FALSE;
#line 616 "rygel-media-container.c"
		}
#line 139 "rygel-media-container.vala"
		if (data->_tmp5_) {
#line 143 "rygel-media-container.vala"
			data->start = CLAMP (data->offset, (guint) 0, (guint) (gee_collection_get_size ((GeeCollection*) data->_result_) - 1));
#line 145 "rygel-media-container.vala"
			if (data->max_count != 0) {
#line 145 "rygel-media-container.vala"
				data->_tmp6_ = (data->start + data->max_count) <= gee_collection_get_size ((GeeCollection*) data->_result_);
#line 626 "rygel-media-container.c"
			} else {
#line 145 "rygel-media-container.vala"
				data->_tmp6_ = FALSE;
#line 630 "rygel-media-container.c"
			}
#line 145 "rygel-media-container.vala"
			if (data->_tmp6_) {
#line 146 "rygel-media-container.vala"
				data->stop = data->start + data->max_count;
#line 636 "rygel-media-container.c"
			} else {
#line 148 "rygel-media-container.vala"
				data->stop = (guint) gee_collection_get_size ((GeeCollection*) data->_result_);
#line 640 "rygel-media-container.c"
			}
#line 153 "rygel-media-container.vala"
			data->total_matches = (guint) 0;
#line 644 "rygel-media-container.c"
			data->result = (data->_tmp7_ = gee_abstract_list_slice ((GeeAbstractList*) data->_result_, (gint) data->start, (gint) data->stop), RYGEL_IS_MEDIA_OBJECTS (data->_tmp7_) ? ((RygelMediaObjects*) data->_tmp7_) : NULL);
			_g_object_unref0 (data->children);
			_g_object_unref0 (data->_result_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
#line 157 "rygel-media-container.vala"
			data->total_matches = (guint) gee_collection_get_size ((GeeCollection*) data->_result_);
#line 660 "rygel-media-container.c"
			data->result = data->_result_;
			_g_object_unref0 (data->children);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		_g_object_unref0 (data->children);
		_g_object_unref0 (data->_result_);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 95 "rygel-media-container.vala"
void rygel_media_container_search (RygelMediaContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 95 "rygel-media-container.vala"
	RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->search (self, expression, offset, max_count, cancellable, _callback_, _user_data_);
#line 692 "rygel-media-container.c"
}


#line 95 "rygel-media-container.vala"
RygelMediaObjects* rygel_media_container_search_finish (RygelMediaContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
#line 95 "rygel-media-container.vala"
	return RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->search_finish (self, _res_, total_matches, error);
#line 700 "rygel-media-container.c"
}


static void rygel_media_container_real_find_object_data_free (gpointer _data) {
	RygelMediaContainerFindObjectData* data;
	data = _data;
	_g_free0 (data->id);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelMediaContainerFindObjectData, data);
}


static void rygel_media_container_real_find_object (RygelMediaContainer* self, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaContainerFindObjectData* _data_;
	_data_ = g_slice_new0 (RygelMediaContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_container_real_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_container_real_find_object_data_free);
	_data_->self = g_object_ref (self);
	_data_->id = g_strdup (id);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_container_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_media_container_real_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaContainerFindObjectData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_container_real_find_object_co (data);
}


/**
     * Recursively searches for media object with the given id in this
     * container.
     *
     * @param id ID of the media object to search for
     * @param cancellable optional cancellable for this operation
     * @param callback function to call when result is ready
     *
     * return the found media object.
     */
static gboolean rygel_media_container_real_find_object_co (RygelMediaContainerFindObjectData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 25:
		goto _state_25;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->expression = rygel_relational_expression_new ();
#line 177 "rygel-media-container.vala"
		((RygelSearchExpression*) data->expression)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_EQ);
#line 178 "rygel-media-container.vala"
		((RygelSearchExpression*) data->expression)->operand1 = (data->_tmp0_ = g_strdup ("@id"), _g_free0 (((RygelSearchExpression*) data->expression)->operand1), data->_tmp0_);
#line 179 "rygel-media-container.vala"
		((RygelSearchExpression*) data->expression)->operand2 = (data->_tmp1_ = g_strdup (data->id), _g_free0 (((RygelSearchExpression*) data->expression)->operand2), data->_tmp1_);
#line 776 "rygel-media-container.c"
		data->_state_ = 25;
		rygel_media_container_search (data->self, (RygelSearchExpression*) data->expression, (guint) 0, (guint) 1, data->cancellable, rygel_media_container_find_object_ready, data);
		return FALSE;
		_state_25:
		data->results = rygel_media_container_search_finish (data->self, data->_res_, &data->total_matches, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_rygel_search_expression_unref0 (data->expression);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
#line 187 "rygel-media-container.vala"
		if (gee_collection_get_size ((GeeCollection*) data->results) > 0) {
#line 798 "rygel-media-container.c"
			data->result = (RygelMediaObject*) gee_abstract_list_get ((GeeAbstractList*) data->results, 0);
			_g_object_unref0 (data->results);
			_rygel_search_expression_unref0 (data->expression);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			data->result = NULL;
			_g_object_unref0 (data->results);
			_rygel_search_expression_unref0 (data->expression);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		_g_object_unref0 (data->results);
		_rygel_search_expression_unref0 (data->expression);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 173 "rygel-media-container.vala"
void rygel_media_container_find_object (RygelMediaContainer* self, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 173 "rygel-media-container.vala"
	RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->find_object (self, id, cancellable, _callback_, _user_data_);
#line 844 "rygel-media-container.c"
}


#line 173 "rygel-media-container.vala"
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
#line 173 "rygel-media-container.vala"
	return RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->find_object_finish (self, _res_, error);
#line 852 "rygel-media-container.c"
}


static void rygel_media_container_real_add_item_data_free (gpointer _data) {
	RygelMediaContainerAddItemData* data;
	data = _data;
	_g_object_unref0 (data->item);
	_g_object_unref0 (data->cancellable);
	g_object_unref (data->self);
	g_slice_free (RygelMediaContainerAddItemData, data);
}


static void rygel_media_container_real_add_item (RygelMediaContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaContainerAddItemData* _data_;
	_data_ = g_slice_new0 (RygelMediaContainerAddItemData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_container_real_add_item);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_container_real_add_item_data_free);
	_data_->self = g_object_ref (self);
	_data_->item = _g_object_ref0 (item);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_container_real_add_item_co (_data_);
}


static void rygel_media_container_real_add_item_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaContainerAddItemData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_media_container_add_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaContainerAddItemData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_container_real_add_item_co (data);
}


/**
     * Add a new item directly under this container.
     *
     * @param didl_item The item to add to this container.
     *
     * return nothing.
     *
     * This implementation is very basic: It only creates the file under the
     * first writable URI it can find for this container & sets the ID of the
     * item to that of the URI of the newly created item. If your subclass
     * doesn't ID the items by their original URIs, you definitely want to
     * override this method.
     */
static gboolean rygel_media_container_real_add_item_co (RygelMediaContainerAddItemData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 26:
		goto _state_26;
		case 27:
		goto _state_27;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_state_ = 26;
		rygel_media_object_get_writable ((RygelMediaObject*) data->self, data->cancellable, rygel_media_container_add_item_ready, data);
		return FALSE;
		_state_26:
		data->dir = rygel_media_object_get_writable_finish ((RygelMediaObject*) data->self, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
#line 211 "rygel-media-container.vala"
		if (data->dir == NULL) {
#line 941 "rygel-media-container.c"
			data->_inner_error_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _ ("Object creation in %s not allowed"), ((RygelMediaObject*) data->self)->id);
			{
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->dir);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
		}
		data->file = g_file_get_child_for_display_name (data->dir, rygel_media_object_get_title ((RygelMediaObject*) data->item), &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->dir);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->_state_ = 27;
		g_file_create_async (data->file, G_FILE_CREATE_NONE, G_PRIORITY_DEFAULT, data->cancellable, rygel_media_container_add_item_ready, data);
		return FALSE;
		_state_27:
#line 218 "rygel-media-container.vala"
		data->_tmp0_ = g_file_create_finish (data->file, data->_res_, &data->_inner_error_);
#line 979 "rygel-media-container.c"
		_g_object_unref0 (data->_tmp0_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->file);
			_g_object_unref0 (data->dir);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->uri = g_file_get_uri (data->file);
#line 222 "rygel-media-container.vala"
		((RygelMediaObject*) data->item)->id = (data->_tmp1_ = g_strdup (data->uri), _g_free0 (((RygelMediaObject*) data->item)->id), data->_tmp1_);
#line 223 "rygel-media-container.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) ((RygelMediaObject*) data->item)->uris, data->uri);
#line 1001 "rygel-media-container.c"
		_g_free0 (data->uri);
		_g_object_unref0 (data->file);
		_g_object_unref0 (data->dir);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 207 "rygel-media-container.vala"
void rygel_media_container_add_item (RygelMediaContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 207 "rygel-media-container.vala"
	RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->add_item (self, item, cancellable, _callback_, _user_data_);
#line 1022 "rygel-media-container.c"
}


#line 207 "rygel-media-container.vala"
void rygel_media_container_add_item_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
#line 207 "rygel-media-container.vala"
	RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->add_item_finish (self, _res_, error);
#line 1030 "rygel-media-container.c"
}


/**
     * Method to be be called each time this container is updated (metadata
     * changes for this container, items under it gets removed/added or their
     * metadata changes etc).
     *
     * @param container the container that just got updated.
     */
#line 233 "rygel-media-container.vala"
void rygel_media_container_updated (RygelMediaContainer* self) {
#line 233 "rygel-media-container.vala"
	g_return_if_fail (self != NULL);
#line 234 "rygel-media-container.vala"
	self->update_id++;
#line 237 "rygel-media-container.vala"
	g_signal_emit_by_name (self, "container-updated", self);
#line 1049 "rygel-media-container.c"
}


/**
     * Sets the URI of this container and optionally the create_classes.
     *
     * @param uri the URI to set.
     * @param create_classes list of item classes.
     */
#line 246 "rygel-media-container.vala"
void rygel_media_container_set_uri (RygelMediaContainer* self, const char* uri, GeeArrayList* create_classes) {
#line 246 "rygel-media-container.vala"
	g_return_if_fail (self != NULL);
#line 246 "rygel-media-container.vala"
	g_return_if_fail (uri != NULL);
#line 247 "rygel-media-container.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) ((RygelMediaObject*) self)->uris);
#line 248 "rygel-media-container.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) ((RygelMediaObject*) self)->uris, uri);
#line 250 "rygel-media-container.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) self->create_classes);
#line 252 "rygel-media-container.vala"
	if (create_classes != NULL) {
#line 253 "rygel-media-container.vala"
		gee_abstract_collection_add_all ((GeeAbstractCollection*) self->create_classes, (GeeCollection*) create_classes);
#line 1075 "rygel-media-container.c"
	} else {
#line 255 "rygel-media-container.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) self->create_classes, RYGEL_MEDIA_ITEM_IMAGE_CLASS);
#line 256 "rygel-media-container.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) self->create_classes, RYGEL_MEDIA_ITEM_VIDEO_CLASS);
#line 257 "rygel-media-container.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) self->create_classes, RYGEL_MEDIA_ITEM_AUDIO_CLASS);
#line 1083 "rygel-media-container.c"
	}
}


static void rygel_media_container_search_in_children_data_free (gpointer _data) {
	RygelMediaContainerSearchInChildrenData* data;
	data = _data;
	_rygel_search_expression_unref0 (data->expression);
	_g_object_unref0 (data->children);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelMediaContainerSearchInChildrenData, data);
}


static void rygel_media_container_search_in_children (RygelMediaContainer* self, RygelSearchExpression* expression, RygelMediaObjects* children, guint limit, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaContainerSearchInChildrenData* _data_;
	_data_ = g_slice_new0 (RygelMediaContainerSearchInChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_container_search_in_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_container_search_in_children_data_free);
	_data_->self = g_object_ref (self);
	_data_->expression = _rygel_search_expression_ref0 (expression);
	_data_->children = _g_object_ref0 (children);
	_data_->limit = limit;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_container_search_in_children_co (_data_);
}


static RygelMediaObjects* rygel_media_container_search_in_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelMediaContainerSearchInChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_container_search_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaContainerSearchInChildrenData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_container_search_in_children_co (data);
}


static gboolean rygel_media_container_search_in_children_co (RygelMediaContainerSearchInChildrenData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 28:
		goto _state_28;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_result_ = rygel_media_objects_new ();
		{
			data->_child_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) data->children);
#line 268 "rygel-media-container.vala"
			while (TRUE) {
#line 268 "rygel-media-container.vala"
				if (!gee_iterator_next (data->_child_it)) {
#line 268 "rygel-media-container.vala"
					break;
#line 1155 "rygel-media-container.c"
				}
				data->child = (RygelMediaObject*) gee_iterator_get (data->_child_it);
#line 269 "rygel-media-container.vala"
				if (RYGEL_IS_MEDIA_CONTAINER (data->child)) {
#line 1160 "rygel-media-container.c"
					data->container = _g_object_ref0 ((data->_tmp0_ = data->child, RYGEL_IS_MEDIA_CONTAINER (data->_tmp0_) ? ((RygelMediaContainer*) data->_tmp0_) : NULL));
					data->_state_ = 28;
					rygel_media_container_search (data->container, data->expression, (guint) 0, data->limit, data->cancellable, rygel_media_container_search_in_children_ready, data);
					return FALSE;
					_state_28:
					data->child_result = rygel_media_container_search_finish (data->container, data->_res_, &data->tmp, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
						g_error_free (data->_inner_error_);
						_g_object_unref0 (data->container);
						_g_object_unref0 (data->child);
						_g_object_unref0 (data->_child_it);
						_g_object_unref0 (data->_result_);
						{
							if (data->_state_ == 0) {
								g_simple_async_result_complete_in_idle (data->_async_result);
							} else {
								g_simple_async_result_complete (data->_async_result);
							}
							g_object_unref (data->_async_result);
							return FALSE;
						}
					}
#line 279 "rygel-media-container.vala"
					gee_abstract_collection_add_all ((GeeAbstractCollection*) data->_result_, (GeeCollection*) data->child_result);
#line 1186 "rygel-media-container.c"
					_g_object_unref0 (data->child_result);
					_g_object_unref0 (data->container);
				}
#line 282 "rygel-media-container.vala"
				if (data->limit > 0) {
#line 282 "rygel-media-container.vala"
					data->_tmp1_ = gee_collection_get_size ((GeeCollection*) data->_result_) >= data->limit;
#line 1194 "rygel-media-container.c"
				} else {
#line 282 "rygel-media-container.vala"
					data->_tmp1_ = FALSE;
#line 1198 "rygel-media-container.c"
				}
#line 282 "rygel-media-container.vala"
				if (data->_tmp1_) {
#line 1202 "rygel-media-container.c"
					_g_object_unref0 (data->child);
#line 283 "rygel-media-container.vala"
					break;
#line 1206 "rygel-media-container.c"
				}
				_g_object_unref0 (data->child);
			}
			_g_object_unref0 (data->_child_it);
		}
		data->result = data->_result_;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_object_unref0 (data->_result_);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


/**
     * handler for container_updated signal on this container. We only forward
     * it to the parent, hoping someone will get it from the root container
     * and act upon it.
     *
     * @param container the container that emitted the signal
     * @param updated_container the container that just got updated
     */
#line 298 "rygel-media-container.vala"
static void rygel_media_container_on_container_updated (RygelMediaContainer* self, RygelMediaContainer* container, RygelMediaContainer* updated_container) {
#line 298 "rygel-media-container.vala"
	g_return_if_fail (self != NULL);
#line 298 "rygel-media-container.vala"
	g_return_if_fail (container != NULL);
#line 298 "rygel-media-container.vala"
	g_return_if_fail (updated_container != NULL);
#line 300 "rygel-media-container.vala"
	if (((RygelMediaObject*) self)->parent != NULL) {
#line 301 "rygel-media-container.vala"
		g_signal_emit_by_name (((RygelMediaObject*) self)->parent, "container-updated", updated_container);
#line 1256 "rygel-media-container.c"
	}
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search = rygel_media_container_real_search;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search_finish = rygel_media_container_real_search_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_media_container_real_find_object;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_media_container_real_find_object_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->add_item = rygel_media_container_real_add_item;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->add_item_finish = rygel_media_container_real_add_item_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_container_finalize;
	/**
	     * container_updated signal that is emitted if a child container under the
	     * tree of this container gets updated.
	     *
	     * @param container the container that just got updated.
	     */
	g_signal_new ("container_updated", RYGEL_TYPE_MEDIA_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_MEDIA_CONTAINER);
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
}


static void rygel_media_container_finalize (GObject* obj) {
	RygelMediaContainer * self;
	self = RYGEL_MEDIA_CONTAINER (obj);
	_g_object_unref0 (self->create_classes);
	G_OBJECT_CLASS (rygel_media_container_parent_class)->finalize (obj);
}


/**
 * Represents a container (folder) for media items and containers. Provides
 * basic serialization (to DIDLLiteWriter) implementation. Deriving classes
 * are supposed to provide working implementations of get_children.
 */
GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}




