/* rygel-media-item.c generated by valac 0.9.5, the Vala compiler
 * generated from rygel-media-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gst/gst.h>
#include <libgupnp-av/gupnp-av.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define RYGEL_TYPE_THUMBNAILER (rygel_thumbnailer_get_type ())
#define RYGEL_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailer))
#define RYGEL_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))
#define RYGEL_IS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_IS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))

typedef struct _RygelThumbnailer RygelThumbnailer;
typedef struct _RygelThumbnailerClass RygelThumbnailerClass;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_SUBTITLE_MANAGER (rygel_subtitle_manager_get_type ())
#define RYGEL_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManager))
#define RYGEL_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))
#define RYGEL_IS_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_IS_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_SUBTITLE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))

typedef struct _RygelSubtitleManager RygelSubtitleManager;
typedef struct _RygelSubtitleManagerClass RygelSubtitleManagerClass;
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_ART_STORE (rygel_media_art_store_get_type ())
#define RYGEL_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStore))
#define RYGEL_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))
#define RYGEL_IS_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_IS_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_MEDIA_ART_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))

typedef struct _RygelMediaArtStore RygelMediaArtStore;
typedef struct _RygelMediaArtStoreClass RygelMediaArtStoreClass;

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;

typedef enum  {
	RYGEL_MEDIA_ITEM_ERROR_BAD_URI
} RygelMediaItemError;
#define RYGEL_MEDIA_ITEM_ERROR rygel_media_item_error_quark ()
struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* author;
	char* album;
	char* date;
	char* genre;
	char* mime_type;
	char* dlna_profile;
	gint64 size;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint n_audio_channels;
	gint track_number;
	gint width;
	gint height;
	gint pixel_width;
	gint pixel_height;
	gint color_depth;
	GeeArrayList* thumbnails;
	GeeArrayList* subtitles;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*should_stream) (RygelMediaItem* self);
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	char* uri;
	char* mime_type;
	char* caption_type;
	gint64 size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	char* mime_type;
	char* uri;
	char* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};


static gpointer rygel_media_item_parent_class = NULL;

GQuark rygel_media_item_error_quark (void);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_ITEM_IMAGE_CLASS "object.item.imageItem"
#define RYGEL_MEDIA_ITEM_PHOTO_CLASS "object.item.imageItem.photo"
#define RYGEL_MEDIA_ITEM_VIDEO_CLASS "object.item.videoItem"
#define RYGEL_MEDIA_ITEM_AUDIO_CLASS "object.item.audioItem"
#define RYGEL_MEDIA_ITEM_MUSIC_CLASS "object.item.audioItem.musicTrack"
RygelMediaObject* rygel_media_object_construct (GType object_type);
void rygel_media_object_set_title (RygelMediaObject* self, const char* value);
RygelMediaItem* rygel_media_item_new (const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
RygelMediaItem* rygel_media_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
static inline void _dynamic_set_blocksize1 (GstElement* obj, glong value);
static inline void _dynamic_set_tcp_timeout2 (GstElement* obj, gint64 value);
GstElement* rygel_media_item_create_stream_source (RygelMediaItem* self);
static GstElement* rygel_media_item_real_create_stream_source (RygelMediaItem* self);
gboolean rygel_media_item_should_stream (RygelMediaItem* self);
static gboolean rygel_media_item_real_should_stream (RygelMediaItem* self);
GType rygel_thumbnailer_get_type (void) G_GNUC_CONST;
RygelThumbnailer* rygel_thumbnailer_get_default (void);
RygelThumbnail* rygel_thumbnailer_get_thumbnail (RygelThumbnailer* self, const char* uri, GError** error);
GType rygel_subtitle_manager_get_type (void) G_GNUC_CONST;
RygelSubtitleManager* rygel_subtitle_manager_get_default (void);
RygelSubtitle* rygel_subtitle_manager_get_subtitle (RygelSubtitleManager* self, const char* uri, GError** error);
void rygel_media_item_add_uri (RygelMediaItem* self, const char* uri, RygelThumbnail* thumbnail);
GType rygel_media_art_store_get_type (void) G_GNUC_CONST;
RygelMediaArtStore* rygel_media_art_store_get_default (void);
RygelThumbnail* rygel_media_art_store_find_media_art_any (RygelMediaArtStore* self, RygelMediaItem* item, GError** error);
void rygel_media_item_lookup_album_art (RygelMediaItem* self);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
guint rygel_transcoder_get_distance (RygelTranscoder* self, RygelMediaItem* item);
gint rygel_media_item_compare_transcoders (RygelMediaItem* self, void* a, void* b);
static char* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const char* uri, GError** error);
void rygel_subtitle_add_didl_node (RygelSubtitle* self, GUPnPDIDLLiteItem* didl_item);
GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error);
GUPnPDIDLLiteResource* rygel_thumbnail_add_resource (RygelThumbnail* self, GUPnPDIDLLiteItem* didl_item, const char* protocol);
void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
static GUPnPProtocolInfo* rygel_media_item_get_protocol_info (RygelMediaItem* self, const char* uri, const char* protocol);
gint rygel_media_object_compare_string_props (RygelMediaObject* self, const char* prop1, const char* prop2);
static gint rygel_media_item_compare_by_date (RygelMediaItem* self, RygelMediaItem* item);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
static gint rygel_media_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const char* property);
static gint rygel_media_item_compare_long (RygelMediaItem* self, glong a, glong b);
static void rygel_media_item_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark rygel_media_item_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_item_error-quark");
}


#line 72 "rygel-media-item.vala"
RygelMediaItem* rygel_media_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class) {
#line 308 "rygel-media-item.c"
	RygelMediaItem * self;
	char* _tmp0_;
	char* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
#line 72 "rygel-media-item.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 72 "rygel-media-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 72 "rygel-media-item.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 72 "rygel-media-item.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 72 "rygel-media-item.vala"
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
#line 76 "rygel-media-item.vala"
	((RygelMediaObject*) self)->id = (_tmp0_ = g_strdup (id), _g_free0 (((RygelMediaObject*) self)->id), _tmp0_);
#line 77 "rygel-media-item.vala"
	((RygelMediaObject*) self)->parent = parent;
#line 78 "rygel-media-item.vala"
	rygel_media_object_set_title ((RygelMediaObject*) self, title);
#line 79 "rygel-media-item.vala"
	((RygelMediaObject*) self)->upnp_class = (_tmp1_ = g_strdup (upnp_class), _g_free0 (((RygelMediaObject*) self)->upnp_class), _tmp1_);
#line 81 "rygel-media-item.vala"
	self->thumbnails = (_tmp2_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_icon_info_ref, rygel_icon_info_unref, NULL), _g_object_unref0 (self->thumbnails), _tmp2_);
#line 82 "rygel-media-item.vala"
	self->subtitles = (_tmp3_ = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) rygel_subtitle_ref, rygel_subtitle_unref, NULL), _g_object_unref0 (self->subtitles), _tmp3_);
#line 336 "rygel-media-item.c"
	return self;
}


#line 72 "rygel-media-item.vala"
RygelMediaItem* rygel_media_item_new (const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class) {
#line 72 "rygel-media-item.vala"
	return rygel_media_item_construct (RYGEL_TYPE_MEDIA_ITEM, id, parent, title, upnp_class);
#line 345 "rygel-media-item.c"
}


static inline void _dynamic_set_blocksize1 (GstElement* obj, glong value) {
	g_object_set (obj, "blocksize", value, NULL);
}


static inline void _dynamic_set_tcp_timeout2 (GstElement* obj, gint64 value) {
	g_object_set (obj, "tcp-timeout", value, NULL);
}


#line 87 "rygel-media-item.vala"
static GstElement* rygel_media_item_real_create_stream_source (RygelMediaItem* self) {
#line 361 "rygel-media-item.c"
	GstElement* result = NULL;
	GstElement* src;
#line 87 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 88 "rygel-media-item.vala"
	src = NULL;
#line 90 "rygel-media-item.vala"
	if (gee_collection_get_size ((GeeCollection*) ((RygelMediaObject*) self)->uris) != 0) {
#line 370 "rygel-media-item.c"
		GstElement* _tmp1_;
		char* _tmp0_;
#line 91 "rygel-media-item.vala"
		src = (_tmp1_ = gst_element_make_from_uri (GST_URI_SRC, _tmp0_ = (char*) gee_abstract_list_get ((GeeAbstractList*) ((RygelMediaObject*) self)->uris, 0), NULL), _gst_object_unref0 (src), _tmp1_);
#line 375 "rygel-media-item.c"
		_g_free0 (_tmp0_);
	}
#line 94 "rygel-media-item.vala"
	if (src != NULL) {
#line 95 "rygel-media-item.vala"
		if (g_object_class_find_property (G_OBJECT_GET_CLASS ((GObject*) src), "blocksize") != NULL) {
#line 98 "rygel-media-item.vala"
			_dynamic_set_blocksize1 (src, (glong) 65536);
#line 384 "rygel-media-item.c"
		}
#line 101 "rygel-media-item.vala"
		if (g_object_class_find_property (G_OBJECT_GET_CLASS ((GObject*) src), "tcp-timeout") != NULL) {
#line 104 "rygel-media-item.vala"
			_dynamic_set_tcp_timeout2 (src, (gint64) 60000000);
#line 390 "rygel-media-item.c"
		}
	}
	result = src;
#line 108 "rygel-media-item.vala"
	return result;
#line 396 "rygel-media-item.c"
}


#line 87 "rygel-media-item.vala"
GstElement* rygel_media_item_create_stream_source (RygelMediaItem* self) {
#line 87 "rygel-media-item.vala"
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->create_stream_source (self);
#line 404 "rygel-media-item.c"
}


#line 114 "rygel-media-item.vala"
static gboolean rygel_media_item_real_should_stream (RygelMediaItem* self) {
#line 410 "rygel-media-item.c"
	gboolean result = FALSE;
#line 114 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 414 "rygel-media-item.c"
	result = self->size <= 0;
#line 116 "rygel-media-item.vala"
	return result;
#line 418 "rygel-media-item.c"
}


#line 114 "rygel-media-item.vala"
gboolean rygel_media_item_should_stream (RygelMediaItem* self) {
#line 114 "rygel-media-item.vala"
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->should_stream (self);
#line 426 "rygel-media-item.c"
}


#line 121 "rygel-media-item.vala"
void rygel_media_item_add_uri (RygelMediaItem* self, const char* uri, RygelThumbnail* thumbnail) {
#line 432 "rygel-media-item.c"
	GError * _inner_error_;
#line 121 "rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 121 "rygel-media-item.vala"
	g_return_if_fail (uri != NULL);
#line 438 "rygel-media-item.c"
	_inner_error_ = NULL;
#line 122 "rygel-media-item.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) ((RygelMediaObject*) self)->uris, uri);
#line 124 "rygel-media-item.vala"
	if (thumbnail != NULL) {
#line 125 "rygel-media-item.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) self->thumbnails, thumbnail);
#line 446 "rygel-media-item.c"
	} else {
		gboolean _tmp0_ = FALSE;
#line 126 "rygel-media-item.vala"
		if (g_str_has_prefix (((RygelMediaObject*) self)->upnp_class, RYGEL_MEDIA_ITEM_IMAGE_CLASS)) {
#line 126 "rygel-media-item.vala"
			_tmp0_ = TRUE;
#line 453 "rygel-media-item.c"
		} else {
#line 127 "rygel-media-item.vala"
			_tmp0_ = g_str_has_prefix (((RygelMediaObject*) self)->upnp_class, RYGEL_MEDIA_ITEM_VIDEO_CLASS);
#line 457 "rygel-media-item.c"
		}
#line 126 "rygel-media-item.vala"
		if (_tmp0_) {
#line 461 "rygel-media-item.c"
			RygelThumbnailer* thumbnailer;
#line 129 "rygel-media-item.vala"
			thumbnailer = rygel_thumbnailer_get_default ();
#line 131 "rygel-media-item.vala"
			if (thumbnailer == NULL) {
#line 467 "rygel-media-item.c"
				_g_object_unref0 (thumbnailer);
#line 132 "rygel-media-item.vala"
				return;
#line 471 "rygel-media-item.c"
			}
			{
				RygelThumbnail* thumb;
#line 136 "rygel-media-item.vala"
				thumb = rygel_thumbnailer_get_thumbnail (thumbnailer, uri, &_inner_error_);
#line 477 "rygel-media-item.c"
				if (_inner_error_ != NULL) {
					goto __catch40_g_error;
				}
#line 137 "rygel-media-item.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) self->thumbnails, thumb);
#line 483 "rygel-media-item.c"
				_rygel_icon_info_unref0 (thumb);
			}
			goto __finally40;
			__catch40_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally40:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (thumbnailer);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_object_unref0 (thumbnailer);
		}
	}
#line 141 "rygel-media-item.vala"
	if (g_str_has_prefix (((RygelMediaObject*) self)->upnp_class, RYGEL_MEDIA_ITEM_VIDEO_CLASS)) {
#line 508 "rygel-media-item.c"
		RygelSubtitleManager* subtitle_manager;
#line 142 "rygel-media-item.vala"
		subtitle_manager = rygel_subtitle_manager_get_default ();
#line 144 "rygel-media-item.vala"
		if (subtitle_manager == NULL) {
#line 514 "rygel-media-item.c"
			_g_object_unref0 (subtitle_manager);
#line 145 "rygel-media-item.vala"
			return;
#line 518 "rygel-media-item.c"
		}
		{
			RygelSubtitle* subtitle;
#line 149 "rygel-media-item.vala"
			subtitle = rygel_subtitle_manager_get_subtitle (subtitle_manager, uri, &_inner_error_);
#line 524 "rygel-media-item.c"
			if (_inner_error_ != NULL) {
				goto __catch41_g_error;
			}
#line 150 "rygel-media-item.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) self->subtitles, subtitle);
#line 530 "rygel-media-item.c"
			_rygel_subtitle_unref0 (subtitle);
		}
		goto __finally41;
		__catch41_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				_g_error_free0 (err);
			}
		}
		__finally41:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (subtitle_manager);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (subtitle_manager);
	}
}


#line 155 "rygel-media-item.vala"
void rygel_media_item_lookup_album_art (RygelMediaItem* self) {
#line 557 "rygel-media-item.c"
	GError * _inner_error_;
	gboolean _tmp0_ = FALSE;
	RygelMediaArtStore* media_art_store;
#line 155 "rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 563 "rygel-media-item.c"
	_inner_error_ = NULL;
#line 156 "rygel-media-item.vala"
	if (g_str_has_prefix (((RygelMediaObject*) self)->upnp_class, RYGEL_MEDIA_ITEM_AUDIO_CLASS)) {
#line 157 "rygel-media-item.vala"
		_tmp0_ = gee_collection_get_size ((GeeCollection*) self->thumbnails) == 0;
#line 569 "rygel-media-item.c"
	} else {
#line 156 "rygel-media-item.vala"
		_tmp0_ = FALSE;
#line 573 "rygel-media-item.c"
	}
#line 156 "rygel-media-item.vala"
	g_assert (_tmp0_);
#line 159 "rygel-media-item.vala"
	media_art_store = rygel_media_art_store_get_default ();
#line 160 "rygel-media-item.vala"
	if (media_art_store == NULL) {
#line 581 "rygel-media-item.c"
		_g_object_unref0 (media_art_store);
#line 161 "rygel-media-item.vala"
		return;
#line 585 "rygel-media-item.c"
	}
	{
		RygelThumbnail* thumb;
#line 165 "rygel-media-item.vala"
		thumb = rygel_media_art_store_find_media_art_any (media_art_store, self, &_inner_error_);
#line 591 "rygel-media-item.c"
		if (_inner_error_ != NULL) {
			goto __catch42_g_error;
		}
#line 166 "rygel-media-item.vala"
		if (thumb != NULL) {
#line 167 "rygel-media-item.vala"
			gee_abstract_list_insert ((GeeAbstractList*) self->thumbnails, 0, thumb);
#line 599 "rygel-media-item.c"
		}
		_rygel_icon_info_unref0 (thumb);
	}
	goto __finally42;
	__catch42_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (err);
		}
	}
	__finally42:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (media_art_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	;
	_g_object_unref0 (media_art_store);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 172 "rygel-media-item.vala"
gint rygel_media_item_compare_transcoders (RygelMediaItem* self, void* a, void* b) {
#line 632 "rygel-media-item.c"
	gint result = 0;
	RygelTranscoder* transcoder1;
	RygelTranscoder* transcoder2;
#line 172 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 173 "rygel-media-item.vala"
	transcoder1 = _g_object_ref0 (RYGEL_TRANSCODER (a));
#line 174 "rygel-media-item.vala"
	transcoder2 = _g_object_ref0 (RYGEL_TRANSCODER (b));
#line 642 "rygel-media-item.c"
	result = ((gint) rygel_transcoder_get_distance (transcoder1, self)) - ((gint) rygel_transcoder_get_distance (transcoder2, self));
	_g_object_unref0 (transcoder2);
	_g_object_unref0 (transcoder1);
#line 176 "rygel-media-item.vala"
	return result;
#line 648 "rygel-media-item.c"
}


#line 180 "rygel-media-item.vala"
void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
#line 654 "rygel-media-item.c"
	GError * _inner_error_;
#line 180 "rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 180 "rygel-media-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 660 "rygel-media-item.c"
	_inner_error_ = NULL;
	{
		GeeIterator* _subtitle_it;
#line 183 "rygel-media-item.vala"
		_subtitle_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->subtitles);
#line 183 "rygel-media-item.vala"
		while (TRUE) {
#line 668 "rygel-media-item.c"
			RygelSubtitle* subtitle;
			char* protocol;
			gboolean _tmp0_ = FALSE;
#line 183 "rygel-media-item.vala"
			if (!gee_iterator_next (_subtitle_it)) {
#line 183 "rygel-media-item.vala"
				break;
#line 676 "rygel-media-item.c"
			}
#line 183 "rygel-media-item.vala"
			subtitle = (RygelSubtitle*) gee_iterator_get (_subtitle_it);
#line 184 "rygel-media-item.vala"
			protocol = rygel_media_item_get_protocol_for_uri (self, subtitle->uri, &_inner_error_);
#line 682 "rygel-media-item.c"
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_rygel_subtitle_unref0 (subtitle);
				_g_object_unref0 (_subtitle_it);
				return;
			}
#line 186 "rygel-media-item.vala"
			if (allow_internal) {
#line 186 "rygel-media-item.vala"
				_tmp0_ = TRUE;
#line 693 "rygel-media-item.c"
			} else {
#line 186 "rygel-media-item.vala"
				_tmp0_ = _vala_strcmp0 (protocol, "internal") != 0;
#line 697 "rygel-media-item.c"
			}
#line 186 "rygel-media-item.vala"
			if (_tmp0_) {
#line 187 "rygel-media-item.vala"
				rygel_subtitle_add_didl_node (subtitle, didl_item);
#line 703 "rygel-media-item.c"
			}
			_g_free0 (protocol);
			_rygel_subtitle_unref0 (subtitle);
		}
		_g_object_unref0 (_subtitle_it);
	}
	{
		GeeIterator* _uri_it;
#line 191 "rygel-media-item.vala"
		_uri_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) ((RygelMediaObject*) self)->uris);
#line 191 "rygel-media-item.vala"
		while (TRUE) {
#line 716 "rygel-media-item.c"
			char* uri;
			char* protocol;
			gboolean _tmp1_ = FALSE;
#line 191 "rygel-media-item.vala"
			if (!gee_iterator_next (_uri_it)) {
#line 191 "rygel-media-item.vala"
				break;
#line 724 "rygel-media-item.c"
			}
#line 191 "rygel-media-item.vala"
			uri = (char*) gee_iterator_get (_uri_it);
#line 192 "rygel-media-item.vala"
			protocol = rygel_media_item_get_protocol_for_uri (self, uri, &_inner_error_);
#line 730 "rygel-media-item.c"
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (uri);
				_g_object_unref0 (_uri_it);
				return;
			}
#line 194 "rygel-media-item.vala"
			if (allow_internal) {
#line 194 "rygel-media-item.vala"
				_tmp1_ = TRUE;
#line 741 "rygel-media-item.c"
			} else {
#line 194 "rygel-media-item.vala"
				_tmp1_ = _vala_strcmp0 (protocol, "internal") != 0;
#line 745 "rygel-media-item.c"
			}
#line 194 "rygel-media-item.vala"
			if (_tmp1_) {
#line 749 "rygel-media-item.c"
				GUPnPDIDLLiteResource* _tmp2_;
#line 195 "rygel-media-item.vala"
				_tmp2_ = rygel_media_item_add_resource (self, didl_item, uri, protocol, NULL, &_inner_error_);
#line 753 "rygel-media-item.c"
				_g_object_unref0 (_tmp2_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (protocol);
					_g_free0 (uri);
					_g_object_unref0 (_uri_it);
					return;
				}
			}
			_g_free0 (protocol);
			_g_free0 (uri);
		}
		_g_object_unref0 (_uri_it);
	}
	{
		GeeIterator* _thumbnail_it;
#line 199 "rygel-media-item.vala"
		_thumbnail_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->thumbnails);
#line 199 "rygel-media-item.vala"
		while (TRUE) {
#line 774 "rygel-media-item.c"
			RygelThumbnail* thumbnail;
			char* protocol;
			gboolean _tmp3_ = FALSE;
#line 199 "rygel-media-item.vala"
			if (!gee_iterator_next (_thumbnail_it)) {
#line 199 "rygel-media-item.vala"
				break;
#line 782 "rygel-media-item.c"
			}
#line 199 "rygel-media-item.vala"
			thumbnail = (RygelThumbnail*) gee_iterator_get (_thumbnail_it);
#line 200 "rygel-media-item.vala"
			protocol = rygel_media_item_get_protocol_for_uri (self, ((RygelIconInfo*) thumbnail)->uri, &_inner_error_);
#line 788 "rygel-media-item.c"
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_rygel_icon_info_unref0 (thumbnail);
				_g_object_unref0 (_thumbnail_it);
				return;
			}
#line 202 "rygel-media-item.vala"
			if (allow_internal) {
#line 202 "rygel-media-item.vala"
				_tmp3_ = TRUE;
#line 799 "rygel-media-item.c"
			} else {
#line 202 "rygel-media-item.vala"
				_tmp3_ = _vala_strcmp0 (protocol, "internal") != 0;
#line 803 "rygel-media-item.c"
			}
#line 202 "rygel-media-item.vala"
			if (_tmp3_) {
#line 807 "rygel-media-item.c"
				GUPnPDIDLLiteResource* _tmp4_;
#line 203 "rygel-media-item.vala"
				_tmp4_ = rygel_thumbnail_add_resource (thumbnail, didl_item, protocol);
#line 811 "rygel-media-item.c"
				_g_object_unref0 (_tmp4_);
			}
			_g_free0 (protocol);
			_rygel_icon_info_unref0 (thumbnail);
		}
		_g_object_unref0 (_thumbnail_it);
	}
}


#line 208 "rygel-media-item.vala"
GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error) {
#line 824 "rygel-media-item.c"
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteResource* res;
	GUPnPProtocolInfo* _tmp0_;
#line 208 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 208 "rygel-media-item.vala"
	g_return_val_if_fail (didl_item != NULL, NULL);
#line 208 "rygel-media-item.vala"
	g_return_val_if_fail (protocol != NULL, NULL);
#line 213 "rygel-media-item.vala"
	res = gupnp_didl_lite_object_add_resource ((GUPnPDIDLLiteObject*) didl_item);
#line 215 "rygel-media-item.vala"
	if (uri != NULL) {
#line 216 "rygel-media-item.vala"
		gupnp_didl_lite_resource_set_uri (res, uri);
#line 840 "rygel-media-item.c"
	}
#line 219 "rygel-media-item.vala"
	if (import_uri != NULL) {
#line 220 "rygel-media-item.vala"
		gupnp_didl_lite_resource_set_import_uri (res, import_uri);
#line 846 "rygel-media-item.c"
	}
#line 223 "rygel-media-item.vala"
	gupnp_didl_lite_resource_set_size64 (res, self->size);
#line 224 "rygel-media-item.vala"
	gupnp_didl_lite_resource_set_duration (res, self->duration);
#line 225 "rygel-media-item.vala"
	gupnp_didl_lite_resource_set_bitrate (res, self->bitrate);
#line 227 "rygel-media-item.vala"
	gupnp_didl_lite_resource_set_sample_freq (res, self->sample_freq);
#line 228 "rygel-media-item.vala"
	gupnp_didl_lite_resource_set_bits_per_sample (res, self->bits_per_sample);
#line 229 "rygel-media-item.vala"
	gupnp_didl_lite_resource_set_audio_channels (res, self->n_audio_channels);
#line 231 "rygel-media-item.vala"
	gupnp_didl_lite_resource_set_width (res, self->width);
#line 232 "rygel-media-item.vala"
	gupnp_didl_lite_resource_set_height (res, self->height);
#line 233 "rygel-media-item.vala"
	gupnp_didl_lite_resource_set_color_depth (res, self->color_depth);
#line 236 "rygel-media-item.vala"
	gupnp_didl_lite_resource_set_protocol_info (res, _tmp0_ = rygel_media_item_get_protocol_info (self, uri, protocol));
#line 868 "rygel-media-item.c"
	_g_object_unref0 (_tmp0_);
	result = res;
#line 238 "rygel-media-item.vala"
	return result;
#line 873 "rygel-media-item.c"
}


#line 241 "rygel-media-item.vala"
static gint rygel_media_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const char* property) {
#line 879 "rygel-media-item.c"
	RygelMediaItem * self;
	gint result = 0;
	RygelMediaObject* _tmp0_;
	RygelMediaItem* item;
	GQuark _tmp2_;
	const char* _tmp1_;
	static GQuark _tmp2__label0 = 0;
	static GQuark _tmp2__label1 = 0;
	static GQuark _tmp2__label2 = 0;
	static GQuark _tmp2__label3 = 0;
	static GQuark _tmp2__label4 = 0;
	self = (RygelMediaItem*) base;
#line 241 "rygel-media-item.vala"
	g_return_val_if_fail (media_object != NULL, 0);
#line 241 "rygel-media-item.vala"
	g_return_val_if_fail (property != NULL, 0);
#line 243 "rygel-media-item.vala"
	item = _g_object_ref0 ((_tmp0_ = media_object, RYGEL_IS_MEDIA_ITEM (_tmp0_) ? ((RygelMediaItem*) _tmp0_) : NULL));
#line 898 "rygel-media-item.c"
	_tmp1_ = property;
	_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (((_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string ("dc:creator")))) || (_tmp2_ == ((0 != _tmp2__label1) ? _tmp2__label1 : (_tmp2__label1 = g_quark_from_static_string ("dc:artist"))))) || (_tmp2_ == ((0 != _tmp2__label2) ? _tmp2__label2 : (_tmp2__label2 = g_quark_from_static_string ("dc:author")))))
	switch (0) {
		default:
		{
			result = rygel_media_object_compare_string_props ((RygelMediaObject*) self, self->author, item->author);
			_g_object_unref0 (item);
#line 249 "rygel-media-item.vala"
			return result;
#line 909 "rygel-media-item.c"
		}
	} else if (_tmp2_ == ((0 != _tmp2__label3) ? _tmp2__label3 : (_tmp2__label3 = g_quark_from_static_string ("upnp:album"))))
	switch (0) {
		default:
		{
			result = rygel_media_object_compare_string_props ((RygelMediaObject*) self, self->album, item->album);
			_g_object_unref0 (item);
#line 251 "rygel-media-item.vala"
			return result;
#line 919 "rygel-media-item.c"
		}
	} else if (_tmp2_ == ((0 != _tmp2__label4) ? _tmp2__label4 : (_tmp2__label4 = g_quark_from_static_string ("dc:date"))))
	switch (0) {
		default:
		{
			result = rygel_media_item_compare_by_date (self, item);
			_g_object_unref0 (item);
#line 253 "rygel-media-item.vala"
			return result;
#line 929 "rygel-media-item.c"
		}
	} else
	switch (0) {
		default:
		{
			result = RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->compare_by_property (RYGEL_MEDIA_OBJECT (self), (RygelMediaObject*) item, property);
			_g_object_unref0 (item);
#line 255 "rygel-media-item.vala"
			return result;
#line 939 "rygel-media-item.c"
		}
	}
	_g_object_unref0 (item);
}


#line 259 "rygel-media-item.vala"
static GUPnPProtocolInfo* rygel_media_item_get_protocol_info (RygelMediaItem* self, const char* uri, const char* protocol) {
#line 948 "rygel-media-item.c"
	GUPnPProtocolInfo* result = NULL;
	GUPnPProtocolInfo* protocol_info;
#line 259 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 259 "rygel-media-item.vala"
	g_return_val_if_fail (protocol != NULL, NULL);
#line 261 "rygel-media-item.vala"
	protocol_info = gupnp_protocol_info_new ();
#line 263 "rygel-media-item.vala"
	gupnp_protocol_info_set_mime_type (protocol_info, self->mime_type);
#line 264 "rygel-media-item.vala"
	gupnp_protocol_info_set_dlna_profile (protocol_info, self->dlna_profile);
#line 265 "rygel-media-item.vala"
	gupnp_protocol_info_set_protocol (protocol_info, protocol);
#line 266 "rygel-media-item.vala"
	gupnp_protocol_info_set_dlna_flags (protocol_info, GUPNP_DLNA_FLAGS_DLNA_V15);
#line 268 "rygel-media-item.vala"
	if (g_str_has_prefix (((RygelMediaObject*) self)->upnp_class, RYGEL_MEDIA_ITEM_IMAGE_CLASS)) {
#line 269 "rygel-media-item.vala"
		gupnp_protocol_info_set_dlna_flags (protocol_info, gupnp_protocol_info_get_dlna_flags (protocol_info) | GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE);
#line 969 "rygel-media-item.c"
	} else {
#line 271 "rygel-media-item.vala"
		gupnp_protocol_info_set_dlna_flags (protocol_info, gupnp_protocol_info_get_dlna_flags (protocol_info) | GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE);
#line 973 "rygel-media-item.c"
	}
#line 274 "rygel-media-item.vala"
	if (!rygel_media_item_should_stream (self)) {
#line 275 "rygel-media-item.vala"
		gupnp_protocol_info_set_dlna_operation (protocol_info, GUPNP_DLNA_OPERATION_RANGE);
#line 276 "rygel-media-item.vala"
		gupnp_protocol_info_set_dlna_flags (protocol_info, gupnp_protocol_info_get_dlna_flags (protocol_info) | (GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE | GUPNP_DLNA_FLAGS_CONNECTION_STALL));
#line 981 "rygel-media-item.c"
	} else {
#line 279 "rygel-media-item.vala"
		gupnp_protocol_info_set_dlna_flags (protocol_info, gupnp_protocol_info_get_dlna_flags (protocol_info) | GUPNP_DLNA_FLAGS_SENDER_PACED);
#line 985 "rygel-media-item.c"
	}
	result = protocol_info;
#line 282 "rygel-media-item.vala"
	return result;
#line 990 "rygel-media-item.c"
}


#line 285 "rygel-media-item.vala"
static char* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const char* uri, GError** error) {
#line 996 "rygel-media-item.c"
	char* result = NULL;
	GError * _inner_error_;
	char* scheme;
#line 285 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 285 "rygel-media-item.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 1004 "rygel-media-item.c"
	_inner_error_ = NULL;
#line 286 "rygel-media-item.vala"
	scheme = g_uri_parse_scheme (uri);
#line 287 "rygel-media-item.vala"
	if (scheme == NULL) {
#line 1010 "rygel-media-item.c"
		_inner_error_ = g_error_new (RYGEL_MEDIA_ITEM_ERROR, RYGEL_MEDIA_ITEM_ERROR_BAD_URI, _ ("Bad URI: %s"), uri);
		{
			g_propagate_error (error, _inner_error_);
			_g_free0 (scheme);
			return NULL;
		}
	}
#line 291 "rygel-media-item.vala"
	if (_vala_strcmp0 (scheme, "http") == 0) {
#line 1020 "rygel-media-item.c"
		result = g_strdup ("http-get");
		_g_free0 (scheme);
#line 292 "rygel-media-item.vala"
		return result;
#line 1025 "rygel-media-item.c"
	} else {
#line 293 "rygel-media-item.vala"
		if (_vala_strcmp0 (scheme, "file") == 0) {
#line 1029 "rygel-media-item.c"
			result = g_strdup ("internal");
			_g_free0 (scheme);
#line 294 "rygel-media-item.vala"
			return result;
#line 1034 "rygel-media-item.c"
		} else {
#line 295 "rygel-media-item.vala"
			if (_vala_strcmp0 (scheme, "rtsp") == 0) {
#line 1038 "rygel-media-item.c"
				result = g_strdup ("rtsp-rtp-udp");
				_g_free0 (scheme);
#line 297 "rygel-media-item.vala"
				return result;
#line 1043 "rygel-media-item.c"
			} else {
#line 300 "rygel-media-item.vala"
				g_warning (_ ("Failed to probe protocol for URI %s. Assuming '%s'"), uri, scheme);
#line 1047 "rygel-media-item.c"
				result = scheme;
#line 304 "rygel-media-item.vala"
				return result;
#line 1051 "rygel-media-item.c"
			}
		}
	}
	_g_free0 (scheme);
}


#line 308 "rygel-media-item.vala"
static gint rygel_media_item_compare_by_date (RygelMediaItem* self, RygelMediaItem* item) {
#line 1061 "rygel-media-item.c"
	gint result = 0;
#line 308 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 308 "rygel-media-item.vala"
	g_return_val_if_fail (item != NULL, 0);
#line 309 "rygel-media-item.vala"
	if (self->date == NULL) {
#line 1069 "rygel-media-item.c"
		result = -1;
#line 310 "rygel-media-item.vala"
		return result;
#line 1073 "rygel-media-item.c"
	} else {
#line 311 "rygel-media-item.vala"
		if (item->date == NULL) {
#line 1077 "rygel-media-item.c"
			result = 1;
#line 312 "rygel-media-item.vala"
			return result;
#line 1081 "rygel-media-item.c"
		} else {
			GTimeVal tv1 = {0};
			GTimeVal tv2 = {0};
			gint ret;
			g_get_current_time (&tv1);
#line 315 "rygel-media-item.vala"
			g_assert (g_time_val_from_iso8601 (self->date, &tv1));
#line 1089 "rygel-media-item.c"
			g_get_current_time (&tv2);
#line 318 "rygel-media-item.vala"
			g_assert (g_time_val_from_iso8601 (item->date, &tv2));
#line 320 "rygel-media-item.vala"
			ret = rygel_media_item_compare_long (self, tv1.tv_sec, tv2.tv_sec);
#line 321 "rygel-media-item.vala"
			if (ret == 0) {
#line 322 "rygel-media-item.vala"
				ret = rygel_media_item_compare_long (self, tv1.tv_usec, tv2.tv_usec);
#line 1099 "rygel-media-item.c"
			}
			result = ret;
#line 325 "rygel-media-item.vala"
			return result;
#line 1104 "rygel-media-item.c"
		}
	}
}


#line 329 "rygel-media-item.vala"
static gint rygel_media_item_compare_long (RygelMediaItem* self, glong a, glong b) {
#line 1112 "rygel-media-item.c"
	gint result = 0;
#line 329 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 330 "rygel-media-item.vala"
	if (a < b) {
#line 1118 "rygel-media-item.c"
		result = -1;
#line 331 "rygel-media-item.vala"
		return result;
#line 1122 "rygel-media-item.c"
	} else {
#line 332 "rygel-media-item.vala"
		if (a > b) {
#line 1126 "rygel-media-item.c"
			result = 1;
#line 333 "rygel-media-item.vala"
			return result;
#line 1130 "rygel-media-item.c"
		} else {
			result = 0;
#line 335 "rygel-media-item.vala"
			return result;
#line 1135 "rygel-media-item.c"
		}
	}
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_ITEM_CLASS (klass)->create_stream_source = rygel_media_item_real_create_stream_source;
	RYGEL_MEDIA_ITEM_CLASS (klass)->should_stream = rygel_media_item_real_should_stream;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->compare_by_property = rygel_media_item_real_compare_by_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	self->size = (gint64) (-1);
	self->duration = (glong) (-1);
	self->bitrate = -1;
	self->sample_freq = -1;
	self->bits_per_sample = -1;
	self->n_audio_channels = -1;
	self->track_number = -1;
	self->width = -1;
	self->height = -1;
	self->pixel_width = -1;
	self->pixel_height = -1;
	self->color_depth = -1;
	self->place_holder = FALSE;
}


static void rygel_media_item_finalize (GObject* obj) {
	RygelMediaItem * self;
	self = RYGEL_MEDIA_ITEM (obj);
	_g_free0 (self->author);
	_g_free0 (self->album);
	_g_free0 (self->date);
	_g_free0 (self->genre);
	_g_free0 (self->mime_type);
	_g_free0 (self->dlna_profile);
	_g_object_unref0 (self->thumbnails);
	_g_object_unref0 (self->subtitles);
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
}


/**
 * Represents a media (Music, Video and Image) item.
 */
GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




