/* rygel-plugin-loader.c generated by valac 0.9.5, the Vala compiler
 * generated from rygel-plugin-loader.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <gmodule.h>
#include <config.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_PLUGIN_LOADER (rygel_plugin_loader_get_type ())
#define RYGEL_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoader))
#define RYGEL_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderClass))
#define RYGEL_IS_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN_LOADER))
#define RYGEL_IS_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN_LOADER))
#define RYGEL_PLUGIN_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderClass))

typedef struct _RygelPluginLoader RygelPluginLoader;
typedef struct _RygelPluginLoaderClass RygelPluginLoaderClass;
typedef struct _RygelPluginLoaderPrivate RygelPluginLoaderPrivate;

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_LOG_LEVEL (rygel_log_level_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelPluginPrivate RygelPluginPrivate;

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
typedef struct _RygelPluginLoaderLoadModulesFromDirData RygelPluginLoaderLoadModulesFromDirData;
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))

struct _RygelPluginLoader {
	GObject parent_instance;
	RygelPluginLoaderPrivate * priv;
};

struct _RygelPluginLoaderClass {
	GObjectClass parent_class;
};

struct _RygelPluginLoaderPrivate {
	GeeHashMap* plugin_hash;
};

typedef enum  {
	RYGEL_LOG_LEVEL_INVALID = 0,
	RYGEL_LOG_LEVEL_CRITICAL = 1,
	RYGEL_LOG_LEVEL_ERROR = 2,
	RYGEL_LOG_LEVEL_WARNING = 3,
	RYGEL_LOG_LEVEL_INFO = 4,
	RYGEL_LOG_LEVEL_DEFAULT = 4,
	RYGEL_LOG_LEVEL_DEBUG = 5
} RygelLogLevel;

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	char* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	RygelLogLevel (*get_log_level) (RygelConfiguration* self, GError** error);
	char* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const char* section, GError** error);
	char* (*get_title) (RygelConfiguration* self, const char* section, GError** error);
	char* (*get_string) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const char* section, const char* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const char* section, const char* key, GError** error);
};

struct _RygelPlugin {
	GUPnPResourceFactory parent_instance;
	RygelPluginPrivate * priv;
	char* name;
	char* title;
	char* description;
	char* desc_path;
	GeeArrayList* resource_infos;
	GeeArrayList* icon_infos;
	GeeArrayList* default_icons;
};

struct _RygelPluginClass {
	GUPnPResourceFactoryClass parent_class;
};

struct _RygelPluginLoaderLoadModulesFromDirData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelPluginLoader* self;
	GFile* dir;
	char* _tmp0_;
	char* attributes;
	GList* infos;
	GFileEnumerator* enumerator;
	GFileEnumerator* _tmp1_;
	GFileEnumerator* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	char* _tmp5_;
	GError * _error_;
	char* file_name;
	char* file_path;
	char* _tmp6_;
	char* _tmp7_;
	GFile* file;
	GFileType file_type;
	char* content_type;
	char* mime;
	GList* info_collection;
	GList* info_it;
	GFileInfo* info;
	char* _tmp8_;
	GError * _inner_error_;
};

typedef void (*RygelPluginLoaderModuleInitFunc) (RygelPluginLoader* loader, void* user_data);

static gpointer rygel_plugin_loader_parent_class = NULL;

GType rygel_plugin_loader_get_type (void) G_GNUC_CONST;
GType rygel_plugin_get_type (void) G_GNUC_CONST;
#define RYGEL_PLUGIN_LOADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderPrivate))
enum  {
	RYGEL_PLUGIN_LOADER_DUMMY_PROPERTY
};
RygelPluginLoader* rygel_plugin_loader_new (void);
RygelPluginLoader* rygel_plugin_loader_construct (GType object_type);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
GType rygel_log_level_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
char* rygel_configuration_get_plugin_path (RygelConfiguration* self, GError** error);
static gboolean rygel_plugin_loader_is_dir (GFile* file);
static void rygel_plugin_loader_load_modules_from_dir (RygelPluginLoader* self, GFile* dir, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_plugin_loader_load_modules_from_dir_finish (RygelPluginLoader* self, GAsyncResult* _res_);
void rygel_plugin_loader_load_plugins (RygelPluginLoader* self);
gboolean rygel_configuration_get_enabled (RygelConfiguration* self, const char* section, GError** error);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
void rygel_plugin_loader_add_plugin (RygelPluginLoader* self, RygelPlugin* plugin);
RygelPlugin* rygel_plugin_loader_get_plugin_by_name (RygelPluginLoader* self, const char* name);
GeeCollection* rygel_plugin_loader_list_plugins (RygelPluginLoader* self);
static void rygel_plugin_loader_load_modules_from_dir_data_free (gpointer _data);
static void rygel_plugin_loader_load_modules_from_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_list_free_g_object_unref (GList* self);
static void rygel_plugin_loader_load_module_from_file (RygelPluginLoader* self, const char* file_path);
static gboolean rygel_plugin_loader_load_modules_from_dir_co (RygelPluginLoaderLoadModulesFromDirData* data);
static void rygel_plugin_loader_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 41 "rygel-plugin-loader.vala"
RygelPluginLoader* rygel_plugin_loader_construct (GType object_type) {
#line 250 "rygel-plugin-loader.c"
	RygelPluginLoader * self;
	GeeHashMap* _tmp0_;
#line 41 "rygel-plugin-loader.vala"
	self = (RygelPluginLoader*) g_object_new (object_type, NULL);
#line 42 "rygel-plugin-loader.vala"
	self->priv->plugin_hash = (_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_TYPE_PLUGIN, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_str_hash, g_str_equal, NULL), _g_object_unref0 (self->priv->plugin_hash), _tmp0_);
#line 257 "rygel-plugin-loader.c"
	return self;
}


#line 41 "rygel-plugin-loader.vala"
RygelPluginLoader* rygel_plugin_loader_new (void) {
#line 41 "rygel-plugin-loader.vala"
	return rygel_plugin_loader_construct (RYGEL_TYPE_PLUGIN_LOADER);
#line 266 "rygel-plugin-loader.c"
}


#line 46 "rygel-plugin-loader.vala"
void rygel_plugin_loader_load_plugins (RygelPluginLoader* self) {
#line 272 "rygel-plugin-loader.c"
	GError * _inner_error_;
	char* path;
	GFile* dir;
	gboolean _tmp3_ = FALSE;
#line 46 "rygel-plugin-loader.vala"
	g_return_if_fail (self != NULL);
#line 279 "rygel-plugin-loader.c"
	_inner_error_ = NULL;
#line 47 "rygel-plugin-loader.vala"
	g_assert (g_module_supported ());
#line 283 "rygel-plugin-loader.c"
	path = NULL;
	{
		RygelMetaConfig* config;
		char* _tmp0_;
		char* _tmp1_;
#line 51 "rygel-plugin-loader.vala"
		config = rygel_meta_config_get_default ();
#line 52 "rygel-plugin-loader.vala"
		_tmp0_ = rygel_configuration_get_plugin_path ((RygelConfiguration*) config, &_inner_error_);
#line 293 "rygel-plugin-loader.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (config);
			goto __catch35_g_error;
		}
#line 52 "rygel-plugin-loader.vala"
		path = (_tmp1_ = _tmp0_, _g_free0 (path), _tmp1_);
#line 300 "rygel-plugin-loader.c"
		_g_object_unref0 (config);
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp2_;
#line 54 "rygel-plugin-loader.vala"
			path = (_tmp2_ = g_strdup (PLUGIN_DIR), _g_free0 (path), _tmp2_);
#line 313 "rygel-plugin-loader.c"
			_g_error_free0 (_error_);
		}
	}
	__finally35:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
#line 57 "rygel-plugin-loader.vala"
	dir = g_file_new_for_path (path);
#line 58 "rygel-plugin-loader.vala"
	if (dir != NULL) {
#line 58 "rygel-plugin-loader.vala"
		_tmp3_ = rygel_plugin_loader_is_dir (dir);
#line 330 "rygel-plugin-loader.c"
	} else {
#line 58 "rygel-plugin-loader.vala"
		_tmp3_ = FALSE;
#line 334 "rygel-plugin-loader.c"
	}
#line 58 "rygel-plugin-loader.vala"
	g_assert (_tmp3_);
#line 60 "rygel-plugin-loader.vala"
	rygel_plugin_loader_load_modules_from_dir (self, dir, NULL, NULL);
#line 340 "rygel-plugin-loader.c"
	_g_object_unref0 (dir);
	_g_free0 (path);
}


#line 63 "rygel-plugin-loader.vala"
void rygel_plugin_loader_add_plugin (RygelPluginLoader* self, RygelPlugin* plugin) {
#line 348 "rygel-plugin-loader.c"
	GError * _inner_error_;
	gboolean enabled;
#line 63 "rygel-plugin-loader.vala"
	g_return_if_fail (self != NULL);
#line 63 "rygel-plugin-loader.vala"
	g_return_if_fail (plugin != NULL);
#line 355 "rygel-plugin-loader.c"
	_inner_error_ = NULL;
#line 64 "rygel-plugin-loader.vala"
	enabled = TRUE;
#line 359 "rygel-plugin-loader.c"
	{
		RygelMetaConfig* config;
		gboolean _tmp0_;
#line 66 "rygel-plugin-loader.vala"
		config = rygel_meta_config_get_default ();
#line 67 "rygel-plugin-loader.vala"
		_tmp0_ = rygel_configuration_get_enabled ((RygelConfiguration*) config, plugin->name, &_inner_error_);
#line 367 "rygel-plugin-loader.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (config);
			goto __catch36_g_error;
		}
#line 67 "rygel-plugin-loader.vala"
		enabled = _tmp0_;
#line 374 "rygel-plugin-loader.c"
		_g_object_unref0 (config);
	}
	goto __finally36;
	__catch36_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (err);
		}
	}
	__finally36:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
#line 70 "rygel-plugin-loader.vala"
	if (enabled) {
#line 71 "rygel-plugin-loader.vala"
		g_message (_ ("New plugin '%s' available"), plugin->name);
#line 72 "rygel-plugin-loader.vala"
		gee_abstract_map_set ((GeeAbstractMap*) self->priv->plugin_hash, plugin->name, plugin);
#line 73 "rygel-plugin-loader.vala"
		g_signal_emit_by_name (self, "plugin-available", plugin);
#line 401 "rygel-plugin-loader.c"
	} else {
#line 75 "rygel-plugin-loader.vala"
		g_debug (_ ("Plugin '%s' disabled in user configuration, ignoring.."), plugin->name);
#line 405 "rygel-plugin-loader.c"
	}
}


#line 80 "rygel-plugin-loader.vala"
RygelPlugin* rygel_plugin_loader_get_plugin_by_name (RygelPluginLoader* self, const char* name) {
#line 412 "rygel-plugin-loader.c"
	RygelPlugin* result = NULL;
#line 80 "rygel-plugin-loader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 80 "rygel-plugin-loader.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 418 "rygel-plugin-loader.c"
	result = (RygelPlugin*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->plugin_hash, name);
#line 81 "rygel-plugin-loader.vala"
	return result;
#line 422 "rygel-plugin-loader.c"
}


#line 84 "rygel-plugin-loader.vala"
GeeCollection* rygel_plugin_loader_list_plugins (RygelPluginLoader* self) {
#line 428 "rygel-plugin-loader.c"
	GeeCollection* result = NULL;
#line 84 "rygel-plugin-loader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 432 "rygel-plugin-loader.c"
	result = gee_map_get_values ((GeeMap*) self->priv->plugin_hash);
#line 85 "rygel-plugin-loader.vala"
	return result;
#line 436 "rygel-plugin-loader.c"
}


static void rygel_plugin_loader_load_modules_from_dir_data_free (gpointer _data) {
	RygelPluginLoaderLoadModulesFromDirData* data;
	data = _data;
	_g_object_unref0 (data->dir);
	g_object_unref (data->self);
	g_slice_free (RygelPluginLoaderLoadModulesFromDirData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_plugin_loader_load_modules_from_dir (RygelPluginLoader* self, GFile* dir, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelPluginLoaderLoadModulesFromDirData* _data_;
	_data_ = g_slice_new0 (RygelPluginLoaderLoadModulesFromDirData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_plugin_loader_load_modules_from_dir);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_plugin_loader_load_modules_from_dir_data_free);
	_data_->self = g_object_ref (self);
	_data_->dir = _g_object_ref0 (dir);
	rygel_plugin_loader_load_modules_from_dir_co (_data_);
}


static void rygel_plugin_loader_load_modules_from_dir_finish (RygelPluginLoader* self, GAsyncResult* _res_) {
	RygelPluginLoaderLoadModulesFromDirData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_plugin_loader_load_modules_from_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelPluginLoaderLoadModulesFromDirData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_plugin_loader_load_modules_from_dir_co (data);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static gboolean rygel_plugin_loader_load_modules_from_dir_co (RygelPluginLoaderLoadModulesFromDirData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 20:
		goto _state_20;
		case 21:
		goto _state_21;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
#line 89 "rygel-plugin-loader.vala"
		g_debug (_ ("Searching for modules in folder '%s' .."), data->_tmp0_ = g_file_get_path (data->dir));
#line 500 "rygel-plugin-loader.c"
		_g_free0 (data->_tmp0_);
		data->attributes = g_strdup (G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
		{
			data->_state_ = 20;
			g_file_enumerate_children_async (data->dir, data->attributes, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, rygel_plugin_loader_load_modules_from_dir_ready, data);
			return FALSE;
			_state_20:
			data->_tmp1_ = g_file_enumerate_children_finish (data->dir, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch37_g_error;
			}
#line 99 "rygel-plugin-loader.vala"
			data->enumerator = (data->_tmp2_ = data->_tmp1_, _g_object_unref0 (data->enumerator), data->_tmp2_);
#line 514 "rygel-plugin-loader.c"
			data->_state_ = 21;
			g_file_enumerator_next_files_async (data->enumerator, G_MAXINT, G_PRIORITY_DEFAULT, NULL, rygel_plugin_loader_load_modules_from_dir_ready, data);
			return FALSE;
			_state_21:
			data->_tmp3_ = g_file_enumerator_next_files_finish (data->enumerator, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch37_g_error;
			}
#line 105 "rygel-plugin-loader.vala"
			data->infos = (data->_tmp4_ = data->_tmp3_, __g_list_free_g_object_unref0 (data->infos), data->_tmp4_);
#line 525 "rygel-plugin-loader.c"
		}
		goto __finally37;
		__catch37_g_error:
		{
			data->_error_ = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
#line 109 "rygel-plugin-loader.vala"
				g_critical (_ ("Error listing contents of folder '%s': %s"), data->_tmp5_ = g_file_get_path (data->dir), data->_error_->message);
#line 535 "rygel-plugin-loader.c"
				_g_free0 (data->_tmp5_);
				_g_error_free0 (data->_error_);
				_g_object_unref0 (data->enumerator);
				__g_list_free_g_object_unref0 (data->infos);
				_g_free0 (data->attributes);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				_g_error_free0 (data->_error_);
			}
		}
		__finally37:
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->enumerator);
			__g_list_free_g_object_unref0 (data->infos);
			_g_free0 (data->attributes);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		{
			data->info_collection = data->infos;
			for (data->info_it = data->info_collection; data->info_it != NULL; data->info_it = data->info_it->next) {
				data->info = _g_object_ref0 ((GFileInfo*) data->info_it->data);
				{
					data->file_name = g_strdup (g_file_info_get_name (data->info));
					data->file_path = (data->_tmp7_ = g_build_filename (data->_tmp6_ = g_file_get_path (data->dir), data->file_name, NULL), _g_free0 (data->_tmp6_), data->_tmp7_);
					data->file = g_file_new_for_path (data->file_path);
					data->file_type = g_file_info_get_file_type (data->info);
					data->content_type = g_strdup (g_file_info_get_content_type (data->info));
					data->mime = g_content_type_get_mime_type (data->content_type);
#line 125 "rygel-plugin-loader.vala"
					if (data->file_type == G_FILE_TYPE_DIRECTORY) {
#line 127 "rygel-plugin-loader.vala"
						rygel_plugin_loader_load_modules_from_dir (data->self, data->file, NULL, NULL);
#line 577 "rygel-plugin-loader.c"
					} else {
#line 128 "rygel-plugin-loader.vala"
						if (_vala_strcmp0 (data->mime, "application/x-sharedlib") == 0) {
#line 130 "rygel-plugin-loader.vala"
							rygel_plugin_loader_load_module_from_file (data->self, data->file_path);
#line 583 "rygel-plugin-loader.c"
						}
					}
					_g_free0 (data->mime);
					_g_free0 (data->content_type);
					_g_object_unref0 (data->file);
					_g_free0 (data->file_path);
					_g_free0 (data->file_name);
					_g_object_unref0 (data->info);
				}
			}
		}
#line 134 "rygel-plugin-loader.vala"
		g_debug (_ ("Finished searching for modules in folder '%s'"), data->_tmp8_ = g_file_get_path (data->dir));
#line 597 "rygel-plugin-loader.c"
		_g_free0 (data->_tmp8_);
		_g_object_unref0 (data->enumerator);
		__g_list_free_g_object_unref0 (data->infos);
		_g_free0 (data->attributes);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 138 "rygel-plugin-loader.vala"
static void rygel_plugin_loader_load_module_from_file (RygelPluginLoader* self, const char* file_path) {
#line 617 "rygel-plugin-loader.c"
	GModule* module;
	void* function = NULL;
	RygelPluginLoaderModuleInitFunc _tmp0_;
	GDestroyNotify module_init_target_destroy_notify = NULL;
	void* module_init_target = NULL;
	RygelPluginLoaderModuleInitFunc module_init;
#line 138 "rygel-plugin-loader.vala"
	g_return_if_fail (self != NULL);
#line 138 "rygel-plugin-loader.vala"
	g_return_if_fail (file_path != NULL);
#line 139 "rygel-plugin-loader.vala"
	module = g_module_open (file_path, G_MODULE_BIND_LOCAL);
#line 140 "rygel-plugin-loader.vala"
	if (module == NULL) {
#line 141 "rygel-plugin-loader.vala"
		g_warning (_ ("Failed to load module from path '%s' : %s"), file_path, g_module_error ());
#line 634 "rygel-plugin-loader.c"
		_g_module_close0 (module);
#line 145 "rygel-plugin-loader.vala"
		return;
#line 638 "rygel-plugin-loader.c"
	}
#line 150 "rygel-plugin-loader.vala"
	if (!g_module_symbol (module, "module_init", &function)) {
#line 151 "rygel-plugin-loader.vala"
		g_warning (_ ("Failed to find entry point function '%s' in '%s': %s"), "module_init", file_path, g_module_error ());
#line 644 "rygel-plugin-loader.c"
		_g_module_close0 (module);
#line 156 "rygel-plugin-loader.vala"
		return;
#line 648 "rygel-plugin-loader.c"
	}
	module_init = (_tmp0_ = (RygelPluginLoaderModuleInitFunc) function, module_init_target = NULL, module_init_target_destroy_notify = NULL, _tmp0_);
#line 160 "rygel-plugin-loader.vala"
	g_assert (module_init != NULL);
#line 163 "rygel-plugin-loader.vala"
	g_module_make_resident (module);
#line 165 "rygel-plugin-loader.vala"
	module_init (self, module_init_target);
#line 167 "rygel-plugin-loader.vala"
	g_debug (_ ("Loaded module source: '%s'"), g_module_name (module));
#line 659 "rygel-plugin-loader.c"
	(module_init_target_destroy_notify == NULL) ? NULL : (module_init_target_destroy_notify (module_init_target), NULL);
	module_init = NULL;
	module_init_target = NULL;
	module_init_target_destroy_notify = NULL;
	_g_module_close0 (module);
}


#line 170 "rygel-plugin-loader.vala"
static gboolean rygel_plugin_loader_is_dir (GFile* file) {
#line 670 "rygel-plugin-loader.c"
	gboolean result = FALSE;
	GError * _inner_error_;
	GFileInfo* file_info;
#line 170 "rygel-plugin-loader.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 676 "rygel-plugin-loader.c"
	_inner_error_ = NULL;
	file_info = NULL;
	{
		GFileInfo* _tmp0_;
		GFileInfo* _tmp1_;
#line 174 "rygel-plugin-loader.vala"
		_tmp0_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 684 "rygel-plugin-loader.c"
		if (_inner_error_ != NULL) {
			goto __catch38_g_error;
		}
#line 174 "rygel-plugin-loader.vala"
		file_info = (_tmp1_ = _tmp0_, _g_object_unref0 (file_info), _tmp1_);
#line 690 "rygel-plugin-loader.c"
	}
	goto __finally38;
	__catch38_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp2_;
#line 178 "rygel-plugin-loader.vala"
			g_critical (_ ("Failed to query content type for '%s'"), _tmp2_ = g_file_get_path (file));
#line 702 "rygel-plugin-loader.c"
			_g_free0 (_tmp2_);
			result = FALSE;
			_g_error_free0 (_error_);
			_g_object_unref0 (file_info);
#line 181 "rygel-plugin-loader.vala"
			return result;
#line 709 "rygel-plugin-loader.c"
		}
	}
	__finally38:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = g_file_info_get_file_type (file_info) == G_FILE_TYPE_DIRECTORY;
	_g_object_unref0 (file_info);
#line 184 "rygel-plugin-loader.vala"
	return result;
#line 723 "rygel-plugin-loader.c"
}


static void rygel_plugin_loader_class_init (RygelPluginLoaderClass * klass) {
	rygel_plugin_loader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelPluginLoaderPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_plugin_loader_finalize;
	g_signal_new ("plugin_available", RYGEL_TYPE_PLUGIN_LOADER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_PLUGIN);
}


static void rygel_plugin_loader_instance_init (RygelPluginLoader * self) {
	self->priv = RYGEL_PLUGIN_LOADER_GET_PRIVATE (self);
}


static void rygel_plugin_loader_finalize (GObject* obj) {
	RygelPluginLoader * self;
	self = RYGEL_PLUGIN_LOADER (obj);
	_g_object_unref0 (self->priv->plugin_hash);
	G_OBJECT_CLASS (rygel_plugin_loader_parent_class)->finalize (obj);
}


/**
 * Responsible for plugin loading. Probes for shared library files in a specific
 * directry and tries to grab a function with a specific name and signature,
 * calls it. The loaded module can then add plugins to Rygel by calling the
 * add_plugin method.
 */
GType rygel_plugin_loader_get_type (void) {
	static volatile gsize rygel_plugin_loader_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_plugin_loader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPluginLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_plugin_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPluginLoader), 0, (GInstanceInitFunc) rygel_plugin_loader_instance_init, NULL };
		GType rygel_plugin_loader_type_id;
		rygel_plugin_loader_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPluginLoader", &g_define_type_info, 0);
		g_once_init_leave (&rygel_plugin_loader_type_id__volatile, rygel_plugin_loader_type_id);
	}
	return rygel_plugin_loader_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




