/* rygel-http-get-test.c generated by valac 0.9.5, the Vala compiler
 * generated from rygel-http-get-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <libgssdp/gssdp.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_HTTP_GET_TEST (rygel_http_get_test_get_type ())
#define RYGEL_HTTP_GET_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTest))
#define RYGEL_HTTP_GET_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestClass))
#define RYGEL_IS_HTTP_GET_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_TEST))
#define RYGEL_IS_HTTP_GET_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_TEST))
#define RYGEL_HTTP_GET_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestClass))

typedef struct _RygelHTTPGetTest RygelHTTPGetTest;
typedef struct _RygelHTTPGetTestClass RygelHTTPGetTestClass;
typedef struct _RygelHTTPGetTestPrivate RygelHTTPGetTestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_CLIENT (rygel_http_client_get_type ())
#define RYGEL_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient))
#define RYGEL_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))
#define RYGEL_IS_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_IS_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_HTTP_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))

typedef struct _RygelHTTPClient RygelHTTPClient;
typedef struct _RygelHTTPClientClass RygelHTTPClientClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelHttpGetTestHandleClientMessageData RygelHttpGetTestHandleClientMessageData;
#define _rygel_media_object_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_object_unref (var), NULL)))

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelHTTPClientPrivate RygelHTTPClientPrivate;
typedef struct _Block1Data Block1Data;
typedef struct _RygelHttpClientRunData RygelHttpClientRunData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
typedef struct _Block2Data Block2Data;
typedef struct _RygelMediaContainerFindObjectData RygelMediaContainerFindObjectData;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelParamSpecHTTPGetHandler RygelParamSpecHTTPGetHandler;

#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;
typedef struct _RygelHTTPTranscodeHandlerPrivate RygelHTTPTranscodeHandlerPrivate;

#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelHTTPIdentityHandlerPrivate RygelHTTPIdentityHandlerPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
typedef struct _RygelParamSpecThumbnail RygelParamSpecThumbnail;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
typedef struct _RygelParamSpecSubtitle RygelParamSpecSubtitle;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;
typedef struct _Block3Data Block3Data;
typedef struct _RygelHttpResponseRunData RygelHttpResponseRunData;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;
typedef struct _RygelParamSpecTranscoder RygelParamSpecTranscoder;
typedef struct _RygelParamSpecMediaObject RygelParamSpecMediaObject;

typedef enum  {
	RYGEL_TEST_ERROR_SKIP = 77,
	RYGEL_TEST_ERROR_TIMEOUT
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelHTTPGetTest {
	GObject parent_instance;
	RygelHTTPGetTestPrivate * priv;
	RygelHTTPServer* server;
	RygelHTTPClient* client;
};

struct _RygelHTTPGetTestClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPGetTest* self, GError** error);
};

struct _RygelHTTPGetTestPrivate {
	gboolean server_done;
	gboolean client_done;
	GMainLoop* main_loop;
	GError* error;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHttpGetTestHandleClientMessageData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGetTest* self;
	SoupMessage* msg;
	RygelHTTPRequest* request;
	RygelHTTPRequest* _tmp0_;
	GError* _tmp1_;
	GError * _error_;
	GError * _inner_error_;
};

struct _RygelHTTPClient {
	GObject parent_instance;
	RygelHTTPClientPrivate * priv;
	GUPnPContext* context;
	SoupMessage* msg;
};

struct _RygelHTTPClientClass {
	GObjectClass parent_class;
};

struct _RygelHTTPClientPrivate {
	GCancellable* _cancellable;
};

struct _Block1Data {
	int _ref_count_;
	RygelHTTPClient * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpClientRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPClient* self;
	GSourceFunc _tmp0_;
	Block1Data* _data1_;
};

struct _RygelMediaObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaObjectPrivate * priv;
};

struct _RygelMediaObjectClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaObject *self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	RygelMediaContainer * self;
	GSourceFunc find_object_continue;
	gpointer find_object_continue_target;
	GDestroyNotify find_object_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelMediaContainerFindObjectData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaContainer* self;
	char* item_id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	GSourceFunc _tmp0_;
	Block2Data* _data2_;
};

struct _RygelHTTPGetHandler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GTypeClass parent_class;
	void (*finalize) (RygelHTTPGetHandler *self);
};

struct _RygelParamSpecHTTPGetHandler {
	GParamSpec parent_instance;
};

struct _RygelHTTPTranscodeHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPTranscodeHandlerPrivate * priv;
};

struct _RygelHTTPTranscodeHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelHTTPIdentityHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPIdentityHandlerPrivate * priv;
};

struct _RygelHTTPIdentityHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	glong size;
	glong duration;
	GeeArrayList* subtitles;
	GeeArrayList* thumbnails;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelThumbnail {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelThumbnailPrivate * priv;
	glong size;
};

struct _RygelThumbnailClass {
	GTypeClass parent_class;
	void (*finalize) (RygelThumbnail *self);
};

struct _RygelParamSpecThumbnail {
	GParamSpec parent_instance;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	glong size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};

struct _RygelParamSpecSubtitle {
	GParamSpec parent_instance;
};

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
};

struct _RygelHTTPResponsePrivate {
	GCancellable* _cancellable;
	SoupMessage* msg;
	SoupServer* server;
};

struct _Block3Data {
	int _ref_count_;
	RygelHTTPResponse * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpResponseRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPResponse* self;
	GSourceFunc _tmp0_;
	Block3Data* _data3_;
};

struct _RygelTranscoder {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTranscoder *self);
};

struct _RygelParamSpecTranscoder {
	GParamSpec parent_instance;
};

struct _RygelParamSpecMediaObject {
	GParamSpec parent_instance;
};


static gpointer rygel_http_get_test_parent_class = NULL;
static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_http_client_parent_class = NULL;
static RygelStateMachineIface* rygel_http_client_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_media_container_parent_class = NULL;
static gpointer rygel_http_get_handler_parent_class = NULL;
static gpointer rygel_http_transcode_handler_parent_class = NULL;
static gpointer rygel_http_identity_handler_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_thumbnail_parent_class = NULL;
static gpointer rygel_subtitle_parent_class = NULL;
static gpointer rygel_http_response_parent_class = NULL;
static RygelStateMachineIface* rygel_http_response_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_transcoder_parent_class = NULL;
static gpointer rygel_media_object_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GType rygel_http_get_test_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_client_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_GET_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestPrivate))
enum  {
	RYGEL_HTTP_GET_TEST_DUMMY_PROPERTY
};
RygelHTTPGetTest* rygel_http_get_test_new (GError** error);
RygelHTTPGetTest* rygel_http_get_test_construct (GType object_type, GError** error);
void rygel_http_get_test_run (RygelHTTPGetTest* self, GError** error);
gint rygel_http_get_test_main (char** args, int args_length1);
RygelHTTPServer* rygel_http_server_new (GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error);
gpointer rygel_media_object_ref (gpointer instance);
void rygel_media_object_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_object (GValue* value, gpointer v_object);
void rygel_value_take_media_object (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_object (const GValue* value);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
char* rygel_http_server_get_uri (RygelHTTPServer* self);
RygelHTTPClient* rygel_http_client_new (GUPnPContext* context, const char* uri);
RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context, const char* uri);
static gboolean rygel_http_get_test_on_timeout (RygelHTTPGetTest* self);
static gboolean _rygel_http_get_test_on_timeout_gsource_func (gpointer self);
static void rygel_http_get_test_on_message_received (RygelHTTPGetTest* self, RygelHTTPServer* server, SoupMessage* msg);
static void _rygel_http_get_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
static void rygel_http_get_test_on_client_completed (RygelHTTPGetTest* self, RygelStateMachine* client);
static void _rygel_http_get_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
static void rygel_http_get_test_real_run (RygelHTTPGetTest* self, GError** error);
RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
static RygelHTTPRequest* rygel_http_get_test_create_request (RygelHTTPGetTest* self, SoupMessage* msg, GError** error);
static void rygel_http_get_test_handle_client_message (RygelHTTPGetTest* self, SoupMessage* msg, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_get_test_handle_client_message_finish (RygelHTTPGetTest* self, GAsyncResult* _res_);
static void rygel_http_get_test_handle_client_message_data_free (gpointer _data);
static void rygel_http_get_test_handle_client_message_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
static gboolean rygel_http_get_test_handle_client_message_co (RygelHttpGetTestHandleClientMessageData* data);
static void rygel_http_get_test_finalize (GObject* obj);
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_PATH_ROOT,
	RYGEL_HTTP_SERVER_URI
};
#define RYGEL_HTTP_SERVER_SERVER_PATH "/RygelHTTPServer/Rygel/Test"
static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const char* path, GHashTable* query, SoupClientContext* client);
static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const char* path, GHashTable* query, SoupClientContext* client, gpointer self);
RygelMediaContainer* rygel_media_container_new (void);
RygelMediaContainer* rygel_media_container_construct (GType object_type);
RygelTranscoder* rygel_transcoder_new (void);
RygelTranscoder* rygel_transcoder_construct (GType object_type);
gpointer rygel_transcoder_ref (gpointer instance);
void rygel_transcoder_unref (gpointer instance);
GParamSpec* rygel_param_spec_transcoder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_transcoder (GValue* value, gpointer v_object);
void rygel_value_take_transcoder (GValue* value, gpointer v_object);
gpointer rygel_value_get_transcoder (const GValue* value);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const char* target, GError** error);
const char* rygel_http_server_get_path_root (RygelHTTPServer* self);
#define RYGEL_MEDIA_CONTAINER_ITEM_ID "TestItem"
RygelHTTPItemURI* rygel_http_item_uri_new (const char* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const char* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const char* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const char* transcode_target);
char* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static void rygel_http_server_finalize (GObject* obj);
static void rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define RYGEL_HTTP_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientPrivate))
enum  {
	RYGEL_HTTP_CLIENT_DUMMY_PROPERTY,
	RYGEL_HTTP_CLIENT_CANCELLABLE
};
static void rygel_http_client_real_run_data_free (gpointer _data);
static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_client_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self);
static void _lambda1_ (SoupSession* session, SoupMessage* msg, Block1Data* _data1_);
static void __lambda1__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* data);
static void rygel_http_client_finalize (GObject* obj);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY
};
static void rygel_media_container_find_object_data_free (gpointer _data);
static void rygel_media_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const char* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static gboolean _rygel_media_container_find_object_co_gsource_func (gpointer self);
static gboolean _lambda0_ (Block2Data* _data2_);
static gboolean __lambda0__gsource_func (gpointer self);
RygelMediaItem* rygel_media_item_new (void);
RygelMediaItem* rygel_media_item_construct (GType object_type);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* data);
RygelMediaObject* rygel_media_object_new (void);
RygelMediaObject* rygel_media_object_construct (GType object_type);
gpointer rygel_http_get_handler_ref (gpointer instance);
void rygel_http_get_handler_unref (gpointer instance);
GParamSpec* rygel_param_spec_http_get_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_http_get_handler (GValue* value, gpointer v_object);
void rygel_value_take_http_get_handler (GValue* value, gpointer v_object);
gpointer rygel_value_get_http_get_handler (const GValue* value);
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_GET_HANDLER_DUMMY_PROPERTY
};
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* get_request);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* get_request);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* get_request);
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* get_request);
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type);
static void rygel_http_get_handler_finalize (RygelHTTPGetHandler* obj);
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TRANSCODE_HANDLER_DUMMY_PROPERTY
};
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (RygelTranscoder* transcoder, GCancellable* cancellable);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type, RygelTranscoder* transcoder, GCancellable* cancellable);
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_IDENTITY_HANDLER_DUMMY_PROPERTY
};
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable);
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable);
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
gpointer rygel_thumbnail_ref (gpointer instance);
void rygel_thumbnail_unref (gpointer instance);
GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_thumbnail (GValue* value, gpointer v_object);
void rygel_value_take_thumbnail (GValue* value, gpointer v_object);
gpointer rygel_value_get_thumbnail (const GValue* value);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
gboolean rygel_media_item_should_stream (RygelMediaItem* self);
static void rygel_media_item_finalize (RygelMediaObject* obj);
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (void);
RygelThumbnail* rygel_thumbnail_construct (GType object_type);
static void rygel_thumbnail_finalize (RygelThumbnail* obj);
enum  {
	RYGEL_SUBTITLE_DUMMY_PROPERTY
};
RygelSubtitle* rygel_subtitle_new (void);
RygelSubtitle* rygel_subtitle_construct (GType object_type);
static void rygel_subtitle_finalize (RygelSubtitle* obj);
#define RYGEL_HTTP_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponsePrivate))
enum  {
	RYGEL_HTTP_RESPONSE_DUMMY_PROPERTY,
	RYGEL_HTTP_RESPONSE_CANCELLABLE
};
static void rygel_http_response_real_run_data_free (gpointer _data);
static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_response_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self);
static gboolean _lambda2_ (Block3Data* _data3_);
static gboolean __lambda2__gsource_func (gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* data);
static void rygel_http_response_finalize (GObject* obj);
static void rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_TRANSCODER_DUMMY_PROPERTY
};
static void rygel_transcoder_finalize (RygelTranscoder* obj);
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY
};
static void rygel_media_object_finalize (RygelMediaObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


#line 43 "rygel-http-get-test.vala"
gint rygel_http_get_test_main (char** args, int args_length1) {
#line 741 "rygel-http-get-test.c"
	gint result = 0;
	GError * _inner_error_;
	_inner_error_ = NULL;
	{
		RygelHTTPGetTest* test;
#line 45 "rygel-http-get-test.vala"
		test = rygel_http_get_test_new (&_inner_error_);
#line 749 "rygel-http-get-test.c"
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 47 "rygel-http-get-test.vala"
		rygel_http_get_test_run (test, &_inner_error_);
#line 758 "rygel-http-get-test.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (test);
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
		_g_object_unref0 (test);
	}
	goto __finally0;
	__catch0_rygel_test_error_skip:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			result = _error_->code;
			_g_error_free0 (_error_);
#line 49 "rygel-http-get-test.vala"
			return result;
#line 779 "rygel-http-get-test.c"
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 51 "rygel-http-get-test.vala"
			g_critical ("rygel-http-get-test.vala:51: %s", _error_->message);
#line 791 "rygel-http-get-test.c"
			result = -1;
			_g_error_free0 (_error_);
#line 53 "rygel-http-get-test.vala"
			return result;
#line 796 "rygel-http-get-test.c"
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
#line 56 "rygel-http-get-test.vala"
	return result;
#line 808 "rygel-http-get-test.c"
}


#line 43 "rygel-http-get-test.vala"
int main (int argc, char ** argv) {
#line 814 "rygel-http-get-test.c"
	g_thread_init (NULL);
#line 43 "rygel-http-get-test.vala"
	g_type_init ();
#line 43 "rygel-http-get-test.vala"
	return rygel_http_get_test_main (argv, argc);
#line 820 "rygel-http-get-test.c"
}


#line 59 "rygel-http-get-test.vala"
RygelHTTPGetTest* rygel_http_get_test_construct (GType object_type, GError** error) {
#line 826 "rygel-http-get-test.c"
	GError * _inner_error_;
	RygelHTTPGetTest * self;
	RygelHTTPServer* _tmp0_;
	RygelHTTPServer* _tmp1_;
	RygelHTTPClient* _tmp3_;
	char* _tmp2_;
	GMainLoop* _tmp4_;
	_inner_error_ = NULL;
#line 59 "rygel-http-get-test.vala"
	self = (RygelHTTPGetTest*) g_object_new (object_type, NULL);
#line 60 "rygel-http-get-test.vala"
	_tmp0_ = rygel_http_server_new (&_inner_error_);
#line 839 "rygel-http-get-test.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
#line 60 "rygel-http-get-test.vala"
	self->server = (_tmp1_ = _tmp0_, _g_object_unref0 (self->server), _tmp1_);
#line 61 "rygel-http-get-test.vala"
	self->client = (_tmp3_ = rygel_http_client_new (self->server->context, _tmp2_ = rygel_http_server_get_uri (self->server)), _g_object_unref0 (self->client), _tmp3_);
#line 849 "rygel-http-get-test.c"
	_g_free0 (_tmp2_);
#line 63 "rygel-http-get-test.vala"
	self->priv->main_loop = (_tmp4_ = g_main_loop_new (NULL, FALSE), _g_main_loop_unref0 (self->priv->main_loop), _tmp4_);
#line 853 "rygel-http-get-test.c"
	return self;
}


#line 59 "rygel-http-get-test.vala"
RygelHTTPGetTest* rygel_http_get_test_new (GError** error) {
#line 59 "rygel-http-get-test.vala"
	return rygel_http_get_test_construct (RYGEL_TYPE_HTTP_GET_TEST, error);
#line 862 "rygel-http-get-test.c"
}


#line 120 "rygel-http-get-test.vala"
static gboolean _rygel_http_get_test_on_timeout_gsource_func (gpointer self) {
#line 868 "rygel-http-get-test.c"
	gboolean result;
	result = rygel_http_get_test_on_timeout (self);
	return result;
}


#line 94 "rygel-http-get-test.vala"
static void _rygel_http_get_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self) {
#line 877 "rygel-http-get-test.c"
	rygel_http_get_test_on_message_received (self, _sender, message);
}


#line 86 "rygel-http-get-test.vala"
static void _rygel_http_get_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 884 "rygel-http-get-test.c"
	rygel_http_get_test_on_client_completed (self, _sender);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


#line 66 "rygel-http-get-test.vala"
static void rygel_http_get_test_real_run (RygelHTTPGetTest* self, GError** error) {
#line 896 "rygel-http-get-test.c"
	GError * _inner_error_;
#line 66 "rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 900 "rygel-http-get-test.c"
	_inner_error_ = NULL;
#line 67 "rygel-http-get-test.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, _rygel_http_get_test_on_timeout_gsource_func, g_object_ref (self), g_object_unref);
#line 68 "rygel-http-get-test.vala"
	g_signal_connect_object (self->server, "message-received", (GCallback) _rygel_http_get_test_on_message_received_rygel_http_server_message_received, self, 0);
#line 69 "rygel-http-get-test.vala"
	g_signal_connect_object ((RygelStateMachine*) self->client, "completed", (GCallback) _rygel_http_get_test_on_client_completed_rygel_state_machine_completed, self, 0);
#line 71 "rygel-http-get-test.vala"
	rygel_state_machine_run ((RygelStateMachine*) self->client, NULL, NULL);
#line 73 "rygel-http-get-test.vala"
	g_main_loop_run (self->priv->main_loop);
#line 75 "rygel-http-get-test.vala"
	if (self->priv->error != NULL) {
#line 914 "rygel-http-get-test.c"
		_inner_error_ = _g_error_copy0 (self->priv->error);
		{
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


#line 66 "rygel-http-get-test.vala"
void rygel_http_get_test_run (RygelHTTPGetTest* self, GError** error) {
#line 66 "rygel-http-get-test.vala"
	RYGEL_HTTP_GET_TEST_GET_CLASS (self)->run (self, error);
#line 928 "rygel-http-get-test.c"
}


#line 80 "rygel-http-get-test.vala"
static RygelHTTPRequest* rygel_http_get_test_create_request (RygelHTTPGetTest* self, SoupMessage* msg, GError** error) {
#line 934 "rygel-http-get-test.c"
	RygelHTTPRequest* result = NULL;
#line 80 "rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 80 "rygel-http-get-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 940 "rygel-http-get-test.c"
	result = (RygelHTTPRequest*) rygel_http_get_new (self->server, gupnp_context_get_server (self->server->context), msg);
#line 81 "rygel-http-get-test.vala"
	return result;
#line 944 "rygel-http-get-test.c"
}


#line 86 "rygel-http-get-test.vala"
static void rygel_http_get_test_on_client_completed (RygelHTTPGetTest* self, RygelStateMachine* client) {
#line 86 "rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 86 "rygel-http-get-test.vala"
	g_return_if_fail (client != NULL);
#line 87 "rygel-http-get-test.vala"
	if (self->priv->server_done) {
#line 88 "rygel-http-get-test.vala"
		g_main_loop_quit (self->priv->main_loop);
#line 958 "rygel-http-get-test.c"
	}
#line 91 "rygel-http-get-test.vala"
	self->priv->client_done = TRUE;
#line 962 "rygel-http-get-test.c"
}


#line 94 "rygel-http-get-test.vala"
static void rygel_http_get_test_on_message_received (RygelHTTPGetTest* self, RygelHTTPServer* server, SoupMessage* msg) {
#line 94 "rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 94 "rygel-http-get-test.vala"
	g_return_if_fail (server != NULL);
#line 94 "rygel-http-get-test.vala"
	g_return_if_fail (msg != NULL);
#line 96 "rygel-http-get-test.vala"
	rygel_http_get_test_handle_client_message (self, msg, NULL, NULL);
#line 976 "rygel-http-get-test.c"
}


static void rygel_http_get_test_handle_client_message_data_free (gpointer _data) {
	RygelHttpGetTestHandleClientMessageData* data;
	data = _data;
	_g_object_unref0 (data->msg);
	g_object_unref (data->self);
	g_slice_free (RygelHttpGetTestHandleClientMessageData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_http_get_test_handle_client_message (RygelHTTPGetTest* self, SoupMessage* msg, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpGetTestHandleClientMessageData* _data_;
	_data_ = g_slice_new0 (RygelHttpGetTestHandleClientMessageData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_test_handle_client_message);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_test_handle_client_message_data_free);
	_data_->self = g_object_ref (self);
	_data_->msg = _g_object_ref0 (msg);
	rygel_http_get_test_handle_client_message_co (_data_);
}


static void rygel_http_get_test_handle_client_message_finish (RygelHTTPGetTest* self, GAsyncResult* _res_) {
	RygelHttpGetTestHandleClientMessageData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_get_test_handle_client_message_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetTestHandleClientMessageData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_http_get_test_handle_client_message_co (data);
}


static gboolean rygel_http_get_test_handle_client_message_co (RygelHttpGetTestHandleClientMessageData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			data->request = rygel_http_get_test_create_request (data->self, data->msg, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
			data->_state_ = 1;
			rygel_state_machine_run ((RygelStateMachine*) data->request, rygel_http_get_test_handle_client_message_ready, data);
			return FALSE;
			_state_1:
#line 103 "rygel-http-get-test.vala"
			rygel_state_machine_run_finish ((RygelStateMachine*) data->request, data->_res_);
#line 105 "rygel-http-get-test.vala"
			g_assert (((RygelHTTPRequest*) (data->_tmp0_ = data->request, RYGEL_IS_HTTP_GET (data->_tmp0_) ? ((RygelHTTPGet*) data->_tmp0_) : NULL))->item != NULL);
#line 107 "rygel-http-get-test.vala"
			if (data->self->priv->client_done) {
#line 108 "rygel-http-get-test.vala"
				g_main_loop_quit (data->self->priv->main_loop);
#line 1047 "rygel-http-get-test.c"
			}
#line 111 "rygel-http-get-test.vala"
			data->self->priv->server_done = TRUE;
#line 1051 "rygel-http-get-test.c"
			_g_object_unref0 (data->request);
		}
		goto __finally1;
		__catch1_g_error:
		{
			data->_error_ = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
#line 113 "rygel-http-get-test.vala"
				data->self->priv->error = (data->_tmp1_ = _g_error_copy0 (data->_error_), _g_error_free0 (data->self->priv->error), data->_tmp1_);
#line 114 "rygel-http-get-test.vala"
				g_main_loop_quit (data->self->priv->main_loop);
#line 1064 "rygel-http-get-test.c"
				_g_error_free0 (data->_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				_g_error_free0 (data->_error_);
			}
		}
		__finally1:
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 120 "rygel-http-get-test.vala"
static gboolean rygel_http_get_test_on_timeout (RygelHTTPGetTest* self) {
#line 1099 "rygel-http-get-test.c"
	gboolean result = FALSE;
	GError* _tmp0_;
#line 120 "rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 121 "rygel-http-get-test.vala"
	self->priv->error = (_tmp0_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_TIMEOUT, "Timeout"), _g_error_free0 (self->priv->error), _tmp0_);
#line 122 "rygel-http-get-test.vala"
	g_main_loop_quit (self->priv->main_loop);
#line 1108 "rygel-http-get-test.c"
	result = FALSE;
#line 124 "rygel-http-get-test.vala"
	return result;
#line 1112 "rygel-http-get-test.c"
}


static void rygel_http_get_test_class_init (RygelHTTPGetTestClass * klass) {
	rygel_http_get_test_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPGetTestPrivate));
	RYGEL_HTTP_GET_TEST_CLASS (klass)->run = rygel_http_get_test_real_run;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_test_finalize;
}


static void rygel_http_get_test_instance_init (RygelHTTPGetTest * self) {
	self->priv = RYGEL_HTTP_GET_TEST_GET_PRIVATE (self);
}


static void rygel_http_get_test_finalize (GObject* obj) {
	RygelHTTPGetTest * self;
	self = RYGEL_HTTP_GET_TEST (obj);
	_g_object_unref0 (self->server);
	_g_object_unref0 (self->client);
	_g_main_loop_unref0 (self->priv->main_loop);
	_g_error_free0 (self->priv->error);
	G_OBJECT_CLASS (rygel_http_get_test_parent_class)->finalize (obj);
}


GType rygel_http_get_test_get_type (void) {
	static volatile gsize rygel_http_get_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGetTest), 0, (GInstanceInitFunc) rygel_http_get_test_instance_init, NULL };
		GType rygel_http_get_test_type_id;
		rygel_http_get_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGetTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_test_type_id__volatile, rygel_http_get_test_type_id);
	}
	return rygel_http_get_test_type_id__volatile;
}


#line 166 "rygel-http-get-test.vala"
static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const char* path, GHashTable* query, SoupClientContext* client, gpointer self) {
#line 1154 "rygel-http-get-test.c"
	rygel_http_server_server_cb (self, server, msg, path, query, client);
}


#line 150 "rygel-http-get-test.vala"
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error) {
#line 1161 "rygel-http-get-test.c"
	GError * _inner_error_;
	RygelHTTPServer * self;
	RygelMediaContainer* _tmp2_;
	_inner_error_ = NULL;
#line 150 "rygel-http-get-test.vala"
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
#line 1168 "rygel-http-get-test.c"
	{
		GUPnPContext* _tmp0_;
		GUPnPContext* _tmp1_;
#line 152 "rygel-http-get-test.vala"
		_tmp0_ = gupnp_context_new (NULL, "lo", (guint) 0, &_inner_error_);
#line 1174 "rygel-http-get-test.c"
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
#line 152 "rygel-http-get-test.vala"
		self->context = (_tmp1_ = _tmp0_, _g_object_unref0 (self->context), _tmp1_);
#line 1180 "rygel-http-get-test.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP, "Network context not available");
			{
				_g_error_free0 (_error_);
				goto __finally2;
			}
			_g_error_free0 (_error_);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 157 "rygel-http-get-test.vala"
	g_assert (self->context != NULL);
#line 158 "rygel-http-get-test.vala"
	g_assert (gssdp_client_get_host_ip ((GSSDPClient*) self->context) != NULL);
#line 159 "rygel-http-get-test.vala"
	g_assert (gupnp_context_get_port (self->context) > 0);
#line 161 "rygel-http-get-test.vala"
	soup_server_add_handler (gupnp_context_get_server (self->context), RYGEL_HTTP_SERVER_SERVER_PATH, _rygel_http_server_server_cb_soup_server_callback, g_object_ref (self), g_object_unref);
#line 163 "rygel-http-get-test.vala"
	self->root_container = (_tmp2_ = rygel_media_container_new (), _rygel_media_object_unref0 (self->root_container), _tmp2_);
#line 1219 "rygel-http-get-test.c"
	return self;
}


#line 150 "rygel-http-get-test.vala"
RygelHTTPServer* rygel_http_server_new (GError** error) {
#line 150 "rygel-http-get-test.vala"
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, error);
#line 1228 "rygel-http-get-test.c"
}


#line 166 "rygel-http-get-test.vala"
static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const char* path, GHashTable* query, SoupClientContext* client) {
#line 166 "rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 166 "rygel-http-get-test.vala"
	g_return_if_fail (server != NULL);
#line 166 "rygel-http-get-test.vala"
	g_return_if_fail (msg != NULL);
#line 166 "rygel-http-get-test.vala"
	g_return_if_fail (path != NULL);
#line 166 "rygel-http-get-test.vala"
	g_return_if_fail (client != NULL);
#line 171 "rygel-http-get-test.vala"
	soup_server_pause_message (gupnp_context_get_server (self->context), msg);
#line 172 "rygel-http-get-test.vala"
	g_signal_emit_by_name (self, "message-received", msg);
#line 1248 "rygel-http-get-test.c"
}


#line 175 "rygel-http-get-test.vala"
RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const char* target, GError** error) {
#line 1254 "rygel-http-get-test.c"
	RygelTranscoder* result = NULL;
#line 175 "rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 175 "rygel-http-get-test.vala"
	g_return_val_if_fail (target != NULL, NULL);
#line 1260 "rygel-http-get-test.c"
	result = rygel_transcoder_new ();
#line 176 "rygel-http-get-test.vala"
	return result;
#line 1264 "rygel-http-get-test.c"
}


const char* rygel_http_server_get_path_root (RygelHTTPServer* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = RYGEL_HTTP_SERVER_SERVER_PATH;
#line 132 "rygel-http-get-test.vala"
	return result;
#line 1274 "rygel-http-get-test.c"
}


char* rygel_http_server_get_uri (RygelHTTPServer* self) {
	char* result;
	RygelHTTPItemURI* item_uri;
	g_return_val_if_fail (self != NULL, NULL);
#line 141 "rygel-http-get-test.vala"
	item_uri = rygel_http_item_uri_new (RYGEL_MEDIA_CONTAINER_ITEM_ID, self, -1, -1, NULL);
#line 1284 "rygel-http-get-test.c"
	result = rygel_http_item_uri_to_string (item_uri);
	_g_object_unref0 (item_uri);
#line 144 "rygel-http-get-test.vala"
	return result;
#line 1289 "rygel-http-get-test.c"
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = rygel_http_server_get_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_PATH_ROOT, g_param_spec_string ("path-root", "path-root", "path-root", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("message_received", RYGEL_TYPE_HTTP_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SOUP_TYPE_MESSAGE);
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (obj);
	_rygel_media_object_unref0 (self->root_container);
	_g_object_unref0 (self->context);
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
	switch (property_id) {
		case RYGEL_HTTP_SERVER_PATH_ROOT:
		g_value_set_string (value, rygel_http_server_get_path_root (self));
		break;
		case RYGEL_HTTP_SERVER_URI:
		g_value_take_string (value, rygel_http_server_get_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


#line 186 "rygel-http-get-test.vala"
RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context, const char* uri) {
#line 1347 "rygel-http-get-test.c"
	RygelHTTPClient * self;
	GUPnPContext* _tmp0_;
	SoupMessage* _tmp1_;
#line 186 "rygel-http-get-test.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 186 "rygel-http-get-test.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 186 "rygel-http-get-test.vala"
	self = (RygelHTTPClient*) g_object_new (object_type, NULL);
#line 188 "rygel-http-get-test.vala"
	self->context = (_tmp0_ = _g_object_ref0 (context), _g_object_unref0 (self->context), _tmp0_);
#line 190 "rygel-http-get-test.vala"
	self->msg = (_tmp1_ = soup_message_new ("GET", uri), _g_object_unref0 (self->msg), _tmp1_);
#line 191 "rygel-http-get-test.vala"
	g_assert (self->msg != NULL);
#line 1363 "rygel-http-get-test.c"
	return self;
}


#line 186 "rygel-http-get-test.vala"
RygelHTTPClient* rygel_http_client_new (GUPnPContext* context, const char* uri) {
#line 186 "rygel-http-get-test.vala"
	return rygel_http_client_construct (RYGEL_TYPE_HTTP_CLIENT, context, uri);
#line 1372 "rygel-http-get-test.c"
}


static void rygel_http_client_real_run_data_free (gpointer _data) {
	RygelHttpClientRunData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelHttpClientRunData, data);
}


static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPClient * self;
	RygelHttpClientRunData* _data_;
	self = (RygelHTTPClient*) base;
	_data_ = g_slice_new0 (RygelHttpClientRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_client_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_client_real_run_data_free);
	_data_->self = g_object_ref (self);
	rygel_http_client_real_run_co (_data_);
}


static void rygel_http_client_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpClientRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_client_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpClientRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_http_client_real_run_co (data);
}


#line 194 "rygel-http-get-test.vala"
static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self) {
#line 1412 "rygel-http-get-test.c"
	gboolean result;
	result = rygel_http_client_real_run_co (self);
	return result;
}


#line 197 "rygel-http-get-test.vala"
static void _lambda1_ (SoupSession* session, SoupMessage* msg, Block1Data* _data1_) {
#line 1421 "rygel-http-get-test.c"
	RygelHTTPClient * self;
	self = _data1_->self;
#line 197 "rygel-http-get-test.vala"
	g_return_if_fail (session != NULL);
#line 197 "rygel-http-get-test.vala"
	g_return_if_fail (msg != NULL);
#line 198 "rygel-http-get-test.vala"
	_data1_->run_continue (_data1_->run_continue_target);
#line 1430 "rygel-http-get-test.c"
}


#line 197 "rygel-http-get-test.vala"
static void __lambda1__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
#line 1436 "rygel-http-get-test.c"
	_lambda1_ (session, msg, self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		(_data1_->run_continue_target_destroy_notify == NULL) ? NULL : (_data1_->run_continue_target_destroy_notify (_data1_->run_continue_target), NULL);
		_data1_->run_continue = NULL;
		_data1_->run_continue_target = NULL;
		_data1_->run_continue_target_destroy_notify = NULL;
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_data1_ = g_slice_new0 (Block1Data);
		data->_data1_->_ref_count_ = 1;
		data->_data1_->self = g_object_ref (data->self);
		data->_data1_->_async_data_ = data;
		data->_data1_->run_continue = (data->_tmp0_ = _rygel_http_client_real_run_co_gsource_func, data->_data1_->run_continue_target = data, data->_data1_->run_continue_target_destroy_notify = NULL, data->_tmp0_);
#line 197 "rygel-http-get-test.vala"
		soup_session_queue_message (gupnp_context_get_session (data->self->context), _g_object_ref0 (data->self->msg), __lambda1__soup_session_callback, data->_data1_);
#line 1477 "rygel-http-get-test.c"
		data->_state_ = 2;
		return FALSE;
		_state_2:
		;
#line 203 "rygel-http-get-test.vala"
		g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
#line 1484 "rygel-http-get-test.c"
		block1_data_unref (data->_data1_);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static GCancellable* rygel_http_client_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPClient* self;
	self = (RygelHTTPClient*) base;
	result = self->priv->_cancellable;
#line 184 "rygel-http-get-test.vala"
	return result;
#line 1506 "rygel-http-get-test.c"
}


static void rygel_http_client_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPClient* self;
	GCancellable* _tmp0_;
	self = (RygelHTTPClient*) base;
	self->priv->_cancellable = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_cancellable), _tmp0_);
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_http_client_class_init (RygelHTTPClientClass * klass) {
	rygel_http_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPClientPrivate));
	G_OBJECT_CLASS (klass)->get_property = rygel_http_client_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_http_client_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_client_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_CLIENT_CANCELLABLE, "cancellable");
}


static void rygel_http_client_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_http_client_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = rygel_http_client_real_run;
	iface->run_finish = rygel_http_client_real_run_finish;
	iface->get_cancellable = rygel_http_client_real_get_cancellable;
	iface->set_cancellable = rygel_http_client_real_set_cancellable;
}


static void rygel_http_client_instance_init (RygelHTTPClient * self) {
	self->priv = RYGEL_HTTP_CLIENT_GET_PRIVATE (self);
}


static void rygel_http_client_finalize (GObject* obj) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (obj);
	_g_object_unref0 (self->context);
	_g_object_unref0 (self->msg);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_http_client_parent_class)->finalize (obj);
}


GType rygel_http_client_get_type (void) {
	static volatile gsize rygel_http_client_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPClient), 0, (GInstanceInitFunc) rygel_http_client_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_client_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_client_type_id;
		rygel_http_client_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPClient", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_client_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_client_type_id__volatile, rygel_http_client_type_id);
	}
	return rygel_http_client_type_id__volatile;
}


static void rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (object);
	switch (property_id) {
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (object);
	switch (property_id) {
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_media_container_find_object_data_free (gpointer _data) {
	RygelMediaContainerFindObjectData* data;
	data = _data;
	_g_free0 (data->item_id);
	_g_object_unref0 (data->cancellable);
	_rygel_media_object_unref0 (data->result);
	rygel_media_object_unref (data->self);
	g_slice_free (RygelMediaContainerFindObjectData, data);
}


void rygel_media_container_find_object (RygelMediaContainer* self, const char* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaContainerFindObjectData* _data_;
	_data_ = g_slice_new0 (RygelMediaContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_media_container_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_container_find_object_data_free);
	_data_->self = rygel_media_object_ref (self);
	_data_->item_id = g_strdup (item_id);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_container_find_object_co (_data_);
}


RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaContainerFindObjectData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_container_find_object_co (data);
}


#line 210 "rygel-http-get-test.vala"
static gboolean _rygel_media_container_find_object_co_gsource_func (gpointer self) {
#line 1641 "rygel-http-get-test.c"
	gboolean result;
	result = rygel_media_container_find_object_co (self);
	return result;
}


#line 214 "rygel-http-get-test.vala"
static gboolean _lambda0_ (Block2Data* _data2_) {
#line 1650 "rygel-http-get-test.c"
	RygelMediaContainer * self;
	gboolean result = FALSE;
	self = _data2_->self;
#line 215 "rygel-http-get-test.vala"
	_data2_->find_object_continue (_data2_->find_object_continue_target);
#line 1656 "rygel-http-get-test.c"
	result = FALSE;
#line 217 "rygel-http-get-test.vala"
	return result;
#line 1660 "rygel-http-get-test.c"
}


#line 214 "rygel-http-get-test.vala"
static gboolean __lambda0__gsource_func (gpointer self) {
#line 1666 "rygel-http-get-test.c"
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_rygel_media_object_unref0 (_data2_->self);
		(_data2_->find_object_continue_target_destroy_notify == NULL) ? NULL : (_data2_->find_object_continue_target_destroy_notify (_data2_->find_object_continue_target), NULL);
		_data2_->find_object_continue = NULL;
		_data2_->find_object_continue_target = NULL;
		_data2_->find_object_continue_target_destroy_notify = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_data2_ = g_slice_new0 (Block2Data);
		data->_data2_->_ref_count_ = 1;
		data->_data2_->self = rygel_media_object_ref (data->self);
		data->_data2_->_async_data_ = data;
		data->_data2_->find_object_continue = (data->_tmp0_ = _rygel_media_container_find_object_co_gsource_func, data->_data2_->find_object_continue_target = data, data->_data2_->find_object_continue_target_destroy_notify = NULL, data->_tmp0_);
#line 214 "rygel-http-get-test.vala"
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda0__gsource_func, block2_data_ref (data->_data2_), block2_data_unref);
#line 1709 "rygel-http-get-test.c"
		data->_state_ = 3;
		return FALSE;
		_state_3:
		;
#line 222 "rygel-http-get-test.vala"
		if (_vala_strcmp0 (data->item_id, RYGEL_MEDIA_CONTAINER_ITEM_ID) == 0) {
#line 1716 "rygel-http-get-test.c"
			data->result = (RygelMediaObject*) rygel_media_item_new ();
			block2_data_unref (data->_data2_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			data->result = NULL;
			block2_data_unref (data->_data2_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		block2_data_unref (data->_data2_);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 207 "rygel-http-get-test.vala"
RygelMediaContainer* rygel_media_container_construct (GType object_type) {
#line 1757 "rygel-http-get-test.c"
	RygelMediaContainer* self;
#line 207 "rygel-http-get-test.vala"
	self = (RygelMediaContainer*) rygel_media_object_construct (object_type);
#line 1761 "rygel-http-get-test.c"
	return self;
}


#line 207 "rygel-http-get-test.vala"
RygelMediaContainer* rygel_media_container_new (void) {
#line 207 "rygel-http-get-test.vala"
	return rygel_media_container_construct (RYGEL_TYPE_MEDIA_CONTAINER);
#line 1770 "rygel-http-get-test.c"
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
}


GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}


#line 231 "rygel-http-get-test.vala"
RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* get_request) {
#line 1797 "rygel-http-get-test.c"
	RygelHTTPResponse* result = NULL;
#line 231 "rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 231 "rygel-http-get-test.vala"
	g_return_val_if_fail (get_request != NULL, NULL);
#line 1803 "rygel-http-get-test.c"
	result = rygel_http_response_new (get_request);
#line 232 "rygel-http-get-test.vala"
	return result;
#line 1807 "rygel-http-get-test.c"
}


#line 235 "rygel-http-get-test.vala"
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* get_request) {
#line 235 "rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 235 "rygel-http-get-test.vala"
	g_return_if_fail (get_request != NULL);
#line 1817 "rygel-http-get-test.c"
}


#line 230 "rygel-http-get-test.vala"
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type) {
#line 1823 "rygel-http-get-test.c"
	RygelHTTPGetHandler* self;
	self = (RygelHTTPGetHandler*) g_type_create_instance (object_type);
	return self;
}


static void rygel_value_http_get_handler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_http_get_handler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_http_get_handler_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_http_get_handler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_http_get_handler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_http_get_handler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_http_get_handler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelHTTPGetHandler* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_http_get_handler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_http_get_handler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelHTTPGetHandler** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_http_get_handler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_http_get_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecHTTPGetHandler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_HTTP_GET_HANDLER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_http_get_handler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_http_get_handler (GValue* value, gpointer v_object) {
	RygelHTTPGetHandler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_HTTP_GET_HANDLER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_http_get_handler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_http_get_handler_unref (old);
	}
}


void rygel_value_take_http_get_handler (GValue* value, gpointer v_object) {
	RygelHTTPGetHandler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_HTTP_GET_HANDLER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_http_get_handler_unref (old);
	}
}


static void rygel_http_get_handler_class_init (RygelHTTPGetHandlerClass * klass) {
	rygel_http_get_handler_parent_class = g_type_class_peek_parent (klass);
	RYGEL_HTTP_GET_HANDLER_CLASS (klass)->finalize = rygel_http_get_handler_finalize;
}


static void rygel_http_get_handler_instance_init (RygelHTTPGetHandler * self) {
	self->ref_count = 1;
}


static void rygel_http_get_handler_finalize (RygelHTTPGetHandler* obj) {
	RygelHTTPGetHandler * self;
	self = RYGEL_HTTP_GET_HANDLER (obj);
}


GType rygel_http_get_handler_get_type (void) {
	static volatile gsize rygel_http_get_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_handler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_http_get_handler_init, rygel_value_http_get_handler_free_value, rygel_value_http_get_handler_copy_value, rygel_value_http_get_handler_peek_pointer, "p", rygel_value_http_get_handler_collect_value, "p", rygel_value_http_get_handler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGetHandler), 0, (GInstanceInitFunc) rygel_http_get_handler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_http_get_handler_type_id;
		rygel_http_get_handler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelHTTPGetHandler", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_http_get_handler_type_id__volatile, rygel_http_get_handler_type_id);
	}
	return rygel_http_get_handler_type_id__volatile;
}


gpointer rygel_http_get_handler_ref (gpointer instance) {
	RygelHTTPGetHandler* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_http_get_handler_unref (gpointer instance) {
	RygelHTTPGetHandler* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


#line 239 "rygel-http-get-test.vala"
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type, RygelTranscoder* transcoder, GCancellable* cancellable) {
#line 1991 "rygel-http-get-test.c"
	RygelHTTPTranscodeHandler* self;
#line 239 "rygel-http-get-test.vala"
	g_return_val_if_fail (transcoder != NULL, NULL);
#line 239 "rygel-http-get-test.vala"
	g_return_val_if_fail (cancellable != NULL, NULL);
#line 239 "rygel-http-get-test.vala"
	self = (RygelHTTPTranscodeHandler*) rygel_http_get_handler_construct (object_type);
#line 1999 "rygel-http-get-test.c"
	return self;
}


#line 239 "rygel-http-get-test.vala"
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (RygelTranscoder* transcoder, GCancellable* cancellable) {
#line 239 "rygel-http-get-test.vala"
	return rygel_http_transcode_handler_construct (RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, transcoder, cancellable);
#line 2008 "rygel-http-get-test.c"
}


static void rygel_http_transcode_handler_class_init (RygelHTTPTranscodeHandlerClass * klass) {
	rygel_http_transcode_handler_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_http_transcode_handler_instance_init (RygelHTTPTranscodeHandler * self) {
}


GType rygel_http_transcode_handler_get_type (void) {
	static volatile gsize rygel_http_transcode_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_transcode_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTranscodeHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_transcode_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTranscodeHandler), 0, (GInstanceInitFunc) rygel_http_transcode_handler_instance_init, NULL };
		GType rygel_http_transcode_handler_type_id;
		rygel_http_transcode_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPTranscodeHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_transcode_handler_type_id__volatile, rygel_http_transcode_handler_type_id);
	}
	return rygel_http_transcode_handler_type_id__volatile;
}


#line 244 "rygel-http-get-test.vala"
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable) {
#line 2035 "rygel-http-get-test.c"
	RygelHTTPIdentityHandler* self;
#line 244 "rygel-http-get-test.vala"
	g_return_val_if_fail (cancellable != NULL, NULL);
#line 244 "rygel-http-get-test.vala"
	self = (RygelHTTPIdentityHandler*) rygel_http_get_handler_construct (object_type);
#line 2041 "rygel-http-get-test.c"
	return self;
}


#line 244 "rygel-http-get-test.vala"
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable) {
#line 244 "rygel-http-get-test.vala"
	return rygel_http_identity_handler_construct (RYGEL_TYPE_HTTP_IDENTITY_HANDLER, cancellable);
#line 2050 "rygel-http-get-test.c"
}


static void rygel_http_identity_handler_class_init (RygelHTTPIdentityHandlerClass * klass) {
	rygel_http_identity_handler_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_http_identity_handler_instance_init (RygelHTTPIdentityHandler * self) {
}


GType rygel_http_identity_handler_get_type (void) {
	static volatile gsize rygel_http_identity_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_identity_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPIdentityHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_identity_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPIdentityHandler), 0, (GInstanceInitFunc) rygel_http_identity_handler_instance_init, NULL };
		GType rygel_http_identity_handler_type_id;
		rygel_http_identity_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPIdentityHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_identity_handler_type_id__volatile, rygel_http_identity_handler_type_id);
	}
	return rygel_http_identity_handler_type_id__volatile;
}


#line 253 "rygel-http-get-test.vala"
gboolean rygel_media_item_should_stream (RygelMediaItem* self) {
#line 2077 "rygel-http-get-test.c"
	gboolean result = FALSE;
#line 253 "rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2081 "rygel-http-get-test.c"
	result = TRUE;
#line 254 "rygel-http-get-test.vala"
	return result;
#line 2085 "rygel-http-get-test.c"
}


#line 247 "rygel-http-get-test.vala"
RygelMediaItem* rygel_media_item_construct (GType object_type) {
#line 2091 "rygel-http-get-test.c"
	RygelMediaItem* self;
#line 247 "rygel-http-get-test.vala"
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
#line 2095 "rygel-http-get-test.c"
	return self;
}


#line 247 "rygel-http-get-test.vala"
RygelMediaItem* rygel_media_item_new (void) {
#line 247 "rygel-http-get-test.vala"
	return rygel_media_item_construct (RYGEL_TYPE_MEDIA_ITEM);
#line 2104 "rygel-http-get-test.c"
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	self->size = (glong) 1024;
	self->duration = (glong) 1024;
	self->subtitles = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) rygel_subtitle_ref, rygel_subtitle_unref, NULL);
	self->thumbnails = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_thumbnail_ref, rygel_thumbnail_unref, NULL);
}


static void rygel_media_item_finalize (RygelMediaObject* obj) {
	RygelMediaItem * self;
	self = RYGEL_MEDIA_ITEM (obj);
	_g_object_unref0 (self->subtitles);
	_g_object_unref0 (self->thumbnails);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


#line 258 "rygel-http-get-test.vala"
RygelThumbnail* rygel_thumbnail_construct (GType object_type) {
#line 2145 "rygel-http-get-test.c"
	RygelThumbnail* self;
	self = (RygelThumbnail*) g_type_create_instance (object_type);
	return self;
}


#line 258 "rygel-http-get-test.vala"
RygelThumbnail* rygel_thumbnail_new (void) {
#line 258 "rygel-http-get-test.vala"
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL);
#line 2156 "rygel-http-get-test.c"
}


static void rygel_value_thumbnail_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_thumbnail_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_thumbnail_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_thumbnail_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_thumbnail_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_thumbnail_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_thumbnail_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelThumbnail* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_thumbnail_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_thumbnail_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelThumbnail** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_thumbnail_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecThumbnail* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_THUMBNAIL), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_thumbnail (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_thumbnail (GValue* value, gpointer v_object) {
	RygelThumbnail* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_THUMBNAIL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_thumbnail_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_thumbnail_unref (old);
	}
}


void rygel_value_take_thumbnail (GValue* value, gpointer v_object) {
	RygelThumbnail* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_THUMBNAIL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_thumbnail_unref (old);
	}
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
	RYGEL_THUMBNAIL_CLASS (klass)->finalize = rygel_thumbnail_finalize;
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
	self->size = (glong) 1024;
	self->ref_count = 1;
}


static void rygel_thumbnail_finalize (RygelThumbnail* obj) {
	RygelThumbnail * self;
	self = RYGEL_THUMBNAIL (obj);
}


GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_thumbnail_init, rygel_value_thumbnail_free_value, rygel_value_thumbnail_copy_value, rygel_value_thumbnail_peek_pointer, "p", rygel_value_thumbnail_collect_value, "p", rygel_value_thumbnail_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelThumbnail", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}


gpointer rygel_thumbnail_ref (gpointer instance) {
	RygelThumbnail* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_thumbnail_unref (gpointer instance) {
	RygelThumbnail* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_THUMBNAIL_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


#line 262 "rygel-http-get-test.vala"
RygelSubtitle* rygel_subtitle_construct (GType object_type) {
#line 2322 "rygel-http-get-test.c"
	RygelSubtitle* self;
	self = (RygelSubtitle*) g_type_create_instance (object_type);
	return self;
}


#line 262 "rygel-http-get-test.vala"
RygelSubtitle* rygel_subtitle_new (void) {
#line 262 "rygel-http-get-test.vala"
	return rygel_subtitle_construct (RYGEL_TYPE_SUBTITLE);
#line 2333 "rygel-http-get-test.c"
}


static void rygel_value_subtitle_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_subtitle_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_subtitle_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_subtitle_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_subtitle_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_subtitle_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_subtitle_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelSubtitle* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_subtitle_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_subtitle_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelSubtitle** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_subtitle_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecSubtitle* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_SUBTITLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_subtitle (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_subtitle (GValue* value, gpointer v_object) {
	RygelSubtitle* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_SUBTITLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_subtitle_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_subtitle_unref (old);
	}
}


void rygel_value_take_subtitle (GValue* value, gpointer v_object) {
	RygelSubtitle* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_SUBTITLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_subtitle_unref (old);
	}
}


static void rygel_subtitle_class_init (RygelSubtitleClass * klass) {
	rygel_subtitle_parent_class = g_type_class_peek_parent (klass);
	RYGEL_SUBTITLE_CLASS (klass)->finalize = rygel_subtitle_finalize;
}


static void rygel_subtitle_instance_init (RygelSubtitle * self) {
	self->size = (glong) 1024;
	self->ref_count = 1;
}


static void rygel_subtitle_finalize (RygelSubtitle* obj) {
	RygelSubtitle * self;
	self = RYGEL_SUBTITLE (obj);
}


GType rygel_subtitle_get_type (void) {
	static volatile gsize rygel_subtitle_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_subtitle_init, rygel_value_subtitle_free_value, rygel_value_subtitle_copy_value, rygel_value_subtitle_peek_pointer, "p", rygel_value_subtitle_collect_value, "p", rygel_value_subtitle_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitle), 0, (GInstanceInitFunc) rygel_subtitle_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_subtitle_type_id;
		rygel_subtitle_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelSubtitle", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_subtitle_type_id__volatile, rygel_subtitle_type_id);
	}
	return rygel_subtitle_type_id__volatile;
}


gpointer rygel_subtitle_ref (gpointer instance) {
	RygelSubtitle* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_subtitle_unref (gpointer instance) {
	RygelSubtitle* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_SUBTITLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


#line 272 "rygel-http-get-test.vala"
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* get_request) {
#line 2499 "rygel-http-get-test.c"
	RygelHTTPResponse * self;
	SoupMessage* _tmp0_;
	SoupServer* _tmp1_;
#line 272 "rygel-http-get-test.vala"
	g_return_val_if_fail (get_request != NULL, NULL);
#line 272 "rygel-http-get-test.vala"
	self = (RygelHTTPResponse*) g_object_new (object_type, NULL);
#line 273 "rygel-http-get-test.vala"
	self->priv->msg = (_tmp0_ = _g_object_ref0 (((RygelHTTPRequest*) get_request)->msg), _g_object_unref0 (self->priv->msg), _tmp0_);
#line 274 "rygel-http-get-test.vala"
	self->priv->server = (_tmp1_ = _g_object_ref0 (((RygelHTTPRequest*) get_request)->server), _g_object_unref0 (self->priv->server), _tmp1_);
#line 2511 "rygel-http-get-test.c"
	return self;
}


#line 272 "rygel-http-get-test.vala"
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* get_request) {
#line 272 "rygel-http-get-test.vala"
	return rygel_http_response_construct (RYGEL_TYPE_HTTP_RESPONSE, get_request);
#line 2520 "rygel-http-get-test.c"
}


static void rygel_http_response_real_run_data_free (gpointer _data) {
	RygelHttpResponseRunData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelHttpResponseRunData, data);
}


static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPResponse * self;
	RygelHttpResponseRunData* _data_;
	self = (RygelHTTPResponse*) base;
	_data_ = g_slice_new0 (RygelHttpResponseRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_response_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_response_real_run_data_free);
	_data_->self = g_object_ref (self);
	rygel_http_response_real_run_co (_data_);
}


static void rygel_http_response_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpResponseRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_response_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpResponseRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_http_response_real_run_co (data);
}


#line 277 "rygel-http-get-test.vala"
static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self) {
#line 2560 "rygel-http-get-test.c"
	gboolean result;
	result = rygel_http_response_real_run_co (self);
	return result;
}


#line 280 "rygel-http-get-test.vala"
static gboolean _lambda2_ (Block3Data* _data3_) {
#line 2569 "rygel-http-get-test.c"
	RygelHTTPResponse * self;
	gboolean result = FALSE;
	self = _data3_->self;
#line 281 "rygel-http-get-test.vala"
	_data3_->run_continue (_data3_->run_continue_target);
#line 2575 "rygel-http-get-test.c"
	result = FALSE;
#line 283 "rygel-http-get-test.vala"
	return result;
#line 2579 "rygel-http-get-test.c"
}


#line 280 "rygel-http-get-test.vala"
static gboolean __lambda2__gsource_func (gpointer self) {
#line 2585 "rygel-http-get-test.c"
	gboolean result;
	result = _lambda2_ (self);
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		(_data3_->run_continue_target_destroy_notify == NULL) ? NULL : (_data3_->run_continue_target_destroy_notify (_data3_->run_continue_target), NULL);
		_data3_->run_continue = NULL;
		_data3_->run_continue_target = NULL;
		_data3_->run_continue_target_destroy_notify = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_data3_ = g_slice_new0 (Block3Data);
		data->_data3_->_ref_count_ = 1;
		data->_data3_->self = g_object_ref (data->self);
		data->_data3_->_async_data_ = data;
		data->_data3_->run_continue = (data->_tmp0_ = _rygel_http_response_real_run_co_gsource_func, data->_data3_->run_continue_target = data, data->_data3_->run_continue_target_destroy_notify = NULL, data->_tmp0_);
#line 280 "rygel-http-get-test.vala"
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda2__gsource_func, block3_data_ref (data->_data3_), block3_data_unref);
#line 2628 "rygel-http-get-test.c"
		data->_state_ = 4;
		return FALSE;
		_state_4:
		;
#line 288 "rygel-http-get-test.vala"
		soup_message_set_status (data->self->priv->msg, (guint) SOUP_STATUS_OK);
#line 289 "rygel-http-get-test.vala"
		soup_server_unpause_message (data->self->priv->server, data->self->priv->msg);
#line 291 "rygel-http-get-test.vala"
		g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
#line 2639 "rygel-http-get-test.c"
		block3_data_unref (data->_data3_);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static GCancellable* rygel_http_response_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPResponse* self;
	self = (RygelHTTPResponse*) base;
	result = self->priv->_cancellable;
#line 267 "rygel-http-get-test.vala"
	return result;
#line 2661 "rygel-http-get-test.c"
}


static void rygel_http_response_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPResponse* self;
	GCancellable* _tmp0_;
	self = (RygelHTTPResponse*) base;
	self->priv->_cancellable = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_cancellable), _tmp0_);
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_http_response_class_init (RygelHTTPResponseClass * klass) {
	rygel_http_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPResponsePrivate));
	G_OBJECT_CLASS (klass)->get_property = rygel_http_response_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_http_response_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_response_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_RESPONSE_CANCELLABLE, "cancellable");
}


static void rygel_http_response_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_http_response_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = rygel_http_response_real_run;
	iface->run_finish = rygel_http_response_real_run_finish;
	iface->get_cancellable = rygel_http_response_real_get_cancellable;
	iface->set_cancellable = rygel_http_response_real_set_cancellable;
}


static void rygel_http_response_instance_init (RygelHTTPResponse * self) {
	self->priv = RYGEL_HTTP_RESPONSE_GET_PRIVATE (self);
}


static void rygel_http_response_finalize (GObject* obj) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (obj);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->priv->msg);
	_g_object_unref0 (self->priv->server);
	G_OBJECT_CLASS (rygel_http_response_parent_class)->finalize (obj);
}


GType rygel_http_response_get_type (void) {
	static volatile gsize rygel_http_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPResponse), 0, (GInstanceInitFunc) rygel_http_response_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_response_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_response_type_id;
		rygel_http_response_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPResponse", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_response_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_response_type_id__volatile, rygel_http_response_type_id);
	}
	return rygel_http_response_type_id__volatile;
}


static void rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (object);
	switch (property_id) {
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (object);
	switch (property_id) {
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


#line 296 "rygel-http-get-test.vala"
RygelTranscoder* rygel_transcoder_construct (GType object_type) {
#line 2752 "rygel-http-get-test.c"
	RygelTranscoder* self;
	self = (RygelTranscoder*) g_type_create_instance (object_type);
	return self;
}


#line 296 "rygel-http-get-test.vala"
RygelTranscoder* rygel_transcoder_new (void) {
#line 296 "rygel-http-get-test.vala"
	return rygel_transcoder_construct (RYGEL_TYPE_TRANSCODER);
#line 2763 "rygel-http-get-test.c"
}


static void rygel_value_transcoder_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_transcoder_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_transcoder_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_transcoder_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_transcoder_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_transcoder_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_transcoder_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelTranscoder* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_transcoder_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_transcoder_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelTranscoder** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_transcoder_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_transcoder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecTranscoder* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_TRANSCODER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_transcoder (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TRANSCODER), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_transcoder (GValue* value, gpointer v_object) {
	RygelTranscoder* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TRANSCODER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_TRANSCODER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_transcoder_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_transcoder_unref (old);
	}
}


void rygel_value_take_transcoder (GValue* value, gpointer v_object) {
	RygelTranscoder* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TRANSCODER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_TRANSCODER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_transcoder_unref (old);
	}
}


static void rygel_transcoder_class_init (RygelTranscoderClass * klass) {
	rygel_transcoder_parent_class = g_type_class_peek_parent (klass);
	RYGEL_TRANSCODER_CLASS (klass)->finalize = rygel_transcoder_finalize;
}


static void rygel_transcoder_instance_init (RygelTranscoder * self) {
	self->ref_count = 1;
}


static void rygel_transcoder_finalize (RygelTranscoder* obj) {
	RygelTranscoder * self;
	self = RYGEL_TRANSCODER (obj);
}


GType rygel_transcoder_get_type (void) {
	static volatile gsize rygel_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transcoder_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_transcoder_init, rygel_value_transcoder_free_value, rygel_value_transcoder_copy_value, rygel_value_transcoder_peek_pointer, "p", rygel_value_transcoder_collect_value, "p", rygel_value_transcoder_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTranscoder), 0, (GInstanceInitFunc) rygel_transcoder_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_transcoder_type_id;
		rygel_transcoder_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelTranscoder", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_transcoder_type_id__volatile, rygel_transcoder_type_id);
	}
	return rygel_transcoder_type_id__volatile;
}


gpointer rygel_transcoder_ref (gpointer instance) {
	RygelTranscoder* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_transcoder_unref (gpointer instance) {
	RygelTranscoder* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_TRANSCODER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


#line 297 "rygel-http-get-test.vala"
RygelMediaObject* rygel_media_object_construct (GType object_type) {
#line 2928 "rygel-http-get-test.c"
	RygelMediaObject* self;
	self = (RygelMediaObject*) g_type_create_instance (object_type);
	return self;
}


#line 297 "rygel-http-get-test.vala"
RygelMediaObject* rygel_media_object_new (void) {
#line 297 "rygel-http-get-test.vala"
	return rygel_media_object_construct (RYGEL_TYPE_MEDIA_OBJECT);
#line 2939 "rygel-http-get-test.c"
}


static void rygel_value_media_object_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_media_object_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_media_object_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_media_object_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_media_object_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_media_object_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_media_object_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelMediaObject* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_media_object_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_media_object_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelMediaObject** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_media_object_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecMediaObject* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_MEDIA_OBJECT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_media_object (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_media_object (GValue* value, gpointer v_object) {
	RygelMediaObject* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_OBJECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_media_object_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_media_object_unref (old);
	}
}


void rygel_value_take_media_object (GValue* value, gpointer v_object) {
	RygelMediaObject* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_OBJECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_media_object_unref (old);
	}
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
	self->ref_count = 1;
}


static void rygel_media_object_finalize (RygelMediaObject* obj) {
	RygelMediaObject * self;
	self = RYGEL_MEDIA_OBJECT (obj);
}


GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_media_object_init, rygel_value_media_object_free_value, rygel_value_media_object_copy_value, rygel_value_media_object_peek_pointer, "p", rygel_value_media_object_collect_value, "p", rygel_value_media_object_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelMediaObject", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


gpointer rygel_media_object_ref (gpointer instance) {
	RygelMediaObject* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_media_object_unref (gpointer instance) {
	RygelMediaObject* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_MEDIA_OBJECT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




