/* rygel-media-export-item.c generated by valac 0.9.6, the Vala compiler
 * generated from rygel-media-export-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-dlna/gupnp-dlna-information.h>
#include <gst/discoverer/gstdiscoverer.h>
#include <gst/gst.h>
#include <gst/tag/tag.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER (rygel_media_export_jpeg_writer_get_type ())
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriter))
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriterClass))
#define RYGEL_MEDIA_EXPORT_IS_JPEG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER))
#define RYGEL_MEDIA_EXPORT_IS_JPEG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER))
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriterClass))

typedef struct _RygelMediaExportJPEGWriter RygelMediaExportJPEGWriter;
typedef struct _RygelMediaExportJPEGWriterClass RygelMediaExportJPEGWriterClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))



RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, const char* mime, guint64 size, guint64 mtime);
char* rygel_media_export_media_cache_get_id (GFile* file);
RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GUPnPDLNAInformation* dlna_info, const char* mime, guint64 size, guint64 mtime);
RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelPhotoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamVideoInformation* video_info, const char* mime, guint64 size, guint64 mtime);
RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelVideoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamVideoInformation* video_info, GstStreamAudioInformation* audio_info, const char* mime, guint64 size, guint64 mtime);
RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMusicItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamAudioInformation* audio_info, const char* mime, guint64 size, guint64 mtime);
void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GUPnPDLNAInformation* dlna_info, GstStreamAudioInformation* audio_info);
void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, const char* mime, guint64 size, guint64 mtime);
RygelMediaExportJPEGWriter* rygel_media_export_jpeg_writer_new (GError** error);
RygelMediaExportJPEGWriter* rygel_media_export_jpeg_writer_construct (GType object_type, GError** error);
GType rygel_media_export_jpeg_writer_get_type (void) G_GNUC_CONST;
void rygel_media_export_jpeg_writer_write (RygelMediaExportJPEGWriter* self, GstBuffer* buffer, GFile* file);



#line 31 "rygel-media-export-item.vala"
RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, const char* mime, guint64 size, guint64 mtime) {
#line 73 "rygel-media-export-item.c"
	RygelMediaItem* result = NULL;
	char* title;
	RygelMediaItem* item;
	char* _tmp6_;
	char* _tmp7_;
#line 31 "rygel-media-export-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 31 "rygel-media-export-item.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 31 "rygel-media-export-item.vala"
	g_return_val_if_fail (mime != NULL, NULL);
#line 36 "rygel-media-export-item.vala"
	title = g_file_get_basename (file);
#line 87 "rygel-media-export-item.c"
	item = NULL;
#line 39 "rygel-media-export-item.vala"
	if (g_str_has_prefix (mime, "video/")) {
#line 91 "rygel-media-export-item.c"
		char* _tmp0_;
		RygelMediaItem* _tmp1_;
#line 40 "rygel-media-export-item.vala"
		item = (_tmp1_ = (RygelMediaItem*) rygel_video_item_new (_tmp0_ = rygel_media_export_media_cache_get_id (file), parent, title, RYGEL_VIDEO_ITEM_UPNP_CLASS), _g_object_unref0 (item), _tmp1_);
#line 96 "rygel-media-export-item.c"
		_g_free0 (_tmp0_);
	} else {
#line 41 "rygel-media-export-item.vala"
		if (g_str_has_prefix (mime, "image/")) {
#line 101 "rygel-media-export-item.c"
			char* _tmp2_;
			RygelMediaItem* _tmp3_;
#line 42 "rygel-media-export-item.vala"
			item = (_tmp3_ = (RygelMediaItem*) rygel_photo_item_new (_tmp2_ = rygel_media_export_media_cache_get_id (file), parent, title, RYGEL_PHOTO_ITEM_UPNP_CLASS), _g_object_unref0 (item), _tmp3_);
#line 106 "rygel-media-export-item.c"
			_g_free0 (_tmp2_);
		} else {
			char* _tmp4_;
			RygelMediaItem* _tmp5_;
#line 44 "rygel-media-export-item.vala"
			item = (_tmp5_ = (RygelMediaItem*) rygel_music_item_new (_tmp4_ = rygel_media_export_media_cache_get_id (file), parent, title, RYGEL_MUSIC_ITEM_UPNP_CLASS), _g_object_unref0 (item), _tmp5_);
#line 113 "rygel-media-export-item.c"
			_g_free0 (_tmp4_);
		}
	}
#line 47 "rygel-media-export-item.vala"
	item->mime_type = (_tmp6_ = g_strdup (mime), _g_free0 (item->mime_type), _tmp6_);
#line 48 "rygel-media-export-item.vala"
	item->size = (gint64) size;
#line 49 "rygel-media-export-item.vala"
	((RygelMediaObject*) item)->modified = mtime;
#line 50 "rygel-media-export-item.vala"
	rygel_media_item_add_uri (item, _tmp7_ = g_file_get_uri (file));
#line 125 "rygel-media-export-item.c"
	_g_free0 (_tmp7_);
	result = item;
	_g_free0 (title);
#line 52 "rygel-media-export-item.vala"
	return result;
#line 131 "rygel-media-export-item.c"
}


#line 55 "rygel-media-export-item.vala"
RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GUPnPDLNAInformation* dlna_info, const char* mime, guint64 size, guint64 mtime) {
#line 137 "rygel-media-export-item.c"
	RygelMediaItem* result = NULL;
	RygelMediaItem* item;
	char* id;
	GstStreamAudioInformation* audio_info;
	GstStreamVideoInformation* video_info;
#line 55 "rygel-media-export-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 55 "rygel-media-export-item.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 55 "rygel-media-export-item.vala"
	g_return_val_if_fail (dlna_info != NULL, NULL);
#line 55 "rygel-media-export-item.vala"
	g_return_val_if_fail (mime != NULL, NULL);
#line 151 "rygel-media-export-item.c"
	item = NULL;
#line 62 "rygel-media-export-item.vala"
	id = rygel_media_export_media_cache_get_id (file);
#line 63 "rygel-media-export-item.vala"
	audio_info = NULL;
#line 64 "rygel-media-export-item.vala"
	video_info = NULL;
#line 159 "rygel-media-export-item.c"
	{
		GList* stream_info_collection;
		GList* stream_info_it;
#line 66 "rygel-media-export-item.vala"
		stream_info_collection = gupnp_dlna_information_get_info (dlna_info)->stream_list;
#line 165 "rygel-media-export-item.c"
		for (stream_info_it = stream_info_collection; stream_info_it != NULL; stream_info_it = stream_info_it->next) {
			GstStreamInformation* stream_info;
#line 66 "rygel-media-export-item.vala"
			stream_info = (GstStreamInformation*) stream_info_it->data;
#line 170 "rygel-media-export-item.c"
			{
				gboolean _tmp0_ = FALSE;
#line 68 "rygel-media-export-item.vala"
				if (audio_info == NULL) {
#line 69 "rygel-media-export-item.vala"
					_tmp0_ = stream_info->streamtype == GST_STREAM_AUDIO;
#line 177 "rygel-media-export-item.c"
				} else {
#line 68 "rygel-media-export-item.vala"
					_tmp0_ = FALSE;
#line 181 "rygel-media-export-item.c"
				}
#line 68 "rygel-media-export-item.vala"
				if (_tmp0_) {
#line 70 "rygel-media-export-item.vala"
					audio_info = (GstStreamAudioInformation*) stream_info;
#line 187 "rygel-media-export-item.c"
				} else {
					gboolean _tmp1_ = FALSE;
#line 71 "rygel-media-export-item.vala"
					if (video_info == NULL) {
#line 192 "rygel-media-export-item.c"
						gboolean _tmp2_ = FALSE;
#line 72 "rygel-media-export-item.vala"
						if (stream_info->streamtype == GST_STREAM_VIDEO) {
#line 72 "rygel-media-export-item.vala"
							_tmp2_ = TRUE;
#line 198 "rygel-media-export-item.c"
						} else {
#line 73 "rygel-media-export-item.vala"
							_tmp2_ = stream_info->streamtype == GST_STREAM_IMAGE;
#line 202 "rygel-media-export-item.c"
						}
#line 72 "rygel-media-export-item.vala"
						_tmp1_ = _tmp2_;
#line 206 "rygel-media-export-item.c"
					} else {
#line 71 "rygel-media-export-item.vala"
						_tmp1_ = FALSE;
#line 210 "rygel-media-export-item.c"
					}
#line 71 "rygel-media-export-item.vala"
					if (_tmp1_) {
#line 74 "rygel-media-export-item.vala"
						video_info = (GstStreamVideoInformation*) stream_info;
#line 216 "rygel-media-export-item.c"
					}
				}
			}
		}
	}
#line 78 "rygel-media-export-item.vala"
	if (video_info != NULL) {
#line 224 "rygel-media-export-item.c"
		gboolean _tmp3_ = FALSE;
#line 79 "rygel-media-export-item.vala"
		if (audio_info == NULL) {
#line 80 "rygel-media-export-item.vala"
			_tmp3_ = ((GstStreamInformation*) video_info)->streamtype == GST_STREAM_IMAGE;
#line 230 "rygel-media-export-item.c"
		} else {
#line 79 "rygel-media-export-item.vala"
			_tmp3_ = FALSE;
#line 234 "rygel-media-export-item.c"
		}
#line 79 "rygel-media-export-item.vala"
		if (_tmp3_) {
#line 238 "rygel-media-export-item.c"
			RygelMediaItem* _tmp4_;
			RygelMediaItem* _tmp5_;
#line 81 "rygel-media-export-item.vala"
			item = (_tmp4_ = (RygelMediaItem*) rygel_photo_item_new (id, parent, "", RYGEL_PHOTO_ITEM_UPNP_CLASS), _g_object_unref0 (item), _tmp4_);
#line 243 "rygel-media-export-item.c"
			result = rygel_media_export_item_factory_fill_photo_item ((_tmp5_ = item, RYGEL_IS_PHOTO_ITEM (_tmp5_) ? ((RygelPhotoItem*) _tmp5_) : NULL), file, dlna_info, video_info, mime, size, mtime);
			_g_free0 (id);
			_g_object_unref0 (item);
#line 82 "rygel-media-export-item.vala"
			return result;
#line 249 "rygel-media-export-item.c"
		} else {
			RygelMediaItem* _tmp6_;
			RygelMediaItem* _tmp7_;
#line 90 "rygel-media-export-item.vala"
			item = (_tmp6_ = (RygelMediaItem*) rygel_video_item_new (id, parent, "", RYGEL_VIDEO_ITEM_UPNP_CLASS), _g_object_unref0 (item), _tmp6_);
#line 255 "rygel-media-export-item.c"
			result = rygel_media_export_item_factory_fill_video_item ((_tmp7_ = item, RYGEL_IS_VIDEO_ITEM (_tmp7_) ? ((RygelVideoItem*) _tmp7_) : NULL), file, dlna_info, video_info, audio_info, mime, size, mtime);
			_g_free0 (id);
			_g_object_unref0 (item);
#line 91 "rygel-media-export-item.vala"
			return result;
#line 261 "rygel-media-export-item.c"
		}
	} else {
#line 100 "rygel-media-export-item.vala"
		if (audio_info != NULL) {
#line 266 "rygel-media-export-item.c"
			RygelMediaItem* _tmp8_;
			RygelMediaItem* _tmp9_;
#line 101 "rygel-media-export-item.vala"
			item = (_tmp8_ = (RygelMediaItem*) rygel_music_item_new (id, parent, "", RYGEL_MUSIC_ITEM_UPNP_CLASS), _g_object_unref0 (item), _tmp8_);
#line 271 "rygel-media-export-item.c"
			result = rygel_media_export_item_factory_fill_music_item ((_tmp9_ = item, RYGEL_IS_MUSIC_ITEM (_tmp9_) ? ((RygelMusicItem*) _tmp9_) : NULL), file, dlna_info, audio_info, mime, size, mtime);
			_g_free0 (id);
			_g_object_unref0 (item);
#line 102 "rygel-media-export-item.vala"
			return result;
#line 277 "rygel-media-export-item.c"
		} else {
			result = NULL;
			_g_free0 (id);
			_g_object_unref0 (item);
#line 110 "rygel-media-export-item.vala"
			return result;
#line 284 "rygel-media-export-item.c"
		}
	}
	_g_free0 (id);
	_g_object_unref0 (item);
}


#line 114 "rygel-media-export-item.vala"
void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GUPnPDLNAInformation* dlna_info, GstStreamAudioInformation* audio_info) {
#line 114 "rygel-media-export-item.vala"
	g_return_if_fail (item != NULL);
#line 114 "rygel-media-export-item.vala"
	g_return_if_fail (dlna_info != NULL);
#line 117 "rygel-media-export-item.vala"
	if (gupnp_dlna_information_get_info (dlna_info)->duration > 0) {
#line 118 "rygel-media-export-item.vala"
		item->duration = (glong) (gupnp_dlna_information_get_info (dlna_info)->duration / GST_SECOND);
#line 302 "rygel-media-export-item.c"
	} else {
#line 120 "rygel-media-export-item.vala"
		item->duration = (glong) (-1);
#line 306 "rygel-media-export-item.c"
	}
#line 124 "rygel-media-export-item.vala"
	if (audio_info != NULL) {
#line 125 "rygel-media-export-item.vala"
		if (((GstStreamInformation*) audio_info)->tags != NULL) {
#line 312 "rygel-media-export-item.c"
			guint tmp = 0U;
#line 127 "rygel-media-export-item.vala"
			gst_tag_list_get_uint (((GstStreamInformation*) audio_info)->tags, GST_TAG_BITRATE, &tmp);
#line 128 "rygel-media-export-item.vala"
			item->bitrate = ((gint) tmp) / 8;
#line 318 "rygel-media-export-item.c"
		}
#line 130 "rygel-media-export-item.vala"
		item->n_audio_channels = (gint) audio_info->channels;
#line 131 "rygel-media-export-item.vala"
		item->sample_freq = (gint) audio_info->sample_rate;
#line 324 "rygel-media-export-item.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 136 "rygel-media-export-item.vala"
RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelVideoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamVideoInformation* video_info, GstStreamAudioInformation* audio_info, const char* mime, guint64 size, guint64 mtime) {
#line 336 "rygel-media-export-item.c"
	RygelMediaItem* result = NULL;
	RygelVideoItem* _tmp0_;
#line 136 "rygel-media-export-item.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 136 "rygel-media-export-item.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 136 "rygel-media-export-item.vala"
	g_return_val_if_fail (dlna_info != NULL, NULL);
#line 136 "rygel-media-export-item.vala"
	g_return_val_if_fail (video_info != NULL, NULL);
#line 136 "rygel-media-export-item.vala"
	g_return_val_if_fail (mime != NULL, NULL);
#line 144 "rygel-media-export-item.vala"
	rygel_media_export_item_factory_fill_audio_item ((_tmp0_ = item, RYGEL_IS_AUDIO_ITEM (_tmp0_) ? ((RygelAudioItem*) _tmp0_) : NULL), dlna_info, audio_info);
#line 145 "rygel-media-export-item.vala"
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) item, file, dlna_info, mime, size, mtime);
#line 147 "rygel-media-export-item.vala"
	rygel_visual_item_set_width ((RygelVisualItem*) item, (gint) video_info->width);
#line 148 "rygel-media-export-item.vala"
	rygel_visual_item_set_height ((RygelVisualItem*) item, (gint) video_info->height);
#line 149 "rygel-media-export-item.vala"
	rygel_visual_item_set_color_depth ((RygelVisualItem*) item, (gint) video_info->depth);
#line 151 "rygel-media-export-item.vala"
	if (audio_info != NULL) {
#line 152 "rygel-media-export-item.vala"
		((RygelAudioItem*) item)->n_audio_channels = (gint) audio_info->channels;
#line 153 "rygel-media-export-item.vala"
		((RygelAudioItem*) item)->sample_freq = (gint) audio_info->sample_rate;
#line 154 "rygel-media-export-item.vala"
		if (((GstStreamInformation*) audio_info)->tags != NULL) {
#line 367 "rygel-media-export-item.c"
			guint tmp = 0U;
#line 157 "rygel-media-export-item.vala"
			gst_tag_list_get_uint (((GstStreamInformation*) audio_info)->tags, GST_TAG_BITRATE, &tmp);
#line 158 "rygel-media-export-item.vala"
			((RygelAudioItem*) item)->bitrate = ((gint) tmp) / 8;
#line 373 "rygel-media-export-item.c"
		}
	}
	result = _g_object_ref0 ((RygelMediaItem*) item);
#line 162 "rygel-media-export-item.vala"
	return result;
#line 379 "rygel-media-export-item.c"
}


#line 165 "rygel-media-export-item.vala"
RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelPhotoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamVideoInformation* video_info, const char* mime, guint64 size, guint64 mtime) {
#line 385 "rygel-media-export-item.c"
	RygelMediaItem* result = NULL;
#line 165 "rygel-media-export-item.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 165 "rygel-media-export-item.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 165 "rygel-media-export-item.vala"
	g_return_val_if_fail (dlna_info != NULL, NULL);
#line 165 "rygel-media-export-item.vala"
	g_return_val_if_fail (video_info != NULL, NULL);
#line 165 "rygel-media-export-item.vala"
	g_return_val_if_fail (mime != NULL, NULL);
#line 172 "rygel-media-export-item.vala"
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) item, file, dlna_info, mime, size, mtime);
#line 179 "rygel-media-export-item.vala"
	rygel_visual_item_set_width ((RygelVisualItem*) item, (gint) video_info->width);
#line 180 "rygel-media-export-item.vala"
	rygel_visual_item_set_height ((RygelVisualItem*) item, (gint) video_info->height);
#line 181 "rygel-media-export-item.vala"
	rygel_visual_item_set_color_depth ((RygelVisualItem*) item, (gint) video_info->depth);
#line 405 "rygel-media-export-item.c"
	result = _g_object_ref0 ((RygelMediaItem*) item);
#line 183 "rygel-media-export-item.vala"
	return result;
#line 409 "rygel-media-export-item.c"
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


#line 186 "rygel-media-export-item.vala"
RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMusicItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamAudioInformation* audio_info, const char* mime, guint64 size, guint64 mtime) {
#line 420 "rygel-media-export-item.c"
	RygelMediaItem* result = NULL;
	RygelMusicItem* _tmp0_;
	GError * _inner_error_ = NULL;
#line 186 "rygel-media-export-item.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 186 "rygel-media-export-item.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 186 "rygel-media-export-item.vala"
	g_return_val_if_fail (dlna_info != NULL, NULL);
#line 186 "rygel-media-export-item.vala"
	g_return_val_if_fail (mime != NULL, NULL);
#line 193 "rygel-media-export-item.vala"
	rygel_media_export_item_factory_fill_audio_item ((_tmp0_ = item, RYGEL_IS_AUDIO_ITEM (_tmp0_) ? ((RygelAudioItem*) _tmp0_) : NULL), dlna_info, audio_info);
#line 194 "rygel-media-export-item.vala"
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) item, file, dlna_info, mime, size, mtime);
#line 201 "rygel-media-export-item.vala"
	if (audio_info != NULL) {
#line 438 "rygel-media-export-item.c"
		char* _tmp1_ = NULL;
		char* _tmp2_;
		char* _tmp3_ = NULL;
		char* _tmp4_;
		char* _tmp5_ = NULL;
		char* _tmp6_;
		guint tmp = 0U;
#line 202 "rygel-media-export-item.vala"
		if (((GstStreamInformation*) audio_info)->tags != NULL) {
#line 448 "rygel-media-export-item.c"
			GstBuffer* buffer;
			buffer = NULL;
#line 204 "rygel-media-export-item.vala"
			gst_tag_list_get_buffer (((GstStreamInformation*) audio_info)->tags, GST_TAG_IMAGE, &buffer);
#line 205 "rygel-media-export-item.vala"
			if (buffer != NULL) {
#line 455 "rygel-media-export-item.c"
				GstStructure* structure;
				gint image_type = 0;
#line 206 "rygel-media-export-item.vala"
				structure = _gst_structure_copy0 (gst_caps_get_structure (buffer->caps, (guint) 0));
#line 208 "rygel-media-export-item.vala"
				gst_structure_get_enum (structure, "image-type", GST_TYPE_TAG_IMAGE_TYPE, &image_type);
#line 211 "rygel-media-export-item.vala"
				switch (image_type) {
#line 464 "rygel-media-export-item.c"
					case GST_TAG_IMAGE_TYPE_UNDEFINED:
					case GST_TAG_IMAGE_TYPE_FRONT_COVER:
					{
						RygelMediaArtStore* store;
						GFile* thumb;
#line 214 "rygel-media-export-item.vala"
						store = rygel_media_art_store_get_default ();
#line 215 "rygel-media-export-item.vala"
						thumb = rygel_media_art_store_get_media_art_file (store, "album", item, TRUE);
#line 474 "rygel-media-export-item.c"
						{
							RygelMediaExportJPEGWriter* writer;
#line 219 "rygel-media-export-item.vala"
							writer = rygel_media_export_jpeg_writer_new (&_inner_error_);
#line 479 "rygel-media-export-item.c"
							if (_inner_error_ != NULL) {
								goto __catch53_g_error;
							}
#line 220 "rygel-media-export-item.vala"
							rygel_media_export_jpeg_writer_write (writer, buffer, thumb);
#line 485 "rygel-media-export-item.c"
							_g_object_unref0 (writer);
						}
						goto __finally53;
						__catch53_g_error:
						{
							GError * _error_;
							_error_ = _inner_error_;
							_inner_error_ = NULL;
							{
								_g_error_free0 (_error_);
							}
						}
						__finally53:
						if (_inner_error_ != NULL) {
							_g_object_unref0 (thumb);
							_g_object_unref0 (store);
							_gst_structure_free0 (structure);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_g_object_unref0 (thumb);
						_g_object_unref0 (store);
#line 222 "rygel-media-export-item.vala"
						break;
#line 511 "rygel-media-export-item.c"
					}
					default:
					{
#line 224 "rygel-media-export-item.vala"
						break;
#line 517 "rygel-media-export-item.c"
					}
				}
				_gst_structure_free0 (structure);
			}
		}
#line 228 "rygel-media-export-item.vala"
		gst_tag_list_get_string (gupnp_dlna_information_get_info (dlna_info)->tags, GST_TAG_ARTIST, &_tmp1_);
#line 228 "rygel-media-export-item.vala"
		item->artist = (_tmp2_ = _tmp1_, _g_free0 (item->artist), _tmp2_);
#line 229 "rygel-media-export-item.vala"
		gst_tag_list_get_string (gupnp_dlna_information_get_info (dlna_info)->tags, GST_TAG_ALBUM, &_tmp3_);
#line 229 "rygel-media-export-item.vala"
		item->album = (_tmp4_ = _tmp3_, _g_free0 (item->album), _tmp4_);
#line 230 "rygel-media-export-item.vala"
		gst_tag_list_get_string (gupnp_dlna_information_get_info (dlna_info)->tags, GST_TAG_GENRE, &_tmp5_);
#line 230 "rygel-media-export-item.vala"
		item->genre = (_tmp6_ = _tmp5_, _g_free0 (item->genre), _tmp6_);
#line 233 "rygel-media-export-item.vala"
		gst_tag_list_get_uint (gupnp_dlna_information_get_info (dlna_info)->tags, GST_TAG_TRACK_NUMBER, &tmp);
#line 234 "rygel-media-export-item.vala"
		item->track_number = (gint) tmp;
#line 539 "rygel-media-export-item.c"
	}
	result = _g_object_ref0 ((RygelMediaItem*) item);
#line 237 "rygel-media-export-item.vala"
	return result;
#line 544 "rygel-media-export-item.c"
}


#line 240 "rygel-media-export-item.vala"
void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, const char* mime, guint64 size, guint64 mtime) {
#line 550 "rygel-media-export-item.c"
	char* title;
	gboolean _tmp0_ = FALSE;
	char* _tmp15_;
#line 240 "rygel-media-export-item.vala"
	g_return_if_fail (item != NULL);
#line 240 "rygel-media-export-item.vala"
	g_return_if_fail (file != NULL);
#line 240 "rygel-media-export-item.vala"
	g_return_if_fail (dlna_info != NULL);
#line 240 "rygel-media-export-item.vala"
	g_return_if_fail (mime != NULL);
#line 246 "rygel-media-export-item.vala"
	title = NULL;
#line 248 "rygel-media-export-item.vala"
	if (gupnp_dlna_information_get_info (dlna_info)->tags == NULL) {
#line 248 "rygel-media-export-item.vala"
		_tmp0_ = TRUE;
#line 568 "rygel-media-export-item.c"
	} else {
		char* _tmp1_ = NULL;
		gboolean _tmp2_;
		char* _tmp3_;
#line 249 "rygel-media-export-item.vala"
		_tmp0_ = !(_tmp2_ = gst_tag_list_get_string (gupnp_dlna_information_get_info (dlna_info)->tags, GST_TAG_TITLE, &_tmp1_), title = (_tmp3_ = _tmp1_, _g_free0 (title), _tmp3_), _tmp2_);
#line 575 "rygel-media-export-item.c"
	}
#line 248 "rygel-media-export-item.vala"
	if (_tmp0_) {
#line 579 "rygel-media-export-item.c"
		char* _tmp4_;
#line 250 "rygel-media-export-item.vala"
		title = (_tmp4_ = g_file_get_basename (file), _g_free0 (title), _tmp4_);
#line 583 "rygel-media-export-item.c"
	}
#line 253 "rygel-media-export-item.vala"
	rygel_media_object_set_title ((RygelMediaObject*) item, title);
#line 255 "rygel-media-export-item.vala"
	if (gupnp_dlna_information_get_info (dlna_info)->tags != NULL) {
#line 589 "rygel-media-export-item.c"
		GDate* date = NULL;
		GDate* _tmp5_ = NULL;
		gboolean _tmp6_;
		GDate* _tmp7_;
#line 257 "rygel-media-export-item.vala"
		if ((_tmp6_ = gst_tag_list_get_date (gupnp_dlna_information_get_info (dlna_info)->tags, GST_TAG_DATE, &_tmp5_), date = (_tmp7_ = _tmp5_, _g_free0 (date), _tmp7_), _tmp6_)) {
#line 596 "rygel-media-export-item.c"
			gint datestr_length1;
			gint _datestr_size_;
			gchar* _tmp8_;
			gchar* datestr;
			char* _tmp9_;
			datestr = (_tmp8_ = g_new0 (gchar, 30), datestr_length1 = 30, _datestr_size_ = datestr_length1, _tmp8_);
#line 259 "rygel-media-export-item.vala"
			g_date_strftime (datestr, datestr_length1, "%F", date);
#line 260 "rygel-media-export-item.vala"
			item->date = (_tmp9_ = g_strdup ((const char*) datestr), _g_free0 (item->date), _tmp9_);
#line 607 "rygel-media-export-item.c"
			datestr = (g_free (datestr), NULL);
		}
		_g_free0 (date);
	}
#line 265 "rygel-media-export-item.vala"
	if (item->date == NULL) {
#line 614 "rygel-media-export-item.c"
		GTimeVal _tmp10_ = {0};
		GTimeVal tv;
		char* _tmp11_;
#line 266 "rygel-media-export-item.vala"
		tv = (_tmp10_.tv_sec = (glong) mtime, _tmp10_.tv_usec = (glong) 0, _tmp10_);
#line 267 "rygel-media-export-item.vala"
		item->date = (_tmp11_ = g_time_val_to_iso8601 (&tv), _g_free0 (item->date), _tmp11_);
#line 622 "rygel-media-export-item.c"
	}
#line 270 "rygel-media-export-item.vala"
	item->size = (gint64) size;
#line 271 "rygel-media-export-item.vala"
	((RygelMediaObject*) item)->modified = (guint64) ((gint64) mtime);
#line 273 "rygel-media-export-item.vala"
	if (gupnp_dlna_information_get_name (dlna_info) != NULL) {
#line 630 "rygel-media-export-item.c"
		char* _tmp12_;
		char* _tmp13_;
#line 274 "rygel-media-export-item.vala"
		item->dlna_profile = (_tmp12_ = g_strdup (gupnp_dlna_information_get_name (dlna_info)), _g_free0 (item->dlna_profile), _tmp12_);
#line 275 "rygel-media-export-item.vala"
		item->mime_type = (_tmp13_ = g_strdup (gupnp_dlna_information_get_mime (dlna_info)), _g_free0 (item->mime_type), _tmp13_);
#line 637 "rygel-media-export-item.c"
	} else {
		char* _tmp14_;
#line 277 "rygel-media-export-item.vala"
		item->mime_type = (_tmp14_ = g_strdup (mime), _g_free0 (item->mime_type), _tmp14_);
#line 642 "rygel-media-export-item.c"
	}
#line 280 "rygel-media-export-item.vala"
	rygel_media_item_add_uri (item, _tmp15_ = g_file_get_uri (file));
#line 646 "rygel-media-export-item.c"
	_g_free0 (_tmp15_);
	_g_free0 (title);
}




