/* rygel-relational-expression.c generated by valac 0.9.6, the Vala compiler
 * generated from rygel-relational-expression.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <gst/gst.h>
#include <gio/gio.h>


#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelRelationalExpressionPrivate RygelRelationalExpressionPrivate;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_IMAGE_ITEM (rygel_image_item_get_type ())
#define RYGEL_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItem))
#define RYGEL_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))
#define RYGEL_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))

typedef struct _RygelImageItem RygelImageItem;
typedef struct _RygelImageItemClass RygelImageItemClass;

#define RYGEL_TYPE_PHOTO_ITEM (rygel_photo_item_get_type ())
#define RYGEL_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItem))
#define RYGEL_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))
#define RYGEL_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))

typedef struct _RygelPhotoItem RygelPhotoItem;
typedef struct _RygelPhotoItemClass RygelPhotoItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelImageItemPrivate RygelImageItemPrivate;
typedef struct _RygelPhotoItemPrivate RygelPhotoItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	char* (*to_string) (RygelSearchExpression* self);
};

struct _RygelRelationalExpression {
	RygelSearchExpression parent_instance;
	RygelRelationalExpressionPrivate * priv;
};

struct _RygelRelationalExpressionClass {
	RygelSearchExpressionClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* date;
	char* mime_type;
	char* dlna_profile;
	gint64 size;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const char* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const char* uri, const char* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_pixel_width) (RygelVisualItem* self);
	void (*set_pixel_width) (RygelVisualItem* self, gint value);
	gint (*get_pixel_height) (RygelVisualItem* self);
	void (*set_pixel_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelImageItem {
	RygelMediaItem parent_instance;
	RygelImageItemPrivate * priv;
};

struct _RygelImageItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelPhotoItem {
	RygelImageItem parent_instance;
	RygelPhotoItemPrivate * priv;
	char* creator;
};

struct _RygelPhotoItemClass {
	RygelImageItemClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint n_audio_channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
	char* artist;
	char* album;
	char* genre;
	gint track_number;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gint child_count;
	guint32 update_id;
	GeeArrayList* create_classes;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*search) (RygelMediaContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelMediaContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	void (*find_object) (RygelMediaContainer* self, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_item) (RygelMediaContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_relational_expression_parent_class = NULL;

gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_RELATIONAL_EXPRESSION_DUMMY_PROPERTY
};
#define RYGEL_RELATIONAL_EXPRESSION_CAPS "@id,@parentID,upnp:class," "dc:title,upnp:artist,upnp:album," "dc:creator,upnp:createClass"
static gboolean rygel_relational_expression_real_satisfied_by (RygelSearchExpression* base, RygelMediaObject* media_object);
gboolean rygel_relational_expression_compare_string (RygelRelationalExpression* self, const char* str);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
const char* rygel_media_object_get_title (RygelMediaObject* self);
static gboolean rygel_relational_expression_compare_create_class (RygelRelationalExpression* self, RygelMediaContainer* container);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_image_item_get_type (void) G_GNUC_CONST;
GType rygel_photo_item_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
static char* rygel_relational_expression_real_to_string (RygelSearchExpression* base);
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
RygelSearchExpression* rygel_search_expression_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GType h_type, GBoxedCopyFunc h_dup_func, GDestroyNotify h_destroy_func, GType i_type, GBoxedCopyFunc i_dup_func, GDestroyNotify i_destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 33 "rygel-relational-expression.vala"
static gboolean rygel_relational_expression_real_satisfied_by (RygelSearchExpression* base, RygelMediaObject* media_object) {
#line 389 "rygel-relational-expression.c"
	RygelRelationalExpression * self;
	gboolean result = FALSE;
	const char* _tmp4_;
	GQuark _tmp5_;
	static GQuark _tmp5__label0 = 0;
	static GQuark _tmp5__label1 = 0;
	static GQuark _tmp5__label2 = 0;
	static GQuark _tmp5__label3 = 0;
	static GQuark _tmp5__label4 = 0;
	static GQuark _tmp5__label5 = 0;
	static GQuark _tmp5__label6 = 0;
	static GQuark _tmp5__label7 = 0;
	self = (RygelRelationalExpression*) base;
#line 33 "rygel-relational-expression.vala"
	g_return_val_if_fail (media_object != NULL, FALSE);
#line 405 "rygel-relational-expression.c"
	_tmp4_ = (const char*) ((RygelSearchExpression*) self)->operand1;
	_tmp5_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp5_ == ((0 != _tmp5__label0) ? _tmp5__label0 : (_tmp5__label0 = g_quark_from_static_string ("@id"))))
	switch (0) {
		default:
		{
			result = rygel_relational_expression_compare_string (self, media_object->id);
#line 36 "rygel-relational-expression.vala"
			return result;
#line 415 "rygel-relational-expression.c"
		}
	} else if (_tmp5_ == ((0 != _tmp5__label1) ? _tmp5__label1 : (_tmp5__label1 = g_quark_from_static_string ("@parentID"))))
	switch (0) {
		default:
		{
			result = rygel_relational_expression_compare_string (self, ((RygelMediaObject*) media_object->parent)->id);
#line 38 "rygel-relational-expression.vala"
			return result;
#line 424 "rygel-relational-expression.c"
		}
	} else if (_tmp5_ == ((0 != _tmp5__label2) ? _tmp5__label2 : (_tmp5__label2 = g_quark_from_static_string ("upnp:class"))))
	switch (0) {
		default:
		{
			result = rygel_relational_expression_compare_string (self, media_object->upnp_class);
#line 40 "rygel-relational-expression.vala"
			return result;
#line 433 "rygel-relational-expression.c"
		}
	} else if (_tmp5_ == ((0 != _tmp5__label3) ? _tmp5__label3 : (_tmp5__label3 = g_quark_from_static_string ("dc:title"))))
	switch (0) {
		default:
		{
			result = rygel_relational_expression_compare_string (self, rygel_media_object_get_title (media_object));
#line 42 "rygel-relational-expression.vala"
			return result;
#line 442 "rygel-relational-expression.c"
		}
	} else if (_tmp5_ == ((0 != _tmp5__label4) ? _tmp5__label4 : (_tmp5__label4 = g_quark_from_static_string ("upnp:createClass"))))
	switch (0) {
		default:
		{
			RygelMediaObject* _tmp0_;
#line 44 "rygel-relational-expression.vala"
			if (!RYGEL_IS_MEDIA_CONTAINER (media_object)) {
#line 451 "rygel-relational-expression.c"
				result = FALSE;
#line 45 "rygel-relational-expression.vala"
				return result;
#line 455 "rygel-relational-expression.c"
			}
			result = rygel_relational_expression_compare_create_class (self, (_tmp0_ = media_object, RYGEL_IS_MEDIA_CONTAINER (_tmp0_) ? ((RygelMediaContainer*) _tmp0_) : NULL));
#line 48 "rygel-relational-expression.vala"
			return result;
#line 460 "rygel-relational-expression.c"
		}
	} else if (_tmp5_ == ((0 != _tmp5__label5) ? _tmp5__label5 : (_tmp5__label5 = g_quark_from_static_string ("dc:creator"))))
	switch (0) {
		default:
		{
			RygelMediaObject* _tmp1_;
#line 50 "rygel-relational-expression.vala"
			if (!RYGEL_IS_PHOTO_ITEM (media_object)) {
#line 469 "rygel-relational-expression.c"
				result = FALSE;
#line 51 "rygel-relational-expression.vala"
				return result;
#line 473 "rygel-relational-expression.c"
			}
			result = rygel_relational_expression_compare_string (self, (_tmp1_ = media_object, RYGEL_IS_PHOTO_ITEM (_tmp1_) ? ((RygelPhotoItem*) _tmp1_) : NULL)->creator);
#line 54 "rygel-relational-expression.vala"
			return result;
#line 478 "rygel-relational-expression.c"
		}
	} else if (_tmp5_ == ((0 != _tmp5__label6) ? _tmp5__label6 : (_tmp5__label6 = g_quark_from_static_string ("upnp:artist"))))
	switch (0) {
		default:
		{
			RygelMediaObject* _tmp2_;
#line 56 "rygel-relational-expression.vala"
			if (!RYGEL_IS_MUSIC_ITEM (media_object)) {
#line 487 "rygel-relational-expression.c"
				result = FALSE;
#line 57 "rygel-relational-expression.vala"
				return result;
#line 491 "rygel-relational-expression.c"
			}
			result = rygel_relational_expression_compare_string (self, (_tmp2_ = media_object, RYGEL_IS_MUSIC_ITEM (_tmp2_) ? ((RygelMusicItem*) _tmp2_) : NULL)->artist);
#line 60 "rygel-relational-expression.vala"
			return result;
#line 496 "rygel-relational-expression.c"
		}
	} else if (_tmp5_ == ((0 != _tmp5__label7) ? _tmp5__label7 : (_tmp5__label7 = g_quark_from_static_string ("upnp:album"))))
	switch (0) {
		default:
		{
			RygelMediaObject* _tmp3_;
#line 62 "rygel-relational-expression.vala"
			if (!RYGEL_IS_MUSIC_ITEM (media_object)) {
#line 505 "rygel-relational-expression.c"
				result = FALSE;
#line 63 "rygel-relational-expression.vala"
				return result;
#line 509 "rygel-relational-expression.c"
			}
			result = rygel_relational_expression_compare_string (self, (_tmp3_ = media_object, RYGEL_IS_MUSIC_ITEM (_tmp3_) ? ((RygelMusicItem*) _tmp3_) : NULL)->album);
#line 66 "rygel-relational-expression.vala"
			return result;
#line 514 "rygel-relational-expression.c"
		}
	} else
	switch (0) {
		default:
		{
			result = FALSE;
#line 68 "rygel-relational-expression.vala"
			return result;
#line 523 "rygel-relational-expression.c"
		}
	}
}


#line 72 "rygel-relational-expression.vala"
static char* rygel_relational_expression_real_to_string (RygelSearchExpression* base) {
#line 531 "rygel-relational-expression.c"
	RygelRelationalExpression * self;
	char* result = NULL;
	self = (RygelRelationalExpression*) base;
	result = g_strdup_printf ("%s %d %s", (const char*) ((RygelSearchExpression*) self)->operand1, (gint) GPOINTER_TO_INT (((RygelSearchExpression*) self)->op), (const char*) ((RygelSearchExpression*) self)->operand2);
#line 73 "rygel-relational-expression.vala"
	return result;
#line 538 "rygel-relational-expression.c"
}


#line 76 "rygel-relational-expression.vala"
static gboolean rygel_relational_expression_compare_create_class (RygelRelationalExpression* self, RygelMediaContainer* container) {
#line 544 "rygel-relational-expression.c"
	gboolean result = FALSE;
	gboolean ret;
#line 76 "rygel-relational-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 76 "rygel-relational-expression.vala"
	g_return_val_if_fail (container != NULL, FALSE);
#line 77 "rygel-relational-expression.vala"
	ret = FALSE;
#line 553 "rygel-relational-expression.c"
	{
		GeeIterator* _create_class_it;
#line 79 "rygel-relational-expression.vala"
		_create_class_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) container->create_classes);
#line 79 "rygel-relational-expression.vala"
		while (TRUE) {
#line 560 "rygel-relational-expression.c"
			char* create_class;
#line 79 "rygel-relational-expression.vala"
			if (!gee_iterator_next (_create_class_it)) {
#line 79 "rygel-relational-expression.vala"
				break;
#line 566 "rygel-relational-expression.c"
			}
#line 79 "rygel-relational-expression.vala"
			create_class = (char*) gee_iterator_get (_create_class_it);
#line 80 "rygel-relational-expression.vala"
			if (rygel_relational_expression_compare_string (self, create_class)) {
#line 81 "rygel-relational-expression.vala"
				ret = TRUE;
#line 574 "rygel-relational-expression.c"
				_g_free0 (create_class);
#line 83 "rygel-relational-expression.vala"
				break;
#line 578 "rygel-relational-expression.c"
			}
			_g_free0 (create_class);
		}
		_g_object_unref0 (_create_class_it);
	}
	result = ret;
#line 87 "rygel-relational-expression.vala"
	return result;
#line 587 "rygel-relational-expression.c"
}


#line 1152 "glib-2.0.vapi"
static gboolean string_contains (const char* self, const char* needle) {
#line 593 "rygel-relational-expression.c"
	gboolean result = FALSE;
#line 1152 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1152 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 599 "rygel-relational-expression.c"
	result = strstr (self, needle) != NULL;
#line 1153 "glib-2.0.vapi"
	return result;
#line 603 "rygel-relational-expression.c"
}


#line 90 "rygel-relational-expression.vala"
gboolean rygel_relational_expression_compare_string (RygelRelationalExpression* self, const char* str) {
#line 609 "rygel-relational-expression.c"
	gboolean result = FALSE;
	char* up_operand2;
	char* up_str;
#line 90 "rygel-relational-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 91 "rygel-relational-expression.vala"
	up_operand2 = g_utf8_strup ((const char*) ((RygelSearchExpression*) self)->operand2, -1);
#line 92 "rygel-relational-expression.vala"
	up_str = g_utf8_strup (str, -1);
#line 94 "rygel-relational-expression.vala"
	switch (GPOINTER_TO_INT (((RygelSearchExpression*) self)->op)) {
#line 621 "rygel-relational-expression.c"
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
		{
#line 96 "rygel-relational-expression.vala"
			if (_vala_strcmp0 ((const char*) ((RygelSearchExpression*) self)->operand2, "true") == 0) {
#line 626 "rygel-relational-expression.c"
				result = str != NULL;
				_g_free0 (up_str);
				_g_free0 (up_operand2);
#line 97 "rygel-relational-expression.vala"
				return result;
#line 632 "rygel-relational-expression.c"
			} else {
				result = str == NULL;
				_g_free0 (up_str);
				_g_free0 (up_operand2);
#line 99 "rygel-relational-expression.vala"
				return result;
#line 639 "rygel-relational-expression.c"
			}
		}
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		{
			result = _vala_strcmp0 (up_operand2, up_str) == 0;
			_g_free0 (up_str);
			_g_free0 (up_operand2);
#line 102 "rygel-relational-expression.vala"
			return result;
#line 649 "rygel-relational-expression.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			result = string_contains (up_str, up_operand2);
			_g_free0 (up_str);
			_g_free0 (up_operand2);
#line 104 "rygel-relational-expression.vala"
			return result;
#line 658 "rygel-relational-expression.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
		{
			result = g_str_has_prefix (up_str, up_operand2);
			_g_free0 (up_str);
			_g_free0 (up_operand2);
#line 106 "rygel-relational-expression.vala"
			return result;
#line 667 "rygel-relational-expression.c"
		}
		default:
		{
			result = FALSE;
			_g_free0 (up_str);
			_g_free0 (up_operand2);
#line 108 "rygel-relational-expression.vala"
			return result;
#line 676 "rygel-relational-expression.c"
		}
	}
	_g_free0 (up_str);
	_g_free0 (up_operand2);
}


#line 27 "rygel-relational-expression.vala"
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type) {
#line 686 "rygel-relational-expression.c"
	RygelRelationalExpression* self;
#line 27 "rygel-relational-expression.vala"
	self = (RygelRelationalExpression*) rygel_search_expression_construct (object_type, GUPNP_TYPE_SEARCH_CRITERIA_OP, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free);
#line 690 "rygel-relational-expression.c"
	return self;
}


#line 27 "rygel-relational-expression.vala"
RygelRelationalExpression* rygel_relational_expression_new (void) {
#line 27 "rygel-relational-expression.vala"
	return rygel_relational_expression_construct (RYGEL_TYPE_RELATIONAL_EXPRESSION);
#line 699 "rygel-relational-expression.c"
}


static void rygel_relational_expression_class_init (RygelRelationalExpressionClass * klass) {
	rygel_relational_expression_parent_class = g_type_class_peek_parent (klass);
	RYGEL_SEARCH_EXPRESSION_CLASS (klass)->satisfied_by = rygel_relational_expression_real_satisfied_by;
	RYGEL_SEARCH_EXPRESSION_CLASS (klass)->to_string = rygel_relational_expression_real_to_string;
}


static void rygel_relational_expression_instance_init (RygelRelationalExpression * self) {
}


GType rygel_relational_expression_get_type (void) {
	static volatile gsize rygel_relational_expression_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_relational_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelRelationalExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_relational_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRelationalExpression), 0, (GInstanceInitFunc) rygel_relational_expression_instance_init, NULL };
		GType rygel_relational_expression_type_id;
		rygel_relational_expression_type_id = g_type_register_static (RYGEL_TYPE_SEARCH_EXPRESSION, "RygelRelationalExpression", &g_define_type_info, 0);
		g_once_init_leave (&rygel_relational_expression_type_id__volatile, rygel_relational_expression_type_id);
	}
	return rygel_relational_expression_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




