/* rygel-media-query-action.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-media-query-action.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libgupnp-av/gupnp-av.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;
typedef struct _RygelMediaQueryActionPrivate RygelMediaQueryActionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaQueryActionRunData RygelMediaQueryActionRunData;
typedef struct _RygelMediaQueryActionFetchMediaObjectData RygelMediaQueryActionFetchMediaObjectData;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelMediaQueryAction {
	GObject parent_instance;
	RygelMediaQueryActionPrivate * priv;
	char* object_id;
	char* browse_flag;
	char* filter;
	guint index;
	guint requested_count;
	char* sort_criteria;
	guint number_returned;
	guint total_matches;
	guint update_id;
	RygelMediaContainer* root_container;
	RygelHTTPServer* http_server;
	guint32 system_update_id;
	GUPnPServiceAction* action;
	GUPnPDIDLLiteWriter* didl_writer;
	RygelXBoxHacks* xbox_hacks;
	char* object_id_arg;
};

struct _RygelMediaQueryActionClass {
	GObjectClass parent_class;
	void (*parse_args) (RygelMediaQueryAction* self, GError** error);
	void (*fetch_results) (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*fetch_results_finish) (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
	void (*handle_error) (RygelMediaQueryAction* self, GError* _error_);
};

struct _RygelMediaQueryActionPrivate {
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	char* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

typedef enum  {
	RYGEL_XBOX_HACKS_ERROR_NA
} RygelXBoxHacksError;
#define RYGEL_XBOX_HACKS_ERROR rygel_xbox_hacks_error_quark ()
struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gint child_count;
	guint32 update_id;
	GeeArrayList* create_classes;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*search) (RygelMediaContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelMediaContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	void (*find_object) (RygelMediaContainer* self, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_item) (RygelMediaContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaQueryActionRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaQueryAction* self;
	RygelMediaObject* media_object;
	RygelMediaObjects* results;
	GeeIterator* _result_it;
	RygelMediaObject* _result_;
	gboolean _tmp0_;
	RygelMediaObject* _tmp1_;
	GUPnPDIDLLiteObject* _tmp2_;
	GError * err;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelMediaQueryActionFetchMediaObjectData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaQueryAction* self;
	RygelMediaObject* result;
	RygelMediaObject* media_object;
	GError * _inner_error_;
};


static gpointer rygel_media_query_action_parent_class = NULL;
static RygelStateMachineIface* rygel_media_query_action_rygel_state_machine_parent_iface = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_QUERY_ACTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionPrivate))
enum  {
	RYGEL_MEDIA_QUERY_ACTION_DUMMY_PROPERTY,
	RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE
};
#define RYGEL_MEDIA_QUERY_ACTION_DEFAULT_SORT_CRITERIA "-dc:title"
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
RygelMediaQueryAction* rygel_media_query_action_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
GQuark rygel_xbox_hacks_error_quark (void);
RygelXBoxHacks* rygel_xbox_hacks_new_for_action (GUPnPServiceAction* action, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_construct_for_action (GType object_type, GUPnPServiceAction* action, GError** error);
static void rygel_media_query_action_real_run_data_free (gpointer _data);
static void rygel_media_query_action_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_query_action_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_media_query_action_real_run_co (RygelMediaQueryActionRunData* data);
void rygel_media_query_action_parse_args (RygelMediaQueryAction* self, GError** error);
static void rygel_media_query_action_fetch_media_object (RygelMediaQueryAction* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObject* rygel_media_query_action_fetch_media_object_finish (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
void rygel_media_query_action_fetch_results (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_query_action_fetch_results_finish (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
void rygel_media_objects_sort_by_criteria (RygelMediaObjects* self, const char* sort_criteria);
void rygel_xbox_hacks_apply (RygelXBoxHacks* self, RygelMediaItem* item);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
static void rygel_media_query_action_conclude (RygelMediaQueryAction* self);
void rygel_media_query_action_handle_error (RygelMediaQueryAction* self, GError* _error_);
static void rygel_media_query_action_real_parse_args (RygelMediaQueryAction* self, GError** error);
GQuark rygel_content_directory_error_quark (void);
void rygel_xbox_hacks_translate_container_id (RygelXBoxHacks* self, RygelMediaQueryAction* action, char** container_id);
static void rygel_media_query_action_fetch_media_object_data_free (gpointer _data);
static void rygel_media_query_action_fetch_media_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_media_query_action_fetch_media_object_co (RygelMediaQueryActionFetchMediaObjectData* data);
void rygel_media_container_find_object (RygelMediaContainer* self, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_media_query_action_real_handle_error (RygelMediaQueryAction* self, GError* _error_);
static void rygel_media_query_action_finalize (GObject* obj);
static void rygel_media_query_action_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_media_query_action_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 55 "rygel-media-query-action.vala"
RygelMediaQueryAction* rygel_media_query_action_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
#line 354 "rygel-media-query-action.c"
	RygelMediaQueryAction * self;
	RygelMediaContainer* _tmp0_;
	RygelHTTPServer* _tmp1_;
	GUPnPServiceAction* _tmp2_;
	GUPnPDIDLLiteWriter* _tmp3_;
	GError * _inner_error_ = NULL;
#line 55 "rygel-media-query-action.vala"
	g_return_val_if_fail (content_dir != NULL, NULL);
#line 55 "rygel-media-query-action.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 55 "rygel-media-query-action.vala"
	self = (RygelMediaQueryAction*) g_object_new (object_type, NULL);
#line 57 "rygel-media-query-action.vala"
	self->root_container = (_tmp0_ = _g_object_ref0 (content_dir->root_container), _g_object_unref0 (self->root_container), _tmp0_);
#line 58 "rygel-media-query-action.vala"
	self->http_server = (_tmp1_ = _g_object_ref0 (content_dir->http_server), _g_object_unref0 (self->http_server), _tmp1_);
#line 59 "rygel-media-query-action.vala"
	self->system_update_id = content_dir->system_update_id;
#line 60 "rygel-media-query-action.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, content_dir->cancellable);
#line 61 "rygel-media-query-action.vala"
	self->action = (_tmp2_ = action, action = NULL, _tmp2_);
#line 63 "rygel-media-query-action.vala"
	self->didl_writer = (_tmp3_ = gupnp_didl_lite_writer_new (NULL), _g_object_unref0 (self->didl_writer), _tmp3_);
#line 379 "rygel-media-query-action.c"
	{
		RygelXBoxHacks* _tmp4_;
		RygelXBoxHacks* _tmp5_;
#line 66 "rygel-media-query-action.vala"
		_tmp4_ = rygel_xbox_hacks_new_for_action (self->action, &_inner_error_);
#line 385 "rygel-media-query-action.c"
		if (_inner_error_ != NULL) {
			goto __catch48_g_error;
		}
#line 66 "rygel-media-query-action.vala"
		self->xbox_hacks = (_tmp5_ = _tmp4_, _g_object_unref0 (self->xbox_hacks), _tmp5_);
#line 391 "rygel-media-query-action.c"
	}
	goto __finally48;
	__catch48_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		{
		}
	}
	__finally48:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static void rygel_media_query_action_real_run_data_free (gpointer _data) {
	RygelMediaQueryActionRunData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelMediaQueryActionRunData, data);
}


static void rygel_media_query_action_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaQueryAction * self;
	RygelMediaQueryActionRunData* _data_;
	self = (RygelMediaQueryAction*) base;
	_data_ = g_slice_new0 (RygelMediaQueryActionRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_query_action_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_query_action_real_run_data_free);
	_data_->self = g_object_ref (self);
	rygel_media_query_action_real_run_co (_data_);
}


static void rygel_media_query_action_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelMediaQueryActionRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_media_query_action_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaQueryActionRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_query_action_real_run_co (data);
}


static gboolean rygel_media_query_action_real_run_co (RygelMediaQueryActionRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 30:
		goto _state_30;
		case 31:
		goto _state_31;
	}
	_state_0:
	{
#line 72 "rygel-media-query-action.vala"
		rygel_media_query_action_parse_args (data->self, &data->_inner_error_);
#line 460 "rygel-media-query-action.c"
		if (data->_inner_error_ != NULL) {
			goto __catch49_g_error;
		}
		data->_state_ = 30;
		rygel_media_query_action_fetch_media_object (data->self, rygel_media_query_action_run_ready, data);
		return FALSE;
		_state_30:
		data->media_object = rygel_media_query_action_fetch_media_object_finish (data->self, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch49_g_error;
		}
		data->_state_ = 31;
		rygel_media_query_action_fetch_results (data->self, data->media_object, rygel_media_query_action_run_ready, data);
		return FALSE;
		_state_31:
		data->results = rygel_media_query_action_fetch_results_finish (data->self, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->media_object);
			goto __catch49_g_error;
		}
#line 77 "rygel-media-query-action.vala"
		data->self->number_returned = (guint) gee_collection_get_size ((GeeCollection*) data->results);
#line 78 "rygel-media-query-action.vala"
		if (RYGEL_IS_MEDIA_CONTAINER (data->media_object)) {
#line 79 "rygel-media-query-action.vala"
			data->self->update_id = (guint) RYGEL_MEDIA_CONTAINER (data->media_object)->update_id;
#line 487 "rygel-media-query-action.c"
		} else {
#line 81 "rygel-media-query-action.vala"
			data->self->update_id = (guint) G_MAXUINT32;
#line 491 "rygel-media-query-action.c"
		}
#line 84 "rygel-media-query-action.vala"
		rygel_media_objects_sort_by_criteria (data->results, data->self->sort_criteria);
#line 495 "rygel-media-query-action.c"
		{
			data->_result_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) data->results);
#line 86 "rygel-media-query-action.vala"
			while (TRUE) {
#line 86 "rygel-media-query-action.vala"
				if (!gee_iterator_next (data->_result_it)) {
#line 86 "rygel-media-query-action.vala"
					break;
#line 504 "rygel-media-query-action.c"
				}
				data->_result_ = (RygelMediaObject*) gee_iterator_get (data->_result_it);
#line 87 "rygel-media-query-action.vala"
				if (RYGEL_IS_MEDIA_ITEM (data->_result_)) {
#line 87 "rygel-media-query-action.vala"
					data->_tmp0_ = data->self->xbox_hacks != NULL;
#line 511 "rygel-media-query-action.c"
				} else {
#line 87 "rygel-media-query-action.vala"
					data->_tmp0_ = FALSE;
#line 515 "rygel-media-query-action.c"
				}
#line 87 "rygel-media-query-action.vala"
				if (data->_tmp0_) {
#line 88 "rygel-media-query-action.vala"
					rygel_xbox_hacks_apply (data->self->xbox_hacks, (data->_tmp1_ = data->_result_, RYGEL_IS_MEDIA_ITEM (data->_tmp1_) ? ((RygelMediaItem*) data->_tmp1_) : NULL));
#line 521 "rygel-media-query-action.c"
				}
#line 91 "rygel-media-query-action.vala"
				data->_tmp2_ = rygel_media_object_serialize (data->_result_, data->self->didl_writer, data->self->http_server, &data->_inner_error_);
#line 525 "rygel-media-query-action.c"
				_g_object_unref0 (data->_tmp2_);
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->_result_);
					_g_object_unref0 (data->_result_it);
					_g_object_unref0 (data->results);
					_g_object_unref0 (data->media_object);
					goto __catch49_g_error;
				}
				_g_object_unref0 (data->_result_);
			}
			_g_object_unref0 (data->_result_it);
		}
#line 95 "rygel-media-query-action.vala"
		rygel_media_query_action_conclude (data->self);
#line 540 "rygel-media-query-action.c"
		_g_object_unref0 (data->results);
		_g_object_unref0 (data->media_object);
	}
	goto __finally49;
	__catch49_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
#line 97 "rygel-media-query-action.vala"
			rygel_media_query_action_handle_error (data->self, data->err);
#line 552 "rygel-media-query-action.c"
			_g_error_free0 (data->err);
		}
	}
	__finally49:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 101 "rygel-media-query-action.vala"
static void rygel_media_query_action_real_parse_args (RygelMediaQueryAction* self, GError** error) {
#line 576 "rygel-media-query-action.c"
	GError * _inner_error_ = NULL;
#line 101 "rygel-media-query-action.vala"
	g_return_if_fail (self != NULL);
#line 102 "rygel-media-query-action.vala"
	gupnp_service_action_get (self->action, self->object_id_arg, G_TYPE_STRING, &self->object_id, "Filter", G_TYPE_STRING, &self->filter, "StartingIndex", G_TYPE_UINT, &self->index, "RequestedCount", G_TYPE_UINT, &self->requested_count, "SortCriteria", G_TYPE_STRING, &self->sort_criteria, NULL);
#line 118 "rygel-media-query-action.vala"
	if (self->object_id == NULL) {
#line 584 "rygel-media-query-action.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _ ("No such object"));
		{
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
#line 124 "rygel-media-query-action.vala"
	if (self->sort_criteria == NULL) {
#line 593 "rygel-media-query-action.c"
		char* _tmp0_;
#line 125 "rygel-media-query-action.vala"
		self->sort_criteria = (_tmp0_ = g_strdup (RYGEL_MEDIA_QUERY_ACTION_DEFAULT_SORT_CRITERIA), _g_free0 (self->sort_criteria), _tmp0_);
#line 597 "rygel-media-query-action.c"
	}
#line 128 "rygel-media-query-action.vala"
	if (self->xbox_hacks != NULL) {
#line 129 "rygel-media-query-action.vala"
		rygel_xbox_hacks_translate_container_id (self->xbox_hacks, self, &self->object_id);
#line 603 "rygel-media-query-action.c"
	}
}


#line 55 "rygel-media-query-action.vala"
void rygel_media_query_action_parse_args (RygelMediaQueryAction* self, GError** error) {
#line 55 "rygel-media-query-action.vala"
	RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self)->parse_args (self, error);
#line 612 "rygel-media-query-action.c"
}


#line 55 "rygel-media-query-action.vala"
void rygel_media_query_action_fetch_results (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 55 "rygel-media-query-action.vala"
	RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self)->fetch_results (self, media_object, _callback_, _user_data_);
#line 620 "rygel-media-query-action.c"
}


#line 55 "rygel-media-query-action.vala"
RygelMediaObjects* rygel_media_query_action_fetch_results_finish (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error) {
#line 55 "rygel-media-query-action.vala"
	return RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self)->fetch_results_finish (self, _res_, error);
#line 628 "rygel-media-query-action.c"
}


static void rygel_media_query_action_fetch_media_object_data_free (gpointer _data) {
	RygelMediaQueryActionFetchMediaObjectData* data;
	data = _data;
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelMediaQueryActionFetchMediaObjectData, data);
}


static void rygel_media_query_action_fetch_media_object (RygelMediaQueryAction* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaQueryActionFetchMediaObjectData* _data_;
	_data_ = g_slice_new0 (RygelMediaQueryActionFetchMediaObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_query_action_fetch_media_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_query_action_fetch_media_object_data_free);
	_data_->self = g_object_ref (self);
	rygel_media_query_action_fetch_media_object_co (_data_);
}


static RygelMediaObject* rygel_media_query_action_fetch_media_object_finish (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaQueryActionFetchMediaObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_query_action_fetch_media_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaQueryActionFetchMediaObjectData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_query_action_fetch_media_object_co (data);
}


static gboolean rygel_media_query_action_fetch_media_object_co (RygelMediaQueryActionFetchMediaObjectData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 32:
		goto _state_32;
	}
	_state_0:
#line 137 "rygel-media-query-action.vala"
	if (_vala_strcmp0 (data->self->object_id, ((RygelMediaObject*) data->self->root_container)->id) == 0) {
#line 684 "rygel-media-query-action.c"
		data->result = _g_object_ref0 ((RygelMediaObject*) data->self->root_container);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	} else {
#line 140 "rygel-media-query-action.vala"
		g_debug ("rygel-media-query-action.vala:140: searching for object '%s'..", data->self->object_id);
#line 698 "rygel-media-query-action.c"
		data->_state_ = 32;
		rygel_media_container_find_object (data->self->root_container, data->self->object_id, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), rygel_media_query_action_fetch_media_object_ready, data);
		return FALSE;
		_state_32:
		data->media_object = rygel_media_container_find_object_finish (data->self->root_container, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
#line 144 "rygel-media-query-action.vala"
		if (data->media_object == NULL) {
#line 719 "rygel-media-query-action.c"
			data->_inner_error_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _ ("No such object"));
			{
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->media_object);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
		}
#line 148 "rygel-media-query-action.vala"
		g_debug ("rygel-media-query-action.vala:148: object '%s' found.", data->self->object_id);
#line 738 "rygel-media-query-action.c"
		data->result = data->media_object;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_object_unref0 (data->media_object);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 154 "rygel-media-query-action.vala"
static void rygel_media_query_action_conclude (RygelMediaQueryAction* self) {
#line 765 "rygel-media-query-action.c"
	char* didl;
#line 154 "rygel-media-query-action.vala"
	g_return_if_fail (self != NULL);
#line 156 "rygel-media-query-action.vala"
	gupnp_didl_lite_writer_filter (self->didl_writer, self->filter);
#line 159 "rygel-media-query-action.vala"
	didl = gupnp_didl_lite_writer_get_string (self->didl_writer);
#line 161 "rygel-media-query-action.vala"
	if (self->update_id == G_MAXUINT32) {
#line 162 "rygel-media-query-action.vala"
		self->update_id = (guint) self->system_update_id;
#line 777 "rygel-media-query-action.c"
	}
#line 166 "rygel-media-query-action.vala"
	gupnp_service_action_set (self->action, "Result", G_TYPE_STRING, didl, "NumberReturned", G_TYPE_UINT, self->number_returned, "TotalMatches", G_TYPE_UINT, self->total_matches, "UpdateID", G_TYPE_UINT, self->update_id, NULL);
#line 179 "rygel-media-query-action.vala"
	gupnp_service_action_return (self->action);
#line 180 "rygel-media-query-action.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 785 "rygel-media-query-action.c"
	_g_free0 (didl);
}


#line 183 "rygel-media-query-action.vala"
static void rygel_media_query_action_real_handle_error (RygelMediaQueryAction* self, GError* _error_) {
#line 183 "rygel-media-query-action.vala"
	g_return_if_fail (self != NULL);
#line 184 "rygel-media-query-action.vala"
	if (_error_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
#line 185 "rygel-media-query-action.vala"
		gupnp_service_action_return_error (self->action, (guint) _error_->code, _error_->message);
#line 798 "rygel-media-query-action.c"
	} else {
#line 187 "rygel-media-query-action.vala"
		gupnp_service_action_return_error (self->action, (guint) 701, _error_->message);
#line 802 "rygel-media-query-action.c"
	}
#line 190 "rygel-media-query-action.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 806 "rygel-media-query-action.c"
}


void rygel_media_query_action_handle_error (RygelMediaQueryAction* self, GError* _error_) {
	RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self)->handle_error (self, _error_);
}


static GCancellable* rygel_media_query_action_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelMediaQueryAction* self;
	self = (RygelMediaQueryAction*) base;
	result = self->priv->_cancellable;
#line 45 "rygel-media-query-action.vala"
	return result;
#line 822 "rygel-media-query-action.c"
}


static void rygel_media_query_action_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelMediaQueryAction* self;
	GCancellable* _tmp0_;
	self = (RygelMediaQueryAction*) base;
	self->priv->_cancellable = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_cancellable), _tmp0_);
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_media_query_action_class_init (RygelMediaQueryActionClass * klass) {
	rygel_media_query_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaQueryActionPrivate));
	RYGEL_MEDIA_QUERY_ACTION_CLASS (klass)->parse_args = rygel_media_query_action_real_parse_args;
	RYGEL_MEDIA_QUERY_ACTION_CLASS (klass)->handle_error = rygel_media_query_action_real_handle_error;
	G_OBJECT_CLASS (klass)->get_property = rygel_media_query_action_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_media_query_action_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_query_action_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE, "cancellable");
}


static void rygel_media_query_action_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_media_query_action_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = rygel_media_query_action_real_run;
	iface->run_finish = rygel_media_query_action_real_run_finish;
	iface->get_cancellable = rygel_media_query_action_real_get_cancellable;
	iface->set_cancellable = rygel_media_query_action_real_set_cancellable;
}


static void rygel_media_query_action_instance_init (RygelMediaQueryAction * self) {
	self->priv = RYGEL_MEDIA_QUERY_ACTION_GET_PRIVATE (self);
}


static void rygel_media_query_action_finalize (GObject* obj) {
	RygelMediaQueryAction * self;
	self = RYGEL_MEDIA_QUERY_ACTION (obj);
	_g_free0 (self->object_id);
	_g_free0 (self->browse_flag);
	_g_free0 (self->filter);
	_g_free0 (self->sort_criteria);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->root_container);
	_g_object_unref0 (self->http_server);
	_g_object_unref0 (self->didl_writer);
	_g_object_unref0 (self->xbox_hacks);
	_g_free0 (self->object_id_arg);
	G_OBJECT_CLASS (rygel_media_query_action_parent_class)->finalize (obj);
}


/**
 * Base class of Browse and Search actions.
 */
GType rygel_media_query_action_get_type (void) {
	static volatile gsize rygel_media_query_action_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_query_action_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaQueryActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_query_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaQueryAction), 0, (GInstanceInitFunc) rygel_media_query_action_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_media_query_action_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_media_query_action_type_id;
		rygel_media_query_action_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaQueryAction", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (rygel_media_query_action_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_media_query_action_type_id__volatile, rygel_media_query_action_type_id);
	}
	return rygel_media_query_action_type_id__volatile;
}


static void rygel_media_query_action_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaQueryAction * self;
	self = RYGEL_MEDIA_QUERY_ACTION (object);
	switch (property_id) {
		case RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_media_query_action_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaQueryAction * self;
	self = RYGEL_MEDIA_QUERY_ACTION (object);
	switch (property_id) {
		case RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




