/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

using GUPnP;

/**
 * Basic implementation of MS MediaReceiverRegistrar service version 1.
 */
internal class Rygel.MediaReceiverRegistrar: Service {
    public const string UPNP_ID =
                    "urn:microsoft.com:serviceId:X_MS_MediaReceiverRegistrar";
    public const string UPNP_TYPE =
                    "urn:microsoft.com:service:X_MS_MediaReceiverRegistrar:1";
    public const string DESCRIPTION_PATH =
                    "xml/X_MS_MediaReceiverRegistrar1.xml";

    public override void constructed () {
        this.action_invoked["IsAuthorized"].connect (this.is_authorized_cb);
        this.action_invoked["IsValidated"].connect (this.is_authorized_cb);
        this.action_invoked["RegisterDevice"].connect (this.register_device_cb);
    }

    /* IsAuthorized and IsValided action implementations (fake) */
    private void is_authorized_cb (Service             registrar,
                                   owned ServiceAction action) {
        action.set ("Result", typeof (int), 1);

        action.return ();
    }

    private void register_device_cb (Service             registrar,
                                     owned ServiceAction action) {
        action.set ("RegistrationRespMsg",
                    typeof (string),
                    "WhatisSupposedToBeHere");

        action.return ();
    }
}
