/* rygel-http-get.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-http-get.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2006, 2007, 2008 OpenedHand Ltd.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jorn Baayen <jorn.baayen@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _rygel_thumbnail_unref0(var) ((var == NULL) ? NULL : (var = (rygel_thumbnail_unref (var), NULL)))
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_http_get_handler_unref0(var) ((var == NULL) ? NULL : (var = (rygel_http_get_handler_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelHTTPItemURIPrivate RygelHTTPItemURIPrivate;

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;

#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;
#define _rygel_transcoder_unref0(var) ((var == NULL) ? NULL : (var = (rygel_transcoder_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelHttpGetHandleData RygelHttpGetHandleData;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;
#define _rygel_media_object_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_object_unref (var), NULL)))

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;
typedef struct _RygelHttpGetFindItemData RygelHttpGetFindItemData;

#define RYGEL_TYPE_HTTP_TIME_SEEK (rygel_http_time_seek_get_type ())
#define RYGEL_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeek))
#define RYGEL_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))
#define RYGEL_IS_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_IS_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_HTTP_TIME_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))

typedef struct _RygelHTTPTimeSeek RygelHTTPTimeSeek;
typedef struct _RygelHTTPTimeSeekClass RygelHTTPTimeSeekClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHttpGetHandleItemRequestData RygelHttpGetHandleItemRequestData;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPSeek* seek;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelHTTPGetPrivate {
	gint thumbnail_index;
	gint subtitle_index;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPItemURI {
	GObject parent_instance;
	RygelHTTPItemURIPrivate * priv;
	char* item_id;
	gint thumbnail_index;
	gint subtitle_index;
	char* transcode_target;
	RygelHTTPServer* http_server;
};

struct _RygelHTTPItemURIClass {
	GObjectClass parent_class;
};

struct _RygelHttpGetHandleData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGet* self;
	char* header;
	gboolean _tmp0_;
	gboolean _tmp1_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp2_;
	char* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp7_;
	RygelTranscoder* transcoder;
	RygelHTTPGetHandler* _tmp8_;
	RygelHTTPGetHandler* _tmp9_;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaObjectPrivate * priv;
	char* id;
};

struct _RygelMediaObjectClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaObject *self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	glong size;
	GeeArrayList* subtitles;
	GeeArrayList* thumbnails;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	gint64 duration;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_pixel_width) (RygelVisualItem* self);
	void (*set_pixel_width) (RygelVisualItem* self, gint value);
	gint (*get_pixel_height) (RygelVisualItem* self);
	void (*set_pixel_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelVideoItem {
	RygelAudioItem parent_instance;
	RygelVideoItemPrivate * priv;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelHttpGetFindItemData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGet* self;
	RygelMusicItem* music;
	RygelMediaItem* _tmp0_;
	RygelThumbnail* _tmp1_;
	RygelVisualItem* visual;
	RygelMediaItem* _tmp2_;
	RygelThumbnail* _tmp3_;
	RygelMediaItem* _tmp4_;
	RygelSubtitle* _tmp5_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()
struct _RygelHttpGetHandleItemRequestData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGet* self;
	gboolean need_time_seek;
	gboolean need_byte_seek;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	RygelHTTPTimeSeek* _tmp3_;
	RygelHTTPSeek* _tmp4_;
	RygelHTTPByteSeek* _tmp5_;
	RygelHTTPSeek* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	gboolean _tmp9_;
	RygelHTTPResponse* response;
	GError * _inner_error_;
};


static gpointer rygel_http_get_parent_class = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
gpointer rygel_media_object_ref (gpointer instance);
void rygel_media_object_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_object (GValue* value, gpointer v_object);
void rygel_value_take_media_object (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_object (const GValue* value);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
gpointer rygel_thumbnail_ref (gpointer instance);
void rygel_thumbnail_unref (gpointer instance);
GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_thumbnail (GValue* value, gpointer v_object);
void rygel_value_take_thumbnail (GValue* value, gpointer v_object);
gpointer rygel_value_get_thumbnail (const GValue* value);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
gpointer rygel_http_get_handler_ref (gpointer instance);
void rygel_http_get_handler_unref (gpointer instance);
GParamSpec* rygel_param_spec_http_get_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_http_get_handler (GValue* value, gpointer v_object);
void rygel_value_take_http_get_handler (GValue* value, gpointer v_object);
gpointer rygel_value_get_http_get_handler (const GValue* value);
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_GET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_GET, RygelHTTPGetPrivate))
enum  {
	RYGEL_HTTP_GET_DUMMY_PROPERTY
};
#define RYGEL_HTTP_GET_TRANSFER_MODE_HEADER "transferMode.dlna.org"
RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
static void rygel_http_get_real_handle_data_free (gpointer _data);
static void rygel_http_get_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_get_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_http_get_real_handle_co (RygelHttpGetHandleData* data);
GQuark rygel_http_request_error_quark (void);
gpointer rygel_transcoder_ref (gpointer instance);
void rygel_transcoder_unref (gpointer instance);
GParamSpec* rygel_param_spec_transcoder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_transcoder (GValue* value, gpointer v_object);
void rygel_value_take_transcoder (GValue* value, gpointer v_object);
gpointer rygel_value_get_transcoder (const GValue* value);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const char* target, GError** error);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (RygelTranscoder* transcoder, GCancellable* cancellable);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type, RygelTranscoder* transcoder, GCancellable* cancellable);
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable);
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable);
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
static void rygel_http_get_ensure_correct_mode (RygelHTTPGet* self, GError** error);
static void rygel_http_get_handle_item_request (RygelHTTPGet* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_get_handle_item_request_finish (RygelHTTPGet* self, GAsyncResult* _res_, GError** error);
static void rygel_http_get_real_find_item_data_free (gpointer _data);
static void rygel_http_get_real_find_item (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_get_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_http_get_real_find_item_co (RygelHttpGetFindItemData* data);
void rygel_http_request_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_request_find_item_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
GType rygel_video_item_get_type (void) G_GNUC_CONST;
static void rygel_http_get_handle_item_request_data_free (gpointer _data);
static void rygel_http_get_handle_item_request_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_http_get_handle_item_request_co (RygelHttpGetHandleItemRequestData* data);
gboolean rygel_http_time_seek_needed (RygelHTTPGet* request);
gboolean rygel_http_byte_seek_needed (RygelHTTPGet* request);
gboolean rygel_http_time_seek_requested (RygelHTTPGet* request);
gboolean rygel_http_byte_seek_requested (RygelHTTPGet* request);
GQuark rygel_http_seek_error_quark (void);
RygelHTTPTimeSeek* rygel_http_time_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_http_time_seek_get_type (void) G_GNUC_CONST;
RygelHTTPByteSeek* rygel_http_byte_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* get_request);
static void _lambda3_ (const char* name, const char* value, RygelHTTPGet* self);
static void __lambda3__soup_message_headers_foreach_func (const char* name, const char* value, gpointer self);
void rygel_http_request_end (RygelHTTPRequest* self, guint status);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* get_request);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
gboolean rygel_media_item_streamable (RygelMediaItem* self);
gboolean rygel_media_item_should_stream (RygelMediaItem* self);
static void rygel_http_get_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 43 "rygel-http-get.vala"
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
#line 571 "rygel-http-get.c"
	RygelHTTPGet * self;
#line 43 "rygel-http-get.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 43 "rygel-http-get.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 43 "rygel-http-get.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 46 "rygel-http-get.vala"
	self = (RygelHTTPGet*) rygel_http_request_construct (object_type, http_server, server, msg);
#line 48 "rygel-http-get.vala"
	self->priv->thumbnail_index = -1;
#line 49 "rygel-http-get.vala"
	self->priv->subtitle_index = -1;
#line 585 "rygel-http-get.c"
	return self;
}


#line 43 "rygel-http-get.vala"
RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
#line 43 "rygel-http-get.vala"
	return rygel_http_get_construct (RYGEL_TYPE_HTTP_GET, http_server, server, msg);
#line 594 "rygel-http-get.c"
}


static void rygel_http_get_real_handle_data_free (gpointer _data) {
	RygelHttpGetHandleData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelHttpGetHandleData, data);
}


static void rygel_http_get_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPGet * self;
	RygelHttpGetHandleData* _data_;
	self = (RygelHTTPGet*) base;
	_data_ = g_slice_new0 (RygelHttpGetHandleData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_real_handle);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_real_handle_data_free);
	_data_->self = g_object_ref (self);
	rygel_http_get_real_handle_co (_data_);
}


static void rygel_http_get_real_handle_finish (RygelHTTPRequest* base, GAsyncResult* _res_, GError** error) {
	RygelHttpGetHandleData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_get_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetHandleData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_http_get_real_handle_co (data);
}


static gboolean rygel_http_get_real_handle_co (RygelHttpGetHandleData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 5:
		goto _state_5;
	}
	_state_0:
	data->header = g_strdup (soup_message_headers_get_one (((RygelHTTPRequest*) data->self)->msg->request_headers, "getcontentFeatures.dlna.org"));
	data->_tmp2_ = NULL;
#line 57 "rygel-http-get.vala"
	if ((data->_tmp4_ = _vala_strcmp0 (data->_tmp3_ = (g_object_get (((RygelHTTPRequest*) data->self)->msg, "method", &data->_tmp2_, NULL), data->_tmp2_), "HEAD") != 0, _g_free0 (data->_tmp3_), data->_tmp4_)) {
#line 649 "rygel-http-get.c"
		data->_tmp5_ = NULL;
#line 57 "rygel-http-get.vala"
		data->_tmp1_ = _vala_strcmp0 (data->_tmp6_ = (g_object_get (((RygelHTTPRequest*) data->self)->msg, "method", &data->_tmp5_, NULL), data->_tmp5_), "GET") != 0;
#line 653 "rygel-http-get.c"
		_g_free0 (data->_tmp6_);
	} else {
#line 57 "rygel-http-get.vala"
		data->_tmp1_ = FALSE;
#line 658 "rygel-http-get.c"
	}
#line 57 "rygel-http-get.vala"
	if (data->_tmp1_) {
#line 57 "rygel-http-get.vala"
		data->_tmp0_ = TRUE;
#line 664 "rygel-http-get.c"
	} else {
#line 58 "rygel-http-get.vala"
		if (data->header != NULL) {
#line 58 "rygel-http-get.vala"
			data->_tmp7_ = _vala_strcmp0 (data->header, "1") != 0;
#line 670 "rygel-http-get.c"
		} else {
#line 58 "rygel-http-get.vala"
			data->_tmp7_ = FALSE;
#line 674 "rygel-http-get.c"
		}
#line 58 "rygel-http-get.vala"
		data->_tmp0_ = data->_tmp7_;
#line 678 "rygel-http-get.c"
	}
#line 57 "rygel-http-get.vala"
	if (data->_tmp0_) {
#line 682 "rygel-http-get.c"
		data->_inner_error_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _ ("Invalid Request"));
		{
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->header);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
	}
#line 62 "rygel-http-get.vala"
	if (((RygelHTTPRequest*) data->self)->uri->transcode_target != NULL) {
#line 701 "rygel-http-get.c"
		data->transcoder = rygel_http_server_get_transcoder (((RygelHTTPRequest*) data->self)->http_server, ((RygelHTTPRequest*) data->self)->uri->transcode_target, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->header);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
#line 65 "rygel-http-get.vala"
		data->self->handler = (data->_tmp8_ = (RygelHTTPGetHandler*) rygel_http_transcode_handler_new (data->transcoder, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self)), _rygel_http_get_handler_unref0 (data->self->handler), data->_tmp8_);
#line 719 "rygel-http-get.c"
		_rygel_transcoder_unref0 (data->transcoder);
	}
#line 69 "rygel-http-get.vala"
	if (data->self->handler == NULL) {
#line 70 "rygel-http-get.vala"
		data->self->handler = (data->_tmp9_ = (RygelHTTPGetHandler*) rygel_http_identity_handler_new (rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self)), _rygel_http_get_handler_unref0 (data->self->handler), data->_tmp9_);
#line 726 "rygel-http-get.c"
	}
#line 73 "rygel-http-get.vala"
	rygel_http_get_ensure_correct_mode (data->self, &data->_inner_error_);
#line 730 "rygel-http-get.c"
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_free0 (data->header);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->_state_ = 5;
	rygel_http_get_handle_item_request (data->self, rygel_http_get_handle_ready, data);
	return FALSE;
	_state_5:
#line 75 "rygel-http-get.vala"
	rygel_http_get_handle_item_request_finish (data->self, data->_res_, &data->_inner_error_);
#line 751 "rygel-http-get.c"
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_free0 (data->header);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	_g_free0 (data->header);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_http_get_real_find_item_data_free (gpointer _data) {
	RygelHttpGetFindItemData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelHttpGetFindItemData, data);
}


static void rygel_http_get_real_find_item (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPGet * self;
	RygelHttpGetFindItemData* _data_;
	self = (RygelHTTPGet*) base;
	_data_ = g_slice_new0 (RygelHttpGetFindItemData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_real_find_item);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_real_find_item_data_free);
	_data_->self = g_object_ref (self);
	rygel_http_get_real_find_item_co (_data_);
}


static void rygel_http_get_real_find_item_finish (RygelHTTPRequest* base, GAsyncResult* _res_, GError** error) {
	RygelHttpGetFindItemData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_get_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetFindItemData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_http_get_real_find_item_co (data);
}


static gpointer _rygel_media_object_ref0 (gpointer self) {
	return self ? rygel_media_object_ref (self) : NULL;
}


static gpointer _rygel_thumbnail_ref0 (gpointer self) {
	return self ? rygel_thumbnail_ref (self) : NULL;
}


static gboolean rygel_http_get_real_find_item_co (RygelHttpGetFindItemData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 6:
		goto _state_6;
	}
	_state_0:
	data->_state_ = 6;
	RYGEL_HTTP_REQUEST_CLASS (rygel_http_get_parent_class)->find_item (RYGEL_HTTP_REQUEST (data->self), rygel_http_get_find_item_ready, data);
	return FALSE;
	_state_6:
#line 79 "rygel-http-get.vala"
	RYGEL_HTTP_REQUEST_CLASS (rygel_http_get_parent_class)->find_item_finish (RYGEL_HTTP_REQUEST (data->self), data->_res_, &data->_inner_error_);
#line 842 "rygel-http-get.c"
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
#line 81 "rygel-http-get.vala"
	if (((RygelHTTPRequest*) data->self)->uri->thumbnail_index >= 0) {
#line 82 "rygel-http-get.vala"
		if (RYGEL_IS_MUSIC_ITEM (((RygelHTTPRequest*) data->self)->item)) {
#line 860 "rygel-http-get.c"
			data->music = _rygel_media_object_ref0 ((data->_tmp0_ = ((RygelHTTPRequest*) data->self)->item, RYGEL_IS_MUSIC_ITEM (data->_tmp0_) ? ((RygelMusicItem*) data->_tmp0_) : NULL));
#line 85 "rygel-http-get.vala"
			data->self->thumbnail = (data->_tmp1_ = _rygel_thumbnail_ref0 (data->music->album_art), _rygel_thumbnail_unref0 (data->self->thumbnail), data->_tmp1_);
#line 864 "rygel-http-get.c"
			_rygel_media_object_unref0 (data->music);
		} else {
#line 86 "rygel-http-get.vala"
			if (RYGEL_IS_VISUAL_ITEM (((RygelHTTPRequest*) data->self)->item)) {
#line 869 "rygel-http-get.c"
				data->visual = _rygel_media_object_ref0 ((data->_tmp2_ = ((RygelHTTPRequest*) data->self)->item, RYGEL_IS_VISUAL_ITEM (data->_tmp2_) ? ((RygelVisualItem*) data->_tmp2_) : NULL));
#line 89 "rygel-http-get.vala"
				data->self->thumbnail = (data->_tmp3_ = (RygelThumbnail*) gee_abstract_list_get ((GeeAbstractList*) rygel_visual_item_get_thumbnails (data->visual), ((RygelHTTPRequest*) data->self)->uri->thumbnail_index), _rygel_thumbnail_unref0 (data->self->thumbnail), data->_tmp3_);
#line 873 "rygel-http-get.c"
				_rygel_media_object_unref0 (data->visual);
			} else {
				data->_inner_error_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "No Thumbnail available for item '%s", ((RygelMediaObject*) ((RygelHTTPRequest*) data->self)->item)->id);
				{
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
			}
		}
	} else {
#line 96 "rygel-http-get.vala"
		if (((RygelHTTPRequest*) data->self)->uri->subtitle_index >= 0) {
#line 97 "rygel-http-get.vala"
			if (!RYGEL_IS_VIDEO_ITEM (((RygelHTTPRequest*) data->self)->item)) {
#line 897 "rygel-http-get.c"
				data->_inner_error_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "No subtitles available for item '%s", ((RygelMediaObject*) ((RygelHTTPRequest*) data->self)->item)->id);
				{
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
			}
#line 103 "rygel-http-get.vala"
			data->self->subtitle = (data->_tmp5_ = (RygelSubtitle*) gee_abstract_list_get ((GeeAbstractList*) (data->_tmp4_ = ((RygelHTTPRequest*) data->self)->item, RYGEL_IS_VIDEO_ITEM (data->_tmp4_) ? ((RygelVideoItem*) data->_tmp4_) : NULL)->subtitles, ((RygelHTTPRequest*) data->self)->uri->subtitle_index), _rygel_subtitle_unref0 (data->self->subtitle), data->_tmp5_);
#line 915 "rygel-http-get.c"
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_http_get_handle_item_request_data_free (gpointer _data) {
	RygelHttpGetHandleItemRequestData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelHttpGetHandleItemRequestData, data);
}


static void rygel_http_get_handle_item_request (RygelHTTPGet* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpGetHandleItemRequestData* _data_;
	_data_ = g_slice_new0 (RygelHttpGetHandleItemRequestData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_handle_item_request);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_handle_item_request_data_free);
	_data_->self = g_object_ref (self);
	rygel_http_get_handle_item_request_co (_data_);
}


static void rygel_http_get_handle_item_request_finish (RygelHTTPGet* self, GAsyncResult* _res_, GError** error) {
	RygelHttpGetHandleItemRequestData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_get_handle_item_request_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetHandleItemRequestData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_http_get_handle_item_request_co (data);
}


#line 126 "rygel-http-get.vala"
static void _lambda3_ (const char* name, const char* value, RygelHTTPGet* self) {
#line 126 "rygel-http-get.vala"
	g_return_if_fail (name != NULL);
#line 126 "rygel-http-get.vala"
	g_return_if_fail (value != NULL);
#line 127 "rygel-http-get.vala"
	g_debug ("rygel-http-get.vala:127: %s : %s", name, value);
#line 973 "rygel-http-get.c"
}


#line 126 "rygel-http-get.vala"
static void __lambda3__soup_message_headers_foreach_func (const char* name, const char* value, gpointer self) {
#line 979 "rygel-http-get.c"
	_lambda3_ (name, value, self);
}


static gboolean rygel_http_get_handle_item_request_co (RygelHttpGetHandleItemRequestData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 7:
		goto _state_7;
	}
	_state_0:
	data->need_time_seek = rygel_http_time_seek_needed (data->self);
	data->need_byte_seek = rygel_http_byte_seek_needed (data->self);
#line 112 "rygel-http-get.vala"
	if (rygel_http_time_seek_requested (data->self)) {
#line 112 "rygel-http-get.vala"
		data->_tmp1_ = !data->need_time_seek;
#line 1000 "rygel-http-get.c"
	} else {
#line 112 "rygel-http-get.vala"
		data->_tmp1_ = FALSE;
#line 1004 "rygel-http-get.c"
	}
#line 112 "rygel-http-get.vala"
	if (data->_tmp1_) {
#line 112 "rygel-http-get.vala"
		data->_tmp0_ = TRUE;
#line 1010 "rygel-http-get.c"
	} else {
#line 113 "rygel-http-get.vala"
		if (rygel_http_byte_seek_requested (data->self)) {
#line 113 "rygel-http-get.vala"
			data->_tmp2_ = !data->need_byte_seek;
#line 1016 "rygel-http-get.c"
		} else {
#line 113 "rygel-http-get.vala"
			data->_tmp2_ = FALSE;
#line 1020 "rygel-http-get.c"
		}
#line 113 "rygel-http-get.vala"
		data->_tmp0_ = data->_tmp2_;
#line 1024 "rygel-http-get.c"
	}
#line 112 "rygel-http-get.vala"
	if (data->_tmp0_) {
#line 1028 "rygel-http-get.c"
		data->_inner_error_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, "Invalid seek request");
		{
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
	}
#line 117 "rygel-http-get.vala"
	if (data->need_time_seek) {
#line 1046 "rygel-http-get.c"
		data->_tmp3_ = rygel_http_time_seek_new (data->self, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
#line 118 "rygel-http-get.vala"
		data->self->seek = (data->_tmp4_ = (RygelHTTPSeek*) data->_tmp3_, _g_object_unref0 (data->self->seek), data->_tmp4_);
#line 1063 "rygel-http-get.c"
	} else {
#line 119 "rygel-http-get.vala"
		if (data->need_byte_seek) {
#line 1067 "rygel-http-get.c"
			data->_tmp5_ = rygel_http_byte_seek_new (data->self, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
#line 120 "rygel-http-get.vala"
			data->self->seek = (data->_tmp6_ = (RygelHTTPSeek*) data->_tmp5_, _g_object_unref0 (data->self->seek), data->_tmp6_);
#line 1084 "rygel-http-get.c"
		}
	}
#line 124 "rygel-http-get.vala"
	rygel_http_get_handler_add_response_headers (data->self->handler, data->self);
#line 125 "rygel-http-get.vala"
	g_debug ("rygel-http-get.vala:125: Following HTTP headers appended to response:");
#line 126 "rygel-http-get.vala"
	soup_message_headers_foreach (((RygelHTTPRequest*) data->self)->msg->response_headers, __lambda3__soup_message_headers_foreach_func, data->self);
#line 1093 "rygel-http-get.c"
	data->_tmp7_ = NULL;
#line 130 "rygel-http-get.vala"
	if ((data->_tmp9_ = _vala_strcmp0 (data->_tmp8_ = (g_object_get (((RygelHTTPRequest*) data->self)->msg, "method", &data->_tmp7_, NULL), data->_tmp7_), "HEAD") == 0, _g_free0 (data->_tmp8_), data->_tmp9_)) {
#line 132 "rygel-http-get.vala"
		soup_server_unpause_message (((RygelHTTPRequest*) data->self)->server, ((RygelHTTPRequest*) data->self)->msg);
#line 133 "rygel-http-get.vala"
		rygel_http_request_end ((RygelHTTPRequest*) data->self, (guint) SOUP_STATUS_OK);
#line 1101 "rygel-http-get.c"
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->response = rygel_http_get_handler_render_body (data->self->handler, data->self);
	data->_state_ = 7;
	rygel_state_machine_run ((RygelStateMachine*) data->response, rygel_http_get_handle_item_request_ready, data);
	return FALSE;
	_state_7:
#line 140 "rygel-http-get.vala"
	rygel_state_machine_run_finish ((RygelStateMachine*) data->response, data->_res_);
#line 142 "rygel-http-get.vala"
	rygel_http_request_end ((RygelHTTPRequest*) data->self, (guint) SOUP_STATUS_NONE);
#line 1121 "rygel-http-get.c"
	_g_object_unref0 (data->response);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 145 "rygel-http-get.vala"
static void rygel_http_get_ensure_correct_mode (RygelHTTPGet* self, GError** error) {
#line 1137 "rygel-http-get.c"
	char* mode;
	gboolean correct;
	const char* _tmp6_;
	GQuark _tmp7_;
	static GQuark _tmp7__label0 = 0;
	static GQuark _tmp7__label1 = 0;
	static GQuark _tmp7__label2 = 0;
	GError * _inner_error_ = NULL;
#line 145 "rygel-http-get.vala"
	g_return_if_fail (self != NULL);
#line 146 "rygel-http-get.vala"
	mode = g_strdup (soup_message_headers_get_one (((RygelHTTPRequest*) self)->msg->request_headers, RYGEL_HTTP_GET_TRANSFER_MODE_HEADER));
#line 147 "rygel-http-get.vala"
	correct = TRUE;
#line 1152 "rygel-http-get.c"
	_tmp6_ = mode;
	_tmp7_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
	if (_tmp7_ == ((0 != _tmp7__label0) ? _tmp7__label0 : (_tmp7__label0 = g_quark_from_static_string ("Streaming"))))
	switch (0) {
		default:
		{
			gboolean _tmp0_ = FALSE;
#line 151 "rygel-http-get.vala"
			if (RYGEL_IS_HTTP_TRANSCODE_HANDLER (self->handler)) {
#line 151 "rygel-http-get.vala"
				_tmp0_ = TRUE;
#line 1164 "rygel-http-get.c"
			} else {
				gboolean _tmp1_ = FALSE;
				gboolean _tmp2_ = FALSE;
#line 152 "rygel-http-get.vala"
				if (rygel_media_item_streamable (((RygelHTTPRequest*) self)->item)) {
#line 153 "rygel-http-get.vala"
					_tmp2_ = self->subtitle == NULL;
#line 1172 "rygel-http-get.c"
				} else {
#line 152 "rygel-http-get.vala"
					_tmp2_ = FALSE;
#line 1176 "rygel-http-get.c"
				}
#line 152 "rygel-http-get.vala"
				if (_tmp2_) {
#line 154 "rygel-http-get.vala"
					_tmp1_ = self->thumbnail == NULL;
#line 1182 "rygel-http-get.c"
				} else {
#line 152 "rygel-http-get.vala"
					_tmp1_ = FALSE;
#line 1186 "rygel-http-get.c"
				}
#line 152 "rygel-http-get.vala"
				_tmp0_ = _tmp1_;
#line 1190 "rygel-http-get.c"
			}
#line 151 "rygel-http-get.vala"
			correct = _tmp0_;
#line 156 "rygel-http-get.vala"
			break;
#line 1196 "rygel-http-get.c"
		}
	} else if ((_tmp7_ == ((0 != _tmp7__label1) ? _tmp7__label1 : (_tmp7__label1 = g_quark_from_static_string ("Interactive")))) || (_tmp7_ == ((0 != _tmp7__label2) ? _tmp7__label2 : (_tmp7__label2 = g_quark_from_static_string ("Background")))))
	switch (0) {
		default:
		{
			gboolean _tmp3_ = FALSE;
#line 159 "rygel-http-get.vala"
			if (RYGEL_IS_HTTP_IDENTITY_HANDLER (self->handler)) {
#line 1205 "rygel-http-get.c"
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
#line 160 "rygel-http-get.vala"
				if (!rygel_media_item_should_stream (((RygelHTTPRequest*) self)->item)) {
#line 160 "rygel-http-get.vala"
					_tmp5_ = TRUE;
#line 1212 "rygel-http-get.c"
				} else {
#line 161 "rygel-http-get.vala"
					_tmp5_ = self->subtitle != NULL;
#line 1216 "rygel-http-get.c"
				}
#line 160 "rygel-http-get.vala"
				if (_tmp5_) {
#line 160 "rygel-http-get.vala"
					_tmp4_ = TRUE;
#line 1222 "rygel-http-get.c"
				} else {
#line 162 "rygel-http-get.vala"
					_tmp4_ = self->thumbnail != NULL;
#line 1226 "rygel-http-get.c"
				}
#line 160 "rygel-http-get.vala"
				_tmp3_ = _tmp4_;
#line 1230 "rygel-http-get.c"
			} else {
#line 159 "rygel-http-get.vala"
				_tmp3_ = FALSE;
#line 1234 "rygel-http-get.c"
			}
#line 159 "rygel-http-get.vala"
			correct = _tmp3_;
#line 164 "rygel-http-get.vala"
			break;
#line 1240 "rygel-http-get.c"
		}
	}
#line 167 "rygel-http-get.vala"
	if (!correct) {
#line 1245 "rygel-http-get.c"
		_inner_error_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, "%s mode not supported for '%s'", mode, ((RygelMediaObject*) ((RygelHTTPRequest*) self)->item)->id);
		{
			if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (mode);
				return;
			} else {
				_g_free0 (mode);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_g_free0 (mode);
}


static void rygel_http_get_class_init (RygelHTTPGetClass * klass) {
	rygel_http_get_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPGetPrivate));
	RYGEL_HTTP_REQUEST_CLASS (klass)->handle = rygel_http_get_real_handle;
	RYGEL_HTTP_REQUEST_CLASS (klass)->handle_finish = rygel_http_get_real_handle_finish;
	RYGEL_HTTP_REQUEST_CLASS (klass)->find_item = rygel_http_get_real_find_item;
	RYGEL_HTTP_REQUEST_CLASS (klass)->find_item_finish = rygel_http_get_real_find_item_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_finalize;
}


static void rygel_http_get_instance_init (RygelHTTPGet * self) {
	self->priv = RYGEL_HTTP_GET_GET_PRIVATE (self);
}


static void rygel_http_get_finalize (GObject* obj) {
	RygelHTTPGet * self;
	self = RYGEL_HTTP_GET (obj);
	_rygel_thumbnail_unref0 (self->thumbnail);
	_rygel_subtitle_unref0 (self->subtitle);
	_g_object_unref0 (self->seek);
	_rygel_http_get_handler_unref0 (self->handler);
	G_OBJECT_CLASS (rygel_http_get_parent_class)->finalize (obj);
}


/**
 * Responsible for handling HTTP GET & HEAD client requests.
 */
GType rygel_http_get_get_type (void) {
	static volatile gsize rygel_http_get_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGet), 0, (GInstanceInitFunc) rygel_http_get_instance_init, NULL };
		GType rygel_http_get_type_id;
		rygel_http_get_type_id = g_type_register_static (RYGEL_TYPE_HTTP_REQUEST, "RygelHTTPGet", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_type_id__volatile, rygel_http_get_type_id);
	}
	return rygel_http_get_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




