/* rygel-mediathek-rss-container.c generated by valac 0.11.2, the Vala compiler
 * generated from rygel-mediathek-rss-container.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <gee.h>
#include <libxml/xpath.h>


#define RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER (rygel_mediathek_rss_container_get_type ())
#define RYGEL_MEDIATHEK_RSS_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER, RygelMediathekRssContainer))
#define RYGEL_MEDIATHEK_RSS_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER, RygelMediathekRssContainerClass))
#define RYGEL_MEDIATHEK_IS_RSS_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER))
#define RYGEL_MEDIATHEK_IS_RSS_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER))
#define RYGEL_MEDIATHEK_RSS_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER, RygelMediathekRssContainerClass))

typedef struct _RygelMediathekRssContainer RygelMediathekRssContainer;
typedef struct _RygelMediathekRssContainerClass RygelMediathekRssContainerClass;
typedef struct _RygelMediathekRssContainerPrivate RygelMediathekRssContainerPrivate;
#define _soup_date_free0(var) ((var == NULL) ? NULL : (var = (soup_date_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM (rygel_mediathek_video_item_get_type ())
#define RYGEL_MEDIATHEK_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM, RygelMediathekVideoItem))
#define RYGEL_MEDIATHEK_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM, RygelMediathekVideoItemClass))
#define RYGEL_MEDIATHEK_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIATHEK_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIATHEK_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM, RygelMediathekVideoItemClass))

typedef struct _RygelMediathekVideoItem RygelMediathekVideoItem;
typedef struct _RygelMediathekVideoItemClass RygelMediathekVideoItemClass;
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIATHEK_TYPE_ROOT_CONTAINER (rygel_mediathek_root_container_get_type ())
#define RYGEL_MEDIATHEK_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_ROOT_CONTAINER, RygelMediathekRootContainer))
#define RYGEL_MEDIATHEK_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_ROOT_CONTAINER, RygelMediathekRootContainerClass))
#define RYGEL_MEDIATHEK_IS_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIATHEK_IS_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIATHEK_ROOT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_ROOT_CONTAINER, RygelMediathekRootContainerClass))

typedef struct _RygelMediathekRootContainer RygelMediathekRootContainer;
typedef struct _RygelMediathekRootContainerClass RygelMediathekRootContainerClass;
typedef struct _RygelMediathekRootContainerPrivate RygelMediathekRootContainerPrivate;

struct _RygelMediathekRssContainer {
	RygelSimpleContainer parent_instance;
	RygelMediathekRssContainerPrivate * priv;
};

struct _RygelMediathekRssContainerClass {
	RygelSimpleContainerClass parent_class;
};

struct _RygelMediathekRssContainerPrivate {
	guint zdf_content_id;
	SoupDate* last_modified;
};

typedef enum  {
	RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR
} RygelMediathekVideoItemError;
#define RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR rygel_mediathek_video_item_error_quark ()
struct _RygelMediathekRootContainer {
	RygelSimpleContainer parent_instance;
	RygelMediathekRootContainerPrivate * priv;
	SoupSessionAsync* session;
};

struct _RygelMediathekRootContainerClass {
	RygelSimpleContainerClass parent_class;
};


static gpointer rygel_mediathek_rss_container_parent_class = NULL;

GType rygel_mediathek_rss_container_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIATHEK_RSS_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER, RygelMediathekRssContainerPrivate))
enum  {
	RYGEL_MEDIATHEK_RSS_CONTAINER_DUMMY_PROPERTY
};
static void rygel_mediathek_rss_container_on_feed_got (RygelMediathekRssContainer* self, SoupSession* session, SoupMessage* msg);
static gboolean rygel_mediathek_rss_container_parse_response (RygelMediathekRssContainer* self, const gchar* data, gsize length);
GType rygel_mediathek_video_item_get_type (void) G_GNUC_CONST;
GQuark rygel_mediathek_video_item_error_quark (void);
RygelMediathekVideoItem* rygel_mediathek_video_item_create_from_xml (RygelMediaContainer* parent, xmlNode* item, GError** error);
void rygel_mediathek_rss_container_update (RygelMediathekRssContainer* self);
GType rygel_mediathek_root_container_get_type (void) G_GNUC_CONST;
static void _rygel_mediathek_rss_container_on_feed_got_soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
RygelMediathekRssContainer* rygel_mediathek_rss_container_new (RygelMediaContainer* parent, guint id);
RygelMediathekRssContainer* rygel_mediathek_rss_container_construct (GType object_type, RygelMediaContainer* parent, guint id);
static void rygel_mediathek_rss_container_finalize (GObject* obj);


static void rygel_mediathek_rss_container_on_feed_got (RygelMediathekRssContainer* self, SoupSession* session, SoupMessage* msg) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (session != NULL);
	g_return_if_fail (msg != NULL);
	switch ((g_object_get (msg, "status-code", &_tmp0_, NULL), _tmp0_)) {
		case 304:
		{
			g_message ("rygel-mediathek-rss-container.vala:34: Feed has not changed, nothing t" \
"o do");
			break;
		}
		case 200:
		{
			gboolean _tmp1_;
			_tmp1_ = rygel_mediathek_rss_container_parse_response (self, (const gchar*) msg->response_body->data, (gsize) msg->response_body->length);
			if (_tmp1_) {
				const gchar* _tmp2_ = NULL;
				SoupDate* _tmp3_ = NULL;
				SoupDate* _tmp4_;
				_tmp2_ = soup_message_headers_get_one (msg->response_headers, "Date");
				_tmp3_ = soup_date_new_from_string (_tmp2_);
				_tmp4_ = _tmp3_;
				_soup_date_free0 (self->priv->last_modified);
				self->priv->last_modified = _tmp4_;
			}
			break;
		}
		default:
		{
			guint _tmp5_;
			guint _tmp6_;
			const gchar* _tmp7_ = NULL;
			_tmp7_ = soup_status_get_phrase ((g_object_get (msg, "status-code", &_tmp6_, NULL), _tmp6_));
			g_warning ("rygel-mediathek-rss-container.vala:45: Got unexpected response %u (%s)", (g_object_get (msg, "status-code", &_tmp5_, NULL), _tmp5_), _tmp7_);
			break;
		}
	}
}


static gboolean rygel_mediathek_rss_container_parse_response (RygelMediathekRssContainer* self, const gchar* data, gsize length) {
	gboolean result = FALSE;
	gboolean ret;
	xmlDoc* _tmp0_ = NULL;
	xmlDoc* doc;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (data != NULL, FALSE);
	ret = FALSE;
	_tmp0_ = xmlParseMemory (data, (gint) length);
	doc = _tmp0_;
	if (doc != NULL) {
		xmlXPathContext* _tmp1_ = NULL;
		xmlXPathContext* ctx;
		xmlXPathObject* _tmp2_ = NULL;
		xmlXPathObject* xpo;
		gboolean _tmp3_ = FALSE;
		xmlXPathObject* _tmp8_ = NULL;
		gee_abstract_collection_clear ((GeeAbstractCollection*) ((RygelSimpleContainer*) self)->children);
		((RygelMediaContainer*) self)->child_count = 0;
		_tmp1_ = xmlXPathNewContext (doc);
		ctx = _tmp1_;
		_tmp2_ = xmlXPathEval ("/rss/channel/title", ctx);
		xpo = _tmp2_;
		if (xpo->type == XPATH_NODESET) {
			gint _tmp4_;
			_tmp4_ = xmlXPathNodeSetGetLength (xpo->nodesetval);
			_tmp3_ = _tmp4_ > 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			xmlNode* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			_tmp5_ = xmlXPathNodeSetItem (xpo->nodesetval, 0);
			_tmp6_ = xmlNodeGetContent (_tmp5_);
			_tmp7_ = _tmp6_;
			rygel_media_object_set_title ((RygelMediaObject*) self, _tmp7_);
			_g_free0 (_tmp7_);
		}
		_tmp8_ = xmlXPathEval ("/rss/channel/item", ctx);
		xpo = _tmp8_;
		if (xpo->type == XPATH_NODESET) {
			{
				gint i;
				i = 0;
				{
					gboolean _tmp9_;
					_tmp9_ = TRUE;
					while (TRUE) {
						gint _tmp10_;
						xmlNode* _tmp11_ = NULL;
						xmlNode* node;
						RygelMediathekVideoItem* _tmp12_ = NULL;
						RygelMediathekVideoItem* item;
						if (!_tmp9_) {
							i++;
						}
						_tmp9_ = FALSE;
						_tmp10_ = xmlXPathNodeSetGetLength (xpo->nodesetval);
						if (!(i < _tmp10_)) {
							break;
						}
						_tmp11_ = xmlXPathNodeSetItem (xpo->nodesetval, i);
						node = _tmp11_;
						_tmp12_ = rygel_mediathek_video_item_create_from_xml ((RygelMediaContainer*) self, node, &_inner_error_);
						item = _tmp12_;
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
								goto __catch3_rygel_mediathek_video_item_error;
							}
							_xmlXPathFreeContext0 (ctx);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
						rygel_simple_container_add_child ((RygelSimpleContainer*) self, (RygelMediaObject*) item);
						ret = TRUE;
						_g_object_unref0 (item);
						goto __finally3;
						__catch3_rygel_mediathek_video_item_error:
						{
							GError * _error_;
							_error_ = _inner_error_;
							_inner_error_ = NULL;
							g_warning ("rygel-mediathek-rss-container.vala:77: Error creating video item: %s", _error_->message);
							_g_error_free0 (_error_);
						}
						__finally3:
						if (_inner_error_ != NULL) {
							_xmlXPathFreeContext0 (ctx);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
				}
			}
		} else {
			g_warning ("rygel-mediathek-rss-container.vala:83: XPath query failed");
		}
		xmlFreeDoc (doc);
		rygel_media_container_updated ((RygelMediaContainer*) self);
		_xmlXPathFreeContext0 (ctx);
	} else {
		g_warning ("rygel-mediathek-rss-container.vala:90: Failed to parse doc");
	}
	result = ret;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _rygel_mediathek_rss_container_on_feed_got_soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	rygel_mediathek_rss_container_on_feed_got (self, session, msg);
}


void rygel_mediathek_rss_container_update (RygelMediathekRssContainer* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	SoupMessage* _tmp2_ = NULL;
	SoupMessage* _tmp3_;
	SoupMessage* message;
	SoupMessage* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup_printf ("http://www.zdf.de/ZDFmediathek/content/%u?view=rss", self->priv->zdf_content_id);
	_tmp1_ = _tmp0_;
	_tmp2_ = soup_message_new ("GET", _tmp1_);
	message = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	if (self->priv->last_modified != NULL) {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp4_ = soup_date_to_string (self->priv->last_modified, SOUP_DATE_HTTP);
		g_debug ("rygel-mediathek-rss-container.vala:101: Requesting change since %s", _tmp4_);
		_tmp5_ = soup_date_to_string (self->priv->last_modified, SOUP_DATE_HTTP);
		soup_message_headers_append (message->request_headers, "If-Modified-Since", _tmp5_);
	}
	_tmp6_ = _g_object_ref0 (message);
	soup_session_queue_message ((SoupSession*) RYGEL_MEDIATHEK_ROOT_CONTAINER (((RygelMediaObject*) self)->parent)->session, _tmp6_, _rygel_mediathek_rss_container_on_feed_got_soup_session_callback, self);
	_g_object_unref0 (message);
}


RygelMediathekRssContainer* rygel_mediathek_rss_container_construct (GType object_type, RygelMediaContainer* parent, guint id) {
	RygelMediathekRssContainer * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = g_strdup_printf ("GroupId:%u", id);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("ZDF Mediathek RSS feed %u", id);
	_tmp3_ = _tmp2_;
	self = (RygelMediathekRssContainer*) rygel_simple_container_construct (object_type, _tmp1_, parent, _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	self->priv->zdf_content_id = id;
	rygel_mediathek_rss_container_update (self);
	return self;
}


RygelMediathekRssContainer* rygel_mediathek_rss_container_new (RygelMediaContainer* parent, guint id) {
	return rygel_mediathek_rss_container_construct (RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER, parent, id);
}


static void rygel_mediathek_rss_container_class_init (RygelMediathekRssContainerClass * klass) {
	rygel_mediathek_rss_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediathekRssContainerPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_mediathek_rss_container_finalize;
}


static void rygel_mediathek_rss_container_instance_init (RygelMediathekRssContainer * self) {
	self->priv = RYGEL_MEDIATHEK_RSS_CONTAINER_GET_PRIVATE (self);
	self->priv->last_modified = NULL;
}


static void rygel_mediathek_rss_container_finalize (GObject* obj) {
	RygelMediathekRssContainer * self;
	self = RYGEL_MEDIATHEK_RSS_CONTAINER (obj);
	_soup_date_free0 (self->priv->last_modified);
	G_OBJECT_CLASS (rygel_mediathek_rss_container_parent_class)->finalize (obj);
}


GType rygel_mediathek_rss_container_get_type (void) {
	static volatile gsize rygel_mediathek_rss_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mediathek_rss_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediathekRssContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mediathek_rss_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediathekRssContainer), 0, (GInstanceInitFunc) rygel_mediathek_rss_container_instance_init, NULL };
		GType rygel_mediathek_rss_container_type_id;
		rygel_mediathek_rss_container_type_id = g_type_register_static (RYGEL_TYPE_SIMPLE_CONTAINER, "RygelMediathekRssContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_mediathek_rss_container_type_id__volatile, rygel_mediathek_rss_container_type_id);
	}
	return rygel_mediathek_rss_container_type_id__volatile;
}



