/* rygel-search-criteria-parser.c generated by valac 0.11.2, the Vala compiler
 * generated from rygel-search-criteria-parser.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define RYGEL_TYPE_SEARCH_CRITERIA_SYMBOL (rygel_search_criteria_symbol_get_type ())

#define RYGEL_TYPE_SEARCH_CRITERIA_TOKEN (rygel_search_criteria_token_get_type ())
typedef struct _RygelSearchCriteriaToken RygelSearchCriteriaToken;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_SEARCH_CRITERIA_PARSER (rygel_search_criteria_parser_get_type ())
#define RYGEL_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParser))
#define RYGEL_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_SEARCH_CRITERIA_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))

typedef struct _RygelSearchCriteriaParser RygelSearchCriteriaParser;
typedef struct _RygelSearchCriteriaParserClass RygelSearchCriteriaParserClass;
typedef struct _RygelSearchCriteriaParserPrivate RygelSearchCriteriaParserPrivate;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_scanner_destroy0(var) ((var == NULL) ? NULL : (var = (g_scanner_destroy (var), NULL)))
typedef struct _RygelSearchCriteriaParserRunData RygelSearchCriteriaParserRunData;

#define RYGEL_TYPE_LOGICAL_EXPRESSION (rygel_logical_expression_get_type ())
#define RYGEL_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpression))
#define RYGEL_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))
#define RYGEL_IS_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_IS_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_LOGICAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))

typedef struct _RygelLogicalExpression RygelLogicalExpression;
typedef struct _RygelLogicalExpressionClass RygelLogicalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_LOGICAL_OPERATOR (rygel_logical_operator_get_type ())

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;

typedef enum  {
	RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR
} RygelSearchCriteriaError;
#define RYGEL_SEARCH_CRITERIA_ERROR rygel_search_criteria_error_quark ()
typedef enum  {
	RYGEL_SEARCH_CRITERIA_SYMBOL_EQ = GUPNP_SEARCH_CRITERIA_OP_EQ,
	RYGEL_SEARCH_CRITERIA_SYMBOL_NEQ,
	RYGEL_SEARCH_CRITERIA_SYMBOL_LESS,
	RYGEL_SEARCH_CRITERIA_SYMBOL_LEQ,
	RYGEL_SEARCH_CRITERIA_SYMBOL_GREATER,
	RYGEL_SEARCH_CRITERIA_SYMBOL_GEQ,
	RYGEL_SEARCH_CRITERIA_SYMBOL_CONTAINS,
	RYGEL_SEARCH_CRITERIA_SYMBOL_DOES_NOT_CONTAIN,
	RYGEL_SEARCH_CRITERIA_SYMBOL_DERIVED_FROM,
	RYGEL_SEARCH_CRITERIA_SYMBOL_EXISTS,
	RYGEL_SEARCH_CRITERIA_SYMBOL_ASTERISK,
	RYGEL_SEARCH_CRITERIA_SYMBOL_AND,
	RYGEL_SEARCH_CRITERIA_SYMBOL_OR,
	RYGEL_SEARCH_CRITERIA_SYMBOL_TRUE,
	RYGEL_SEARCH_CRITERIA_SYMBOL_FALSE
} RygelSearchCriteriaSymbol;

struct _RygelSearchCriteriaToken {
	gchar* str_symbol;
	RygelSearchCriteriaSymbol symbol;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelSearchCriteriaParser {
	GObject parent_instance;
	RygelSearchCriteriaParserPrivate * priv;
	gchar* str;
	RygelSearchExpression* expression;
	GError* err;
};

struct _RygelSearchCriteriaParserClass {
	GObjectClass parent_class;
};

struct _RygelSearchCriteriaParserPrivate {
	GCancellable* _cancellable;
	GScanner* scanner;
};

struct _RygelSearchCriteriaParserRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchCriteriaParser* self;
	glong _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	RygelSearchExpression* _tmp3_;
	GError * err;
	GError* _tmp4_;
	GError* _tmp5_;
	GError * _inner_error_;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

typedef enum  {
	RYGEL_LOGICAL_OPERATOR_AND,
	RYGEL_LOGICAL_OPERATOR_OR
} RygelLogicalOperator;


static gpointer rygel_search_criteria_parser_parent_class = NULL;
static RygelStateMachineIface* rygel_search_criteria_parser_rygel_state_machine_parent_iface = NULL;

GQuark rygel_search_criteria_error_quark (void);
GType rygel_search_criteria_symbol_get_type (void) G_GNUC_CONST;
GType rygel_search_criteria_token_get_type (void) G_GNUC_CONST;
RygelSearchCriteriaToken* rygel_search_criteria_token_dup (const RygelSearchCriteriaToken* self);
void rygel_search_criteria_token_free (RygelSearchCriteriaToken* self);
void rygel_search_criteria_token_copy (const RygelSearchCriteriaToken* self, RygelSearchCriteriaToken* dest);
void rygel_search_criteria_token_destroy (RygelSearchCriteriaToken* self);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_search_criteria_parser_get_type (void) G_GNUC_CONST;
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
#define RYGEL_SEARCH_CRITERIA_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserPrivate))
enum  {
	RYGEL_SEARCH_CRITERIA_PARSER_DUMMY_PROPERTY,
	RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE
};
RygelSearchCriteriaParser* rygel_search_criteria_parser_new (const gchar* str, GError** error);
RygelSearchCriteriaParser* rygel_search_criteria_parser_construct (GType object_type, const gchar* str, GError** error);
static void rygel_search_criteria_parser_real_run_data_free (gpointer _data);
static void rygel_search_criteria_parser_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_search_criteria_parser_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_search_criteria_parser_real_run_co (RygelSearchCriteriaParserRunData* data);
static RygelSearchExpression* rygel_search_criteria_parser_parse_or_expression (RygelSearchCriteriaParser* self, GError** error);
static RygelSearchExpression* rygel_search_criteria_parser_parse_and_expression (RygelSearchCriteriaParser* self, GError** error);
static RygelSearchExpression* rygel_search_criteria_parser_parse_rel_expression (RygelSearchCriteriaParser* self, GError** error);
static RygelSearchCriteriaSymbol rygel_search_criteria_parser_get_token (RygelSearchCriteriaParser* self);
RygelLogicalExpression* rygel_logical_expression_new (void);
RygelLogicalExpression* rygel_logical_expression_construct (GType object_type);
GType rygel_logical_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_logical_operator_get_type (void) G_GNUC_CONST;
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
static gchar* rygel_search_criteria_parser_get_context (RygelSearchCriteriaParser* self);
static void rygel_search_criteria_parser_finalize (GObject* obj);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void _vala_rygel_search_criteria_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void _vala_rygel_search_criteria_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const RygelSearchCriteriaToken RYGEL_SEARCH_CRITERIA_PARSER_tokens[15] = {{"=", RYGEL_SEARCH_CRITERIA_SYMBOL_EQ}, {"!=", RYGEL_SEARCH_CRITERIA_SYMBOL_NEQ}, {"<", RYGEL_SEARCH_CRITERIA_SYMBOL_LESS}, {"<=", RYGEL_SEARCH_CRITERIA_SYMBOL_LEQ}, {">", RYGEL_SEARCH_CRITERIA_SYMBOL_GREATER}, {">=", RYGEL_SEARCH_CRITERIA_SYMBOL_GEQ}, {"contains", RYGEL_SEARCH_CRITERIA_SYMBOL_CONTAINS}, {"doesNotContain", RYGEL_SEARCH_CRITERIA_SYMBOL_DOES_NOT_CONTAIN}, {"derivedfrom", RYGEL_SEARCH_CRITERIA_SYMBOL_DERIVED_FROM}, {"exists", RYGEL_SEARCH_CRITERIA_SYMBOL_EXISTS}, {"*", RYGEL_SEARCH_CRITERIA_SYMBOL_ASTERISK}, {"and", RYGEL_SEARCH_CRITERIA_SYMBOL_AND}, {"or", RYGEL_SEARCH_CRITERIA_SYMBOL_OR}, {"true", RYGEL_SEARCH_CRITERIA_SYMBOL_TRUE}, {"false", RYGEL_SEARCH_CRITERIA_SYMBOL_FALSE}};

GQuark rygel_search_criteria_error_quark (void) {
	return g_quark_from_static_string ("rygel_search_criteria_error-quark");
}


GType rygel_search_criteria_symbol_get_type (void) {
	static volatile gsize rygel_search_criteria_symbol_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_search_criteria_symbol_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_SEARCH_CRITERIA_SYMBOL_EQ, "RYGEL_SEARCH_CRITERIA_SYMBOL_EQ", "eq"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_NEQ, "RYGEL_SEARCH_CRITERIA_SYMBOL_NEQ", "neq"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_LESS, "RYGEL_SEARCH_CRITERIA_SYMBOL_LESS", "less"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_LEQ, "RYGEL_SEARCH_CRITERIA_SYMBOL_LEQ", "leq"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_GREATER, "RYGEL_SEARCH_CRITERIA_SYMBOL_GREATER", "greater"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_GEQ, "RYGEL_SEARCH_CRITERIA_SYMBOL_GEQ", "geq"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_CONTAINS, "RYGEL_SEARCH_CRITERIA_SYMBOL_CONTAINS", "contains"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_DOES_NOT_CONTAIN, "RYGEL_SEARCH_CRITERIA_SYMBOL_DOES_NOT_CONTAIN", "does-not-contain"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_DERIVED_FROM, "RYGEL_SEARCH_CRITERIA_SYMBOL_DERIVED_FROM", "derived-from"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_EXISTS, "RYGEL_SEARCH_CRITERIA_SYMBOL_EXISTS", "exists"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_ASTERISK, "RYGEL_SEARCH_CRITERIA_SYMBOL_ASTERISK", "asterisk"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_AND, "RYGEL_SEARCH_CRITERIA_SYMBOL_AND", "and"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_OR, "RYGEL_SEARCH_CRITERIA_SYMBOL_OR", "or"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_TRUE, "RYGEL_SEARCH_CRITERIA_SYMBOL_TRUE", "true"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_FALSE, "RYGEL_SEARCH_CRITERIA_SYMBOL_FALSE", "false"}, {0, NULL, NULL}};
		GType rygel_search_criteria_symbol_type_id;
		rygel_search_criteria_symbol_type_id = g_enum_register_static ("RygelSearchCriteriaSymbol", values);
		g_once_init_leave (&rygel_search_criteria_symbol_type_id__volatile, rygel_search_criteria_symbol_type_id);
	}
	return rygel_search_criteria_symbol_type_id__volatile;
}


void rygel_search_criteria_token_copy (const RygelSearchCriteriaToken* self, RygelSearchCriteriaToken* dest) {
	dest->str_symbol = g_strdup (self->str_symbol);
	dest->symbol = self->symbol;
}


void rygel_search_criteria_token_destroy (RygelSearchCriteriaToken* self) {
	_g_free0 (self->str_symbol);
}


RygelSearchCriteriaToken* rygel_search_criteria_token_dup (const RygelSearchCriteriaToken* self) {
	RygelSearchCriteriaToken* dup;
	dup = g_new0 (RygelSearchCriteriaToken, 1);
	rygel_search_criteria_token_copy (self, dup);
	return dup;
}


void rygel_search_criteria_token_free (RygelSearchCriteriaToken* self) {
	rygel_search_criteria_token_destroy (self);
	g_free (self);
}


GType rygel_search_criteria_token_get_type (void) {
	static volatile gsize rygel_search_criteria_token_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_search_criteria_token_type_id__volatile)) {
		GType rygel_search_criteria_token_type_id;
		rygel_search_criteria_token_type_id = g_boxed_type_register_static ("RygelSearchCriteriaToken", (GBoxedCopyFunc) rygel_search_criteria_token_dup, (GBoxedFreeFunc) rygel_search_criteria_token_free);
		g_once_init_leave (&rygel_search_criteria_token_type_id__volatile, rygel_search_criteria_token_type_id);
	}
	return rygel_search_criteria_token_type_id__volatile;
}


RygelSearchCriteriaParser* rygel_search_criteria_parser_construct (GType object_type, const gchar* str, GError** error) {
	RygelSearchCriteriaParser * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GScanner* _tmp2_ = NULL;
	GScanner* _tmp3_;
	g_return_val_if_fail (str != NULL, NULL);
	self = (RygelSearchCriteriaParser*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (str);
	_tmp1_ = _tmp0_;
	_g_free0 (self->str);
	self->str = _tmp1_;
	_tmp2_ = g_scanner_new (NULL);
	_tmp3_ = _tmp2_;
	_g_scanner_destroy0 (self->priv->scanner);
	self->priv->scanner = _tmp3_;
	(*self->priv->scanner->config).cset_skip_characters = " \t\n\r\012" "\013\014\015";
	(*self->priv->scanner->config).scan_identifier_1char = TRUE;
	(*self->priv->scanner->config).cset_identifier_first = G_CSET_a_2_z "_*<>=!@" G_CSET_A_2_Z;
	(*self->priv->scanner->config).cset_identifier_nth = G_CSET_a_2_z "_" G_CSET_DIGITS "=:@" G_CSET_A_2_Z G_CSET_LATINS G_CSET_LATINC;
	(*self->priv->scanner->config).symbol_2_token = TRUE;
	{
		RygelSearchCriteriaToken* token_collection;
		int token_collection_length1;
		int token_it;
		token_collection = RYGEL_SEARCH_CRITERIA_PARSER_tokens;
		token_collection_length1 = G_N_ELEMENTS (RYGEL_SEARCH_CRITERIA_PARSER_tokens);
		for (token_it = 0; token_it < G_N_ELEMENTS (RYGEL_SEARCH_CRITERIA_PARSER_tokens); token_it = token_it + 1) {
			RygelSearchCriteriaToken token;
			token = token_collection[token_it];
			{
				void* _tmp4_ = NULL;
				_tmp4_ = GINT_TO_POINTER ((gint) token.symbol);
				g_scanner_scope_add_symbol (self->priv->scanner, (guint) 0, token.str_symbol, _tmp4_);
			}
		}
	}
	return self;
}


RygelSearchCriteriaParser* rygel_search_criteria_parser_new (const gchar* str, GError** error) {
	return rygel_search_criteria_parser_construct (RYGEL_TYPE_SEARCH_CRITERIA_PARSER, str, error);
}


static void rygel_search_criteria_parser_real_run_data_free (gpointer _data) {
	RygelSearchCriteriaParserRunData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelSearchCriteriaParserRunData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_search_criteria_parser_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchCriteriaParser * self;
	RygelSearchCriteriaParserRunData* _data_;
	self = (RygelSearchCriteriaParser*) base;
	_data_ = g_slice_new0 (RygelSearchCriteriaParserRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_search_criteria_parser_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_search_criteria_parser_real_run_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_search_criteria_parser_real_run_co (_data_);
}


static void rygel_search_criteria_parser_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelSearchCriteriaParserRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_search_criteria_parser_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchCriteriaParserRunData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_search_criteria_parser_real_run_co (data);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean rygel_search_criteria_parser_real_run_co (RygelSearchCriteriaParserRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (g_strcmp0 (data->self->str, "*") == 0) {
		g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp0_ = strlen (data->self->str);
	g_scanner_input_text (data->self->priv->scanner, data->self->str, (guint) data->_tmp0_);
	g_scanner_get_next_token (data->self->priv->scanner);
	data->_tmp1_ = NULL;
	data->_tmp1_ = rygel_search_criteria_parser_parse_or_expression (data->self, &data->_inner_error_);
	data->_tmp2_ = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		goto __catch62_g_error;
	}
	data->_tmp3_ = data->_tmp2_;
	_rygel_search_expression_unref0 (data->self->expression);
	data->self->expression = data->_tmp3_;
	goto __finally62;
	__catch62_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp4_ = _g_error_copy0 (data->err);
		data->_tmp5_ = data->_tmp4_;
		_g_error_free0 (data->self->err);
		data->self->err = data->_tmp5_;
		_g_error_free0 (data->err);
	}
	__finally62:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static RygelSearchExpression* rygel_search_criteria_parser_parse_and_expression (RygelSearchCriteriaParser* self, GError** error) {
	RygelSearchExpression* result = NULL;
	RygelSearchExpression* _tmp0_ = NULL;
	RygelSearchExpression* exp;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_search_criteria_parser_parse_rel_expression (self, &_inner_error_);
	exp = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	while (TRUE) {
		RygelSearchCriteriaSymbol _tmp1_;
		RygelLogicalExpression* _tmp2_ = NULL;
		RygelLogicalExpression* exp2;
		RygelSearchExpression* _tmp3_;
		RygelSearchExpression* _tmp4_;
		RygelSearchExpression* _tmp5_ = NULL;
		RygelSearchExpression* _tmp6_;
		RygelSearchExpression* _tmp7_;
		RygelSearchExpression* _tmp8_;
		RygelSearchExpression* _tmp9_;
		_tmp1_ = rygel_search_criteria_parser_get_token (self);
		if (!(_tmp1_ == RYGEL_SEARCH_CRITERIA_SYMBOL_AND)) {
			break;
		}
		g_scanner_get_next_token (self->priv->scanner);
		_tmp2_ = rygel_logical_expression_new ();
		exp2 = _tmp2_;
		_tmp3_ = _rygel_search_expression_ref0 (exp);
		_tmp4_ = _tmp3_;
		_rygel_search_expression_unref0 (((RygelSearchExpression*) exp2)->operand1);
		((RygelSearchExpression*) exp2)->operand1 = _tmp4_;
		((RygelSearchExpression*) exp2)->op = GINT_TO_POINTER (RYGEL_LOGICAL_OPERATOR_AND);
		_tmp5_ = rygel_search_criteria_parser_parse_rel_expression (self, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_rygel_search_expression_unref0 (exp2);
			_rygel_search_expression_unref0 (exp);
			return NULL;
		}
		_tmp7_ = _tmp6_;
		_rygel_search_expression_unref0 (((RygelSearchExpression*) exp2)->operand2);
		((RygelSearchExpression*) exp2)->operand2 = _tmp7_;
		_tmp8_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) exp2);
		_tmp9_ = _tmp8_;
		_rygel_search_expression_unref0 (exp);
		exp = _tmp9_;
		_rygel_search_expression_unref0 (exp2);
	}
	result = exp;
	return result;
}


static RygelSearchExpression* rygel_search_criteria_parser_parse_rel_expression (RygelSearchCriteriaParser* self, GError** error) {
	RygelSearchExpression* result = NULL;
	RygelRelationalExpression* _tmp0_ = NULL;
	RygelRelationalExpression* exp;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_relational_expression_new ();
	exp = _tmp0_;
	if (self->priv->scanner->token == G_TOKEN_IDENTIFIER) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		RygelSearchCriteriaSymbol _tmp11_;
		_tmp1_ = g_strdup (self->priv->scanner->value.v_identifier);
		_tmp2_ = _tmp1_;
		_g_free0 (((RygelSearchExpression*) exp)->operand1);
		((RygelSearchExpression*) exp)->operand1 = _tmp2_;
		g_scanner_get_next_token (self->priv->scanner);
		_tmp11_ = rygel_search_criteria_parser_get_token (self);
		if (_tmp11_ == RYGEL_SEARCH_CRITERIA_SYMBOL_EQ) {
			_tmp10_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp12_;
			_tmp12_ = rygel_search_criteria_parser_get_token (self);
			_tmp10_ = _tmp12_ == RYGEL_SEARCH_CRITERIA_SYMBOL_NEQ;
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp13_;
			_tmp13_ = rygel_search_criteria_parser_get_token (self);
			_tmp9_ = _tmp13_ == RYGEL_SEARCH_CRITERIA_SYMBOL_LESS;
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp14_;
			_tmp14_ = rygel_search_criteria_parser_get_token (self);
			_tmp8_ = _tmp14_ == RYGEL_SEARCH_CRITERIA_SYMBOL_LEQ;
		}
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp15_;
			_tmp15_ = rygel_search_criteria_parser_get_token (self);
			_tmp7_ = _tmp15_ == RYGEL_SEARCH_CRITERIA_SYMBOL_GREATER;
		}
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp16_;
			_tmp16_ = rygel_search_criteria_parser_get_token (self);
			_tmp6_ = _tmp16_ == RYGEL_SEARCH_CRITERIA_SYMBOL_GEQ;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp17_;
			_tmp17_ = rygel_search_criteria_parser_get_token (self);
			_tmp5_ = _tmp17_ == RYGEL_SEARCH_CRITERIA_SYMBOL_CONTAINS;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp18_;
			_tmp18_ = rygel_search_criteria_parser_get_token (self);
			_tmp4_ = _tmp18_ == RYGEL_SEARCH_CRITERIA_SYMBOL_DOES_NOT_CONTAIN;
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			RygelSearchCriteriaSymbol _tmp19_;
			_tmp19_ = rygel_search_criteria_parser_get_token (self);
			_tmp3_ = _tmp19_ == RYGEL_SEARCH_CRITERIA_SYMBOL_DERIVED_FROM;
		}
		if (_tmp3_) {
			((RygelSearchExpression*) exp)->op = GINT_TO_POINTER ((GUPnPSearchCriteriaOp) self->priv->scanner->token);
			g_scanner_get_next_token (self->priv->scanner);
			if (self->priv->scanner->token == G_TOKEN_STRING) {
				gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp20_ = g_strdup (self->priv->scanner->value.v_string);
				_tmp21_ = _tmp20_;
				_g_free0 (((RygelSearchExpression*) exp)->operand2);
				((RygelSearchExpression*) exp)->operand2 = _tmp21_;
				g_scanner_get_next_token (self->priv->scanner);
				result = (RygelSearchExpression*) exp;
				return result;
			} else {
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				GError* _tmp26_ = NULL;
				GError* _tmp27_;
				_tmp22_ = rygel_search_criteria_parser_get_context (self);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strconcat (_tmp23_, ": expected ", NULL);
				_tmp25_ = g_strconcat (_tmp24_, "\"STRING\"", NULL);
				_tmp26_ = g_error_new_literal (RYGEL_SEARCH_CRITERIA_ERROR, RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, _tmp25_);
				_inner_error_ = (_tmp27_ = _tmp26_, _g_free0 (_tmp25_), _g_free0 (_tmp24_), _g_free0 (_tmp23_), _tmp27_);
				g_propagate_error (error, _inner_error_);
				_rygel_search_expression_unref0 (exp);
				return NULL;
			}
		} else {
			RygelSearchCriteriaSymbol _tmp28_;
			_tmp28_ = rygel_search_criteria_parser_get_token (self);
			if (_tmp28_ == RYGEL_SEARCH_CRITERIA_SYMBOL_EXISTS) {
				RygelSearchCriteriaSymbol _tmp29_;
				((RygelSearchExpression*) exp)->op = GINT_TO_POINTER ((GUPnPSearchCriteriaOp) self->priv->scanner->token);
				g_scanner_get_next_token (self->priv->scanner);
				_tmp29_ = rygel_search_criteria_parser_get_token (self);
				if (_tmp29_ == RYGEL_SEARCH_CRITERIA_SYMBOL_TRUE) {
					gchar* _tmp30_;
					gchar* _tmp31_;
					_tmp30_ = g_strdup ("true");
					_tmp31_ = _tmp30_;
					_g_free0 (((RygelSearchExpression*) exp)->operand2);
					((RygelSearchExpression*) exp)->operand2 = _tmp31_;
					g_scanner_get_next_token (self->priv->scanner);
					result = (RygelSearchExpression*) exp;
					return result;
				} else {
					RygelSearchCriteriaSymbol _tmp32_;
					_tmp32_ = rygel_search_criteria_parser_get_token (self);
					if (_tmp32_ == RYGEL_SEARCH_CRITERIA_SYMBOL_FALSE) {
						gchar* _tmp33_;
						gchar* _tmp34_;
						_tmp33_ = g_strdup ("false");
						_tmp34_ = _tmp33_;
						_g_free0 (((RygelSearchExpression*) exp)->operand2);
						((RygelSearchExpression*) exp)->operand2 = _tmp34_;
						g_scanner_get_next_token (self->priv->scanner);
						result = (RygelSearchExpression*) exp;
						return result;
					} else {
						gchar* _tmp35_ = NULL;
						gchar* _tmp36_;
						gchar* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						GError* _tmp40_ = NULL;
						GError* _tmp41_;
						_tmp35_ = rygel_search_criteria_parser_get_context (self);
						_tmp36_ = _tmp35_;
						_tmp37_ = g_strconcat (_tmp36_, ": expected ", NULL);
						_tmp38_ = g_strconcat (_tmp37_, "\"true\"|\"", NULL);
						_tmp39_ = g_strconcat (_tmp38_, "false\"", NULL);
						_tmp40_ = g_error_new_literal (RYGEL_SEARCH_CRITERIA_ERROR, RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, _tmp39_);
						_inner_error_ = (_tmp41_ = _tmp40_, _g_free0 (_tmp39_), _g_free0 (_tmp38_), _g_free0 (_tmp37_), _g_free0 (_tmp36_), _tmp41_);
						g_propagate_error (error, _inner_error_);
						_rygel_search_expression_unref0 (exp);
						return NULL;
					}
				}
			} else {
				gchar* _tmp42_ = NULL;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				GError* _tmp46_ = NULL;
				GError* _tmp47_;
				_tmp42_ = rygel_search_criteria_parser_get_context (self);
				_tmp43_ = _tmp42_;
				_tmp44_ = g_strconcat (_tmp43_, ": expected ", NULL);
				_tmp45_ = g_strconcat (_tmp44_, "operator", NULL);
				_tmp46_ = g_error_new_literal (RYGEL_SEARCH_CRITERIA_ERROR, RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, _tmp45_);
				_inner_error_ = (_tmp47_ = _tmp46_, _g_free0 (_tmp45_), _g_free0 (_tmp44_), _g_free0 (_tmp43_), _tmp47_);
				g_propagate_error (error, _inner_error_);
				_rygel_search_expression_unref0 (exp);
				return NULL;
			}
		}
	} else {
		if (self->priv->scanner->token == G_TOKEN_LEFT_PAREN) {
			RygelSearchExpression* _tmp48_ = NULL;
			RygelSearchExpression* exp2;
			g_scanner_get_next_token (self->priv->scanner);
			_tmp48_ = rygel_search_criteria_parser_parse_or_expression (self, &_inner_error_);
			exp2 = _tmp48_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_rygel_search_expression_unref0 (exp);
				return NULL;
			}
			if (self->priv->scanner->token != G_TOKEN_RIGHT_PAREN) {
				gchar* _tmp49_ = NULL;
				gchar* _tmp50_;
				gchar* _tmp51_;
				GError* _tmp52_ = NULL;
				GError* _tmp53_;
				_tmp49_ = rygel_search_criteria_parser_get_context (self);
				_tmp50_ = _tmp49_;
				_tmp51_ = g_strconcat (_tmp50_, ": expected ')'", NULL);
				_tmp52_ = g_error_new_literal (RYGEL_SEARCH_CRITERIA_ERROR, RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, _tmp51_);
				_inner_error_ = (_tmp53_ = _tmp52_, _g_free0 (_tmp51_), _g_free0 (_tmp50_), _tmp53_);
				g_propagate_error (error, _inner_error_);
				_rygel_search_expression_unref0 (exp2);
				_rygel_search_expression_unref0 (exp);
				return NULL;
			} else {
				g_scanner_get_next_token (self->priv->scanner);
				result = exp2;
				_rygel_search_expression_unref0 (exp);
				return result;
			}
			_rygel_search_expression_unref0 (exp2);
		} else {
			gchar* _tmp54_ = NULL;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			GError* _tmp58_ = NULL;
			GError* _tmp59_;
			_tmp54_ = rygel_search_criteria_parser_get_context (self);
			_tmp55_ = _tmp54_;
			_tmp56_ = g_strconcat (_tmp55_, ": expected ", NULL);
			_tmp57_ = g_strconcat (_tmp56_, "identifier or '('", NULL);
			_tmp58_ = g_error_new_literal (RYGEL_SEARCH_CRITERIA_ERROR, RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, _tmp57_);
			_inner_error_ = (_tmp59_ = _tmp58_, _g_free0 (_tmp57_), _g_free0 (_tmp56_), _g_free0 (_tmp55_), _tmp59_);
			g_propagate_error (error, _inner_error_);
			_rygel_search_expression_unref0 (exp);
			return NULL;
		}
	}
	_rygel_search_expression_unref0 (exp);
}


static RygelSearchExpression* rygel_search_criteria_parser_parse_or_expression (RygelSearchCriteriaParser* self, GError** error) {
	RygelSearchExpression* result = NULL;
	RygelSearchExpression* _tmp0_ = NULL;
	RygelSearchExpression* exp;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_search_criteria_parser_parse_and_expression (self, &_inner_error_);
	exp = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	while (TRUE) {
		RygelSearchCriteriaSymbol _tmp1_;
		RygelLogicalExpression* _tmp2_ = NULL;
		RygelLogicalExpression* exp2;
		RygelSearchExpression* _tmp3_;
		RygelSearchExpression* _tmp4_;
		RygelSearchExpression* _tmp5_ = NULL;
		RygelSearchExpression* _tmp6_;
		RygelSearchExpression* _tmp7_;
		RygelSearchExpression* _tmp8_;
		RygelSearchExpression* _tmp9_;
		_tmp1_ = rygel_search_criteria_parser_get_token (self);
		if (!(_tmp1_ == RYGEL_SEARCH_CRITERIA_SYMBOL_OR)) {
			break;
		}
		g_scanner_get_next_token (self->priv->scanner);
		_tmp2_ = rygel_logical_expression_new ();
		exp2 = _tmp2_;
		_tmp3_ = _rygel_search_expression_ref0 (exp);
		_tmp4_ = _tmp3_;
		_rygel_search_expression_unref0 (((RygelSearchExpression*) exp2)->operand1);
		((RygelSearchExpression*) exp2)->operand1 = _tmp4_;
		((RygelSearchExpression*) exp2)->op = GINT_TO_POINTER (RYGEL_LOGICAL_OPERATOR_OR);
		_tmp5_ = rygel_search_criteria_parser_parse_and_expression (self, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_rygel_search_expression_unref0 (exp2);
			_rygel_search_expression_unref0 (exp);
			return NULL;
		}
		_tmp7_ = _tmp6_;
		_rygel_search_expression_unref0 (((RygelSearchExpression*) exp2)->operand2);
		((RygelSearchExpression*) exp2)->operand2 = _tmp7_;
		_tmp8_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) exp2);
		_tmp9_ = _tmp8_;
		_rygel_search_expression_unref0 (exp);
		exp = _tmp9_;
		_rygel_search_expression_unref0 (exp2);
	}
	result = exp;
	return result;
}


static GCancellable* rygel_search_criteria_parser_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelSearchCriteriaParser* self;
	self = (RygelSearchCriteriaParser*) base;
	result = self->priv->_cancellable;
	return result;
}


static void rygel_search_criteria_parser_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelSearchCriteriaParser* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	self = (RygelSearchCriteriaParser*) base;
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static RygelSearchCriteriaSymbol rygel_search_criteria_parser_get_token (RygelSearchCriteriaParser* self) {
	RygelSearchCriteriaSymbol result;
	g_return_val_if_fail (self != NULL, 0);
	result = (RygelSearchCriteriaSymbol) self->priv->scanner->token;
	return result;
}


static gchar* rygel_search_criteria_parser_get_context (RygelSearchCriteriaParser* self) {
	gchar* result;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%u", self->priv->scanner->line);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, ".", NULL);
	_tmp3_ = g_strdup_printf ("%u", self->priv->scanner->position);
	_tmp4_ = _tmp3_;
	result = (_tmp5_ = g_strconcat (_tmp2_, _tmp4_, NULL), _g_free0 (_tmp4_), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _tmp5_);
	return result;
}


static void rygel_search_criteria_parser_class_init (RygelSearchCriteriaParserClass * klass) {
	rygel_search_criteria_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelSearchCriteriaParserPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_search_criteria_parser_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_search_criteria_parser_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_search_criteria_parser_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE, "cancellable");
}


static void rygel_search_criteria_parser_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_search_criteria_parser_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_search_criteria_parser_real_run;
	iface->run_finish = rygel_search_criteria_parser_real_run_finish;
	iface->get_cancellable = rygel_search_criteria_parser_real_get_cancellable;
	iface->set_cancellable = rygel_search_criteria_parser_real_set_cancellable;
}


static void rygel_search_criteria_parser_instance_init (RygelSearchCriteriaParser * self) {
	self->priv = RYGEL_SEARCH_CRITERIA_PARSER_GET_PRIVATE (self);
}


static void rygel_search_criteria_parser_finalize (GObject* obj) {
	RygelSearchCriteriaParser * self;
	self = RYGEL_SEARCH_CRITERIA_PARSER (obj);
	_g_free0 (self->str);
	_rygel_search_expression_unref0 (self->expression);
	_g_error_free0 (self->err);
	_g_object_unref0 (self->priv->_cancellable);
	_g_scanner_destroy0 (self->priv->scanner);
	G_OBJECT_CLASS (rygel_search_criteria_parser_parent_class)->finalize (obj);
}


/**
 * Parses a search criteria string and creates SearchExpression as a result.
 */
GType rygel_search_criteria_parser_get_type (void) {
	static volatile gsize rygel_search_criteria_parser_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_search_criteria_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSearchCriteriaParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_search_criteria_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSearchCriteriaParser), 0, (GInstanceInitFunc) rygel_search_criteria_parser_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_search_criteria_parser_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_search_criteria_parser_type_id;
		rygel_search_criteria_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSearchCriteriaParser", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_search_criteria_parser_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_search_criteria_parser_type_id__volatile, rygel_search_criteria_parser_type_id);
	}
	return rygel_search_criteria_parser_type_id__volatile;
}


static void _vala_rygel_search_criteria_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelSearchCriteriaParser * self;
	self = RYGEL_SEARCH_CRITERIA_PARSER (object);
	switch (property_id) {
		case RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_search_criteria_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelSearchCriteriaParser * self;
	self = RYGEL_SEARCH_CRITERIA_PARSER (object);
	switch (property_id) {
		case RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



